/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.VTFormula;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckReportListHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.csl.CslReportProcessPlugin;
import kd.fi.bcm.formplugin.report.multi.ReportCacheService;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanFactory;
import kd.fi.bcm.formplugin.report.util.UnRefreshReportUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.util.TemplateExtDataAreaUtil;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ParseException;
import kd.fi.bcm.spread.model.IDimMember;

public class CheckReportListPlugin
extends AbstractBaseListPlugin
implements HyperLinkClickListener,
CreateListColumnsListener {
    private static final String PREFIX_ENT = "Prefix_Ent_";
    protected static final String BILL_LISTAP = "billlistap";
    protected static final String SPREAD_KEY = "report";
    protected static final String QFILTER = "qfilter";
    protected static final String COMMON_FILTER = "commonFilter";
    protected static final String TEMP_NUMBER = "tempNumber";
    protected static final String MODEL_ID = "modelid";
    protected static final String REPORT_PERIOD_ID = "report_period_id";
    protected static final String REPORT_PERIOD_NUMBER = "report_period_number";
    protected static final String REPORT_YEAR_ID = "report_year_id";
    protected static final String REPORT_YEAR_NUMBER = "report_year_number";
    protected static final String REPORT_ENTITY = "report_entity";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String CHK_RESULT_TYPE = "chkresulttype";
    private static final String FULL_FORMULA = "fulllformula";
    private static final String FULL_RIGHT_FORMULA = "fullrformula";
    private static final String GROUP = "group";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final List<String> chkStsForReportCSL = Arrays.asList("2", "3");
    private static final String CACHE_BILL_LIST_FILTER = "billListFilter";
    private static final String CHK_MARK_CELL = "chkMarkCell";
    protected TemplateModel template;
    protected SpreadManager spread;
    public static final String CHK_SELECTCELL = "chk_SelectCell";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
        if (billList != null) {
            billList.addCreateListColumnsListener((CreateListColumnsListener)this);
            billList.addPackageDataListener(this::packageData);
            billList.addSetFilterListener(this::setFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
        QFilter filter = this.getQFilter();
        billList.getFilterParameter().setFilter(filter);
        if (!this.isOnlyQuery()) {
            billList.getFilterParameter().getQFilters().add(new QFilter(CHK_RESULT_TYPE, "in", chkStsForReportCSL));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isOnlyQuery()) {
            ArrayList feature = new ArrayList();
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("fieldName", CHK_RESULT_TYPE);
            item.put("value", chkStsForReportCSL);
            item.put("compare", Collections.singletonList("17"));
            feature.add(item);
            this.getView().executeClientCommand("setGridFilter", new Object[]{BILL_LISTAP, feature});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListHyperLinkClickListener(this::hyperLinkClick);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = this.getQFilter();
        e.getQFilters().add(filter);
        this.getPageCache().put(CACHE_BILL_LIST_FILTER, ObjectSerialUtil.toByteSerialized((Object)e.getQFilters().toArray(new QFilter[0])));
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (arg.getFieldName().equals("note")) {
            String currentselecttab = (String)this.getView().getFormShowParameter().getCustomParam("currrentreport");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bcm_chknoteedit");
            formShowParameter.setCustomParam("id", ((BillList)arg.getSource()).getSelectedRows().get(0).getPrimaryKeyValue());
            QFilter[] filters = (QFilter[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CACHE_BILL_LIST_FILTER));
            ArrayList<QFilter> filterArr = new ArrayList<QFilter>(Arrays.asList(filters));
            filterArr.add(new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex()));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,chkformula.number,chkresulttype", (QFilter[])filterArr.toArray(new QFilter[0]), (String)"chkresulttype desc, chkformula.number");
            List ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            formShowParameter.setCustomParam("ids", (Object)SerializationUtils.toJsonString(ids));
            formShowParameter.setCustomParam("cslschemeId", (Object)LongUtil.toLong(this.getFormCustomParam("cslscheme")));
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "bcm_chknoteedit");
            formShowParameter.setCloseCallBack(cb);
            this.getView().showForm(formShowParameter);
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs e) {
        ChkCheckReportListHelper.createListColumns((BeforeCreateListColumnsArgs)e);
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
        this.getfixCellPosition(e.getKey(), e.getColId(), e.getIndex());
    }

    public void packageData(PackageDataEvent e) {
        ChkCheckReportListHelper.packageData((PackageDataEvent)e);
    }

    private void getfixCellPosition(String fkey, String colKey, int index) {
        BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
        DynamicObject dy = null;
        try {
            long selectPK = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            dy = BusinessDataServiceHelper.loadSingle((Object)selectPK, (String)"bcm_chkreport");
        }
        catch (Exception e) {
            log.error("\u52fe\u7a3d\u62a5\u544a\u70b9\u51fb\u8d85\u94fe\u63a5\u5b9a\u4f4d\u5355\u5143\u683c\u9519\u8bef\uff01", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u62a5\u544a\u5df2\u91cd\u65b0\u751f\u6210\u3002\u8bf7\u5237\u65b0\u52fe\u7a3d\u62a5\u544a\uff0c\u5e76\u91cd\u65b0\u9009\u62e9\u884c\u3002", (String)"CheckReportListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        long modelId = this.getModelId();
        String modelNum = QueryServiceHelper.queryOne((String)"bcm_model", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)}).getString(NUMBER);
        String vformula = "";
        vformula = colKey.startsWith("l") ? dy.getString(FULL_FORMULA) : dy.getString(FULL_RIGHT_FORMULA);
        try {
            if (ChkFormulaServiceHelper.isJudgeFormula((String)vformula)) {
                return;
            }
            VTFormula vtFormula = new VTFormula(vformula);
            String formula = "";
            for (IFormula iFormula : (List)vtFormula.getPair().p2) {
                if (!iFormula.getUUID().equals(fkey)) continue;
                formula = iFormula.toString();
                break;
            }
            if (ChkFormulaServiceHelper.isXdmFormula((String)formula)) {
                this.xdmFormulaJump2TemplateReport(formula, dy);
                return;
            }
            if (!formula.contains("V(\"@TMP.")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckReportListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            VTFormula.FormulaWithTempMemStr fs = vtFormula.getFormulaToMemStr(formula);
            Map sNumToMems = fs.getDimToMem_Num();
            String entityMemeberNumber = (String)sNumToMems.get(DimTypesEnum.ENTITY.getShortNumber());
            if (StringUtils.isEmpty((String)entityMemeberNumber) || entityMemeberNumber.contains("_")) {
                entityMemeberNumber = dy.getDynamicObject("org").getString(NUMBER);
                sNumToMems.put(DimTypesEnum.ENTITY.getShortNumber(), entityMemeberNumber);
            }
            QFilter qfilter = new QFilter(MODEL, "=", (Object)this.getModelId());
            qfilter.and(NUMBER, "=", (Object)entityMemeberNumber);
            DynamicObject entityMemberDy = MemberServiceHelper.getBaseMember((String)"bcm_entitymembertree", (String)"id", (QFilter)qfilter);
            long entityId = entityMemberDy.getLong("id");
            long scenarioId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.SCENARIO.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.SCENARIO.getShortNumber()))).getLong("id");
            long yearId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.YEAR.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber()))).getLong("id");
            String yearNum = (String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber());
            long periodId = 0L;
            if (((String)sNumToMems.get(DimTypesEnum.PERIOD.getShortNumber())).equals("CurrentPeriod") || ((String)sNumToMems.get(DimTypesEnum.PERIOD.getShortNumber())).equals("LastPeriod")) {
                periodId = this.getRptPeriodId();
                String periodRuntimeNum = this.getRptPeriodNumber();
                Optional oPeriod = PeriodUtils.trans2SpecificPeriod((String)modelNum, (String)periodRuntimeNum, (String)((String)sNumToMems.get(DimTypesEnum.PERIOD.getShortNumber())), (boolean)true);
                oPeriod.ifPresent(s -> sNumToMems.put(DimTypesEnum.PERIOD.getShortNumber(), s));
            } else {
                periodId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.PERIOD.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.PERIOD.getShortNumber()))).getLong("id");
            }
            if (((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber())).equals("CurrentYear") || ((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber())).equals("LastYear")) {
                yearId = this.getRptYearId();
                String yearRuntimeNum = this.getRptYearNumber();
                Optional oYear = PeriodUtils.trans2SpecificFy((String)modelNum, (String)yearRuntimeNum, (String)((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber())));
                oYear.ifPresent(s -> sNumToMems.put(DimTypesEnum.YEAR.getShortNumber(), s));
            } else {
                yearId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.YEAR.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.YEAR.getShortNumber()))).getLong("id");
            }
            long currencyId = DimensionServiceHelper.getMemberDy((String)DimTypesEnum.CURRENCY.getShortNumber(), (long)modelId, (String)((String)sNumToMems.get(DimTypesEnum.CURRENCY.getShortNumber()))).getLong("id");
            LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>(16);
            for (Map.Entry entry : sNumToMems.entrySet()) {
                linkMap.put(DimTypesEnum.getDimNumber((String)((String)entry.getKey()), (long)modelId), (String)entry.getValue());
            }
            long tempId = this.getShowTemplateId(dy, yearId, periodId, modelId, fs.getTempNum());
            if (tempId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckReportListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            ChkCheckReportListHelper.checkTemplateDistributionOrg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (long)entityId, (long)currencyId, (long)tempId);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("entity", entityId);
            map.put("scene", scenarioId);
            map.put("fyear", yearId);
            map.put("period", periodId);
            map.put("currency", currencyId);
            map.put(MODEL, this.getModelId());
            map.put("tem", tempId);
            boolean isSortByEntity = this.getView().getFormShowParameter().getCustomParam("isselectentitytab") == null ? true : (Boolean)this.getView().getFormShowParameter().getCustomParam("isselectentitytab");
            AbstractReportPostman postman = ReportPostmanFactory.getReportPostmanNoReport(isSortByEntity, map);
            this.handleFinTemplate(linkMap, postman, tempId, entityId, yearNum, periodId, scenarioId);
        }
        catch (ParseException p) {
            return;
        }
        catch (Exception ext) {
            log.error("\u52fe\u7a3d\u62a5\u544a\u70b9\u51fb\u8d85\u94fe\u63a5\u5b9a\u4f4d\u5355\u5143\u683c\u9519\u8bef\uff01", (Throwable)ext);
            throw new KDBizException(StringUtils.isEmpty((String)ext.getMessage()) ? ResManager.loadKDString((String)"\u516c\u5f0f\u5f02\u5e38\u3002", (String)"CheckReportListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ext.getMessage());
        }
    }

    private void xdmFormulaJump2TemplateReport(String vformula, DynamicObject dy) {
        try {
            CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)ChkFormulaServiceHelper.parseXdmFormula((String)vformula));
            long entityId = xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.ENTITY.getNumber()) == null ? dy.getLong("org.id") : xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.ENTITY.getNumber()).longValue();
            long scenarioId = xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.SCENARIO.getNumber()) == null ? dy.getLong("scenario.id") : xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.SCENARIO.getNumber()).longValue();
            long yearId = xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.YEAR.getNumber()) == null ? dy.getLong("year.id") : xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.YEAR.getNumber()).longValue();
            long periodId = xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.PERIOD.getNumber()) == null ? dy.getLong("period.id") : xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.PERIOD.getNumber()).longValue();
            long currencyId = xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.CURRENCY.getNumber()) == null ? dy.getLong("currency.id") : xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimTypesEnum.CURRENCY.getNumber()).longValue();
            long tempId = this.getShowTemplateId(dy, yearId, periodId, this.getModelId(), (String)xdmFormulaBuilder.getCondition("template"));
            if (tempId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u516c\u5f0f\u672a\u5173\u8054\u4efb\u4f55\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002", (String)"CheckReportListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
            linkMap.put("extendsmodel", (String)xdmFormulaBuilder.getCondition("extendsmodel"));
            linkMap.put("extendsfield", (String)xdmFormulaBuilder.getCondition("extendsfield"));
            linkMap.put(DimTypesEnum.ENTITY.getNumber(), dy.getString("org.number"));
            linkMap.put(DimTypesEnum.SCENARIO.getNumber(), MemberReader.findMemberById((String)this.getCurModelNumber(), (String)"bcm_scenemembertree", (Long)scenarioId).getNumber());
            linkMap.put(DimTypesEnum.YEAR.getNumber(), MemberReader.findMemberById((String)this.getCurModelNumber(), (String)"bcm_fymembertree", (Long)yearId).getNumber());
            linkMap.put(DimTypesEnum.PERIOD.getNumber(), MemberReader.findMemberById((String)this.getCurModelNumber(), (String)"bcm_periodmembertree", (Long)periodId).getNumber());
            linkMap.put(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findMemberById((String)this.getCurModelNumber(), (String)"bcm_currencymembertree", (Long)currencyId).getNumber());
            if (xdmFormulaBuilder.getDim(DimTypesEnum.PROCESS.getNumber()) == null) {
                linkMap.put(DimTypesEnum.PROCESS.getNumber(), dy.getString("process.number"));
            } else {
                linkMap.put(DimTypesEnum.PROCESS.getNumber(), xdmFormulaBuilder.getDim(DimTypesEnum.PROCESS.getNumber()));
            }
            this.jump2TemplateReport(entityId, scenarioId, yearId, periodId, currencyId, linkMap, tempId, dy.getLong("orgparent.id"));
        }
        catch (Exception e) {
            log.error("deSerializedBytes error!" + e);
        }
    }

    private void jump2TemplateReport(long entityId, long scenarioId, long yearId, long periodId, long currencyId, Map<String, String> linkMap, long tempId, long orgParentId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("entity", entityId);
        map.put("scene", scenarioId);
        map.put("fyear", yearId);
        map.put("period", periodId);
        map.put("currency", currencyId);
        map.put(MODEL, this.getModelId());
        map.put("tem", tempId);
        map.put("orgparent", orgParentId);
        Boolean isselectentitytab = (Boolean)this.getView().getFormShowParameter().getCustomParam("isselectentitytab");
        boolean isSortByEntity = isselectentitytab == null || isselectentitytab != false;
        AbstractReportPostman postman = ReportPostmanFactory.getReportPostmanNoReport(isSortByEntity, map);
        this.handleFinTemplate(linkMap, postman, tempId, entityId, MemberReader.findFyMemberById((String)this.getCurModelNumber(), (Long)yearId).getNumber(), periodId, scenarioId);
    }

    private long getShowTemplateId(DynamicObject dy, long fyid, long periodid, long modelid, String tempNum) {
        QFBuilder qfBuilder = new QFBuilder();
        long tempId = dy.getLong("template.id");
        if (!StringUtil.isEmptyString((String)tempNum)) {
            qfBuilder.add(NUMBER, "=", (Object)tempNum);
            qfBuilder.add(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add("templatetype", "not in", (Object)Lists.newArrayList((Object[])new String[]{TemplateTypeEnum.MSN.getType() + "", TemplateTypeEnum.OTHERWP.getType() + ""}));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qfBuilder.toArray());
            Set ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelid, (Long)fyid, (Long)periodid, ids);
            for (Map.Entry entry : id2Right.entrySet()) {
                tempId = (Long)entry.getValue();
            }
        }
        return tempId;
    }

    private long getReportId(AbstractReportPostman postman, long orgid, long temId) {
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL, "=", postman.getModelPK());
        qf.add("fyear", "=", postman.getYearPK());
        qf.add("period", "=", postman.getPeriodPK());
        qf.add("scene", "=", postman.getScenarioPK());
        qf.add("currency", "=", postman.getCurrencyPK());
        qf.add("entity", "=", (Object)orgid);
        qf.add("template", "=", (Object)temId);
        DynamicObject report = BusinessDataServiceHelper.loadSingle((String)"bcm_reportentity", (String)"id", (QFilter[])qf.toArray());
        return report == null ? 0L : report.getLong("id");
    }

    private void handleFinTemplate(Map<String, String> linkMap, AbstractReportPostman postman, Long temId, Long orgId, String yearNum, long periodId, long scenarioId) {
        if (postman.isSortByEntity()) {
            postman.addPair(temId, this.getReportId(postman, orgId, temId));
        } else {
            postman.addPair(orgId, this.getReportId(postman, orgId, temId));
        }
        String entityNum = this.getRptEntity();
        IFormView view = this.getView().getParentView();
        boolean isFromGuide = GuidePageUtils.isFromGuide(this.getView());
        IFormView parentPlugin = this.getView().getParentView().getViewNoPlugin(this.getView().getParentView().getPageId());
        parentPlugin.getPageCache().remove(CHK_SELECTCELL);
        if (!entityNum.equals(linkMap.get(DimTypesEnum.ENTITY.getNumber()))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_multireportprocess");
            formShowParameter.setParentPageId(view.getParentView().getPageId());
            formShowParameter.setParentFormId(view.getParentView().getEntityId());
            if (isFromGuide) {
                TemplateModel templateModel = TemplateServiceHelper.getTemplateModelById((Object)temId);
                formShowParameter.setCaption(templateModel.getNumber() + " " + templateModel.getName());
            } else {
                formShowParameter.setCaption(this.getOpenFormCaption(postman, yearNum, periodId, scenarioId));
            }
            formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)postman));
            formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
            formShowParameter.setCustomParam("numtomems", linkMap);
            formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            view.getParentView().showForm(formShowParameter);
            this.getView().sendFormAction(view.getParentView());
        } else {
            IFormView childFormView = this.getView().getParentView();
            if (childFormView == null) {
                return;
            }
            String parentFormId = childFormView.getFormShowParameter().getParentFormId();
            if ("bcm_unrefreshreport".equalsIgnoreCase(parentFormId) || "bcm_report_workbenchback".equalsIgnoreCase(parentFormId) || StringUtils.isEmpty((String)parentFormId) && ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM055")) {
                UnRefreshReportUtil.jumpFromCheckList(this.getView(), postman, linkMap);
                return;
            }
            childFormView.getFormShowParameter().setCustomParam("numtomems", linkMap);
            ThreadCache.put((Object)"numtomems", linkMap);
            childFormView.cacheFormShowParameter();
            childFormView.activate();
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
            AbstractReportPostman pm = postman;
            this.fixCellPosition();
            pluginProxy.getPlugIns().forEach(e -> {
                if (!(e instanceof CslReportProcessPlugin)) {
                    return;
                }
                if (IIncreaseReportTab.class.isAssignableFrom(e.getClass())) {
                    ((IIncreaseReportTab)IIncreaseReportTab.class.cast(e)).increaseReportTab(pm);
                }
                ReportCacheService cacheService = new ReportCacheService((IPageCache)this.getView().getParentView().getService(IPageCache.class));
                String curTabKey = cacheService.getReportTabInfoManager().getCurrSelectReportTabInfo().getTabKey();
                String newTabKey = pm.getTabKey(pm.getPairs().get(0));
                if (CslReportProcessPlugin.class.isAssignableFrom(e.getClass()) && this.isSelectSameTab(curTabKey, newTabKey)) {
                    ((CslReportProcessPlugin)e).selectCurAgain();
                    ((CslReportProcessPlugin)e).destory();
                } else {
                    for (ReportTabInfo tab : cacheService.getReportTabInfoManager().getTabs()) {
                        curTabKey = tab.getTabKey();
                        if (!this.isSelectSameTab(curTabKey, newTabKey)) continue;
                        Tab tabCtrl = (Tab)childFormView.getControl("reporttab");
                        tabCtrl.activeTab(tab.getTabKey());
                        break;
                    }
                }
            });
            this.getView().sendFormAction(childFormView);
        }
    }

    private boolean isSelectSameTab(String oldTabKey, String newTabKey) {
        String[] newSplit;
        String[] split = oldTabKey.split("\\|");
        return split[0].equals((newSplit = newTabKey.split("\\|"))[0]) && split[1].equals(newSplit[1]);
    }

    private void fixCellPosition() {
        Map map = this.getFormCustomParam("numtomems") == null ? (Map)ThreadCache.get((Object)"numtomems") : (Map)this.getFormCustomParam("numtomems");
        SpreadManager spreadModel = this.getSpreadModel();
        String extModelNumber = (String)map.get("extendsmodel");
        String extFieldNumber = (String)map.get("extendsfield");
        this.getEffectiveSheet().iteratorCellsByPredicateBreak(c -> {
            if (c.isMdDataDomain() && StringUtils.isEmpty((String)extFieldNumber)) {
                boolean flag = true;
                for (IDimMember dimMember : c.getMemberFromUserObject()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (((String)entry.getKey()).equals(dimMember.getDimension().getNumber()) && !((String)entry.getValue()).equals(dimMember.getNumber())) {
                            flag = false;
                            continue;
                        }
                        if (flag) continue;
                    }
                }
                if (flag) {
                    this.focusCell((Cell)c);
                    return true;
                }
                return false;
            }
            PositionInfo position = spreadModel.getInAreaPositionByRow(c.getRow(), c.getCol());
            if (position != null && position.getExtendInfo() != null && position.getExtendInfo().getExtModelNumber().equals(extModelNumber) && spreadModel.getExtHeadCol2(c.getRow(), c.getCol()).equals(extFieldNumber)) {
                this.focusCell((Cell)c);
                return true;
            }
            return false;
        });
    }

    private void focusCell(Cell c) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put(SpreadProperties.FieldInsertMethod.R.k(), c.getRow());
        params.put(SpreadProperties.FieldInsertMethod.C.k(), c.getCol());
        params.put(SpreadProperties.FieldInsertMethod.RC.k(), 1);
        params.put(SpreadProperties.FieldInsertMethod.CC.k(), 1);
        this.getView().getParentView().activate();
        SpreadClientInvoker.invokeSetSelectionsMethod((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class), SPREAD_KEY, params);
        ArrayList<Map<String, Object>> markRedPoints = new ArrayList<Map<String, Object>>(2);
        if (this.getView().getParentView().getPageCache().get(CHK_MARK_CELL) != null) {
            String[] split = this.getView().getParentView().getPageCache().get(CHK_MARK_CELL).split("@");
            markRedPoints.add(TemplateExtDataAreaUtil.packedCellMap4AllPoint(Integer.parseInt(split[0]), Integer.parseInt(split[1]), false));
        }
        markRedPoints.add(TemplateExtDataAreaUtil.packedCellMap4AllPoint(c.getRow(), c.getCol(), true));
        SpreadClientInvoker.invokeMethod((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class), "setCellTag", SPREAD_KEY, markRedPoints);
        this.getView().sendFormAction(this.getView().getParentView());
        try {
            IFormView parentPlugin = this.getView().getParentView().getViewNoPlugin(this.getView().getParentView().getPageId());
            parentPlugin.getPageCache().put(CHK_SELECTCELL, c.getRow() + "@" + c.getCol());
            parentPlugin.getPageCache().put(CHK_MARK_CELL, c.getRow() + "@" + c.getCol());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private boolean isOnlyQuery() {
        return Boolean.parseBoolean((String)this.getFormCustomParam("isonlyquery"));
    }

    @Override
    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class);
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    public SpreadManager getSpreadModel() {
        if (this.spread == null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getParentView().getService(FormViewPluginProxy.class);
            for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
                if (!ISpreadModelSupplier.class.isAssignableFrom(plugin.getClass())) continue;
                this.spread = ((ISpreadModelSupplier)ISpreadModelSupplier.class.cast(plugin)).getSpreadModel();
                break;
            }
        }
        return this.spread;
    }

    @Override
    public <T> T getFormCustomParam(String key) {
        return (T)this.getView().getParentView().getFormShowParameter().getCustomParam(key);
    }

    private String getOpenFormCaption(AbstractReportPostman pm, String yearNum, long periodid, long scenarioId) {
        DynamicObject entity = QueryServiceHelper.queryOne((String)pm.getTabSort().getEntityNumber(), (String)"name,id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getSortViewPK())});
        DynamicObjectCollection dys = new DynamicObjectCollection();
        dys.add((Object)entity);
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), scenarioId, yearNum, periodid);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)dys);
        return entity.getString("name");
    }

    private QFilter getQFilter() {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (this.getView().getFormShowParameter().getCustomParam(COMMON_FILTER) != null) {
            if (this.getView().getFormShowParameter().getCustomParam(COMMON_FILTER) instanceof JSONArray) {
                qFilter = ReportListUtil.fromJsonArrayToQFilter((JSONArray)this.getView().getFormShowParameter().getCustomParam(COMMON_FILTER));
            } else if (this.getView().getFormShowParameter().getCustomParam(COMMON_FILTER) instanceof QFilter[]) {
                for (QFilter qf : (QFilter[])this.getView().getFormShowParameter().getCustomParam(COMMON_FILTER)) {
                    qFilter.and(qf);
                }
            }
        }
        qFilter.and(new QFilter("chkformula", "!=", (Object)0));
        List settingIds = ChkCheckServiceHelper.getFormulaSettingIdsByNum((Collection)Lists.newArrayList((Object[])new String[]{(String)this.getView().getFormShowParameter().getCustomParam(TEMP_NUMBER)}), (long)this.getModelId());
        qFilter.and("chkformula", "in", (Object)settingIds);
        return qFilter;
    }

    @Override
    public long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam(MODEL_ID);
    }

    private long getRptPeriodId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam(REPORT_PERIOD_ID);
    }

    private String getRptPeriodNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(REPORT_PERIOD_NUMBER);
    }

    private long getRptYearId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam(REPORT_YEAR_ID);
    }

    private String getRptYearNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(REPORT_YEAR_NUMBER);
    }

    private String getRptEntity() {
        return (String)this.getView().getFormShowParameter().getCustomParam(REPORT_ENTITY);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "bcm_chknoteedit": {
                BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
                QFilter filter = this.getQFilter();
                List qFilters = billList.getFilterParameter().getQFilters();
                qFilters.add(filter);
                billList.clearSelection();
                billList.refresh();
                break;
            }
        }
    }
}

