/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import kd.fi.bcm.spread.datacollect.DataCollectServiceHelper;
import kd.fi.bcm.spread.datacollect.OrgDCContext;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

class DataCollectThread<V>
implements Runnable {
    protected static final String CACHEKEY_PROGRESS = "datacollect_progress";
    private Long templateId;
    private Long orgId;
    private String modelnumber;
    private Long modelId;
    private Map<String, String> mapViewPoint;
    private boolean hasdim;
    private SpreadManager sm;
    private String pageId;
    private static final String SUCCUNUMS = "succnums";
    private static final String FAILNUMS = "failnums";
    private static final String TIPNUMS = "tipnums";

    public DataCollectThread(Long templateId, Long orgId, String modelnumber, Long modelId, Map<String, String> mapViewPoint, boolean hasdim, SpreadManager sm, String pageId) {
        this.templateId = templateId;
        this.orgId = orgId;
        this.modelnumber = modelnumber;
        this.modelId = modelId;
        this.mapViewPoint = mapViewPoint;
        this.hasdim = hasdim;
        this.sm = sm;
        this.pageId = pageId;
    }

    @Override
    public void run() {
        PageCache pageCache = new PageCache(this.pageId);
        pageCache.put(CACHEKEY_PROGRESS, String.valueOf(50));
        pageCache.put(SUCCUNUMS, "0");
        pageCache.put(FAILNUMS, "0");
        pageCache.put(TIPNUMS, "0");
        OrgDCContext con = null;
        long baseOrgId = TreeStructureServiceHelper.getEntityBaseMemberId((long)this.orgId);
        try {
            con = DataCollectUtil.doCollect(this.templateId, this.orgId, this.modelnumber, this.modelId, this.mapViewPoint, this.hasdim, this.sm);
        }
        catch (Exception e) {
            IDNumberTreeNode scenario = MemberReader.findScenaMemberByNum((String)this.modelnumber, (String)this.mapViewPoint.get(DimTypesEnum.SCENARIO.getNumber()));
            IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)this.modelnumber, (String)this.mapViewPoint.get(DimTypesEnum.YEAR.getNumber()));
            IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)this.modelnumber, (String)this.mapViewPoint.get(DimTypesEnum.PERIOD.getNumber()));
            String msg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6570\u5931\u8d25\uff1a%s\u3002", (String)"OrgDataCollectService_0", (String)"fi-bcm-business", (Object[])new Object[0]), kd.fi.bcm.business.util.DataCollectUtil.getErrorMsg((Exception)e));
            DynamicObject dy = DataCollectServiceHelper.getLog((String)"", (Long)this.templateId, (Long)baseOrgId, (Integer)0, (Long)this.modelId, (Long)period.getId(), (Long)scenario.getId(), (Long)fy.getId(), (String)msg, (String)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            pageCache.put("sm", JsonSerializerUtil.toJson((SpreadManager)this.sm));
            pageCache.put(SUCCUNUMS, "0");
            pageCache.put(FAILNUMS, "1");
            pageCache.put(TIPNUMS, "0");
            pageCache.put(CACHEKEY_PROGRESS, String.valueOf(100));
            return;
        }
        pageCache.put("sm", JsonSerializerUtil.toJson((SpreadManager)con.getSpreadManager()));
        pageCache.put(SUCCUNUMS, String.valueOf(con.getSuccessacctSum()));
        pageCache.put(FAILNUMS, String.valueOf(con.getFailacctSum()));
        pageCache.put(TIPNUMS, String.valueOf(con.getTipLogSum()));
        pageCache.put(CACHEKEY_PROGRESS, String.valueOf(100));
    }
}

