/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ExportRuleListPlugin
extends AbstractBaseListPlugin {
    transient TempFileCache cache;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("bar_download");
        this.addItemClickListeners("bar_packdownload");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        Object type = this.getView().getFormShowParameter().getCustomParam("ExportPageSource");
        QFilter filter = new QFilter("model", "=", modelId);
        filter.and("creater", "=", (Object)this.getUserId());
        if (type != null && StringUtils.isNotEmpty((String)type.toString())) {
            filter.and("type", "=", type);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_exporturllist", (String)"id,url", (QFilter[])new QFilter[]{filter});
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        ArrayList<Long> notExistsData = new ArrayList<Long>(doc.size());
        for (DynamicObject dy : doc) {
            String url = dy.getString("url");
            if (!StringUtil.isEmptyString((String)url) && this.cache.exists(url)) continue;
            notExistsData.add(dy.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"bcm_exporturllist", (QFilter[])new QFilter[]{new QFilter("id", "in", notExistsData)});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        DynamicObjectCollection doc;
        ListSelectedRowCollection selectedRows;
        BillList billList;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_download".equals(key)) {
            billList = (BillList)this.getControl("billlistap");
            selectedRows = billList.getSelectedRows();
            if (!selectedRows.isEmpty()) {
                doc = QueryServiceHelper.query((String)"bcm_exporturllist", (String)"url,filename", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                for (Object dy : doc) {
                    this.downloadFile(dy.getString("url"), "bcm_report_list", "47150e89000000ac");
                }
                DeleteServiceHelper.delete((String)"bcm_exporturllist", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                List<String> names = doc.stream().map(o -> o.getString("filename")).collect(Collectors.toList());
                this.writeOpLog(names, OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.BATCHEXPORT_DOWNLOAD.getMultiLangEnumBridge(), (String)"batchexport_download"), ResultStatusEnum.SUCCESS.getName());
            }
            billList.refreshData();
            billList.clearSelection();
        }
        if ("bar_packdownload".equals(key)) {
            billList = (BillList)this.getControl("billlistap");
            selectedRows = billList.getSelectedRows();
            if (!selectedRows.isEmpty()) {
                doc = QueryServiceHelper.query((String)"bcm_exporturllist", (String)"filename,url", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                HashMap<String, String> fileNmUrlMap = new HashMap<String, String>();
                for (DynamicObject dy : doc) {
                    fileNmUrlMap.put(dy.getString("filename"), dy.getString("url"));
                }
                NewReportMultiExportService newReportMultiExportService = new NewReportMultiExportService();
                String zipUrl = newReportMultiExportService.zipFile(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u6587\u4ef6%s", (String)"ExportRuleListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())), fileNmUrlMap);
                if (zipUrl != null) {
                    this.downloadFile(zipUrl, "bcm_report_list", "47150e89000000ac");
                }
                DeleteServiceHelper.delete((String)"bcm_exporturllist", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                List<String> names = doc.stream().map(o -> o.getString("filename")).collect(Collectors.toList());
                this.writeOpLog(names, OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.BATCHEXPORT_DOWNLOAD.getMultiLangEnumBridge(), (String)"batchexport_download"), ResultStatusEnum.SUCCESS.getName());
            }
            billList.refreshData();
            billList.clearSelection();
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    private void writeOpLog(List<String> names, OpNameMultiLangEnumBridge opNameBridge, String status) {
        StringBuilder nameStr = new StringBuilder(MemberReader.findModelSNumberById((Object)this.getView().getFormShowParameter().getCustomParam("modelId"))).append(" ");
        for (int i = 0; i < names.size() - 1; ++i) {
            nameStr = nameStr.append(names.get(i)).append(" | ");
        }
        if (!names.isEmpty()) {
            nameStr = nameStr.append(names.get(names.size() - 1));
        }
        this.writeLogWithEntityNumber("bcm_exporturllist", opNameBridge, new OPDescMultiLangEnumBridge("%1$s %2$s%3$s", "ExportRuleListPlugin_1", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{nameStr.toString(), opNameBridge.getDescription(), status})));
    }
}

