/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.ReportMultiExportPlugin;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import org.apache.commons.beanutils.BeanUtils;

public class ExportServiceConstructor {
    public static void buildService(ReportMultiExportService service, ReportMultiExportPlugin plugin) {
        service.setAuditMap(plugin.getAuditMap());
        service.setAudittrial(plugin.getAudittrial());
        service.setCsl(plugin.isCsl());
        service.setCube(plugin.getModelNumber());
        service.setCyNumber2Dy(plugin.getCyNumber2Dy());
        service.setCyObj_view(plugin.getCyObj_view());
        service.setDataTypeMap(plugin.getDataTypeMap());
        service.setViewDataunit(plugin.getViewDataunit());
        service.setDivisor(plugin.getDivisor());
        service.setExcelfiletype(plugin.getExcelfiletype());
        service.setSchemeName(plugin.getSchemeName());
        service.setFileruleStr(plugin.getFileruleStr());
        service.setFiletxt(plugin.getFiletxt());
        service.setFloat(false);
        service.setFyPeriodPairs(plugin.getFyPeriodPairs());
        service.setModelId(plugin.getModelId());
        service.setProcess(plugin.getProcess());
        service.setProcessMap(plugin.getProcessMap());
        service.setReport(false);
        service.setRptType(plugin.getRptType());
        service.setSaveByDim(false);
        service.setScale(plugin.getScale());
        service.setScaleStr(plugin.getScaleStr());
        service.setScene(plugin.getScene());
        service.setScene_view(plugin.getScene_view());
        service.setCslscheme_view(plugin.getCslScheme_view());
        service.setSheetruleStr(plugin.getSheetruleStr());
        service.setSheettxt(plugin.getSheettxt());
        service.setUnweave(plugin.isUnweave());
        service.setReportStatus(plugin.getReportStatus());
        service.setStartYear(plugin.getStartYear());
        service.setStartPeriod(plugin.getStartPeriod());
        service.setEndYear(plugin.getEndYear());
        service.setEndPeriod(plugin.getEndPeriod());
        service.setTempDoc(plugin.getTempDoc());
        service.setOrgDoc(plugin.getOrgDoc());
        service.setPageSourceEnum(plugin.isFromWorkPaper() ? ExportPageSourceEnum.WORKPAPER : ExportPageSourceEnum.DEFAULT);
        service.setSchemeId(plugin.isFromWorkPaper() ? plugin.getSchemeId() : 0L);
        service.setPackDownload(plugin.isPackDownload());
        service.setSourcestyle(plugin.getSourcestyle());
        service.setFloatdispay(plugin.getFloatdisplay());
        service.setFiletype(plugin.getFiletype());
        service.setDimNum2Items(ReportDataSelectScheme.getReportDataSelectScheme(plugin.getPageCache()).searchSchemeByNumber(plugin.getReportDataType()));
        service.setZipFileName(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u6587\u4ef6%s", (String)"ExportServiceConstructor_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())));
        service.setWatermark(plugin.getWatermark());
        service.setDefDimNum2ItemsMap(plugin.getDefDimNum2ItemsMap());
        if ("3".equals(plugin.getExcelfiletype())) {
            service.setExcelfiletype("0");
            service.setFileruleStr(plugin.getFileruleStr() + "_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            service.setIsSchemeId(plugin.getIsSchemeId());
            service.setJQExport(true);
            service.setFileAddress(plugin.getFileAddress());
            ArrayList mcStatus = Lists.newArrayList((Object[])plugin.getEntityFlowstatus().split(","));
            service.setMcStatus(mcStatus);
            service.setExportINI(plugin.isExportINI());
            service.setMergeINI(plugin.isMergeINI());
            service.setExportXml(plugin.isExportXml());
            service.setFormatEnum(plugin.isFormatEnum());
            service.setJqOrgMappingsingleMap(plugin.getJqOrgMappingsingleMap());
            service.setReportData2OrgMap(plugin.getReportData2OrgMap());
            service.setIniRuleCode(plugin.getIniRuleCode());
        }
    }

    public static void buildService(ReportMultiExportService service, ReportMultiExportService newService) throws InvocationTargetException, IllegalAccessException {
        BeanUtils.copyProperties((Object)newService, (Object)service);
        newService.srcTmp2RightId = service.srcTmp2RightId;
        newService.sheetName2Name = HashMultimap.create();
        newService.rptNum2Defined = service.rptNum2Defined;
        newService.rptName2Defined = service.rptName2Defined;
        newService.jqOrgMappingsingleMap = service.jqOrgMappingsingleMap;
        newService.excelCache = service.excelCache;
        newService.dimNums = service.dimNums;
        newService.setTaskConsumer(service.getTaskConsumer());
    }
}

