/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.BaseTableAdjustplugin;
import kd.fi.bcm.formplugin.template.util.SpreadDataModelUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class ExtenTableAdjustPlugin
extends BaseTableAdjustplugin {
    private static final String EXT_MODEL_NUMBER = "extModelNumber";
    private static final String EXT_GROUP = "extGroupr";
    private static final String ADJ_COL_NUMS = "adjColNums";
    private static final String COL_NUMS_WITHOUT_ADJ = "colNumsWithOutAdj";
    private static final String ADJ_COL_SUFFIX = "adjsuffix";
    private static final String WITHOUT_CWP_SUFFIX = "without";
    private static final String AFTER_SUFFIX = "aftersuffix";
    private static final String NUMBER_TTPE = "numext";
    private static final String DATE_TYPE = "date";
    private static final String CUBE = "cube";
    private static final String FLOAT_DIM_NUMS = "floatDimNums";
    private static final String EXTCOLS = "extcols";
    private static final String PARENT_ORG_NUM = "parentOrgNum";
    private static final List<String> DIMS = Arrays.asList("Entity", "Scenario", "Year", "Period", "Currency");

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object eirptValue;
        Object afterAdjWithoutCwp;
        String col;
        int index;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int focusRow = entry.getEntryState().getFocusRow();
        if (focusRow == -1) {
            return;
        }
        if (key.contains(ADJ_COL_SUFFIX)) {
            index = key.indexOf(ADJ_COL_SUFFIX);
            col = key.substring(0, index);
            Object adjustValue = SpreadDataModelUtil.dealValue(model.getValue(col + ADJ_COL_SUFFIX, focusRow));
            afterAdjWithoutCwp = SpreadDataModelUtil.dealValue(model.getValue(col + WITHOUT_CWP_SUFFIX, focusRow));
            eirptValue = SpreadDataModelUtil.dealValue(model.getValue(col, focusRow));
            model.beginInit();
            Object afterValue = ExtenTableAdjustPlugin.add(afterAdjWithoutCwp, adjustValue, eirptValue);
            try {
                model.setValue(col + AFTER_SUFFIX, afterValue, focusRow);
                model.setValue(col + ADJ_COL_SUFFIX, adjustValue, focusRow);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (key.contains(AFTER_SUFFIX)) {
            index = key.indexOf(AFTER_SUFFIX);
            col = key.substring(0, index);
            Object afterData = SpreadDataModelUtil.dealValue(model.getValue(col + AFTER_SUFFIX, focusRow));
            afterAdjWithoutCwp = SpreadDataModelUtil.dealValue(model.getValue(col + WITHOUT_CWP_SUFFIX, focusRow));
            eirptValue = SpreadDataModelUtil.dealValue(model.getValue(col, focusRow));
            model.beginInit();
            Object adjValue = ExtenTableAdjustPlugin.subtract(afterData, afterAdjWithoutCwp, eirptValue);
            try {
                model.setValue(col + ADJ_COL_SUFFIX, adjValue, focusRow);
                model.setValue(col + AFTER_SUFFIX, afterData, focusRow);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        String cube = (String)this.getView().getFormShowParameter().getCustomParam(CUBE);
        List selectDimCell = (List)this.getView().getFormShowParameter().getCustomParam(SELECTCELL);
        Map commonMember = (Map)this.getView().getFormShowParameter().getCustomParam("commonMember");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,membermodel,name,id", (QFilter[])new QFilter[]{filter});
        HashMap<String, IDNumberTreeNode> dim2mem = new HashMap<String, IDNumberTreeNode>(16);
        LinkedHashMap<String, DynamicObject> commonDimModelNum2dimDy = new LinkedHashMap<String, DynamicObject>(16);
        Map<String, DynamicObject> dimNum2Dy = dims.stream().collect(Collectors.toMap(dim -> dim.getString("number"), dim -> dim, (v1, v2) -> v1));
        List<String> sortPVDim = this.getCols("sortPVDim");
        for (String dimNum : sortPVDim) {
            DynamicObject dim2 = dimNum2Dy.get(dimNum);
            dim2mem.put(dim2.getString("membermodel"), MemberReader.findMemberByNumber((String)cube, (String)dimNum, (String)((String)commonMember.get(dimNum))));
            commonDimModelNum2dimDy.put(dim2.getString("membermodel"), dim2);
        }
        this.initNewStylePageViewPanel(commonDimModelNum2dimDy);
        this.bindCtrlMapping(commonDimModelNum2dimDy);
        this.setDefaultValue(dim2mem);
        List<String> sortCol = this.getCols("sortCol");
        HashMap<String, String> colsFieldMapped = new HashMap<String, String>(16);
        this.createTable(modelId, sortCol, colsFieldMapped);
        this.fillData(commonMember, selectDimCell, sortCol, colsFieldMapped);
    }

    private void createTable(Long modelId, List<String> sortCol, Map<String, String> colsFieldMapped) {
        String extModelNumber = (String)this.getFormCustomParam(EXT_MODEL_NUMBER);
        ExtendsModel extendsModel = ExtenTableAdjustPlugin.getExtendsModel(modelId, extModelNumber);
        LinkedHashMap<String, DynaEntityObject> rowCols = new LinkedHashMap<String, DynaEntityObject>(16);
        ArrayList<String> dimFields = new ArrayList<String>(16);
        ArrayList<String> extFields = new ArrayList<String>(16);
        ExtenTableAdjustPlugin.collectFields(extendsModel, rowCols, dimFields, extFields);
        ArrayList<String> canAdjNums = new ArrayList<String>(10);
        List<String> selectColNums = this.getCols("selects");
        String extendsgroup = extendsModel.getExtendsGroupNumber();
        ExtFieldMappedService fieldMappedService = new ExtFieldMappedService(modelId, extendsgroup);
        colsFieldMapped.putAll(fieldMappedService.getColsFieldMapped(extFields.toArray(new String[0])));
        ArrayList<String> numberNumsWithOutAdj = new ArrayList<String>(16);
        colsFieldMapped.forEach((k, v) -> {
            if (selectColNums.contains(k) && v.startsWith(NUMBER_TTPE)) {
                canAdjNums.add((String)k);
            } else if (v.startsWith(NUMBER_TTPE) && sortCol.contains(k)) {
                numberNumsWithOutAdj.add((String)k);
            }
        });
        this.getPageCache().put(ADJ_COL_NUMS, ObjectSerialUtil.toByteSerialized(canAdjNums));
        this.getPageCache().put(COL_NUMS_WITHOUT_ADJ, ObjectSerialUtil.toByteSerialized(numberNumsWithOutAdj));
        Page page = new Page();
        DynamicEntry entity = this.genHearEntity(sortCol, rowCols, extFields, canAdjNums, numberNumsWithOutAdj);
        page.addEntry(entity);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private DynamicEntry genHearEntity(List<String> sortCol, Map<String, DynaEntityObject> rowCols, ArrayList<String> extFields, List<String> canAdjNums, List<String> numberNumsWithOutAdj) {
        DynamicEntry entity = new DynamicEntry("entryentity");
        LocaleString width = new LocaleString("10%");
        for (String col : sortCol) {
            String dimName;
            if (DimTypesEnum.ENTITY.getNumber().equals(col)) {
                entity.addElement((Element)this.createTextEditElement(DimTypesEnum.ENTITY.getName(), col, width, 0, true));
                continue;
            }
            DynaEntityObject dy = rowCols.get(col);
            if (dy == null) continue;
            String string = dimName = extFields.contains(col) ? ((ExtFieldEntry)dy).getExtField().getName() : ((DimFieldEntry)dy).getDimension().getName();
            if (canAdjNums.contains(col)) {
                TextEditElement textEditElement = this.createTextEditElement(String.format(ResManager.loadKDString((String)"%s\u8c03\u6574\u524d\u62a5\u8868\u6570", (String)"ExtTableAdjustPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName), col, width, 0, true);
                TextEditElement withoutCwp = this.createTextEditElement(String.format(ResManager.loadKDString((String)"%s\u975e\u8868\u5f0f\u8c03\u6574\u6570", (String)"ExtTableAdjustPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName), col + WITHOUT_CWP_SUFFIX, width, 0, true);
                TextEditElement extAdjustElement = this.createTextEditElement(String.format(ResManager.loadKDString((String)"%s\u786e\u8ba4\u8868\u5f0f\u8c03\u6574\u6570", (String)"ExtTableAdjustPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName), col + ADJ_COL_SUFFIX, width, 0, false);
                extAdjustElement.setColor(this.COLOR);
                TextEditElement afterData = this.createTextEditElement(String.format(ResManager.loadKDString((String)"%s\u8c03\u6574\u540e\u62a5\u8868\u6570", (String)"ExtTableAdjustPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName), col + AFTER_SUFFIX, width, 0, false);
                afterData.setColor(this.COLOR);
                entity.addElement((Element)textEditElement);
                entity.addElement((Element)withoutCwp);
                entity.addElement((Element)extAdjustElement);
                entity.addElement((Element)afterData);
                continue;
            }
            if (numberNumsWithOutAdj.contains(col)) {
                entity.addElement((Element)this.createTextEditElement(dimName, col, width, 0, true));
                TextEditElement extAdjustElement = this.createTextEditElement(ExtenTableAdjustPlugin.dealAdjNum(col), ExtenTableAdjustPlugin.dealAdjNum(col), width, 0, true);
                entity.addElement((Element)extAdjustElement);
                continue;
            }
            entity.addElement((Element)this.createTextEditElement(dimName, col, width, 0, true));
        }
        entity.addElement((Element)this.createTextEditElement("adjid", "adjid", width, 0, true));
        entity.addElement((Element)this.createTextEditElement("key", "key", width, 0, true));
        return entity;
    }

    private static void collectFields(ExtendsModel extendsModel, Map<String, DynaEntityObject> rowCols, ArrayList<String> dimFields, ArrayList<String> extFields) {
        List extFieldEntrys;
        List dimFieldEntryList = extendsModel.getDimFieldEntry();
        if (dimFieldEntryList != null && !dimFieldEntryList.isEmpty()) {
            dimFieldEntryList.forEach(dimFieldEntry -> {
                rowCols.put(dimFieldEntry.getDimension().getNumber(), (DynaEntityObject)dimFieldEntry);
                dimFields.add(dimFieldEntry.getDimension().getNumber());
            });
        }
        if ((extFieldEntrys = extendsModel.getExtFieldEntry()) != null && !extFieldEntrys.isEmpty()) {
            extFieldEntrys.forEach(extFieldEntry -> {
                rowCols.put(extFieldEntry.getExtField().getNumber(), (DynaEntityObject)extFieldEntry);
                extFields.add(extFieldEntry.getExtField().getNumber());
            });
        }
    }

    private static ExtendsModel getExtendsModel(Long modelId, String extModelNumber) {
        DynamicObject extModelDy = ExtenTableAdjustPlugin.getExtModel(modelId, extModelNumber);
        ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(Long.valueOf(extModelDy.getLong("id")));
        return extendsModel;
    }

    private static DynamicObject getExtModel(Long modelId, String extModelNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)extModelNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,extendsgroup.number", (QFilter[])qFilter.toArray());
        return dynamicObject;
    }

    private void fillData(Map<String, String> commonMap, List<Map<String, String>> selectDimCell, List<String> sortCol, Map<String, String> colsFieldMapped) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        List<String> withoutNum = this.getPageCacheByNum(COL_NUMS_WITHOUT_ADJ);
        ArrayList<String> nums = new ArrayList<String>(16);
        for (String num : withoutNum) {
            nums.add(ExtenTableAdjustPlugin.dealAdjNum(num));
        }
        nums.add("key");
        nums.add("adjid");
        this.getView().setVisible(Boolean.valueOf(false), nums.toArray(new String[0]));
        this.buildDataEntity(commonMap, selectDimCell, sortCol, colsFieldMapped);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void buildDataEntity(Map<String, String> commonMap, List<Map<String, String>> selectDimCell, List<String> sortCol, Map<String, String> colsFieldMapped) {
        CharSequence sb;
        EdQueryComInfo edQueryComInfo = this.getEdQueryComInfo(commonMap);
        EdQueryComInfo edQueryComInfo4Attotal = this.getEdQueryComInfo4Attotal(commonMap, "ERpt", "ATTotal");
        EdQueryComInfo edQueryComInfo4Eirpt = this.getEdQueryComInfo4Attotal(commonMap, "EIRpt", "ATTotal");
        List<String> floatDimNums = this.getCols(FLOAT_DIM_NUMS);
        List<String> uniq = ExtenTableAdjustPlugin.getUniqByEdQueryComInfo(sortCol, colsFieldMapped, edQueryComInfo, floatDimNums);
        ArrayList<String> uniqNum = new ArrayList<String>(16);
        for (String string : uniq) {
            if (colsFieldMapped.get(string) == null || !colsFieldMapped.get(string).startsWith(NUMBER_TTPE)) continue;
            uniqNum.add(string);
        }
        this.getPageCache().put("uniqNum", ObjectSerialUtil.toByteSerialized(uniqNum));
        this.getPageCache().put("colsFieldMapped", ObjectSerialUtil.toByteSerialized(colsFieldMapped));
        HashMultimap floatDim2Mems = HashMultimap.create();
        for (String floatDim : floatDim2Mems.keySet()) {
            edQueryComInfo.addDimFilter(floatDim, floatDim2Mems.get((Object)floatDim).toArray(new String[0]));
            edQueryComInfo4Attotal.addDimFilter(floatDim, floatDim2Mems.get((Object)floatDim).toArray(new String[0]));
            edQueryComInfo4Eirpt.addDimFilter(floatDim, floatDim2Mems.get((Object)floatDim).toArray(new String[0]));
        }
        floatDimNums.add(DimTypesEnum.ENTITY.getNumber());
        edQueryComInfo.setDimselects(floatDimNums.toArray(new String[0]));
        edQueryComInfo4Attotal.setDimselects(floatDimNums.toArray(new String[0]));
        edQueryComInfo4Eirpt.setDimselects(floatDimNums.toArray(new String[0]));
        EDResultSet eDResultSet = ExtDataServiceHelper.queryData((EdQueryComInfo)edQueryComInfo);
        HashMap adjKey2Value = new HashMap(16);
        HashMap<String, Long> adjKey2Id = new HashMap<String, Long>(16);
        List<String> adjColNums = this.getAdjColNums();
        List<String> withoutAdj = this.getPageCacheByNum(COL_NUMS_WITHOUT_ADJ);
        for (EDRow row : eDResultSet.getRows()) {
            String sb2 = ExtenTableAdjustPlugin.genKey(colsFieldMapped, uniq, row);
            adjKey2Id.put(sb2, row.getPkId());
            HashMap<String, BigDecimal> value = new HashMap<String, BigDecimal>(16);
            for (String adjColNum : adjColNums) {
                value.put(adjColNum, row.getBigDecimal(adjColNum));
            }
            for (String withoutAdjColNum : withoutAdj) {
                value.put(withoutAdjColNum, row.getBigDecimal(withoutAdjColNum));
            }
            adjKey2Value.put(sb2, value);
        }
        HashMap adjKey2AttotalValue = new HashMap(16);
        EDResultSet attotalRows = ExtDataServiceHelper.queryData((EdQueryComInfo)edQueryComInfo4Attotal);
        for (EDRow row : attotalRows.getRows()) {
            String sb3 = ExtenTableAdjustPlugin.genKey(colsFieldMapped, uniq, row);
            HashMap<String, BigDecimal> value = new HashMap<String, BigDecimal>(16);
            for (String adjColNum : adjColNums) {
                value.put(adjColNum, row.getBigDecimal(adjColNum));
            }
            adjKey2AttotalValue.put(sb3, value);
        }
        HashMap adjKey2EirptlValue = new HashMap(16);
        EDResultSet eirptRows = ExtDataServiceHelper.queryData((EdQueryComInfo)edQueryComInfo4Eirpt);
        for (EDRow row : eirptRows.getRows()) {
            sb = ExtenTableAdjustPlugin.genKey(colsFieldMapped, uniq, row);
            HashMap<String, BigDecimal> value = new HashMap<String, BigDecimal>(16);
            for (String adjColNum : adjColNums) {
                value.put(adjColNum, row.getBigDecimal(adjColNum));
            }
            adjKey2EirptlValue.put((String)sb, value);
        }
        IDataModel model = this.getModel();
        int[] rows = model.batchCreateNewEntryRow("entryentity", selectDimCell.size());
        for (int i = 0; i < rows.length; ++i) {
            Map<String, String> cellData = selectDimCell.get(i);
            sb = new StringBuilder();
            for (String col : uniq) {
                if (!cellData.containsKey(col)) continue;
                ((StringBuilder)sb).append(cellData.get(col));
            }
            String key = ((StringBuilder)sb).toString();
            try {
                ExtenTableAdjustPlugin.fillData(cellData, model, i, key, withoutAdj, (Map)adjKey2EirptlValue.get(key), adjColNums);
                ExtenTableAdjustPlugin.fillAdjExtData(adjColNums, (Long)adjKey2Id.get(key), (Map)adjKey2Value.get(key), model, i, withoutAdj, (Map)adjKey2AttotalValue.get(key), (Map)adjKey2EirptlValue.get(key));
                continue;
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                log.error((Throwable)e);
            }
        }
        model.deleteEntryRow("entryentity", selectDimCell.size());
    }

    private static String genKey(Map<String, String> colsFieldMapped, List<String> uniq, EDRow row) {
        StringBuilder sb = new StringBuilder();
        String v = "";
        for (String uniqCol : uniq) {
            v = colsFieldMapped.get(uniqCol) != null ? (colsFieldMapped.get(uniqCol).startsWith(NUMBER_TTPE) ? row.getBigDecimal(uniqCol).stripTrailingZeros().toPlainString() : row.getString(uniqCol)) : row.getString(uniqCol);
            if (v == null) {
                v = "";
            }
            sb.append(v);
        }
        return sb.toString();
    }

    private static QFilter genCustomerFilter(List<Map<String, String>> selectDimCell, Map<String, String> colsFieldMapped, List<String> floatDimNums, List<String> uniq, Multimap<String, String> floatDim2Mems) {
        QFilter qFilter = null;
        for (Map<String, String> extDim2Mem : selectDimCell) {
            for (String floatDimNum : floatDimNums) {
                floatDim2Mems.put((Object)floatDimNum, (Object)extDim2Mem.get(floatDimNum));
            }
            QFilter qf = new QFilter("1", "=", (Object)1);
            for (String num : uniq) {
                if (!extDim2Mem.containsKey(num)) continue;
                String v = extDim2Mem.get(num);
                if (colsFieldMapped.get(num).startsWith(DATE_TYPE)) {
                    try {
                        qf.and(colsFieldMapped.get(num), "=", (Object)DateTimeUtils.parseStrDate((String)v));
                        continue;
                    }
                    catch (ParseException e) {
                        String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u4e0d\u53ef\u8868\u5f0f\u8c03\u6574 %s", (String)"ExtTableAdjustPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), v);
                        throw new KDBizException(msg);
                    }
                }
                qf.and(colsFieldMapped.get(num), "=", (Object)v);
            }
            if (qFilter == null) {
                qFilter = qf;
                continue;
            }
            qFilter.or(qf);
        }
        return qFilter;
    }

    private static List<String> getUniqByEdQueryComInfo(List<String> sortCol, Map<String, String> colsFieldMapped, EdQueryComInfo edQueryComInfo, List<String> floatDimNums) {
        List<String> uniq = ExtDataQueryService.getExtModelUniqueFields((EdQueryComInfo)edQueryComInfo);
        if (uniq == null || uniq.isEmpty()) {
            uniq = sortCol.stream().filter(col -> colsFieldMapped.containsKey(col) && !((String)colsFieldMapped.get(col)).startsWith(NUMBER_TTPE)).collect(Collectors.toList());
            for (String floatDimNum : floatDimNums) {
                if (uniq.contains(floatDimNum)) continue;
                uniq.add(floatDimNum);
            }
        } else if ((uniq = uniq.stream().filter(col -> sortCol.contains(col)).collect(Collectors.toList())).isEmpty()) {
            uniq = sortCol.stream().filter(col -> colsFieldMapped.containsKey(col) && !((String)colsFieldMapped.get(col)).startsWith(NUMBER_TTPE)).collect(Collectors.toList());
        }
        return uniq;
    }

    private EdQueryComInfo getEdQueryComInfo(Map<String, String> commonMap) {
        Long modelId = (Long)this.getFormCustomParam("model");
        String extModelNumber = (String)this.getFormCustomParam(EXT_MODEL_NUMBER);
        String extGroup = (String)this.getFormCustomParam(EXT_GROUP);
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(MemberReader.findModelSNumberById((Object)modelId), extGroup, extModelNumber);
        String[] extCols = (String[])ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam(EXTCOLS)));
        edQueryComInfo.setExtselects(extCols);
        edQueryComInfo.setParentOrg((String)this.getFormCustomParam(PARENT_ORG_NUM));
        edQueryComInfo.setNeedSum(false);
        for (String fixDim : ExtDataUtil.fixDims) {
            String mem = commonMap.get(fixDim);
            mem = this.dealProcessAndAudit(fixDim, mem, this.getView().getPageCache().get(ADJUST_AT_MEM));
            edQueryComInfo.addDimFilter(fixDim, new String[]{mem});
        }
        return edQueryComInfo;
    }

    private EdQueryComInfo getEdQueryComInfo4Attotal(Map<String, String> commonMap, String process, String audit) {
        Long modelId = (Long)this.getFormCustomParam("model");
        String extModelNumber = (String)this.getFormCustomParam(EXT_MODEL_NUMBER);
        String extGroup = (String)this.getFormCustomParam(EXT_GROUP);
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(MemberReader.findModelSNumberById((Object)modelId), extGroup, extModelNumber);
        String[] extCols = (String[])ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam(EXTCOLS)));
        edQueryComInfo.setExtselects(extCols);
        edQueryComInfo.setParentOrg((String)this.getFormCustomParam(PARENT_ORG_NUM));
        edQueryComInfo.setNeedSum(true);
        for (String fixDim : ExtDataUtil.fixDims) {
            String mem = commonMap.get(fixDim);
            mem = this.dealProcessAndAudit(fixDim, mem, this.getView().getPageCache().get(ADJUST_AT_MEM));
            if ("Process".equalsIgnoreCase(fixDim)) {
                if (StringUtils.isEmpty((String)process)) {
                    process = "ERpt";
                }
                edQueryComInfo.addDimFilter(fixDim, new String[]{process});
                continue;
            }
            if ("AuditTrail".equalsIgnoreCase(fixDim)) {
                if (StringUtils.isEmpty((String)audit)) {
                    audit = "ATTotal";
                }
                edQueryComInfo.addDimFilter(fixDim, new String[]{audit});
                continue;
            }
            edQueryComInfo.addDimFilter(fixDim, new String[]{mem});
        }
        return edQueryComInfo;
    }

    private static String getExtGroup(Long modelId, String extModelNumber) {
        DynamicObject extModelDy = ExtenTableAdjustPlugin.getExtModel(modelId, extModelNumber);
        String extendsgroup = extModelDy.getString("extendsgroup.number");
        return extendsgroup;
    }

    private static void fillData(Map<String, String> cellData, IDataModel model, int i, String key, List<String> withoutAdj, Map<String, BigDecimal> eirptValues, List<String> adjColNums) {
        for (Map.Entry<String, String> entry : cellData.entrySet()) {
            String value = entry.getValue();
            String col = entry.getKey();
            if (withoutAdj.contains(col) && StringUtils.isEmpty((String)value)) {
                value = "0";
            }
            if (adjColNums != null && adjColNums.contains(col)) {
                value = eirptValues != null && eirptValues.containsKey(col) ? eirptValues.get(col).stripTrailingZeros().toPlainString() : "0";
            }
            model.setValue(col, (Object)value, i);
        }
        model.setValue("key", (Object)key, i);
    }

    private static void fillAdjExtData(List<String> adjCols, Long id, Map<String, BigDecimal> adjValues, IDataModel model, int i, List<String> withoutAdj, Map<String, BigDecimal> attotalValues, Map<String, BigDecimal> eirptValues) {
        boolean hasAdj = adjValues != null;
        boolean hasAttotal = attotalValues != null;
        adjCols.forEach(extNum -> {
            String eirptValue = eirptValues == null ? "0" : eirptValues.get(extNum);
            if (eirptValue instanceof BigDecimal) {
                eirptValue = ((BigDecimal)((Object)eirptValue)).stripTrailingZeros().toPlainString();
            }
            if (hasAdj) {
                Object adjValue = adjValues.get(extNum);
                if (adjValue instanceof BigDecimal) {
                    adjValue = ((BigDecimal)adjValue).stripTrailingZeros().toPlainString();
                }
                model.setValue(extNum + ADJ_COL_SUFFIX, adjValue, i);
                Object attotalValue = attotalValues.get(extNum);
                if (attotalValue instanceof BigDecimal) {
                    attotalValue = ((BigDecimal)attotalValue).stripTrailingZeros().toPlainString();
                }
                model.setValue(extNum + AFTER_SUFFIX, attotalValue, i);
                model.setValue(extNum + WITHOUT_CWP_SUFFIX, ExtenTableAdjustPlugin.subtract(attotalValue, adjValue, eirptValue), i);
            } else if (hasAttotal) {
                Object attotalValue = attotalValues.get(extNum);
                if (attotalValue instanceof BigDecimal) {
                    attotalValue = ((BigDecimal)attotalValue).stripTrailingZeros().toPlainString();
                }
                model.setValue(extNum + AFTER_SUFFIX, attotalValue, i);
                model.setValue(extNum + WITHOUT_CWP_SUFFIX, ExtenTableAdjustPlugin.subtract(attotalValue, "", eirptValue), i);
            }
        });
        if (hasAdj) {
            for (String num : withoutAdj) {
                Object value = adjValues.get(num);
                if (value instanceof BigDecimal) {
                    value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                }
                model.setValue(ExtenTableAdjustPlugin.dealAdjNum(num), value, i);
            }
            model.setValue("adjid", (Object)id, i);
        }
    }

    private void setDefaultValue(Map<String, IDNumberTreeNode> dim2mem) {
        ORM orm = ORM.create();
        for (Map.Entry<String, IDNumberTreeNode> entry : dim2mem.entrySet()) {
            String dimModelNum = entry.getKey();
            DynamicObjectType dataEntiyType = (DynamicObjectType)orm.getDataEntityType(dimModelNum);
            DynamicObject memberDyna = new DynamicObject(dataEntiyType, null);
            memberDyna.set("id", (Object)entry.getValue().getId());
            memberDyna.set("number", (Object)entry.getValue().getNumber());
            String name = entry.getValue().getName();
            name = this.dealProcessAndAuditname(entry.getKey(), this.adjAtName, name);
            memberDyna.set("name", (Object)name);
            this.getModel().getDataEntity().set(this.sugarF7Key(dimModelNum, entry.getValue().getDimNumber()), (Object)memberDyna);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_save".equals(key)) {
            EDSaveComInfo edSaveComInfo = this.genSaveComInfo();
            String[] extCols = (String[])ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam(EXTCOLS)));
            edSaveComInfo.setCols(extCols);
            List<String> floatDimNums = this.getCols(FLOAT_DIM_NUMS);
            edSaveComInfo.setDims(floatDimNums.toArray(new String[0]));
            try {
                this.collectSaveValue(edSaveComInfo, extCols, floatDimNums);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                log.error((Throwable)e);
                return;
            }
            ExtDataServiceHelper.saveData((EDSaveComInfo)edSaveComInfo);
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    private void collectSaveValue(EDSaveComInfo edSaveComInfo, String[] extCols, List<String> floatDimNums) {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("entryentity");
        List<String> adjColNums = this.getAdjColNums();
        List<String> withoutAdjColNums = this.getPageCacheByNum(COL_NUMS_WITHOUT_ADJ);
        HashMap<String, Pair> addValue = new HashMap<String, Pair>(16);
        List<String> uniqNum = this.getPageCacheByNum("uniqNum");
        HashMap colsFieldMapped = new HashMap(16);
        String colsFieldMappedStr = this.getPageCache().get("colsFieldMapped");
        if (StringUtils.isNotEmpty((String)colsFieldMappedStr)) {
            colsFieldMapped.putAll((Map)ObjectSerialUtil.deSerializedBytes((String)colsFieldMappedStr));
        }
        int adjSize = adjColNums.size();
        for (DynamicObject data : datas) {
            int i;
            ArrayList<Object> uniqs = new ArrayList<Object>(16);
            Object[] addValueRow = new Object[extCols.length];
            Object[] updateValueRow = new Object[extCols.length];
            String[] dimValueRow = new String[floatDimNums.size()];
            long adjId = data.getLong("adjid");
            StringBuilder sb = new StringBuilder();
            boolean canSave = false;
            for (i = 0; i < extCols.length; ++i) {
                String string = extCols[i];
                Object cellValue = data.get(string);
                uniqs.add(cellValue);
                if (adjColNums.contains(string)) {
                    Object adjValue = data.get(string + ADJ_COL_SUFFIX);
                    if (adjValue != null && StringUtils.isNotEmpty((String)adjValue.toString())) {
                        addValueRow[i] = adjValue;
                        updateValueRow[i] = adjValue;
                        canSave = true;
                        continue;
                    }
                    addValueRow[i] = "0";
                    updateValueRow[i] = "0";
                    if (adjSize != 1) continue;
                    break;
                }
                if (adjId == 0L) {
                    if (!colsFieldMapped.containsKey(string)) continue;
                    String mapCol = (String)colsFieldMapped.get(string);
                    if (mapCol.startsWith(NUMBER_TTPE) && !uniqNum.contains(string)) {
                        addValueRow[i] = new BigDecimal(0);
                        continue;
                    }
                    addValueRow[i] = cellValue;
                    continue;
                }
                updateValueRow[i] = withoutAdjColNums.contains(string) ? data.get(ExtenTableAdjustPlugin.dealAdjNum(string)) : cellValue;
            }
            if (!canSave) continue;
            for (i = 0; i < floatDimNums.size(); ++i) {
                String string;
                dimValueRow[i] = string = data.get(floatDimNums.get(i)) != null ? data.getString(floatDimNums.get(i)) : "";
                uniqs.add(string);
            }
            if (adjId != 0L) {
                if (!edSaveComInfo.checkValue(updateValueRow)) continue;
                edSaveComInfo.putUpdateValues(adjId, updateValueRow, dimValueRow);
                continue;
            }
            if (!edSaveComInfo.checkValue(addValueRow)) continue;
            for (Object e : uniqs) {
                sb.append(e == null ? "" : e.toString());
            }
            addValue.put(sb.toString(), new Pair((Object)addValueRow, (Object)dimValueRow));
        }
        for (Pair value : addValue.values()) {
            edSaveComInfo.addValue((Object[])value.p1, (String[])value.p2);
        }
    }

    private static String dealAdjNum(String extCol) {
        return extCol.replace("_", "").toLowerCase(Locale.ENGLISH) + ADJ_COL_SUFFIX;
    }

    private EDSaveComInfo genSaveComInfo() {
        Long modelId = (Long)this.getFormCustomParam("model");
        String extModelNumber = (String)this.getFormCustomParam(EXT_MODEL_NUMBER);
        String extGroup = (String)this.getFormCustomParam(EXT_GROUP);
        String showNum = MemberReader.findModelSNumberById((Object)modelId);
        EDSaveComInfo edSaveComInfo = new EDSaveComInfo(showNum, extGroup, extModelNumber);
        Map commonMember = (Map)this.getView().getFormShowParameter().getCustomParam("commonMember");
        for (String fixDim : ExtDataUtil.fixDims) {
            String mem = (String)commonMember.get(fixDim);
            mem = this.dealProcessAndAudit(fixDim, mem, this.getView().getPageCache().get(ADJUST_AT_MEM));
            edSaveComInfo.addfixedDimension(fixDim, mem);
        }
        String parentOrg = (String)this.getFormCustomParam(PARENT_ORG_NUM);
        edSaveComInfo.setParentOrg(parentOrg);
        return edSaveComInfo;
    }

    private static QFBuilder getAdjExtDataQf(String adjProcess, String adjAudit, Map<String, String> commonMember, String dataModel, String showNumber, Long modelId) {
        String extGroup = ExtenTableAdjustPlugin.getExtGroup(modelId, dataModel);
        ExtFieldMappedService fieldMappedService = new ExtFieldMappedService(modelId, extGroup);
        Map dimsFieldMapped = fieldMappedService.getDimsFieldMapped(commonMember.keySet().toArray(new String[0]));
        QFBuilder qfBuilder = new QFBuilder();
        QFilter qf = new QFilter("modelnumber", "=", (Object)showNumber);
        qf.and("datamodel", "=", (Object)dataModel);
        for (String dim : DIMS) {
            qf.and((String)dimsFieldMapped.get(dim), "=", (Object)commonMember.get(dim));
        }
        qf.and((String)dimsFieldMapped.get("Process"), "=", (Object)adjProcess);
        qf.and((String)dimsFieldMapped.get("AuditTrail"), "=", (Object)adjAudit);
        qfBuilder.add(qf);
        return qfBuilder;
    }

    private List<String> getAdjColNums() {
        return this.getPageCacheByNum(ADJ_COL_NUMS);
    }

    private List<String> getNumberColNumsWithOutAdj() {
        return this.getPageCacheByNum(COL_NUMS_WITHOUT_ADJ);
    }

    private List<String> getPageCacheByNum(String key) {
        String cloNamesCache = this.getPageCache().get(key);
        if (StringUtil.isEmptyString((String)cloNamesCache)) {
            return new ArrayList<String>(20);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)cloNamesCache);
    }

    private List<String> getCols(String arg) {
        String selects = (String)this.getFormCustomParam(arg);
        if (StringUtil.isEmptyString((String)selects)) {
            return new ArrayList<String>(20);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)selects);
    }
}

