/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.RichTextEditorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.ComponentInfo;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.task.MyTaskTreeUtil;
import kd.fi.bcm.formplugin.tree.task.TaskCataLog;
import kd.fi.bcm.formplugin.tree.task.TaskTreeBulider;
import kd.fi.bcm.formplugin.tree.task.TaskTreeNode;

public class MultiTabReportProcess4TaskPlugin
extends AbstractMultiReportPlugin {
    private static final String HASOVERDUE = "hasoverdue";
    private static final String UNOVERDUE = "unoverdue";
    private static final String COMINGOVERDUE = "comingoverdue";
    private static final String FINISH = "finish";
    private static final String UNCOMPLETE = "uncom_plete";
    private static final String COMPLETE = "complete";
    private static final String ALL = "all";
    private static final String TASKTREE = "tasktree";
    private static final String DESCRIPTION_TAB = "descriptiontab";
    private static final String EXPLAIN_PAGE = "explain_page";
    private static final String PARAM_PAGE = "param_page";
    private static final String NOTFIN_PAGE = "notfin_page";
    private static final String ISVISIBLE_FLAG = "isVisible_flag";
    private static final String TASKPKCACHE_KEY = "task_pk_cache";
    private static final String FILTER_CACHE = "filterCache";
    private static final String TREENODE_CLICK_CALLBACK = "treeNodeClickCallback";
    private static final String CALLBACK_CLICK_STATUSTAB = "callback_click_statustab";
    private static final String FLAG_HASSHOWCONFIRM = "hasShowConfirm";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String BTN_ALLTASK_COMPLETED = "btn_alltaskcompleted";
    private static final String BTN_ALLTASK_UNCOMPLETED = "btn_alltaskuncompleted";

    @Override
    protected void lockToolbar(boolean success) {
        this.getView().setEnable(Boolean.valueOf(success), new String[]{"btn_taskcompleted", "btn_taskuncompleted", "btn_batchtaskoprt", "btn_save", "btn_complete", "btn_weaving", "btn_commit", "btn_back", "btn_batchoprt", "btn_allcomplete", "btn_allweaving", "btn_allcommit", "btn_allback", "btn_check", "btn_convert", "btn_selectdynaitem", "btn_postil", "btn_more", "btn_calculate", BTN_ALLTASK_COMPLETED, BTN_ALLTASK_UNCOMPLETED});
    }

    @Override
    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getControl(TASKTREE);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                if (MultiTabReportProcess4TaskPlugin.this.isClickedTheSameNode(evt)) {
                    return;
                }
                if (MultiTabReportProcess4TaskPlugin.this.isModified()) {
                    MultiTabReportProcess4TaskPlugin.this.getPageCache().put("nodeId", evt.getNodeId().toString());
                    MultiTabReportProcess4TaskPlugin.this.getPageCache().put("parentId", evt.getParentNodeId() == null ? "" : evt.getParentNodeId().toString());
                    MultiTabReportProcess4TaskPlugin.this.getPageCache().put(MultiTabReportProcess4TaskPlugin.FLAG_HASSHOWCONFIRM, "true");
                    MultiTabReportProcess4TaskPlugin.this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316,\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u62a5\u8868\uff1f", (String)"MultiTabReportProcess4TaskPlugin_0", (String)MultiTabReportProcess4TaskPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MultiTabReportProcess4TaskPlugin.TREENODE_CLICK_CALLBACK);
                } else {
                    MultiTabReportProcess4TaskPlugin.this.clickTreeNode(evt);
                }
            }
        });
        Tab descriptionTab = this.getDescriptionTab();
        descriptionTab.addTabSelectListener(this::descriptionTabSelected);
        this.initBindCtrl();
        Tab statustab = (Tab)this.getControl("statustab");
        statustab.addTabSelectListener(this::statusTabSelected);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (TREENODE_CLICK_CALLBACK.equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                this.cacheTrueOrFalseFlag("set_change_4_save_flag", true);
                this.invokeSaveEvent();
            } else {
                this.fireClickNodeEvent();
            }
        } else if (CALLBACK_CLICK_STATUSTAB.equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                this.getPageCache().remove("tabkey_selected");
                this.invokeSaveEvent();
            } else {
                this.setModified(false);
            }
        }
    }

    private void fireClickNodeEvent() {
        String nodeId = this.getPageCache().get("nodeId");
        String parentNodeId = this.getPageCache().get("parentNodeId");
        TreeNodeEvent event = new TreeNodeEvent((Object)"", (Object)parentNodeId, (Object)nodeId);
        this.clickTreeNode(event);
    }

    @Override
    protected void afterSaveReportData() {
        if (this.isTrueFlagInCache("set_change_4_save_flag")) {
            this.cacheTrueOrFalseFlag("set_change_4_save_flag", false);
            this.fireClickNodeEvent();
        }
    }

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put("tabkey_selected", tabKey);
        this.getPageCache().remove("curReportStatus");
        if (this.isModified() && !this.isTrueFlagInCache(FLAG_HASSHOWCONFIRM)) {
            this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316,\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u62a5\u8868\uff1f", (String)"MultiTabReportProcess4TaskPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "change_confirm");
        } else {
            this.switchTab(tabKey);
            this.loadReport();
        }
        this.getPageCache().remove(FLAG_HASSHOWCONFIRM);
    }

    private void descriptionTabSelected(TabSelectEvent evt) {
        JSONObject map;
        Long pk;
        String key = evt.getTabKey();
        String serial = this.getPageCache().get(TASKPKCACHE_KEY);
        if (StringUtils.isNotEmpty((String)serial) && (pk = (map = JSONObject.parseObject((String)serial)).getLong(key)) != null) {
            if (EXPLAIN_PAGE.equals(key)) {
                this.doBuildTabDisplayComponent(this.getTaskExplainInfoByTaskCatalogPk(pk));
            } else if (PARAM_PAGE.equals(key)) {
                this.doBuildTabDisplayComponent(this.getTaskParamInfoByTaskCatalogPk(pk));
            } else {
                throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u4efb\u52a1\u7684\u4efb\u52a1\u8bf4\u660e\u6216\u53c2\u6570\u7684PK\u3002", (String)"MultiTabReportProcess4TaskPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void statusTabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        this.getPageCache().put("clicktab", "1");
        if (this.isTrueFlagInCache("isalreadyRefreshTree")) {
            this.getPageCache().remove("isalreadyRefreshTree");
            return;
        }
        switch (key) {
            case "status_uncomplete": {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_COMPLETED});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_UNCOMPLETED});
                this.getPageCache().put(FILTER_CACHE, UNCOMPLETE);
                break;
            }
            case "status_complete": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_COMPLETED});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_UNCOMPLETED});
                this.getPageCache().put(FILTER_CACHE, COMPLETE);
                break;
            }
            case "status_all": {
                this.getPageCache().put(FILTER_CACHE, ALL);
            }
        }
        this.refreshTaskTree();
    }

    private void setEnbleBtnByChangeTab() {
        String key;
        switch (key = this.getPageCache().get(FILTER_CACHE)) {
            case "uncom_plete": {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_COMPLETED});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_UNCOMPLETED});
                break;
            }
            case "complete": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_COMPLETED});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_UNCOMPLETED});
                break;
            }
            case "all": {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_COMPLETED});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ALLTASK_UNCOMPLETED});
            }
        }
    }

    private Tab getDescriptionTab() {
        return (Tab)this.getControl(DESCRIPTION_TAB);
    }

    private void clickTreeNode(TreeNodeEvent evt) {
        TreeModel treenode = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        String nodeId = (String)evt.getNodeId();
        TaskTreeNode node = (TaskTreeNode)treenode.searchByNodeId(nodeId);
        if (this.isSameReportPostman(nodeId, (TreeModel<TaskTreeNode>)treenode)) {
            this.getPageCache().put("current_node_id", evt.getNodeId().toString());
            return;
        }
        this.setMockCreateNewData(true);
        this.getModel().createNewData();
        this.getPageCache().remove("bindCtrl");
        int hasviewperm = 0;
        long orgid = 0L;
        long taskid = 0L;
        ReportPostmanByEntity pm = (ReportPostmanByEntity)node.getData();
        com.google.common.base.Predicate p = null;
        TaskTypeEnum type = node.getNodetype();
        this.getPageCache().put("tasktype", String.valueOf(type.getValue()));
        TaskCataLog catalog = node.getCatalog();
        switch (type) {
            case ORG_DISPLAY: 
            case LABEL: 
            case REPORT: 
            case UNFITASK: {
                if (this.isEPM()) break;
                String appId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
                hasviewperm = BcmBasePluginUtil.checkPermission(this.getUserId(), Long.parseLong((String)node.getModelId()), appId, "bcm_report_list", "47150e89000000ac");
                if (hasviewperm != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u4f53\u7cfb\u7684\u62a5\u8868\u7f16\u5236\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u540e\u91cd\u8bd5\u3002", (String)"MultiTabReportProcess4TaskPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                TreeView tree = (TreeView)this.getControl(TASKTREE);
                String id = this.getCacheCurrentNodeID();
                TaskTreeNode old = (TaskTreeNode)treenode.searchByNodeId(id);
                if (old == null) {
                    old = (TaskTreeNode)treenode.seekChildIf(((ITreeNode)((TaskTreeNode)treenode.getRoot()).getChildren().get(0)).getId(), t -> TaskTypeEnum.PARAM == t.getNodetype());
                }
                if (old != null) {
                    if (old.getParent() != null) {
                        tree.focusNode(new TreeNode(old.getParent().getId(), old.getId(), old.getName()));
                        tree.treeNodeClick(old.getParent().getId(), old.getId());
                    } else {
                        tree.focusNode(new TreeNode(null, old.getId(), old.getName()));
                        tree.treeNodeClick(null, old.getId());
                    }
                }
                return;
            }
        }
        switch (type) {
            case ROOT: {
                List<ComponentInfo> components = this.getTaskExplainInfoByTaskCatalog(catalog);
                if (StringUtils.isNotEmpty((String)catalog.getExplain())) {
                    this.showDescriptonTab(components, EXPLAIN_PAGE, catalog);
                } else {
                    this.showDescriptonTab(this.getTaskParamInfoByTaskCatalogPk(LongUtil.toLong((Object)catalog.getId())), PARAM_PAGE, catalog);
                }
                this.getPageCache().put("startroot", "1");
                this.getPageCache().put("selectnodetype", "1");
                break;
            }
            case EXPLAIN: {
                this.showDescriptonTab(this.getTaskExplainInfoByTaskCatalog(catalog), EXPLAIN_PAGE, catalog);
                this.getPageCache().put("selectnodetype", "1");
                this.getPageCache().put("clicktab", null);
                break;
            }
            case PARAM: {
                this.showDescriptonTab(this.getTaskParamInfoByTaskCatalogPk(LongUtil.toLong((Object)catalog.getId())), PARAM_PAGE, catalog);
                this.getPageCache().put("selectnodetype", "1");
                this.getPageCache().put("clicktab", null);
                break;
            }
            case ORG_DISPLAY: 
            case LABEL: {
                p = t -> TaskTypeEnum.REPORT == t.getNodetype();
                node = (TaskTreeNode)treenode.seekChildIf(nodeId, (Predicate)p);
                orgid = Long.parseLong((String)node.getOrgId());
                taskid = Long.parseLong((String)node.getTaskId());
                pm = (ReportPostmanByEntity)node.getData();
                TaskTreeBulider.addReportIdToPair(pm);
                this.getPageCache().put("orgid", String.valueOf(orgid));
                this.getPageCache().put("taskid", String.valueOf(taskid));
                this.showFinOrNotFinReport(pm);
                break;
            }
            case REPORT: {
                orgid = Long.parseLong((String)node.getOrgId());
                taskid = Long.parseLong((String)node.getTaskId());
                this.getPageCache().put("orgid", String.valueOf(orgid));
                this.getPageCache().put("taskid", String.valueOf(taskid));
                TaskTreeBulider.addReportIdToPair(pm);
                this.showFinReport(pm);
                break;
            }
            case UNFITASK: {
                orgid = Long.parseLong((String)node.getOrgId());
                taskid = Long.parseLong((String)node.getTaskId());
                this.getPageCache().put("orgid", String.valueOf(orgid));
                this.getPageCache().put("taskid", String.valueOf(taskid));
                this.showNotFinReport(pm);
                break;
            }
        }
        this.taskOperateButton(orgid, taskid);
        this.getPageCache().put("current_node_id", evt.getNodeId().toString());
    }

    private void taskOperateButton(long orgid, long taskid) {
        Boolean taskStatus = MyTaskTreeUtil.getTaskStausIsCompleteForLong(orgid, taskid);
        if (taskStatus != null) {
            this.getView().setEnable(Boolean.valueOf(taskStatus == false), new String[]{BTN_ALLTASK_COMPLETED});
            this.getView().setEnable(taskStatus, new String[]{BTN_ALLTASK_UNCOMPLETED});
        } else if (this.getPageCache().get("clicktab") == null) {
            if (this.getPageCache().get("selectnodetype") != null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_COMPLETED, BTN_ALLTASK_UNCOMPLETED});
            } else {
                this.setEnbleBtnByChangeTab();
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_COMPLETED, BTN_ALLTASK_UNCOMPLETED});
        }
        this.getPageCache().put("startroot", null);
        this.getPageCache().put("selectnodetype", null);
        this.getPageCache().put("clicktab", null);
        this.getPageCache().put("defaulttaskid", null);
    }

    private void showFinOrNotFinReport(ReportPostmanByEntity pm) {
        if (TemplateServiceHelper.isNotFinTemplate((Object)pm.getTemplatePK(pm.getPairs().get(0)))) {
            this.getPageCache().put("tasktype", String.valueOf(TaskTypeEnum.UNFITASK.getValue()));
            this.showNotFinReport(pm);
        } else {
            this.showFinReport(pm);
        }
    }

    private boolean isSameReportPostman(String clickNodeId, TreeModel<TaskTreeNode> treenode) {
        String preNodeId = this.getCacheCurrentNodeID();
        TaskTreeNode clicknode = (TaskTreeNode)treenode.searchByNodeId(clickNodeId);
        TaskTreeNode prenode = (TaskTreeNode)treenode.searchByNodeId(preNodeId);
        if (prenode == null) {
            return false;
        }
        if (TaskTypeEnum.ORG_DISPLAY == clicknode.getNodetype() || TaskTypeEnum.LABEL == clicknode.getNodetype()) {
            clicknode = (TaskTreeNode)treenode.seekChildIf(clickNodeId, t -> TaskTypeEnum.REPORT == t.getNodetype());
        }
        if (TaskTypeEnum.ORG_DISPLAY == prenode.getNodetype() || TaskTypeEnum.LABEL == prenode.getNodetype()) {
            prenode = (TaskTreeNode)treenode.seekChildIf(preNodeId, t -> TaskTypeEnum.REPORT == t.getNodetype());
        }
        if (StringUtils.isNotEmpty((String)preNodeId) && clicknode.getData() != null && prenode.getData() != null) {
            return ((ReportPostmanByEntity)clicknode.getData()).equals(prenode.getData());
        }
        return false;
    }

    private String getCacheCurrentNodeID() {
        return this.getPageCache().get("current_node_id");
    }

    private boolean isClickedTheSameNode(TreeNodeEvent evt) {
        return evt.getNodeId().toString().equals(this.getCacheCurrentNodeID());
    }

    private void showDescriptonTab(List<ComponentInfo> components, String activeTabKey, TaskCataLog catalog) {
        this.cacheDescriptionTabTaskPK(catalog);
        this.buildDescriptionTabPage();
        this.doBuildTabDisplayComponent(components);
        this.getDescriptionTab().activeTab(activeTabKey);
        this.switchVisible(false);
    }

    private void showFinReport(ReportPostmanByEntity pm) {
        this.switchVisible(true);
        this.getView().updateView("multrptpanel");
        this.getPageCache().remove("KEY_MODEL_ID");
        this.initReportTabEnv(pm);
        this.setDescriptionTabIsVisibleFlag(false);
    }

    private void showNotFinReport(ReportPostmanByEntity pm) {
        if (pm.getPairs().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6a21\u677fPK\u3002", (String)"MultiTabReportProcess4TaskPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getTemplatePK(pm.getPairs().get(0)))});
        this.doBuildTabPage(Collections.singletonList(Pair.onePair((Object)NOTFIN_PAGE, (Object)template.getString("name"))));
        List<ComponentInfo> components = super.getNotFinInfoByPostman(pm);
        this.doBuildTabDisplayComponent(components);
        this.getPageCache().put("bindCtrl", this.toByteSerialized(components));
        this.switchVisible(false);
        this.setItemvisible(this.nofinToolbarItemList(), true);
        Tab tab = (Tab)this.getControl(DESCRIPTION_TAB);
        tab.activeTab(NOTFIN_PAGE);
        this.getPageCache().put("notFinPostman", this.toByteSerialized(pm));
        this.initBtnState();
        this.initReportTabEnv(pm);
    }

    @Override
    protected void setPageComponentEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_entitymembertree"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_fymembertree"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_periodmembertree"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_scenemembertree"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_currencymembertree"});
    }

    private void cacheDescriptionTabTaskPK(TaskCataLog catalog) {
        JSONObject map = new JSONObject();
        if (catalog.isIsshowexplain()) {
            map.put(EXPLAIN_PAGE, (Object)catalog.getId());
        }
        map.put(PARAM_PAGE, (Object)catalog.getId());
        this.getPageCache().put(TASKPKCACHE_KEY, map.toJSONString());
    }

    private void buildDescriptionTabPage() {
        if (this.isVisibleDescriptionTab()) {
            return;
        }
        String serial = this.getPageCache().get(TASKPKCACHE_KEY);
        boolean isExistExplainTask = false;
        if (StringUtils.isNotEmpty((String)serial)) {
            JSONObject map = JSONObject.parseObject((String)serial);
            isExistExplainTask = map.containsKey((Object)EXPLAIN_PAGE);
        }
        ArrayList tabs = isExistExplainTask ? Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)EXPLAIN_PAGE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"MultiTabReportProcess4TaskPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), Pair.onePair((Object)PARAM_PAGE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u53c2\u6570", (String)"MultiTabReportProcess4TaskPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]))}) : Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)PARAM_PAGE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u53c2\u6570", (String)"MultiTabReportProcess4TaskPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]))});
        this.doBuildTabPage(tabs);
    }

    private void doBuildTabPage(List<Pair<String, String>> tabInfos) {
        TabAp tabap = new TabAp();
        tabap.setKey(DESCRIPTION_TAB);
        tabap.setName(new LocaleString(DESCRIPTION_TAB));
        tabap.setGrow(0);
        for (Pair<String, String> tab : tabInfos) {
            TabPageAp page = new TabPageAp();
            page.setKey((String)tab.p1);
            page.setName(new LocaleString((String)tab.p2));
            tabap.getItems().add(page);
        }
        this.getView().updateControlMetadata(DESCRIPTION_TAB, tabap.createControl());
        this.setDescriptionTabIsVisibleFlag(true);
    }

    private void setDescriptionTabIsVisibleFlag(Boolean isvisible) {
        this.getPageCache().put(ISVISIBLE_FLAG, isvisible.toString());
    }

    private boolean isVisibleDescriptionTab() {
        String flag = this.getPageCache().get(ISVISIBLE_FLAG);
        if (StringUtils.isNotEmpty((String)flag)) {
            return Boolean.parseBoolean(flag);
        }
        return false;
    }

    private void doBuildTabDisplayComponent(List<ComponentInfo> components) {
        FlexPanelAp displaypanel = new FlexPanelAp();
        displaypanel.setKey("displaypanel");
        displaypanel.setDirection("row");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("1px");
        margin.setTop("3px");
        style.setMargin(margin);
        displaypanel.setHeight(new LocaleString("100%"));
        displaypanel.setWidth(new LocaleString("100%"));
        displaypanel.setStyle(style);
        components.forEach(e -> {
            switch (e.type) {
                case LABEL: {
                    DataEntityUtils.addField2Panel((ContainerAp)displaypanel, TextField.class, (String)e.key, (String)e.name, (boolean)true);
                    break;
                }
                case TEXTAREA: {
                    EntryFieldAp entryField = DataEntityUtils.addField2Panel((ContainerAp)displaypanel, TextAreaField.class, (String)e.key, (String)e.name, (boolean)true);
                    entryField.setTextAlign("left");
                    entryField.setFieldTextAlign("left");
                    ((TextAreaField)entryField.getField()).setMaxLength(2000);
                    entryField.setHeight(new LocaleString("680px"));
                    entryField.setWidth(new LocaleString("99%"));
                    entryField.setShowTitle(false);
                    entryField.setFieldStyle(2);
                    displaypanel.setDirection("column");
                    break;
                }
                case F7: {
                    DataEntityUtils.addF72Panel((ContainerAp)displaypanel, (String)e.key, (String)e.name, (String)e.entityNum, (boolean)true);
                    break;
                }
                case RICHTXT: {
                    RichTextEditorAp richAp = new RichTextEditorAp();
                    richAp.setKey(e.key);
                    richAp.setName(new LocaleString(e.name));
                    displaypanel.setDirection("column");
                    displaypanel.getItems().add(richAp);
                    break;
                }
            }
        });
        Map features = displaypanel.createControl();
        if (!components.stream().anyMatch(p -> p.type == ComponentType.RICHTXT)) {
            features.put("dr", "row");
        }
        this.getView().updateControlMetadata("displaypanel", features);
        this.bindCtrl(components, true);
        this.getView().updateView("displaypanel");
    }

    private void initBindCtrl() {
        List components;
        String bindCtrl = this.getPageCache().get("bindCtrl");
        List list = components = StringUtils.isNotEmpty((String)bindCtrl) ? (List)this.deSerializedBytes(bindCtrl) : null;
        if (components != null) {
            this.bindCtrl(components, false);
        }
    }

    private void bindCtrl(List<ComponentInfo> components, boolean isInitVal) {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        components.forEach(e -> {
            if (!props.containsKey((Object)e.key)) {
                if (ComponentType.F7 == e.type) {
                    DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("displaypanel")), (MainEntityType)mainEntityType, (String)e.key, (String)e.entityNum, (IDataModel)this.getModel(), (IFormView)this.getView());
                } else {
                    DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl("displaypanel")), (MainEntityType)mainEntityType, (String)e.key, (IDataModel)this.getModel(), (IFormView)this.getView());
                }
            }
            if (isInitVal) {
                this.getModel().setValue(e.key, e.val);
            }
        });
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().equals("notfininfo")) {
            TextEdit editor = new TextEdit();
            editor.setKey(e.getKey());
            editor.setView(this.getView());
            editor.setModel(this.getModel());
            e.setControl((Control)editor);
        }
    }

    private List<ComponentInfo> getTaskExplainInfoByTaskCatalogPk(Object pk) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"bcm_taskexplain", (String)"id,text", (QFilter[])new QFilter[]{new QFilter("taskcatalog.id", "=", pk)});
        if (dyna != null) {
            ComponentInfo explain = new ComponentInfo("explain_txt", ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"MultiTabReportProcess4TaskPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), ComponentType.TEXTAREA, dyna.getString("text"));
            components.add(explain);
        }
        return components;
    }

    private List<ComponentInfo> getTaskExplainInfoByTaskCatalog(TaskCataLog catalog) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        ComponentInfo explain = new ComponentInfo("explain_txt", ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"MultiTabReportProcess4TaskPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), ComponentType.TEXTAREA, catalog.getExplain());
        components.add(explain);
        return components;
    }

    private List<ComponentInfo> getTaskParamInfoByTaskCatalogPk(Object pk) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamNameSelector(), (QFilter[])new QFilter[]{new QFilter("taskcatalog.id", "=", pk)});
        if (dyna != null) {
            ComponentInfo year = new ComponentInfo("year_txt", dyna.getString("year.dimension.name"), ComponentType.LABEL, dyna.getString("year.name"));
            components.add(year);
            ComponentInfo period = new ComponentInfo("period_txt", dyna.getString("period.dimension.name"), ComponentType.LABEL, dyna.getString("period.name"));
            components.add(period);
            ComponentInfo scenario = new ComponentInfo("scenario_txt", dyna.getString("scenario.dimension.name"), ComponentType.LABEL, dyna.getString("scenario.name"));
            components.add(scenario);
            ComponentInfo currency = new ComponentInfo("currency_txt", dyna.getString("currency.dimension.name"), ComponentType.LABEL, dyna.getString("currency.name"));
            components.add(currency);
        }
        return components;
    }

    private void switchVisible(boolean rptPanelVisible) {
        this.getView().setVisible(Boolean.valueOf(!rptPanelVisible), new String[]{"multtabdesppanel"});
        this.getView().setVisible(Boolean.valueOf(rptPanelVisible), new String[]{"multrptpanel"});
        this.setItemvisible(this.enableToolbarItemList(), rptPanelVisible);
        this.cacheIsRptTabVisible(rptPanelVisible);
    }

    private void setItemvisible(String[] items, boolean isVisible) {
        if (isVisible) {
            this.visibleBtn(items);
        } else {
            this.hideBtn(items);
        }
    }

    private String[] enableToolbarItemList() {
        return new String[]{"btn_taskcompleted", "btn_taskuncompleted", "btn_batchtaskoprt", "btn_batchoprt", "btn_complete", "btn_allcomplete", "btn_weaving", "btn_allweaving", "btn_save", "btn_commit", "btn_allcommit", "btn_back", "btn_allback", "btn_check", "btn_calculate", "btn_checkup", "btn_checkresult", "btn_selectdynaitem", "btn_postil", "btn_more", "btn_more_normal", "print", "import", "export", "history", "editdescription", "btn_datacollect", "btn_convert"};
    }

    private String[] nofinToolbarItemList() {
        return new String[]{"btn_save", "btn_complete", "btn_weaving", "btn_commit", "btn_back"};
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isMockCreateNewData()) {
            return;
        }
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        Tab statustab = (Tab)this.getControl("statustab");
        if (status != null) {
            if (status.contains(HASOVERDUE) && status.contains(UNOVERDUE) && status.contains(FINISH)) {
                this.getPageCache().put(FILTER_CACHE, ALL);
                this.getPageCache().put("isalreadyRefreshTree", "true");
                statustab.activeTab("status_all");
            } else if (status.contains(HASOVERDUE) || status.contains(UNOVERDUE) || status.contains(COMINGOVERDUE)) {
                this.getPageCache().put(FILTER_CACHE, UNCOMPLETE);
            } else {
                this.getPageCache().put(FILTER_CACHE, COMPLETE);
                this.getPageCache().put("isalreadyRefreshTree", "true");
                statustab.activeTab("status_complete");
            }
        } else {
            this.getPageCache().put(FILTER_CACHE, UNCOMPLETE);
        }
        this.refreshTaskTree();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String opkey = evt.getItemKey();
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permitem.get(this.getView().getEntityId());
        if (map == null || map.get(opkey) == null) {
            return;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return;
        }
        int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId(), perm[0], perm[1]);
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"MultiTabReportProcess4TaskPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u9700\u8981\u8be5\u529f\u80fd\u3002", (String)"MultiTabReportProcess4TaskPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if ("btn_checkup".equals(itemKey)) {
            this.actionCheckUpChk(true);
        } else if ("btn_checkresult".equals(itemKey)) {
            this.openChkReport();
        } else if ("query_export".equals(itemKey) || "export".equals(itemKey)) {
            this.invokeExportEvent(this.getView().getEntityId());
        }
    }

    @Override
    protected boolean doTaskCheck(String key) {
        boolean result = true;
        String orgid = this.getPageCache().get("orgid");
        String taskid = this.getPageCache().get("taskid");
        result = MyTaskTreeUtil.doCheck(key, Long.valueOf(taskid), Long.valueOf(orgid));
        if (!result) {
            if ("itemmark".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6709\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\u3002", (String)"MultiTabReportProcess4TaskPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6709\u540e\u7f6e\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\u3002", (String)"MultiTabReportProcess4TaskPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        return result;
    }

    @Override
    public void refreshTaskTree() {
        String combo = this.getPageCache().get(FILTER_CACHE);
        Boolean isoverdue = combo == null ? false : combo.contains(UNCOMPLETE) || combo.contains(ALL);
        Boolean issoondue = combo == null ? false : combo.contains(UNCOMPLETE) || combo.contains(ALL);
        Boolean isundue = combo == null ? false : combo.contains(UNCOMPLETE) || combo.contains(ALL);
        Boolean iscomplete = combo == null ? false : combo.contains(COMPLETE) || combo.contains(ALL);
        TaskTreeBulider tb = TaskTreeBulider.toTreeModel(this.getPageCache());
        TaskTreeNode root = tb.initTree(String.valueOf(this.getUserId()), isoverdue, issoondue, isundue, iscomplete, false, ModelUtil.queryApp((IFormView)this.getView()));
        tb.cache2page(this.getPageCache());
        TreeModel model = new TreeModel((ITreeNode)root);
        TreeView tree = (TreeView)this.getControl(TASKTREE);
        model.buildEntryTree(tree);
        model.cache2page(this.getPageCache());
        this.updateNumberBystatus((TreeModel<TaskTreeNode>)model);
        if (root.getChildren().isEmpty()) {
            this.setItemvisible(this.enableToolbarItemList(), false);
            this.buildBlankPanel(root.getId());
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_UNCOMPLETED});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ALLTASK_COMPLETED});
        }
        if (this.getView().getFormShowParameter().getCustomParam("rootid") != null) {
            this.focusNode(root, tree);
        } else if (root.getChildren() != null && !root.getChildren().isEmpty() && root.getChildren().get(0) != null) {
            TaskTreeNode node = (TaskTreeNode)model.seekChildIf(((ITreeNode)root.getChildren().get(0)).getId(), t -> TaskTypeEnum.REPORT == t.getNodetype());
            if (node == null) {
                node = (TaskTreeNode)model.seekChildIf(((ITreeNode)root.getChildren().get(0)).getId(), t -> TaskTypeEnum.PARAM == t.getNodetype());
            }
            TaskTreeNode parent = (TaskTreeNode)node.getParent();
            while (TaskTypeEnum.VIRTUAL != parent.getNodetype()) {
                tree.expand(parent.getId());
                parent = (TaskTreeNode)parent.getParent();
            }
            tree.focusNode(new TreeNode(node.getParent().getId(), node.getId(), node.getName()));
            tree.treeNodeClick(node.getParent().getId(), node.getId());
        } else if (this.isTrueFlagInCache("is_modify")) {
            this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316,\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u62a5\u8868\uff1f", (String)"MultiTabReportProcess4TaskPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), CALLBACK_CLICK_STATUSTAB);
        }
    }

    private void openChkReport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setParentPageId(this.getView().getParentView().getPageId());
        showParameter.setFormId("bcm_chkspeechlist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void updateNumberBystatus(TreeModel<TaskTreeNode> model) {
        Map map = model.getDict();
        int tasknumber = 0;
        int reportnumber = 0;
        for (Map.Entry entry : map.entrySet()) {
            TaskTreeNode node = (TaskTreeNode)((Object)entry.getValue());
            TaskTypeEnum tasktype = node.getNodetype();
            switch (tasktype) {
                case REPORT: {
                    ++tasknumber;
                    ReportPostmanByEntity rbe = (ReportPostmanByEntity)node.getData();
                    reportnumber += rbe.getPairs().size();
                    break;
                }
                case UNFITASK: {
                    ++tasknumber;
                    ++reportnumber;
                    break;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(tasknumber).append(ResManager.loadKDString((String)"\u4e2a\u4efb\u52a1/", (String)"MultiTabReportProcess4TaskPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])).append(reportnumber).append(ResManager.loadKDString((String)"\u5f20\u62a5\u8868)", (String)"MultiTabReportProcess4TaskPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        this.getPageCache().put("tasknumber", String.valueOf(tasknumber));
        this.getPageCache().put("reportnumber", String.valueOf(reportnumber));
        Label label = (Label)this.getControl("label_tips");
        label.setText(sb.toString());
    }

    private void focusNode(TaskTreeNode root, TreeView tree) {
        int tasktype = (Integer)this.getView().getFormShowParameter().getCustomParam("tasktype");
        Long rootid = (Long)this.getView().getFormShowParameter().getCustomParam("rootid");
        this.getView().getFormShowParameter().getCustomParams().remove("rootid");
        this.getView().cacheFormShowParameter();
        Long orgid = (Long)this.getView().getFormShowParameter().getCustomParam("orgid");
        String treenodekey = null;
        switch (tasktype) {
            case 0: {
                treenodekey = String.valueOf(rootid);
                break;
            }
            case 2: {
                treenodekey = rootid + "_explain";
                break;
            }
            case 1: {
                treenodekey = rootid + "_param";
                break;
            }
            case 100: {
                treenodekey = rootid + "_" + orgid;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Long taskid = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
                Long tempid = (Long)this.getView().getFormShowParameter().getCustomParam("tempid");
                treenodekey = orgid + "_" + taskid;
                if (tempid == null) break;
            }
        }
        TaskTreeNode node = (TaskTreeNode)TreeModel.toTreeModel((IPageCache)this.getPageCache()).searchByNodeId(treenodekey);
        if (node != null) {
            TaskTreeNode parent = (TaskTreeNode)node.getParent();
            while (TaskTypeEnum.VIRTUAL != parent.getNodetype()) {
                tree.expand(parent.getId());
                parent = (TaskTreeNode)parent.getParent();
            }
            tree.focusNode(new TreeNode(node.getParent().getId(), node.getId(), node.getName()));
            tree.treeNodeClick(node.getParent().getId(), node.getId());
        }
    }

    @Override
    protected void buildBlankPanel(String nodeId) {
        this.doBuildTabDisplayComponent(new ArrayList<ComponentInfo>());
        this.getPageCache().put("current_node_id", nodeId);
        this.switchVisible(false);
        TabAp tabap = new TabAp();
        tabap.setKey(DESCRIPTION_TAB);
        tabap.setName(new LocaleString(DESCRIPTION_TAB));
        tabap.setGrow(0);
        TabPageAp page = new TabPageAp();
        page.setKey("nopage");
        page.setName(new LocaleString(ResManager.loadKDString((String)"\u65e0\u4efb\u52a1", (String)"MultiTabReportProcess4TaskPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
        tabap.getItems().add(page);
        Map features = tabap.createControl();
        this.getView().updateControlMetadata(DESCRIPTION_TAB, features);
    }

    @Override
    public void actionSave() {
        super.actionSave();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
    }

    @Override
    public long getModelId() {
        return (Long)ThreadCache.get((Object)"taskmodelid", () -> {
            try {
                return super.getModelId();
            }
            catch (Exception e) {
                return 0L;
            }
        });
    }

    protected static enum ComponentType {
        LABEL,
        F7,
        TEXTAREA,
        RICHTXT;

    }
}

