/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanFactory;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class MultiTabReportProcessPlugin
extends AbstractMultiReportPlugin {
    @Override
    public void initialize() {
        super.initialize();
        if (StringUtil.isEmptyString((String)((String)this.getView().getFormShowParameter().getCustomParam("processtype")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"linkquery", "linkgl", "linkdetailaccount", "linkvoucher", "btn_datacollect"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    protected boolean willExecuteBizRule() {
        return super.willExecuteBizRule();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtil.equals((String)evt.getItemKey(), (String)"btn_copyhis")) {
            super.setRefreshListFlag();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isMockCreateNewData()) {
            return;
        }
        String postmanSerial = (String)this.getFormCustomParam("reportpostman");
        if (StringUtils.isEmpty((String)postmanSerial)) {
            throw new KDBizException("not found ReportPostman Info!");
        }
        AbstractReportPostman postman = (AbstractReportPostman)this.deSerializedBytes(postmanSerial);
        this.initReportTabEnv(postman);
        this.registerFormula();
        if (ApplicationTypeEnum.RPT.appnum.equals(this.getBizAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_schemecollect"});
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map cp = e.getFormShowParameter().getCustomParams();
        if (!cp.containsKey("reportpostman") && cp.containsKey("reportId")) {
            long reportid = Long.parseLong(cp.get("reportId").toString());
            DynamicObject report = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"entity.id,scene.id,fyear.id,period.id,currency.id,model.id,template.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportid)});
            if (report == null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u6253\u5f00\u3002", (String)"MultiTabReportProcessPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), reportid));
                return;
            }
            AbstractReportPostman postman = ReportPostmanFactory.getReportPostman(true, report);
            postman.addPair(report.get("template.id"), reportid);
            cp.put("reportpostman", this.toByteSerialized(postman));
        }
    }

    @Override
    protected void setPageComponentEnable() {
        if (!this.isVarDimension("bcm_entitymembertree")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_entitymembertree"});
        }
    }

    @Override
    protected boolean isCsl() {
        return false;
    }

    @Override
    protected void initBtnState() {
        boolean isReadOnlyByOrgVersioning = this.isReadOnlyByOrgVersioning();
        String isOnlyQuery = (String)this.getView().getFormShowParameter().getCustomParam("isonlyquery");
        if ("true".equals(isOnlyQuery)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
            this.setBtnVisible(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_datacollect", "btn_mergesum"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_refresh", "query_export"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"query_export"});
            if (isReadOnlyByOrgVersioning) {
                this.setBtnVisible(false);
            } else {
                super.initBtnState();
            }
        }
        if (this.isRPT()) {
            this.hideBtn("btn_mergeext");
        }
        AbstractMultiReportPlugin.OrgFlowArchiveStatus orgCommit2Archive = this.checkECSubmitStatus();
        if (orgCommit2Archive.isFlowCommit || orgCommit2Archive.isFlowArchive || orgCommit2Archive.isStageArchive) {
            this.hideBtn("btn_mergeext");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_complete", "btn_datacollect", "btn_weaving", "btn_commit", "btn_back", "btn_copyhis", "btn_batchoprt", "btn_calculate", "btn_ybcarried"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_mergesum"});
        }
        this.hideLinkQueryBtn();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_exec_bizrule"});
        GuidePageUtils.afterCreateNewData4Rpt(this.getView());
    }

    private void setBtnVisible(boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"btn_save", "btn_complete", "btn_datacollect", "btn_weaving", "btn_commit", "btn_back", "btn_copyhis", "btn_batchoprt", "btn_calculate", "btn_more_normal", "btn_convert"});
    }

    @Override
    public void actionSave() {
        super.actionSave();
    }

    @Override
    protected void afterLoadReport() {
        super.afterLoadReport();
        this.setICMemeberBackgroundColor();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.setICMemeberBackgroundColor();
    }

    private void registerFormula() {
        this.registerGetAttrFormula();
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
    }

    private void registerGetAttrFormula() {
        this.registerFormular("get_dim_attr");
        this.registerFormular("getjlentry");
    }

    private void registerFormular(String formulaStr) {
        Formula f = ResourcesLoaderUtil.getFormulaByNumber((String)formulaStr);
        HashMap<String, Object> formula = new HashMap<String, Object>();
        formula.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), f.getNumber());
        formula.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), f.getParam().size());
        formula.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), f.getName());
        description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), f.getParam());
        formula.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
        SpreadClientInvoker.invokeRegisterCustomFormulaMethod(this.getClientViewProxy(), "report", Lists.newArrayList((Object[])new Map[]{formula}));
    }
}

