/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.integration.RpaIniFileEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.util.TurnSystem26Util;
import kd.fi.bcm.formplugin.intergration.vo.MergeIniFileModel;
import kd.fi.bcm.formplugin.report.ExportServiceConstructor;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.ExportGCExcelCache;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.FloatAreaInfo;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.formplugin.report.export.ReportExportOneFileTaskService;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import kd.fi.bcm.formplugin.report.export.SpreadJSExportModel;
import kd.fi.bcm.formplugin.report.export.TempReportInfo;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatLogicImpl;
import kd.fi.bcm.formplugin.report.util.ExcutorAdjustHelper;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.formplugin.report.util.SXSSFUtil;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.util.POIUtil;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;

public class NewReportMultiExportService
extends ReportMultiExportService {
    public static final String TAB_STRIP_VISIBLE = "tabStripVisible";
    public static final String SHEETS = "sheets";
    public static final String ROW_FILTER = "rowFilter";
    public static final String VALIDATIONS = "validations";
    public static final String COLUMNS = "columns";
    public static final String ROWS = "rows";
    public static final String PRINT_INFO = "printInfo";
    public static final String SIZE = "size";
    protected List<String> fileUrls = new ArrayList<String>(16);
    TempFileCache cache;
    public XSSFWorkbook cache_wb;
    Map<Object, Short> stylesByWB = new HashMap<Object, Short>(16);

    public NewReportMultiExportService() {
    }

    public NewReportMultiExportService(TempReportInfo tempReportInfo) {
        super(tempReportInfo);
        this.numbers = FormulaConfig.getInstance().getFormulaNumberSet();
    }

    @Override
    public void initService() {
        super.initService();
        this.excelCache = ExportGCExcelCache.getExportGCExcelCache(this);
        this.numbers = FormulaConfig.getInstance().getFormulaNumberSet();
    }

    @Override
    public SXSSFWorkbook addSheet2JSONWorkBook(SheetInfo sheetInfo, String spreadjson, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, OutputStream out, SXSSFWorkbook allSheetBook) {
        this.dealProgress(false);
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        try {
            XSSFWorkbook xssfWorkbook = this.getXssfWorkbook(sheetInfo, spreadjson, cellValues);
            if (xssfWorkbook == null) {
                return allSheetBook;
            }
            return this.writeJson(xssfWorkbook, allSheetBook, sheetInfo);
        }
        catch (Exception e) {
            log.error(sheetInfo.getFileName() + ":" + sheetInfo.getSheetName() + ":dealWorkBook:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            return allSheetBook;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HSSFWorkbook addSheet2JSONWorkBook(SheetInfo sheetInfo, String spreadjson, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, OutputStream out, HSSFWorkbook allSheetBook) {
        this.dealProgress(false);
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        XSSFWorkbook xssfWorkbook = null;
        try {
            xssfWorkbook = this.getXssfWorkbook(sheetInfo, spreadjson, cellValues);
            if (xssfWorkbook == null) {
                HSSFWorkbook hSSFWorkbook = allSheetBook;
                return hSSFWorkbook;
            }
            HSSFWorkbook hSSFWorkbook = this.writeJson(xssfWorkbook, allSheetBook, sheetInfo);
            return hSSFWorkbook;
        }
        catch (Exception e) {
            log.error(sheetInfo.getFileName() + ":" + sheetInfo.getSheetName() + ":dealWorkBook:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        finally {
            if (xssfWorkbook != null) {
                try {
                    xssfWorkbook.close();
                }
                catch (IOException e) {
                    log.warn("\u5bfc\u51fa2003\u7248\u672cExcel\u6587\u4ef6\u5173\u95edxssfWorkbook\u8f93\u51fa\u6d41\u5931\u8d25" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
            }
        }
        return allSheetBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSSFWorkbook getXssfWorkbook(SheetInfo sheetInfo, String spreadjson, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) throws Exception {
        int freeRow = 0;
        int freecol = 0;
        JSONArray columns = new JSONArray();
        JSONArray rows = new JSONArray();
        String pdfURL = null;
        if (this.excelCache.getCacheRptTmpJSURL().get(this.currentRptId + "") == null || StringUtils.isEmpty((String)this.excelCache.getCacheRptTmpJSURL().get((Object)new StringBuilder().append((long)this.currentRptId).append((String)"").toString()).url)) {
            SpreadJSExportModel jsExportModel;
            ByteArrayOutputStream spreadJsonOut = null;
            try {
                JSONObject sheets;
                jsExportModel = new SpreadJSExportModel(this.currentRptId, 0L, "", columns, rows, freeRow, freecol);
                this.excelCache.getCacheRptTmpJSURL().put(this.currentRptId + "", jsExportModel);
                String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
                JSONObject jsonMap = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
                boolean isChange = false;
                if (jsonMap.get((Object)TAB_STRIP_VISIBLE) == null || !jsonMap.getBoolean(TAB_STRIP_VISIBLE).booleanValue()) {
                    jsonMap.put(TAB_STRIP_VISIBLE, (Object)true);
                    isChange = true;
                }
                if ((sheets = jsonMap.getJSONObject(SHEETS)) != null) {
                    String sheetName = sheetInfo.getSheetName();
                    JSONObject sheetObj = sheets.getJSONObject(sheetName);
                    if (sheetObj == null) {
                        sheetObj = (JSONObject)sheets.values().iterator().next();
                    }
                    if (sheetObj != null) {
                        if (sheetObj.containsKey((Object)ROW_FILTER)) {
                            isChange = true;
                            sheetObj.remove((Object)ROW_FILTER);
                        }
                        if (sheetObj.containsKey((Object)VALIDATIONS)) {
                            isChange = true;
                            sheetObj.remove((Object)VALIDATIONS);
                        }
                        columns = sheetObj.getJSONArray(COLUMNS);
                        rows = sheetObj.getJSONArray(ROWS);
                    }
                }
                try {
                    Workbook gcbook = SpreadUtils.getWorkbook((String)(isChange ? jsonMap.toString() : ssjson));
                    freeRow = gcbook.getActiveSheet().getFreezeRow();
                    freecol = gcbook.getActiveSheet().getFreezeColumn();
                    spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                }
                catch (IllegalArgumentException e) {
                    if (sheets != null) {
                        String sheetName = sheetInfo.getSheetName();
                        try {
                            ((JSONObject)sheets.get((Object)sheetName)).remove((Object)PRINT_INFO);
                        }
                        catch (NullPointerException ne) {
                            for (Map.Entry entry : sheets.entrySet()) {
                                ((JSONObject)entry.getValue()).remove((Object)PRINT_INFO);
                            }
                        }
                    }
                    Workbook gcbook = SpreadUtils.getWorkbook((String)jsonMap.toString());
                    freeRow = gcbook.getActiveSheet().getFreezeRow();
                    freecol = gcbook.getActiveSheet().getFreezeColumn();
                    spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                }
                if (spreadJsonOut == null) {
                    XSSFWorkbook xSSFWorkbook = null;
                    return xSSFWorkbook;
                }
                pdfURL = this.cache.saveAsUrl(sheetInfo.getSheetName() + "." + XSSFWorkbookType.XLSX.getExtension(), spreadJsonOut.toByteArray(), 5000);
            }
            catch (IllegalArgumentException e) {
                log.warn(sheetInfo.getFileName() + ":" + sheetInfo.getSheetName() + ":Style conversion is not supported" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            finally {
                try {
                    if (spreadJsonOut != null) {
                        spreadJsonOut.close();
                    }
                }
                catch (IOException e) {
                    log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
            }
            this.dealProgress(false);
            jsExportModel = new SpreadJSExportModel(this.currentRptId, 0L, pdfURL, columns, rows, freeRow, freecol);
            this.excelCache.getCacheRptTmpJSURL().put(this.currentRptId + "", jsExportModel);
        } else {
            pdfURL = this.excelCache.getCacheRptTmpJSURL().get((Object)new StringBuilder().append((long)this.currentRptId).append((String)"").toString()).url;
        }
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(this.cache.getInputStream(pdfURL));
        xssfWorkbook.setForceFormulaRecalculation(false);
        XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
        if (columns != null && !columns.isEmpty()) {
            for (int i = 0; i < columns.size(); ++i) {
                if (columns.getJSONObject(i) == null || columns.getJSONObject(i).get((Object)SIZE) == null) continue;
                int size = Double.valueOf(columns.getJSONObject(i).get((Object)SIZE).toString()).intValue();
                sheet.setColumnWidth(i, size * 33);
            }
        }
        if (rows != null && !rows.isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                if (rows.getJSONObject(i) == null || rows.getJSONObject(i).get((Object)SIZE) == null) continue;
                int size = Double.valueOf(rows.getJSONObject(i).get((Object)SIZE).toString()).intValue();
                if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isExportAutoSizeColum")) {
                    sheet.autoSizeColumn(i);
                }
                sheet.getRow(i).setHeight((short)(size * 15));
            }
        }
        sheet.createFreezePane(freecol, freeRow);
        this.dealSheetForWp(sheet, cellValues);
        if (ExportPageSourceEnum.WORKPAPER.getIndex() == this.getPageSourceEnum().getIndex()) {
            cellValues = Pair.onePair(new ArrayList(16), (Object)cellValues.p2);
        }
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            if (sheet.getRow(i) != null) continue;
            XSSFRow row = sheet.createRow(i);
            for (int c = 0; c < sheetInfo.getMaxCol(); ++c) {
                row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            }
        }
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isExportMergeUseCellType")) {
            this.setSheetValue(xssfWorkbook, (Pair<List<Map<String, Object>>, List<Map<String, Object>>>)cellValues, sheetInfo);
        } else {
            this.setSheetValue_old(xssfWorkbook, (Pair<List<Map<String, Object>>, List<Map<String, Object>>>)cellValues, sheetInfo);
        }
        this.dealOrgRowStyle(xssfWorkbook);
        return xssfWorkbook;
    }

    private void dealSheetForWp(XSSFSheet sheet, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) {
        if (!this.getJsonChange().isEmpty()) {
            Map<String, Object> jsonChange = this.getJsonChange();
            ArrayList<Integer> cols = new ArrayList(16);
            if (jsonChange.containsKey(SpreadProperties.ContextMenuItemNamesEnum.insertColumns.name()) || jsonChange.containsKey(SpreadProperties.ContextMenuItemNamesEnum.insertRows.name())) {
                cols = (List)jsonChange.get(SpreadProperties.ContextMenuItemNamesEnum.insertColumns.name());
                AtomicInteger i = new AtomicInteger(0);
                Map<Integer, Integer> insertCols = this.getInsertCols(cols);
                Integer maxcol = (Integer)jsonChange.get("maxcol");
                Integer maxRow = (Integer)jsonChange.get("maxRow");
                if (maxRow + 1 < sheet.getLastRowNum()) {
                    maxRow = sheet.getLastRowNum();
                }
                int col = 0;
                for (int j = 0; j < sheet.getLastRowNum(); ++j) {
                    if (sheet.getRow(j) == null) continue;
                    col = sheet.getRow(j).getLastCellNum();
                    break;
                }
                if (maxcol < col) {
                    maxcol = col;
                }
                Integer finalMaxRow = maxRow;
                Integer finalMaxcol = maxcol;
                HashMap<Object, Short> styles = new HashMap<Object, Short>(16);
                CellCopyPolicy copyPolicy = new CellCopyPolicy();
                copyPolicy.setCopyCellValue(false);
                copyPolicy.setCopyMergedRegions(false);
                if (insertCols != null && !insertCols.isEmpty()) {
                    insertCols.forEach((k, v) -> SXSSFUtil.insertCol(sheet, k, v, finalMaxRow, finalMaxcol, styles));
                }
                Integer inserRows = (Integer)jsonChange.get(SpreadProperties.ContextMenuItemNamesEnum.insertRows.name());
                SXSSFUtil.insertRows(sheet, inserRows, 1, finalMaxRow, finalMaxcol, styles);
                if (insertCols != null && !insertCols.isEmpty()) {
                    SXSSFUtil.addMergedRegion(sheet, insertCols, inserRows);
                }
            }
            List p1 = (List)cellValues.p1;
            SXSSFUtil.updateFormula(p1, sheet);
            cellValues = Pair.onePair(new ArrayList(16), (Object)cellValues.p2);
        }
    }

    private void dealOrgRowStyle(XSSFWorkbook xssfWorkbook) {
        if (!this.getJsonChange().isEmpty()) {
            Map<String, Object> jsonChange = this.getJsonChange();
            Integer insertRows = (Integer)jsonChange.get(SpreadProperties.ContextMenuItemNamesEnum.insertRows.name());
            int startRow = insertRows + 1;
            XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
            List cellRangeAddresses = (List)jsonChange.get(SpreadProperties.SetSpanMethod.SETSPAN.k());
            if (cellRangeAddresses != null && !cellRangeAddresses.isEmpty()) {
                List templateMergedRegions = sheet.getMergedRegions();
                if (!templateMergedRegions.isEmpty()) {
                    ArrayList indices = new ArrayList(16);
                    templateMergedRegions.forEach(tmpMr -> {
                        final String tempMergeRange = this.getRangeStr((CellRangeAddress)tmpMr);
                        if (cellRangeAddresses.stream().anyMatch(new Predicate<CellRangeAddress>(){

                            @Override
                            public boolean test(CellRangeAddress cellAddresses) {
                                String mergeRange = NewReportMultiExportService.this.getRangeStr(cellAddresses);
                                return ExcelUtils.isOverlap((String)tempMergeRange, (String)mergeRange);
                            }
                        })) {
                            indices.add(templateMergedRegions.indexOf(tmpMr));
                        }
                    });
                    if (!indices.isEmpty()) {
                        sheet.removeMergedRegions(indices);
                    }
                }
                cellRangeAddresses.forEach(cellAddresses -> {
                    sheet.addMergedRegionUnsafe(cellAddresses);
                    XSSFCell xssfCell = sheet.getRow(cellAddresses.getFirstRow()).getCell(cellAddresses.getFirstColumn());
                    XSSFCellStyle cellStyle = xssfWorkbook.createCellStyle();
                    if (xssfCell != null) {
                        if (xssfCell.getCellStyle() != null) {
                            POIUtil.copyCellStyle(xssfCell.getCellStyle(), cellStyle);
                        }
                        cellStyle.setWrapText(true);
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        xssfCell.setCellStyle((CellStyle)cellStyle);
                    }
                });
            }
            SXSSFUtil.setOrgRowStyle(xssfWorkbook, startRow);
        }
    }

    private String getRangeStr(CellRangeAddress cellAddresses) {
        String start = ExcelUtils.xy2Pos((int)cellAddresses.getFirstColumn(), (int)cellAddresses.getFirstRow());
        String end = ExcelUtils.xy2Pos((int)cellAddresses.getLastColumn(), (int)cellAddresses.getLastRow());
        return start + ":" + end;
    }

    private Map<Integer, Integer> getInsertCols(List<Integer> cols) {
        if (cols != null && !cols.isEmpty()) {
            LinkedHashMap<Integer, Integer> mergeRegions = new LinkedHashMap<Integer, Integer>(cols.size());
            cols = cols.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            int count = 1;
            for (int i = 0; i < cols.size(); ++i) {
                Integer integer = cols.get(i);
                if (mergeRegions.containsKey(integer)) {
                    mergeRegions.put(integer, ++count);
                    continue;
                }
                count = 1;
                mergeRegions.put(integer, count);
            }
            return mergeRegions;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> doExport_Excels() {
        try {
            if (this.isJQExport) {
                ReportDataSelectScheme rdss = ReportDataSchemeUtil.getReportDataSelectScheme(new SchemeContext(this.getModelId()), "2");
                for (Map.Entry entry : this.reportData2OrgMap.entrySet()) {
                    String reportDataType = (String)entry.getKey();
                    Map<String, DynamicObject> reportData = rdss.searchSchemeByNumber(reportDataType);
                    Set orgIds = (Set)entry.getValue();
                    for (ReportExportInfo pair : this.tempReportInfo.getExportInfos()) {
                        String[] info;
                        String v;
                        Iterator<String> iterator;
                        ReportExportInfo newPair = new ReportExportInfo(new ArrayList<String>(pair.getUnweavings()), new HashMap<String, DynamicObject>(pair.getWeavings()), pair.getFilterAnalyiers());
                        if (newPair.getUnweavings() != null) {
                            iterator = newPair.getUnweavings().iterator();
                            while (iterator.hasNext()) {
                                v = iterator.next();
                                info = v.split("\\|");
                                if (orgIds.contains(info[2])) continue;
                                iterator.remove();
                            }
                        }
                        if (newPair.getWeavings() != null) {
                            iterator = newPair.getWeavings().keySet().iterator();
                            while (iterator.hasNext()) {
                                v = iterator.next();
                                info = v.split("\\|");
                                if (orgIds.contains(info[2])) continue;
                                iterator.remove();
                            }
                        }
                        if (newPair.getUnWeavingSize() == 0 && newPair.getWeavingSize() == 0) continue;
                        newPair.setReportDataType(reportDataType);
                        ReportExportOneFileTaskService fileTaskService = new ReportExportOneFileTaskService();
                        ExportServiceConstructor.buildService((ReportMultiExportService)this, fileTaskService);
                        fileTaskService.setDimNum2Items(reportData);
                        fileTaskService.processMap.clear();
                        DynamicObject process = reportData.get("Process");
                        fileTaskService.processMap.put(process.getString("number"), process);
                        fileTaskService.process = process;
                        fileTaskService.audittrial = reportData.get("AuditTrail");
                        if (reportData.get("Currency") != null) {
                            fileTaskService.cyDy = reportData.get("Currency");
                            fileTaskService.setCyObj_view(reportData.get("Currency"));
                        }
                        fileTaskService.fileContext = new ReportMultiExportService.FileContext();
                        fileTaskService.sheetName2Name = HashMultimap.create();
                        fileTaskService.doExport_Excel(newPair);
                    }
                }
            } else {
                for (ReportExportInfo pair : this.tempReportInfo.getExportInfos()) {
                    if (pair.getUnWeavingSize() == 0 && pair.getWeavingSize() == 0) continue;
                    this.currentFileInfo = pair;
                    ReportExportOneFileTaskService fileTaskService = new ReportExportOneFileTaskService();
                    ExportServiceConstructor.buildService((ReportMultiExportService)this, fileTaskService);
                    fileTaskService.fileContext = new ReportMultiExportService.FileContext();
                    fileTaskService.sheetName2Name = HashMultimap.create();
                    fileTaskService.doExport_Excel(pair);
                }
            }
        }
        catch (Exception e) {
            log.warn(this.getClass().toString() + ":" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        finally {
            if (this.tempReportInfo == null) {
                if (this.getTaskConsumer() != null) {
                    this.getTaskConsumer().accept(100);
                }
            } else {
                this.setCompleteSheet(new AtomicInteger(this.tempReportInfo.getSize()));
            }
            if (this.getTaskConsumer() != null) {
                this.getTaskConsumer().accept(100);
            }
        }
        return this.fileUrls;
    }

    @Override
    public List<String> doMultiExport_IniFile() throws UnsupportedEncodingException {
        MergeIniFileModel mergeModel = new MergeIniFileModel();
        this.fileNm2OrgMap.forEach((k, v) -> {
            try {
                String url = this.exportINIFile((String)k, (String)v, this.isSchemeId, mergeModel);
                if (url == null) {
                    return;
                }
                this.fileUrls.add(url);
                this.fileNm2UrlMap.put(v + ".ini", url);
            }
            catch (UnsupportedEncodingException e) {
                log.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        });
        if (this.isMergeINI) {
            String name = this.zipFileName;
            String url = this.mergeIniFile(name, mergeModel);
            this.fileUrls.add(url);
            this.fileNm2UrlMap.put(name + ".ini", url);
        }
        return this.fileUrls;
    }

    public Map<String, Pair<String, String>> getSrcOrg2JQCodeType() {
        HashMap<String, Pair<String, String>> src2JQCodeTypes = new HashMap<String, Pair<String, String>>(16);
        QFBuilder qfBuilder = new QFBuilder("schemeid", "=", (Object)this.getIsSchemeId());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"srcmembnumber,targmembnumber,srcreporttype", (QFilter[])qfBuilder.toArray());
        for (DynamicObject dy : doc) {
            src2JQCodeTypes.put(dy.getString("targmembnumber"), (Pair<String, String>)Pair.onePair((Object)dy.getString("srcmembnumber"), (Object)dy.getString("srcreporttype")));
        }
        return src2JQCodeTypes;
    }

    public Table<String, String, List<Pair<String, String>>> classifyAttachment(DynamicObjectCollection attachments) {
        HashBasedTable org2Tmp2URLs = HashBasedTable.create();
        HashSet<String> fy_Periods = new HashSet<String>(16);
        for (FYPeriodPair pair : this.fyPeriodPairs) {
            fy_Periods.add(pair.getFy().getString("number") + "_" + pair.getPeriod().getString("number"));
        }
        HashSet<String> filterKeys = new HashSet<String>(16);
        for (ReportExportInfo exportInfo : this.tempReportInfo.getExportInfos()) {
            if (exportInfo.getWeavings() != null) {
                filterKeys.addAll(exportInfo.getWeavings().keySet());
            }
            filterKeys.addAll(exportInfo.getUnweavings());
        }
        for (DynamicObject attachment : attachments) {
            String orgNumber = attachment.getString("noteinfo.entity.number");
            String sceneNumber = attachment.getString("noteinfo.scene.number");
            String yearNumber = attachment.getString("noteinfo.year.number");
            String periodNumber = attachment.getString("noteinfo.period.number");
            String tmpId = attachment.getString("noteinfo.template.id");
            String tmpNumber = attachment.getString("noteinfo.template.number");
            String dimensionstr = attachment.getString("noteinfo.dimensionstr");
            if (orgNumber == null) {
                String str = dimensionstr.split(DimTypesEnum.ENTITY.getNumber() + "\\|")[1];
                orgNumber = str.split(",")[0];
                str = dimensionstr.split(DimTypesEnum.SCENARIO.getNumber() + "\\|")[1];
                sceneNumber = str.split(",")[0];
                str = dimensionstr.split(DimTypesEnum.YEAR.getNumber() + "\\|")[1];
                yearNumber = str.split(",")[0];
                str = dimensionstr.split(DimTypesEnum.PERIOD.getNumber() + "\\|")[1];
                periodNumber = str.split(",")[0];
            }
            Map<String, Long> orgNum2Ids = this.getTempReportInfo().getId2OrgDys().entrySet().stream().collect(Collectors.toMap(v -> ((DynamicObject)v.getValue()).getString("number"), k -> (Long)k.getKey()));
            if (!filterKeys.contains(yearNumber + "|" + periodNumber + "|" + orgNum2Ids.get(orgNumber) + "|" + tmpId)) continue;
            if (fy_Periods.contains(yearNumber + "_" + periodNumber) && org2Tmp2URLs.get((Object)orgNumber, (Object)(sceneNumber + "&" + yearNumber + "&" + periodNumber + "&" + tmpNumber)) != null) {
                ((List)org2Tmp2URLs.get((Object)orgNumber, (Object)(sceneNumber + "&" + yearNumber + "&" + periodNumber + "&" + tmpNumber))).add(Pair.onePair((Object)attachment.getString("name"), (Object)attachment.getString("url")));
                continue;
            }
            if (!fy_Periods.contains(yearNumber + "_" + periodNumber)) continue;
            ArrayList<Pair> urls = new ArrayList<Pair>(8);
            urls.add(Pair.onePair((Object)attachment.getString("name"), (Object)attachment.getString("url")));
            org2Tmp2URLs.put((Object)orgNumber, (Object)(sceneNumber + "&" + yearNumber + "&" + periodNumber + "&" + tmpNumber), urls);
        }
        return org2Tmp2URLs;
    }

    public DynamicObjectCollection getAttachments() {
        ArrayList<Long> yearIds = new ArrayList<Long>(16);
        ArrayList<Long> periodIds = new ArrayList<Long>(16);
        ArrayList<Long> entityIds = new ArrayList<Long>(16);
        for (FYPeriodPair pair : this.fyPeriodPairs) {
            yearIds.add(pair.getFy().getLong("id"));
            periodIds.add(pair.getPeriod().getLong("id"));
        }
        for (ReportExportInfo exportInfo : this.tempReportInfo.getExportInfos()) {
            String orgKey;
            if (exportInfo.getWeavings() != null) {
                for (Map.Entry entry : exportInfo.getWeavings().entrySet()) {
                    orgKey = ((String)entry.getKey()).split("\\|")[2];
                    entityIds.add(Long.valueOf(orgKey));
                }
            }
            for (String string : exportInfo.getUnweavings()) {
                orgKey = string.split("\\|")[2];
                entityIds.add(Long.valueOf(orgKey));
            }
        }
        Set tmpNums = this.tempReportInfo.getAllTemps().values().stream().map(d -> d.getString("number")).collect(Collectors.toSet());
        QFilter type2Filter = new QFilter("model", "=", (Object)this.modelId);
        type2Filter.and(new QFilter("scene", "=", (Object)this.scene_view.getLong("id")));
        type2Filter.and(new QFilter("year", "in", yearIds));
        type2Filter.and(new QFilter("period", "in", periodIds));
        type2Filter.and(new QFilter("entity", "in", entityIds));
        type2Filter.and(new QFilter("template.number", "in", tmpNums));
        type2Filter.and(new QFilter("attachmenttype", "=", (Object)"2"));
        QFilter type1Filter = new QFilter("model", "=", (Object)this.modelId);
        type1Filter.and(new QFilter("attachmenttype", "=", (Object)"1"));
        type1Filter.and(new QFilter("template.number", "in", tmpNums));
        type2Filter.or(type1Filter);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_chknoteinfo", (String)"id", (QFilter[])type2Filter.toArray());
        List noteInfoIds = dynamicObjectCollection.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bcm_chkattachment", (String)"id,noteinfo.dimensionstr,noteinfo.scene.id,noteinfo.scene.number,noteinfo.year.id,noteinfo.year.number,noteinfo.year.name,noteinfo.period.id,noteinfo.period.number,noteinfo.period.name,noteinfo.entity.id,noteinfo.entity.number,noteinfo.entity.name,noteinfo.template.id,noteinfo.template.number,noteinfo.template.name,url,name", (QFilter[])new QFilter[]{new QFilter("noteinfo", "in", noteInfoIds)});
        return attachments;
    }

    public String exportINIFile(String fileKey, String fileNm, Long isSchemeId, MergeIniFileModel mergeModel) throws UnsupportedEncodingException {
        String content;
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        if ((content = this.writeINIContent(fileKey, fileNm, isSchemeId, mergeModel)) == null || this.isMergeINI) {
            return null;
        }
        this.fileList.add(fileNm + ".ini");
        return this.cache.saveAsUrl(fileNm + ".ini", content.getBytes("GBK"), 5000);
    }

    private String mergeIniFile(String name, MergeIniFileModel mergeModel) throws UnsupportedEncodingException {
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        String content = this.mergeINIContent(mergeModel);
        this.fileList.add(name + ".ini");
        return this.cache.saveAsUrl(name + ".ini", content.getBytes("GBK"), 5000);
    }

    private String mergeINIContent(MergeIniFileModel mergeModel) {
        StringBuilder sb = new StringBuilder();
        String sp = System.getProperty("line.separator", "\n");
        sb.append("[Set]").append(sp);
        sb.append("Dir=").append(this.fileAddress).append(sp);
        sb.append(sp).append("[File]").append(sp);
        mergeModel.getFileList().forEach(k -> sb.append((String)k).append(sp));
        sb.append(sp).append("[Sheet]").append(sp);
        for (Map.Entry<String, String> entry : mergeModel.getSheetMap().entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(sp);
        }
        sb.append(sp).append("[Nexus]").append(sp);
        for (Map.Entry<String, String> entry : mergeModel.getNexusMap().entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append(sp);
        }
        return sb.toString();
    }

    private String writeINIContent(String fileKey, String fileNm, Long isSchemeId, MergeIniFileModel mergeModel) {
        long orgId = Long.parseLong(fileKey.substring(0, fileKey.indexOf(64)));
        String reportData = fileKey.substring(fileKey.lastIndexOf(64) + 1);
        StringBuilder sb = new StringBuilder();
        String sp = System.getProperty("line.separator", "\n");
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        DynamicObject dimMappingDyn = QueryServiceHelper.queryOne((String)"bcm_issinglemap", (String)"srcmembname,srcmembnumber,srcreporttype,targmembname,targmembnumber,targmembid", (QFilter[])new QFilter[]{new QFilter("schemeid", "=", (Object)isSchemeId), new QFilter("targmembid", "=", (Object)orgId), new QFilter("reportdatatype", "=", (Object)reportData)});
        if (dimMappingDyn == null) {
            return null;
        }
        DynamicObjectCollection sheetMappingDyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname, template.name,isfloat", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)isSchemeId), new QFilter("mappingstatus", "=", (Object)"1"), new QFilter("effectstatus", "=", (Object)"1"), new QFilter("template", "in", this.tempDoc.stream().map(dyn -> dyn.get("report_number.id")).collect(Collectors.toList()))}, (String)"seqnum");
        ArrayList sheetMappingIds = new ArrayList(sheetMappingDyns.size());
        sheetMappingDyns.forEach(dyn -> sheetMappingIds.add(dyn.getLong("id")));
        DynamicObjectCollection cellMappings = QueryServiceHelper.query((String)"bcm_iscellmappingdata", (String)"sheetmappingid,mappingjson", (QFilter[])new QFilter[]{new QFilter("sheetmappingid", "in", sheetMappingIds)});
        sb.append("[Set]").append(sp);
        sb.append("Dir=").append(this.fileAddress).append(sp);
        sb.append(sp).append("[File]").append(sp);
        String fileYearMonth = this.getFileNameYearMonth(dimMappingDyn.getString("srcmembnumber"), dimMappingDyn.getString("srcreporttype"), isSchemeId, fileKey);
        sb.append(fileYearMonth).append("=").append(dimMappingDyn.getString("srcmembname")).append("&").append(this.fileAddress).append("\\").append(fileNm).append(".xls").append(sp);
        StringBuilder filesb = new StringBuilder();
        mergeModel.getFileList().add(filesb.append(fileYearMonth).append("=").append(dimMappingDyn.getString("srcmembname")).append("&").append(this.fileAddress).append("\\").append(fileNm).append(".xls").toString());
        sb.append(sp).append("[Sheet]").append(sp);
        sheetMappingDyns.forEach(dyn -> sb.append(dyn.getString("sheetname")).append("=").append(dyn.getString("template.name")).append(sp));
        sheetMappingDyns.forEach(dyn -> {
            if ("0".equals(dyn.getString("isfloat"))) {
                mergeModel.getSheetMap().put(dyn.getString("sheetname"), dyn.getString("template.name"));
            }
        });
        sb.append(sp).append("[Nexus]").append(sp);
        HashMap cellMappingMap = new HashMap(cellMappings.size());
        cellMappings.forEach(dyn -> cellMappingMap.put(dyn.getLong("sheetmappingid"), dyn));
        for (DynamicObject sheetmapping : sheetMappingDyns) {
            sb.append(sheetmapping.getString("sheetname")).append("=");
            Long sheetMappingId = sheetmapping.getLong("id");
            if (cellMappingMap.containsKey(sheetMappingId)) {
                JSONObject jsonMap = JSONObject.parseObject((String)((DynamicObject)cellMappingMap.get(sheetMappingId)).getString("mappingjson"));
                JSONArray dataList = jsonMap.getJSONArray("data");
                JSONObject data = null;
                int floatSeq = 1;
                int floatRowCount = 0;
                for (int i = 0; i < dataList.size(); ++i) {
                    data = (JSONObject)dataList.get(i);
                    for (Map.Entry entry : data.entrySet()) {
                        String[] excelIndexs;
                        String[] JQIndexs;
                        StringBuilder nexusSb;
                        List floatAreaInfos = (List)this.nexusMap.get(orgDyn.get("number") + "|" + sheetmapping.get("template.name"));
                        JSONArray cellIndexList = JSONArray.parseArray((String)entry.getValue().toString());
                        if (((String)entry.getKey()).startsWith("g_")) {
                            nexusSb = new StringBuilder();
                            for (int j = 0; j < cellIndexList.size(); ++j) {
                                HashMap cellIndex = (HashMap)JSONObject.parseObject((String)cellIndexList.get(j).toString(), HashMap.class);
                                for (Map.Entry indexEntry : cellIndex.entrySet()) {
                                    List value = (List)indexEntry.getValue();
                                    if (value.isEmpty() || StringUtils.isEmpty((String)((String)value.get(1)))) continue;
                                    JQIndexs = ((String)value.get(1)).replaceAll("\\[|\\]", "").split(",");
                                    String JQIndex = "{" + JQIndexs[0] + "}{" + JQIndexs[1] + "}";
                                    nexusSb.append(JQIndex).append("=");
                                    sb.append(JQIndex).append("=");
                                    excelIndexs = ((String)indexEntry.getKey()).split("#");
                                    String excelIndex = "{" + (Integer.parseInt(excelIndexs[0]) + 1 + floatRowCount) + "}{" + TurnSystem26Util.ToNumberSystem26(Integer.parseInt(excelIndexs[1]) + 1) + "}";
                                    sb.append(excelIndex).append(";");
                                    nexusSb.append(excelIndex).append(";");
                                }
                            }
                            if (!"0".equals(sheetmapping.getString("isfloat"))) continue;
                            mergeModel.getNexusMap().put(sheetmapping.getString("sheetname"), nexusSb.toString());
                            continue;
                        }
                        nexusSb = new StringBuilder();
                        LinkedHashSet<String> rowSet = new LinkedHashSet<String>(16);
                        LinkedHashSet<String> colSet = new LinkedHashSet<String>(16);
                        LinkedHashSet<String> excelRowSet = new LinkedHashSet<String>(16);
                        LinkedHashSet<String> excelColSet = new LinkedHashSet<String>(16);
                        if (floatAreaInfos == null || floatAreaInfos.size() < floatSeq) continue;
                        FloatAreaInfo floatAreaInfo = (FloatAreaInfo)floatAreaInfos.get(floatSeq - 1);
                        ++floatSeq;
                        int countFRows = floatAreaInfo.getFloatRowCount();
                        for (int j = 0; j < cellIndexList.size(); ++j) {
                            HashMap cellIndex = (HashMap)JSONObject.parseObject((String)cellIndexList.get(j).toString(), HashMap.class);
                            for (Map.Entry indexEntry : cellIndex.entrySet()) {
                                List value = (List)indexEntry.getValue();
                                if (value.isEmpty() || StringUtils.isEmpty((String)((String)value.get(1)))) continue;
                                JQIndexs = ((String)value.get(1)).replaceAll("\\[|\\]", "").split(",");
                                rowSet.add(JQIndexs[0]);
                                colSet.add(JQIndexs[1]);
                                excelIndexs = ((String)indexEntry.getKey()).split("#");
                                excelRowSet.add(String.valueOf(Integer.parseInt(excelIndexs[0]) + 1 + floatRowCount));
                                excelRowSet.add(String.valueOf(Integer.parseInt(excelIndexs[0]) + floatRowCount + countFRows));
                                excelColSet.add(TurnSystem26Util.ToNumberSystem26(Integer.parseInt(excelIndexs[1]) + 1));
                            }
                        }
                        floatRowCount += floatAreaInfo.getOrgFloatRowCount() >= countFRows ? 0 : countFRows - floatAreaInfo.getOrgFloatRowCount();
                        sb.append("{");
                        sb.append(rowSet.stream().collect(Collectors.joining(",")));
                        sb.append("}{");
                        sb.append(colSet.stream().collect(Collectors.joining(",")));
                        sb.append("}={");
                        sb.append(String.join((CharSequence)"~", excelRowSet));
                        sb.append("}{");
                        sb.append(String.join((CharSequence)",", excelColSet));
                        sb.append("};");
                        nexusSb.append("{");
                        nexusSb.append(rowSet.stream().collect(Collectors.joining(",")));
                        nexusSb.append("}{");
                        nexusSb.append(colSet.stream().collect(Collectors.joining(",")));
                        nexusSb.append("}={");
                        nexusSb.append(String.join((CharSequence)"~", excelRowSet));
                        nexusSb.append("}{");
                        nexusSb.append(String.join((CharSequence)",", excelColSet));
                        nexusSb.append("};");
                        if (!"0".equals(sheetmapping.getString("isfloat"))) continue;
                        mergeModel.getNexusMap().put(sheetmapping.getString("sheetname"), nexusSb.toString());
                    }
                }
                sb.append(sp);
                continue;
            }
            sb.append(sp);
        }
        return sb.toString();
    }

    protected String getFileNameYearMonth(String srcmembnumber, String srcreporttype, Long isSchemeId, String fileKey) {
        StringBuilder sb = new StringBuilder();
        QFilter pf = new QFilter("scheme", "=", (Object)isSchemeId);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"bcm_iniruledata", (String)"value", (QFilter[])new QFilter[]{pf}, (String)"ordernum asc");
        if (datas == null || datas.isEmpty()) {
            sb.append(srcmembnumber).append(srcreporttype);
        } else {
            Pair<String, String> ymPair = this.getYmPair(fileKey);
            String value = null;
            Iterator iterator = datas.iterator();
            while (iterator.hasNext()) {
                DynamicObject data;
                DynamicObject dynamicObject = data = (DynamicObject)iterator.next();
                value = dynamicObject.getString("value");
                switch (RpaIniFileEnum.getRpaIniFileEnumByNumber((String)value)) {
                    case ENTERPRISECODE: {
                        sb.append(srcmembnumber);
                        break;
                    }
                    case REPORTTYPECODE: {
                        sb.append(srcreporttype);
                        break;
                    }
                    case YEAR: {
                        sb.append((String)ymPair.p1);
                        break;
                    }
                    case PERIOD: {
                        sb.append((String)ymPair.p2);
                        break;
                    }
                }
            }
        }
        return sb.toString();
    }

    private Pair<String, String> getYmPair(String fileKey) {
        String[] fileNmArr = fileKey.split("@");
        ArrayList<String> mcodeList = new ArrayList<String>();
        mcodeList.add("M_M");
        mcodeList.add("M_HF");
        mcodeList.add("M_Q");
        mcodeList.add("HF_HF");
        mcodeList.add("Q_Q");
        mcodeList.add("Q_HF");
        for (String str : mcodeList) {
            fileNmArr[2] = fileNmArr[2].replace(str, "");
        }
        return Pair.onePair((Object)fileNmArr[1].replace("FY", ""), (Object)fileNmArr[2]);
    }

    public String downloadFile(ByteArrayOutputStream oo, String fileName, String suffix) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String zipUrl = cache.saveAsUrl(fileName + suffix, oo.toByteArray(), 5000);
        return zipUrl;
    }

    protected String getFileSuffix() {
        switch (this.getFiletype()) {
            case "0": {
                return "xls";
            }
            case "1": {
                return "doc";
            }
            case "2": {
                return "pdf";
            }
            case "3": {
                return "xlsx";
            }
        }
        return "xlsx";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upLoadFileTemp(String fileName, SXSSFWorkbook workbook) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            String string = this.downloadFile(out, fileName, "." + this.getFileSuffix());
            return string;
        }
        catch (IOException e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            return "";
        }
        finally {
            block39: {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (this.cache_wb != null) {
                        try {
                            this.cache_wb.close();
                        }
                        catch (IOException e) {
                            log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + e);
                        }
                        finally {
                            this.cache_wb = null;
                        }
                    }
                    if (workbook == null) break block39;
                    try {
                        try {
                            workbook.dispose();
                            workbook.close();
                            workbook = null;
                        }
                        catch (IOException e) {
                            log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + e);
                            workbook = null;
                        }
                    }
                    catch (Throwable throwable) {
                        workbook = null;
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upLoadFileTemp(String fileName, HSSFWorkbook workbook) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            String string = this.downloadFile(out, fileName, "." + this.getFileSuffix());
            return string;
        }
        catch (IOException e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            return "";
        }
        finally {
            block39: {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (this.cache_wb != null) {
                        try {
                            this.cache_wb.close();
                        }
                        catch (IOException e) {
                            log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + e);
                        }
                        finally {
                            this.cache_wb = null;
                        }
                    }
                    if (workbook == null) break block39;
                    try {
                        try {
                            workbook.close();
                            workbook = null;
                        }
                        catch (IOException e) {
                            log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + e);
                            workbook = null;
                        }
                    }
                    catch (Throwable throwable) {
                        workbook = null;
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
    }

    protected void setSheetValue(XSSFWorkbook workbook, Pair<List<Map<String, Object>>, List<Map<String, Object>>> values, SheetInfo sheetInfo) throws ParseException {
        Cell cell;
        Iterator cellIt;
        Object row;
        Exception error;
        ArrayList<String> failCells;
        Iterator rowIt;
        XSSFSheet sheet;
        HashMap<Short, Short> fmtStyles = new HashMap<Short, Short>(16);
        HashSet<Short> formatedStyles = new HashSet<Short>(16);
        CellCopyPolicy copyPolicy = new CellCopyPolicy();
        copyPolicy.setCopyCellValue(false);
        copyPolicy.setCopyMergedRegions(false);
        if (this.fileContext.isFloat) {
            this.dealFloatArea(workbook, sheetInfo);
        }
        if (this.cache_wb != null) {
            workbook = this.cache_wb;
        }
        if ((sheet = workbook.getSheetAt(0)) == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(16);
        HashMap<String, CellType> rc2CellType = new HashMap<String, CellType>(16);
        if (!this.fileContext.isSaveByDim) {
            rowIt = sheet.rowIterator();
            failCells = new ArrayList<String>(16);
            error = null;
            while (rowIt.hasNext()) {
                row = (Row)rowIt.next();
                cellIt = row.cellIterator();
                while (cellIt.hasNext()) {
                    cell = (Cell)cellIt.next();
                    try {
                        CellType cellType = cell.getCellType();
                        String key = cell.getRowIndex() + "@" + cell.getColumnIndex();
                        rc2CellType.put(key, cellType);
                        if (cellType != CellType.BLANK && POIUtil.isNeedUnitChange(cell.getCellStyle().getDataFormatString())) {
                            keys.add(key);
                        }
                        if (cellType == CellType.FORMULA && !TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH))) {
                            cell.removeFormula();
                        }
                        this.dealforceValueFont(workbook, fmtStyles, formatedStyles, (XSSFCell)cell);
                    }
                    catch (IllegalStateException e) {
                        if (error == null) {
                            error = e;
                        }
                        failCells.add(cell.getRowIndex() + "-" + cell.getColumnIndex());
                    }
                }
            }
            if (error != null) {
                log.error("cell:" + String.join((CharSequence)",", failCells) + ThrowableHelper.generateFirstThreadCauseMessageInfo(error, (int)30));
            }
        } else {
            rowIt = sheet.rowIterator();
            failCells = new ArrayList(16);
            error = null;
            while (rowIt.hasNext()) {
                row = (Row)rowIt.next();
                cellIt = row.cellIterator();
                while (cellIt.hasNext()) {
                    cell = (Cell)cellIt.next();
                    try {
                        if (cell.getCellType() != CellType.FORMULA || TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH))) continue;
                        cell.removeFormula();
                    }
                    catch (Exception f) {
                        if (error == null) {
                            error = f;
                        }
                        failCells.add(cell.getRowIndex() + "-" + cell.getColumnIndex());
                    }
                }
            }
            if (error != null) {
                log.error("FormulaParseException:" + String.join((CharSequence)",", failCells) + ThrowableHelper.generateFirstThreadCauseMessageInfo(error, (int)30));
                error = null;
                failCells.clear();
            }
        }
        ArrayList<String> failCells2 = new ArrayList<String>(16);
        Exception error2 = null;
        HashMap<String, Object> key2Cells = new HashMap<String, Object>(((List)values.p1).size() + ((List)values.p2).size());
        for (Object val : (List)values.p1) {
            key2Cells.put(val.get("r") + "@" + val.get("c"), val);
        }
        for (Map val : (List)values.p2) {
            String key = val.get("r") + "@" + val.get("c");
            if (key2Cells.containsKey(key)) {
                ((Map)key2Cells.get(key)).putAll(val);
                continue;
            }
            key2Cells.put(key, val);
        }
        FormulaChecker formulaChecker = new FormulaChecker();
        for (Map.Entry entry : key2Cells.entrySet()) {
            Object f;
            CellType cellType;
            Map val = (Map)entry.getValue();
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            XSSFRow row2 = sheet.getRow(rowIndex);
            if (row2 == null) {
                row2 = sheet.createRow(rowIndex);
            }
            XSSFCell cell2 = row2.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (val.containsKey("s") || !this.isSaveByDim()) {
                this.dealforceValueFont(workbook, fmtStyles, formatedStyles, cell2);
            }
            if ((cellType = (CellType)rc2CellType.get(entry.getKey())) == null) continue;
            String cellValue = SXSSFUtil.toString((Cell)cell2, cellType);
            Object v = val.get("v");
            boolean isValEqualExcel = cellValue.equals(v == null ? "" : v.toString());
            if (this.fileContext.isSaveByDim) {
                if (!(isValEqualExcel || !val.containsKey("v") || cellType == CellType.FORMULA && formulaChecker.checkIsOnlyExcel(cellValue.toLowerCase(Locale.ENGLISH)))) {
                    SXSSFUtil.setCellValue(cell2, v);
                }
                if (!val.containsKey("f") || (f = val.get("f")) != null && !StringUtils.isNotEmpty((String)((String)f)) || cellValue.equals(f)) continue;
                cell2.setCellFormula((String)f);
                continue;
            }
            try {
                if (keys.contains(cell2.getRowIndex() + "@" + cell2.getColumnIndex())) {
                    Object value = v;
                    if (value instanceof Number && POIUtil.isNeedUnitChange(cell2.getCellStyle().getDataFormatString())) {
                        BigDecimal srcval = new BigDecimal(v.toString());
                        BigDecimal newval = this.scale == -1 ? srcval.divide(this.divisor, RoundingMode.HALF_UP) : srcval.divide(this.divisor, this.scale, RoundingMode.HALF_UP);
                        if (!(isValEqualExcel || cellType == CellType.FORMULA && formulaChecker.checkIsOnlyExcel(cellValue.toLowerCase(Locale.ENGLISH)))) {
                            SXSSFUtil.setCellValue(cell2, newval);
                        }
                    } else if (!(isValEqualExcel || cellType == CellType.FORMULA && formulaChecker.checkIsOnlyExcel(cellValue.toLowerCase(Locale.ENGLISH)))) {
                        SXSSFUtil.setCellValue(cell2, value);
                    }
                } else if (!isValEqualExcel) {
                    SXSSFUtil.setCellValue(cell2, v);
                }
                if (!val.containsKey("f") || (f = val.get("f")) != null && !StringUtils.isNotEmpty((String)((String)f)) || cellValue.equals(f)) continue;
                cell2.setCellFormula((String)f);
            }
            catch (Exception e) {
                if (cellType == CellType.FORMULA) {
                    String fval = cell2.getCTCell().getF().getStringValue();
                    cell2.getCTCell().unsetF();
                    cell2.setCellValue(fval);
                }
                if (error2 == null) {
                    error2 = e;
                }
                failCells2.add(cell2.getRowIndex() + "-" + cell2.getColumnIndex());
            }
        }
        if (error2 != null) {
            log.error("FormulaParseException:" + String.join((CharSequence)",", failCells2) + ThrowableHelper.generateFirstThreadCauseMessageInfo(error2, (int)30));
        }
        ThreadCache.remove((Object)"floattype");
        ThreadCache.remove((Object)"floatarea");
        this.fileContext.isFloat = false;
    }

    protected void setSheetValue_old(XSSFWorkbook workbook, Pair<List<Map<String, Object>>, List<Map<String, Object>>> values, SheetInfo sheetInfo) throws ParseException {
        Object value;
        XSSFCell cell;
        XSSFRow row;
        Cell cell2;
        Iterator cellIt;
        Row row2;
        Throwable error;
        ArrayList<String> failCells;
        Iterator rowIt;
        XSSFSheet sheet;
        HashMap<Short, Short> fmtStyles = new HashMap<Short, Short>(16);
        HashSet<Short> formatedStyles = new HashSet<Short>(16);
        CellCopyPolicy copyPolicy = new CellCopyPolicy();
        copyPolicy.setCopyCellValue(false);
        copyPolicy.setCopyMergedRegions(false);
        if (this.fileContext.isFloat) {
            this.dealFloatArea(workbook, sheetInfo);
        }
        if (this.cache_wb != null) {
            workbook = this.cache_wb;
        }
        if ((sheet = workbook.getSheetAt(0)) == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(16);
        if (!this.fileContext.isSaveByDim) {
            rowIt = sheet.rowIterator();
            failCells = new ArrayList<String>(16);
            error = null;
            while (rowIt.hasNext()) {
                row2 = (Row)rowIt.next();
                cellIt = row2.cellIterator();
                while (cellIt.hasNext()) {
                    cell2 = (Cell)cellIt.next();
                    try {
                        if (cell2.getCellType() != CellType.BLANK && POIUtil.isNeedUnitChange(cell2.getCellStyle().getDataFormatString())) {
                            keys.add(cell2.getRowIndex() + "@" + cell2.getColumnIndex());
                        }
                        this.dealforceValueFont(workbook, fmtStyles, formatedStyles, (XSSFCell)cell2);
                    }
                    catch (IllegalStateException e) {
                        if (error == null) {
                            error = e;
                        }
                        failCells.add(cell2.getRowIndex() + "-" + cell2.getColumnIndex());
                    }
                }
            }
            if (error != null) {
                log.error("cell:" + String.join((CharSequence)",", failCells) + ThrowableHelper.generateFirstThreadCauseMessageInfo(error, (int)30));
            }
        }
        rowIt = sheet.rowIterator();
        failCells = new ArrayList(16);
        error = null;
        while (rowIt.hasNext()) {
            row2 = (Row)rowIt.next();
            cellIt = row2.cellIterator();
            while (cellIt.hasNext()) {
                cell2 = (Cell)cellIt.next();
                try {
                    if (cell2.getCellType() != CellType.FORMULA || TempFormulaUtil.checkIsOnlyExcel(cell2.getCellFormula().toLowerCase(Locale.ENGLISH))) continue;
                    cell2.removeFormula();
                }
                catch (Exception f) {
                    if (error == null) {
                        error = f;
                    }
                    failCells.add(cell2.getRowIndex() + "-" + cell2.getColumnIndex());
                }
            }
        }
        if (error != null) {
            log.error("FormulaParseException:" + String.join((CharSequence)",", failCells) + ThrowableHelper.generateFirstThreadCauseMessageInfo(error, (int)30));
            error = null;
            failCells.clear();
        }
        for (Map val : (List)values.p1) {
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            row = sheet.getRow(rowIndex);
            if (row == null) {
                row = sheet.createRow(rowIndex);
            }
            cell = row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (this.fileContext.isSaveByDim) {
                if (val.containsKey("v") && (cell.getCellType() != CellType.FORMULA || !TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH)))) {
                    SXSSFUtil.setCellValue(cell, val.get("v"));
                }
                if (!val.containsKey("f") || val.get("f") != null && !StringUtils.isNotEmpty((String)((String)val.get("f")))) continue;
                cell.setCellFormula((String)val.get("f"));
                continue;
            }
            if (keys.contains(cell.getRowIndex() + "@" + cell.getColumnIndex())) {
                value = val.get("v");
                if (value instanceof Number) {
                    BigDecimal srcval = new BigDecimal(val.get("v").toString());
                    BigDecimal newval = this.scale == -1 ? srcval.divide(this.divisor, RoundingMode.HALF_UP) : srcval.divide(this.divisor, this.scale, RoundingMode.HALF_UP);
                    SXSSFUtil.setCellValue(cell, newval);
                } else {
                    SXSSFUtil.setCellValue(cell, val.get("v"));
                }
            } else {
                SXSSFUtil.setCellValue(cell, val.get("v"));
            }
            if (!val.containsKey("f") || val.get("f") != null && !StringUtils.isNotEmpty((String)((String)val.get("f")))) continue;
            cell.setCellFormula((String)val.get("f"));
        }
        for (Map val : (List)values.p2) {
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            row = sheet.getRow(rowIndex);
            if (row == null) {
                row = sheet.createRow(rowIndex);
            }
            cell = row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (val.containsKey("s") || !this.isSaveByDim()) {
                this.dealforceValueFont(workbook, fmtStyles, formatedStyles, cell);
            }
            try {
                if (this.fileContext.isSaveByDim) {
                    if (cell.getCellType() == CellType.FORMULA && TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH))) continue;
                    SXSSFUtil.setCellValue(cell, val.get("v"));
                    continue;
                }
                value = val.get("v");
                String dataFormatString = cell.getCellStyle().getDataFormatString();
                if (value instanceof Number && POIUtil.isNeedUnitChange(dataFormatString)) {
                    BigDecimal srcval = new BigDecimal(val.get("v").toString());
                    BigDecimal newval = this.scale == -1 ? srcval.divide(this.divisor, 9, RoundingMode.HALF_UP) : srcval.divide(this.divisor, this.scale, RoundingMode.HALF_UP);
                    if (cell.getCellType() == CellType.FORMULA && TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH))) continue;
                    SXSSFUtil.setCellValue(cell, newval);
                    continue;
                }
                if (cell.getCellType() == CellType.FORMULA && TempFormulaUtil.checkIsOnlyExcel(cell.getCellFormula().toLowerCase(Locale.ENGLISH))) continue;
                SXSSFUtil.setCellValue(cell, value);
            }
            catch (FormulaParseException f) {
                if (cell.getCellType() == CellType.FORMULA) {
                    String fval = cell.getCTCell().getF().getStringValue();
                    cell.getCTCell().unsetF();
                    cell.setCellValue(fval);
                }
                if (error == null) {
                    error = f;
                }
                failCells.add(cell.getRowIndex() + "-" + cell.getColumnIndex());
            }
        }
        if (error != null) {
            log.error("FormulaParseException:" + String.join((CharSequence)",", failCells) + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)error, (int)30));
        }
        ThreadCache.remove((Object)"floattype");
        ThreadCache.remove((Object)"floatarea");
        this.fileContext.isFloat = false;
    }

    private void dealFloatArea(XSSFWorkbook workbook, SheetInfo sheetInfo) {
        this.floatSheet(workbook, sheetInfo);
    }

    private void dealforceValueFont(XSSFWorkbook workbook, Map<Short, Short> fmtStyles, Set<Short> formatedStyles, XSSFCell cell) {
        if (formatedStyles.add(cell.getCellStyle().getIndex())) {
            String cyFormat;
            String newformat;
            String prex;
            String formatStr = cell.getCellStyle().getDataFormatString();
            Pair<String, String> addr = POIUtil.getCellDataFontAddr(formatStr);
            String[] fs = formatStr.split("\\.");
            String string = prex = fs.length > 0 ? fs[0] : formatStr;
            if (((String)addr.p2).equals("%")) {
                if (this.newscaleStr.isEmpty()) {
                    newformat = formatStr;
                } else {
                    String scaleStr = this.newscaleStr.replaceFirst("00", "");
                    newformat = prex + scaleStr + (String)addr.p2;
                }
            } else {
                newformat = this.newscaleStr.isEmpty() ? formatStr : prex + this.newscaleStr + (String)addr.p2;
            }
            if (formatStr.startsWith("\u00a5") || formatStr.endsWith("$")) {
                newformat = cyFormat = "\u00a5" + newformat.substring(1) + ";\u00a5-" + newformat.substring(1);
            }
            if (formatStr.startsWith("General")) {
                newformat = cyFormat = "0" + this.newscaleStr;
            }
            int formatIndex = workbook.getStylesSource().putNumberFormat(newformat);
            if (this.scale > -1) {
                if (fmtStyles.containsKey(cell.getCellStyle().getIndex())) {
                    cell.setCellStyle((CellStyle)workbook.getCellStyleAt((int)fmtStyles.get(cell.getCellStyle().getIndex()).shortValue()));
                } else {
                    XSSFCellStyle copyStyle = cell.getCellStyle().copy();
                    copyStyle.setDataFormat(formatIndex);
                    fmtStyles.put(cell.getCellStyle().getIndex(), copyStyle.getIndex());
                    cell.setCellStyle((CellStyle)copyStyle);
                }
            }
        } else if (fmtStyles.get(cell.getCellStyle().getIndex()) != null) {
            cell.setCellStyle((CellStyle)workbook.getCellStyleAt((int)fmtStyles.get(cell.getCellStyle().getIndex()).shortValue()));
        }
    }

    protected Map<String, List<String>> floatSheet(XSSFWorkbook workbook, SheetInfo sheetInfo) {
        Object floatAreasObj = ThreadCache.get((Object)"floatarea");
        HashMap<String, List<String>> deleteDatas = new HashMap<String, List<String>>(16);
        if (floatAreasObj == null) {
            return deleteDatas;
        }
        List floatAreas = (List)floatAreasObj;
        if (floatAreas != null && !floatAreas.isEmpty() && ((AutoFloatLogicImpl.FloatArea)floatAreas.get(0)).isCol()) {
            this.floatColSheet(workbook, floatAreas, sheetInfo);
        } else {
            this.floatRowSheet(workbook, floatAreas);
        }
        ThreadCache.remove((Object)"floatarea");
        return deleteDatas;
    }

    private void floatRowSheet(XSSFWorkbook workbook, List<AutoFloatLogicImpl.FloatArea> floatAreas) {
        int i;
        XSSFSheet sheet = workbook.getSheetAt(0);
        CellCopyPolicy copyPolicy = new CellCopyPolicy();
        copyPolicy.setCopyCellValue(false);
        NewReportMultiExportService.deleteOneCellMerge(sheet);
        ArrayList<Pair<Integer, CellRangeAddress>> index2Ranges = new ArrayList<Pair<Integer, CellRangeAddress>>(16);
        List mergedRegions = sheet.getMergedRegions();
        mergedRegions.sort((r1, r2) -> {
            Integer firstRow1 = r1.getFirstRow();
            Integer firstRow2 = r2.getFirstRow();
            Integer lastRow1 = r1.getLastRow();
            Integer lastRow2 = r2.getLastRow();
            if (firstRow1 < firstRow2) {
                return -1;
            }
            if (firstRow1.equals(firstRow2)) {
                return lastRow1.compareTo(lastRow2);
            }
            return 1;
        });
        HashMap<Integer, CellRangeAddress> index2fixRegions = new HashMap<Integer, CellRangeAddress>(16);
        HashMap<Object, Short> styles = new HashMap<Object, Short>(16);
        this.cache_wb = new XSSFWorkbook();
        XSSFSheet copy2cache_sheet = this.cache_wb.createSheet("copy2cache");
        int firstRowNum = sheet.getFirstRowNum();
        if (firstRowNum >= 0) {
            for (int i2 = 0; i2 <= sheet.getRow(firstRowNum).getLastCellNum(); ++i2) {
                copy2cache_sheet.setColumnWidth(i2, sheet.getColumnWidth(i2));
            }
        }
        int needfloatSum = 0;
        for (AutoFloatLogicImpl.FloatArea floatArea : floatAreas) {
            Integer n;
            int srcStartRow;
            int needFloatSize = floatArea.getRowMapSize();
            int floatAreaEndIndex = floatArea.getOriginalendIndex_report();
            int floatAreaStartIndex = floatArea.getOriginalStartIndex_report();
            log.error(floatArea.getAreaSimpleInfo());
            if (floatArea.isDel_pre()) {
                this.dealCollectDelMerge(sheet, mergedRegions, index2fixRegions, floatArea);
                this.dealCollectDelMerge_NoMerge(this.cache_wb.getSheetAt(0), floatArea);
            }
            if (needFloatSize < 1) continue;
            ++needfloatSum;
            boolean isOneLineFloat = false;
            if (floatAreaEndIndex == floatAreaStartIndex) {
                isOneLineFloat = true;
            }
            int n2 = srcStartRow = floatAreaEndIndex + 1 > sheet.getLastRowNum() ? sheet.getLastRowNum() : floatAreaEndIndex;
            if (!floatArea.getDeledata().isEmpty()) {
                boolean b;
                int i3;
                int del_size = floatArea.isDel_pre() ? floatArea.getDeledata().size() : 0;
                floatAreaEndIndex = this.isReport && !this.hasTopSort && this.getSourcestyle().equals("1") ? floatArea.getOriginalendIndex_report() - del_size : floatArea.getOriginalendIndex();
                floatAreaStartIndex = this.isReport && !this.hasTopSort && this.getSourcestyle().equals("1") ? floatArea.getOriginalStartIndex_report() : floatArea.getOriginalStartIndex();
                srcStartRow = floatArea.getOriginalendIndex_report() - del_size + 1;
                if (isOneLineFloat) {
                    ++srcStartRow;
                }
                int n3 = srcStartRow = srcStartRow > sheet.getLastRowNum() ? sheet.getLastRowNum() : srcStartRow;
                if (srcStartRow < sheet.getLastRowNum()) {
                    sheet.shiftRows(srcStartRow, sheet.getLastRowNum(), needFloatSize);
                } else {
                    sheet.shiftRows(sheet.getLastRowNum(), sheet.getLastRowNum(), needFloatSize);
                }
                for (i3 = copy2cache_sheet.getPhysicalNumberOfRows(); i3 <= floatAreaEndIndex; ++i3) {
                    XSSFRow row = copy2cache_sheet.createRow(i3);
                    XSSFRow oldRow = sheet.getRow(i3);
                    if (oldRow != null) {
                        POIUtil.copyRowByIndex(this.cache_wb, oldRow, row, oldRow.getLastCellNum(), styles);
                        continue;
                    }
                    int lastNotNullRow = i3;
                    do {
                        if ((oldRow = sheet.getRow(--lastNotNullRow)) == null) continue;
                        POIUtil.copyRowByIndex(this.cache_wb, oldRow, row, oldRow.getLastCellNum(), styles);
                    } while (oldRow == null && lastNotNullRow >= 0);
                }
                for (i3 = 0; i3 < needFloatSize; ++i3) {
                    copy2cache_sheet.createRow(floatAreaEndIndex + i3 + 1);
                }
                boolean bl = b = copy2cache_sheet.getRow(floatAreaStartIndex) == null;
                if (b) {
                    return;
                }
                Integer j = 0;
                while (j < needFloatSize) {
                    POIUtil.copyRowByIndex(this.cache_wb, sheet.getRow(floatAreaStartIndex), copy2cache_sheet.getRow(floatAreaEndIndex + j + 1), copy2cache_sheet.getRow(floatAreaStartIndex).getLastCellNum(), styles);
                    n = j;
                    Integer n4 = j = Integer.valueOf(j + 1);
                }
                this.collectFloatedMergeRegion(mergedRegions, index2fixRegions, needFloatSize, floatAreaEndIndex, floatAreaStartIndex);
            } else {
                boolean b;
                int i4;
                if (isOneLineFloat) {
                    ++srcStartRow;
                }
                int n5 = srcStartRow = srcStartRow > sheet.getLastRowNum() ? sheet.getLastRowNum() : srcStartRow;
                if (srcStartRow < sheet.getLastRowNum()) {
                    sheet.shiftRows(srcStartRow, sheet.getLastRowNum(), needFloatSize);
                } else {
                    sheet.shiftRows(sheet.getLastRowNum(), sheet.getLastRowNum(), needFloatSize);
                }
                for (i4 = copy2cache_sheet.getPhysicalNumberOfRows(); i4 <= floatAreaEndIndex; ++i4) {
                    XSSFRow row = copy2cache_sheet.createRow(i4);
                    XSSFRow oldRow = sheet.getRow(i4);
                    if (oldRow != null) {
                        POIUtil.copyRowByIndex(this.cache_wb, oldRow, row, oldRow.getLastCellNum(), styles);
                        continue;
                    }
                    oldRow = sheet.getRow(floatAreaStartIndex);
                    if (oldRow == null) continue;
                    POIUtil.copyRowByIndex(this.cache_wb, oldRow, row, oldRow.getLastCellNum(), styles);
                }
                for (i4 = 0; i4 < needFloatSize; ++i4) {
                    copy2cache_sheet.createRow(floatAreaEndIndex + i4 + 1);
                }
                boolean bl = b = copy2cache_sheet.getRow(floatAreaStartIndex) == null;
                if (b) {
                    return;
                }
                Integer j = 0;
                while (j < needFloatSize) {
                    POIUtil.copyRowByIndex(this.cache_wb, sheet.getRow(floatAreaStartIndex), copy2cache_sheet.getRow(floatAreaEndIndex + j + 1), copy2cache_sheet.getRow(floatAreaStartIndex).getLastCellNum(), styles);
                    Integer n6 = j;
                    n = j = Integer.valueOf(j + 1);
                }
                this.collectFloatedMergeRegion(mergedRegions, index2fixRegions, needFloatSize, floatAreaEndIndex, floatAreaStartIndex);
            }
            if (floatArea.isDel_pre()) continue;
            this.dealCollectDelMerge(sheet, mergedRegions, index2fixRegions, floatArea);
            this.dealCollectDelMerge_NoMerge(this.cache_wb.getSheetAt(0), floatArea);
        }
        for (i = copy2cache_sheet.getLastRowNum() + 1; i <= sheet.getLastRowNum(); ++i) {
            XSSFRow row = copy2cache_sheet.createRow(i);
            XSSFRow oldRow = sheet.getRow(i);
            if (oldRow == null) continue;
            POIUtil.copyRowByIndex(this.cache_wb, oldRow, row, oldRow.getLastCellNum(), styles);
        }
        if (needfloatSum > 1) {
            NewReportMultiExportService.copyExcelFormula(sheet, copy2cache_sheet);
        }
        for (i = 0; i < mergedRegions.size(); ++i) {
            if (index2fixRegions.containsKey(i)) continue;
            index2Ranges.add((Pair<Integer, CellRangeAddress>)Pair.onePair((Object)i, mergedRegions.get(i)));
        }
        this.dealSheetMergeRange(sheet, index2Ranges, index2fixRegions);
        List mergeds = sheet.getMergedRegions();
        for (CellRangeAddress merged : mergeds) {
            copy2cache_sheet.addMergedRegion(merged);
        }
    }

    private static void copyExcelFormula(XSSFSheet sheet, XSSFSheet copy2cache_sheet) {
        Iterator rowIt = sheet.rowIterator();
        while (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            if (row == null) continue;
            Iterator cellIt = row.cellIterator();
            while (cellIt.hasNext()) {
                XSSFCell cachecell;
                XSSFRow cacherow;
                Cell cell = (Cell)cellIt.next();
                if (cell == null || CellType.FORMULA != cell.getCellType() || (cacherow = copy2cache_sheet.getRow(cell.getRowIndex())) == null || (cachecell = cacherow.getCell(cell.getColumnIndex())) == null) continue;
                cachecell.setCellFormula(cell.getCellFormula());
            }
        }
    }

    private void dealCollectDelMerge(XSSFSheet sheet, List<CellRangeAddress> mergedRegions, Map<Integer, CellRangeAddress> index2fixRegions, AutoFloatLogicImpl.FloatArea floatArea) {
        block10: {
            List<Integer> deledata = floatArea.getDeledata();
            if (deledata.isEmpty()) break block10;
            deledata.sort(Comparator.naturalOrder());
            if (!ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isCollectDelMergeContinous2")) {
                Map<Integer, Integer> delIndex2Sums = ExcutorAdjustHelper.getContinuousRow2Sum(deledata);
                for (Map.Entry<Integer, Integer> entry : delIndex2Sums.entrySet()) {
                    try {
                        int startRow;
                        List mergeIdxs = IntStream.range(0, sheet.getMergedRegions().size()).boxed().collect(Collectors.toList());
                        sheet.removeMergedRegions(mergeIdxs);
                        int n = startRow = entry.getKey() > sheet.getLastRowNum() || entry.getKey() + entry.getValue() > sheet.getLastRowNum() ? sheet.getLastRowNum() : entry.getKey() + entry.getValue();
                        if (floatArea.getFloatSize() > 2 && !ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isCollectDelMergeContinous2")) {
                            sheet.shiftRows(startRow - 1, sheet.getLastRowNum(), entry.getValue() * -1);
                        } else {
                            sheet.shiftRows(startRow, sheet.getLastRowNum(), entry.getValue() * -1);
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    this.collectFloatedMergeRegion(mergedRegions, index2fixRegions, entry.getValue() * -1, floatArea.getOriginalendIndex_report(), floatArea.getOriginalStartIndex_report());
                }
            } else {
                int delSum = 0;
                for (Integer r : deledata) {
                    if (r < 0 || r + 1 - delSum > sheet.getLastRowNum()) continue;
                    try {
                        sheet.shiftRows(r + 1 - delSum, sheet.getLastRowNum(), -1);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    this.collectFloatedMergeRegion(mergedRegions, index2fixRegions, -1, floatArea.getOriginalendIndex_report(), floatArea.getOriginalStartIndex_report());
                    ++delSum;
                }
            }
        }
    }

    private void dealCollectDelMerge_NoMerge(XSSFSheet sheet, AutoFloatLogicImpl.FloatArea floatArea) {
        block10: {
            try {
                List<Integer> deledata = floatArea.getDeledata();
                if (deledata.isEmpty()) break block10;
                deledata.sort(Comparator.naturalOrder());
                if (!ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isCollectDelMergeContinous2")) {
                    Map<Integer, Integer> delIndex2Sums = ExcutorAdjustHelper.getContinuousRow2Sum(deledata);
                    for (Map.Entry<Integer, Integer> entry : delIndex2Sums.entrySet()) {
                        try {
                            int startRow;
                            List mergeIdxs = IntStream.range(0, sheet.getMergedRegions().size()).boxed().collect(Collectors.toList());
                            sheet.removeMergedRegions(mergeIdxs);
                            int n = startRow = entry.getKey() > sheet.getLastRowNum() ? sheet.getLastRowNum() : entry.getKey() + entry.getValue();
                            if (floatArea.getFloatSize() > 2 && !ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isCollectDelMergeContinous2")) {
                                sheet.shiftRows(startRow - 1, sheet.getLastRowNum(), entry.getValue() * -1);
                                continue;
                            }
                            sheet.shiftRows(startRow, sheet.getLastRowNum(), entry.getValue() * -1);
                        }
                        catch (IllegalStateException e) {
                            log.error((Throwable)e);
                        }
                    }
                    break block10;
                }
                int delSum = 0;
                int lastRowNum = sheet.getLastRowNum();
                for (Integer r : deledata) {
                    int row = r + 1 - delSum;
                    if (r < 0 || row > lastRowNum) continue;
                    try {
                        sheet.shiftRows(row > sheet.getLastRowNum() ? deledata.get(0) + 1 : row, sheet.getLastRowNum(), -1);
                    }
                    catch (IllegalStateException e) {
                        log.error((Throwable)e);
                    }
                    ++delSum;
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void collectFloatedMergeRegion(List<CellRangeAddress> mergedRegions, Map<Integer, CellRangeAddress> index2fixRegions, int needFloatSize, int floatAreaEndIndex, int floatAreaStartIndex) {
        for (int i = 0; i < mergedRegions.size(); ++i) {
            boolean isEndRowAfterSrcRow;
            CellRangeAddress fixRange;
            CellRangeAddress p2;
            int lastRow;
            CellRangeAddress mr = mergedRegions.get(i);
            CellRangeAddress ra = index2fixRegions.get(i);
            int firstRow = ra == null ? mr.getFirstRow() : ra.getFirstRow();
            int n = lastRow = ra == null ? mr.getLastRow() : ra.getLastRow();
            if (needFloatSize > 0) {
                boolean isOriAfterMerge;
                boolean isOriInMerge = firstRow <= floatAreaStartIndex && lastRow >= floatAreaStartIndex || firstRow >= floatAreaStartIndex && lastRow <= floatAreaEndIndex;
                boolean bl = isOriAfterMerge = firstRow >= floatAreaStartIndex && firstRow >= floatAreaEndIndex;
                if (isOriInMerge) {
                    p2 = ra != null ? new CellRangeAddress(ra.getFirstRow(), ra.getLastRow() + needFloatSize, ra.getFirstColumn(), ra.getLastColumn()) : new CellRangeAddress(firstRow, mr.getLastRow() + needFloatSize, mr.getFirstColumn(), mr.getLastColumn());
                    index2fixRegions.put(i, p2);
                    continue;
                }
                if (!isOriAfterMerge) continue;
                if (ra != null) {
                    fixRange = ra;
                    fixRange.setFirstRow(fixRange.getFirstRow() + needFloatSize);
                    fixRange.setLastRow(fixRange.getLastRow() + needFloatSize);
                } else {
                    fixRange = new CellRangeAddress(firstRow + needFloatSize, mr.getLastRow() + needFloatSize, mr.getFirstColumn(), mr.getLastColumn());
                }
                index2fixRegions.put(i, fixRange);
                continue;
            }
            if (needFloatSize >= 0) continue;
            boolean isFirstRowAfterSrcRow = firstRow > floatAreaStartIndex;
            boolean bl = isEndRowAfterSrcRow = lastRow >= floatAreaStartIndex;
            if (isFirstRowAfterSrcRow && isEndRowAfterSrcRow) {
                p2 = ra != null ? new CellRangeAddress(ra.getFirstRow() + needFloatSize, ra.getLastRow() + needFloatSize, ra.getFirstColumn(), ra.getLastColumn()) : new CellRangeAddress(firstRow + needFloatSize, mr.getLastRow() + needFloatSize, mr.getFirstColumn(), mr.getLastColumn());
                index2fixRegions.put(i, p2);
                continue;
            }
            if (isFirstRowAfterSrcRow || !isEndRowAfterSrcRow) continue;
            if (ra != null) {
                fixRange = ra;
                fixRange.setLastRow(fixRange.getLastRow() + needFloatSize);
            } else {
                fixRange = new CellRangeAddress(firstRow, mr.getLastRow() + needFloatSize, mr.getFirstColumn(), mr.getLastColumn());
            }
            index2fixRegions.put(i, fixRange);
        }
    }

    private void dealSheetMergeRange(XSSFSheet sheet, List<Pair<Integer, CellRangeAddress>> index2Ranges, Map<Integer, CellRangeAddress> index2fixRegions) {
        List delOldRanges = index2Ranges.stream().map(r -> (Integer)r.p1).collect(Collectors.toList());
        for (Integer n : delOldRanges) {
            index2fixRegions.remove(n);
        }
        delOldRanges.addAll(index2fixRegions.keySet());
        sheet.removeMergedRegions(delOldRanges);
        for (Pair pair : index2Ranges) {
            if (((CellRangeAddress)pair.p2).getNumberOfCells() < 2) continue;
            sheet.addMergedRegionUnsafe((CellRangeAddress)pair.p2);
        }
        for (CellRangeAddress cellRangeAddress : index2fixRegions.values()) {
            try {
                if (cellRangeAddress.getNumberOfCells() < 2) continue;
                sheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            catch (Exception e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
    }

    private static void deleteOneCellMerge(XSSFSheet sheet) {
        ArrayList<Integer> deleteIndexs = new ArrayList<Integer>(16);
        for (int i = 0; i < sheet.getMergedRegions().size(); ++i) {
            CellRangeAddress mergedRegion = (CellRangeAddress)sheet.getMergedRegions().get(i);
            if (mergedRegion.getFirstRow() != mergedRegion.getLastRow() || mergedRegion.getFirstColumn() != mergedRegion.getLastColumn()) continue;
            deleteIndexs.add(i);
        }
        sheet.removeMergedRegions(deleteIndexs);
    }

    protected void floatColSheet(XSSFWorkbook workbook, List<AutoFloatLogicImpl.FloatArea> floatAreas, SheetInfo sheetInfo) {
        XSSFSheet sheet = workbook.getSheetAt(0);
        CellCopyPolicy copyPolicy = new CellCopyPolicy();
        copyPolicy.setCopyCellValue(false);
        ArrayList<Pair<Integer, CellRangeAddress>> index2Ranges = new ArrayList<Pair<Integer, CellRangeAddress>>(16);
        List mergedRegions = sheet.getMergedRegions();
        mergedRegions.sort((r1, r2) -> {
            int firstRow1 = r1.getFirstRow();
            int firstRow2 = r2.getFirstRow();
            int lastRow1 = r1.getLastRow();
            int lastRow2 = r2.getLastRow();
            if (firstRow1 < firstRow2) {
                return -1;
            }
            if (firstRow1 == firstRow2) {
                if (lastRow1 < lastRow2) {
                    return -1;
                }
                return 1;
            }
            return 1;
        });
        HashMap<Integer, CellRangeAddress> index2fixRegions = new HashMap<Integer, CellRangeAddress>(16);
        HashMap<Object, Short> styles = new HashMap<Object, Short>(16);
        HashMap<Integer, Integer> copy2fromIndexs = new HashMap<Integer, Integer>(16);
        HashMap floatIndex2Widths = new HashMap(16);
        HashMap<Integer, Integer> sourceIndex2Widths = new HashMap<Integer, Integer>(16);
        for (int i = 0; i < sheetInfo.getMaxCol(); ++i) {
            sourceIndex2Widths.put(i, sheet.getColumnWidth(i));
        }
        for (AutoFloatLogicImpl.FloatArea floatArea : floatAreas) {
            boolean bl;
            Object delIndex2SumEntry2;
            Object row;
            Iterator rowIt;
            int needFloatSize = floatArea.getRowMapSize();
            int floatAreaEndIndex = floatArea.getOriginalendIndex_report();
            int floatAreaStartIndex = floatArea.getOriginalStartIndex_report();
            List<Integer> deledata = floatArea.getDeledata();
            if (floatArea.isHasFloat() && !deledata.isEmpty()) {
                deledata.sort(Comparator.naturalOrder());
                int physicalNumberOfCells = sheet.getRow(sheet.getFirstRowNum()).getPhysicalNumberOfCells();
                for (Integer n : deledata) {
                    Object cell;
                    Iterator cellIt;
                    if (n >= 0 && n <= physicalNumberOfCells) {
                        rowIt = sheet.rowIterator();
                        while (rowIt.hasNext()) {
                            row = (Row)rowIt.next();
                            ArrayList<Object> arrayList = new ArrayList<Object>(16);
                            cellIt = row.cellIterator();
                            while (cellIt.hasNext()) {
                                cell = (Cell)cellIt.next();
                                if (n.intValue() != cell.getColumnIndex()) continue;
                                arrayList.add(cell);
                            }
                            for (Cell cell2 : arrayList) {
                                row.removeCell(cell2);
                            }
                        }
                        sheet.shiftColumns(n + 1, physicalNumberOfCells, -1);
                        NewReportMultiExportService.dealColSheetMergeRange(mergedRegions, index2fixRegions, -1, n, n);
                        continue;
                    }
                    rowIt = sheet.rowIterator();
                    while (rowIt.hasNext()) {
                        row = (Row)rowIt.next();
                        ArrayList<Object> arrayList = new ArrayList<Object>(16);
                        cellIt = row.cellIterator();
                        while (cellIt.hasNext()) {
                            cell = (Cell)cellIt.next();
                            if (n.intValue() != cell.getColumnIndex()) continue;
                            arrayList.add(cell);
                        }
                        for (Cell cell3 : arrayList) {
                            row.removeCell(cell3);
                        }
                    }
                }
                Map<Integer, Integer> delIndex2Sums = ExcutorAdjustHelper.getContinuousRow2Sum(deledata);
                for (Object delIndex2SumEntry2 : delIndex2Sums.entrySet()) {
                    for (Map.Entry entry : sourceIndex2Widths.entrySet()) {
                        if ((Integer)entry.getKey() > (Integer)delIndex2SumEntry2.getKey()) {
                            floatIndex2Widths.put((Integer)entry.getKey() - (Integer)delIndex2SumEntry2.getValue(), entry.getValue());
                            continue;
                        }
                        floatIndex2Widths.put((Integer)entry.getKey(), entry.getValue());
                    }
                }
                sourceIndex2Widths.clear();
                sourceIndex2Widths.putAll(floatIndex2Widths);
                floatIndex2Widths.clear();
            }
            if (needFloatSize < 1) continue;
            int lastCellNum = sheetInfo.getMaxCol();
            int startColNum = floatAreaEndIndex > lastCellNum ? lastCellNum : floatAreaEndIndex;
            boolean bl2 = bl = floatAreaEndIndex == floatAreaStartIndex;
            if (bl) {
                ++startColNum;
            }
            startColNum = startColNum > lastCellNum ? lastCellNum : startColNum;
            delIndex2SumEntry2 = sourceIndex2Widths.entrySet().iterator();
            while (delIndex2SumEntry2.hasNext()) {
                Map.Entry entry = delIndex2SumEntry2.next();
                if ((Integer)entry.getKey() >= startColNum) {
                    floatIndex2Widths.put((Integer)entry.getKey() + needFloatSize, entry.getValue());
                    continue;
                }
                floatIndex2Widths.put((Integer)entry.getKey(), entry.getValue());
            }
            sourceIndex2Widths.clear();
            sourceIndex2Widths.putAll(floatIndex2Widths);
            sheet.shiftColumns(startColNum, lastCellNum, needFloatSize);
            rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                row = (Row)rowIt.next();
                if (!POIUtil.validateRowShiftParameters(startColNum, row.getLastCellNum(), needFloatSize)) continue;
                for (int i = 0; i < needFloatSize; ++i) {
                    copy2fromIndexs.put(startColNum + i, floatAreaStartIndex);
                    row.createCell(startColNum + i);
                    XSSFCell fromCell = (XSSFCell)row.getCell(floatAreaStartIndex);
                    XSSFCell toCell = (XSSFCell)row.getCell(startColNum + i);
                    if (fromCell == null || toCell == null) continue;
                    POIUtil.copyCellWithoutValue(workbook, fromCell, toCell, styles);
                }
            }
            NewReportMultiExportService.dealColSheetMergeRange(mergedRegions, index2fixRegions, needFloatSize, floatAreaEndIndex, floatAreaStartIndex);
        }
        for (Map.Entry entry : sourceIndex2Widths.entrySet()) {
            sheet.autoSizeColumn(((Integer)entry.getKey()).intValue());
            sheet.setColumnWidth(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry entry : copy2fromIndexs.entrySet()) {
            sheet.autoSizeColumn(((Integer)entry.getKey()).intValue());
            sheet.setColumnWidth(((Integer)entry.getKey()).intValue(), ((Integer)sourceIndex2Widths.get(entry.getValue())).intValue());
        }
        for (int i = 0; i < mergedRegions.size(); ++i) {
            if (index2fixRegions.containsKey(i)) continue;
            index2Ranges.add((Pair<Integer, CellRangeAddress>)Pair.onePair((Object)i, mergedRegions.get(i)));
        }
        this.dealSheetMergeRange(sheet, index2Ranges, index2fixRegions);
    }

    private static void dealColSheetMergeRange(List<CellRangeAddress> mergedRegions, Map<Integer, CellRangeAddress> index2fixRegions, int needFloatSize, int floatAreaEndIndex, int floatAreaStartIndex) {
        for (int i = 0; i < mergedRegions.size(); ++i) {
            CellRangeAddress fixRange;
            boolean isOriAfterMerge;
            CellRangeAddress mr = mergedRegions.get(i);
            CellRangeAddress ra = index2fixRegions.get(i);
            int firstCol = ra == null ? mr.getFirstColumn() : ra.getFirstColumn();
            int lastCol = ra == null ? mr.getLastColumn() : ra.getLastColumn();
            boolean isOriInMerge = firstCol <= floatAreaStartIndex && lastCol >= floatAreaStartIndex || firstCol >= floatAreaStartIndex && lastCol <= floatAreaEndIndex;
            boolean bl = isOriAfterMerge = firstCol >= floatAreaStartIndex && firstCol >= floatAreaEndIndex;
            if (isOriInMerge) {
                CellRangeAddress p2 = ra != null ? new CellRangeAddress(ra.getFirstRow(), ra.getLastRow(), ra.getFirstColumn(), ra.getLastColumn() + needFloatSize) : new CellRangeAddress(mr.getFirstRow(), mr.getLastRow(), mr.getFirstColumn(), mr.getLastColumn() + needFloatSize);
                index2fixRegions.put(i, p2);
                continue;
            }
            if (!isOriAfterMerge) continue;
            if (ra != null) {
                fixRange = ra;
                fixRange.setFirstColumn(fixRange.getFirstColumn() + needFloatSize);
                fixRange.setLastColumn(fixRange.getLastColumn() + needFloatSize);
            } else {
                fixRange = new CellRangeAddress(mr.getFirstRow(), mr.getLastRow(), mr.getFirstColumn() + needFloatSize, mr.getLastColumn() + needFloatSize);
            }
            index2fixRegions.put(i, fixRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SXSSFWorkbook writeJson(XSSFWorkbook workbook, SXSSFWorkbook allSheetBook, SheetInfo sheetInfo) {
        if (this.cache_wb != null) {
            workbook = this.cache_wb;
        }
        XSSFSheet sheet = workbook.getSheetAt(0);
        String safeSheetName = NewReportMultiExportService.createSafeSheetName(sheetInfo.getReal_sheetName(), '_');
        sheetInfo.setReal_sheetName(safeSheetName);
        String addr = "";
        if (!this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).isEmpty()) {
            addr = "(" + this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).size() + ")";
        }
        if (!StringUtils.isEmpty((String)addr)) {
            int length = safeSheetName.length();
            int addrLength = addr.length();
            if (length >= 29) {
                safeSheetName = safeSheetName.substring(0, 31 - addrLength);
            }
        }
        int sheetLastRowNum = sheet.getLastRowNum();
        if (this.currentFileInfo != null && this.currentFileInfo.getSheetSize() == 1 && allSheetBook.getNumberOfSheets() == 0) {
            for (int row = sheetInfo.getMaxRow(); row <= sheetLastRowNum; ++row) {
                try {
                    if (sheet.getRow(row) == null || sheetInfo.getMaxRow() == sheetLastRowNum) continue;
                    sheet.removeRow((Row)sheet.getRow(row));
                    continue;
                }
                catch (Exception e) {
                    log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
            allSheetBook = new SXSSFWorkbook(workbook);
            allSheetBook.getXSSFWorkbook().setSheetName(0, safeSheetName + addr);
            this.sheetName2Name.put((Object)sheetInfo.getReal_sheetName(), (Object)(safeSheetName + addr));
            allSheetBook.getXSSFWorkbook().getSheetAt(0).setDisplayZeros(!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM015.getNumber()));
            allSheetBook.getXSSFWorkbook().getSheetAt(0).setForceFormulaRecalculation(false);
        } else {
            XSSFSheet newSheet = allSheetBook.getXSSFWorkbook().createSheet(safeSheetName + addr);
            newSheet.setDisplayZeros(!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM015.getNumber()));
            newSheet.setForceFormulaRecalculation(false);
            this.sheetName2Name.put((Object)sheetInfo.getReal_sheetName(), (Object)(safeSheetName + addr));
            for (int row = sheetInfo.getMaxRow(); row <= sheetLastRowNum; ++row) {
                try {
                    if (sheet.getRow(row) == null || sheetInfo.getMaxRow() == sheetLastRowNum) continue;
                    sheet.removeRow((Row)sheet.getRow(row));
                    continue;
                }
                catch (Exception e) {
                    log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
            if (!ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"ISUSEINWORKBOOK")) {
                POIUtil.copySheet(allSheetBook.getXSSFWorkbook(), sheet, newSheet, sheetInfo, this.stylesByWB);
            } else {
                POIUtil.copySheet(allSheetBook.getXSSFWorkbook(), sheet, newSheet, sheetInfo, null);
            }
            if (this.cache_wb != null) {
                try {
                    this.cache_wb.close();
                }
                catch (IOException e) {
                    log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
                finally {
                    this.cache_wb = null;
                }
            }
        }
        return allSheetBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSSFWorkbook writeJson(XSSFWorkbook workbook, HSSFWorkbook allSheetBook, SheetInfo sheetInfo) {
        if (this.cache_wb != null) {
            workbook = this.cache_wb;
        }
        XSSFSheet sheet = workbook.getSheetAt(0);
        String safeSheetName = NewReportMultiExportService.createSafeSheetName(sheetInfo.getReal_sheetName(), '_');
        sheetInfo.setReal_sheetName(safeSheetName);
        String addr = "";
        if (!this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).isEmpty()) {
            addr = "(" + this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).size() + ")";
        }
        if (!StringUtils.isEmpty((String)addr)) {
            int length = safeSheetName.length();
            int addrLength = addr.length();
            if (length >= 29) {
                safeSheetName = safeSheetName.substring(0, 31 - addrLength);
            }
        }
        int sheetLastRowNum = sheet.getLastRowNum();
        HSSFSheet newSheet = allSheetBook.createSheet(safeSheetName + addr);
        newSheet.setDisplayZeros(!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM015.getNumber()));
        newSheet.setForceFormulaRecalculation(false);
        this.sheetName2Name.put((Object)sheetInfo.getReal_sheetName(), (Object)(safeSheetName + addr));
        for (int row = sheetInfo.getMaxRow(); row <= sheetLastRowNum; ++row) {
            try {
                if (sheet.getRow(row) == null || sheetInfo.getMaxRow() == sheetLastRowNum) continue;
                sheet.removeRow((Row)sheet.getRow(row));
                continue;
            }
            catch (Exception e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        if (!ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"ISUSEINWORKBOOK")) {
            POIUtil.copySheet(allSheetBook, workbook, sheet, newSheet, sheetInfo, this.stylesByWB);
        } else {
            POIUtil.copySheet(allSheetBook, workbook, sheet, newSheet, sheetInfo, null);
        }
        if (this.cache_wb != null) {
            try {
                this.cache_wb.close();
            }
            catch (IOException e) {
                log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            finally {
                this.cache_wb = null;
            }
        }
        return allSheetBook;
    }

    public static String createSafeSheetName(String nameProposal, char replaceChar) {
        if (nameProposal == null) {
            return "null";
        }
        if (nameProposal.length() < 1) {
            return "empty";
        }
        nameProposal = nameProposal.replaceAll("\n", "");
        int length = Math.min(31, nameProposal.length());
        String shortenname = nameProposal.substring(0, length);
        StringBuilder result = new StringBuilder(shortenname);
        block4: for (int i = 0; i < length; ++i) {
            char ch = result.charAt(i);
            switch (ch) {
                case '\u0000': 
                case '\u0003': 
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '\uff1a': {
                    result.setCharAt(i, replaceChar);
                    continue block4;
                }
                case '\'': {
                    if (i != 0 && i != length - 1) continue block4;
                    result.setCharAt(i, replaceChar);
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zipFiles(String fileNm) {
        if (StringUtils.isEmpty((String)fileNm)) {
            fileNm = this.zipFileName;
        }
        byte[] buffer = new byte[512];
        int readLength = 0;
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        InputStream inputStream = null;
        String zipUrl = "";
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        Map<String, Pair<String, String>> src2JQCodeTypes = this.getSrcOrg2JQCodeType();
        if (!this.fileNm2UrlMap.isEmpty()) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)oo, Charset.forName("GBK"));){
                for (Map.Entry entry : this.fileNm2UrlMap.entrySet()) {
                    ZipEntry z = new ZipEntry((String)entry.getKey());
                    zipOutputStream.putNextEntry(z);
                    inputStream = this.cache.getInputStream((String)entry.getValue());
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    inputStream.close();
                    zipOutputStream.closeEntry();
                }
                DynamicObjectCollection attachments = this.getAttachments();
                Set orgNums = this.getTempReportInfo().getId2OrgDys().values().stream().map(v -> v.getString("number")).collect(Collectors.toSet());
                Table<String, String, List<Pair<String, String>>> org2Tmp2URLs = this.classifyAttachment(attachments);
                for (Map.Entry entry : org2Tmp2URLs.rowMap().entrySet()) {
                    if (!orgNums.contains(entry.getKey())) continue;
                    if (this.cache == null) {
                        this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    }
                    for (Map.Entry tmpAttsEntry : ((Map)entry.getValue()).entrySet()) {
                        String tmpNum = StringUtils.isEmpty((String)((String)this.rptNum2Defined.get(((String)tmpAttsEntry.getKey()).split("&")[3]))) ? ((String)tmpAttsEntry.getKey()).split("&")[3] : (String)this.rptNum2Defined.get(((String)tmpAttsEntry.getKey()).split("&")[3]);
                        String fyNum = ((String)tmpAttsEntry.getKey()).split("&")[1];
                        fyNum = fyNum.substring(2, fyNum.length());
                        String periodNum = ((String)tmpAttsEntry.getKey()).split("&")[2];
                        periodNum = periodNum.substring(3, periodNum.length());
                        try {
                            ByteArrayOutputStream tempOStream = new ByteArrayOutputStream();
                            Throwable throwable = null;
                            try {
                                ZipOutputStream tempZipOStream = new ZipOutputStream((OutputStream)tempOStream, Charset.forName("GBK"));
                                Throwable throwable2 = null;
                                try {
                                    String orgFolderName;
                                    for (Pair attUrl : (List)tmpAttsEntry.getValue()) {
                                        ZipEntry tmpAttachmentEntry = new ZipEntry(new String(((String)attUrl.p1).getBytes(Charset.forName("GBK")), Charset.forName("GBK")));
                                        tempZipOStream.putNextEntry(tmpAttachmentEntry);
                                        try (InputStream attStream = FileServiceFactory.getAttachmentFileService().getInputStream((String)attUrl.p2);){
                                            while ((readLength = attStream.read(buffer, 0, 512)) != -1) {
                                                tempZipOStream.write(buffer, 0, readLength);
                                            }
                                        }
                                        catch (IOException e) {
                                            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                                        }
                                        tempZipOStream.closeEntry();
                                    }
                                    tempZipOStream.finish();
                                    String tempZipUrl = this.cache.saveAsUrl((String)entry.getKey() + ".ZIP", tempOStream.toByteArray(), 5000);
                                    Pair<String, String> pair = src2JQCodeTypes.get(entry.getKey());
                                    if (pair == null) {
                                        orgFolderName = pair == null ? (String)entry.getKey() + "/" + tmpNum + ".ZIP" : (String)pair.p1 + (String)pair.p2 + "/" + tmpNum + ".ZIP";
                                    } else {
                                        orgFolderName = this.getIniRuleCode().replaceAll("&", "");
                                        orgFolderName = orgFolderName.replaceAll("enterpriseCode", (String)pair.p1);
                                        orgFolderName = orgFolderName.replaceAll("reportTypeCode", (String)pair.p2);
                                        orgFolderName = orgFolderName.replaceAll("year", fyNum);
                                        orgFolderName = orgFolderName.replaceAll("period", periodNum);
                                        orgFolderName = orgFolderName + "/" + tmpNum + ".ZIP";
                                    }
                                    ZipEntry z = new ZipEntry(orgFolderName);
                                    zipOutputStream.putNextEntry(z);
                                    inputStream = this.cache.getInputStream(tempZipUrl);
                                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                                        zipOutputStream.write(buffer, 0, readLength);
                                    }
                                    inputStream.close();
                                    zipOutputStream.closeEntry();
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (tempZipOStream == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            tempZipOStream.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    tempZipOStream.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (tempOStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        tempOStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                tempOStream.close();
                            }
                        }
                        catch (IOException e) {
                            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                        }
                    }
                }
                zipOutputStream.finish();
                zipUrl = this.cache.saveAsUrl(fileNm + ".zip", oo.toByteArray(), 5000);
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            finally {
                try {
                    if (oo != null) {
                        oo.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
        if (this.isJQExport) {
            this.fileList.add(fileNm + ".zip");
        }
        return Collections.singletonList(zipUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String zipFile(String fileNm, HashMap<String, String> fileNmUrlMap) {
        if (StringUtils.isEmpty((String)fileNm)) {
            fileNm = this.zipFileName;
        }
        byte[] buffer = new byte[512];
        int readLength = 0;
        int exists = 0;
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        InputStream inputStream = null;
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        if (!fileNmUrlMap.isEmpty()) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(oo);){
                for (Map.Entry<String, String> entry : fileNmUrlMap.entrySet()) {
                    if (!this.cache.exists(entry.getValue())) continue;
                    ++exists;
                    ZipEntry z = new ZipEntry(entry.getKey());
                    zipOutputStream.putNextEntry(z);
                    inputStream = this.cache.getInputStream(entry.getValue());
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    inputStream.close();
                    zipOutputStream.closeEntry();
                }
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            finally {
                try {
                    if (oo != null) {
                        oo.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
        if (exists > 0) {
            String zipUrl = this.cache.saveAsUrl(fileNm + ".zip", oo.toByteArray(), 5000);
            return zipUrl;
        }
        return null;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        NewReportMultiExportService copyObj = (NewReportMultiExportService)super.clone();
        copyObj.fileContext = new ReportMultiExportService.FileContext();
        return copyObj;
    }

    public Set<String> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(Set<String> numbers) {
        this.numbers = numbers;
    }

    public HashMultimap<String, String> getSheetName2Name() {
        return this.sheetName2Name;
    }

    public void setSheetName2Name(HashMultimap<String, String> sheetName2Name) {
        this.sheetName2Name = sheetName2Name;
    }

    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public TempFileCache getCache() {
        return this.cache;
    }

    public void setCache(TempFileCache cache) {
        this.cache = cache;
    }
}

