/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashMultimap;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.utils.WatermarkUtil;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.ExportServiceConstructor;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.formplugin.report.export.ReportPrintOneFileTaskService;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import kd.fi.bcm.formplugin.report.export.TempReportInfo;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.util.POIUtil;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class NewReportMultiPrintService
extends ReportMultiExportService {
    protected List<String> fileUrls = new ArrayList<String>(16);
    transient TempFileCache cache;
    boolean isshowfooter = false;
    protected List<String> subTempURLS = new ArrayList<String>(16);
    protected List<String> subPDFURLS = new ArrayList<String>(16);

    public NewReportMultiPrintService() {
    }

    public NewReportMultiPrintService(TempReportInfo tempReportInfo) {
        super(tempReportInfo);
        this.numbers = FormulaConfig.getInstance().getFormulaNumberSet();
    }

    @Override
    public void initService() {
        super.initService();
        this.numbers = FormulaConfig.getInstance().getFormulaNumberSet();
    }

    @Override
    public SXSSFWorkbook addSheet2JSONWorkBook(SheetInfo sheetInfo, String spreadjson, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, OutputStream out, SXSSFWorkbook allSheetBook) {
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        try {
            String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
            JSONObject obj = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
            JSONObject sheets = (JSONObject)obj.get((Object)"sheets");
            for (Map.Entry k : sheets.entrySet()) {
                String rptfooter;
                JSONObject sheet = (JSONObject)k.getValue();
                sheet.put("index", (Object)(sheetInfo.getIndex() + sheet.getIntValue("index")));
                sheet.put("name", (Object)sheetInfo.getReal_sheetName());
                if (sheet.containsKey((Object)"rowFilter")) {
                    sheet.remove((Object)"rowFilter");
                }
                if (!ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isshowfooter") && sheet.containsKey((Object)"printInfo") && sheet.getJSONObject("printInfo") != null && "&P/&N".equals(rptfooter = sheet.getJSONObject("printInfo").getString("footerCenter"))) {
                    this.isshowfooter = true;
                    sheet.getJSONObject("printInfo").remove((Object)"footerCenter");
                }
                if (sheet.containsKey((Object)"printInfo") && sheet.getJSONObject("printInfo") != null && sheet.getJSONObject("printInfo").containsKey((Object)"margin")) {
                    JSONObject margin = sheet.getJSONObject("printInfo").getJSONObject("margin");
                    if (margin.containsKey((Object)"left") && StringUtils.isEmpty((String)margin.getString("left"))) {
                        margin.remove((Object)"left");
                    }
                    if (margin.containsKey((Object)"right") && StringUtils.isEmpty((String)margin.getString("right"))) {
                        margin.remove((Object)"right");
                    }
                    if (margin.containsKey((Object)"top") && StringUtils.isEmpty((String)margin.getString("top"))) {
                        margin.remove((Object)"top");
                    }
                    if (margin.containsKey((Object)"bottom") && StringUtils.isEmpty((String)margin.getString("bottom"))) {
                        margin.remove((Object)"bottom");
                    }
                    if (margin.containsKey((Object)"header") && StringUtils.isEmpty((String)margin.getString("header"))) {
                        margin.remove((Object)"header");
                    }
                    if (margin.containsKey((Object)"footer") && StringUtils.isEmpty((String)margin.getString("footer"))) {
                        margin.remove((Object)"footer");
                    }
                }
                this.setSheetValue(sheet, cellValues);
                this.needChangeUnitCells_print.clear();
            }
            this.writeJson(obj, out, sheetInfo.getIndex());
            return allSheetBook;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void setSheetValue(JSONObject sheet, Pair<List<Map<String, Object>>, List<Map<String, Object>>> values) {
        JSONObject data = sheet.getJSONObject("data");
        JSONObject dataTable = data.getJSONObject("dataTable");
        if (dataTable == null) {
            return;
        }
        if (this.fileContext.isFloat) {
            Map<String, List<String>> map = this.floatSpreadJson(dataTable, sheet);
        }
        if (!this.fileContext.isSaveByDim) {
            for (Object row : dataTable.entrySet()) {
                if (row.getValue() == null) continue;
                JSONObject cells = (JSONObject)row.getValue();
                for (Map.Entry cell : cells.entrySet()) {
                    try {
                        JSONObject cellObj = (JSONObject)cell.getValue();
                        if (!cellObj.containsKey((Object)"value")) continue;
                        BigDecimal srcval = cellObj.getBigDecimal("value");
                        JSONObject cellStyle = cellObj.getJSONObject("style");
                        if (!POIUtil.isNeedUnitChange(cellStyle.get((Object)"formatter"))) continue;
                        BigDecimal newval = this.scale == -1 ? srcval.divide(this.divisor, RoundingMode.HALF_UP) : srcval.divide(this.divisor, this.scale, RoundingMode.HALF_UP);
                        String key = (String)row.getKey() + "@" + (String)cell.getKey();
                        this.dealforceValueFont(key, cellStyle);
                        cellObj.put("value", (Object)newval);
                    }
                    catch (Exception e) {
                        log.error("cell:" + (String)row.getKey() + ":" + cell.toString() + e);
                    }
                }
            }
        }
        boolean isADJE = this.audittrial.getString("number").equals("ADJE");
        for (Map val : (List)values.p1) {
            String colKey;
            JSONObject cell;
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            String rowKey = String.valueOf(rowIndex);
            JSONObject row = dataTable.getJSONObject(rowKey);
            if (row == null || (cell = row.getJSONObject(colKey = String.valueOf(colIndex))) == null) continue;
            if (this.fileContext.isSaveByDim) {
                if (isADJE) {
                    cell.put("value", val.get("v"));
                    continue;
                }
                if (!val.containsKey("v")) continue;
                cell.put("value", val.get("v"));
                continue;
            }
            cell.put("value", val.get("v"));
        }
        for (Map val : (List)values.p2) {
            String colKey;
            JSONObject cell;
            int rowIndex = (Integer)val.get("r");
            int colIndex = (Integer)val.get("c");
            String key = rowIndex + "@" + colIndex;
            String rowKey = String.valueOf(rowIndex);
            JSONObject row = dataTable.getJSONObject(rowKey);
            if (row == null) {
                row = new JSONObject();
                dataTable.put(rowKey, (Object)row);
            }
            if ((cell = row.getJSONObject(colKey = String.valueOf(colIndex))) == null) {
                cell = new JSONObject();
                row.put(colKey, (Object)cell);
            }
            if (val.get("v") != null && cell.get((Object)"value") instanceof String && val.get("v") instanceof String && cell.get((Object)"value").toString().trim().equals(val.get("v").toString().trim())) continue;
            Object style = cell.get((Object)"style");
            boolean needUnitChange = false;
            if (this.fileContext.isSaveByDim) {
                cell.put("value", val.get("v"));
            } else {
                Object value = val.get("v");
                if (style != null) {
                    Object formatter = ((JSONObject)style).get((Object)"formatter");
                    if (formatter != null) {
                        if (value instanceof Number && needUnitChange) {
                            BigDecimal srcval = new BigDecimal(val.get("v").toString());
                            BigDecimal newval = this.scale == -1 ? srcval.divide(this.divisor, RoundingMode.HALF_UP) : srcval.divide(this.divisor, this.scale, RoundingMode.HALF_UP);
                            cell.put("value", (Object)newval);
                        } else {
                            cell.put("value", val.get("v"));
                        }
                    } else {
                        cell.put("value", val.get("v"));
                    }
                } else {
                    cell.put("value", val.get("v"));
                }
            }
            if (style == null) continue;
            this.dealforceValueFont(key, (JSONObject)style);
        }
        dataTable.forEach((r, p) -> {
            if (p != null) {
                ((JSONObject)p).forEach((c, v) -> {
                    if (v != null) {
                        Object formula = ((JSONObject)v).get((Object)"formula");
                        Object value = ((JSONObject)v).get((Object)"value");
                        if (formula != null && !TempFormulaUtil.checkIsOnlyExcel(formula.toString().toLowerCase(Locale.ENGLISH))) {
                            ((JSONObject)v).remove((Object)"formula");
                        }
                        if (!this.isReport && value instanceof Integer && (Integer)value == 0) {
                            ((JSONObject)v).remove((Object)"value");
                        }
                    }
                });
            }
        });
        if (this.fileContext.isFloat) {
            ArrayList<String> keys = new ArrayList<String>(16);
            keys.addAll(dataTable.keySet());
            keys.sort(Comparator.comparing(Integer::valueOf));
            JSONObject sortdataTable = new JSONObject(true);
            for (String key : keys) {
                JSONObject rowObj = (JSONObject)dataTable.get((Object)key);
                if (rowObj == null) {
                    sortdataTable.put(key, null);
                    continue;
                }
                JSONObject sortRowObj = new JSONObject(true);
                ArrayList<String> colKeys = new ArrayList<String>(16);
                colKeys.addAll(rowObj.keySet());
                colKeys.sort(Comparator.comparing(Integer::valueOf));
                for (String colKey : colKeys) {
                    sortRowObj.put(colKey, rowObj.get((Object)colKey));
                }
                sortdataTable.put(key, (Object)sortRowObj);
            }
            data.put("dataTable", (Object)sortdataTable);
        }
        ThreadCache.remove((Object)"floattype");
        ThreadCache.remove((Object)"floatarea");
        this.fileContext.isFloat = false;
    }

    private void dealforceValueFont(String key, JSONObject style) {
        if (this.fileContext.isSaveByDim && !this.needChangeUnitCells_print.contains(key)) {
            return;
        }
        Object formatter = style.get((Object)"formatter");
        boolean needUnitChange = POIUtil.isNeedUnitChange(formatter);
        if (formatter != null && needUnitChange && this.scale > -1) {
            String newFmt = POIUtil.dealforceValueFont(formatter.toString(), this.newscaleStr);
            style.put("formatter", (Object)newFmt);
        }
        if (this.fileContext.isSaveByDim && formatter == null && this.scale != -1) {
            style.put("formatter", (Object)("#,##0" + this.newscaleStr));
        }
        if (formatter != null && formatter.toString().equals("General") && !needUnitChange) {
            if (this.scale == -1) {
                style.put("formatter", (Object)"###0.00");
            } else {
                style.put("formatter", (Object)("#,##0" + this.newscaleStr));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> doExport_Excels() {
        try {
            for (ReportExportInfo pair : this.tempReportInfo.getExportInfos()) {
                ReportPrintOneFileTaskService fileTaskService = new ReportPrintOneFileTaskService();
                ExportServiceConstructor.buildService((ReportMultiExportService)this, fileTaskService);
                fileTaskService.fileContext = new ReportMultiExportService.FileContext();
                fileTaskService.sheetName2Name = HashMultimap.create();
                fileTaskService.doExport_Excel(pair);
            }
        }
        catch (Exception e) {
            log.warn(this.getClass().toString() + e);
        }
        finally {
            this.setCompleteSheet(new AtomicInteger(this.tempReportInfo.getSize()));
        }
        return this.fileUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upLoadFileTemp(String fileName, byte[] bytes) {
        ByteArrayInputStream excelStream = new ByteArrayInputStream(bytes);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String json = SpreadUtils.getStrFromInsByCode((InputStream)excelStream, (Charset)StandardCharsets.UTF_8);
        String pdfURL = "";
        ByteArrayOutputStream out = null;
        try {
            out = SpreadUtils.getByteArrayOutputStream((String)json);
            pdfURL = cache.saveAsUrl(fileName + ".pdf", out.toByteArray(), 100);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (excelStream != null) {
                    ((InputStream)excelStream).close();
                }
            }
            catch (IOException e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        return pdfURL;
    }

    public String uploadFile(ByteArrayOutputStream oo, String fileName, String suffix) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String zipUrl = cache.saveAsUrl(fileName + suffix, oo.toByteArray(), 5000);
        return zipUrl;
    }

    @Override
    protected void writeJson(JSONObject allSheetObj, OutputStream out, int index) throws IOException {
        allSheetObj.put("tabStripVisible", (Object)Boolean.TRUE);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = SpreadUtils.getInputStream((String)allSheetObj.toString());){
            String zipUrl = cache.saveAsUrl(index + ".pdf", inputStream, 5000);
            this.subPDFURLS.add(zipUrl);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public String mulFile2One(List<String> files, String targetPath) {
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        mergePdf.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        mergePdf.setAcroFormMergeMode(PDFMergerUtility.AcroFormMergeMode.JOIN_FORM_FIELDS_MODE);
        for (String f : files) {
            mergePdf.addSource(this.cache.getInputStream(f));
        }
        mergePdf.setDestinationFileName(targetPath);
        String pdfUrl = "";
        try (ByteArrayOutputStream pdfOutputStream = new ByteArrayOutputStream();){
            mergePdf.setDestinationStream((OutputStream)pdfOutputStream);
            mergePdf.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
            pdfUrl = this.cache.saveAsUrl(targetPath, pdfOutputStream.toByteArray(), 5000);
            if (this.isshowfooter && !ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"isshowfooter")) {
                PDDocument document = PDDocument.load((InputStream)this.cache.getInputStream(pdfUrl));
                int numberOfPages = document.getNumberOfPages();
                for (int i = 0; i < numberOfPages; ++i) {
                    PDPage page = document.getPage(i);
                    float width = page.getMediaBox().getWidth();
                    PDPageContentStream pageContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                    pageContentStream.beginText();
                    pageContentStream.newLineAtOffset(width / 2.0f - 10.0f, 20.0f);
                    try {
                        File file = new File(KDFont.getFontFilesDir());
                        if (!file.exists()) {
                            pageContentStream.setFont((PDFont)PDType1Font.SYMBOL, 8.0f);
                        } else {
                            pageContentStream.setFont((PDFont)PDType0Font.load((PDDocument)document, (File)file), 8.0f);
                        }
                    }
                    catch (Exception e) {
                        pageContentStream.setFont((PDFont)PDType1Font.SYMBOL, 8.0f);
                    }
                    pageContentStream.showText(String.format("%d/%s", i + 1, numberOfPages));
                    pageContentStream.endText();
                    pageContentStream.restoreGraphicsState();
                    pageContentStream.close();
                }
                document.save((OutputStream)pdfOutputStream);
                pdfUrl = this.cache.saveAsUrl(targetPath, pdfOutputStream.toByteArray(), 5000);
            }
            if (StringUtils.isNotEmpty((String)this.getWatermark())) {
                WatermarkUtil.pdfWatermarkTxt((OutputStream)pdfOutputStream, (InputStream)this.cache.getInputStream(pdfUrl), (String)this.getWatermark());
                pdfUrl = this.cache.saveAsUrl(targetPath, pdfOutputStream.toByteArray(), 5000);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return pdfUrl;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        NewReportMultiExportService copyObj = (NewReportMultiExportService)super.clone();
        copyObj.fileContext = new ReportMultiExportService.FileContext();
        return copyObj;
    }

    public Set<String> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(Set<String> numbers) {
        this.numbers = numbers;
    }

    public HashMultimap<String, String> getSheetName2Name() {
        return this.sheetName2Name;
    }

    public void setSheetName2Name(HashMultimap<String, String> sheetName2Name) {
        this.sheetName2Name = sheetName2Name;
    }

    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public TempFileCache getCache() {
        return this.cache;
    }

    public void setCache(TempFileCache cache) {
        this.cache = cache;
    }
}

