/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.ReportDataScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.scheme.SimpleIDNumberTreeNode;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public class ReportDataSelectScheme
implements Serializable {
    private static final String NUMBER = "number";
    private static final String SCHEME_TYPE = "schemetype";
    public static final String latestType = "all0310";
    public static final String custom = "custom";
    public static final String REPORT_PREPARE = "1";
    public static final String REPORT_SEARCH = "2";
    public static final String REPORT_ADJUST = "3";
    private SchemeContext schemeContext;
    private String schemetype;
    private Map<String, String> names = new LinkedHashMap<String, String>(16);
    private Map<String, List<AbstractScheme>> RDataSelectSchemes;
    private String type = "1";
    private boolean isCm;
    public static final String MATCHPCSCHEME = "matchpcscheme";
    public static final String SHORTCUTSELECTCALLCLEAN = "shortcut_select_callclean";
    public static final Set<String> NOTSETDIMS = Sets.newHashSet((Object[])new String[]{DimTypesEnum.DATASORT.getNumber()});
    private static final String CACHE_RDSS = "cache_rdss";
    public static List<String> exportBPs = Lists.newArrayList((Object[])new String[]{"Rpt", "IRpt", "RAdj", "ERpt", "EIRpt", "ERAdj", "SRPT", "CT", "EJET", "CSTE", "ADJT", "DIF"});
    public static Set<String> pcBPs = Sets.newHashSet((Object[])new String[]{"IRpt", "RAdj"});

    public static String getCurrentSchemeNum() {
        return ThreadCache.get((Object)SHORTCUTSELECTCALLCLEAN) == null ? null : ThreadCache.get((Object)SHORTCUTSELECTCALLCLEAN).toString();
    }

    private void initModel(SchemeContext schemeContext, String schemetype) {
        this.schemeContext = schemeContext;
        String reporttype = (String)ThreadCache.get((Object)"ReportDataSelectScheme.rt", () -> QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])new QFilter("id", "=", (Object)schemeContext.getModel()).toArray()).getString("reporttype"));
        if (ApplicationTypeEnum.CM.index.equals(reporttype)) {
            this.isCm = true;
        }
        List dimNums = TemplateUtil.getReportDataDimNums((long)schemeContext.getModel());
        schemeContext.removeIf(dimension -> dimension.isIssys() && !dimNums.contains(dimension.getNumber()));
        this.schemetype = schemetype;
        this.RDataSelectSchemes = new HashMap<String, List<AbstractScheme>>(16);
    }

    public static String getSchemeType(boolean isleaf, boolean isCvt) {
        return latestType;
    }

    public void addRDataSelectScheme(String schemeType, AbstractScheme scheme) {
        if (this.RDataSelectSchemes.get(schemeType) == null) {
            this.RDataSelectSchemes.put(schemeType, new ArrayList(10));
        }
        this.RDataSelectSchemes.get(schemeType).add(scheme);
    }

    public void addAllRDataSelectSchemes(DynamicObjectCollection dys) {
        dys.stream().forEach(dy -> {
            ReportDataScheme rps = new ReportDataScheme(this.getModel(), dy.getString(NUMBER), dy.getString("name"), dy.getBoolean("issys"), dy.getString(SCHEME_TYPE), null);
            HashMap detailMap = new HashMap(16);
            this.getDimensions().stream().filter(dimension -> dy.getDynamicObject(dimension.getFieldmapped()) != null).forEach(dimension -> detailMap.put(dimension.getNumber(), ReportDataScheme.covert2Simple((IDNumberTreeNode)BcmThreadCache.findNodeById((String)this.getModelNum(), (String)dimension.getNumber(), (long)dy.getDynamicObject(dimension.getFieldmapped()).getLong("id")))));
            rps.setSchemeDetails(detailMap);
            rps.setSeq(this.RDataSelectSchemes.get(dy.getString(SCHEME_TYPE)) == null ? 0 : this.RDataSelectSchemes.get(dy.getString(SCHEME_TYPE)).size());
            this.addRDataSelectScheme(dy.getString(SCHEME_TYPE), (AbstractScheme)rps);
        });
    }

    public Map<String, List<AbstractScheme>> getRDataSelectSchemes() {
        return this.RDataSelectSchemes;
    }

    public ReportDataSelectScheme(SchemeContext schemeContext) {
        this(schemeContext, null, REPORT_PREPARE);
    }

    public ReportDataSelectScheme(SchemeContext schemeContext, String type) {
        this(schemeContext, null, type);
    }

    public ReportDataSelectScheme() {
    }

    public ReportDataSelectScheme(SchemeContext schemeContext, String schemetype, String type) {
        this.type = type;
        this.initModel(schemeContext, schemetype);
        this.updateOldDate();
        QFilter filter = new QFilter("model", "=", (Object)this.getModel()).and("applymenu", "=", (Object)type);
        QFilter tempFilter = new QFilter("template", "=", (Object)schemeContext.getTemplateId());
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bcm_reportdata_custseting", (String)"issystem,schemetype,name,number,detail.dimension,detail.dimensionmember,applymenu,template.id", (QFilter[])new QFilter[]{filter, tempFilter}, (String)"sequence");
        if (schemes.length == 0) {
            tempFilter = new QFilter("template", "=", (Object)0L).or(new QFilter("template", "=", null));
            schemes = BusinessDataServiceHelper.load((String)"bcm_reportdata_custseting", (String)"issystem,schemetype,name,number,detail.dimension,detail.dimensionmember,applymenu,template.id", (QFilter[])new QFilter[]{filter, tempFilter}, (String)"sequence");
        }
        Arrays.stream(schemes).filter(scheme -> StringUtils.isEmpty((String)schemetype) || schemetype.equalsIgnoreCase(scheme.getString(SCHEME_TYPE))).forEach(scheme -> {
            String number = scheme.getString(NUMBER);
            this.names.put(number, scheme.getString("name"));
            ReportDataScheme rps = new ReportDataScheme(this.getModel(), scheme);
            this.addRDataSelectScheme(scheme.getString(SCHEME_TYPE), (AbstractScheme)rps);
        });
    }

    public final void SaveRDataSelectSchemes() {
        ArrayList toSaveDatas = new ArrayList(10);
        this.RDataSelectSchemes.keySet().forEach(schemeType -> this.RDataSelectSchemes.get(schemeType).forEach(rDataSelectScheme -> toSaveDatas.add(rDataSelectScheme.toDy(this.schemeContext))));
        QFilter modelfilter = new QFilter("model", "=", (Object)this.getModel()).and("applymenu", "=", (Object)this.type);
        if (!StringUtil.isEmptyString((String)this.schemetype)) {
            modelfilter.and(SCHEME_TYPE, "=", (Object)this.schemetype);
        }
        if (this.schemeContext.getTemplateId() != 0L) {
            modelfilter.and("template", "=", (Object)this.schemeContext.getTemplateId());
        } else {
            QFilter tempFilter = new QFilter("template", "=", (Object)0L).or(new QFilter("template", "=", null));
            modelfilter.and(tempFilter);
        }
        DeleteServiceHelper.delete((String)"bcm_reportdata_custseting", (QFilter[])modelfilter.toArray());
        if (toSaveDatas.isEmpty()) {
            ReportDataSchemeUtil.removeCache(this.schemeContext.getModel(), this.schemeContext.getTemplateId());
            return;
        }
        toSaveDatas.forEach(dynamicObject -> {
            dynamicObject.set("applymenu", (Object)this.type);
            if (this.schemeContext.getTemplateId() != 0L) {
                dynamicObject.set("template", (Object)this.schemeContext.getTemplateId());
            }
        });
        SaveServiceHelper.save((DynamicObject[])toSaveDatas.toArray(new DynamicObject[0]));
        ReportDataSchemeUtil.removeCache(this.schemeContext.getModel(), this.schemeContext.getTemplateId());
    }

    public void cacheReportDataSelectScheme(IPageCache pageCache) {
        pageCache.put(CACHE_RDSS, ObjectSerialUtil.toByteSerialized((Object)this));
    }

    public static ReportDataSelectScheme getReportDataSelectScheme(IPageCache pageCache) {
        String cache = pageCache.get(CACHE_RDSS);
        if (StringUtil.isEmptyString((String)cache)) {
            return null;
        }
        return (ReportDataSelectScheme)ObjectSerialUtil.deSerializedBytes((String)cache);
    }

    public List<ComboItem> getComboItems(boolean isCvt, boolean isleaf, boolean isDC) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        String schemeType = ReportDataSelectScheme.getSchemeType(isleaf, isCvt);
        if (isDC && this.RDataSelectSchemes.get("dc") == null && this.RDataSelectSchemes.get(schemeType) == null) {
            return comboItems;
        }
        if (this.RDataSelectSchemes.get(schemeType) != null) {
            this.RDataSelectSchemes.get(schemeType).forEach(RDataSelectScheme -> {
                boolean isContainsCSTE;
                Map schemeDetails = ((ReportDataScheme)RDataSelectScheme).getTreeNodeSchemeDetails();
                boolean isContainsProcess = schemeDetails.containsKey(SysDimensionEnum.Process.getNumber());
                boolean bl = isContainsCSTE = isContainsProcess ? "CSTE".equals(((SimpleIDNumberTreeNode)schemeDetails.get(SysDimensionEnum.Process.getNumber())).getNumber()) : false;
                if (!(isleaf && isContainsProcess && isContainsCSTE)) {
                    comboItems.add(new ComboItem(new LocaleString(RDataSelectScheme.getName()), RDataSelectScheme.getNumber()));
                }
            });
        }
        return comboItems;
    }

    public List<ComboItem> getExportComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ArrayList rs = new ArrayList(10);
        for (Map.Entry<String, List<AbstractScheme>> listEntry : this.RDataSelectSchemes.entrySet()) {
            rs.addAll(listEntry.getValue());
        }
        if (!rs.isEmpty()) {
            rs.forEach(r -> {
                ReportDataScheme rds = (ReportDataScheme)r;
                for (Map.Entry o : rds.getTreeNodeSchemeDetails().entrySet()) {
                    if (!((String)o.getKey()).equals(DimTypesEnum.PROCESS.getNumber()) || exportBPs.contains(((SimpleIDNumberTreeNode)o.getValue()).getNumber())) continue;
                    return;
                }
                comboItems.add(new ComboItem(new LocaleString(r.getName()), r.getNumber()));
            });
        }
        return comboItems;
    }

    public Map<String, SimpleIDNumberTreeNode> searchTreeNodeSchemeByNumber(String number) {
        if (StringUtils.isNotEmpty((String)this.schemetype)) {
            return ((ReportDataScheme)this.RDataSelectSchemes.get(this.schemetype).stream().filter(p -> p.getNumber().equalsIgnoreCase(number)).findFirst().get()).getTreeNodeSchemeDetails();
        }
        for (Map.Entry<String, List<AbstractScheme>> schemeType : this.RDataSelectSchemes.entrySet()) {
            for (AbstractScheme rds : schemeType.getValue()) {
                if (!rds.getNumber().equalsIgnoreCase(number)) continue;
                return ((ReportDataScheme)rds).getTreeNodeSchemeDetails();
            }
        }
        return null;
    }

    public Map<String, DynamicObject> searchSchemeByNumber(String number) {
        return ReportDataScheme.convertIDNumberTreeNode2Dyna(this.searchTreeNodeSchemeByNumber(number));
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public List<Dimension> getDimensions() {
        return this.schemeContext.getDimensions();
    }

    public final long getModel() {
        return this.schemeContext.getModel();
    }

    public static String getCtrlKey(String dimNumber) {
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber);
        return "bcm_userdefinedmembertree".equalsIgnoreCase(entity) ? entity + "_" + dimNumber.toLowerCase(Locale.ENGLISH) : entity;
    }

    public static void filterByTemplate(TemplateModel model, ReportDataSelectScheme rdss) {
        if (rdss == null || model == null) {
            return;
        }
        HashMultimap scopeMap = HashMultimap.create();
        model.getViewPointDimensionEntries().forEach(v -> scopeMap.put((Object)v.getDimension().getNumber(), (Object)v.getMember().getNumber()));
        model.getPageDimensionEntries().forEach(p -> p.getMembers().forEach(m -> new MembRangeItem(p.getDimension().getMemberEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)model.getModelId()).matchItems(c -> scopeMap.put((Object)p.getDimension().getNumber(), (Object)c.getNumber()))));
        model.getPagePropEntries().forEach(p -> p.getAllMembProperties().forEach(m -> new MembRangeItem(p.getDimension().getMemberEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), true, (Object)model.getModelId()).matchItems(c -> scopeMap.put((Object)p.getDimension().getNumber(), (Object)c.getNumber()))));
        HashMap<String, Set> delMap = new HashMap<String, Set>(16);
        for (String string : scopeMap.keySet()) {
            Set noPermMemberNums = (Set)ThreadCache.get((Object)("filterByTemplate-" + rdss.getModel() + string), () -> DataCollectUtil.getNotPermNumsByNums((Long)rdss.getModel(), (String)key, (Collection)scopeMap.get((Object)key)));
            delMap.put(string, noPermMemberNums);
        }
        for (Map.Entry entry : delMap.entrySet()) {
            scopeMap.get(entry.getKey()).removeAll((Collection)entry.getValue());
        }
        for (String string : rdss.getRDataSelectSchemes().keySet()) {
            List<AbstractScheme> scs = rdss.getRDataSelectSchemes().get(string);
            for (int i = 0; i < scs.size(); ++i) {
                ReportDataScheme sc = (ReportDataScheme)scs.get(i);
                boolean inScope = true;
                for (Object dim : sc.getTreeNodeSchemeDetails().keySet()) {
                    String dimnum = dim.toString();
                    if (!scopeMap.containsKey((Object)dimnum)) {
                        inScope = false;
                        break;
                    }
                    SimpleIDNumberTreeNode object = (SimpleIDNumberTreeNode)sc.getTreeNodeSchemeDetails().get(dimnum);
                    if (object == null || scopeMap.get((Object)dimnum).contains(object.getNumber())) continue;
                    inScope = false;
                    break;
                }
                if (inScope) continue;
                scs.remove(sc);
                --i;
            }
        }
    }

    private void preReportDataSelectSchemes(String type) {
        PairList schemes = new PairList();
        if (REPORT_PREPARE.equals(type)) {
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u62a5\u8868", (String)"ReportDataSelectScheme_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"EIRpt#EntityInput");
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u8868\u5f0f\u8c03\u6574", (String)"ReportDataSelectScheme_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERAdj#CWP");
            if (this.isCm) {
                schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u5408\u5e76\u5f55\u5165", (String)"ReportDataSelectScheme_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"CSTE#EntityInput");
            }
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u8c03\u6574\u6570", (String)"ReportDataSelectScheme_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERAdj#ADJE");
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u62a5\u8868(\u8c03\u6574\u540e)", (String)"ReportDataSelectScheme_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERpt#ATTotal");
        } else if (REPORT_SEARCH.equals(type)) {
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u62a5\u8868(\u8c03\u6574\u540e)", (String)"ReportDataSelectScheme_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERpt#ATTotal");
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u62a5\u8868", (String)"ReportDataSelectScheme_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"EIRpt#EntityInput");
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u8868\u5f0f\u8c03\u6574", (String)"ReportDataSelectScheme_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERAdj#CWP");
            if (this.isCm) {
                schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u5408\u5e76\u5f55\u5165", (String)"ReportDataSelectScheme_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"CSTE#EntityInput");
            }
            schemes.addPair((Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01\u8c03\u6574\u6570", (String)"ReportDataSelectScheme_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"ERAdj#ADJE");
        }
        schemes.addPair((Object)ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u62a5\u8868", (String)"ReportDataSelectScheme_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"IRpt#EntityInput");
        schemes.addPair((Object)ResManager.loadKDString((String)"\u62a5\u8868\u6298\u7b97\u5dee", (String)"ReportDataSelectScheme_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"IRpt#TraDif");
        schemes.addPair((Object)ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u62a5\u8868\u8c03\u6574", (String)"ReportDataSelectScheme_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"RAdj#ADJE");
        schemes.addPair((Object)ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u62a5\u8868(\u8c03\u6574\u540e)", (String)"ReportDataSelectScheme_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"Rpt#ATTotal");
        if (REPORT_SEARCH.equals(type)) {
            schemes.addPair((Object)ResManager.loadKDString((String)"\u62b5\u9500\u524d\u62a5\u8868\u6c47\u603b\u6570", (String)"ReportDataSelectScheme_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"SRPT#ATTotal");
        }
        schemes.forEach(p -> {
            String number = (String)p.p2;
            this.names.put(number, (String)p.p1);
            String[] pArr = ((String)p.p2).split("#");
            ReportDataScheme rps = new ReportDataScheme(this.getModel(), number, (String)p.p1, true, latestType, null);
            HashMap<String, SimpleIDNumberTreeNode> detailMap = new HashMap<String, SimpleIDNumberTreeNode>(16);
            detailMap.put(DimTypesEnum.PROCESS.getNumber(), ReportDataScheme.covert2Simple((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)this.getModelNum(), (String)DimTypesEnum.PROCESS.getNumber(), (String)pArr[0])));
            detailMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), ReportDataScheme.covert2Simple((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)this.getModelNum(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)pArr[1])));
            detailMap.put(DimTypesEnum.CURRENCY.getNumber(), ReportDataScheme.covert2Simple((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)this.getModelNum(), (String)DimTypesEnum.CURRENCY.getNumber(), (String)"DC")));
            rps.setSchemeDetails(detailMap);
            rps.setSeq(this.RDataSelectSchemes.get(latestType) == null ? 0 : this.RDataSelectSchemes.get(latestType).size());
            this.addRDataSelectScheme(latestType, (AbstractScheme)rps);
        });
    }

    private String getModelNum() {
        return (String)ThreadCache.get((Object)String.join((CharSequence)"_", "ReportDataSelectScheme", "" + this.getModel()), () -> MemberReader.findModelNumberById((Object)this.getModel()));
    }

    private void updateOldDate() {
        if (this.type.equals(REPORT_ADJUST)) {
            return;
        }
        if (ThreadCache.get((Object)String.join((CharSequence)"|", "updateOldDate", this.schemeContext.getModelNumber(), this.type)) != null) {
            return;
        }
        QFilter newType = new QFilter("model", "=", (Object)this.getModel()).and(new QFilter(SCHEME_TYPE, "=", (Object)latestType)).and("applymenu", "=", (Object)this.type);
        boolean exit = QueryServiceHelper.exists((String)"bcm_reportdata_custseting", (QFilter[])newType.toArray());
        if (exit) {
            if (this.type.equals(REPORT_SEARCH) || this.type.equals(REPORT_ADJUST)) {
                return;
            }
            this.updateIRptAdje(newType);
            if (!this.isCm) {
                DeleteServiceHelper.delete((String)"bcm_reportdata_custseting", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModel()), new QFilter(NUMBER, "=", (Object)"CSTE#EntityInput")});
            }
            return;
        }
        this.RDataSelectSchemes.clear();
        this.preReportDataSelectSchemes(this.type);
        ArrayList toSaveDatas = new ArrayList(10);
        this.RDataSelectSchemes.keySet().forEach(schemeType -> this.RDataSelectSchemes.get(schemeType).forEach(rDataSelectScheme -> toSaveDatas.add(rDataSelectScheme.toDy(this.schemeContext))));
        QFilter modelfilter = new QFilter("model", "=", (Object)this.getModel()).and(new QFilter("issystem", "=", (Object)REPORT_PREPARE).and("applymenu", "=", (Object)this.type));
        DeleteServiceHelper.delete((String)"bcm_reportdata_custseting", (QFilter[])modelfilter.toArray());
        toSaveDatas.forEach(dyo -> dyo.set("applymenu", (Object)this.type));
        SaveServiceHelper.save((DynamicObject[])toSaveDatas.toArray(new DynamicObject[0]));
        QFilter customfilter = new QFilter("model", "=", (Object)this.getModel()).and(new QFilter("issystem", "=", (Object)"0").and("applymenu", "=", (Object)this.type));
        int seq = toSaveDatas.size();
        DynamicObject[] olds = BusinessDataServiceHelper.load((String)"bcm_reportdata_custseting", (String)"schemetype,sequence,applymenu", (QFilter[])customfilter.toArray());
        if (olds != null) {
            for (DynamicObject obj : olds) {
                obj.set(SCHEME_TYPE, (Object)latestType);
                obj.set("applymenu", (Object)this.type);
                obj.set("sequence", (Object)seq);
                ++seq;
            }
            SaveServiceHelper.save((DynamicObject[])olds);
        }
        this.RDataSelectSchemes.clear();
        ThreadCache.put((Object)String.join((CharSequence)"|", "updateOldDate", this.schemeContext.getModelNumber(), this.type), (Object)1);
    }

    private void updateIRptAdje(QFilter newType) {
        newType.and(new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u62a5\u8868\u8c03\u6574", (String)"ReportDataSelectScheme_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        String number = "RAdj#ADJE";
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bcm_reportdata_custseting", (String)"id,name,number,detail.dimension,detail.dimensionmember", (QFilter[])newType.toArray());
        if (object != null && object.getString(NUMBER).equals("IRpt#ADJE")) {
            object.set(NUMBER, (Object)number);
            DynamicObjectCollection detail = object.getDynamicObjectCollection("detail");
            detail.forEach(dynamicObject -> {
                DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
                if (dimension != null && DimTypesEnum.PROCESS.getNumber().equals(dimension.getString(NUMBER))) {
                    dynamicObject.set("dimensionmember", (Object)MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModel()), (String)"RAdj").getId());
                }
            });
            SaveServiceHelper.update((DynamicObject)object);
        }
    }

    public AbstractScheme searchSchemeByFilter(long orgId, FilterView filter) {
        if (StringUtils.isNotEmpty((String)this.schemetype)) {
            return this.RDataSelectSchemes.get(this.schemetype).stream().filter(p -> this.matchScheme(orgId, filter, (AbstractScheme)p)).findFirst().get();
        }
        for (Map.Entry<String, List<AbstractScheme>> schemeType : this.RDataSelectSchemes.entrySet()) {
            for (AbstractScheme rds : schemeType.getValue()) {
                if (!this.matchScheme(orgId, filter, rds)) continue;
                return rds;
            }
        }
        return null;
    }

    private boolean matchScheme(long orgId, FilterView filter, AbstractScheme scheme) {
        Optional<String> optional;
        HashMultimap dim2Mem = HashMultimap.create();
        filter.getPageDomain().getAllMembers().forEach(arg_0 -> ReportDataSelectScheme.lambda$matchScheme$28((Multimap)dim2Mem, arg_0));
        filter.getViewPointDomain().getAllMembers().forEach(arg_0 -> ReportDataSelectScheme.lambda$matchScheme$29((Multimap)dim2Mem, arg_0));
        this.checkIsDC(scheme.getModel(), orgId, (Multimap<String, String>)dim2Mem);
        boolean isMatch = true;
        String schemeBP = "EIRpt";
        try {
            schemeBP = ((DynamicObject)scheme.getSchemeDetails().get(DimTypesEnum.PROCESS.getNumber())).getString(NUMBER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isPC = pcBPs.contains(schemeBP);
        for (Object dim : ((ReportDataScheme)scheme).getTreeNodeSchemeDetails().keySet()) {
            String dimnum = dim.toString();
            if (!dim2Mem.containsKey((Object)dimnum)) {
                isMatch = false;
                break;
            }
            if (ThreadCache.get((Object)MATCHPCSCHEME) == null && DimTypesEnum.CURRENCY.getNumber().equals(dimnum) && isPC && dim2Mem.get((Object)dimnum).contains("PC")) break;
            if (ThreadCache.get((Object)MATCHPCSCHEME) == null && DimTypesEnum.CURRENCY.getNumber().equals(dimnum) && !isPC && dim2Mem.get((Object)dimnum).contains("PC")) {
                isMatch = false;
                break;
            }
            SimpleIDNumberTreeNode object = (SimpleIDNumberTreeNode)((ReportDataScheme)scheme).getTreeNodeSchemeDetails().get(dimnum);
            if (dim2Mem.get((Object)dimnum).contains(object.getNumber())) continue;
            isMatch = false;
            break;
        }
        if (isMatch && isPC && (optional = dim2Mem.get((Object)DimTypesEnum.CURRENCY.getNumber()).stream().filter(e -> !Sets.newHashSet((Object[])new String[]{"DC", "EC", "PC"}).contains(e)).findAny()).isPresent()) {
            scheme.appendSchemeDetail(DimTypesEnum.CURRENCY.getNumber(), (Object)BcmThreadCache.findMemberByNum((String)MemberReader.findModelNumberById((Object)scheme.getModel()), (String)DimTypesEnum.CURRENCY.getNumber(), (String)optional.get()));
        }
        return isMatch;
    }

    private void checkIsDC(long modelId, long orgId, Multimap<String, String> dim2Mem) {
        if (dim2Mem.containsKey((Object)DimTypesEnum.PROCESS.getNumber()) && dim2Mem.containsKey((Object)DimTypesEnum.CURRENCY.getNumber())) {
            dim2Mem.get((Object)DimTypesEnum.PROCESS.getNumber()).forEach(p -> {
                String cu = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)orgId, (String)p, (String)"DC", (long)0L, (long)0L).p2;
                if (dim2Mem.get((Object)DimTypesEnum.CURRENCY.getNumber()).contains(cu)) {
                    dim2Mem.put((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)"DC");
                } else if (!Sets.newHashSet((Object[])new String[]{"DC", "EC"}).removeAll(dim2Mem.get((Object)DimTypesEnum.CURRENCY.getNumber()))) {
                    dim2Mem.put((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)"PC");
                }
            });
        }
    }

    public SchemeContext getSchemeContext() {
        return this.schemeContext;
    }

    public void setSchemeContext(SchemeContext schemeContext) {
        this.schemeContext = schemeContext;
    }

    public String getSchemetype() {
        return this.schemetype;
    }

    public void setSchemetype(String schemetype) {
        this.schemetype = schemetype;
    }

    public void setNames(Map<String, String> names) {
        this.names = names;
    }

    public void setRDataSelectSchemes(Map<String, List<AbstractScheme>> RDataSelectSchemes) {
        this.RDataSelectSchemes = RDataSelectSchemes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isCm() {
        return this.isCm;
    }

    public void setCm(boolean cm) {
        this.isCm = cm;
    }

    private static /* synthetic */ void lambda$matchScheme$29(Multimap dim2Mem, IDimMember m) {
        dim2Mem.put((Object)m.getDimension().getNumber(), (Object)m.getNumber());
        if (m instanceof DimMember && ((DimMember)m).getOriNumber() != null) {
            dim2Mem.put((Object)m.getDimension().getNumber(), (Object)((DimMember)m).getOriNumber());
        }
    }

    private static /* synthetic */ void lambda$matchScheme$28(Multimap dim2Mem, IDimMember m) {
        dim2Mem.put((Object)m.getDimension().getNumber(), (Object)m.getNumber());
        if (m instanceof DimMember && ((DimMember)m).getOriNumber() != null) {
            dim2Mem.put((Object)m.getDimension().getNumber(), (Object)((DimMember)m).getOriNumber());
        }
    }
}

