/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.CodeRuleUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ReportDataSelectSchemeSetPlugin
extends AbstractBaseFormPlugin
implements TabSelectListener {
    protected String ctl_entryentity = "entryentity";
    private static final String PROCESS = "process";
    private static final String AUDIT_TRAIL = "audittrail";
    private static final String CURRENCY = "currency";
    private static final String NUMBER = "number";
    private static final String IS_SYS = "issys";
    private static final String MODEL = "model";
    private static final String CURRENT_TABKEY = "currentTabKey";
    private static final String INTERNALCOMPANY = "internalcompany";
    private static final List<String> staticKeysString = Arrays.asList("currency", "process", "audittrail", "datatype", "multigaap", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6", "internalcompany");
    private String type = "1";

    @Override
    public void registerListener(EventObject e) {
        this.addBeforeF7SelectListener(staticKeysString.toArray(new String[0]));
        Tab tab = (Tab)this.getControl("tabap1");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners("btn_save");
        this.addItemClickListeners("advcontoolbarap");
    }

    protected void addBeforeF7SelectListener(String ... idenitiys) {
        for (String idenitiy : idenitiys) {
            BasedataEdit edit = (BasedataEdit)this.getControl(idenitiy);
            if (edit == null) continue;
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            edit.setF7BatchFill(false);
            edit.setF7MultipleSelect(false);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_save".equals(key)) {
            this.deleteBlankRows();
            this.saveData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvAnnualAccountPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            OperationLogUtil.writeOperationLog((IFormView)this.getView().getParentView(), (String)(OpItemEnum.MEMBERSET.getName() + OpItemEnum.SAVE.getName()), (String)(OpItemEnum.SAVE.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)this.getModelId());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_delete": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.ctl_entryentity);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u3002", (String)"ReportDataSelectSchemeSetPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.getModel().deleteEntryRows(this.ctl_entryentity, selectRows);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof NewEntry) {
            DynamicObjectCollection dy = this.getModel().getEntryEntity(this.ctl_entryentity);
            this.getModel().setValue(NUMBER, (Object)CodeRuleUtil.getCodeRuleNumber((String)"bcm_rptadjust", (String)"createtime"), dy.size() - 1);
            this.getModel().setValue(IS_SYS, (Object)"0", dy.size() - 1);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)key);
        QFilter storageTypeFilter = new QFilter("storagetype", "!=", (Object)"3");
        if ("bcm_userdefinedmembertree".equalsIgnoreCase(entity)) {
            QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            qfBuilder.and("dimension", "=", (Object)this.getDimensionByNumber(key).getId());
            qfBuilder.add(storageTypeFilter);
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qfBuilder.toList(), null));
            return;
        }
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(modelFilter);
        qFilterList.add(storageTypeFilter);
        ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    protected Dimension getDimensionByNumber(String keyNumber) {
        Map<Long, Dimension> dimensionMap = this.getDimesnionMap();
        Long dimensionid = dimensionMap.keySet().stream().filter(id -> ((Dimension)dimensionMap.get(id)).getFieldmapped().equals(keyNumber)).findFirst().get();
        return dimensionMap.get(dimensionid);
    }

    protected Map<Long, Dimension> getDimesnionMap() {
        String cache = this.getPageCache().get("dimensions");
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
        }
        return new HashMap<Long, Dimension>();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        long modelid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(MODEL).toString());
        this.getModel().setValue(MODEL, (Object)modelid);
        SchemeContext schemeContext = new SchemeContext(modelid, this.getFormCustomParam("template"));
        ReportDataSelectScheme rdds = ReportDataSchemeUtil.getReportDataSelectScheme(schemeContext, this.type);
        rdds.cacheReportDataSelectScheme(this.getPageCache());
        this.buildEntryView();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap"});
        this.getView().setVisible(Boolean.valueOf(this.isCM()), new String[]{"adjust"});
    }

    private void buildEntryView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{DimTypesEnum.DATATYPE.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.MULTIGAAP.getNumber().toLowerCase(Locale.ENGLISH), "dim1", "dim2", "dim3", "dim4", "dim5", "dim6"});
        this.getPageCache().put(CURRENT_TABKEY, "singleec");
        this.getModel().setValue(MODEL, this.getView().getFormShowParameter().getCustomParam(MODEL));
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,issysdimension,name,number,fieldmapped,shortnumber", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("issysdimension", "=", (Object)false).or(NUMBER, "in", (Object)TemplateUtil.getReportDataDimNums((long)this.getModelId()))});
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ctl_entryentity);
        HashMap dimensionMap = new HashMap();
        dimensions.forEach(dimension -> {
            Dimension dimensionDy = new Dimension(dimension);
            if (!dimensionDy.isIssys()) {
                entryGrid.setColumnProperty(dimensionDy.getFieldmapped(), "header", (Object)new LocaleString(dimensionDy.getName()));
                entryGrid.setColumnProperty(dimensionDy.getFieldmapped() + "after", "header", (Object)new LocaleString(dimensionDy.getName()));
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{dimensionDy.getFieldmapped(), dimensionDy.getFieldmapped() + "after"});
            dimensionMap.put(dimensionDy.getId(), dimensionDy);
        });
        this.getPageCache().put("dimensions", ObjectSerialUtil.toByteSerialized(dimensionMap));
        this.refresh();
        this.getModel().setDataChanged(false);
        this.getModel().updateCache();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "report": {
                this.type = "1";
                break;
            }
            case "search": {
                this.type = "2";
                break;
            }
            case "adjust": {
                this.type = "3";
                break;
            }
        }
        this.tabChange();
    }

    private void tabChange() {
        SchemeContext sctx = new SchemeContext(this.getModelId(), this.getFormCustomParam("template"));
        ReportDataSchemeUtil.getReportDataSelectScheme(sctx, this.type).cacheReportDataSelectScheme(this.getPageCache());
        this.buildEntryView();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.getModel().setValue("schemetype", (Object)this.getSchemesType(), e.getRowDataEntities()[0].getRowIndex());
    }

    private ReportDataSelectScheme updateRDataSelectSchemes() {
        ReportDataSelectScheme rdds = ReportDataSelectScheme.getReportDataSelectScheme(this.getPageCache());
        rdds.getRDataSelectSchemes().remove(this.getSchemesType());
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(this.ctl_entryentity);
        rdds.addAllRDataSelectSchemes(dynamicObjects);
        rdds.cacheReportDataSelectScheme(this.getPageCache());
        return rdds;
    }

    private String getSchemesType() {
        return "all0310";
    }

    private void deleteBlankRows() {
        ArrayList<Integer> nullRow = new ArrayList<Integer>(10);
        HashSet<String> keys = new HashSet<String>(Arrays.asList(NUMBER, "name", PROCESS, AUDIT_TRAIL));
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(this.ctl_entryentity);
        for (int rowIndex = 0; rowIndex < dcs.size(); ++rowIndex) {
            boolean deleteFlag = true;
            for (IDataEntityProperty property : ((DynamicObject)dcs.get(0)).getDataEntityType().getProperties()) {
                if (!keys.contains(property.getName()) || this.getModel().getValue(property.getName(), rowIndex) == null || StringUtil.isEmptyString((String)this.getModel().getValue(property.getName(), rowIndex).toString())) continue;
                deleteFlag = false;
            }
            if (!deleteFlag) continue;
            nullRow.add(rowIndex);
        }
        if (!nullRow.isEmpty()) {
            int[] rowIndexs = new int[nullRow.size()];
            for (int i = 0; i < nullRow.size(); ++i) {
                rowIndexs[i] = (Integer)nullRow.get(i);
            }
            this.getModel().deleteEntryRows(this.ctl_entryentity, rowIndexs);
        }
        this.getModel().updateCache();
    }

    protected void refresh() {
        this.getModel().deleteEntryData(this.ctl_entryentity);
        this.getModel().createNewEntryRow(this.ctl_entryentity);
        this.getModel().deleteEntryRow(this.ctl_entryentity, 0);
        Map<Long, Dimension> dimensionMap = this.getDimesnionMap();
        ReportDataSelectScheme rdds = ReportDataSelectScheme.getReportDataSelectScheme(this.getPageCache());
        String schemesType = this.getSchemesType();
        this.getModel().setDataChanged(false);
        this.getModel().beginInit();
        List<AbstractScheme> abstractSchemes = rdds.getRDataSelectSchemes().get(schemesType);
        if (abstractSchemes != null) {
            abstractSchemes.forEach(rdss -> {
                int row = this.getModel().createNewEntryRow(this.ctl_entryentity);
                this.getModel().setValue(IS_SYS, (Object)(rdss.isIssys() ? "1" : "0"), row);
                this.getModel().setValue("name", (Object)rdss.getName(), row);
                this.getModel().setValue(NUMBER, (Object)rdss.getNumber(), row);
                this.getModel().setValue("schemetype", (Object)schemesType, row);
                rdss.getSchemeDetails().forEach((dimensionnumber, value) -> this.getModel().setValue(dimensionMap.values().stream().filter(p -> p.getNumber().equalsIgnoreCase(dimensionnumber.toString().toLowerCase(Locale.ENGLISH))).findFirst().get().getFieldmapped(), value, row));
            });
        }
        this.getModel().endInit();
        this.getView().updateView(this.ctl_entryentity);
    }

    protected void saveData() {
        DynamicObjectCollection dys = this.getModel().getEntryEntity(this.ctl_entryentity);
        boolean isOk = false;
        isOk = this.isExistAuditTrailDimension() ? dys.stream().anyMatch(dy -> ObjectUtils.isEmpty((Object)dy.get("name")) || ObjectUtils.isEmpty((Object)dy.get(NUMBER)) || ObjectUtils.isEmpty((Object)dy.get(PROCESS)) || ObjectUtils.isEmpty((Object)dy.get(AUDIT_TRAIL))) : dys.stream().anyMatch(dy -> ObjectUtils.isEmpty((Object)dy.get("name")) || ObjectUtils.isEmpty((Object)dy.get(NUMBER)) || ObjectUtils.isEmpty((Object)dy.get(PROCESS)));
        if (isOk) {
            if (this.isExistAuditTrailDimension()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u3001\u8fc7\u7a0b\u3001\u5ba1\u8ba1\u7ebf\u7d22\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u672a\u586b\u5199\u7684\u5fc5\u5f55\u9879\u3002", (String)"ReportDataSelectSchemeSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u3001\u8fc7\u7a0b\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u3002", (String)"ReportDataSelectSchemeSetPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> rdsNameList = new ArrayList<String>();
        for (DynamicObject dynamicObject : dys) {
            rdsNameList.add(dynamicObject.getString("name"));
        }
        HashSet rdsNameSet = new HashSet(rdsNameList);
        if (rdsNameList.size() != rdsNameSet.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportDataSelectSchemeSetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ReportDataSelectScheme rdds = this.updateRDataSelectSchemes();
        rdds.SaveRDataSelectSchemes();
        this.getModel().setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (NUMBER.equalsIgnoreCase(key)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            int row = e.getChangeSet()[0].getRowIndex();
            DynamicObject dy = (DynamicObject)this.getModel().getEntryEntity(this.ctl_entryentity).get(row);
            if (dy.getBoolean(IS_SYS) && !ObjectUtils.isEmpty((Object)oldValue)) {
                this.getModel().setValue(NUMBER, oldValue);
                this.getModel().setDataChanged(false);
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u5236\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3002", (String)"ReportDataSelectSchemeSetPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

