/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;

public class ReportFilterCommDimSetPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final List<String> lockDims = Lists.newArrayList((Object[])new String[]{DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.CURRENCY.getNumber()});
    private static final List<String> aloneSelectDims = Lists.newArrayList((Object[])new String[]{DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber()});

    @Override
    public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        super.setSingleF7Filter(bdEdit);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ItemClassEdit edit = (ItemClassEdit)this.getControl("typemember");
        if (edit != null) {
            edit.setF7MultipleSelect(true);
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners("member", "btn_cancel", "btn_save");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("member".equals(key)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((String)newValue)) {
                int[] selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
                this.getModel().beginInit();
                this.getModel().setValue("data", null, selectIndexs[0]);
                this.getModel().endInit();
                this.getView().updateView("data", selectIndexs[0]);
            }
        } else if ("reportdata".equals(key)) {
            this.getModel().beginInit();
            String reportDataType = (String)e.getChangeSet()[0].getNewValue();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            if (StringUtils.isEmpty((String)reportDataType) || "zidingyi".equals(reportDataType)) {
                for (DynamicObject obj : collection) {
                    obj.set("member", null);
                    obj.set("data", null);
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ENTRYENTITY});
            } else {
                ReportDataSelectScheme rdss = ReportDataSelectScheme.getReportDataSelectScheme(this.getParentView().getPageCache());
                Map<String, DynamicObject> dimNum2Items = rdss.searchSchemeByNumber(reportDataType);
                int index = 0;
                for (DynamicObject obj : collection) {
                    String dimNum = obj.getDynamicObject("dim").getString("number");
                    if (dimNum2Items.get(dimNum) != null) {
                        DynamicObject dyObj = dimNum2Items.get(dimNum);
                        ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
                        JSONObject object = new JSONObject();
                        object.put("id", (Object)dyObj.getString("id"));
                        object.put("number", (Object)dyObj.getString("number"));
                        object.put("name", (Object)dyObj.getString("name"));
                        ls.add(object);
                        List names = ls.stream().map(o -> (String)o.get((Object)"name")).collect(Collectors.toList());
                        obj.set("member", (Object)String.join((CharSequence)",", names));
                        obj.set("data", (Object)JSONObject.toJSONString(ls));
                    } else {
                        obj.set("member", null);
                        obj.set("data", null);
                    }
                    if (lockDims.contains(dimNum)) {
                        this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"member"});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"member"});
                    }
                    ++index;
                }
            }
            this.getView().updateView(ENTRYENTITY);
            this.getModel().endInit();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            long tempId = (Long)this.getFormCustomParam("tempid");
            DynamicObject tempDy = BusinessDataServiceHelper.loadSingle((Object)tempId, (String)"bcm_templateentity");
            IDataModel model = this.getModel();
            String number = (String)this.getFormCustomParam("number");
            String name = (String)this.getFormCustomParam("name");
            List comboItems = SerializationUtils.fromJsonStringToList((String)((String)this.getFormCustomParam("comboItems")), ComboItem.class);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"ReportFilterCommDimSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            comboItem.setValue("zidingyi");
            comboItems.add(comboItem);
            ComboEdit combo = (ComboEdit)this.getView().getControl("reportdata");
            combo.setComboItems(comboItems);
            this.getModel().setValue("number", (Object)number);
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue("reportdata", this.getFormCustomParam("defaultCombo"));
            this.getView().updateView("reportdata");
            this.buildEntry2(tempDy, model);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void buildEntry2(DynamicObject tempDy, IDataModel model) {
        TemplateModel tempModel = ModelDataProvider.getTemplateModel(tempDy.getLong("id"));
        tempModel.getPageDimensionEntries();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        if (!tempModel.getPageDimensionEntries().isEmpty()) {
            DynamicObject[] dims = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,number,name,membermodel", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId())});
            Map<String, DynamicObject> num2Dims = Arrays.stream(dims).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
            String reportDataType = (String)this.getFormCustomParam("defaultCombo");
            ReportDataSelectScheme rdss = ReportDataSelectScheme.getReportDataSelectScheme(this.getParentView().getPageCache());
            Map<String, DynamicObject> dimNum2Items = rdss.searchSchemeByNumber(reportDataType);
            List schemeDims = rdss.getSchemeContext().getDimensions();
            int size = schemeDims.size();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            int index = 0;
            Iterator iterator = schemeDims.iterator();
            while (iterator.hasNext()) {
                Dimension pageDim;
                Dimension dimension = pageDim = (Dimension)iterator.next();
                String number = pageDim.getNumber();
                if (dimNum2Items.get(number) != null) {
                    DynamicObject dyObj = dimNum2Items.get(number);
                    ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
                    JSONObject object = new JSONObject();
                    object.put("id", (Object)dyObj.getString("id"));
                    object.put("number", (Object)dyObj.getString("number"));
                    object.put("name", (Object)dyObj.getString("name"));
                    ls.add(object);
                    List names = ls.stream().map(o -> (String)o.get((Object)"name")).collect(Collectors.toList());
                    model.setValue("member", (Object)String.join((CharSequence)",", names), index);
                    model.setValue("data", (Object)JSONObject.toJSONString(ls), index);
                }
                model.setValue("dimtype", (Object)num2Dims.get(dimension.getNumber()).getString("membermodel"), index);
                model.setValue("dim", (Object)dimension.getId(), index);
                if (lockDims.contains(number)) {
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"member"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"member"});
                }
                ++index;
            }
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void buildEntry(DynamicObject tempDy, IDataModel model) {
        TemplateModel tempModel = ModelDataProvider.getTemplateModel(tempDy.getLong("id"));
        String filterdimdata = (String)this.getFormCustomParam("filterdimdata");
        JSONArray dimMembs = new JSONArray();
        if (!StringUtils.isEmpty((String)filterdimdata)) {
            dimMembs = (JSONArray)JSONObject.parse((String)filterdimdata);
        }
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        if (!tempModel.getFilterDimensionEntries().isEmpty()) {
            DynamicObject[] dims = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,number,name,membermodel", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId())});
            Map<String, DynamicObject> num2Dims = Arrays.stream(dims).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
            model.batchCreateNewEntryRow(ENTRYENTITY, tempModel.getFilterDimensionEntries().size());
            int index = 0;
            for (FilterDimensionEntry filterDim : tempModel.getFilterDimensionEntries()) {
                model.setValue("dimtype", (Object)num2Dims.get(filterDim.getDimension().getNumber()).getString("membermodel"), index);
                for (Object dimMemb : dimMembs) {
                    JSONArray membs;
                    if (!((JSONObject)dimMemb).getString("number").equals(filterDim.getDimension().getNumber()) || (membs = ((JSONObject)dimMemb).getJSONArray("members")) == null) continue;
                    List ls = membs.stream().map(r -> {
                        JSONObject object = new JSONObject();
                        object.put("id", (Object)((JSONObject)r).getLong("id"));
                        object.put("number", (Object)((JSONObject)r).getString("number"));
                        object.put("name", (Object)((JSONObject)r).getString("name"));
                        return object;
                    }).collect(Collectors.toList());
                    List names = ls.stream().map(o -> (String)o.get((Object)"name")).collect(Collectors.toList());
                    this.getModel().setValue("member", (Object)String.join((CharSequence)",", names), index);
                    this.getModel().setValue("data", (Object)JSONObject.toJSONString(ls), index);
                }
                model.setValue("dim", (Object)num2Dims.get(filterDim.getDimension().getNumber()), index);
                ++index;
            }
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("member".equals(key)) {
            int[] selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
            if (selectIndexs.length <= 0) {
                return;
            }
            try {
                String entityModel = ((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(selectIndexs[0])).getString("dimtype");
                String dimNum = ((DynamicObject)((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(selectIndexs[0])).get("dim")).getString("number");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entityModel, (boolean)true);
                String filterdimdata = ((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(selectIndexs[0])).getString("data");
                JSONArray membs = new JSONArray();
                if (!StringUtils.isEmpty((String)filterdimdata)) {
                    membs = (JSONArray)JSONObject.parse((String)filterdimdata);
                    List ls = membs.stream().map(r -> ((JSONObject)r).getLong("id")).collect(Collectors.toList());
                    parameter.setSelectedRows(ls.toArray());
                }
                QFilter f7MemberScope = this.getF7MemberScope(entityModel, dimNum);
                QFilter filter = new QFilter("model.id", "=", (Object)this.getModelId());
                filter.and("dimension", "=", (Object)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNum));
                filter.and(f7MemberScope);
                if (DimTypesEnum.CURRENCY.getNumber().equals(dimNum)) {
                    filter.and("isleaf", "=", (Object)true);
                }
                parameter.getListFilterParameter().setFilter(filter);
                if (aloneSelectDims.contains(dimNum)) {
                    parameter.setMultiSelect(false);
                }
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)parameter);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        } else if ("btn_save".equals(key)) {
            DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRYENTITY);
            JSONArray dims = new JSONArray(16);
            for (DynamicObject dy : doc) {
                JSONObject object = new JSONObject();
                if (dy.getDynamicObject("dim") == null || StringUtils.isEmpty((String)dy.getString("data"))) continue;
                object.put("id", (Object)dy.getDynamicObject("dim").getLong("id"));
                object.put("number", (Object)dy.getDynamicObject("dim").getString("number"));
                object.put("name", (Object)dy.getDynamicObject("dim").getString("name"));
                if (!StringUtils.isEmpty((String)dy.getString("data"))) {
                    JSONArray membs = (JSONArray)JSONObject.parse((String)dy.getString("data"));
                    object.put("members", (Object)membs);
                }
                dims.add((Object)object);
            }
            this.getView().returnDataToParent((Object)JSONObject.toJSONString((Object)dims));
            this.getView().close();
        }
    }

    private QFilter getF7MemberScope(String entityModel, String dimNum) {
        long tempId = (Long)this.getFormCustomParam("tempid");
        TemplateModel tempModel = ModelDataProvider.getTemplateModel(tempId);
        QFilter filter = null;
        for (PageDimensionEntry fe : tempModel.getPageDimensionEntries()) {
            if (!fe.getDimension().getNumber().equals(dimNum)) continue;
            List members = fe.getMembers();
            if (!fe.getDimension().getMemberEntityNumber().equals(entityModel)) continue;
            for (Member member : members) {
                String entity = member.getDataEntityNumber();
                Long memberid = member.getId();
                int range = member.getScope();
                MembRangeItem item = new MembRangeItem(entity, memberid, member.getNumber(), range, false, (Object)this.getModelId());
                if (filter == null) {
                    filter = item.buildFilterByScope();
                    continue;
                }
                filter.or(item.buildFilterByScope());
            }
        }
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getReturnData() != null && event.getReturnData() instanceof ListSelectedRowCollection) {
            int[] selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
            int selectedRow = selectIndexs[0];
            List ls = ((ListSelectedRowCollection)event.getReturnData()).stream().map(r -> {
                JSONObject object = new JSONObject();
                object.put("id", r.getPrimaryKeyValue());
                object.put("number", (Object)r.getNumber());
                object.put("name", (Object)r.getName());
                return object;
            }).collect(Collectors.toList());
            List names = ls.stream().map(o -> (String)o.get((Object)"name")).collect(Collectors.toList());
            this.getModel().setValue("member", (Object)String.join((CharSequence)",", names), selectedRow);
            this.getModel().setValue("data", (Object)JSONObject.toJSONString(ls), selectedRow);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
    }
}

