/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.AbstractJobHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.server.realtime.RealtimeJobHandler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.report.NewReportMultiPrintService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.formplugin.report.export.UnSupportSpreadJsonException;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportMultiExportTask
extends AbstractTask {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportMultiExportTask.class);
    private String feedBackMsg = "";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Date beginTime;
        String message;
        List<Object> data;
        Recorder serviceRecord;
        block21: {
            Recorder times = new Recorder((Object)0);
            serviceRecord = new Recorder(null);
            String reportMultiExportTask_0 = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u3002", (String)"ReportMultiExportTask_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.feedbackProgress(0, reportMultiExportTask_0, null);
            data = new ArrayList(16);
            message = "";
            beginTime = TimeServiceHelper.now();
            try {
                if (this.isStop()) {
                    this.stop();
                }
                if (!params.containsKey("service")) break block21;
                String serviceStr = (String)params.get("service");
                serviceRecord.setRecord(ObjectSerialUtil.deSerializedBytes((String)serviceStr));
                Consumer<Integer> fillback_consumer = r -> {
                    String exportShowMsg = this.getExportShowMsg((ReportMultiExportService)serviceRecord.getRecord());
                    if (StringUtils.isNotEmpty((CharSequence)exportShowMsg)) {
                        if (this.isStop()) {
                            this.feedbackProgress(100, exportShowMsg, null);
                            this.stop();
                        } else {
                            this.feedbackProgress((int)r, exportShowMsg, null);
                        }
                    }
                };
                ((ReportMultiExportService)serviceRecord.getRecord()).setTaskConsumer(fillback_consumer);
                ((ReportMultiExportService)serviceRecord.getRecord()).initService();
                try {
                    this.waitForBigTaskBefore((Recorder<ReportMultiExportService>)serviceRecord);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                times.setRecord((Object)((ReportMultiExportService)serviceRecord.getRecord()).tempReportInfo.getSize());
                if (((ReportMultiExportService)serviceRecord.getRecord()).isPackDownload) {
                    ((ReportMultiExportService)serviceRecord.getRecord()).doExport_Excels();
                    data.add(((ReportMultiExportService)serviceRecord.getRecord()).zipFile("", ((ReportMultiExportService)serviceRecord.getRecord()).fileNm2UrlMap));
                } else {
                    data = ((ReportMultiExportService)serviceRecord.getRecord()).doExport_Excels();
                }
                if (((ReportMultiExportService)serviceRecord.getRecord()).isJQExport) {
                    if (((ReportMultiExportService)serviceRecord.getRecord()).isExportINI) {
                        ((ReportMultiExportService)serviceRecord.getRecord()).doMultiExport_IniFile();
                        data.clear();
                        data.addAll(((ReportMultiExportService)serviceRecord.getRecord()).zipFiles(""));
                    }
                    if (((ReportMultiExportService)serviceRecord.getRecord()).isExportXml) {
                        ((ReportMultiExportService)serviceRecord.getRecord()).doExport_Xml();
                        data.clear();
                        data.addAll(((ReportMultiExportService)serviceRecord.getRecord()).zipFiles(""));
                    }
                }
            }
            catch (Exception e) {
                ((ReportMultiExportService)serviceRecord.getRecord()).setCompleteSheet(new AtomicInteger((Integer)times.getRecord()));
                if (e.getCause() instanceof UnSupportSpreadJsonException) {
                    message = e.getCause().getMessage();
                }
                log.error((Throwable)e);
            }
        }
        if (!(serviceRecord.getRecord() instanceof NewReportMultiPrintService)) {
            ArrayList<DynamicObject> urlDys = new ArrayList<DynamicObject>(16);
            HashMap<String, String> fileNameMap = ((ReportMultiExportService)serviceRecord.getRecord()).getFileNm2UrlMap();
            for (String string : data) {
                DynamicObject urlDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exporturllist");
                urlDy.set("url", (Object)string);
                if (((ReportMultiExportService)serviceRecord.getRecord()).isPackDownload || ((ReportMultiExportService)serviceRecord.getRecord()).isJQExport) {
                    urlDy.set("filename", (Object)(((ReportMultiExportService)serviceRecord.getRecord()).getZipFileName() + ".zip"));
                } else if (ReportMultiExportTask.getKey(fileNameMap, string) != null) {
                    urlDy.set("filename", (Object)ReportMultiExportTask.getKey(fileNameMap, string).replace(".", DateTimeUtils.format((Date)new Date(), (String)"_yyyy_MM_dd_mm_ss") + "."));
                } else {
                    urlDy.set("filename", (Object)ReportMultiExportTask.getKey(fileNameMap, string));
                }
                urlDy.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                urlDy.set("createdate", (Object)beginTime);
                urlDy.set("modifydate", (Object)TimeServiceHelper.now());
                urlDy.set("type", (Object)Integer.toString(((ReportMultiExportService)serviceRecord.getRecord()).getPageSourceEnum().getIndex()));
                urlDy.set("log", (Object)message);
                urlDy.set("model", (Object)((ReportMultiExportService)serviceRecord.getRecord()).getModelId());
                urlDys.add(urlDy);
            }
            SaveServiceHelper.save((DynamicObject[])urlDys.toArray(new DynamicObject[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "true");
        result.put("data", data);
        result.put("message", message);
        result.put("fileNm2OrgMap", ((ReportMultiExportService)serviceRecord.getRecord()).fileNm2OrgMap);
        result.put("zipName", ((ReportMultiExportService)serviceRecord.getRecord()).getZipFileName());
        result.put("fileList", ((ReportMultiExportService)serviceRecord.getRecord()).getFileList().stream().collect(Collectors.joining(",")));
        result.put("noEffOrgs", ((ReportMultiExportService)serviceRecord.getRecord()).getNoEffectiveOrg().stream().collect(Collectors.joining(",")));
        log.warn("multiexport---------task----------" + String.join((CharSequence)",", data) + TimeServiceHelper.now());
        this.feedbackCustomdata(result);
        try {
            String taskIdKey = (String)GlobalCacheServiceHelper.getCommonCache().getIfPresent("exportReport_Max");
            String jobid = "";
            if (this.getMessageHandler() instanceof AbstractJobHandler) {
                jobid = ((AbstractJobHandler)this.getMessageHandler()).convertMessage(new MessageInfo()).getId();
            }
            if (taskIdKey != null && taskIdKey.equals(jobid)) {
                GlobalCacheServiceHelper.getCommonCache().invalidateByKey("exportReport_Max");
            }
        }
        catch (Exception e) {
            log.error("multiexporttask_end" + e);
        }
    }

    private String getExportShowMsg(ReportMultiExportService exportService) {
        ReportExportInfo exportInfo = exportService.getCurrentFileInfo();
        if (exportInfo == null || exportService.getCurrentSheetMsg().get() == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)this.feedBackMsg, (CharSequence)exportService.getCurrentSheetMsg().get())) {
            return null;
        }
        this.feedBackMsg = exportService.getCurrentSheetMsg().get();
        int totalReportNum = exportService.getTempReportInfo().getExportInfos().size();
        int sheetNumPerReport = exportService.getTempReportInfo().getExportInfos().get(0).getSheetSize();
        int complementSheet = exportService.getCompleteSheet().get();
        int complementReportNum = complementSheet / sheetNumPerReport;
        String exportShowMsg = String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5bfc\u51fa%1$s\u4efd\uff0c\u8fd8\u5269\u4f59%2$s\u4efd\u3002", (String)"ReportMultiExportTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), complementReportNum, totalReportNum - complementReportNum);
        for (String unweaving : exportInfo.getUnweavings()) {
            if (!unweaving.startsWith(exportService.getCurrentSheetMsg().get())) continue;
            String[] unweavingArray = unweaving.split("\\|");
            String fyName = MemberReader.findFyMemberByNum((String)exportService.getCube(), (String)unweavingArray[0]).getName();
            String periodName = MemberReader.findPeriodMemberByNum((String)exportService.getCube(), (String)unweavingArray[1]).getName();
            String orgName = MemberReader.findEntityMemberById((String)exportService.getCube(), (Long)Long.valueOf(unweavingArray[2])).getName();
            exportShowMsg = exportShowMsg + String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5728\u6267\u884c%s\u7684\u8868\u3002", (String)"ReportMultiExportTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName + fyName + periodName);
            return exportShowMsg;
        }
        for (String weaving : exportInfo.getWeavings().keySet()) {
            if (!weaving.startsWith(exportService.getCurrentSheetMsg().get())) continue;
            DynamicObject dynamicObject = exportInfo.getWeavings().get(weaving);
            String orgName = MemberReader.findEntityMemberById((String)exportService.getCube(), (Long)dynamicObject.getLong(7)).getName();
            String fyName = MemberReader.findFyMemberById((String)exportService.getCube(), (Long)dynamicObject.getLong(11)).getName();
            String periodName = MemberReader.findPeriodMemberById((String)exportService.getCube(), (Long)dynamicObject.getLong(13)).getName();
            String curencyName = MemberReader.findCurrencyMemberById((String)exportService.getCube(), (Long)dynamicObject.getLong(15)).getName();
            exportShowMsg = exportShowMsg + String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5728\u6267\u884c%s\u7684\u8868\u3002", (String)"ReportMultiExportTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName + fyName + periodName + curencyName);
            return exportShowMsg;
        }
        return exportShowMsg;
    }

    private void waitForBigTaskBefore(Recorder<ReportMultiExportService> serviceRecord) {
        String maxStr = ConfigServiceHelper.getStringParamNoModel((String)"exportReport_Max");
        if (StringUtils.isNotEmpty((CharSequence)maxStr)) {
            int maxValue = Integer.parseInt(maxStr);
            String jobid = ((RealtimeJobHandler)this.getMessageHandler()).convertMessage(new MessageInfo()).getId();
            if (((ReportMultiExportService)serviceRecord.getRecord()).tempReportInfo.getSize() > maxValue) {
                GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"exportReport_Max", () -> jobid);
            }
            CountDownLatch latch = new CountDownLatch(1);
            ThreadPoolService.runInReportExportThread2(() -> {
                try {
                    boolean isHasRunning = true;
                    while (((ReportMultiExportService)serviceRecord.getRecord()).tempReportInfo.getSize() > maxValue && isHasRunning) {
                        String taskIdKey = (String)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"exportReport_Max", () -> jobid);
                        if (StringUtils.isEmpty((CharSequence)taskIdKey) || jobid.equals(taskIdKey)) {
                            isHasRunning = false;
                            break;
                        }
                        if (!isHasRunning) continue;
                        ThreadCache.remove((Object)"local-cache");
                        Thread.sleep(3000L);
                        GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"exportReport_Max", () -> jobid);
                    }
                    if (!isHasRunning) {
                        latch.countDown();
                    }
                    if (((ReportMultiExportService)serviceRecord.getRecord()).tempReportInfo.getSize() <= maxValue) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
            });
            if (((ReportMultiExportService)serviceRecord.getRecord()).tempReportInfo.getSize() > maxValue) {
                GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"exportReport_Max", () -> jobid);
            }
            try {
                latch.await();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    protected boolean isStop() {
        return super.isStop();
    }

    public void stop() throws KDException {
        super.stop();
    }

    protected void checkIsStop() {
        super.checkIsStop();
    }

    public static String getKey(HashMap<String, String> map, String value) {
        String mapKey = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            mapKey = entry.getKey();
        }
        return mapKey;
    }

    public String getFeedBackMsg() {
        return this.feedBackMsg;
    }

    public void setFeedBackMsg(String feedBackMsg) {
        this.feedBackMsg = feedBackMsg;
    }
}

