/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.NewReportMultiPrintService;
import kd.fi.bcm.formplugin.report.ReportMultiExportPlugin;
import kd.fi.bcm.formplugin.report.export.FileInfo;
import kd.fi.bcm.spread.util.SpreadUtils;

public class ReportMultiPrintPlugin
extends ReportMultiExportPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportMultiPrintPlugin.class);
    private static NumberFormat format = NumberFormat.getInstance();

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pack_download", "floatdisplay"});
    }

    @Override
    public NewReportMultiPrintService getTaskComsumerService() {
        NewReportMultiPrintService service = new NewReportMultiPrintService();
        return service;
    }

    @Override
    public String getTaskClassName() {
        return "kd.fi.bcm.formplugin.report.ReportMultiExportTask";
    }

    @Override
    public String getTaskJobInfoName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ReportMultiExportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void downloadFile(ByteArrayOutputStream oo, FileInfo fileInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshSpread(String fileName, byte[] bytes) {
        ByteArrayInputStream excelStream = new ByteArrayInputStream(bytes);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String json = SpreadUtils.getStrFromInsByCode((InputStream)excelStream, (Charset)StandardCharsets.UTF_8);
        String pdfURL = "";
        ByteArrayOutputStream out = null;
        try {
            out = SpreadUtils.getByteArrayOutputStream((String)json);
            pdfURL = cache.saveAsUrl(fileName + ".pdf", out.toByteArray(), 100);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (excelStream != null) {
                    ((InputStream)excelStream).close();
                }
            }
            catch (IOException e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        this.downloadFile(pdfURL, "bcm_report_list", "47150e89000000ac");
    }

    static {
        format.setGroupingUsed(true);
    }
}

