/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.multi.ReportCacheService;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabManager;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByTemplateStyleView;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.GZIPUtils;

public class ReportToVoucherPlugin
extends AbstractMultiReportPlugin
implements TabSelectListener,
TreeNodeClickListener {
    private static final String CACHE_TREETEMPLATE = "cache_treetemplate";
    private static final String ROWRLIST = "rlist";
    private static final String RFOCUS = "rfocus";
    private static final String CMDNAMEKEY = "closeTab";
    private ReportCacheService cacheService;
    private static final List<String> dimKeys = Collections.singletonList("scenario");
    private static final String SHOWTMPTYPE_CACHE = "showtmptype";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String MODEL_ID = "modelid";
    private static final String SCENARIO = "scenario";
    private static final String TREEVIEW_ENTITY = "treeview_entity";
    private static final String POSITION = "position";
    private static final String TAB_SELECT = "tabselect";
    private static final String SEARCH_BEFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";
    private static final String RPTEXP = "rptexp";
    private static final String TEMPLATE_ID = "templateid";
    private static final String POSITION_JSON = "positionjson";
    private static final String SPREAD = "spread";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.cacheService = new ReportCacheService(this.getPageCache());
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEditModel;
        this.addItemClickListeners("toolbarap");
        TreeView modelTreeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        modelTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(SCENARIO);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((basedataEditModel = (BasedataEdit)this.getControl(MODEL)) != null) {
            basedataEditModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Tab reportTab = (Tab)this.getControl("reporttab");
        reportTab.addItemClickListener((ItemClickListener)this);
        reportTab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(SEARCH_BEFORE, SEARCH_NEXT, "btn_confirm", "btn_cancel");
        Search sl = (Search)this.getControl("templatesearchap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    ReportToVoucherPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
                } else {
                    ReportToVoucherPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, event -> {
            if (this.getReportTabInfoManager().getCurrSelectReportTabInfo() == null) {
                return;
            }
            if (this.getPageCache().get("show") != null) {
                String initpos = this.getPageCache().get("initposition");
                Point point = ExcelUtils.pos2Point((String)initpos.split(":")[0]);
                this.setSelector(new SpreadSelector(point.y, point.x, point.y, point.x));
                HashMap<String, Integer> selectparams = new HashMap<String, Integer>();
                selectparams.put("r", point.y);
                selectparams.put("c", point.x);
                selectparams.put("rc", 1);
                selectparams.put("cc", 1);
                SpreadClientInvoker.invokeSetSelectionsMethod(this.getClientViewProxy(), "report", selectparams);
                this.getPageCache().remove("show");
            }
            Cell cell = this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            this.setReportStausBar(event);
            this.setSelectRptPosition(cell);
        });
    }

    private void setSelectRptPosition(Cell cell) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        String tmplName = this.getTemplateModel().getName();
        int row = cell.getRow();
        int col = cell.getCol();
        String position = ExcelUtils.xy2Pos((int)col, (int)row);
        if (TemplateTypeEnum.DYNA.getType() == this.getTemplateModel().getTemplateType().intValue()) {
            int direct = 0;
            for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                List basepoints = e.getBasePoints();
                if (basepoints.isEmpty()) continue;
                if (direct == 0) {
                    direct = ((BasePointInfo)basepoints.get(0)).getDirect();
                }
                boolean hitposition = false;
                for (BasePointInfo basepoint : basepoints) {
                    RangeModel b = new RangeModel(basepoint.getDynaRange());
                    if (direct == 2) {
                        if (b.getY_start() <= ExcelUtils.pos2Y((String)position) && ExcelUtils.pos2Y((String)position) <= b.getY_end()) {
                            position = ExcelUtils.xy2Pos((int)ExcelUtils.pos2X((String)position), (int)b.getY_start()) + ":" + ExcelUtils.xy2Pos((int)ExcelUtils.pos2X((String)position), (int)b.getY_end());
                            hitposition = true;
                        }
                    } else if (b.getX_start() <= ExcelUtils.pos2X((String)position) && ExcelUtils.pos2X((String)position) <= b.getX_end()) {
                        position = ExcelUtils.xy2Pos((int)b.getX_start(), (int)ExcelUtils.pos2Y((String)position)) + ":" + ExcelUtils.xy2Pos((int)b.getX_end(), (int)ExcelUtils.pos2Y((String)position));
                        hitposition = true;
                    }
                    if (!hitposition) continue;
                    break;
                }
                if (!hitposition) continue;
                break;
            }
            this.getModel().setValue(POSITION, (Object)(tmplName + "!" + position));
        } else {
            this.getModel().setValue(POSITION, (Object)(tmplName + "!" + position));
        }
        returnData.put(TEMPLATE_ID, Long.toString(this.getTemplateModel().getId()));
        returnData.put(MODEL_ID, String.valueOf(this.getModelId()));
        returnData.put("scenarioid", ((DynamicObject)this.getModel().getValue(SCENARIO)).getString("id"));
        returnData.put(POSITION, position);
        this.getPageCache().put(POSITION_JSON, SerializationUtils.serializeToBase64(returnData));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam(RPTEXP) != null && !StringUtils.isEmpty((CharSequence)((CharSequence)this.getFormCustomParam(RPTEXP))) && this.getPageCache().get("show") == null && this.getPageCache().get("first") == null) {
            this.getPageCache().put("show", (String)this.getFormCustomParam(RPTEXP));
            this.getPageCache().put("first", "true");
            String json = (String)this.getFormCustomParam(RPTEXP);
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)json);
            this.getModel().setValue(MODEL, map.get(MODEL_ID));
            this.getPageCache().put(MODEL_ID, (String)map.get(MODEL_ID));
            this.getModel().setValue(SCENARIO, map.get("scenarioid"));
            this.getPageCache().put("scenarioId", (String)map.get("scenarioid"));
            this.refreshTree();
            TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
            treeView.focusNode(new TreeNode(null, (String)map.get(TEMPLATE_ID), ""));
            this.treeNodeClick(new TreeNodeEvent((Object)"", null, map.get(TEMPLATE_ID)));
            this.getPageCache().put("initposition", (String)map.get(POSITION));
            this.getPageCache().put(POSITION_JSON, json);
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("callback", "invokeAction");
            params.put("invokemethod", "setBlankSpread");
            SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), "report", params);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String f7Key = e.getKey();
        long modelId = this.getModelId();
        if (f7Key.equals(SCENARIO) && modelId != 0L) {
            String pagekey = e.getKey();
            BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), modelId, f7Key, pagekey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, SingleF7TypeEnum.LEAF);
            e.setControl((Control)f7);
        }
    }

    public void setBlankSpread(String spreadjson) {
        if (this.getPageCache().get(SPREAD) == null) {
            this.getPageCache().put(SPREAD, spreadjson);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                DynamicObject oldValue;
                if (this.getModel().getValue(MODEL) != null) {
                    this.getPageCache().put(MODEL_ID, ((DynamicObject)this.getModel().getValue(MODEL)).getString("id"));
                }
                if ((oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue()) == null && (oldValue != null || TAB_SELECT.equals(this.getPageCache().get(TAB_SELECT)))) break;
                this.initF7();
                this.closeTab0(null);
                this.refreshTree();
                this.getModel().setValue(POSITION, null);
                this.getPageCache().remove(POSITION_JSON);
                this.getPageCache().put(TAB_SELECT, "");
                break;
            }
            case "scenario": {
                DynamicObject scenariooldValue;
                if (this.getModel().getValue(SCENARIO) != null) {
                    this.getPageCache().put("scenarioId", ((DynamicObject)this.getModel().getValue(SCENARIO)).getString("id"));
                }
                if ((scenariooldValue = (DynamicObject)e.getChangeSet()[0].getOldValue()) == null && (scenariooldValue != null || TAB_SELECT.equals(this.getPageCache().get(TAB_SELECT)))) break;
                this.closeTab0(null);
                this.refreshTree();
                this.getModel().setValue(POSITION, null);
                this.getPageCache().remove(POSITION_JSON);
                this.getPageCache().put(TAB_SELECT, "");
                break;
            }
            case "showtmptype": {
                String showType = (String)e.getChangeSet()[0].getNewValue();
                this.getPageCache().put(SHOWTMPTYPE_CACHE, showType);
                this.refreshTree();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String currentTab = arg0.getTabKey();
        this.getPageCache().put("tabkey_selected", currentTab);
        this.switchTab(currentTab);
        this.getView().getFormShowParameter().setAppId("cm");
        this.getPageCache().put("thismodel", ((DynamicObject)this.getModel().getValue(MODEL)).getString("id"));
        this.getPageCache().put("thisscenario", ((DynamicObject)this.getModel().getValue(SCENARIO)).getString("id"));
        super.loadReport();
        String modelid = this.getPageCache().get("thismodel");
        String scenarioid = this.getPageCache().get("thisscenario");
        this.getPageCache().put(TAB_SELECT, TAB_SELECT);
        this.getModel().setValue(MODEL, (Object)modelid);
        this.getModel().setValue(SCENARIO, (Object)scenarioid);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        List qFilters;
        BasedataEdit base;
        String key = ((BasedataEdit)arg0.getSource()).getKey();
        if (SCENARIO.equals(key)) {
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ReportToVoucherPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            base = (BasedataEdit)arg0.getSource();
            qFilters = base.getQFilters();
            if (qFilters == null) {
                qFilters = Lists.newArrayList();
                base.setQFilters(qFilters);
            }
            qFilters.add(QFilter.of((String)"model = ? and isleaf = ?", (Object[])new Object[]{this.getPageCache().get(MODEL_ID), "1"}));
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setQFilters(qFilters);
        }
        if (MODEL.equals(key)) {
            base = (BasedataEdit)arg0.getSource();
            qFilters = base.getQFilters();
            if (qFilters == null) {
                qFilters = Lists.newArrayList();
                base.setQFilters(qFilters);
            }
            QFilter qf = new QFilter("ReportType", "in", (Object)new String[]{ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.CM.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()});
            qFilters.add(qf);
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter listFilterParameter = param.getListFilterParameter();
            listFilterParameter.setQFilters(qFilters);
            arg0.getFormShowParameter().setCustomParam("noNeedDefaultQFilter", (Object)true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
    }

    private void initF7() {
        this.getModel().setValue(SCENARIO, null);
        this.getModel().setValue(POSITION, (Object)"");
        this.getView().updateView(SCENARIO);
        this.getView().updateView(POSITION);
    }

    private void refreshTree() {
        if (this.getModel().getValue(MODEL) != null && this.getModel().getValue(SCENARIO) != null) {
            Long modelid = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
            this.buildLeftTree(modelid);
        } else {
            TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
            tree.deleteAllNodes();
        }
    }

    private void buildLeftTree(Long modelid) {
        DynamicObjectCollection rootNodecollection = this.getTreeListORM(modelid);
        if (rootNodecollection == null || rootNodecollection.isEmpty()) {
            TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
            tree.deleteAllNodes();
        } else {
            TemplateTreeNode root = new TemplateTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportToVoucherPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            String showType = this.getPageCache().get(SHOWTMPTYPE_CACHE);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(MODEL, "=", (Object)modelid);
            qfBuilder.add("usage", "=", (Object)"1");
            qfBuilder.add("templatetype", "!=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType()));
            qfBuilder.add("status", "=", (Object)"1");
            root = TreeBuilder.getTemplateTreeNew((DynamicObjectCollection)rootNodecollection, (TemplateTreeNode)root, () -> qfBuilder.toArray(), (String)showType, templateColls -> this.setScenarioFilte(templateColls));
            root.SetIsOpened(true);
            this.initTree((AbstractTreeNode<Object>)root);
        }
    }

    private void setScenarioFilte(DynamicObjectCollection templateColls) {
        HashSet havePermIds = new HashSet();
        templateColls.forEach(dyn -> havePermIds.add(dyn.getLong("id")));
        if (!havePermIds.isEmpty()) {
            Long scenarioId = Long.valueOf(((DynamicObject)this.getModel().getValue(SCENARIO)).getString("id"));
            List templateModels = TemplateRangeService.getTemplateModels(havePermIds, (long)this.getModelId(), (boolean)false, (boolean)true);
            for (TemplateModel t : templateModels) {
                if (TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)t, (Object)scenarioId)) continue;
                havePermIds.remove(t.getId());
            }
        }
        Iterator it = templateColls.iterator();
        while (it.hasNext()) {
            if (havePermIds.contains(((DynamicObject)it.next()).getLong("id"))) continue;
            it.remove();
        }
    }

    private DynamicObjectCollection getTreeListORM(Long modelid) {
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelid);
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", new QFilter[]{filterModel}, "longnumber");
        return doc;
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (root.getChildren() == null) {
                return;
            }
            treemodel.ache2page(this.getPageCache(), CACHE_TREETEMPLATE);
        }
    }

    private void searchMember(String text) {
        if (this.getModel().getValue(SCENARIO) == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(10);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREETEMPLATE);
        if (treeModel == null) {
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (!list.isEmpty()) {
            this.getPageCache().put(ROWRLIST, SerializationUtils.toJsonString(list));
            this.getPageCache().put(RFOCUS, "0");
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp) != null && ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ReportToVoucherPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if (SEARCH_BEFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            int rowCount = 0;
            TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREETEMPLATE);
            String rowcache = this.getPageCache().get(ROWRLIST);
            String count = this.getPageCache().get(RFOCUS);
            if (count != null) {
                rowCount = Integer.parseInt(count);
            }
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportToVoucherPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if (SEARCH_BEFORE.equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ReportToVoucherPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if (SEARCH_NEXT.equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ReportToVoucherPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            String focusnode = String.valueOf(rowList.get(rowCount));
            this.getPageCache().put(RFOCUS, String.valueOf(rowCount));
            ITreeNode parent = treeModel.searchByNodeId(focusnode).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp) != null && treeModel.searchByNodeId(temp).getParent() != null) {
                    parentId = treeModel.searchByNodeId(temp).getParent().getId();
                    continue;
                }
                break;
            }
        } else if ("btn_confirm".equals(key)) {
            if (this.getPageCache().get(POSITION_JSON) != null) {
                view.returnDataToParent((Object)this.getPageCache().get(POSITION_JSON));
                view.close();
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u4f4d\u7f6e\u3002", (String)"ReportToVoucherPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if ("btn_cancel".equals(key)) {
            view.close();
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (!"root".equals(selectedNodeId)) {
            this.getPageCache().put("templateselectedNodeId", selectedNodeId);
            this.changeTemplate(Long.valueOf(selectedNodeId));
        }
    }

    private void changeTemplate(Long selectedNodeId) {
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedNodeId, (String)"bcm_templateentity");
        }
        catch (Exception e) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("viewDim", "haveOpenReport");
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dynamicObject);
        ReportPostmanByTemplateStyleView pm = new ReportPostmanByTemplateStyleView(template.getId(), pageCache.get("scenarioId"), pageCache.get("yearId"), pageCache.get("periodId"), pageCache.get("currencyId"), this.getModelId());
        this.increaseReportTab(pm);
    }

    @Override
    public void increaseReportTab(AbstractReportPostman postman) {
        Tab reporttab;
        Map<Object, DynamicObject> names = this.collectSortNameByIds0(postman);
        ArrayList newTabSelKey = new ArrayList(1);
        postman.getPairs().forEach(e -> {
            ReportTabInfo tabInfo = new ReportTabInfo(postman.getTabKey((Pair<Object, Object>)e), ((DynamicObject)names.get(postman.querySortPrimaryPK((Pair<Object, Object>)e))).getString("name"), e.p2, postman.getTemplatePK((Pair<Object, Object>)e), this.getLoadReportModelType());
            boolean hasAdd = this.getReportTabInfoManager().addReportTabInfo4List(tabInfo);
            if (hasAdd && newTabSelKey.isEmpty()) {
                newTabSelKey.add(tabInfo.getTabKey());
            }
        });
        this.cacheService.cacheReportTabInfoManager(this.getReportTabInfoManager());
        if (!newTabSelKey.isEmpty()) {
            this.recontructReportTab();
            reporttab = (Tab)this.getControl("reporttab");
            reporttab.activeTab((String)newTabSelKey.get(0));
        }
        reporttab = (Tab)this.getControl("reporttab");
        reporttab.activeTab(postman.getTabKey(postman.getPairs().get(0)));
        reporttab.selectTab(postman.getTabKey(postman.getPairs().get(0)));
        if (this.getReportTabInfoManager().getTabCount() == 1) {
            this.getReportTabInfoManager().getFirstReportTabInfo().setSelected(true);
            this.cacheService.cacheReportTabInfoManager(this.getReportTabInfoManager());
        }
    }

    private void recontructReportTab() {
        TabAp tabap = new TabAp();
        tabap.setKey("reporttab");
        tabap.setName(new LocaleString("reporttab"));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<ReportTabInfo> it = this.getReportTabInfoManager().iterator();
        while (it.hasNext()) {
            ReportTabInfo tab = it.next();
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"ReportToVoucherPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("reporttab", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>();
        closeMap.put("closable", true);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        this.closeTab0(e.getEventArgs());
    }

    private void closeTab0(String key) {
        ReportTabManager reportTabManager = this.getReportTabInfoManager();
        if (key != null && !key.isEmpty()) {
            reportTabManager.releaseByKey(key);
            this.cacheService.release(key);
            this.cacheService.cacheReportTabInfoManager(reportTabManager);
            String lastTabKey = reportTabManager.getLastTabKey(key);
            if (lastTabKey != null && !lastTabKey.equals(this.getPageCache().get("tabkey_selected"))) {
                this.getPageCache().put("tabkey_selected", lastTabKey);
                Tab tab2 = (Tab)this.getControl("reporttab");
                tab2.activeTab(lastTabKey);
            }
            this.getView().executeClientCommand(CMDNAMEKEY, new Object[]{key});
        } else {
            ArrayList tabkeys = new ArrayList();
            reportTabManager.getTabs().forEach(tab -> {
                tabkeys.add(tab.getTabKey());
                this.cacheService.release(tab.getTabKey());
            });
            reportTabManager.releaseAll();
            this.cacheService.cacheReportTabInfoManager(reportTabManager);
            this.getPageCache().put("tabkey_selected", "");
            for (String s : tabkeys) {
                this.getView().executeClientCommand(CMDNAMEKEY, new Object[]{s});
            }
            String spreadjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(this.getPageCache().get(SPREAD).substring(6))));
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", spreadjson);
        }
    }

    private Map<Object, DynamicObject> collectSortNameByIds0(AbstractReportPostman postman) {
        HashMap<Object, DynamicObject> nameMap = new HashMap<Object, DynamicObject>();
        HashSet ids = new HashSet();
        postman.getPairs().forEach(e -> ids.add(postman.querySortPrimaryPK((Pair<Object, Object>)e)));
        if (!ids.isEmpty()) {
            String tmplSelector = "id,name,number";
            String entitySelector = "id,name,number,isleaf";
            DynamicObjectCollection templates = QueryServiceHelper.query((String)postman.getFormEntityNumber(), (String)("bcm_entitymembertree".equals(postman.getFormEntityNumber()) ? entitySelector : tmplSelector), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            for (DynamicObject d : templates) {
                nameMap.put(d.get("id"), d);
            }
        }
        return nameMap;
    }

    @Override
    public long getModelId() {
        if (this.getPageCache().get(MODEL_ID) == null) {
            if (this.getModel().getValue(MODEL) != null) {
                return ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
            }
            return 0L;
        }
        return Long.parseLong(this.getPageCache().get(MODEL_ID));
    }

    @Override
    public void reportTabSelected(TabSelectEvent tabSelectEvent) {
    }

    @Override
    protected boolean isReportStyleShow() {
        return false;
    }

    @Override
    protected void afterLoadReport() {
    }

    @Override
    protected IDimMember initEntityMember(IDimension dim) {
        return null;
    }
}

