/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RpaDataImportPlugin
extends SpreadBasePlugin
implements UploadListener {
    private static final String CTL_IMPORTINFO = "importinfo";
    private static final String CTL_IMPORTINFO_EXT = "importinfo_ext";
    protected static final String NUMBER = "number";
    protected static final String MODEL = "model";
    protected static final String SCHEME_NAME_COMBOITEM = "schemename";

    @Override
    public void initialize() {
        this.addClickListeners("btn_supload", "btn_lastscheme", "btn_import", "btn_resetfile");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachment");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.refreshEntryEntity();
        this.loadSchemeComboItem((Long)this.getFormCustomParam("modelId"));
    }

    private void loadSchemeComboItem(Long modelId) {
        DynamicObject excelSource = QueryServiceHelper.queryOne((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"EXCEL")});
        Long entityId = (Long)this.getFormCustomParam("entityId");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)"bcm_entitymembertree", (String)NUMBER);
        if (excelSource == null) {
            return;
        }
        long id = excelSource.getLong("id");
        DynamicObjectCollection schemeList = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id,number,name,versionnumber", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId), new QFilter("issrc", "=", (Object)id), new QFilter("status", "=", (Object)"1"), new QFilter("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId))});
        List schemeIds = schemeList.stream().map(scheme -> scheme.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection entityAssign = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)"entity.id,entity.number,range,scheme,property,propertyvalue.id,propertyvalue.number,applytype", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId), new QFilter("scheme", "in", schemeIds)}, (String)"scheme,applytype desc");
        Map<Long, DynamicObject> schemeMap = schemeList.stream().collect(Collectors.toMap(scheme -> scheme.getLong("id"), scheme -> scheme));
        HashMap<Long, DynamicObject> schemeResultMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynObj : entityAssign) {
            String mnumber;
            Long mId;
            HashSet entityNums = new HashSet(10);
            boolean bl = false;
            if (dynObj.get("entity.number") == null) {
                bl = true;
                mId = dynObj.getLong("propertyvalue.id");
                mnumber = dynObj.getString("propertyvalue.number");
            } else {
                mId = dynObj.getLong("entity.id");
                mnumber = dynObj.getString("entity.number");
            }
            new MembRangeItem("bcm_entitymembertree", mId, mnumber, Integer.parseInt(dynObj.getString("range")), bl, (Object)modelId).matchItems(item -> entityNums.add(item.number));
            String applytype = dynObj.getString("applytype");
            if (!entityNums.contains(org.getString(NUMBER))) continue;
            Long schemeId = dynObj.getLong("scheme");
            if ("0".equals(applytype)) {
                schemeResultMap.remove(schemeId);
                continue;
            }
            schemeResultMap.put(schemeId, schemeMap.get(schemeId));
        }
        HashSet schemeIdSet = new HashSet(schemeResultMap.size());
        schemeIdSet.addAll(schemeResultMap.keySet());
        IntegrationUtil.filterSchemeByDate((long)modelId, (String)((String)this.getFormCustomParam("periodNum")), (String)((String)this.getFormCustomParam("yearNum")), schemeIdSet);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(schemeResultMap.size());
        for (Map.Entry entry : schemeResultMap.entrySet()) {
            if (!schemeIdSet.contains(entry.getKey())) continue;
            ComboItem comboItem = new ComboItem();
            DynamicObject dynObj = (DynamicObject)entry.getValue();
            comboItem.setCaption(new LocaleString(dynObj.get(NUMBER) + "-" + dynObj.get("name") + "-V" + dynObj.get("versionnumber")));
            comboItem.setValue(dynObj.get("id").toString());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(SCHEME_NAME_COMBOITEM);
        comboEdit.setComboItems(comboItems);
        if (schemeResultMap.size() == 1) {
            Iterator iterator = schemeResultMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.getModel().setValue(SCHEME_NAME_COMBOITEM, iterator.next());
            }
        }
    }

    private void refreshEntryEntity() {
        IDataModel model = this.getModel();
        String url = this.getPageCache().get("urls");
        if (StringUtils.isEmpty((CharSequence)url)) {
            model.deleteEntryData(CTL_IMPORTINFO);
            model.deleteEntryData(CTL_IMPORTINFO_EXT);
            return;
        }
        String scheme = (String)this.getModel().getValue(SCHEME_NAME_COMBOITEM);
        if (StringUtils.isEmpty((CharSequence)scheme)) {
            model.deleteEntryData(CTL_IMPORTINFO);
            model.deleteEntryData(CTL_IMPORTINFO_EXT);
            return;
        }
        model.deleteEntryData(CTL_IMPORTINFO);
        model.deleteEntryData(CTL_IMPORTINFO_EXT);
        Long schemeId = LongUtil.toLong((Object)scheme);
        DynamicObject[] templates = this.getTemplateIdsBySheet(url, schemeId);
        if (templates == null || templates.length == 0) {
            return;
        }
        String rptData = null;
        SpreadManager spread = null;
        int index = 0;
        int extIndex = 0;
        Map<String, List<String>> areaMap = null;
        for (DynamicObject template : templates) {
            List<String> areaExtRangeList;
            rptData = template.getString("rptdata");
            spread = JsonSerializerUtil.toSpreadManager((String)rptData);
            areaMap = CellMappingHandle.getFloatArea(spread, true);
            List<String> areaRangeList = areaMap.get("float");
            if (areaRangeList != null && !areaRangeList.isEmpty()) {
                for (int i = 0; i < areaRangeList.size(); ++i) {
                    ++index;
                }
            }
            if ((areaExtRangeList = areaMap.get("extFloat")) == null || areaExtRangeList.isEmpty()) continue;
            for (int i = 0; i < areaExtRangeList.size(); ++i) {
                ++extIndex;
            }
        }
        if (index > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabpageap"});
            this.getModel().batchCreateNewEntryRow(CTL_IMPORTINFO, index);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap"});
        }
        if (extIndex > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabpageap1"});
            this.getModel().batchCreateNewEntryRow(CTL_IMPORTINFO_EXT, extIndex);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap1"});
        }
        int count = 0;
        int extCount = 0;
        for (DynamicObject template : templates) {
            List<String> areaExtRangeList;
            rptData = template.getString("rptdata");
            spread = JsonSerializerUtil.toSpreadManager((String)rptData);
            areaMap = CellMappingHandle.getFloatArea(spread, true);
            List<String> areaRangeList = areaMap.get("float");
            if (areaRangeList != null && !areaRangeList.isEmpty()) {
                for (int i = 0; i < areaRangeList.size(); ++i) {
                    model.setValue("templatename", template.get("name"), count);
                    model.setValue("templatenum", template.get(NUMBER), count);
                    model.setValue("templateid", (Object)template.getLong("id"), count);
                    model.setValue("floatarea", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6d6e\u52a8\u533a\u57df", (String)"RpaDataImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1), count);
                    model.setValue("floatareanum", (Object)(i + 1), count);
                    ++count;
                }
            }
            if ((areaExtRangeList = areaMap.get("extFloat")) == null || areaExtRangeList.isEmpty()) continue;
            for (int i = 0; i < areaExtRangeList.size(); ++i) {
                model.setValue("templatename_ext", template.get("name"), extCount);
                model.setValue("templatenum_ext", template.get(NUMBER), extCount);
                model.setValue("templateid_ext", (Object)template.getLong("id"), extCount);
                model.setValue("floatarea_ext", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u62d3\u5c55\u533a\u57df", (String)"RpaDataImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1), extCount);
                model.setValue("floatareanum_ext", (Object)(i + 1), extCount);
                ++extCount;
            }
        }
        this.getPageCache().put("lastScheme", Boolean.FALSE.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DynamicObject[] getTemplateIdsBySheet(String url, Long schemeId) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(url);){
            int i;
            HSSFWorkbook wb;
            ArrayList<String> sheetNames = new ArrayList<String>();
            if (url.endsWith("xls")) {
                wb = new HSSFWorkbook(inputStream);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    sheetNames.add(wb.getSheetAt(i).getSheetName());
                }
            } else if (url.endsWith("xlsx")) {
                wb = new XSSFWorkbook(inputStream);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    sheetNames.add(wb.getSheetAt(i).getSheetName());
                }
            }
            QFBuilder qfSheet = new QFBuilder("scheme", "=", (Object)schemeId);
            qfSheet.add("sheetname", "in", sheetNames);
            qfSheet.add("mappingstatus", "=", (Object)"1");
            qfSheet.add("effectstatus", "=", (Object)"1");
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"sheetname,template.id,template.name,template.number,template.rptdata", (QFilter[])qfSheet.toArray());
            Set templateIds = dyns.stream().map(temp -> temp.getLong("template.id")).collect(Collectors.toSet());
            Long modelId = (Long)this.getFormCustomParam("modelId");
            Long yearId = (Long)this.getFormCustomParam("yearId");
            Long periodId = (Long)this.getFormCustomParam("periodId");
            Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, templateIds);
            qfSheet.add("template", "in", id2Right.values());
            dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"sheetname,template.id,template.name,template.number,template.rptdata", (QFilter[])qfSheet.toArray());
            DynamicObject[] tempaltes = new DynamicObject[dyns.size()];
            int index = 0;
            for (DynamicObject dyn : dyns) {
                DynamicObject template = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
                template.set("id", dyn.get("template.id"));
                template.set(NUMBER, dyn.get("template.number"));
                template.set("name", dyn.get("template.name"));
                template.set("rptdata", dyn.get("template.rptdata"));
                tempaltes[index] = template;
                ++index;
            }
            DynamicObject[] dynamicObjectArray = tempaltes;
            return dynamicObjectArray;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (e instanceof RecordFormatException) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6587\u4ef6\u8d85\u8fc7org.apache.poi\u7684100,000,000\u4e2a\u6570\u7ec4\u9650\u5236,\u8bf7\u66f4\u6362\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!(e instanceof OfficeXmlFileException)) throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u66f4\u6362\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u975e\u539f\u59cb.xlsx\u6216\u8005.xls\uff0c\u8bf7\u66f4\u6362\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSheetMappingListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.removeUploadFile();
        ArrayList urls = new ArrayList(10);
        Collections.addAll(urls, evt.getUrls());
        LinkedHashMap url1map = (LinkedHashMap)evt.getUrls()[0];
        String url = url1map.get("url").toString();
        String filename = url1map.get("name").toString();
        Long pkId = System.currentTimeMillis();
        String fbilltype = "bcm_isscheme_excell";
        String urlstr = AttachmentServiceHelper.saveTempToFileService((String)url, (String)"bcm", (String)fbilltype, (Object)pkId, (String)filename);
        this.saveAttachment(url1map, pkId.toString(), urlstr);
        if (!urlstr.endsWith(".xls") && !urlstr.endsWith(".xlsx")) {
            urlstr = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(urlstr);
        }
        this.getPageCache().put("urls", urlstr);
        this.getPageCache().put("filename", filename);
        this.refreshEntryEntity();
    }

    private void saveAttachment(LinkedHashMap<String, Object> url1map, String pkId, String urlstr) {
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        String fbilltype = "bcm_isscheme_excell";
        dynObj.set("fBillType", (Object)fbilltype);
        dynObj.set("fnumber", url1map.get("uid"));
        dynObj.set("fInterID", (Object)pkId);
        dynObj.set("fFileId", (Object)urlstr);
        dynObj.set("fAttachmentName", url1map.get("name"));
        dynObj.set("fExtName", url1map.get("type"));
        dynObj.set("fAttachmentSize", url1map.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", (Object)this.getUserId());
        dynObj.set("fCreateTime", url1map.get("createdate"));
        dynObj.set("fModifyMen_Id", (Object)this.getUserId());
        dynObj.set("fModifyTime", url1map.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().put("urls", null);
        this.refreshEntryEntity();
    }

    @Override
    public void click(EventObject evt) {
        String eventKey = ((Control)evt.getSource()).getKey();
        if ("btn_import".equalsIgnoreCase(eventKey)) {
            this.importData();
        } else if ("btn_lastscheme".equalsIgnoreCase(eventKey)) {
            this.getLastScheme();
        }
    }

    private void getLastScheme() {
        DynamicObject[] templates;
        Long modelId = (Long)this.getFormCustomParam("modelId");
        String url = this.getPageCache().get("urls");
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"RpaDataImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter("modelid", "=", (Object)modelId);
        QFilter extqf = new QFilter("modelid", "=", (Object)modelId);
        qf.and("creatorid", "=", (Object)userId);
        extqf.and("creatorid", "=", (Object)userId);
        Long fschemeid = LongUtil.toLong((Object)this.getModel().getValue(SCHEME_NAME_COMBOITEM));
        if (fschemeid == 0L) {
            DynamicObjectCollection schemeids = QueryServiceHelper.query((String)"bcm_isexcelimport_config", (String)"id,schemeid,dataunit", (QFilter[])qf.toArray(), (String)"createdate desc");
            if (schemeids == null || schemeids.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u9009\u62e9\u65b9\u6848\u3002", (String)"RpaDataImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            fschemeid = ((DynamicObject)schemeids.get(0)).getLong("schemeid");
            qf.and("schemeid", "=", (Object)fschemeid);
            extqf.and("schemeid", "=", (Object)fschemeid);
        } else {
            qf.and("schemeid", "=", (Object)fschemeid);
            extqf.and("schemeid", "=", (Object)fschemeid);
        }
        qf.and("extendarea", "=", (Object)0);
        DynamicObject[] isexcelimports = BusinessDataServiceHelper.load((String)"bcm_isexcelimport_config", (String)"modelid,templateid,floatarea,startline,endline,seqnum,schemeid,dataunit,extendarea", (QFilter[])qf.toArray(), (String)"seqnum");
        extqf.and("floatarea", "=", (Object)0);
        DynamicObject[] isexcelimportsext = BusinessDataServiceHelper.load((String)"bcm_isexcelimport_config", (String)"modelid,templateid,floatarea,startline,endline,seqnum,schemeid,dataunit,extendarea", (QFilter[])extqf.toArray(), (String)"seqnum");
        if (isexcelimports.length == 0 && isexcelimportsext.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u9009\u62e9\u65b9\u6848\u3002", (String)"RpaDataImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String dataunit = null;
        if (isexcelimports.length > 0) {
            dataunit = isexcelimports[0].getString("dataunit");
        } else if (isexcelimportsext.length > 0) {
            dataunit = isexcelimportsext[0].getString("dataunit");
        }
        this.getModel().setValue("dataunit", (Object)dataunit);
        DynamicObjectCollection entityAssign = QueryServiceHelper.query((String)"bcm_schemeassignentity", (String)"entity.id,entity.number,range,scheme,property,propertyvalue.id,propertyvalue.number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId), new QFilter("scheme", "=", (Object)fschemeid)});
        HashSet entityIds = new HashSet(10);
        for (DynamicObject dynObj : entityAssign) {
            String mnumber;
            Long mId;
            boolean isCustom = false;
            if (dynObj.get("entity.number") == null) {
                isCustom = true;
                mId = dynObj.getLong("propertyvalue.id");
                mnumber = dynObj.getString("propertyvalue.number");
            } else {
                mId = dynObj.getLong("entity.id");
                mnumber = dynObj.getString("entity.number");
            }
            new MembRangeItem("bcm_entitymembertree", mId, mnumber, Integer.parseInt(dynObj.getString("range")), isCustom, (Object)modelId).matchItems(item -> entityIds.add(LongUtil.toLong((Object)item.id)));
        }
        if (!entityIds.contains(this.getFormCustomParam("entityId"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u9009\u62e9\u65b9\u6848\u3002", (String)"RpaDataImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, DynamicObject> lastSchemeMap = Arrays.stream(isexcelimports).collect(Collectors.toMap(isexcell -> isexcell.getLong("id"), isexcell -> isexcell));
        Map<Long, DynamicObject> extlastSchemeMap = Arrays.stream(isexcelimportsext).collect(Collectors.toMap(isexcell -> isexcell.getLong("id"), isexcell -> isexcell));
        ArrayList<DynamicObject> resultlist = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> extresultlist = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyo : templates = this.getTemplateIdsBySheet(url, fschemeid)) {
            DynamicObject excellImportDyo;
            Long templateId = dyo.getLong("id");
            for (Map.Entry<Long, DynamicObject> entry : lastSchemeMap.entrySet()) {
                excellImportDyo = entry.getValue();
                if (excellImportDyo.get("templateid.id") == null || !excellImportDyo.get("templateid.id").equals(templateId)) continue;
                resultlist.add(entry.getValue());
            }
            for (Map.Entry<Long, DynamicObject> entry : extlastSchemeMap.entrySet()) {
                excellImportDyo = entry.getValue();
                if (excellImportDyo.get("templateid.id") == null || !excellImportDyo.get("templateid.id").equals(templateId)) continue;
                extresultlist.add(entry.getValue());
            }
        }
        DynamicObjectCollection importinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO);
        DynamicObjectCollection extimportinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO_EXT);
        if (importinfos != null || extimportinfos != null) {
            if (importinfos != null) {
                for (DynamicObject importInfo : importinfos) {
                    if (!resultlist.isEmpty()) {
                        for (DynamicObject dyn : resultlist) {
                            if (importInfo.getLong("templateid") != dyn.getLong("templateid.id") || importInfo.getInt("floatareanum") != dyn.getInt("floatarea")) continue;
                            int index = importInfo.getInt("seq") - 1;
                            if (dyn.getInt("floatarea") != 0) {
                                this.getModel().setValue("floatarea", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6d6e\u52a8\u533a\u57df", (String)"RpaDataImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getInt("floatarea")), index);
                                this.getModel().setValue("startline", dyn.get("startline"), index);
                                this.getModel().setValue("endline", dyn.get("endline"), index);
                                this.getModel().setValue("floatareanum", (Object)dyn.getInt("floatarea"), index);
                            }
                            this.getModel().setValue("templatenum", dyn.get("templateid.number"), index);
                            this.getModel().setValue("templateid", dyn.get("templateid.id"), index);
                            this.getModel().setValue("templatename", dyn.get("templateid.name"), index);
                        }
                        continue;
                    }
                    if (!extresultlist.isEmpty()) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u9009\u62e9\u65b9\u6848\u3002", (String)"RpaDataImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (extimportinfos != null) {
                for (DynamicObject extimportInfo : extimportinfos) {
                    if (extresultlist.isEmpty()) continue;
                    for (DynamicObject dyn : extresultlist) {
                        if (extimportInfo.getLong("templateid_ext") != dyn.getLong("templateid.id") || extimportInfo.getInt("floatareanum_ext") != dyn.getInt("extendarea")) continue;
                        int index = extimportInfo.getInt("seq") - 1;
                        if (dyn.getInt("extendarea") != 0) {
                            this.getModel().setValue("floatarea_ext", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u62d3\u5c55\u533a\u57df", (String)"RpaDataImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.getInt("extendarea")), index);
                            this.getModel().setValue("startline_ext", dyn.get("startline"), index);
                            this.getModel().setValue("endline_ext", dyn.get("endline"), index);
                            this.getModel().setValue("floatareanum_ext", (Object)dyn.getInt("extendarea"), index);
                        }
                        this.getModel().setValue("templatenum_ext", dyn.get("templateid.number"), index);
                        this.getModel().setValue("templateid_ext", dyn.get("templateid.id"), index);
                        this.getModel().setValue("templatename_ext", dyn.get("templateid.name"), index);
                    }
                }
            }
            this.getPageCache().put("lastScheme", Boolean.TRUE.toString());
            this.getModel().setValue(SCHEME_NAME_COMBOITEM, (Object)fschemeid.toString());
        }
    }

    private void importData() {
        String url = this.getPageCache().get("urls");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"RpaDataImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String scheme = (String)this.getModel().getValue(SCHEME_NAME_COMBOITEM);
        if (StringUtils.isBlank((CharSequence)scheme)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u65b9\u6848\u3002", (String)"RpaDataImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String dataunit = (String)this.getModel().getValue("dataunit");
        if (StringUtils.isBlank((CharSequence)dataunit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u91d1\u989d\u5355\u4f4d\u3002", (String)"RpaDataImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> param1 = this.buildImportParam(url);
        if (param1 == null) {
            return;
        }
        this.savesexcelimport();
        ArrayList<Map<String, Object>> ctxs = new ArrayList<Map<String, Object>>(1);
        ctxs.add(param1);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("ctx", ctxs);
        this.dispatchImport(param);
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u5bfc\u5165", (String)"RpaDataImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c\u5bfc\u5165", (String)"RpaDataImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId(), (String)"bcm_rpadataimport");
    }

    private void removeUploadFile() {
        String fbilltype = "bcm_isscheme_excell";
        DynamicObjectCollection dynObj = QueryServiceHelper.query((String)"bos_attachment", (String)"fnumber,fInterID", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)fbilltype), new QFilter("fCreateMen_Id", "=", (Object)this.getUserId())});
        if (dynObj != null && !dynObj.isEmpty()) {
            for (DynamicObject obj : dynObj) {
                AttachmentServiceHelper.remove((String)fbilltype, (Object)obj.getString("fInterID"), (Object)obj.getString("fnumber"));
            }
        }
        QFilter attachFilter = new QFilter("fCreateMen_Id", "=", (Object)this.getUserId()).and("fBillType", "=", (Object)fbilltype);
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{attachFilter});
    }

    private Map<String, Object> buildImportParam(String url) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        Long modelId = (Long)this.getFormCustomParam("modelId");
        String modelNum = (String)this.getFormCustomParam("modelNum");
        Long scenarioId = (Long)this.getFormCustomParam("scenarioId");
        String scenarioNum = (String)this.getFormCustomParam("scenarioNum");
        Long yearId = (Long)this.getFormCustomParam("yearId");
        String yearNum = (String)this.getFormCustomParam("yearNum");
        Long periodId = (Long)this.getFormCustomParam("periodId");
        String periodNum = (String)this.getFormCustomParam("periodNum");
        Long currencyId = (Long)this.getFormCustomParam("currencyId");
        String currencyNum = (String)this.getFormCustomParam("currencyNum");
        Long entityId = (Long)this.getFormCustomParam("entityId");
        String entityNum = (String)this.getFormCustomParam("entityNum");
        Map all4Import = (Map)JSON.parseObject((String)((String)this.getFormCustomParam("all4Import")), HashMap.class);
        Long fschemeid = LongUtil.toLong((Object)this.getModel().getValue(SCHEME_NAME_COMBOITEM));
        String dataunit = (String)this.getModel().getValue("dataunit");
        Pair model = Pair.onePair((Object)modelId, (Object)modelNum);
        Pair org = Pair.onePair((Object)entityId, (Object)entityNum);
        Pair scene = Pair.onePair((Object)scenarioId, (Object)scenarioNum);
        Pair year = Pair.onePair((Object)yearId, (Object)yearNum);
        Pair period = Pair.onePair((Object)periodId, (Object)periodNum);
        Pair currency = Pair.onePair((Object)currencyId, (Object)currencyNum);
        Map<String, Map<Integer, Pair<Integer, Integer>>> floatConfig = this.getFloatConfig();
        Map<String, Map<Integer, Pair<Integer, Integer>>> extendConfig = this.getExtFloatConfig();
        if (floatConfig == null || extendConfig == null) {
            return null;
        }
        param.put(MODEL, model);
        param.put("org", org);
        param.put("scene", scene);
        param.put("year", year);
        param.put("period", period);
        param.put("currency", currency);
        param.put("floatConfig", floatConfig);
        param.put("extendConfig", extendConfig);
        param.put("all4Import", all4Import);
        param.put("scheme", fschemeid);
        param.put("dataunit", dataunit);
        param.put("url", url);
        param.put("userId", LongUtil.toLong((Object)this.getUserId()));
        return param;
    }

    private void dispatchImport(Map<String, Object> param) {
        JobInfo job = new JobInfo();
        job.setAppId(ApplicationTypeEnum.CM.appnum);
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"RpaDataImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        job.setNumber("JobRPARptImport");
        job.setId(UUID.randomUUID().toString());
        job.setTaskClassname("kd.fi.bcm.formplugin.report.excelrptimport.RpaExcelRptImportTask");
        job.setParams(param);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobForm.dispatch((JobInfo)job, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "taskcloseback": {
                this.taskCallBack(evt.getReturnData());
                break;
            }
        }
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            if (jsonObject.containsKey((Object)"errorMsg")) {
                String errorMsg = (String)jsonObject.get((Object)"errorMsg");
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            if (jsonObject.containsKey((Object)"failRpts")) {
                List failRpts = (List)jsonObject.get((Object)"failRpts");
                if (failRpts.stream().noneMatch(r -> r.size() > 0)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"RpaDataImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5b58\u5728\u5bfc\u5165\u5931\u8d25\u60c5\u51b5\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u96c6\u6210\u65e5\u5fd7\u8def\u5f84\u4e3a\uff1a\u62a5\u8868\u7f16\u62a5>\u96c6\u6210\u53d6\u6570>\u91c7\u96c6\u65e5\u5fd7\u3002", (String)"RpaDataImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void savesexcelimport() {
        DynamicObjectCollection extimportinfos;
        DynamicObjectCollection importinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO);
        Long modelid = (Long)this.getFormCustomParam("modelId");
        Long fschemeid = LongUtil.toLong((Object)this.getModel().getValue(SCHEME_NAME_COMBOITEM));
        String dataunit = String.valueOf(this.getModel().getValue("dataunit"));
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        QFilter qf = new QFilter("modelid", "=", (Object)modelid);
        qf.and("schemeid", "=", (Object)fschemeid);
        qf.and("creatorid", "=", (Object)userId);
        DeleteServiceHelper.delete((String)"bcm_isexcelimport_config", (QFilter[])qf.toArray());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (importinfos != null) {
            for (DynamicObject importInfo : importinfos) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isexcelimport_config");
                dynamicObject.set("modelid", (Object)modelid);
                dynamicObject.set("templateid", (Object)importInfo.getLong("templateid"));
                dynamicObject.set("schemeid", (Object)fschemeid);
                dynamicObject.set("dataunit", (Object)dataunit);
                dynamicObject.set("floatarea", importInfo.get("floatareanum"));
                dynamicObject.set("startline", importInfo.get("startline"));
                dynamicObject.set("endline", importInfo.get("endline"));
                dynamicObject.set("seqnum", importInfo.get("seq"));
                dynamicObject.set("creatorid", (Object)userId);
                dynamicObject.set("modifierid", (Object)userId);
                dynamicObject.set("modifiydate", (Object)this.getCurrentSysTime());
                dynamicObject.set("createdate", (Object)this.getCurrentSysTime());
                list.add(dynamicObject);
            }
        }
        if ((extimportinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO_EXT)) != null) {
            for (DynamicObject extimportInfo : extimportinfos) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isexcelimport_config");
                dynamicObject.set("modelid", (Object)modelid);
                dynamicObject.set("templateid", (Object)extimportInfo.getLong("templateid_ext"));
                dynamicObject.set("schemeid", (Object)fschemeid);
                dynamicObject.set("dataunit", (Object)dataunit);
                dynamicObject.set("extendarea", extimportInfo.get("floatareanum_ext"));
                dynamicObject.set("startline", extimportInfo.get("startline_ext"));
                dynamicObject.set("endline", extimportInfo.get("endline_ext"));
                dynamicObject.set("seqnum", extimportInfo.get("seq"));
                dynamicObject.set("creatorid", (Object)userId);
                dynamicObject.set("modifierid", (Object)userId);
                dynamicObject.set("modifiydate", (Object)this.getCurrentSysTime());
                dynamicObject.set("createdate", (Object)this.getCurrentSysTime());
                list.add(dynamicObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
    }

    private Map<String, Map<Integer, Pair<Integer, Integer>>> getFloatConfig() {
        HashMap<String, Map<Integer, Pair<Integer, Integer>>> map = new HashMap<String, Map<Integer, Pair<Integer, Integer>>>(10);
        DynamicObjectCollection importinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO);
        HashMap<Long, Boolean> floatTemplate = new HashMap<Long, Boolean>(16);
        if (importinfos != null) {
            int endline;
            int startline;
            Long templateId;
            for (DynamicObject importInfo : importinfos) {
                if (importInfo.getInt("floatareanum") == 0) continue;
                int floatareanum = importInfo.getInt("floatareanum");
                templateId = importInfo.getLong("templateid");
                startline = importInfo.getInt("startline");
                endline = importInfo.getInt("endline");
                if (floatareanum != 1) continue;
                if (startline == 0 && endline == 0) {
                    floatTemplate.put(templateId, false);
                    continue;
                }
                if (startline != 0 && endline != 0) {
                    if (startline > endline) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5f00\u59cb\u884c\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u884c\u3002", (String)"RpaDataImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), importInfo.getString("templatename")));
                        return null;
                    }
                    floatTemplate.put(templateId, true);
                    continue;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u6d6e\u52a8\u533a\u57df\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"RpaDataImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), importInfo.getString("templatename")));
                return null;
            }
            for (DynamicObject importInfo : importinfos) {
                if (importInfo.getInt("floatareanum") == 0) continue;
                String templateNum = importInfo.getString("templatenum");
                templateId = importInfo.getLong("templateid");
                startline = importInfo.getInt("startline");
                endline = importInfo.getInt("endline");
                int floatareanum = importInfo.getInt("floatareanum");
                if (!floatTemplate.containsKey(templateId)) continue;
                if (((Boolean)floatTemplate.get(templateId)).booleanValue()) {
                    if (startline == 0 || endline == 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u6d6e\u52a8\u533a\u57df\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"RpaDataImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), importInfo.getString("templatename")));
                        return null;
                    }
                    if (startline > endline) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5f00\u59cb\u884c\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u884c\u3002", (String)"RpaDataImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), importInfo.getString("templatename")));
                        return null;
                    }
                    Pair floatLine = Pair.onePair((Object)(startline - 1), (Object)(endline - 1));
                    if (map.containsKey(templateNum)) {
                        ((Map)map.get(templateNum)).put(floatareanum, floatLine);
                        continue;
                    }
                    HashMap<Integer, Pair> importinfoMap = new HashMap<Integer, Pair>(10);
                    importinfoMap.put(floatareanum, floatLine);
                    map.put(templateNum, importinfoMap);
                    continue;
                }
                if (startline == 0 && endline == 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u6d6e\u52a8\u533a\u57df\u8bf7\u586b\u5199\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u518d\u5bfc\u5165\u3002", (String)"RpaDataImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), importInfo.getString("templatename")));
                return null;
            }
        }
        return map;
    }

    private Map<String, Map<Integer, Pair<Integer, Integer>>> getExtFloatConfig() {
        HashMap<String, Map<Integer, Pair<Integer, Integer>>> map = new HashMap<String, Map<Integer, Pair<Integer, Integer>>>(10);
        DynamicObjectCollection extimportinfos = this.getModel().getEntryEntity(CTL_IMPORTINFO_EXT);
        HashMap<Long, Boolean> extFloatTemplate = new HashMap<Long, Boolean>(16);
        if (extimportinfos != null) {
            int endline;
            int startline;
            Long templateId;
            for (DynamicObject extImportInfo : extimportinfos) {
                if (extImportInfo.getInt("floatareanum_ext") == 0) continue;
                int extfloatareanum = extImportInfo.getInt("floatareanum_ext");
                templateId = extImportInfo.getLong("templateid_ext");
                startline = extImportInfo.getInt("startline_ext");
                endline = extImportInfo.getInt("endline_ext");
                if (extfloatareanum != 1) continue;
                if (startline == 0 && endline == 0) {
                    extFloatTemplate.put(templateId, false);
                    continue;
                }
                if (startline != 0 && endline != 0) {
                    if (startline > endline) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5f00\u59cb\u884c\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u884c\u3002", (String)"RpaDataImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extImportInfo.getString("templatename_ext")));
                        return null;
                    }
                    extFloatTemplate.put(templateId, true);
                    continue;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u62d3\u5c55\u533a\u57df\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"RpaDataImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extImportInfo.getString("templatename_ext")));
                return null;
            }
            for (DynamicObject extImportInfo : extimportinfos) {
                if (extImportInfo.getInt("floatareanum_ext") == 0) continue;
                String templateNum = extImportInfo.getString("templatenum_ext");
                templateId = extImportInfo.getLong("templateid_ext");
                startline = extImportInfo.getInt("startline_ext");
                endline = extImportInfo.getInt("endline_ext");
                int floatareanum = extImportInfo.getInt("floatareanum_ext");
                if (!extFloatTemplate.containsKey(templateId)) continue;
                if (((Boolean)extFloatTemplate.get(templateId)).booleanValue()) {
                    if (startline == 0 || endline == 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u62d3\u5c55\u533a\u57df\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"RpaDataImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extImportInfo.getString("templatename_ext")));
                        return null;
                    }
                    if (startline > endline) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5f00\u59cb\u884c\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u884c\u3002", (String)"RpaDataImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extImportInfo.getString("templatename_ext")));
                        return null;
                    }
                    Pair floatLine = Pair.onePair((Object)(startline - 1), (Object)(endline - 1));
                    if (map.containsKey(templateNum)) {
                        ((Map)map.get(templateNum)).put(floatareanum, floatLine);
                        continue;
                    }
                    HashMap<Integer, Pair> importinfoMap = new HashMap<Integer, Pair>(10);
                    importinfoMap.put(floatareanum, floatLine);
                    map.put(templateNum, importinfoMap);
                    continue;
                }
                if (startline == 0 && endline == 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u62d3\u5c55\u533a\u57df\u8bf7\u586b\u5199\u5f00\u59cb\u884c\u7ed3\u675f\u884c\u518d\u5bfc\u5165\u3002", (String)"RpaDataImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extImportInfo.getString("templatename")));
                return null;
            }
        }
        return map;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEME_NAME_COMBOITEM.equals(key)) {
            String lastScheme = this.getPageCache().get("lastScheme");
            if (StringUtils.isNotEmpty((CharSequence)lastScheme) && Boolean.parseBoolean(lastScheme)) {
                this.getPageCache().remove("lastScheme");
                return;
            }
            this.refreshEntryEntity();
        }
    }
}

