/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.LongUtil;

public class RptEntryDeletePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PERIOD = "period";
    private static final String IS_RESET_REPORT_PROCESS = "isresetreportprocess";
    public static final String YEAR = "year";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        MulBasedataEdit yearF7 = (MulBasedataEdit)this.getControl(YEAR);
        MulBasedataEdit controlF7 = (MulBasedataEdit)this.getControl(PERIOD);
        yearF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        controlF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String userId = RequestContext.get().getUserId();
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(userId), (String)modelId);
        if (!isAdmin) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_RESET_REPORT_PROCESS});
        }
        boolean isDataLockOpen = OlapServiceHelper.checkMeasure((String)MemberReader.findModelNumberById((Object)modelId), (String)FacTabFieldDefEnum.FIELD_LOCK.getField());
        this.getView().setVisible(Boolean.valueOf(!isDataLockOpen), new String[]{IS_RESET_REPORT_PROCESS});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ok".equals(key)) {
            boolean isResetReportProcess;
            DynamicObjectCollection yearColl = (DynamicObjectCollection)this.getModel().getValue(YEAR);
            DynamicObjectCollection periodColl = (DynamicObjectCollection)this.getModel().getValue(PERIOD);
            if (yearColl.isEmpty() || periodColl.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u671f\u95f4\u3002", (String)"RptEntryDeletePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean bl = isResetReportProcess = this.getModel().getValue(IS_RESET_REPORT_PROCESS) == null ? false : (Boolean)this.getModel().getValue(IS_RESET_REPORT_PROCESS);
            if (isResetReportProcess) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u91cd\u7f6e\u6240\u9009\u62a5\u8868\u6a21\u677f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u7684\u7f16\u5236\u72b6\u6001\uff0c\u4e14\u53d6\u6d88\u7f16\u5236\u5b8c\u6210\u5e76\u6253\u56de\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\uff1f", (String)"RptEntryDeletePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5c06\u6240\u9009\u6a21\u677f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u7684\u88ab\u6253\u56de\u6216\u7f16\u5236\u4e2d\u62a5\u8868\u8bb0\u5f55\u72b6\u6001\u91cd\u7f6e\u4e3a\u672a\u7f16\u5236\uff1f", (String)"RptEntryDeletePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("del".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            DynamicObjectCollection yearColl = (DynamicObjectCollection)this.getModel().getValue(YEAR);
            DynamicObjectCollection periodColl = (DynamicObjectCollection)this.getModel().getValue(PERIOD);
            boolean isResetReportProcess = this.getModel().getValue(IS_RESET_REPORT_PROCESS) == null ? false : (Boolean)this.getModel().getValue(IS_RESET_REPORT_PROCESS);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(YEAR, this.getPKArray(yearColl));
            map.put(PERIOD, this.getPKArray(periodColl));
            map.put(IS_RESET_REPORT_PROCESS, isResetReportProcess);
            this.getView().setReturnData(map);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private List<Object> getPKArray(DynamicObjectCollection coll) {
        ArrayList<Object> list = new ArrayList<Object>();
        coll.forEach(n -> list.add(n.getDynamicObject("fbasedataid").get("id")));
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        QFilter qFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List<String> specificPeOrFY = Arrays.asList("LastPeriod", "CurrentPeriod", "LastYear", "CurrentYear", "AllYear");
        QFilter adjustFilter = null;
        if (PERIOD.equals(evt.getProperty().getName()) && this.getModel().getValue(YEAR) != null) {
            DynamicObjectCollection fyDCollection = (DynamicObjectCollection)this.getModel().getValue(YEAR);
            adjustFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
            adjustFilter.and("isadjust", "=", (Object)"1");
            for (DynamicObject fy : fyDCollection) {
                adjustFilter.and("useyear", "like", (Object)("%" + fy.getString("fbasedataid.number") + "%"));
            }
            qFilter.and(QFilter.of((String)"isadjust !='1' or isadjust is null", (Object[])new Object[0]));
        }
        qFilter.and("parent", "!=", (Object)0);
        qFilter.and("number", "not in", specificPeOrFY);
        showParameter.getListFilterParameter().setFilter(adjustFilter != null ? qFilter.or(adjustFilter) : qFilter);
    }
}

