/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class RptFormulaListPlugin
extends AbstractFormPlugin {
    private static final String KEY_FORMULALIST = "formulalist";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String FORMULA = "formula";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowDoubleClick(RowClickEvent evt) {
                RptFormulaListPlugin.this.rowDoubleClick(evt);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        String formulas = (String)this.getView().getFormShowParameter().getCustomParam("formulas");
        List lstFormula = FormulaAnalyze.analyticFun((String)formulas);
        IDataModel dataModel = this.getModel();
        int rowCount = lstFormula.size();
        this.getModel().batchCreateNewEntryRow(KEY_FORMULALIST, rowCount);
        for (int i = 0; i < rowCount; ++i) {
            dataModel.setEntryCurrentRowIndex(KEY_FORMULALIST, i);
            StringBuffer stringBuffer = new StringBuffer();
            ((FunctionExpr)lstFormula.get(i)).output(stringBuffer, null);
            dataModel.setValue(FORMULA, (Object)stringBuffer.toString(), i);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(KEY_BTNOK)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
            int[] rowSelect = entryGrid.getSelectRows();
            if (rowSelect.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u516c\u5f0f", (String)"RptFormulaListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openLinkQuery(rowSelect[0]);
        } else if (control.getKey().equals(KEY_BTNCANCEL)) {
            this.getView().close();
        }
    }

    private void rowDoubleClick(RowClickEvent evt) {
        this.openLinkQuery(evt.getRow());
    }

    private void openLinkQuery(int rowSelect) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
        String formulaStr = entryGrid.getModel().getValue(FORMULA, rowSelect).toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("rowSelect", rowSelect);
        result.put(FORMULA, formulaStr);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }
}

