/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.log.api.AppLogInfo;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.formplugin.report.BaseTableAdjustplugin;
import kd.fi.bcm.formplugin.template.util.SpreadDataModelUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class TableAdjustPlugin
extends BaseTableAdjustplugin {
    private static final String COL_NUMS = "colNums";
    private static final List<String> SYSCURRENCY = Arrays.asList("PC", "EC", "DC");
    private static final String DIMMEM_NUM2NAME = "dimMemNum2Name";
    private static final String COLNUM_SUFFIX = "number";
    protected static final String CELLDATA = "cellvalue";
    protected static final String ADJUSTDATA = "adjustdata";
    protected static final String AFTERDATA = "afterdata";
    protected static final String AFTERADJ_WITHOUT_CWP = "afterWithCwp";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int focusRow = entry.getEntryState().getFocusRow();
        if (focusRow == -1) {
            return;
        }
        Object afterData = SpreadDataModelUtil.dealValue(model.getValue(AFTERDATA, focusRow));
        Object adjustValue = SpreadDataModelUtil.dealValue(model.getValue(ADJUSTDATA, focusRow));
        Object afterAdjWithoutCwp = SpreadDataModelUtil.dealValue(model.getValue(AFTERADJ_WITHOUT_CWP, focusRow));
        Object cellValue = SpreadDataModelUtil.dealValue(model.getValue(CELLDATA, focusRow));
        if (ADJUSTDATA.equals(key)) {
            model.beginInit();
            try {
                Object afterValue = TableAdjustPlugin.add(afterAdjWithoutCwp, adjustValue, cellValue);
                model.setValue(AFTERDATA, afterValue, focusRow);
                model.setValue(ADJUSTDATA, adjustValue, focusRow);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (AFTERDATA.equals(key)) {
            model.beginInit();
            try {
                Object adjValue = TableAdjustPlugin.subtract(afterData, afterAdjWithoutCwp, cellValue);
                model.setValue(ADJUSTDATA, adjValue, focusRow);
                model.setValue(AFTERDATA, afterData, focusRow);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String currency;
        String num;
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        String cube = (String)this.getView().getFormShowParameter().getCustomParam("cube");
        List selectDimCell = (List)this.getView().getFormShowParameter().getCustomParam(SELECTCELL);
        Map commonMember = (Map)this.getView().getFormShowParameter().getCustomParam(COMMONMEMBER);
        List originSelectDimCell = (List)this.getView().getFormShowParameter().getCustomParam(ORI_SELECTCELL);
        Map originCommonMember = (Map)this.getView().getFormShowParameter().getCustomParam(ORI_COMMONMEMBER);
        String bpNum = (String)commonMember.get("Process");
        String entity = (String)commonMember.get("Entity");
        Long orgId = (Long)this.getView().getFormShowParameter().getCustomParam("orgId");
        Table dimMemNum2Name = (Table)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam(DIMMEM_NUM2NAME)));
        Table allAssoMembers = (Table)ThreadCache.get((Object)("assoMembInModel" + cube), () -> AssoStorageMemUtil.getAllAssoMembers((String)cube));
        if (commonMember.containsKey("MyCompany")) {
            if ("$ECur".equals(commonMember.get("MyCompany"))) {
                for (Map dim2mem : selectDimCell) {
                    num = ((String)dim2mem.get("Entity")).split("\\|")[0];
                    dim2mem.put("MyCompany", num);
                }
                commonMember.remove("MyCompany");
            }
        } else {
            for (Map dim2mem : selectDimCell) {
                if (!"$ECur".equals(dim2mem.get("MyCompany"))) continue;
                num = ((String)dim2mem.get("Entity")).split("\\|")[0];
                dim2mem.put("MyCompany", num);
            }
        }
        if (!commonMember.containsKey("Currency")) {
            for (int i = 0; i < selectDimCell.size(); ++i) {
                Map dim2num = (Map)selectDimCell.get(i);
                Map dim2num4Ori = (Map)originSelectDimCell.get(i);
                if (!SYSCURRENCY.contains(dim2num.get("Currency"))) continue;
                currency = this.dealDC(bpNum, entity, orgId, modelId, (String)dim2num.get("Currency"), dim2num);
                dim2num.put("Currency", currency);
                dim2num4Ori.put("Currency", currency);
            }
        }
        if (SYSCURRENCY.contains(commonMember.get("Currency"))) {
            for (int i = 0; i < selectDimCell.size(); ++i) {
                Map cellDim2mem = (Map)selectDimCell.get(i);
                Map originCellDim2mem = (Map)originSelectDimCell.get(i);
                currency = this.dealDC(bpNum, entity, orgId, modelId, (String)commonMember.get("Currency"), cellDim2mem);
                cellDim2mem.put("Currency", currency);
                originCellDim2mem.put("Currency", currency);
            }
            commonMember.remove("Currency");
            originCommonMember.remove("Currency");
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,membermodel,name,id", (QFilter[])new QFilter[]{filter});
        HashMap<String, IDNumberTreeNode> dim2mem = new HashMap<String, IDNumberTreeNode>(16);
        HashMap<String, DynamicObject> commonDimModelNum2dimDy = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> rowColDimNum2Dy = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : dims) {
            String dimNum = dim.getString(COLNUM_SUFFIX);
            if (originCommonMember.containsKey(dimNum)) {
                dim2mem.put(dim.getString("membermodel"), MemberReader.findMemberByNumber((String)cube, (String)dimNum, (String)((String)originCommonMember.get(dimNum))));
                commonDimModelNum2dimDy.put(dim.getString("membermodel"), dim);
            }
            if (!((Map)selectDimCell.get(0)).containsKey(dimNum)) continue;
            rowColDimNum2Dy.put(dimNum, dim);
        }
        this.initNewStylePageViewPanel(commonDimModelNum2dimDy);
        this.bindCtrlMapping(commonDimModelNum2dimDy);
        this.setDefaultValue(dim2mem);
        List<String> colNums = this.createTable(rowColDimNum2Dy);
        this.getView().getPageCache().put(COL_NUMS, ObjectSerialUtil.toByteSerialized(colNums));
        this.fillData(commonMember, originCommonMember, selectDimCell, originSelectDimCell, cube, (Table<String, String, String>)dimMemNum2Name, (Table<String, String, String>)allAssoMembers);
    }

    private String dealDC(String bpNum, String entity, Long orgId, Long modelId, String currency, Map<String, String> dim2mem) {
        if (bpNum == null) {
            bpNum = dim2mem.get("Process");
        }
        if (entity == null) {
            orgId = Long.parseLong(dim2mem.get("Entity").split("\\|")[1]);
        }
        Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)orgId, (String)bpNum, (String)currency, (long)0L, (long)0L);
        return (String)pair.p2;
    }

    private List<String> createTable(Map<String, DynamicObject> rowColDimNum2Dy) {
        ArrayList<String> colNames = new ArrayList<String>(10);
        Page page = new Page();
        DynamicEntry entity = new DynamicEntry("entryentity");
        LocaleString width = new LocaleString("10%");
        TextEditElement reportCell = this.createTextEditElement(ResManager.loadKDString((String)"\u8c03\u6574\u524d\u62a5\u8868\u6570", (String)"TableAdjustPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), CELLDATA, width, 0, true);
        entity.addElement((Element)reportCell);
        TextEditElement wihtoutCwpCell = this.createTextEditElement(ResManager.loadKDString((String)"\u975e\u8868\u5f0f\u8c03\u6574\u6570", (String)"TableAdjustPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AFTERADJ_WITHOUT_CWP, width, 0, true);
        Tips tips1 = new Tips();
        tips1.setContent(new LocaleString(ResManager.loadKDString((String)"\u975e\u8868\u5f0f\u8c03\u6574\u6570=\u62a5\u8868\u8c03\u6574\u6570\uff08ERADJ+ATTotal\uff09-\u8868\u5f0f\u8c03\u6574\u6570\uff08ERADJ+CWP\uff09", (String)"TableAdjustPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        tips1.setType("text");
        wihtoutCwpCell.setTips(tips1);
        entity.addElement((Element)wihtoutCwpCell);
        TextEditElement adjCell = this.createTextEditElement(ResManager.loadKDString((String)"\u786e\u8ba4\u8868\u5f0f\u8c03\u6574\u6570", (String)"TableAdjustPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ADJUSTDATA, width, 0, false);
        adjCell.setColor(this.COLOR);
        entity.addElement((Element)adjCell);
        TextEditElement afterAdjCell = this.createTextEditElement(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u62a5\u8868\u6570", (String)"TableAdjustPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AFTERDATA, width, 0, false);
        afterAdjCell.setColor(this.COLOR);
        Tips tips = new Tips();
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u62a5\u8868\u6570=\u8c03\u6574\u524d\u62a5\u8868\u6570+\u975e\u8868\u5f0f\u8c03\u6574\u6570+\u786e\u8ba4\u8868\u5f0f\u8c03\u6574\u6570", (String)"TableAdjustPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        tips.setType("text");
        afterAdjCell.setTips(tips);
        entity.addElement((Element)afterAdjCell);
        for (Map.Entry<String, DynamicObject> entry : rowColDimNum2Dy.entrySet()) {
            String dimName = entry.getValue().getString("name");
            String dimNum = entry.getKey();
            entity.addElement((Element)this.createTextEditElement(dimName, dimNum.toLowerCase(), width, 0, true));
            entity.addElement((Element)this.createTextEditElement(dimName, dimNum.toLowerCase() + COLNUM_SUFFIX, width, 0, true));
            colNames.add(dimNum);
        }
        page.addEntry(entity);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        return colNames;
    }

    private void fillData(Map<String, String> commonMember, Map<String, String> orignCommonMember, List<Map<String, String>> selectDimCell, List<Map<String, String>> originSelectDimCell, String cube, Table<String, String, String> dimMemNum2Name, Table<String, String, String> allAssoMembers) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        ArrayList<String> needHideDim = new ArrayList<String>(16);
        for (String dim : selectDimCell.get(0).keySet()) {
            if (CELLDATA.equals(dim)) continue;
            if (orignCommonMember.containsKey(dim)) {
                needHideDim.add(dim.toLowerCase());
            }
            needHideDim.add(dim.toLowerCase() + COLNUM_SUFFIX);
        }
        this.getView().setVisible(Boolean.valueOf(false), needHideDim.toArray(new String[0]));
        this.bulidEntry(commonMember, orignCommonMember, selectDimCell, originSelectDimCell, cube, dimMemNum2Name);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void bulidEntry(Map<String, String> commonMember, Map<String, String> oriCommonMember, List<Map<String, String>> selectDimCell, List<Map<String, String>> oriSelectDimCell, String cube, Table<String, String, String> dimMemNum2Name) {
        SQLBuilder sql = this.getOlapSql(commonMember, oriCommonMember, selectDimCell, oriSelectDimCell, cube, this.adjAtMem);
        Map result = OlapServiceHelper.queryData((SQLBuilder)sql).asMap();
        String[] dimOrder = sql.getSelectField();
        IDataModel model = this.getModel();
        int size = selectDimCell.size();
        int[] rows = model.batchCreateNewEntryRow("entryentity", size);
        for (int i = 0; i < rows.length; ++i) {
            Map<String, String> rowcolMems = selectDimCell.get(i);
            Map<String, String> oriCowcolMems = oriSelectDimCell.get(i);
            this.fillDimMemData(oriCowcolMems, rowcolMems, dimMemNum2Name, model, i, this.adjAtName);
            this.fillCellValue(commonMember, oriCommonMember, result, dimOrder, model, i, rowcolMems, oriCowcolMems, this.adjAtMem);
        }
        model.deleteEntryRow("entryentity", size);
    }

    private void fillCellValue(Map<String, String> commonMember, Map<String, String> oriCommonMember, Map<String, Object> result, String[] dimOrder, IDataModel model, int i, Map<String, String> rowcolMems, Map<String, String> oriRowcolMems, String adjustAtMem) {
        ArrayList<String> adjustMemLists = new ArrayList<String>(16);
        ArrayList<String> attotalMemLists = new ArrayList<String>(16);
        ArrayList<String> cellMemLists = new ArrayList<String>(16);
        for (String dim : dimOrder) {
            String mem = this.getMember(commonMember, rowcolMems, dim);
            adjustMemLists.add(this.dealProcessAndAudit(dim, mem, adjustAtMem));
            String oriMem = this.getMember(oriCommonMember, oriRowcolMems, dim);
            attotalMemLists.add(this.dealProcessAndAudit4Attotal(dim, oriMem));
            cellMemLists.add(this.dealProcessAndAudit4Cell(dim, oriMem));
        }
        String cellValueKey = String.join((CharSequence)"|", cellMemLists);
        Object cellValue = result.get(cellValueKey);
        model.setValue(CELLDATA, cellValue, i);
        String adjustDimKey = String.join((CharSequence)"|", adjustMemLists);
        Object adjValue = result.get(adjustDimKey);
        model.setValue(ADJUSTDATA, adjValue, i);
        String attotalDimKey = String.join((CharSequence)"|", attotalMemLists);
        Object attotalValue = result.get(attotalDimKey);
        model.setValue(AFTERDATA, attotalValue, i);
        Object withouCwp = TableAdjustPlugin.subtract(attotalValue, adjValue, cellValue);
        model.setValue(AFTERADJ_WITHOUT_CWP, withouCwp, i);
    }

    private String getMember(Map<String, String> commonMember, Map<String, String> rowcolMems, String dim) {
        String mem = "";
        if (rowcolMems.get(dim) != null) {
            mem = rowcolMems.get(dim);
            mem = this.getEntityNum(dim, mem);
        } else {
            mem = commonMember.get(dim);
        }
        return mem;
    }

    private void fillDimMemData(Map<String, String> oriRowColMems, Map<String, String> rowcolMems, Table<String, String, String> dimMemNum2Name, IDataModel model, int i, String adjatName) {
        for (Map.Entry<String, String> entry : rowcolMems.entrySet()) {
            String dim = entry.getKey();
            if (CELLDATA.equals(dim)) continue;
            String memNum = entry.getValue();
            memNum = this.getEntityNum(dim, memNum);
            model.setValue(dim + COLNUM_SUFFIX, (Object)memNum, i);
            if ("Currency".equals(dim)) {
                model.setValue(dim, (Object)memNum, i);
                continue;
            }
            String oriMemNum = memNum;
            if (oriRowColMems.containsKey(dim) && !"Entity".equals(dim)) {
                oriMemNum = oriRowColMems.get(dim);
            }
            String name = (String)dimMemNum2Name.get((Object)dim, (Object)oriMemNum);
            name = this.dealProcessAndAuditname(dim, adjatName, name);
            model.setValue(dim, (Object)name, i);
        }
    }

    private SQLBuilder getOlapSql(Map<String, String> commonMember, Map<String, String> oriCommonMember, List<Map<String, String>> selectDimCell, List<Map<String, String>> originSelectDimCell, String cube, String adjustAtMem) {
        SQLBuilder sql = new SQLBuilder(cube);
        HashMultimap dim2MembMap = HashMultimap.create();
        for (int i = 0; i < selectDimCell.size(); ++i) {
            Map<String, String> dim2mem = selectDimCell.get(i);
            Map<String, String> dim2mem4ori = originSelectDimCell.get(i);
            dim2mem.forEach((k, v) -> {
                v = this.getEntityNum((String)k, (String)v);
                if (CELLDATA.equals(k)) {
                    return;
                }
                dim2MembMap.put(k, v);
            });
            dim2mem4ori.forEach((k, v) -> {
                v = this.getEntityNum((String)k, (String)v);
                if (CELLDATA.equals(k)) {
                    return;
                }
                dim2MembMap.put(k, v);
            });
        }
        for (String dim2 : dim2MembMap.keySet()) {
            Set auditMems;
            sql.addSelectField(new String[]{dim2});
            if ("Process".equalsIgnoreCase(dim2)) {
                Set processMems = dim2MembMap.get((Object)dim2);
                processMems.add("EIRpt");
                processMems.add("ERpt");
                processMems.add("ERAdj");
                processMems.add("RAdj");
                sql.addFilter(dim2, processMems.toArray(new String[0]));
                continue;
            }
            if ("AuditTrail".equalsIgnoreCase(dim2)) {
                auditMems = dim2MembMap.get((Object)dim2);
                auditMems.add("ATTotal");
                auditMems.add(adjustAtMem);
                sql.addFilter(dim2, auditMems.toArray(new String[0]));
                continue;
            }
            if ("MyCompany".equalsIgnoreCase(dim2)) {
                auditMems = dim2MembMap.get((Object)dim2);
                auditMems.add("MyCompany");
                sql.addFilter(dim2, auditMems.toArray(new String[0]));
                continue;
            }
            sql.addFilter(dim2, dim2MembMap.get((Object)dim2).toArray(new String[0]));
        }
        HashMultimap commonDim2MembMap = HashMultimap.create();
        commonMember.forEach((dim, v) -> {
            commonDim2MembMap.put(dim, v);
            commonDim2MembMap.put(dim, oriCommonMember.get(dim));
        });
        commonMember.forEach((dim, v) -> {
            sql.addSelectField(new String[]{dim});
            if ("Process".equalsIgnoreCase((String)dim)) {
                sql.addFilter(dim, new String[]{v, "ERAdj", "RAdj", "ERpt", "EIRpt"});
            } else if ("AuditTrail".equalsIgnoreCase((String)dim)) {
                sql.addFilter(dim, new String[]{v, adjustAtMem, "ATTotal"});
            } else if ("MyCompany".equalsIgnoreCase((String)dim)) {
                sql.addFilter(dim, new String[]{v, "MyCompany"});
            } else {
                sql.addFilter(dim, commonDim2MembMap.get(dim).toArray(new String[0]));
            }
        });
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        return sql;
    }

    private String getEntityNum(String k, String v) {
        if ("Entity".equals(k)) {
            String[] split = v.split("\\|");
            v = split[0];
        }
        return v;
    }

    private void setDefaultValue(Map<String, IDNumberTreeNode> dim2mem) {
        ORM orm = ORM.create();
        for (Map.Entry<String, IDNumberTreeNode> entry : dim2mem.entrySet()) {
            String dimModelNum = entry.getKey();
            DynamicObjectType dataEntiyType = (DynamicObjectType)orm.getDataEntityType(dimModelNum);
            DynamicObject memberDyna = new DynamicObject(dataEntiyType, null);
            memberDyna.set("id", (Object)entry.getValue().getId());
            memberDyna.set(COLNUM_SUFFIX, (Object)entry.getValue().getNumber());
            String name = entry.getValue().getName();
            name = this.dealProcessAndAuditname(entry.getKey(), this.adjAtName, name);
            memberDyna.set("name", (Object)name);
            this.getModel().getDataEntity().set(this.sugarF7Key(dimModelNum, entry.getValue().getDimNumber()), (Object)memberDyna);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_save".equals(key)) {
            SaveCommandInfo info = new SaveCommandInfo();
            Map commonMember = (Map)this.getView().getFormShowParameter().getCustomParam(COMMONMEMBER);
            if (SYSCURRENCY.contains(commonMember.get("Currency"))) {
                commonMember.remove("Currency");
            }
            if ("$ECur".equals(commonMember.get("MyCompany"))) {
                commonMember.remove("MyCompany");
            }
            String adjAt = this.getView().getPageCache().get(ADJUST_AT_MEM);
            commonMember.forEach((dim, mem) -> {
                mem = this.dealProcessAndAudit((String)dim, (String)mem, adjAt);
                info.addfixedDimension(new String[]{dim, mem});
            });
            String cube = (String)this.getView().getFormShowParameter().getCustomParam("cube");
            info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            OlapCommandUtil.addSourceMeasure((String)cube, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.M1);
            List<String> colNums = this.getColNums();
            String[] rowColDimensions = colNums.toArray(new String[0]);
            info.setDimensions(rowColDimensions);
            CellSet cellSets = new CellSet(rowColDimensions, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            DynamicObjectCollection datas = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> numberLists = new ArrayList<String>(16);
            for (DynamicObject data : datas) {
                for (String colNum : colNums) {
                    String mem2 = data.getString(colNum.toLowerCase() + COLNUM_SUFFIX);
                    numberLists.add(this.dealProcessAndAudit(colNum, mem2, adjAt));
                }
                cellSets.setFromQuery(false);
                if (NumberUtils.isNumber((String)data.getString(ADJUSTDATA))) {
                    cellSets.set(numberLists.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)new BigDecimal(data.getString(ADJUSTDATA)));
                }
                numberLists.clear();
            }
            OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)cube);
            String opName = ResManager.loadKDString((String)"\u5feb\u6377\u8868\u5f0f\u8c03\u6574", (String)"TableAdjustPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDescription = ResManager.loadKDString((String)"%1s %2s %3s %4s \u4fdd\u5b58\u6210\u529f", (String)"TableAdjustPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)String.format(opDescription, this.getFormShowParam("year"), this.getFormShowParam("period"), this.getFormShowParam("entity"), this.getFormShowParam("template")), (Long)modelId, (String)this.getModel().getDataEntityType().getName());
            OperationLogUtil.writeOperationLog((AppLogInfo)logInfo);
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    private <T> T getFormShowParam(String name) {
        return (T)this.getView().getFormShowParameter().getCustomParam(name);
    }

    private List<String> getColNums() {
        String cloNamesCache = this.getPageCache().get(COL_NUMS);
        if (StringUtil.isEmptyString((String)cloNamesCache)) {
            return new ArrayList<String>(20);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)cloNamesCache);
    }
}

