/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.formplugin.report.ReportListPlugin;
import kd.fi.bcm.formplugin.report.context.ReportListContext;
import org.apache.commons.collections.CollectionUtils;

public class ReportListContextProvider {
    public static final String reportlistcontext = "reportlistcontext";
    public static final String model = "model";
    public static final String cslscheme = "cslscheme";
    public static final String entity = "entity";
    public static final String scenario = "scenario";
    public static final String year = "year";
    public static final String period = "period";
    public static final String currency = "currency";
    public transient ReportListPlugin plugin;
    private static final String cache_treeorg = "cache_treeentity";
    public Set<Long> selectTempIds = new HashSet<Long>(16);
    public Set<Long> selectOrgIds = new HashSet<Long>(16);
    public FilterSchemeModel filterSchemeModel;
    public ReportListContext context;
    private static final String ORG_CURR = "org_curr";

    public ReportListContextProvider(ReportListPlugin plugin, boolean isNeedFilterScheme) {
        this.plugin = plugin;
        if (isNeedFilterScheme) {
            Long planId = 0L;
            if (plugin.getValue("screenlist") == null) {
                return;
            }
            planId = ((DynamicObject)plugin.getValue("screenlist")).getLong("id");
            this.filterSchemeModel = new FilterSchemeModel(planId);
        }
    }

    public ReportListContextProvider() {
    }

    public ReportListContext getReportListContext(ReportListPlugin plugin) {
        DynamicObject modelDy = (DynamicObject)plugin.getValue(model);
        DynamicObject scenceDy = (DynamicObject)plugin.getValue(scenario);
        DynamicObject yearDy = (DynamicObject)plugin.getValue(year);
        DynamicObject periodDy = (DynamicObject)plugin.getValue(period);
        DynamicObject cyDy = (DynamicObject)plugin.getValue(currency);
        DynamicObject cslSchemeDy = (DynamicObject)plugin.getValue(cslscheme);
        if (modelDy == null || scenceDy == null || yearDy == null || periodDy == null || cyDy == null || cslSchemeDy == null) {
            return null;
        }
        DynamicObject[] templates = plugin.getSelectTemplates(false);
        this.context = new ReportListContext(modelDy.getLong("id"), cslSchemeDy.getLong("id"), scenceDy.getLong("id"), yearDy.getLong("id"), periodDy.getLong("id"), cyDy.getLong("id"), templates);
        this.context.setScenarioDy(scenceDy);
        this.context.setYearDy(yearDy);
        this.context.setPeriodDy(periodDy);
        this.context.setCyDy(cyDy);
        return this.context;
    }

    public ReportListContext getReportListContext(ReportListPlugin plugin, boolean needTemp) {
        DynamicObject modelDy = (DynamicObject)plugin.getValue(model);
        DynamicObject scenceDy = (DynamicObject)plugin.getValue(scenario);
        DynamicObject yearDy = (DynamicObject)plugin.getValue(year);
        DynamicObject periodDy = (DynamicObject)plugin.getValue(period);
        DynamicObject cyDy = (DynamicObject)plugin.getValue(currency);
        DynamicObject cslSchemeDy = (DynamicObject)plugin.getValue(cslscheme);
        if (modelDy == null || scenceDy == null || yearDy == null || periodDy == null || cyDy == null || cslSchemeDy == null) {
            return null;
        }
        this.context = new ReportListContext(modelDy.getLong("id"), cslSchemeDy.getLong("id"), scenceDy.getLong("id"), yearDy.getLong("id"), periodDy.getLong("id"), cyDy.getLong("id"));
        this.context.setScenarioDy(scenceDy);
        this.context.setYearDy(yearDy);
        this.context.setPeriodDy(periodDy);
        this.context.setCyDy(cyDy);
        if (needTemp) {
            DynamicObject[] templates = plugin.getSelectTemplates(false);
            this.context.setTemplates(templates);
        }
        return this.context;
    }

    public int getReportListCurrentSize(long modelid, long sceneid, long yearid, long periodid, long cyid, List<Long> orgids, List<Long> tmpids, boolean isFromReportWeave, boolean isOrgTab) {
        RightVersionTemplateParams params = new RightVersionTemplateParams(modelid, sceneid, yearid, periodid, cyid, false);
        params.setQuery(!isFromReportWeave);
        if (CollectionUtils.isNotEmpty(tmpids)) {
            params.setTemplateIds(tmpids.stream().collect(Collectors.toSet()));
        }
        int sum = 0;
        if (CollectionUtils.isNotEmpty(orgids)) {
            params.setOrgIds(orgids.stream().collect(Collectors.toSet()));
            for (Map.Entry entry : TemplateUtil.getCommitReportCount((RightVersionTemplateParams)params).entrySet()) {
                sum += ((ReportEditStatus)entry.getValue()).getAllReportCount();
            }
        }
        return sum;
    }

    public boolean isNeedTip() {
        if (this.filterSchemeModel != null) {
            return this.filterSchemeModel.needTips;
        }
        return false;
    }

    public Set<Long> getSelectTemplateIdByFilter() {
        if (!this.selectTempIds.isEmpty()) {
            return this.selectTempIds;
        }
        if (this.filterSchemeModel != null) {
            this.selectTempIds.addAll(this.filterSchemeModel.tempIds);
        }
        return this.selectTempIds;
    }

    public boolean isNeedSchemeFilter() {
        return this.filterSchemeModel != null;
    }

    public Set<Long> getSelectOrgIdByFilter() {
        if (!this.selectOrgIds.isEmpty()) {
            return this.selectOrgIds;
        }
        if (this.filterSchemeModel != null) {
            this.selectOrgIds.addAll(this.filterSchemeModel.orgIds);
        }
        return this.selectOrgIds;
    }

    public static class FilterSchemeModel {
        public List<Long> tempIds = new ArrayList<Long>(16);
        public List<Long> orgIds = new ArrayList<Long>(16);
        public List<Long> tempCatalogIds = new ArrayList<Long>(16);
        public DynamicObject plan;
        public long planId = 0L;
        public boolean needTips = false;

        public FilterSchemeModel(long planId) {
            this.planId = planId;
            Map planInfo = DataCollectUtil.datacollectscreenById((Long)planId);
            this.needTips = (Boolean)((List)planInfo.get("check")).get(0);
            this.orgIds.addAll((Collection)planInfo.get("orgIds"));
            this.tempCatalogIds.addAll((Collection)planInfo.get("catalogIds"));
            List templateNums = (List)planInfo.get("templateNumbers");
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)templateNums)});
            this.tempIds = doc.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
            if (!this.tempCatalogIds.isEmpty()) {
                DynamicObjectCollection temps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("templatecatalog", "in", this.tempCatalogIds)});
                if (this.tempIds.isEmpty()) {
                    this.tempIds.addAll(temps.stream().map(t -> t.getLong("id")).collect(Collectors.toList()));
                } else {
                    this.tempIds.retainAll(temps.stream().map(t -> t.getLong("id")).collect(Collectors.toList()));
                }
            }
        }
    }
}

