/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.csl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class LinkIntegrationPlugin
extends AbstractBaseListPlugin {
    protected static final String CTL_BILLLISTAP = "billlistap";
    protected static final String CTL_BILLLISTAPC = "billlistap1";
    private static String[] headArr;

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        BillList billList_c = (BillList)this.getControl(CTL_BILLLISTAPC);
        billList.addSetFilterListener(this::setFilter);
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
        billList_c.addSetFilterListener(this::setFilter);
        billList_c.addCreateListColumnsListener(this::beforeCreateListColumns);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String view = (String)this.getFormCustomParam("view");
        if ("1".equals(view)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_BILLLISTAPC});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CTL_BILLLISTAP});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_BILLLISTAP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CTL_BILLLISTAPC});
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filterList = e.getQFilters();
        Long modelId = (Long)this.getFormCustomParam("modelId");
        Map resultMap = (Map)this.getFormCustomParam("resultMap");
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        resultMap.keySet().forEach(key -> filter.and(new QFilter(key, "=", resultMap.get(key))));
        filterList.add(filter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Long modelId = (Long)this.getFormCustomParam("modelId");
        String modelType = HWModelParamUtil.getModelType((long)modelId);
        List listColumns = args.getListColumns();
        this.handleColumnsFieldKeys(listColumns, modelType);
    }

    private void handleColumnsFieldKeys(List<IListColumn> listColumns, String modelType) {
        List<String> colNames = this.getColNames(modelType);
        int temp = 0;
        if (HWModelTypeEnum.FIN.getNumber().equals(modelType)) {
            for (int i = 0; i < listColumns.size(); ++i) {
                listColumns.get(i).setCaption(new LocaleString(colNames.get(i - temp)));
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dim5"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"md_dim5"});
        } else if (HWModelTypeEnum.LG.getNumber().equals(modelType)) {
            for (int i = 0; i < listColumns.size(); ++i) {
                if ("dim5".equals(listColumns.get(i).getListFieldKey()) || "md_dim5".equals(listColumns.get(i).getListFieldKey())) {
                    ++temp;
                    continue;
                }
                listColumns.get(i).setCaption(new LocaleString(colNames.get(i - temp)));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"dim5"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"md_dim5"});
            }
        }
    }

    protected List<String> getColNames(String modelType) {
        if (HWModelTypeEnum.FIN.getNumber().equals(modelType)) {
            headArr = new String[]{"Batchname", "Year", "Period", "Entity", "EntityX", "Account", "AccountX", "ICP", "ICPX", "C1", "C1X", "C2", "C2X", "C3", "C3X", "C4", "C4X", "C5", "C5X", "Amount", "AmountX", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848", (String)"LinkIntegrationPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])};
            ArrayList<String> headList = new ArrayList<String>(headArr.length);
            Collections.addAll(headList, headArr);
            return headList;
        }
        if (HWModelTypeEnum.LG.getNumber().equals(modelType)) {
            headArr = new String[]{"Location-Name", "Year", "Period", "Source-Company", "Entity", "Source-Account", "Account", "Source-Intercompany", "ICP", "Source-Department", "Custom1", "Source-Custom2", "Custom2", "Source-Custom3", "Custom3", "Source-Custom4", "Custom4", "Source-Amount", "Amount", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848", (String)"LinkIntegrationPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])};
            ArrayList<String> headList = new ArrayList<String>(headArr.length);
            Collections.addAll(headList, headArr);
            return headList;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u7c7b\u578b\u201d\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u5728\u201c\u53c2\u6570\u7ba1\u7406>\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570\u4fe1\u606f\u540e\u91cd\u8bd5\u3002", (String)"LinkIntegrationPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_export": {
                this.handleExportData();
            }
        }
    }

    public void handleExportData() {
        List<String> list = this.getAllCols();
        String selectFields = StringUtils.join(list, (String)",");
        Long modelId = (Long)this.getFormCustomParam("modelId");
        Map resultMap = (Map)this.getFormCustomParam("resultMap");
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        resultMap.keySet().forEach(key -> filter.and(new QFilter(key, "=", resultMap.get(key))));
        DynamicObjectCollection toExportData = QueryServiceHelper.query((String)"bcm_datacomparisontable", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (toExportData == null || toExportData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"LinkIntegrationPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String modelType = HWModelParamUtil.getModelType((long)modelId);
        List<String> headerList = this.getColNames(modelType);
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCellStyle style = workBook.createCellStyle();
            XSSFDataFormat format = workBook.createDataFormat();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setDataFormat(format.getFormat("@"));
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            XSSFSheet xssfSheet = workBook.createSheet();
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            for (int i = 0; i < headerList.size(); ++i) {
                XSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(headerList.get(i));
                cell.setCellStyle((CellStyle)headerStyle);
            }
            ++rowNum;
            String[] split = selectFields.split(",");
            headerList.clear();
            Collections.addAll(headerList, split);
            for (DynamicObject rowData : toExportData) {
                ArrayList row = Lists.newArrayListWithExpectedSize((int)headerList.size());
                for (int i = 0; i < headerList.size(); ++i) {
                    row.add(rowData.get(headerList.get(i)));
                }
                XSSFRow xssfRow = xssfSheet.createRow(rowNum);
                for (int j = 0; j < row.size(); ++j) {
                    XSSFCell cell = xssfRow.createCell(j);
                    Object obj = row.get(j);
                    if (obj != null && !StringUtils.isEmpty((String)obj.toString())) {
                        cell.setCellValue(obj.toString());
                    }
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
            String url = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u8054\u67e5\u96c6\u6210\u5bfc\u51fa", (String)"LinkIntegrationPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((String)url)) {
                this.getClientViewProxy().addAction("download", (Object)url);
            }
        }
        catch (IOException ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LinkIntegrationPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getAllCols() {
        ArrayList<String> fieldlist = new ArrayList<String>();
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        List listFields = billList.getListFields();
        for (ListField listField : listFields) {
            fieldlist.add(listField.getListFieldKey());
        }
        return fieldlist;
    }
}

