/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.description;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;

public class ShowDescriptionPlugin
extends AbstractBaseListPlugin {
    private static final String billlistap = "billlistap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_delete");
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.hideDeleteBtn();
        this.refresh();
    }

    private void hideDeleteBtn() {
        String entityId = this.getView().getFormShowParameter().getCustomParam("entityId").toString();
        this.getView().setVisible(Boolean.valueOf("bcm_report_list".equals(entityId)), new String[]{"flexp_del"});
    }

    private void refresh() {
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.addSetFilterListener(this::setFilter);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String reportRecordId = this.getView().getFormShowParameter().getCustomParam("reportRecordId").toString();
        QFilter filter = this.getFilter(Long.valueOf(reportRecordId));
        e.getQFilters().add(filter);
    }

    private QFilter getFilter(Long reportRecordId) {
        DynamicObjectCollection descriptions = this.getDescriptions(reportRecordId);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject desc : descriptions) {
            ids.add(desc.getLong("id"));
        }
        return new QFilter("id", "in", ids);
    }

    private DynamicObjectCollection getDescriptions(Long reportRecordId) {
        DynamicObject reportRecord = this.getReportRecord(reportRecordId);
        String selectFields = "id, report";
        QFilter qFilter = this.getQFilter(reportRecord);
        return QueryServiceHelper.query((String)"bcm_rptdescriptionentity", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObject getReportRecord(Long reportRecordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)reportRecordId);
        String selectFileds = "id, model, template, entity, scene, fyear, period, currency, template.number, entity.number";
        DynamicObject rptRecord = QueryServiceHelper.queryOne((String)"bcm_reportlistentity", (String)selectFileds, (QFilter[])new QFilter[]{qFilter});
        return rptRecord;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_delete".equals(key)) {
            this.delete();
        }
    }

    private void delete() {
        BillList billList = (BillList)this.getView().getControl(billlistap);
        ListSelectedRowCollection coll = billList.getSelectedRows();
        if (coll.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81ea\u5df1\u521b\u5efa\u7684\u6700\u8fd1\u4e00\u6b21\u6ce8\u91ca\u6570\u636e\u3002", (String)"ShowDescriptionPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isCommit = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCommit");
        if (isCommit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4e0a\u62a5\u3001\u5df2\u5f52\u6863\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u6570\u636e\u3002", (String)"ShowDescriptionPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pKeyValues = coll.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "=", pKeyValues[0]);
        String selectFields = "id, model, template, entity, scene, fyear, period, currency, creator, createtime";
        DynamicObject select = QueryServiceHelper.queryOne((String)"bcm_rptdescriptionentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
        QFilter qFilter = this.getQFilter(select);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_rptdescriptionentity", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
        if (select.getString("creator").equals(RequestContext.get().getUserId()) && select.getString("createtime").equals(dys[0].getString("createtime"))) {
            DeleteServiceHelper.delete((String)"bcm_rptdescriptionentity", (QFilter[])new QFilter[]{filter});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ShowDescriptionPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u53ef\u5220\u9664\u81ea\u5df1\u521b\u5efa\u7684\u6700\u8fd1\u4e00\u6b21\u6ce8\u91ca\u6570\u636e\u3002", (String)"ShowDescriptionPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter getQFilter(DynamicObject object) {
        QFilter filter = new QFilter("model", "=", (Object)object.getLong("model"));
        filter.and(new QFilter("template", "=", (Object)object.getLong("template")));
        filter.and(new QFilter("entity", "=", (Object)object.getLong("entity")));
        filter.and(new QFilter("scene", "=", (Object)object.getLong("scene")));
        filter.and(new QFilter("fyear", "=", (Object)object.getLong("fyear")));
        filter.and(new QFilter("period", "=", (Object)object.getLong("period")));
        DynamicObject currencyObj = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("currency")));
        Object currency = DimensionUtil.getOrgCurrency(currencyObj, object.getLong("entity"), object.getLong("fyear"), object.getLong("period"));
        filter.and(new QFilter("currency", "=", (Object)Long.valueOf(currency.toString())));
        return filter;
    }
}

