/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.excelrptimport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.ImportDataUnitEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelRptImportContext {
    private Pair<Long, String> model;
    private Tuple<Long, String, Boolean> org;
    private Pair<Long, String> scene;
    private Pair<Long, String> year;
    private Pair<Long, String> period;
    private Pair<Long, String> currency;
    private Pair<Long, String> selectCurrecny;
    private Long scheme;
    private Map<String, Map<String, String>> defaultMembers;
    private Map<String, Map<Integer, Pair<Integer, Integer>>> floatConfig;
    private Map<String, Map<Integer, Pair<Integer, Integer>>> extendConfig;
    private Map<String, TemplateModel> templateModelMap;
    private String url;
    private Workbook book;
    private Long startTime;
    private Map<Long, String> all4Import;
    private Long userId;
    private ImportDataUnitEnum dataUnit;
    private Map<String, String> cell2cell = new HashMap<String, String>(16);
    private Map<String, Object> customParam = new HashMap<String, Object>(16);
    private Map<String, Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>>> extendData = new HashMap<String, Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>>>(16);

    public ExcelRptImportContext(Pair<Long, String> model, Pair<Long, String> org, Pair<Long, String> scene, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> currency, Long scheme, String url, Map<Long, String> all4Import) {
        this.model = model;
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,isleaf,storagetype,currency.id,currency.number", (QFilter[])new QFilter[]{new QFilter("id", "=", org.p1)});
        if (StorageTypeEnum.SHARE.index.equals(orgDyn.getString("storagetype"))) {
            QFBuilder qfBuilder1 = new QFBuilder("model", "=", model.p1);
            qfBuilder1.add("number", "=", (Object)orgDyn.getString("number"));
            qfBuilder1.add("storagetype", "in", (Object)StorageTypeEnum.STORAGE.index);
            orgDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,number,isleaf,storagetype,currency.id,currency.number", (QFilter[])qfBuilder1.toArray());
        }
        this.org = Tuple.create((Object)orgDyn.getLong("id"), (Object)orgDyn.getString("number"), (Object)orgDyn.getBoolean("isleaf"));
        this.scene = scene;
        this.year = year;
        this.period = period;
        this.selectCurrecny = currency;
        QFilter modelQFilter = new QFilter("model", "=", model.p1);
        this.handleCurrency((Long)org.p1, (Long)year.p1, (Long)period.p1, modelQFilter);
        this.scheme = scheme;
        this.url = url;
        this.startTime = new Date().getTime();
        this.all4Import = all4Import;
    }

    public Pair<Long, String> getModel() {
        return this.model;
    }

    public Tuple<Long, String, Boolean> getOrg() {
        return this.org;
    }

    public Pair<Long, String> getScene() {
        return this.scene;
    }

    public Pair<Long, String> getYear() {
        return this.year;
    }

    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    public Long getScheme() {
        return this.scheme;
    }

    public Workbook getBook() {
        return this.book;
    }

    public Map<String, Map<Integer, Pair<Integer, Integer>>> getFloatConfig() {
        return this.floatConfig;
    }

    public void setFloatConfig(Map<String, Map<Integer, Pair<Integer, Integer>>> floatConfig) {
        this.floatConfig = floatConfig;
    }

    public Map<String, TemplateModel> getTemplateModelMap() {
        return this.templateModelMap;
    }

    public void setTemplateModelMap(Map<String, TemplateModel> templateModelMap) {
        this.templateModelMap = templateModelMap;
    }

    public void setBook(Workbook book) {
        this.book = book;
    }

    public Map<String, Map<String, String>> getDefaultMembers() {
        return this.defaultMembers;
    }

    public void setDefaultMembers(Map<String, Map<String, String>> defaultMembers) {
        this.defaultMembers = defaultMembers;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Pair<Long, String> getSelectCurrecny() {
        return this.selectCurrecny;
    }

    private void handleCurrency(Long org, Long year, Long period, QFilter modelQFilter) {
        Long curId = 0L;
        String curNum = "";
        DynamicObject orgCurrency = OrgCurrencyServiceHelper.getOrgById((Long)org, (Long)year, (Long)period);
        curNum = orgCurrency.getString("currency.number");
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id, number", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)curNum)});
        curId = currency.getLong("id");
        curNum = currency.getString("number");
        this.currency = Pair.onePair((Object)curId, (Object)curNum);
    }

    public Map<Long, String> getAll4Import() {
        return this.all4Import;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public ImportDataUnitEnum getDataUnit() {
        return this.dataUnit;
    }

    public void setDataUnit(ImportDataUnitEnum dataUnit) {
        this.dataUnit = dataUnit;
    }

    public Map<String, Map<Integer, Pair<Integer, Integer>>> getExtendConfig() {
        return this.extendConfig;
    }

    public void setExtendConfig(Map<String, Map<Integer, Pair<Integer, Integer>>> extendConfig) {
        this.extendConfig = extendConfig;
    }

    public Map<String, String> getCell2cell() {
        return this.cell2cell;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        this.customParam = customParam;
    }

    public Map<String, Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>>> getExtendData() {
        return this.extendData;
    }
}

