/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.excelrptimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.integrationnew.service.IntegrationNewServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.ImportDataUnitEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.excelrptimport.ExcelRptImportContext;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.SeqLogicImpl;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.util.ReportRecordUtil;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.util.DynamicUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelRptImportHandler {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(ExcelRptImportHandler.class);
    private static final String KEY_SPLIT = "#";
    private static final String G_PRE = "g_";
    private static final String F_PRE = "f_";
    private static final String T_PRE = "t_";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NOT_FOUND = "not found";
    private static final String ASSO_STORE_OPEN = "assoStoreOpen";
    private static final String LOCK_DIM = "lockDim";
    private static final int MAX_BATCH_QUERYNUMS = 10000;
    private static final int ERRORMSG_LENGTH = 1000;
    private static final boolean IS_INCLUDE_ADJUST_LASTPERIOD = false;
    private static HashMap<String, DataTypeAcctCacheInfo> dataTypeMap = new HashMap(16);

    private ExcelRptImportHandler() {
    }

    public static Map<String, Object> importRpt(ExcelRptImportContext ctx) {
        ExcelRptImportHandler.setBook(ctx);
        ExcelRptImportHandler.setAssoStoreOpen(ctx);
        log.startWatch();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            Map<String, Object> data = ExcelRptImportHandler.doloadData(ctx, result);
            WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"\u89e3\u6790Excel\u6570\u636e\u8017\u65f6-->", (String)"ExcelRptImportHandler_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            ExcelRptImportHandler.doOutput(ctx, data, result);
            WatchLoggerUtil.debug((WatchLogger)log, (String)ResManager.loadKDString((String)"\u5339\u914d\u6570\u636e\u548c\u5199Olap\u8017\u65f6-->", (String)"ExcelRptImportHandler_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            ExcelRptImportHandler.executeCalculate(ctx);
        }
        catch (Exception e) {
            log.error("importRpt error:", (Throwable)e);
            if (e instanceof KDBizException) {
                throw e;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u4e0e\u6a21\u677f\u5df2\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelRptImportHandler_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return result;
    }

    private static void setAssoStoreOpen(ExcelRptImportContext ctx) {
        ctx.getCustomParam().put(ASSO_STORE_OPEN, ConfigServiceHelper.getBoolParam((Long)((Long)ctx.getModel().p1), (String)"CM043"));
        ctx.getCustomParam().put(LOCK_DIM, IntegrationUtil.getLockDim((Long)((Long)ctx.getModel().p1)));
    }

    private static void doOutputExtend(ExcelRptImportContext ctx, Map<String, Object> data, Map<String, Object> failRpt, Map<Long, String> successRpt, Map<String, String> warnRpt) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map extendData = (Map)data.get("extend");
        for (Map.Entry entry : extendData.entrySet()) {
            Map oneRptData = (Map)entry.getValue();
            Map t_data = (Map)oneRptData.get("t_data");
            TemplateModel model = ctx.getTemplateModelMap().get(entry.getKey());
            Map<String, String> filterView = ExcelRptImportHandler.getFilterView(ctx, model, true);
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
            int dataUnit = ExcelRptImportHandler.getDataUnit((Integer)spread.getBook().getSheet(0).getUserObject("dataunit"), ctx.getDataUnit());
            int extendIndex = 0;
            ArrayList<Pair<String, List<Long>>> deleteDataList = new ArrayList<Pair<String, List<Long>>>(16);
            ArrayList<EDSaveComInfo> saveDataList = new ArrayList<EDSaveComInfo>(16);
            for (PositionInfo e2 : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), false)) {
                String pre;
                List datas;
                ExtendInfo extendInfo = e2.getExtendInfo();
                if (extendInfo == null || CollectionUtils.isEmpty((Collection)(datas = (List)t_data.get(pre = T_PRE + ++extendIndex)))) continue;
                Map extHeadMapNum2Index = spread.getExtHeadInfoColNum2Indexs(e2);
                ExtendsModel extendsModel = ExcelRptImportHandler.getExtendsModel(extendInfo.getExtModelNumber(), (Long)ctx.getModel().p1);
                List fieldList = extendsModel.getFieldEntry();
                Pair<Boolean, String> mustInPair = ExcelRptImportHandler.checkMustInput(fieldList, extHeadMapNum2Index, datas, ctx, (String)entry.getKey(), pre);
                if (!((Boolean)mustInPair.p1).booleanValue()) {
                    failRpt.put((String)entry.getKey(), mustInPair.p2);
                    break;
                }
                List<String> uniqueList = fieldList.stream().filter(f -> f.getUniqueCheck()).map(f -> f.getNumber()).collect(Collectors.toList());
                Pair<Boolean, String> uniquePair = ExcelRptImportHandler.checkUnique(uniqueList, extHeadMapNum2Index, datas, ctx, (String)entry.getKey(), pre);
                if (!((Boolean)uniquePair.p1).booleanValue()) {
                    failRpt.put((String)entry.getKey(), uniquePair.p2);
                    break;
                }
                Pair<Boolean, EDSaveComInfo> eciPair = ExcelRptImportHandler.getSaveInfo(ctx, extendsModel, filterView, extHeadMapNum2Index);
                if (!((Boolean)eciPair.p1).booleanValue()) {
                    failRpt.put((String)entry.getKey(), ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e3a\u62a5\u8868\u6c47\u603b\u7684\u5408\u5e76\u7ec4\u7ec7\u4e0d\u80fd\u5bfc\u5165\u6570\u636e\u3002", (String)"ExcelRptImportHandler_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                EDSaveComInfo eci = (EDSaveComInfo)eciPair.p2;
                Pair<Map<String, String>, Map<String, String>> fieldMapped = ExcelRptImportHandler.getFieldMapped((Long)ctx.getModel().p1);
                Map extHeadMapIndex2Num = spread.getExtHeadInfo(e2);
                Map<String, Set<String>> floatMap = ExcelRptImportHandler.getFloatMap(extendInfo, ctx);
                Pair<Boolean, String> rightPair = ExcelRptImportHandler.checkData(extHeadMapNum2Index, extHeadMapIndex2Num, datas, floatMap, ctx, eci, (Map)fieldMapped.p2, (String)entry.getKey(), dataUnit, warnRpt, pre);
                if (!((Boolean)rightPair.p1).booleanValue()) {
                    failRpt.put((String)entry.getKey(), rightPair.p2);
                    break;
                }
                List<Long> ids = ExcelRptImportHandler.getDeleteIds(eci, uniqueList, extendsModel, (Map)fieldMapped.p1);
                if (ids.size() > 0) {
                    String extendDataEntity = "bcm_extenddata";
                    if (ExtendDimGroupType.TRANSACTION.getIndex().equals(extendsModel.getExtendsGroupType())) {
                        extendDataEntity = "bcm_extenddata_bus";
                    }
                    deleteDataList.add((Pair<String, List<Long>>)Pair.onePair((Object)extendDataEntity, ids));
                }
                saveDataList.add(eci);
            }
            if (failRpt.get(model.getNumber()) != null) continue;
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    Set fandeSet = (Set)ctx.getCustomParam().computeIfAbsent("float&extend", e -> new HashSet());
                    if (fandeSet.contains(model.getNumber())) {
                        ctx.getExtendData().put(model.getNumber(), (Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>>)Pair.onePair(deleteDataList, saveDataList));
                        continue;
                    }
                    ExcelRptImportHandler.saveExtend(deleteDataList, saveDataList);
                    successRpt.put(model.getId(), model.getNumber());
                }
                catch (Exception ex) {
                    tx.markRollback();
                    failRpt.put((String)entry.getKey(), "save data error");
                    log.error("ExtDataServiceHelper.saveData error", (Throwable)ex);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private static void saveExtend(List<Pair<String, List<Long>>> deleteDataList, List<EDSaveComInfo> saveDataList) {
        for (Pair<String, List<Long>> idPair : deleteDataList) {
            DeleteServiceHelper.delete((String)((String)idPair.p1), (QFilter[])new QFilter[]{new QFilter("id", "in", idPair.p2)});
        }
        for (EDSaveComInfo eci : saveDataList) {
            ExtDataServiceHelper.saveData((EDSaveComInfo)eci);
        }
    }

    private static List<Long> getDeleteIds(EDSaveComInfo eci, List<String> uniqueList, ExtendsModel extendsModel, Map<String, String> fieldMapped) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (uniqueList.size() == 0) {
            return ids;
        }
        String[] dims = eci.getDims();
        String[] cols = eci.getCols();
        ArrayList<Integer> indexList = new ArrayList<Integer>(16);
        for (String string : uniqueList) {
            int i;
            boolean isGetKey = false;
            for (i = 0; i < cols.length; ++i) {
                if (!string.equals(cols[i])) continue;
                indexList.add(i);
                isGetKey = true;
                break;
            }
            if (isGetKey) continue;
            for (i = 0; i < dims.length; ++i) {
                if (!string.equals(dims[i])) continue;
                indexList.add(cols.length + i);
            }
        }
        HashSet<String> removeSet = new HashSet<String>(16);
        for (Object[] value : eci.getAllValues()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indexList.size(); ++i) {
                Object valueIndex = value[(Integer)indexList.get(i)];
                String valueStr = "";
                valueStr = valueIndex instanceof Date ? ((Date)valueIndex).getTime() + "" : (valueIndex instanceof BigDecimal ? ((BigDecimal)valueIndex).stripTrailingZeros().toPlainString() : (valueIndex == null ? "" : valueIndex.toString()));
                sb.append(valueStr);
            }
            removeSet.add(sb.toString());
        }
        EdQueryComInfo edQueryComInfo = ExcelRptImportHandler.BuildComInfo(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber(), eci);
        DataSet rows = ExtDataServiceHelper.queryDataset((EdQueryComInfo)edQueryComInfo);
        while (rows.hasNext()) {
            kd.bos.algo.Row next = rows.next();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < uniqueList.size(); ++i) {
                String key = fieldMapped.get(uniqueList.get(i)) == null ? uniqueList.get(i) : fieldMapped.get(uniqueList.get(i));
                Object value = next.get(key);
                String valueStr = "";
                valueStr = value instanceof Date ? ((Date)value).getTime() + "" : (value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : (value == null ? "" : value.toString()));
                sb.append(valueStr);
            }
            if (!removeSet.contains(sb.toString())) continue;
            ids.add(next.getLong("id"));
        }
        return ids;
    }

    private static EdQueryComInfo BuildComInfo(String modelSNumber, String groupNumber, String extNumber, EDSaveComInfo eci) {
        EdQueryComInfo eqi = new EdQueryComInfo(modelSNumber, groupNumber, extNumber);
        eqi.setDimselects(eci.getDims());
        eqi.setExtselects(eci.getCols());
        Map fixedDimension = eci.getfixedDimension();
        eqi.addDimFilter(DimEntityNumEnum.ENTITY.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.ENTITY.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.YEAR.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.YEAR.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.PERIOD.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.PERIOD.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.CURRENCY.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.CURRENCY.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.SCENARIO.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.SCENARIO.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.PROCESS.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.PROCESS.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.AUDITTRIAL.getNumber(), new String[]{(String)fixedDimension.get(DimEntityNumEnum.AUDITTRIAL.getNumber())});
        return eqi;
    }

    private static Pair<Boolean, EDSaveComInfo> getSaveInfo(ExcelRptImportContext ctx, ExtendsModel extendsModel, Map<String, String> filterView, Map<String, Integer> extHeadMapNum2Index) {
        Pair<Boolean, String> entityPair = ExcelRptImportHandler.checkEntity(ctx);
        if (!((Boolean)entityPair.p1).booleanValue()) {
            return Pair.onePair((Object)false, null);
        }
        EDSaveComInfo eci = new EDSaveComInfo(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        eci.setIgnoreuniquevalue(true);
        String parenNumber = MemberReader.findEntityMemberById((Long)((Long)ctx.getModel().p1), (Long)((Long)ctx.getOrg().p1)).getParent().getNumber();
        eci.setParentOrg(parenNumber);
        HashMap<String, Object> fixDim = new HashMap<String, Object>(8);
        fixDim.put("Entity", ctx.getOrg().p2);
        fixDim.put("Year", ctx.getYear().p2);
        fixDim.put("Period", ctx.getPeriod().p2);
        fixDim.put("Scenario", ctx.getScene().p2);
        for (Map.Entry<String, String> view : filterView.entrySet()) {
            if ("Currency".equals(view.getKey()) || "AuditTrail".equals(view.getKey())) {
                fixDim.put(view.getKey(), view.getValue());
                continue;
            }
            if (!"Process".equals(view.getKey())) continue;
            fixDim.put(view.getKey(), entityPair.p2 == null ? view.getValue() : (String)entityPair.p2);
        }
        eci.setFixDim(fixDim);
        Map<String, String> extField2Mapped = extendsModel.getExtFieldEntry().stream().collect(Collectors.toMap(e -> e.getExtField().getNumber(), v -> v.getExtField().getMapped()));
        String[] cols = new String[extField2Mapped.size()];
        int i = 0;
        for (String string : extField2Mapped.keySet()) {
            cols[i++] = string;
        }
        eci.setCols(cols);
        ArrayList<String> dimList = new ArrayList<String>();
        for (String key : extHeadMapNum2Index.keySet()) {
            if ((fixDim.containsKey(key) || extField2Mapped.containsKey(key)) && !"Entity".equals(key)) continue;
            dimList.add(key);
        }
        String[] stringArray = dimList.toArray(new String[0]);
        eci.setDims(stringArray);
        return Pair.onePair((Object)true, (Object)eci);
    }

    private static Pair<Boolean, String> checkEntity(ExcelRptImportContext ctx) {
        if (((Boolean)ctx.getOrg().p3).booleanValue()) {
            return Pair.onePair((Object)true, null);
        }
        MergeDataSourceEnum mergeSource = MergeControlHelper.getMergeSource((Object)ctx.getModel().p1, (Object)ctx.getScene().p1, (Object)ctx.getYear().p1, (Object)ctx.getPeriod().p1, (Object)ctx.getOrg().p1);
        if (mergeSource == MergeDataSourceEnum.CSTE) {
            return Pair.onePair((Object)true, (Object)"EIRpt");
        }
        return Pair.onePair((Object)false, null);
    }

    private static Pair<Boolean, String> checkData(Map<String, Integer> extHeadMapNum2Index, Map<Integer, String> extHeadMapIndex2Num, List<Object> objects, Map<String, Set<String>> floatMap, ExcelRptImportContext ctx, EDSaveComInfo eci, Map<String, String> fieldMapped, String tempNumber, int dataUnit, Map<String, String> warnRpt, String pre) {
        Long modelId = (Long)ctx.getModel().p1;
        Map<String, Map<String, String>> checkMap = ExcelRptImportHandler.getCheckMap(floatMap, extHeadMapNum2Index, objects, modelId);
        Map<String, Integer> extMappingMap = ExcelRptImportHandler.getMappingMap(eci.getCols());
        Map<String, Integer> dimMappingMap = ExcelRptImportHandler.getMappingMap(eci.getDims());
        StringBuilder dataError = new StringBuilder();
        StringBuilder formatError = new StringBuilder();
        for (Object obj : objects) {
            Map map = (Map)obj;
            Object[] extData = new Object[eci.getCols().length];
            String[] dimData = new String[eci.getDims().length];
            for (Map.Entry data : map.entrySet()) {
                boolean isSetValue;
                String key = (String)data.getKey();
                String col = key.split(KEY_SPLIT)[1];
                Object value = data.getValue();
                String dim = extHeadMapIndex2Num.get(Integer.parseInt(col));
                Set<String> numberSet = floatMap.get(dim);
                if (numberSet == null) {
                    boolean isSetValue2 = ExcelRptImportHandler.setDataValue(extMappingMap, dimMappingMap, extData, dimData, dim, value, fieldMapped, dataUnit);
                    if (isSetValue2 || formatError.length() >= 1000) continue;
                    ExcelRptImportHandler.appendDataError(formatError, dim, ctx.getCell2cell().get(tempNumber + key + pre), value);
                    continue;
                }
                String number = checkMap.get(dim).get(value.toString());
                if (number == null && dataError.length() < 1000) {
                    ExcelRptImportHandler.appendDataError(dataError, dim, ctx.getCell2cell().get(tempNumber + key + pre), value);
                    continue;
                }
                if (number == null || (isSetValue = ExcelRptImportHandler.setDataValue(extMappingMap, dimMappingMap, extData, dimData, dim, number, fieldMapped, dataUnit)) || formatError.length() >= 1000) continue;
                ExcelRptImportHandler.appendDataError(formatError, dim, ctx.getCell2cell().get(tempNumber + key + pre), value);
            }
            String lockDim = (String)ctx.getCustomParam().get(LOCK_DIM);
            boolean islock = IntegrationUtil.checkLock((String[])eci.getDims(), (String[])dimData, (String)lockDim, warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getYear().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
            if (islock) continue;
            eci.addValue(extData, dimData);
        }
        String error = "";
        if (dataError.length() > 0) {
            error = String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5728\u6a21\u677f\u8bbe\u7f6e\u7684\u6210\u5458\u8303\u56f4\u5185\uff1a%1$s\u3002", (String)"ExcelRptImportHandler_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dataError);
        }
        if (formatError.length() > 0) {
            error = error + String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a%1$s\u3002", (String)"ExcelRptImportHandler_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), formatError);
        }
        if (StringUtil.isEmptyString((String)error)) {
            return Pair.onePair((Object)true, (Object)"");
        }
        return Pair.onePair((Object)false, (Object)error);
    }

    private static void appendFormatError(StringBuilder formatError, String error) {
        formatError.append("[");
        formatError.append(error);
        formatError.append("]");
    }

    private static void appendDataError(StringBuilder dataError, String dim, String cell, Object value) {
        dataError.append("[");
        dataError.append(dim);
        dataError.append(":");
        dataError.append(cell);
        dataError.append(":");
        dataError.append(value);
        dataError.append("]");
    }

    private static Map<String, Map<String, String>> getCheckMap(Map<String, Set<String>> floatMap, Map<String, Integer> extHeadMapNum2Index, List<Object> objects, Long modelId) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        HashMap<String, Map<String, String>> checkMap = new HashMap<String, Map<String, String>>(16);
        for (String key : floatMap.keySet()) {
            Integer index = extHeadMapNum2Index.get(key);
            ArrayList<String> nameList = new ArrayList<String>(16);
            for (Object obj : objects) {
                Map map = (Map)obj;
                String first = (String)map.keySet().stream().findFirst().get();
                String pre = first.split(KEY_SPLIT)[0];
                nameList.add((String)map.get(pre + KEY_SPLIT + index));
            }
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)key);
            QFilter dimQf = new QFilter("dimension.number", "=", (Object)key);
            QFilter nameQf = new QFilter("name", "in", nameList);
            DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"name, number", (QFilter[])new QFilter[]{modelQf, dimQf, nameQf});
            HashMap<String, String> checkDimMap = new HashMap<String, String>(16);
            for (DynamicObject obj : query) {
                checkDimMap.put(obj.getString("name"), obj.getString("number"));
            }
            checkMap.put(key, checkDimMap);
        }
        return checkMap;
    }

    private static boolean setDataValue(Map<String, Integer> extMappingMap, Map<String, Integer> dimMappingMap, Object[] extData, String[] dimData, String dim, Object value, Map<String, String> fieldMapped, int dataUnit) {
        if (dimMappingMap.containsKey(dim)) {
            dimData[dimMappingMap.get((Object)dim).intValue()] = value.toString();
        } else if (extMappingMap.containsKey(dim)) {
            int type = Integer.parseInt(fieldMapped.get(dim));
            Object data = null;
            try {
                if (value == null || value instanceof String && StringUtil.isEmptyString((String)((String)value))) {
                    data = DataTypeEnum.DEFAULT.getCode() == type || DataTypeEnum.CURRENCY.getCode() == type || DataTypeEnum.UNCURRENCY.getCode() == type || DataTypeEnum.PROPORTION.getCode() == type ? new BigDecimal(0) : null;
                } else if (DataTypeEnum.DEFAULT.getCode() == type || DataTypeEnum.CURRENCY.getCode() == type || DataTypeEnum.UNCURRENCY.getCode() == type || DataTypeEnum.PROPORTION.getCode() == type) {
                    BigDecimal dataBig = new BigDecimal(value.toString());
                    if (DataTypeEnum.DEFAULT.getCode() == type || DataTypeEnum.CURRENCY.getCode() == type) {
                        dataBig = dataBig.multiply(new BigDecimal(10).pow(dataUnit));
                    }
                    data = dataBig;
                } else if (DataTypeEnum.DATETP.getCode() == type) {
                    data = value instanceof Date ? value : DateTimeUtils.parseStrDate((String)value.toString());
                } else if (DataTypeEnum.TXT.getCode() == type) {
                    data = value.toString();
                }
                extData[extMappingMap.get((Object)dim).intValue()] = data;
            }
            catch (Throwable e) {
                log.error("turn format error", e);
                return false;
            }
        }
        return true;
    }

    private static Map<String, Integer> getMappingMap(String[] cols) {
        HashMap<String, Integer> mappingMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < cols.length; ++i) {
            mappingMap.put(cols[i], i);
        }
        return mappingMap;
    }

    private static Pair<Boolean, String> checkUnique(List<String> uniqueList, Map<String, Integer> extHeadMap, List<Object> dataList, ExcelRptImportContext ctx, String tempNumber, String pre) {
        if (uniqueList.size() == 0) {
            return Pair.onePair((Object)true, (Object)"");
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(16);
        for (String input : uniqueList) {
            Integer index = extHeadMap.get(input);
            if (index == null) continue;
            indexList.add(index);
        }
        HashSet<String> uniqueSet = new HashSet<String>(16);
        StringBuilder errorMsg = new StringBuilder();
        for (Object obj : dataList) {
            Map map = (Map)obj;
            String first = (String)map.keySet().stream().findFirst().get();
            String preKey = first.split(KEY_SPLIT)[0];
            StringBuilder sb = new StringBuilder();
            StringBuilder errorSb = new StringBuilder("[");
            for (Integer index : indexList) {
                String key = preKey + KEY_SPLIT + index;
                Object value = map.get(key);
                if (value == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u552f\u4e00\u503c\u548c\u5fc5\u5f55\u9879\u5fc5\u987b\u505a\u6620\u5c04\uff1a%1$s\u3002", (String)"ExcelRptImportHandler_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), tempNumber));
                }
                sb.append(value.toString());
                errorSb.append(ctx.getCell2cell().get(tempNumber + key + pre)).append(":").append(value.toString()).append(";");
            }
            errorSb.append("]");
            if (uniqueSet.add(sb.toString()) || errorMsg.length() >= 1000) continue;
            errorMsg.append((CharSequence)errorSb);
        }
        if (errorMsg.length() > 0) {
            return Pair.onePair((Object)false, (Object)String.format(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u91cd\u590d\uff1a%1$s\u3002", (String)"ExcelRptImportHandler_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), errorMsg));
        }
        return Pair.onePair((Object)true, (Object)"");
    }

    private static Pair<Map<String, String>, Map<String, String>> getFieldMapped(Long modelId) {
        DynamicObjectCollection extModel = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,fieldmapped, datatype,enumitem.datatype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        DynamicObjectCollection userDefined = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,fieldmapped", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("issysdimension", "=", (Object)"0")});
        HashMap<String, String> fieldMapped = new HashMap<String, String>(16);
        HashMap<String, String> fieldType = new HashMap<String, String>(16);
        for (DynamicObject object : extModel) {
            fieldMapped.put(object.getString("number"), object.getString("fieldmapped"));
            if (DataTypeEnum.ENUMTP.getCode() == Integer.parseInt(object.getString("datatype"))) {
                fieldType.put(object.getString("number"), object.getString("enumitem.datatype"));
                continue;
            }
            fieldType.put(object.getString("number"), object.getString("datatype"));
        }
        for (DynamicObject object : userDefined) {
            fieldMapped.put(object.getString("number"), object.getString("fieldmapped"));
        }
        return Pair.onePair(fieldMapped, fieldType);
    }

    private static Pair<Boolean, String> checkMustInput(List<FieldEntry> fieldList, Map<String, Integer> extHeadMap, List<Object> objects, ExcelRptImportContext ctx, String tempNumber, String pre) {
        List inputList = fieldList.stream().filter(f -> f.getIsNecessary()).map(f -> f.getNumber()).collect(Collectors.toList());
        StringBuilder errorMsg = new StringBuilder();
        for (String input : inputList) {
            Integer col = extHeadMap.get(input);
            if (col == null) continue;
            String key = KEY_SPLIT + col;
            boolean isHasMustIn = false;
            for (Object obj : objects) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    if (!((String)entry.getKey()).endsWith(key)) continue;
                    isHasMustIn = true;
                    if (entry.getValue() == null && errorMsg.length() < 1000) {
                        ExcelRptImportHandler.appendInputMsg(errorMsg, input, ctx.getCell2cell().get(tempNumber + (String)entry.getKey() + pre));
                        continue;
                    }
                    if (!(entry.getValue() instanceof String) || !StringUtil.isEmptyString((String)entry.getValue().toString()) || errorMsg.length() >= 1000) continue;
                    ExcelRptImportHandler.appendInputMsg(errorMsg, input, ctx.getCell2cell().get(tempNumber + (String)entry.getKey() + pre));
                }
            }
            if (isHasMustIn || errorMsg.length() >= 1000) continue;
            ExcelRptImportHandler.appendInputMsg(errorMsg, input, "");
        }
        if (errorMsg.length() > 0) {
            return Pair.onePair((Object)false, (Object)String.format(ResManager.loadKDString((String)"\u672a\u586b\u5199\u5fc5\u5f55\u5b57\u6bb5\uff1a%1$s\u3002", (String)"ExcelRptImportHandler_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), errorMsg));
        }
        return Pair.onePair((Object)true, (Object)"");
    }

    private static void appendInputMsg(StringBuilder errorMsg, String input, String cell) {
        errorMsg.append("[");
        errorMsg.append(input);
        errorMsg.append("->");
        errorMsg.append(cell);
        errorMsg.append("]");
    }

    private static ExtendsModel getExtendsModel(String extModelNumber, Long modelId) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter numberQf = new QFilter("number", "=", (Object)extModelNumber);
        DynamicObject extendModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{modelQf, numberQf});
        return new ExtendsModel(Long.valueOf(extendModel.getLong("id")));
    }

    private static Map<String, Set<String>> getFloatMap(ExtendInfo extendInfo, ExcelRptImportContext ctx) {
        Long modelId = (Long)ctx.getModel().p1;
        HashMap<String, Set<String>> floatMap = new HashMap<String, Set<String>>(16);
        List floatdims = extendInfo.getFloatdims();
        for (FloatDimInfo fdi : floatdims) {
            String number = fdi.getDimension().getNumber();
            HashSet<String> numberSet = new HashSet<String>(16);
            if (fdi.getDynaMembScopes().size() > 0) {
                for (DynaMembScopeInfo dmsi : fdi.getDynaMembScopes()) {
                    MembRangeItem rangItem = new MembRangeItem(fdi.getDimension().getUqCode(), Long.valueOf(dmsi.getMember().getId()), dmsi.getMember().getNumber(), RangeEnum.getRangeByVal((int)dmsi.getRangeId()), dmsi.isCustom(), (Object)modelId);
                    rangItem.matchItems(c -> numberSet.add(c.getNumber()));
                }
            } else if (fdi.getMember() != null) {
                numberSet.add(fdi.getMember().getNumber());
            }
            floatMap.put(number, numberSet);
        }
        if (extendInfo.isShowDataSourceOrg()) {
            HashSet<Object> numberSet = new HashSet<Object>(16);
            numberSet.add(ctx.getOrg().p2);
            floatMap.put("Entity", numberSet);
        }
        return floatMap;
    }

    private static void executeCalculate(ExcelRptImportContext ctx) {
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"calculate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ctx.getScheme())});
        if ("true".equals(scheme.getString("calculate"))) {
            IRunner runner = () -> {
                log.info("executeCalculate param is:" + (String)ctx.getModel().p2 + ";" + (String)ctx.getOrg().p2 + ";" + (String)ctx.getScene().p2 + ";" + (String)ctx.getYear().p2 + ";" + (String)ctx.getPeriod().p2);
                MergeControlService.getInstance().executeCalculate((String)ctx.getModel().p2, (String)ctx.getOrg().p2, (String)ctx.getScene().p2, (String)ctx.getYear().p2, (String)ctx.getPeriod().p2);
            };
            ThreadPoolService.runInCalAfterIntegrateThread((IRunner)runner);
        }
    }

    private static void setBook(ExcelRptImportContext ctx) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(ctx.getUrl());){
            HSSFWorkbook workBook = null;
            if (ctx.getUrl().endsWith("xls")) {
                workBook = new HSSFWorkbook(inputStream);
            } else if (ctx.getUrl().endsWith("xlsx")) {
                workBook = new XSSFWorkbook(inputStream);
            }
            ctx.setBook((Workbook)workBook);
        }
        catch (Exception e) {
            log.error("setBook error ", (Throwable)e);
            if (e instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"ExcelRptImportHandler_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private static void doOutput(ExcelRptImportContext ctx, Map<String, Object> data, Map<String, Object> failRpt) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ctx.setDefaultMembers(ExcelRptImportHandler.getTemplateDimMap(ctx));
        List allDim = DimensionServiceHelper.getAllDim((Long)((Long)ctx.getModel().p1));
        SaveCommandInfo info = new SaveCommandInfo();
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        info.setMeasures(new String[]{measure});
        OlapCommandUtil.addSourceMeasure((String)((String)ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
        info.setDimensions(allDim.toArray(new String[0]));
        CellSet cellSets = new CellSet(allDim.toArray(new String[0]), new String[]{measure});
        HashMap<Long, String> successRpt = new HashMap<Long, String>(16);
        HashMap<String, String> warnRpt = new HashMap<String, String>(16);
        HashMap<Long, String> noDimRptDataModels = new HashMap<Long, String>(16);
        ExcelRptImportHandler.doOutputExtend(ctx, data, failRpt, successRpt, warnRpt);
        Map fixData = (Map)data.get("fix");
        for (Map.Entry entry : fixData.entrySet()) {
            Map map;
            if (failRpt.containsKey(entry.getKey()) || CollectionUtils.isEmpty((Map)(map = (Map)entry.getValue()))) continue;
            TemplateModel model = ctx.getTemplateModelMap().get(entry.getKey());
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
            int dataUnit = ExcelRptImportHandler.getDataUnit((Integer)spread.getBook().getSheet(0).getUserObject("dataunit"), ctx.getDataUnit());
            Map<String, String> filterView = ExcelRptImportHandler.getFilterView(ctx, model, false);
            if (filterView.get(PresetConstant.FY_DIM) == null || filterView.get(PresetConstant.PERIOD_DIM) == null) {
                failRpt.put((String)entry.getKey(), ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u5728\u884c\u5217\u7ef4\u7684\u62a5\u8868\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"ExcelRptImportHandler_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                continue;
            }
            if (model.isSaveByDim()) {
                Set<String> pageDim = ExcelRptImportHandler.getPageDim(model);
                ExcelRptImportHandler.analysisFix(ctx, info, cellSets, warnRpt, spread, filterView, map, allDim, measure, dataUnit, (String)entry.getKey(), failRpt, pageDim);
            } else {
                String rptDataModel = ExcelRptImportHandler.analysisFixSaveNotByDim(spread, map);
                noDimRptDataModels.put(model.getId(), rptDataModel);
            }
            if (failRpt.get(entry.getKey()) != null) continue;
            successRpt.put(model.getId(), model.getNumber());
        }
        Map floatData = (Map)data.get("float");
        for (Map.Entry entry : floatData.entrySet()) {
            if (failRpt.containsKey(entry.getKey())) continue;
            Map oneRptData = (Map)entry.getValue();
            Map f_data = (Map)oneRptData.get("f_data");
            TemplateModel model = ctx.getTemplateModelMap().get(entry.getKey());
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
            int dataUnit = ExcelRptImportHandler.getDataUnit((Integer)spread.getBook().getSheet(0).getUserObject("dataunit"), ctx.getDataUnit());
            Map<String, String> filterView = ExcelRptImportHandler.getFilterView(ctx, model, false);
            if (filterView.get(PresetConstant.FY_DIM) == null || filterView.get(PresetConstant.PERIOD_DIM) == null) {
                failRpt.put((String)entry.getKey(), ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u5728\u884c\u5217\u7ef4\u7684\u62a5\u8868\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"ExcelRptImportHandler_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                continue;
            }
            Set<String> pageDim = ExcelRptImportHandler.getPageDim(model);
            boolean isDirectHoriz = DynamicUtils.isDirectHoriz((SpreadManager)spread);
            ArrayList basePointInfos = new ArrayList(10);
            ArrayList<int[]> dataStartPosition = new ArrayList<int[]>(10);
            for (PositionInfo positionInfo : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
                if (!positionInfo.isFloatPosition()) continue;
                basePointInfos.addAll(positionInfo.getBasePoints());
                int[] start = ExcelUtils.pos2Point((String)positionInfo.getStartPosition()).toArray();
                for (BasePointInfo bp : positionInfo.getBasePoints()) {
                    dataStartPosition.add(start);
                }
            }
            ArrayList<Pair> tempData = new ArrayList<Pair>();
            for (Map.Entry fentry : f_data.entrySet()) {
                Object line22;
                HashMap seqMap = new HashMap();
                Integer index = Integer.parseInt(((String)fentry.getKey()).replace(F_PRE, "")) - 1;
                BasePointInfo basePoint = (BasePointInfo)basePointInfos.get(index);
                String dynaRange = basePoint.getDynaRange();
                String[] range = dynaRange.split(":");
                int[] startXY = ExcelUtils.pos2Point((String)range[0]).toArray();
                HashMap<Integer, String> dynColMap = new HashMap<Integer, String>();
                HashMap<String, String> fixFloatMap = new HashMap<String, String>();
                HashMap<String, String> hideFloatMap = new HashMap<String, String>();
                HashMap<String, List<DynaMembScopeInfo>> scopeMap = new HashMap<String, List<DynaMembScopeInfo>>();
                boolean hasSeq = false;
                String seqDim = null;
                for (Object line22 : basePoint.getBasePointInnerLineInfo()) {
                    if (line22.isSeq()) {
                        hasSeq = true;
                        seqDim = ((DynaMembScopeInfo)line22.getDynaMembScopes().get(0)).getMember().getDimension().getNumber();
                        continue;
                    }
                    if (line22.getOffset() != -1) {
                        dynColMap.put(startXY[0] + line22.getOffset(), line22.getDimension().getNumber());
                        List scopes = line22.getDynaMembScopes();
                        if (scopes.isEmpty()) {
                            ExcelRptImportHandler.setDefaultScope((Long)ctx.getModel().p1, (BasePointInnerLineInfo)line22, scopes);
                        }
                        scopeMap.put(line22.getDimension().getNumber(), scopes);
                        continue;
                    }
                    if (line22.isIshide()) {
                        hideFloatMap.put(line22.getDimension().getNumber(), line22.getNumberfrom());
                        continue;
                    }
                    fixFloatMap.put(((DynaMembScopeInfo)line22.getDynaMembScopes().get(0)).getMember().getDimension().getNumber(), ((DynaMembScopeInfo)line22.getDynaMembScopes().get(0)).getMember().getNumber());
                }
                HashMap<String, Set<String>> allFloatMembers = new HashMap<String, Set<String>>(16);
                line22 = ((List)fentry.getValue()).iterator();
                while (line22.hasNext()) {
                    Object dr = line22.next();
                    Map dataRow = (Map)dr;
                    dataRow.forEach((axis, v) -> {
                        int col = Integer.parseInt(axis.split(KEY_SPLIT)[1]);
                        String dim = (String)dynColMap.get(col);
                        if (!StringUtils.isEmpty((CharSequence)dim)) {
                            Set members = allFloatMembers.computeIfAbsent(dim, k -> new HashSet(16));
                            if (v instanceof Double) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s\uff08%2$s\uff09\u5bf9\u5e94\u7684\u6570\u636e\u7b2c%3s\u5217\u6d6e\u52a8\u6210\u5458\u4e3a\u6570\u503c\u7c7b\u578b\uff0c\u5305\u542b\u6570\u503c:%4$s\uff0c\u6d6e\u52a8\u6210\u5458\u53ea\u652f\u6301\u6587\u672c\u683c\u5f0f\u3002", (String)"ExcelRptImportHandler_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), ExcelUtils.int2pos((int)col), v.toString()));
                            }
                            if (!StringUtils.isEmpty((CharSequence)((String)v).trim())) {
                                members.add(((String)v).trim());
                            }
                        }
                    });
                }
                boolean isCheckPass = true;
                Pair<List<Map<String, String>>, Map<String, Map<String, String>>> mappedMember = ExcelRptImportHandler.checkMembers(ctx, allFloatMembers, scopeMap, model, dynaRange);
                if (!CollectionUtils.isEmpty((Collection)((Collection)mappedMember.p1))) {
                    isCheckPass = false;
                    List reportList = (List)failRpt.get(model.getNumber());
                    if (reportList == null) {
                        failRpt.put(model.getNumber(), mappedMember.p1);
                    } else {
                        reportList.addAll((Collection)mappedMember.p1);
                    }
                }
                if (!isCheckPass) continue;
                HashMap rowMap = new HashMap();
                for (Object dr : (List)fentry.getValue()) {
                    Map dataRow = (Map)dr;
                    dataRow.forEach((axis, v) -> {
                        int row = Integer.parseInt(axis.split(KEY_SPLIT)[0]);
                        int col = Integer.parseInt(axis.split(KEY_SPLIT)[1]);
                        String dim = (String)dynColMap.get(col);
                        if (!StringUtils.isEmpty((CharSequence)dim)) {
                            String trimedV = ((String)v).trim();
                            Map dimMap = rowMap.computeIfAbsent(row, k -> new HashMap());
                            if (((Map)mappedMember.p2).get(dim) != null) {
                                dimMap.put(dim, ((Map)((Map)mappedMember.p2).get(dim)).getOrDefault(trimedV, trimedV));
                            } else {
                                dimMap.put(dim, trimedV);
                            }
                        }
                    });
                }
                if (hasSeq && rowMap.size() > 0) {
                    List seqNumbers = (List)ThreadCache.get((Object)"seqNumbers", () -> new SeqLogicImpl(spread, (Long)ctx.getModel().p1, isDirectHoriz).getSeqnumbers());
                    if (rowMap.size() > seqNumbers.size()) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u62a5\u8868\u6a21\u677f\u4e2d\u5e8f\u53f7\u6210\u5458\u6700\u591a\u652f\u6301%3$s\u4e2a\uff0c\u5bfc\u5165\u6570\u636e\u8d85\u51fa\u5e8f\u53f7\u6210\u5458\u4e2a\u6570\u3002", (String)"ExcelRptImportHandler_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), seqNumbers.size()));
                    }
                    HashMap<String, Integer> counterMap = new HashMap<String, Integer>(rowMap.size());
                    for (Map.Entry entry2 : rowMap.entrySet()) {
                        StringBuilder key = new StringBuilder();
                        for (Object dim : dynColMap.values()) {
                            key.append((String)((Map)entry2.getValue()).get(dim)).append('_');
                        }
                        Integer count = (Integer)counterMap.get(key.toString());
                        if (count == null) {
                            count = 1;
                        } else {
                            Object dim;
                            dim = count;
                            Integer n = count = Integer.valueOf(count + 1);
                        }
                        counterMap.put(key.toString(), count);
                        seqMap.put(entry2.getKey(), seqNumbers.get(count - 1));
                    }
                }
                HashMap colMap = new HashMap(16);
                basePoint.getFixMemberPosition().forEach((col, dims) -> {
                    Integer key = ((int[])dataStartPosition.get(index))[0] + col;
                    Map dimMap = colMap.computeIfAbsent(key, k -> new HashMap(16));
                    for (IDimMember dim : dims) {
                        dimMap.put(dim.getDimension().getNumber(), dim.getNumber());
                    }
                });
                for (Object dr : (List)fentry.getValue()) {
                    Map map = (Map)dr;
                    for (Map.Entry dataRowEntry : map.entrySet()) {
                        int row = Integer.parseInt(((String)dataRowEntry.getKey()).split(KEY_SPLIT)[0]);
                        int col2 = Integer.parseInt(((String)dataRowEntry.getKey()).split(KEY_SPLIT)[1]);
                        if (dynColMap.containsKey(col2)) continue;
                        HashMap<String, String> dimMap = new HashMap<String, String>();
                        if (rowMap.get(row) == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u62a5\u8868\u6a21\u677f\u4e2d\u7b2c%3$s\u884c\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u7ec4\u5408\uff0c\u5982\u679c\u4e0d\u9700\u8981\u5bfc\u5165\uff0c\u53ef\u4ee5\u6e05\u9664\u8be5\u8868\u5355\u5143\u683c\u6620\u5c04\u540e\u518d\u8bd5\u3002", (String)"ExcelRptImportHandler_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), row + 1));
                        }
                        if (colMap.get(col2) == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u62a5\u8868\u6a21\u677f\u4e2d\u7b2c%3$s\u5217\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u7ec4\u5408\uff0c\u5982\u679c\u4e0d\u9700\u8981\u5bfc\u5165\uff0c\u53ef\u4ee5\u6e05\u9664\u8be5\u8868\u5355\u5143\u683c\u6620\u5c04\u540e\u518d\u8bd5\u3002", (String)"ExcelRptImportHandler_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), ExcelUtils.int2pos((int)col2)));
                        }
                        ((Map)rowMap.get(row)).forEach(dimMap::put);
                        ((Map)colMap.get(col2)).forEach(dimMap::put);
                        fixFloatMap.forEach(dimMap::put);
                        filterView.forEach(dimMap::put);
                        hideFloatMap.forEach((k, v) -> {
                            String cfr_ignored_0 = (String)dimMap.put((String)k, (String)dimMap.get(v));
                        });
                        if (hasSeq) {
                            dimMap.put(seqDim, (String)seqMap.get(row));
                        }
                        ArrayList<String> members = new ArrayList<String>(10);
                        for (String dim : allDim) {
                            IDNumberTreeNode memb;
                            String m = (String)dimMap.get(dim);
                            if (StringUtils.isEmpty((CharSequence)m)) {
                                if (PresetConstant.MYCOMPANY_DIM.equals(dim)) {
                                    m = (String)ctx.getOrg().p2;
                                } else {
                                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u62a5\u8868\u6a21\u677f\u4e2d\u7ef4\u5ea6%3$s\u5b58\u5728\u6210\u5458\u4e3a\u7a7a\u3002", (String)"ExcelRptImportHandler_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), dim) + "\n" + String.format(ResManager.loadKDString((String)"dataRow:%1$s", (String)"ExcelRptImportHandler_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), JSON.toJSONString(dr)));
                                }
                            }
                            if (NOT_FOUND.equals((memb = MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)dim, (String)m)).getNumber())) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u62a5\u8868\u6a21\u677f\u4e2d\u7ef4\u5ea6%3$s\u4e2d\u4e0d\u5b58\u5728\u6210\u5458%4$s\u3002", (String)"ExcelRptImportHandler_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), model.getName(), model.getNumber(), dim, m));
                            }
                            if (!ExcelRptImportHandler.checkCanSave(memb = ExcelRptImportHandler.getAssoStoreMem(ctx, memb, pageDim), dim)) break;
                            members.add(memb.getNumber());
                        }
                        if (members.size() != allDim.size()) continue;
                        Map<String, String> dim2Members = ExcelRptImportHandler.getDim2MembersMap(allDim, dimMap, new HashMap<String, String>(1));
                        DataTypeEnum dataType = CellDataTypeUtil.getCellDataTypeThreadCache((long)((Long)ctx.getModel().p1), dim2Members, dataTypeMap);
                        String cellValue = (String)dataRowEntry.getValue();
                        Object value = ExcelRptImportHandler.getOlapValue(cellValue, dataType, dataUnit, ExcelUtils.int2pos((int)col2), model.getNumber(), failRpt);
                        tempData.add(Pair.onePair(members, (Object)value));
                    }
                }
                seqMap.clear();
            }
            if (failRpt.get(model.getNumber()) != null) continue;
            Map map = (Map)oneRptData.get("g_data");
            ExcelRptImportHandler.analysisFix(ctx, info, cellSets, warnRpt, spread, filterView, map, allDim, measure, dataUnit, model.getNumber(), failRpt, pageDim);
            if (failRpt.get(model.getNumber()) != null) continue;
            tempData.forEach(d -> {
                String lockDim;
                String[] saveDimNums = ((List)d.p1).toArray(new String[0]);
                boolean islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])saveDimNums, (String)(lockDim = (String)ctx.getCustomParam().get(LOCK_DIM)), (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getYear().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                if (!islock) {
                    cellSets.set(saveDimNums, measure, d.p2);
                }
            });
            successRpt.put(model.getId(), model.getNumber());
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(successRpt)) {
                    List<Long> reportIds = ExcelRptImportHandler.batchSaveNewReportRecords(ctx, successRpt.keySet(), noDimRptDataModels);
                    WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - rptIds: %n %s", reportIds));
                }
                OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)((String)ctx.getModel().p2));
                WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - cellSets:%n %s", cellSets));
                ExcelRptImportHandler.saveExtendBat(successRpt, ctx);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("\u4fdd\u5b58\u5bfc\u5165\u6570\u636e\u65f6\u51fa\u9519\uff01 --- CellSets\uff1a%n %s", cellSets.toString()));
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5bfc\u5165\u6570\u636e\u65f6\u51fa\u9519\u3002", (String)"ExcelRptImportHandler_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\n" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        ExcelRptImportHandler.writeLog(ctx, failRpt, successRpt, warnRpt);
    }

    private static Set<String> getPageDim(TemplateModel model) {
        HashSet<String> pageDim = new HashSet<String>(16);
        for (PageDimensionEntry v : model.getPageDimensionEntries()) {
            pageDim.add(v.getDimension().getNumber());
        }
        return pageDim;
    }

    private static void saveExtendBat(Map<Long, String> successRpt, ExcelRptImportContext ctx) {
        Map<String, Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>>> extendData = ctx.getExtendData();
        for (Map.Entry<Long, String> map : successRpt.entrySet()) {
            Pair<List<Pair<String, List<Long>>>, List<EDSaveComInfo>> data = extendData.get(map.getValue());
            if (data == null) continue;
            ExcelRptImportHandler.saveExtend((List)data.p1, (List)data.p2);
        }
    }

    private static Object getOlapValue(String cellValue, DataTypeEnum dataType, int dataUnit, String col, String tmplNum, Map<String, Object> failRpt) {
        Object value = null;
        if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
            try {
                value = ExcelRptImportHandler.handleDataType(cellValue, dataType, dataUnit);
            }
            catch (Exception e) {
                List failInfos = failRpt.getOrDefault(tmplNum, new ArrayList(2));
                failInfos.add(String.format(ResManager.loadKDString((String)"\u503c'%1$s'\u4e0d\u652f\u6301\u8f6c\u6362\u6210%2$s\u7c7b\u578b\uff0c\u6240\u5c5e\u6570\u636e\u5217\u4e3a%3$s\u3002", (String)"ExcelRptImportHandler_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), cellValue, dataType.getName(), col));
                failRpt.put(tmplNum, failInfos);
            }
        }
        return value;
    }

    private static Object handleDataType(String cellValue, DataTypeEnum dataType, int dataUnit) {
        Object value = null;
        if (DataTypeEnum.TXT == dataType) {
            value = cellValue;
        } else if (DataTypeEnum.CURRENCY == dataType || DataTypeEnum.DEFAULT == dataType) {
            value = BigDecimal.valueOf(Double.parseDouble(cellValue)).multiply(new BigDecimal(10).pow(dataUnit));
        } else if (DataTypeEnum.UNCURRENCY == dataType) {
            value = BigDecimal.valueOf(Double.parseDouble(cellValue));
        } else if (DataTypeEnum.DATETP == dataType) {
            value = ExcelRptImportHandler.getOADate(cellValue);
        } else if (DataTypeEnum.PROPORTION == dataType) {
            value = BigDecimal.valueOf(Double.parseDouble(cellValue));
        }
        return value;
    }

    private static String getOADate(String dateStr) {
        String oaStr;
        try {
            Date date = DateTimeUtils.parseStrDate((String)dateStr);
            oaStr = DateTimeUtils.convertToOADate((Date)date);
        }
        catch (ParseException ex) {
            try {
                Date date = DateTimeUtils.parseStrDate2((String)dateStr);
                oaStr = DateTimeUtils.convertToOADate((Date)date);
            }
            catch (ParseException ex2) {
                try {
                    Date date = DateTimeUtils.parseStrDate3((String)dateStr);
                    oaStr = DateTimeUtils.convertToOADate((Date)date);
                }
                catch (ParseException ex3) {
                    oaStr = dateStr;
                }
            }
        }
        return oaStr;
    }

    private static void setDefaultScope(long modelId, BasePointInnerLineInfo info, List<DynaMembScopeInfo> scope) {
        DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modelId, (String)info.getDimension().getNumber(), (String)info.getDimension().getUqCode());
        DimMember mem = new DimMember(info.getDimension().getName(), info.getDimension().getNumber(), "", info.getDimension());
        mem.setId(member.getLong("id"));
        scope.add(new DynaMembScopeInfo((IDimMember)mem, RangeEnum.VALUE_90.getValue()));
    }

    private static Pair<List<Map<String, String>>, Map<String, Map<String, String>>> checkMembers(ExcelRptImportContext ctx, Map<String, Set<String>> allFloatMembers, Map<String, List<DynaMembScopeInfo>> scopeMap, TemplateModel model, String dynaRange) {
        ArrayList unMappedMember = new ArrayList();
        HashMap mappedMember = new HashMap(16);
        QFBuilder qfBuilder = new QFBuilder();
        QFilter qFilter = new QFilter("model", "=", ctx.getModel().p1);
        HashSet numbers = new HashSet();
        for (Map.Entry<String, Set<String>> entry : allFloatMembers.entrySet()) {
            String dim = entry.getKey();
            Set<String> members = entry.getValue();
            HashMap mappedMemb = new HashMap(16);
            mappedMember.put(dim, mappedMemb);
            List<DynaMembScopeInfo> scopeList = scopeMap.get(dim);
            numbers.clear();
            for (DynaMembScopeInfo scinfo : scopeList) {
                VersionParam param = ExcelRptImportHandler.getVersionParam(dim, ctx, scinfo);
                if (param != null) {
                    new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(scinfo.getMember().getId()), scinfo.getMember().getNumber(), RangeEnum.getRangeByVal((int)scinfo.getRangeId()), scinfo.isCustom(), (Object)model.getModelId()).matchItem4Ic(param, c -> numbers.add(c.number));
                    continue;
                }
                new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(scinfo.getMember().getId()), scinfo.getMember().getNumber(), RangeEnum.getRangeByVal((int)scinfo.getRangeId()), scinfo.isCustom(), (Object)model.getModelId()).matchItems(c -> numbers.add(c.number));
            }
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dim);
            qfBuilder.clear();
            List partition = Lists.partition((List)Lists.newArrayList(members), (int)10000);
            DynamicObjectCollection col2 = new DynamicObjectCollection();
            for (List list : partition) {
                qfBuilder.add("dimension.number", "=", (Object)dim);
                qfBuilder.add("name", "in", (Object)list);
                col2.addAll((Collection)QueryServiceHelper.query((String)entity, (String)"name, number", (QFilter[])qfBuilder.add(qFilter).toArray()));
                qfBuilder.clear();
            }
            HashMap name2Num = new HashMap();
            col2.forEach(d -> {
                if (numbers.contains(d.getString("number"))) {
                    Set v = name2Num.getOrDefault(d.getString("name"), new HashSet());
                    v.add(d.getString("number"));
                    name2Num.put(d.getString("name"), v);
                }
            });
            HashSet unExsitName = new HashSet();
            HashMap exsitName = new HashMap();
            members.forEach(name -> {
                if (name2Num.get(name) != null && ((Set)name2Num.get(name)).size() == 1) {
                    exsitName.put(name, ((Set)name2Num.get(name)).toArray(new String[0])[0]);
                } else {
                    unExsitName.add(name);
                }
            });
            if (!unExsitName.isEmpty()) {
                List partition1 = Lists.partition((List)Lists.newArrayList(unExsitName), (int)10000);
                DynamicObjectCollection col3 = new DynamicObjectCollection();
                for (List list : partition1) {
                    qfBuilder.add("dimension.number", "=", (Object)dim);
                    qfBuilder.add("number", "in", (Object)list);
                    col3.addAll((Collection)QueryServiceHelper.query((String)entity, (String)"number", (QFilter[])qfBuilder.add(qFilter).toArray()));
                    qfBuilder.clear();
                }
                col3.forEach(d -> {
                    if (numbers.contains(d.getString("number"))) {
                        mappedMemb.put(d.getString("number"), d.getString("number"));
                    }
                });
            }
            exsitName.entrySet().forEach(e -> {
                if (numbers.contains(e.getValue())) {
                    mappedMemb.put(e.getKey(), e.getValue());
                }
            });
            for (String member : members) {
                if (mappedMemb.containsKey(member)) continue;
                HashMap<String, String> names = new HashMap<String, String>();
                names.put("name", member);
                names.put("dimnumer", dim);
                names.put("tempnumber", model.getNumber());
                names.put("floatarea", dynaRange);
                unMappedMember.add(names);
            }
        }
        return Pair.onePair(unMappedMember, mappedMember);
    }

    private static VersionParam getVersionParam(String dim, ExcelRptImportContext ctx, DynaMembScopeInfo scinfo) {
        if (!"InternalCompany".equals(dim) || scinfo.isCustom()) {
            return null;
        }
        String number = scinfo.getMember().getNumber();
        if (!"ICEntity".equalsIgnoreCase(number) && !"ICOEntity".equalsIgnoreCase(number)) {
            return null;
        }
        if (ctx.getModel() != null && ctx.getScene() != null && ctx.getYear() != null && ctx.getPeriod() != null) {
            return new VersionParam(((Long)ctx.getModel().p1).longValue(), ((Long)ctx.getScene().p1).longValue(), ((Long)ctx.getYear().p1).longValue(), ((Long)ctx.getPeriod().p1).longValue());
        }
        return null;
    }

    private static void analysisFix(ExcelRptImportContext ctx, SaveCommandInfo info, CellSet cellSets, Map<String, String> warnRpt, SpreadManager spread, Map<String, String> filterView, Map<String, Object> dataAxis, List<String> allDim, String measure, int dataUnit, String tmplNum, Map<String, Object> failRpt, Set<String> pageDim) {
        ArrayList<Pair> tempData = new ArrayList<Pair>();
        for (Map.Entry<String, Object> d2 : dataAxis.entrySet()) {
            String[] index = d2.getKey().split(KEY_SPLIT);
            Cell c = spread.getBook().getSheet(0).getCell(Integer.parseInt(index[0]), Integer.parseInt(index[1]));
            if (!c.isMdDataDomain() || c.getMemberFromUserObject() == null || c.getMemberFromUserObject().isEmpty()) continue;
            HashMap<String, String> crossMap = new HashMap<String, String>();
            c.getMemberFromUserObject().forEach(m -> {
                String dim = m.getDimension().getNumber();
                String member = m.getNumber();
                if (PresetConstant.PERIOD_DIM.equals(dim)) {
                    if ("CurrentPeriod".equals(member)) {
                        member = (String)ctx.getPeriod().p2;
                    } else if ("LastPeriod".equals(member)) {
                        member = (String)ThreadCache.get((Object)("lastperiod_of_" + (String)ctx.getPeriod().p2), () -> PeriodUtils.getLastPeriodElseThrowException((String)((String)ctx.getModel().p2), (String)((String)ctx.getYear().p2), (boolean)false));
                    }
                } else if (PresetConstant.FY_DIM.equals(dim)) {
                    if ("CurrentYear".equals(member)) {
                        member = (String)ctx.getYear().p2;
                    } else if ("LastYear".equals(member)) {
                        member = (String)ThreadCache.get((Object)("lastyear_of_" + (String)ctx.getYear().p2), () -> PeriodUtils.getLastYearElseThrowException((String)((String)ctx.getModel().p2), (String)((String)ctx.getYear().p2)));
                    }
                }
                crossMap.put(dim, member);
            });
            ArrayList<String> members = new ArrayList<String>(allDim.size());
            for (String dim : allDim) {
                String m2 = filterView.getOrDefault(dim, (String)crossMap.get(dim));
                IDNumberTreeNode memb = MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)dim, (String)m2);
                if (!ExcelRptImportHandler.checkCanSave(memb = ExcelRptImportHandler.getAssoStoreMem(ctx, memb, pageDim), dim)) break;
                members.add(memb.getNumber());
            }
            if (members.size() != allDim.size()) continue;
            Map<String, String> dim2Members = ExcelRptImportHandler.getDim2MembersMap(allDim, filterView, crossMap);
            DataTypeEnum dataType = CellDataTypeUtil.getCellDataTypeThreadCache((long)((Long)ctx.getModel().p1), dim2Members, dataTypeMap);
            String cellValue = (String)dataAxis.get(c.getRow() + KEY_SPLIT + c.getCol());
            Object value = ExcelRptImportHandler.getOlapValue(cellValue, dataType, dataUnit, ExcelUtils.int2pos((int)c.getCol()), tmplNum, failRpt);
            tempData.add(Pair.onePair(members, (Object)value));
        }
        if (failRpt.get(tmplNum) == null) {
            tempData.forEach(d -> {
                String lockDim;
                String[] saveDimNums = ((List)d.p1).toArray(new String[0]);
                boolean islock = IntegrationUtil.checkLock((SaveCommandInfo)info, (List)allDim, (String[])saveDimNums, (String)(lockDim = (String)ctx.getCustomParam().get(LOCK_DIM)), (Map)warnRpt, (Long)((Long)ctx.getModel().p1), (String)((String)ctx.getScene().p2), (String)((String)ctx.getOrg().p2), (String)((String)ctx.getYear().p2), (String)((String)ctx.getPeriod().p2), (String)((String)ctx.getCurrency().p2));
                if (!islock) {
                    cellSets.set(saveDimNums, measure, d.p2);
                }
            });
        }
    }

    private static IDNumberTreeNode getAssoStoreMem(ExcelRptImportContext ctx, IDNumberTreeNode memb, Set<String> pageDim) {
        Boolean assoStoreOpen = (Boolean)ctx.getCustomParam().get(ASSO_STORE_OPEN);
        if (assoStoreOpen == null || !assoStoreOpen.booleanValue()) {
            return memb;
        }
        if (pageDim.contains(memb.getDimNumber())) {
            return memb;
        }
        Long assoStoreId = (Long)memb.getProperty("assostoremem");
        if (assoStoreId == null) {
            return memb;
        }
        String entityNumber = MemberReader.getEntityNumberByDim((String)((String)ctx.getModel().p2), (String)memb.getDimNumber());
        IDNumberTreeNode newTreeNode = MemberReader.findMemberById((String)((String)ctx.getModel().p2), (String)entityNumber, (Long)assoStoreId);
        if (PresetConstant.MYCOMPANY_DIM.equals(memb.getDimNumber()) && "$ECur".equals(newTreeNode.getNumber())) {
            return MemberReader.findEntityMemberById((String)((String)ctx.getModel().p2), (Long)((Long)ctx.getOrg().p1));
        }
        return newTreeNode;
    }

    private static Map<String, String> getDim2MembersMap(List<String> allDim, Map<String, String> filterView, Map<String, String> crossMap) {
        HashMap<String, String> dim2Members = new HashMap<String, String>(allDim.size());
        for (String dim : allDim) {
            String m = filterView.getOrDefault(dim, crossMap.get(dim));
            dim2Members.put(dim, m);
        }
        return dim2Members;
    }

    private static String analysisFixSaveNotByDim(SpreadManager spread, Map<String, Object> dataAxis) {
        for (Map.Entry<String, Object> d : dataAxis.entrySet()) {
            String[] index = d.getKey().split(KEY_SPLIT);
            Cell c = spread.getBook().getSheet(0).getCell(Integer.parseInt(index[0]), Integer.parseInt(index[1]));
            c.setValue(dataAxis.get(c.getRow() + KEY_SPLIT + c.getCol()));
        }
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    private static Map<String, List<Long>> getUnweaveRpt(ExcelRptImportContext ctx, Set<Long> successRpt) {
        ArrayList<Long> unweave = new ArrayList<Long>(10);
        ArrayList<Long> weaving = new ArrayList<Long>(10);
        HashMap<String, List<Long>> groupWeave = new HashMap<String, List<Long>>(3);
        groupWeave.put("unweave", unweave);
        groupWeave.put("weaving", weaving);
        for (Long id : successRpt) {
            if (ReportStatusEnum.UNWEAVE.status().equals(ctx.getAll4Import().get(id))) {
                unweave.add(id);
            }
            if (!ReportStatusEnum.WEAVING.status().equals(ctx.getAll4Import().get(id)) && !ReportStatusEnum.BACK.status().equals(ctx.getAll4Import().get(id))) continue;
            weaving.add(id);
        }
        return groupWeave;
    }

    private static Map<String, Object> doloadData(ExcelRptImportContext ctx, Map<String, Object> failRpt) {
        if (ctx.getBook() == null) {
            return new HashMap<String, Object>(2);
        }
        Map<String, Map<Integer, Pair<Integer, Integer>>> floatConfig = ctx.getFloatConfig();
        Map<String, Map<Integer, Pair<Integer, Integer>>> extendConfig = ctx.getExtendConfig();
        Map<String, TemplateModel> templateModelMap = ExcelRptImportHandler.getTemplateModels(ctx);
        Map<String, Object> sheetMappingJson = ExcelRptImportHandler.getSheetMappingJsonByScheme(ctx);
        HashMap<String, Object> allData = new HashMap<String, Object>(3);
        LinkedHashMap<String, LinkedHashMap<String, Object>> fixData = new LinkedHashMap<String, LinkedHashMap<String, Object>>(16);
        LinkedHashMap<String, LinkedHashMap<String, Object>> floatData = new LinkedHashMap<String, LinkedHashMap<String, Object>>(16);
        LinkedHashMap extendData = new LinkedHashMap(16);
        Iterator it = ctx.getBook().sheetIterator();
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            TemplateModel templateModel = templateModelMap.get(sheet.getSheetName());
            if (templateModel == null) continue;
            if (ctx.getAll4Import().get(templateModel.getId()) == null) {
                failRpt.put(templateModel.getNumber(), ResManager.loadKDString((String)"\u4e3a\u975e\u53ef\u7f16\u5236\u72b6\u6001\u6216\u8868\u683c\u6620\u5c04\u7248\u672c\u4e0e\u5f53\u524d\u62a5\u8868\u7248\u672c\u4e0d\u4e00\u81f4", (String)"ExcelRptImportHandler_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                continue;
            }
            boolean isfloat = ExcelRptImportHandler.isFloatTemplate(sheet, templateModelMap);
            boolean isExtend = ExcelRptImportHandler.isExtendTemplate(sheet, templateModelMap);
            Map mappingJson = (Map)JSON.parseObject((String)((String)sheetMappingJson.get(sheet.getSheetName())), HashMap.class);
            List data = (List)mappingJson.get("data");
            LinkedHashMap<String, Object> oneRptData = new LinkedHashMap<String, Object>();
            LinkedHashMap oneExtendData = new LinkedHashMap();
            if (isfloat && isExtend) {
                Set fandeSet = (Set)ctx.getCustomParam().computeIfAbsent("float&extend", e -> new HashSet());
                fandeSet.add(templateModel.getNumber());
            }
            if (isfloat || isExtend) {
                Map<Integer, Pair<Integer, Integer>> fetchRowConfigExtend;
                List areaMark = (List)mappingJson.get("areaMark");
                List extendMark = (List)mappingJson.get("extendMark");
                log.info("ExcelRptImportHandler tmpl and areaMark:" + sheet.getSheetName() + areaMark == null ? "" : (JSONObject.toJSONString((Object)areaMark) + extendMark == null ? "" : JSONObject.toJSONString((Object)extendMark)));
                Pair<Map<Integer, Pair<Integer, Integer>>, Map<Integer, Pair<Integer, Integer>>> pointAllConfig = ExcelRptImportHandler.getPointAllConfig(areaMark, extendMark, sheet);
                Map<Integer, Pair<Integer, Integer>> pointFloatConfig = (Map<Integer, Pair<Integer, Integer>>)pointAllConfig.p1;
                Map<Integer, Pair<Integer, Integer>> map = (Map<Integer, Pair<Integer, Integer>>)pointAllConfig.p2;
                Map<Integer, Pair<Integer, Integer>> fetchRowConfig = pointFloatConfig.size() == 0 ? floatConfig.get(templateModel.getNumber()) : pointFloatConfig;
                Map<Integer, Pair<Integer, Integer>> map2 = fetchRowConfigExtend = map.size() == 0 ? extendConfig.get(templateModel.getNumber()) : map;
                if (CollectionUtils.isEmpty(fetchRowConfig) && CollectionUtils.isEmpty(fetchRowConfigExtend)) continue;
                Integer rowNum = 0;
                Integer lastDataRow = 0;
                Recorder lastMappingRow = new Recorder((Object)0);
                HashMap fData = new HashMap(16);
                HashMap tData = new HashMap(16);
                HashMap<String, Object> gData = new HashMap<String, Object>(16);
                for (Map area : data) {
                    for (Map.Entry a : area.entrySet()) {
                        String preKey = (String)a.getKey();
                        if (preKey.startsWith(F_PRE) || preKey.startsWith(T_PRE)) {
                            Pair<Integer, Integer> start2EndRow = null;
                            if (preKey.startsWith(F_PRE)) {
                                start2EndRow = fetchRowConfig == null ? null : fetchRowConfig.get(Integer.parseInt(preKey.substring(2)));
                            } else if (preKey.startsWith(T_PRE)) {
                                Pair<Integer, Integer> pair = start2EndRow = fetchRowConfigExtend == null ? null : fetchRowConfigExtend.get(Integer.parseInt(preKey.substring(2)));
                            }
                            if (start2EndRow == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u6d6e\u52a8\u533a\u57df\u6570\u91cf\u4e0e\u5bfc\u5165\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelRptImportHandler_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                            }
                            ArrayList<HashMap<String, Object>> floatRowData = new ArrayList<HashMap<String, Object>>((Integer)start2EndRow.p2 - (Integer)start2EndRow.p1);
                            for (int i = ((Integer)start2EndRow.p1).intValue(); i <= (Integer)start2EndRow.p2; ++i) {
                                HashMap<String, Object> oneRowData = new HashMap<String, Object>();
                                int n = i - (Integer)start2EndRow.p1;
                                for (Object cell : (List)a.getValue()) {
                                    Map map22 = (Map)JSON.parseObject((String)JSON.toJSONString(cell), HashMap.class);
                                    for (Map.Entry<String, Object> entry : map22.entrySet()) {
                                        ExcelRptImportHandler.setSingleCellValue(sheet, entry, oneRowData, i, (Recorder<Integer>)lastMappingRow, preKey, n, templateModel.getNumber(), ctx);
                                    }
                                }
                                if (!oneRowData.entrySet().stream().anyMatch(e -> StringUtils.isNotBlank(e.getValue()))) continue;
                                floatRowData.add(oneRowData);
                            }
                            if (preKey.startsWith(F_PRE)) {
                                fData.put(preKey, floatRowData);
                            } else {
                                tData.put(preKey, floatRowData);
                            }
                            lastDataRow = (Integer)start2EndRow.p2;
                        }
                        if (!preKey.startsWith(G_PRE)) continue;
                        rowNum = lastDataRow;
                        for (Object cell : (List)a.getValue()) {
                            Map map3 = (Map)JSON.parseObject((String)JSON.toJSONString(cell), HashMap.class);
                            for (Map.Entry<String, Object> entry : map3.entrySet()) {
                                ExcelRptImportHandler.setSingleCellValue(sheet, entry, gData, rowNum, (Recorder<Integer>)lastMappingRow, preKey, 0, templateModel.getNumber(), ctx);
                            }
                        }
                        lastMappingRow.setRecord((Object)0);
                    }
                }
                oneRptData.put("g_data", gData);
                oneRptData.put("f_data", fData);
                oneExtendData.put("t_data", tData);
                if (gData.size() > 0 || fData.size() > 0) {
                    floatData.put(templateModel.getNumber(), oneRptData);
                }
                if (tData.size() <= 0) continue;
                extendData.put(templateModel.getNumber(), oneExtendData);
                continue;
            }
            for (Object obj : (List)((Map)data.get(0)).get("g_1")) {
                Map map = (Map)JSON.parseObject((String)JSON.toJSONString(obj), HashMap.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    ExcelRptImportHandler.setSingleCellValue(sheet, entry, oneRptData, -1, (Recorder<Integer>)new Recorder((Object)0), null, 0, templateModel.getNumber(), ctx);
                }
            }
            fixData.put(templateModel.getNumber(), oneRptData);
        }
        ctx.setBook(null);
        allData.put("fix", fixData);
        allData.put("float", floatData);
        allData.put("extend", extendData);
        WatchLoggerUtil.debug((WatchLogger)log, (String)String.format("Debug Info - doloadData:%n %s", allData));
        return allData;
    }

    private static Pair<Map<Integer, Pair<Integer, Integer>>, Map<Integer, Pair<Integer, Integer>>> getPointAllConfig(List<Map<String, String>> areaMark, List<Map<String, String>> extendMark, Sheet sheet) {
        ArrayList<Map<String, String>> resList = new ArrayList<Map<String, String>>(16);
        if (!CollectionUtils.isEmpty(areaMark)) {
            resList.addAll(areaMark);
        }
        if (!CollectionUtils.isEmpty(extendMark)) {
            resList.addAll(extendMark);
        }
        HashMap<Integer, Pair<Integer, Integer>> areaMap = new HashMap<Integer, Pair<Integer, Integer>>(16);
        HashMap<Integer, Pair<Integer, Integer>> extendMap = new HashMap<Integer, Pair<Integer, Integer>>(16);
        if (CollectionUtils.isEmpty(resList)) {
            return Pair.onePair(areaMap, extendMap);
        }
        CellMappingHandle.getAreaMarkList(resList);
        Map<Integer, Pair<Integer, Integer>> pointAllConfig = ExcelRptImportHandler.get4PointFloatConfig(sheet, resList);
        if (pointAllConfig.size() == 0) {
            return Pair.onePair(areaMap, extendMap);
        }
        int areaIndex = 1;
        int extendIndex = 1;
        for (int i = 0; i < resList.size(); ++i) {
            if (ExcelRptImportHandler.ContainsMark(areaMark, (Map)resList.get(i))) {
                areaMap.put(areaIndex++, pointAllConfig.get(i + 1));
                continue;
            }
            extendMap.put(extendIndex++, pointAllConfig.get(i + 1));
        }
        return Pair.onePair(areaMap, extendMap);
    }

    private static boolean ContainsMark(List<Map<String, String>> areaMark, Map<String, String> orderMark) {
        if (CollectionUtils.isEmpty(areaMark)) {
            return false;
        }
        for (Map<String, String> mark : areaMark) {
            if (!mark.get("area").equals(orderMark.get("area"))) continue;
            return true;
        }
        return false;
    }

    private static boolean isExtendTemplate(Sheet sheet, Map<String, TemplateModel> templateModelMap) {
        TemplateModel templateModel = templateModelMap.get(sheet.getSheetName());
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)templateModel.getRptData());
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            ExtendInfo extendInfo = e.getExtendInfo();
            if (extendInfo == null) continue;
            return true;
        }
        return false;
    }

    private static Map<Integer, Pair<Integer, Integer>> get4PointFloatConfig(Sheet sheet, List<Map<String, String>> areaMark) {
        HashMap<Integer, Pair<Integer, Integer>> floatConfig = new HashMap<Integer, Pair<Integer, Integer>>(16);
        Recorder currentRow = new Recorder((Object)0);
        Recorder currentAreaSeq = new Recorder((Object)1);
        areaMark.stream().map(e -> (String)e.get("mark")).collect(Collectors.toList()).forEach(config -> {
            String[] split = config.split(";", -1);
            Pair<Integer, Integer> startRow = ExcelRptImportHandler.findRow(sheet, (Integer)currentRow.getRecord(), split[0], split[1], false);
            if (startRow != null) {
                currentRow.setRecord(startRow.p1);
                Pair<Integer, Integer> lastRow = ExcelRptImportHandler.findRow(sheet, (Integer)currentRow.getRecord(), split[2], split[3], true);
                if (lastRow != null) {
                    currentRow.setRecord(lastRow.p1);
                    floatConfig.put((Integer)currentAreaSeq.getRecord(), (Pair<Integer, Integer>)Pair.onePair((Object)((Integer)startRow.p1 + 1), (Object)((Integer)lastRow.p1 - 1)));
                    if ((Integer)lastRow.p1 - (Integer)startRow.p1 < 2) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u533a\u57df\u6807\u8bc6\uff1a\"%2$s\"\uff0c\u6620\u5c04\u6d6e\u52a8\u533a\u57df\u8d77\u59cb\u884c\u4e0e\u7ed3\u675f\u884c\u91cd\u53e0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelRptImportHandler_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), sheet.getSheetName(), config));
                    }
                }
            }
            currentAreaSeq.setRecord((Object)((Integer)currentAreaSeq.getRecord() + 1));
        });
        return floatConfig;
    }

    private static Pair<Integer, Integer> findRow(Sheet sheet, int cur, String p1, String p2, boolean findLast) {
        for (int i = cur; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            boolean start = false;
            boolean end = false;
            for (org.apache.poi.ss.usermodel.Cell cell : row) {
                if (cell.getCellType() != CellType.STRING) continue;
                if (ExcelRptImportHandler.checkStringEquals(cell.getStringCellValue(), p1) && !StringUtil.isEmptyString((String)p1)) {
                    start = true;
                }
                if (start && kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)p2) || start && cell.getStringCellValue().equals(p2)) {
                    end = true;
                }
                if (!start || !end) continue;
                return Pair.onePair((Object)cell.getRowIndex(), (Object)cell.getColumnIndex());
            }
            if (findLast && StringUtils.isEmpty((CharSequence)p1) && StringUtils.isEmpty((CharSequence)p2) && ExcelRptImportHandler.isEmptyRow(row)) {
                return Pair.onePair((Object)(i + 1), (Object)0);
            }
            if (i != sheet.getLastRowNum()) continue;
            return Pair.onePair((Object)(i + 1), (Object)0);
        }
        return null;
    }

    private static boolean checkStringEquals(String a, String b) {
        return BCMStringUtil.remove((String)a).replaceAll("\\s*", "").equals(BCMStringUtil.remove((String)b).replaceAll("\\s*", ""));
    }

    private static boolean isEmptyRow(Row row) {
        for (org.apache.poi.ss.usermodel.Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK || cell.getCellType() == CellType._NONE) continue;
            if (cell.getCellType() != CellType.STRING) {
                return false;
            }
            String cellValue = cell.getStringCellValue().trim().replaceAll("\u3000", "");
            if (!StringUtils.isNotEmpty((CharSequence)cellValue)) continue;
            return false;
        }
        return true;
    }

    private static void setSingleCellValue(Sheet sheet, Map.Entry<String, Object> entry, Map<String, Object> oneRptData, Integer rowNum, Recorder<Integer> lastMappingRow, String pre, int rowindex, String tempNumber, ExcelRptImportContext ctx) {
        String value;
        Object[] cellInfo = entry.getValue() instanceof List ? ((List)entry.getValue()).toArray() : (String[])entry.getValue();
        String[] location = cellInfo[0].toString().split(KEY_SPLIT);
        String key = entry.getKey();
        if (rowNum == -1) {
            value = ExcelRptImportHandler.getCellValue(sheet, Integer.parseInt(location[0]), Integer.parseInt(location[1]));
        } else {
            if (pre.startsWith(G_PRE)) {
                rowNum = rowNum + (Integer.parseInt(location[0]) - (Integer)lastMappingRow.getRecord());
            } else if (pre.startsWith(F_PRE) || pre.startsWith(T_PRE)) {
                lastMappingRow.setRecord((Object)Integer.parseInt(location[0]));
                key = Integer.parseInt(key.split(KEY_SPLIT)[0]) + rowindex + KEY_SPLIT + key.split(KEY_SPLIT)[1];
            }
            value = ExcelRptImportHandler.getCellValue(sheet, rowNum, Integer.parseInt(location[1]));
        }
        if (value != null) {
            oneRptData.put(key, value);
            ctx.getCell2cell().put(tempNumber + key + pre, rowNum + 1 + KEY_SPLIT + (Integer.parseInt(location[1]) + 1));
        }
    }

    private static String getCellValue(Sheet sheet, int row, int col) {
        if (sheet.getRow(row) == null || sheet.getRow(row).getCell(col) == null) {
            return null;
        }
        return ExcelRptImportHandler.getCellValueByCell((CellBase)sheet.getRow(row).getCell(col));
    }

    public static String getCellValueByCell(CellBase cell) {
        if (cell == null || "".equals(cell.toString().trim())) {
            return "";
        }
        String cellValue = "";
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((org.apache.poi.ss.usermodel.Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    sdf = format == 20 || format == 32 ? new SimpleDateFormat("HH:mm") : (format == 14 || format == 31 || format == 57 || format == 58 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new KDBizException("exception on get date data !".concat(e.toString()));
                    }
                }
                BigDecimal bd = new BigDecimal(String.valueOf(cell.getNumericCellValue()));
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (CellType.NUMERIC == cachedFormulaResultType) {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                if (CellType.STRING != cachedFormulaResultType) break;
                cellValue = cell.getStringCellValue();
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "ERROR VALUE";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    private static int getDataUnit(int rptdataunit, ImportDataUnitEnum dataUnitEnum) {
        return dataUnitEnum == ImportDataUnitEnum.DEFUALT ? 0 : rptdataunit;
    }

    private static void writeLog(ExcelRptImportContext ctx, Map<String, Object> failRpt, Map<Long, String> successRpt, Map<String, String> warnRpt) {
        DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
        dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyObj.set("model", ctx.getModel().p1);
        dyObj.set("fy", ctx.getYear().p1);
        dyObj.set("period", ctx.getPeriod().p1);
        dyObj.set("scenario", ctx.getScene().p1);
        dyObj.set("currency", ctx.getSelectCurrecny().p1);
        dyObj.set("org", ctx.getOrg().p1);
        dyObj.set("scheme", (Object)ctx.getScheme());
        dyObj.set("dimmembers", (Object)"");
        dyObj.set("datafrom", null);
        if (failRpt.size() > 0 && successRpt.size() == 0) {
            dyObj.set("error", (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\uff1a%s\u3002", (String)"ExcelRptImportHandler_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), JSON.toJSONString(failRpt)));
            dyObj.set("collectorstate", (Object)CollectStatusEnum.FAIL.getValue());
        } else if (failRpt.size() > 0 && successRpt.size() > 0) {
            dyObj.set("error", (Object)String.format(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f\uff0c\u7f16\u7801\u5982\u4e0b\uff1a%1$s\u3002\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\uff1a%2$s\u3002", (String)"ExcelRptImportHandler_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", successRpt.values()), String.join((CharSequence)",", JSON.toJSONString(failRpt))));
            dyObj.set("collectorstate", (Object)CollectStatusEnum.SUCCESS.getValue());
        } else {
            dyObj.set("error", (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff0c\u7f16\u7801\u5982\u4e0b\uff1a%s\u3002", (String)"ExcelRptImportHandler_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", successRpt.values())));
            dyObj.set("collectorstate", (Object)CollectStatusEnum.SUCCESS.getValue());
        }
        if (warnRpt.size() > 0) {
            String error = dyObj.getString("error");
            Map msgMap = IntegrationUtil.getMsgMap(warnRpt);
            error = error + String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6210\u5458\u56e0\u9501\u5b9a\u672a\u6210\u529f\u5165\u5e93:%1$s;", (String)"ExcelRptImportHandler_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), JSONObject.toJSONString((Object)msgMap));
            dyObj.set("error", (Object)error);
        }
        dyObj.set("collector", (Object)ctx.getUserId());
        dyObj.set("collecttime", (Object)TimeServiceHelper.now());
        dyObj.set("executerec", null);
        Long spend = new Date().getTime() - ctx.getStartTime();
        StringBuilder sb = IntegrationNewServiceHelper.calculate((Long)spend);
        dyObj.set("spend", (Object)sb.toString());
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj}, (OperateOption)op);
    }

    private static boolean isFloatTemplate(Sheet sheet, Map<String, TemplateModel> templateModelMap) {
        int type = templateModelMap.get(sheet.getSheetName()).getTemplateType();
        if (TemplateTypeEnum.FIX.getType() == type) {
            return false;
        }
        return TemplateTypeEnum.DYNA.getType() == type;
    }

    private static Map<String, TemplateModel> getTemplateModels(ExcelRptImportContext ctx) {
        HashMap<String, TemplateModel> templateModelMap = new HashMap<String, TemplateModel>();
        HashMap<String, TemplateModel> templateModelMap4CTX = new HashMap<String, TemplateModel>();
        HashSet<String> sheetNames = new HashSet<String>(ctx.getBook().getNumberOfSheets());
        Iterator it = ctx.getBook().sheetIterator();
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            sheetNames.add(sheet.getSheetName());
        }
        QFBuilder qfSheet = new QFBuilder("scheme", "=", (Object)ctx.getScheme());
        qfSheet.add("sheetname", "in", sheetNames);
        qfSheet.add("mappingstatus", "=", (Object)"1");
        qfSheet.add("effectstatus", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,template,template.number", (QFilter[])qfSheet.toArray());
        Set templateIds = dyns.stream().map(temp -> temp.getLong("template")).collect(Collectors.toSet());
        Long modelId = (Long)ctx.getModel().p1;
        Long yearId = (Long)ctx.getYear().p1;
        Long periodId = (Long)ctx.getPeriod().p1;
        Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, templateIds);
        qfSheet.add("template", "in", id2Right.values());
        dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,template,template.number", (QFilter[])qfSheet.toArray());
        dyns.forEach(dyn -> {
            TemplateModel tmplModel = TemplateServiceHelper.getTemplateModelById((Object)dyn.getLong("template"));
            templateModelMap.put(dyn.getString("sheetname"), tmplModel);
            templateModelMap4CTX.put(dyn.getString("template.number"), tmplModel);
        });
        if (templateModelMap.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u8868\u683c\u6620\u5c04\u3002", (String)"ExcelRptImportHandler_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        ctx.setTemplateModelMap(templateModelMap4CTX);
        return templateModelMap;
    }

    private static Map<String, Object> getSheetMappingJsonByScheme(ExcelRptImportContext ctx) {
        QFBuilder qfSheet = new QFBuilder("scheme", "=", (Object)ctx.getScheme());
        qfSheet.add("mappingstatus", "=", (Object)"1");
        qfSheet.add("effectstatus", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,template", (QFilter[])qfSheet.toArray());
        Set templateIds = dyns.stream().map(temp -> temp.getLong("template")).collect(Collectors.toSet());
        Long modelId = (Long)ctx.getModel().p1;
        Long yearId = (Long)ctx.getYear().p1;
        Long periodId = (Long)ctx.getPeriod().p1;
        Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, templateIds);
        qfSheet.add("template", "in", id2Right.values());
        dyns = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,template", (QFilter[])qfSheet.toArray());
        Map<Long, String> sheetMapping = dyns.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("sheetname")));
        QFBuilder qfCell = new QFBuilder("sheetmappingid", "in", sheetMapping.keySet());
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"bcm_iscellmappingdata", (String)"sheetmappingid,mappingjson", (QFilter[])qfCell.toArray());
        HashMap<String, Object> result = new HashMap<String, Object>(datas.size());
        datas.forEach(data -> result.put((String)sheetMapping.get(data.getLong("sheetmappingid")), data.get("mappingjson")));
        return result;
    }

    private static Map<String, String> getFilterView(ExcelRptImportContext ctx, TemplateModel template, boolean isExtend) {
        HashMap<String, String> filterView = new HashMap<String, String>(16);
        for (ViewPointDimensionEntry v2 : template.getViewPointDimensionEntries()) {
            filterView.put(v2.getDimension().getNumber(), v2.getMember().getNumber());
        }
        for (ViewPointDimensionEntry v2 : template.getPageDimensionEntries()) {
            String dim = v2.getDimension().getNumber();
            String member = PresetConstant.SCENE_DIM.equals(dim) ? (String)ctx.getScene().p2 : (PresetConstant.FY_DIM.equals(dim) ? (String)ctx.getYear().p2 : (PresetConstant.PERIOD_DIM.equals(dim) ? (String)ctx.getPeriod().p2 : (PresetConstant.CURRENCY_DIM.equals(dim) ? (String)ctx.getCurrency().p2 : (PresetConstant.ENTITY_DIM.equals(dim) ? (String)ctx.getOrg().p2 : (PresetConstant.PROCESS_DIM.equals(dim) ? ((Boolean)ctx.getOrg().p3 != false ? "EIRpt" : "CSTE") : (PresetConstant.AUDITTRIAL_DIM.equals(dim) ? "EntityInput" : null))))));
            filterView.put(dim, member);
        }
        if (ctx.getDefaultMembers() != null) {
            Map<String, String> defaultMembers = ctx.getDefaultMembers().get(template.getNumber());
            defaultMembers.forEach(filterView::put);
        }
        filterView.put(PresetConstant.PROCESS_DIM, (Boolean)ctx.getOrg().p3 != false ? "EIRpt" : "CSTE");
        filterView.put(PresetConstant.CURRENCY_DIM, (String)ctx.getCurrency().p2);
        StringBuilder sb = new StringBuilder();
        StringBuilder xtendSb = new StringBuilder();
        filterView.forEach((k, v) -> {
            if (v == null) {
                if (isExtend && (PresetConstant.CURRENCY_DIM.equals(k) || PresetConstant.PROCESS_DIM.equals(k) || PresetConstant.AUDITTRIAL_DIM.equals(k))) {
                    xtendSb.append((String)k).append(";");
                }
                sb.append((String)k).append(";");
            }
        });
        if (isExtend) {
            if (xtendSb.length() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u7f3a\u5c11\u6307\u5b9a\u503c", (String)"ExcelRptImportHandler_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), xtendSb));
            }
        } else if (template.isSaveByDim() && sb.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u7f3a\u5c11\u6307\u5b9a\u503c", (String)"ExcelRptImportHandler_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), sb));
        }
        return filterView;
    }

    private static Map<String, Map<String, String>> getTemplateDimMap(ExcelRptImportContext ctx) {
        HashMap<String, Map<String, String>> templateDim = new HashMap<String, Map<String, String>>(16);
        Long scheme = ctx.getScheme();
        QFilter schemeQF = scheme != null ? new QFilter("scheme", "=", (Object)scheme) : null;
        DynamicObjectCollection isSheetMapObjs = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id, template.id,template.number", (QFilter[])new QFilter[]{schemeQF});
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (DynamicObject sheetMapObj : isSheetMapObjs) {
            templateIds.add(sheetMapObj.getLong("template.id"));
        }
        Long modelId = (Long)ctx.getModel().p1;
        Long yearId = (Long)ctx.getYear().p1;
        Long periodId = (Long)ctx.getPeriod().p1;
        Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, templateIds);
        QFilter templateQF = new QFilter("template", "in", id2Right.values());
        DynamicObjectCollection pageDims = QueryServiceHelper.query((String)"bcm_isspagedimselect", (String)"id, dimension,dimension.number, memnumber, template.id", (QFilter[])new QFilter[]{schemeQF, templateQF});
        isSheetMapObjs = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id, template.id,template.number", (QFilter[])new QFilter[]{schemeQF, templateQF});
        for (DynamicObject sheetMapObj : isSheetMapObjs) {
            HashMap<String, String> dimMem = new HashMap<String, String>(16);
            for (DynamicObject pageDim : pageDims) {
                long templateId = pageDim.getLong("template.id");
                if (templateId != sheetMapObj.getLong("template.id")) continue;
                dimMem.put(pageDim.getString("dimension.number"), pageDim.getString("memnumber"));
            }
            templateDim.put(sheetMapObj.getString("template.number"), dimMem);
        }
        return templateDim;
    }

    private static List<Long> batchSaveNewReportRecords(ExcelRptImportContext ctx, Set<Long> templateIds, Map<Long, String> noDimRptDataModels) {
        Map<String, List<Long>> groupWeave = ExcelRptImportHandler.getUnweaveRpt(ctx, templateIds);
        if (!groupWeave.get("unweave").isEmpty()) {
            ReportRecordUtil.batchSaveNewReportRecords(groupWeave.get("unweave"), ctx.getModel().p1, ctx.getCurrency().p1, ctx.getOrg().p1, ctx.getScene().p1, ctx.getYear().p1, ctx.getPeriod().p1, ReportStatusEnum.WEAVING, false, ctx.getUserId());
            groupWeave.get("weaving").addAll((Collection<Long>)groupWeave.get("unweave"));
        }
        ArrayList<Long> reportIds = new ArrayList<Long>(10);
        Date now = TimeServiceHelper.now();
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        if (!groupWeave.get("weaving").isEmpty()) {
            DynamicObject[] weavingRecords;
            QFBuilder qf = new QFBuilder("model", "=", ctx.getModel().p1);
            qf.add("entity", "=", ctx.getOrg().p1);
            qf.add("fyear", "=", ctx.getYear().p1);
            qf.add("period", "=", ctx.getPeriod().p1);
            qf.add("currency", "=", ctx.getCurrency().p1);
            qf.add("template", "in", groupWeave.get("weaving"));
            for (DynamicObject d : weavingRecords = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"id,template.id,modifier,modifytime,reportstatus,data,spreadjson", (QFilter[])qf.toArray())) {
                d.set("modifier", (Object)ctx.getUserId());
                d.set("modifytime", (Object)now);
                d.set("reportstatus", (Object)ReportStatusEnum.WEAVING.status());
                TemplateModel templateModel = ModelDataProvider.getTemplateModel(d.getLong("template.id"));
                String spreadJson = templateModel.getRptSpreadJson();
                if (noDimRptDataModels.get(d.getLong("template.id")) != null) {
                    d.set("data", (Object)noDimRptDataModels.get(d.getLong("template.id")));
                } else {
                    d.set("data", (Object)templateModel.getRptData());
                }
                d.set("spreadjson", (Object)spreadJson);
                reportIds.add(d.getLong("id"));
            }
            SaveServiceHelper.update((DynamicObject[])weavingRecords, (OperateOption)op);
        }
        return reportIds;
    }

    private static boolean checkCanSave(IDNumberTreeNode node, String dim) {
        if (node.getStorageType() == StorageTypeEnum.LABEL || node.getStorageType() == StorageTypeEnum.DYNAMIC) {
            return false;
        }
        return PresetConstant.ENTITY_DIM.equals(dim) || node.isLeaf() || node.getStorageType() == StorageTypeEnum.STORAGE;
    }
}

