/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportTask;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.FileInfo;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.formplugin.report.export.SpreadJSExportModel;
import kd.fi.bcm.formplugin.report.export.TempReportInfo;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;

public class ExportGCExcelCache {
    protected String excelfiletype;
    protected TempReportInfo tempReportInfo;
    protected List<String> rNumbers = new ArrayList<String>(16);
    public ExportPageSourceEnum pageSourceEnum;
    protected List<FYPeriodPair> fyPeriodPairs;
    protected Table<String, Long, Long> srcTmp2RightId = HashBasedTable.create();
    protected String sourcestyle = "1";
    protected boolean hasTopSort = false;
    protected String floatdispay = "1";
    protected Map<String, SpreadJSExportModel> cacheRptTmpJSURL = new ConcurrentHashMap<String, SpreadJSExportModel>(16);
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportMultiExportTask.class);

    public static ExportGCExcelCache getExportGCExcelCache(NewReportMultiExportService service) {
        ExportGCExcelCache cache = new ExportGCExcelCache();
        cache.excelfiletype = service.getExcelfiletype();
        cache.tempReportInfo = service.getTempReportInfo();
        cache.rNumbers = service.getrNumbers();
        cache.pageSourceEnum = service.getPageSourceEnum();
        cache.fyPeriodPairs = service.getFyPeriodPairs();
        cache.srcTmp2RightId = service.getSrcTmp2RightId();
        cache.sourcestyle = service.getSourcestyle();
        cache.floatdispay = service.getFloatdispay();
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGCExcel() {
        for (ReportExportInfo reportExportInfo : this.tempReportInfo.getExportInfos()) {
            if (reportExportInfo.getUnWeavingSize() == 0 && reportExportInfo.getWeavingSize() == 0) continue;
            FileInfo fileInfo = new FileInfo(null, 0);
            fileInfo.setReportDataType(reportExportInfo.getReportDataType());
            List<String> numSeqListSort = this.sortTemplateSeqByNumber(this.tempReportInfo.getAllTemps(), reportExportInfo);
            block5: for (String str : numSeqListSort) {
                for (DynamicObject obj : this.tempReportInfo.getAllTemps().values()) {
                    if (!obj.getString("number").equals(str)) continue;
                    fileInfo.getNumSeqList().add(obj.getString("number"));
                    continue block5;
                }
            }
            int sum = reportExportInfo.getUnweavings().size() + reportExportInfo.getWeavings().size();
            CountDownLatch latch = new CountDownLatch(sum);
            for (String number : "2".equals(this.excelfiletype) ? this.tempReportInfo.getOrgIds() : ("1".equals(this.excelfiletype) ? this.tempReportInfo.getOrgIds() : fileInfo.getNumSeqList())) {
                ThreadPoolService.runInReportExportThread(() -> {
                    String tempid;
                    ReportMultiExportService.KeyParamProvider keyProvider;
                    if (reportExportInfo.getUnweavings() != null) {
                        for (String string : reportExportInfo.getUnweavings()) {
                            keyProvider = new ReportMultiExportService.KeyParamProvider(string);
                            tempid = keyProvider.getTempId();
                            long orgid = Long.parseLong(keyProvider.getOrgId());
                            DynamicObject tempDy = this.tempReportInfo.getAllTemps().get(Long.valueOf(tempid));
                            FYPeriodPair currenctfp = this.getFyPeriodPair(this.fyPeriodPairs, this.tempReportInfo, fileInfo, number, keyProvider.getStrs(), tempDy);
                            if (currenctfp == null) {
                                latch.countDown();
                                continue;
                            }
                            Long l = (Long)this.srcTmp2RightId.get((Object)currenctfp.getKey(), (Object)Long.valueOf(tempid));
                            if (l == null) {
                                if (this.srcTmp2RightId.row((Object)currenctfp.getKey()).containsValue(Long.valueOf(tempid))) {
                                    l = Long.valueOf(tempid);
                                } else {
                                    latch.countDown();
                                    continue;
                                }
                            }
                            if (this.cacheRptTmpJSURL.containsKey(l + "")) {
                                latch.countDown();
                                continue;
                            }
                            TemplateModel temp = ModelDataProvider.getTemplateModel(l);
                            String spreadjson = temp.getRptSpreadJson().substring(6);
                            SpreadJSExportModel jsExportModel = SpreadJSExportModel.getJSExportModel(l, l, spreadjson);
                            if (jsExportModel != null) {
                                this.cacheRptTmpJSURL.put(jsExportModel.rptId + "", jsExportModel);
                            }
                            latch.countDown();
                        }
                    }
                    if (reportExportInfo.getWeavings() != null) {
                        for (Map.Entry entry : reportExportInfo.getWeavings().entrySet()) {
                            DynamicObject currentreport;
                            keyProvider = new ReportMultiExportService.KeyParamProvider((String)entry.getKey());
                            tempid = keyProvider.getTempId();
                            DynamicObject tempDy = this.tempReportInfo.getAllTemps().get(Long.valueOf(tempid));
                            FYPeriodPair currenctfp = this.getFyPeriodPair(this.fyPeriodPairs, this.tempReportInfo, fileInfo, number, keyProvider.getStrs(), tempDy);
                            if (currenctfp == null) {
                                latch.countDown();
                                continue;
                            }
                            Long l = (Long)this.srcTmp2RightId.get((Object)currenctfp.getKey(), (Object)Long.valueOf(tempid));
                            if (l == null) {
                                if (this.srcTmp2RightId.row((Object)currenctfp.getKey()).containsValue(Long.valueOf(tempid))) {
                                    l = Long.valueOf(tempid);
                                } else {
                                    latch.countDown();
                                    continue;
                                }
                            }
                            TemplateModel temp = ModelDataProvider.getTemplateModel(l);
                            DynamicObject report = currentreport = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)entry.getValue()).getLong("id"), (String)"bcm_reportentity", (String)"id,spreadjson,data,modifytime");
                            if (!"1".equals(this.sourcestyle)) {
                                report = null;
                            }
                            if (this.cacheRptTmpJSURL.containsKey(report != null ? report.getString("id") : temp.getId() + "")) {
                                latch.countDown();
                                continue;
                            }
                            try {
                                String reportSpreadjson = report != null ? report.getString("spreadjson") : temp.getRptSpreadJson();
                                boolean isTran2Temp = false;
                                if (StringUtils.isEmpty((String)reportSpreadjson) || this.hasTopSort || !this.floatdispay.equals("3")) {
                                    reportSpreadjson = temp.getRptSpreadJson();
                                    isTran2Temp = true;
                                }
                                String spreadjson = reportSpreadjson.substring(6);
                                SpreadJSExportModel jsExportModel = SpreadJSExportModel.getJSExportModel(report != null ? report.getLong("id") : temp.getId(), l, spreadjson);
                                if (jsExportModel != null) {
                                    this.cacheRptTmpJSURL.put(isTran2Temp ? jsExportModel.tmpId + "" : jsExportModel.rptId + "", jsExportModel);
                                }
                                latch.countDown();
                            }
                            catch (Exception e) {
                                latch.countDown();
                                log.error((Throwable)e);
                            }
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                log.warn(this.getClass().toString() + e);
            }
        }
    }

    public List<String> sortTemplateSeqByNumber(Map<Object, DynamicObject> allTemps, ReportExportInfo pair) {
        DynamicObject temp;
        String tempid;
        String[] strs;
        ArrayList<DynamicObject> templs = new ArrayList<DynamicObject>();
        if (pair.getUnweavings() != null) {
            for (String string : pair.getUnweavings()) {
                strs = string.split("\\|");
                tempid = strs[3];
                temp = allTemps.get(Long.valueOf(tempid));
                templs.add(temp);
            }
        }
        if (pair.getWeavings() != null) {
            for (Map.Entry entry : pair.getWeavings().entrySet()) {
                strs = ((String)entry.getKey()).split("\\|");
                tempid = strs[3];
                temp = allTemps.get(Long.valueOf(tempid));
                templs.add(temp);
            }
        }
        List<String> numSeqList = this.rNumbers.isEmpty() ? templs.stream().sorted(Comparator.comparing(t -> t.getInt("sequence"))).map(t -> t.getString("number")).collect(Collectors.toList()) : this.rNumbers;
        return numSeqList;
    }

    protected FYPeriodPair getFyPeriodPair(List<FYPeriodPair> fyPeriodPairs, TempReportInfo tempReportInfo, FileInfo fileInfo, String number, String[] strs, DynamicObject temp) {
        int index = this.pageSourceEnum.getIndex();
        if (!(index != ExportPageSourceEnum.DEFAULT.getIndex() && index != ExportPageSourceEnum.RPA.getIndex() || this.isAllocaTpl(Long.parseLong(strs[2]), temp.getString("id"), tempReportInfo.getAllocaMap()))) {
            return null;
        }
        String tempNum = temp.getString("number");
        if ("0".equals(this.excelfiletype) ? !tempNum.equals(number) : !String.valueOf(strs[2]).equals(number)) {
            return null;
        }
        fileInfo.getNum2IndexCounts().putIfAbsent(number, 0);
        FYPeriodPair currenctfp = null;
        for (FYPeriodPair fyPeriodPair : fyPeriodPairs) {
            if (!fyPeriodPair.getKey().equals(strs[0] + "|" + strs[1])) continue;
            currenctfp = fyPeriodPair;
            break;
        }
        return currenctfp;
    }

    public boolean isAllocaTpl(Long orgId, String tempId, Map<Long, Set<Long>> map) {
        Set<Long> orgIds = map.get(Long.valueOf(tempId));
        if (orgIds != null && !orgIds.isEmpty()) {
            return orgIds.contains(orgId);
        }
        return false;
    }

    public Map<String, SpreadJSExportModel> getCacheRptTmpJSURL() {
        return this.cacheRptTmpJSURL;
    }
}

