/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatLogicImpl;

public class FixRangeAdjustService
implements Serializable {
    private List<AutoFloatLogicImpl.FloatArea> floatAreas;
    private String key;

    public FixRangeAdjustService(List<AutoFloatLogicImpl.FloatArea> floatArea) {
        this.floatAreas = floatArea;
        this.key = this.floatAreas.get(0).isCol() ? "col" : "row";
    }

    public void doAdjust(Object spansObj) {
        if (spansObj != null) {
            JSONArray spans = (JSONArray)spansObj;
            int dynaFloatSize = 0;
            int dynaDelSize = 0;
            LinkedHashMap<String, JSONObject> hash2Span = new LinkedHashMap<String, JSONObject>(16);
            for (Object span : spans) {
                JSONObject spanJObj = (JSONObject)span;
                int row = spanJObj.getInteger("row");
                int rowCount = spanJObj.getInteger("rowCount");
                int col = spanJObj.getInteger("col");
                int colCount = spanJObj.getInteger("colCount");
                String copyRowJson = spanJObj.toJSONString();
                JSONObject value = JSONObject.parseObject((String)copyRowJson, (Feature[])new Feature[]{Feature.OrderedField});
                hash2Span.put(row + "@" + rowCount + "@" + col + "@" + colCount, value);
            }
            for (AutoFloatLogicImpl.FloatArea floatArea : this.floatAreas) {
                int fixRangeDelSize = floatArea.getDeledata().size();
                int fixRangeAdjSize = floatArea.getRowMapSize();
                for (Object span : spans) {
                    JSONObject spanJObj = (JSONObject)span;
                    int row = spanJObj.getInteger(this.key);
                    int rowCount = spanJObj.getInteger(this.key + "Count");
                    int startIndex = floatArea.getOriginalStartIndex_report() - dynaFloatSize + dynaDelSize;
                    int endIndex = floatArea.getOriginalendIndex_report() - dynaFloatSize + dynaDelSize;
                    boolean isOriInMerge = row <= startIndex && row + rowCount - 1 >= endIndex || row >= startIndex && row + rowCount - 1 <= endIndex;
                    boolean isOriAfterMerge = row > startIndex && row + rowCount - 1 > endIndex;
                    int row1 = spanJObj.getInteger("row");
                    int rowCount1 = spanJObj.getInteger("rowCount");
                    int col = spanJObj.getInteger("col");
                    int colCount = spanJObj.getInteger("colCount");
                    JSONObject newSpan = (JSONObject)hash2Span.get(row1 + "@" + rowCount1 + "@" + col + "@" + colCount);
                    int newRow = newSpan.getInteger(this.key);
                    int newRowCount = newSpan.getInteger(this.key + "Count");
                    if (isOriInMerge) {
                        if (rowCount > 1) {
                            newSpan.put(this.key + "Count", (Object)(newRowCount + fixRangeAdjSize - fixRangeDelSize));
                            continue;
                        }
                        newSpan.put(this.key, (Object)(newRow + fixRangeAdjSize - fixRangeDelSize));
                        continue;
                    }
                    if (!isOriAfterMerge) continue;
                    if (rowCount > 1) {
                        newSpan.put(this.key, (Object)(newRow + fixRangeAdjSize - fixRangeDelSize));
                        newSpan.put(this.key + "Count", (Object)newRowCount);
                        continue;
                    }
                    newSpan.put(this.key, (Object)(newRow + fixRangeAdjSize - fixRangeDelSize));
                }
                dynaFloatSize += fixRangeAdjSize;
                dynaDelSize += fixRangeDelSize;
            }
            spans.clear();
            for (AutoFloatLogicImpl.FloatArea value : hash2Span.values()) {
                spans.add((Object)value);
            }
        }
    }
}

