/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class JqExportXMLOperator {
    private static Document initDocument(String url) {
        Document document;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream ins = fileService.getInputStream(url);){
            SAXReader reader = new SAXReader();
            document = reader.read(ins);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return document;
    }

    public static Map<String, Element> getReportElement(String url) {
        Document document = JqExportXMLOperator.initDocument(url);
        Element root = document.getRootElement();
        Iterator reportIterator = root.elementIterator("report");
        HashMap<String, Element> result = new HashMap<String, Element>(16);
        while (reportIterator.hasNext()) {
            Element report = (Element)reportIterator.next();
            String num = report.attributeValue("code");
            result.put(num.toLowerCase(Locale.ENGLISH), report);
        }
        Iterator unitcatIterator = root.elementIterator("unitcat");
        while (unitcatIterator.hasNext()) {
            Element unitcat = (Element)unitcatIterator.next();
            String num = unitcat.attributeValue("code");
            result.put(num.toLowerCase(Locale.ENGLISH), unitcat);
        }
        return result;
    }

    public static File createXML(String url, String xmlFileName, Map<String, Map<String, String>> exportFileInfo) {
        File file = new File(FilenameUtils.getName((String)xmlFileName));
        Document document = JqExportXMLOperator.initDocument(url);
        Element root = document.getRootElement();
        Iterator reportIterator = root.elementIterator("report");
        while (reportIterator.hasNext()) {
            String tableCode;
            Element report = (Element)reportIterator.next();
            String reportCode = report.attributeValue("code");
            if (!exportFileInfo.containsKey(reportCode)) continue;
            Map<String, String> table2FileMap = exportFileInfo.get(reportCode);
            Element baseTable = report.element("basetable");
            if (baseTable != null && table2FileMap.containsKey(tableCode = baseTable.attributeValue("code"))) {
                baseTable.setAttributeValue("datafile", table2FileMap.get(tableCode));
            }
            Iterator subTableIterator = report.elementIterator("subtable");
            while (subTableIterator.hasNext()) {
                Element subTable = (Element)subTableIterator.next();
                String tableCode2 = subTable.attributeValue("code");
                if (!table2FileMap.containsKey(tableCode2)) continue;
                subTable.setAttributeValue("datafile", table2FileMap.get(tableCode2));
            }
        }
        Iterator unitcatIterator = root.elementIterator("unitcat");
        while (unitcatIterator.hasNext()) {
            Map<String, String> table2FileMap;
            Element unitcat = (Element)unitcatIterator.next();
            String unitcatCode = unitcat.attributeValue("code");
            if (!exportFileInfo.containsKey(unitcatCode) || !(table2FileMap = exportFileInfo.get(unitcatCode)).containsKey(unitcatCode)) continue;
            unitcat.setAttributeValue("datafile", table2FileMap.get(unitcatCode));
        }
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setEncoding("GBK");
        XMLWriter writer = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            writer = new XMLWriter((OutputStream)out, outputFormat);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }
}

