/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.report.export.FileInfo;

public class ReportExportInfo
implements Serializable {
    public static final String b_props = "id,spreadjson,data";
    private List<String> unweavings;
    private Map<String, DynamicObject> weavings;
    private String cacheDataSetId;
    private CachedDataSet dataSet;
    private int maxInMemory = 20;
    private String reportDataType;
    private List<FilterDomainAnalyier> filterAnalyiers = new ArrayList<FilterDomainAnalyier>(16);
    private List<FilterDomainAnalyier> pageFilterAnalyiers = new ArrayList<FilterDomainAnalyier>(16);
    private int sheetSize;

    public ReportExportInfo(List<String> unweavings, Map<String, DynamicObject> weavings, FileInfo fileInfo) {
        this.unweavings = unweavings;
        this.weavings = weavings;
    }

    public ReportExportInfo(List<String> unweavings, Map<String, DynamicObject> weavings) {
        this.unweavings = unweavings;
        this.weavings = weavings;
    }

    public ReportExportInfo(List<String> unweavings, Map<String, DynamicObject> weavings, List<FilterDomainAnalyier> filterAnalyiers) {
        this.unweavings = unweavings;
        this.weavings = weavings;
        this.filterAnalyiers = filterAnalyiers;
        this.sheetSize = this.getWeavingSize() + this.getUnWeavingSize() + this.getFilterSheetSize() + this.getPageFilterSheetSize() - this.filterAnalyiers.size() - this.pageFilterAnalyiers.size();
    }

    public int getSheetSize() {
        return this.sheetSize;
    }

    private int getFilterSheetSize() {
        int filterSheetSize = 0;
        for (FilterDomainAnalyier filterAnalyier : this.filterAnalyiers) {
            int reportSheetSize = 1;
            for (List<JSONObject> fitler : filterAnalyier.fitlers) {
                reportSheetSize *= fitler.size();
            }
            filterSheetSize += reportSheetSize;
        }
        return filterSheetSize;
    }

    private int getPageFilterSheetSize() {
        int pageFilterSheetSize = 0;
        for (FilterDomainAnalyier filterAnalyier : this.pageFilterAnalyiers) {
            int reportSheetSize = 1;
            for (List<JSONObject> fitler : filterAnalyier.fitlers) {
                reportSheetSize *= fitler.size();
            }
            pageFilterSheetSize += reportSheetSize;
        }
        return pageFilterSheetSize;
    }

    public final void initSpreadJSAndModel() {
        if (this.weavings == null || this.weavings.isEmpty()) {
            return;
        }
        List ids = this.weavings.values().stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bcm_exportQueryReport", (String)"bcm_reportentity", (String)b_props, (QFilter[])new QFilter[]{filter}, (String)"id");){
            CacheHint cacheHint = new CacheHint();
            this.cacheDataSetId = dataSet.cache(cacheHint).getCacheId();
        }
    }

    public DynamicObject getBReport(long id) {
        this.dataSet = Algo.getCacheDataSet((String)this.cacheDataSetId);
        int rowCount = this.dataSet.getRowCount();
        int index = 0;
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity");
        report.set("id", (Object)id);
        do {
            Iterator it = this.dataSet.iterator(index, index + this.maxInMemory);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                if (id != row.getLong("id")) continue;
                report.set("spreadjson", (Object)row.getString("spreadjson"));
                report.set("data", (Object)row.getString("data"));
                return report;
            }
        } while ((index += this.maxInMemory) + this.maxInMemory < rowCount);
        return report;
    }

    public int getUnWeavingSize() {
        return this.unweavings == null ? 0 : this.unweavings.size();
    }

    public int getWeavingSize() {
        return this.weavings == null ? 0 : this.weavings.size();
    }

    public List<String> getUnweavings() {
        return this.unweavings;
    }

    public void setUnweavings(List<String> unweavings) {
        this.unweavings = unweavings;
    }

    public Map<String, DynamicObject> getWeavings() {
        return this.weavings;
    }

    public void setWeavings(Map<String, DynamicObject> weavings) {
        this.weavings = weavings;
    }

    public List<FilterDomainAnalyier> getFilterAnalyiers() {
        return this.filterAnalyiers;
    }

    public void setFilterAnalyiers(List<FilterDomainAnalyier> filterAnalyiers) {
        this.filterAnalyiers = filterAnalyiers;
    }

    public String getReportDataType() {
        return this.reportDataType;
    }

    public void setReportDataType(String reportDataType) {
        this.reportDataType = reportDataType;
    }

    public List<FilterDomainAnalyier> getPageFilterAnalyiers() {
        return this.pageFilterAnalyiers;
    }

    public void setPageFilterAnalyiers(List<FilterDomainAnalyier> pageFilterAnalyiers) {
        this.pageFilterAnalyiers = pageFilterAnalyiers;
    }

    public static class FilterDomainAnalyier {
        public long templateid;
        public String tempNum;
        public List<List<JSONObject>> fitlers;

        public FilterDomainAnalyier(long templateid, String tempNum, List<List<JSONObject>> fitlers) {
            this.templateid = templateid;
            this.tempNum = tempNum;
            this.fitlers = fitlers;
        }

        public long getTemplateid() {
            return this.templateid;
        }

        public String getTempNum() {
            return this.tempNum;
        }

        public List<List<JSONObject>> getFitlers() {
            return this.fitlers;
        }
    }
}

