/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;

public class SpreadJSExportModel {
    public long rptId;
    public long tmpId;
    public String url;
    public JSONArray columns = new JSONArray();
    public JSONArray rows = new JSONArray();
    int freeRow = 0;
    int freecol = 0;
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, SpreadJSExportModel.class);

    public SpreadJSExportModel(long rptId, String url, JSONArray columns) {
        this.rptId = rptId;
        this.url = url;
        this.columns = columns;
    }

    public SpreadJSExportModel(long rptId, long tmpId, String url, JSONArray columns, JSONArray rows, int freeRow, int freecol) {
        this.rptId = rptId;
        this.tmpId = tmpId;
        this.url = url;
        this.columns = columns;
        this.rows = rows;
        this.freeRow = freeRow;
        this.freecol = freecol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpreadJSExportModel getJSExportModel(long rptId, long tempId, String spreadjson) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
        ByteArrayOutputStream spreadJsonOut = null;
        int freeRow = 0;
        int freecol = 0;
        JSONArray columns = new JSONArray();
        JSONArray rows = new JSONArray();
        try {
            try {
                JSONObject sheets;
                JSONObject jsonMap = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
                boolean isChange = false;
                if (jsonMap.get((Object)"tabStripVisible") == null || !jsonMap.getBoolean("tabStripVisible").booleanValue()) {
                    jsonMap.put("tabStripVisible", (Object)true);
                    isChange = true;
                }
                if ((sheets = jsonMap.getJSONObject("sheets")) != null) {
                    for (Object sheet : sheets.entrySet()) {
                        JSONObject sheetObj = (JSONObject)sheet.getValue();
                        if (sheetObj.containsKey((Object)"rowFilter")) {
                            isChange = true;
                            sheetObj.remove((Object)"rowFilter");
                        }
                        if (sheetObj.containsKey((Object)"validations")) {
                            isChange = true;
                            sheetObj.remove((Object)"validations");
                        }
                        if (sheetObj == null) continue;
                        columns = sheetObj.getJSONArray("columns");
                        rows = sheetObj.getJSONArray("rows");
                    }
                }
                try {
                    Workbook gcbook = SpreadUtils.getWorkbook((String)(isChange ? jsonMap.toString() : ssjson));
                    freeRow = gcbook.getActiveSheet().getFreezeRow();
                    freecol = gcbook.getActiveSheet().getFreezeColumn();
                    spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                }
                catch (IllegalArgumentException e) {
                    if (sheets != null) {
                        try {
                            for (Map.Entry sheet : sheets.entrySet()) {
                                JSONObject sheetObj = (JSONObject)sheet;
                                sheetObj.remove((Object)"printInfo");
                            }
                        }
                        catch (NullPointerException ne) {
                            for (Map.Entry entry : sheets.entrySet()) {
                                ((JSONObject)entry.getValue()).remove((Object)"printInfo");
                            }
                        }
                    }
                    Workbook gcbook = SpreadUtils.getWorkbook((String)jsonMap.toString());
                    freeRow = gcbook.getActiveSheet().getFreezeRow();
                    freecol = gcbook.getActiveSheet().getFreezeColumn();
                    spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn(rptId + ":Style conversion is not supported" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            if (spreadJsonOut == null) {
                SpreadJSExportModel e = null;
                return e;
            }
            String pdfURL = cache.saveAsUrl(rptId + "." + XSSFWorkbookType.XLSX.getExtension(), spreadJsonOut.toByteArray(), 5000);
            SpreadJSExportModel spreadJSExportModel = new SpreadJSExportModel(rptId, tempId, pdfURL, columns, rows, freeRow, freecol);
            return spreadJSExportModel;
        }
        catch (Exception e) {
            log.error(rptId + ":dealWorkBook:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        finally {
            try {
                if (spreadJsonOut != null) {
                    spreadJsonOut.close();
                }
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        return null;
    }
}

