/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.export.csv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.ExportFileRuleEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.intergration.scheme.handle.CellMappingHandle;
import kd.fi.bcm.formplugin.model.transfer.core.TransferSerializeUtils;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.BuildSheetContext;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.FileInfo;
import kd.fi.bcm.formplugin.report.export.JqExportXMLOperator;
import kd.fi.bcm.formplugin.report.export.ReportExportInfo;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import kd.fi.bcm.formplugin.report.export.TempReportInfo;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Element;

public class ReportExportCsvFileTaskService
extends NewReportMultiExportService {
    private String time;
    private final Map<Long, DynamicObject> sheetCellMapping = new HashMap<Long, DynamicObject>(16);
    private final Map<String, Map<String, String>> exportFileInfo = new HashMap<String, Map<String, String>>(16);
    private Collection<String> dimensions;
    private final Map<String, Object> enumValueMap = new HashMap<String, Object>(16);

    private void buildExecTime() {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyyMMddHHmmss");
        this.time = df.format(TimeServiceHelper.now());
    }

    private void buildDimensionInfo() {
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        this.dimensions = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum).values();
        QFBuilder builder = new QFBuilder("number", "=", (Object)"Extends");
        builder.add("model", "=", (Object)this.getModelId());
        DynamicObject extendsDim = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])builder.toArray());
        if (extendsDim != null) {
            Long extendsDimId = extendsDim.getLong("id");
            builder = new QFBuilder("dimension", "=", (Object)extendsDimId);
            DynamicObjectCollection enumValues = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,enumvalue", (QFilter[])builder.toArray());
            for (DynamicObject enumValue : enumValues) {
                this.enumValueMap.put(enumValue.getString("id"), enumValue.get("enumvalue"));
            }
        }
    }

    private Map<String, List<DynamicObject>> querySheetMap() {
        QFilter qf = new QFilter("scheme", "=", (Object)this.isSchemeId);
        qf.and("mappingstatus", "=", (Object)"1");
        qf.and("effectstatus", "=", (Object)"1");
        DynamicObjectCollection sheetMapping = QueryServiceHelper.query((String)"bcm_issheetmapping", (String)"id,sheetname,mappingstatus,effectstatus,template,template.number,template.versionnumber,floatmapping", (QFilter[])new QFilter[]{qf});
        HashMap<String, List<DynamicObject>> sheetMap = new HashMap<String, List<DynamicObject>>(sheetMapping.size());
        for (DynamicObject object : sheetMapping) {
            String template = object.getString("template.number");
            sheetMap.computeIfAbsent(template, l -> new ArrayList());
            List mappings = (List)sheetMap.get(template);
            mappings.add(object);
        }
        return sheetMap;
    }

    private DynamicObject findMapping(List<DynamicObject> mappings, String version) {
        if (mappings == null) {
            return null;
        }
        for (DynamicObject mapping : mappings) {
            if (!version.equals(mapping.getString("template.versionnumber"))) continue;
            return mapping;
        }
        return null;
    }

    private void buildCellMapping() {
        QFBuilder builder = new QFBuilder("scheme", "=", (Object)this.isSchemeId);
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_iscellmappingdata", (String)"sheetmappingid,mappingjson", (QFilter[])builder.toArray());
        for (DynamicObject obj : mappings) {
            this.sheetCellMapping.put(obj.getLong("sheetmappingid"), obj);
        }
    }

    @Override
    public List<String> doExport_Xml() {
        String xmlUrl = CellMappingHandle.getXmlAttachment(this.isSchemeId);
        String xmlFileName = String.format("--%s.Xml", this.time);
        log.info("ReportExportCsvFileTaskService-exportFileInfo: " + JSONObject.toJSONString(this.exportFileInfo));
        File xmlFile = JqExportXMLOperator.createXML(xmlUrl, xmlFileName, this.exportFileInfo);
        this.uploadFile(xmlFile);
        return this.fileUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> doExport_Excels() {
        try {
            this.buildExecTime();
            this.buildDimensionInfo();
            Map<String, List<DynamicObject>> sheetMap = this.querySheetMap();
            this.buildCellMapping();
            this.zipFileName = String.format("--%s", this.time);
            String xmlUrl = CellMappingHandle.getXmlAttachment(this.isSchemeId);
            Map<String, Element> exportTable = JqExportXMLOperator.getReportElement(xmlUrl);
            Map<Object, DynamicObject> templateInfo = this.tempReportInfo.getAllTemps();
            Set templateIds = templateInfo.keySet().stream().map(id -> (Long)id).collect(Collectors.toSet());
            Map id2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)this.startYear.getLong("id"), (Long)this.startPeriod.getLong("id"), templateIds);
            for (DynamicObject template : templateInfo.values()) {
                String number;
                List<DynamicObject> mappings;
                DynamicObject mapping;
                if (!id2Right.containsValue(template.getLong("id")) || (mapping = this.findMapping(mappings = sheetMap.get(number = template.getString("number")), template.getString("versionnumber"))) == null) continue;
                String sheet = mapping.getString("sheetname").toLowerCase(Locale.ENGLISH);
                long sheetMappingId = mapping.getLong("id");
                String floatMapping = mapping.getString("floatmapping");
                if (!StringUtils.isNotEmpty((CharSequence)sheet) || !exportTable.containsKey(sheet)) continue;
                Element report = exportTable.get(sheet);
                this.doExport_Excel(report, template, sheetMappingId, floatMapping);
            }
        }
        catch (Exception e) {
            log.warn(this.getClass().toString() + ":" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        finally {
            if (this.tempReportInfo == null) {
                if (this.getTaskConsumer() != null) {
                    this.getTaskConsumer().accept(100);
                }
            } else {
                this.setCompleteSheet(new AtomicInteger(this.tempReportInfo.getSize()));
            }
            if (this.getTaskConsumer() != null) {
                this.getTaskConsumer().accept(100);
            }
        }
        return this.fileUrls;
    }

    public void doExport_Excel(Element element, DynamicObject template, long sheetMappingId, String floatMapping) {
        DynamicObject cellMapping = this.sheetCellMapping.get(sheetMappingId);
        Map<String, JSONArray> cellMap = this.getCellMap(cellMapping.getString("mappingjson"));
        String reportCode = element.attributeValue("code");
        boolean isReport = this.isReportElement(element);
        if (isReport) {
            String fileName;
            Element baseTable = element.element("basetable");
            if (baseTable != null) {
                fileName = this.getFileName(true, baseTable.attributeValue("code"));
                this.createCsvFile(true, fileName, reportCode, baseTable, template, cellMap, null);
            }
            Iterator subTableIterator = element.elementIterator("subtable");
            while (subTableIterator.hasNext()) {
                Element subTable = (Element)subTableIterator.next();
                String code = subTable.attributeValue("code");
                List<String> floatAreas = this.findArea(code, floatMapping);
                if (floatAreas.isEmpty()) continue;
                fileName = this.getFileName(true, code);
                this.createCsvFile(true, fileName, reportCode, subTable, template, cellMap, floatAreas.get(0));
            }
        } else {
            String fileName = this.getFileName(false, element.attributeValue("datafile"));
            this.createCsvFile(false, fileName, reportCode, element, template, cellMap, null);
        }
    }

    private boolean isReportElement(Element report) {
        String name = report.getName();
        return "report".equals(name);
    }

    private String getFileName(boolean isReport, String code) {
        String csvFileName = isReport ? String.format("-%1$s-%2$s.csv", code, this.time) : code.replaceFirst("[0-9]{14}", this.time);
        return csvFileName;
    }

    private List<String> findArea(String subTableCode, String floatMapping) {
        String[] areas;
        ArrayList<String> result = new ArrayList<String>(10);
        if (StringUtils.isEmpty((CharSequence)floatMapping)) {
            return result;
        }
        for (String area : areas = floatMapping.split(";")) {
            if (!area.contains(subTableCode)) continue;
            result.add(area.split("\uff1a")[0]);
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void createCsvFile(boolean isReport, String fileName, String reportCode, Element table, DynamicObject template, Map<String, JSONArray> cellMapping, String floatArea) {
        String tableCode = table.attributeValue("code");
        List columns = table.elements("column");
        String templateId = template.getString("id");
        ArrayList<String> data = new ArrayList<String>(10);
        ReportDataSelectScheme rdss = ReportDataSchemeUtil.getReportDataSelectScheme(new SchemeContext(this.getModelId()), "2");
        for (Map.Entry entry : this.reportData2OrgMap.entrySet()) {
            String reportDataType = (String)entry.getKey();
            Map<String, DynamicObject> reportData = rdss.searchSchemeByNumber(reportDataType);
            Set orgIds = (Set)entry.getValue();
            for (ReportExportInfo pair : this.tempReportInfo.getExportInfos()) {
                ReportExportInfo newPair = new ReportExportInfo(new ArrayList<String>(pair.getUnweavings()), new HashMap<String, DynamicObject>(pair.getWeavings()), pair.getFilterAnalyiers());
                this.filterExportInfo(newPair, templateId, orgIds);
                if (newPair.getUnWeavingSize() == 0 && newPair.getWeavingSize() == 0) continue;
                newPair.setReportDataType(reportDataType);
                this.setDimNum2Items(reportData);
                this.processMap.clear();
                DynamicObject process = reportData.get("Process");
                this.processMap.put(process.getString("number"), process);
                this.process = process;
                this.audittrial = reportData.get("AuditTrail");
                if (reportData.get("Currency") != null) {
                    this.cyDy = reportData.get("Currency");
                    this.setCyObj_view(reportData.get("Currency"));
                }
                this.fileContext = new ReportMultiExportService.FileContext();
                this.sheetName2Name = HashMultimap.create();
                FileInfo fileInfo = new FileInfo(null, 0);
                fileInfo.setReportDataType(pair.getReportDataType());
                List<String> row = this.initUnWeavingReport(isReport, this.tempReportInfo, fileInfo, pair, template.getString("number"), cellMapping, columns, reportDataType, floatArea);
                data.addAll(row);
                row = this.initWeavingReport(isReport, this.tempReportInfo, fileInfo, pair, template.getString("number"), cellMapping, columns, reportDataType, floatArea);
                data.addAll(row);
            }
        }
        if (data.isEmpty() || data.stream().allMatch(StringUtils::isEmpty)) {
            return;
        }
        File csvFile = new File(FilenameUtils.getName((String)fileName));
        TransferSerializeUtils.writeDataToFileWithGBK(csvFile, data);
        this.uploadFile(csvFile);
        this.exportFileInfo.computeIfAbsent(reportCode, k -> new HashMap(16));
        Map<String, String> table2FileMap = this.exportFileInfo.get(reportCode);
        table2FileMap.put(tableCode, fileName);
    }

    private void filterExportInfo(ReportExportInfo pair, String templateId, Set<String> orgIds) {
        String[] info;
        String v;
        Iterator<String> iterator;
        if (pair.getUnweavings() != null) {
            iterator = pair.getUnweavings().iterator();
            while (iterator.hasNext()) {
                v = iterator.next();
                if (!v.contains(templateId)) {
                    iterator.remove();
                    continue;
                }
                info = v.split("\\|");
                if (orgIds.contains(info[2])) continue;
                iterator.remove();
            }
        }
        if (pair.getWeavings() != null) {
            iterator = pair.getWeavings().keySet().iterator();
            while (iterator.hasNext()) {
                v = iterator.next();
                if (!v.contains(templateId)) {
                    iterator.remove();
                    continue;
                }
                info = v.split("\\|");
                if (orgIds.contains(info[2])) continue;
                iterator.remove();
            }
        }
    }

    public List<String> initUnWeavingReport(boolean isReportCsv, TempReportInfo tempReportInfo, FileInfo fileInfo, ReportExportInfo reportExportInfo, String number, Map<String, JSONArray> cellMapping, List<Element> columns, String reportDataType, String floatArea) {
        List<String> result = new ArrayList<String>(16);
        if (this.fileContext.isUnweave() && reportExportInfo.getUnweavings() != null) {
            for (String notExitReportkey : reportExportInfo.getUnweavings()) {
                ReportMultiExportService.KeyParamProvider keyProvider = new ReportMultiExportService.KeyParamProvider(notExitReportkey);
                String tempid = keyProvider.getTempId();
                long orgid = Long.parseLong(keyProvider.getOrgId());
                DynamicObject tempDy = tempReportInfo.getAllTemps().get(Long.valueOf(tempid));
                FYPeriodPair currenctfp = this.getFyPeriodPair(this.fyPeriodPairs, tempReportInfo, fileInfo, number, keyProvider.getStrs(), tempDy);
                if (currenctfp == null) continue;
                Long l = (Long)this.srcTmp2RightId.get((Object)currenctfp.getKey(), (Object)Long.valueOf(tempid));
                if (l == null) {
                    if (!this.srcTmp2RightId.row((Object)currenctfp.getKey()).containsValue(Long.valueOf(tempid))) continue;
                    l = Long.valueOf(tempid);
                }
                TemplateModel temp = ModelDataProvider.getTemplateModel(l);
                DynamicObject currentOrg = tempReportInfo.getId2OrgDys().get(orgid);
                this.initProcessMember(currentOrg, this.processMap);
                this.fileContext.setSaveByDim(temp.isSaveByDim());
                BuildSheetContext buildSheetContext = new BuildSheetContext(fileInfo, number, temp.genAbsoluteDynamicObject(), currenctfp, currentOrg);
                SheetInfo sheetInfo = this.getSheetInfo(tempReportInfo, fileInfo, buildSheetContext);
                String rowHeadValue = this.buildRowHeadValue(currentOrg.getString("number"), reportDataType, currenctfp.getFy().getString("number"), currenctfp.getPeriod().getString("number"), isReportCsv);
                try {
                    Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues;
                    SpreadManager spreadModel = this.getSpreadManager(temp, currenctfp, currentOrg, null);
                    boolean isFilterTemp = false;
                    for (ReportExportInfo.FilterDomainAnalyier filterAnalyier : reportExportInfo.getFilterAnalyiers()) {
                        if (filterAnalyier.getTemplateid() != temp.getId() && !filterAnalyier.getTempNum().equals(temp.getNumber())) continue;
                        for (List<JSONObject> filters : filterAnalyier.fitlers) {
                            spreadModel = this.getSpreadManager(temp, currenctfp, currentOrg, null);
                            this.fileContext.setReport(false);
                            this.isReport = false;
                            StringBuilder sb = new StringBuilder();
                            for (JSONObject membObj : filters) {
                                JSONObject dimObj = membObj.getJSONObject("dim");
                                sb.append(dimObj.getString("name"));
                                sb.append(":");
                                Dimension dim = new Dimension(dimObj.getString("name"), dimObj.getString("number"), "");
                                DimMember dimMember = new DimMember(membObj.getString("name"), membObj.getString("number"), "", (IDimension)dim);
                                dimMember.setId(membObj.getLong("id").longValue());
                                dim.addMember((IDimMember)dimMember);
                                sb.append(membObj.getString("name"));
                                sb.append(";");
                                spreadModel.getFilter().changeFilterDim((IDimension)dim, spreadModel);
                            }
                            sheetInfo.setReal_sheetName(sheetInfo.getSheetName().replaceFirst("filterdim", sb.toString()));
                            cellValues = this.isKeepSomeSetting() ? this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, null, sheetInfo, null) : this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, null, sheetInfo);
                            result = this.buildSaveData(spreadModel, rowHeadValue, cellValues, cellMapping, columns, floatArea);
                            isFilterTemp = true;
                            sheetInfo.setIndex(sheetInfo.getIndex() + 1);
                            fileInfo.getNum2IndexCounts().put(number, fileInfo.getNum2IndexCounts().get(number) + 1);
                            fileInfo.setSheetIndex(fileInfo.getSheetIndex() + 1);
                        }
                    }
                    sheetInfo.setReal_sheetName(sheetInfo.getSheetName().replaceFirst("filterdim", ""));
                    if (!isFilterTemp) {
                        cellValues = this.isKeepSomeSetting() ? this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, null, sheetInfo, null) : this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, null, sheetInfo);
                        result = this.buildSaveData(spreadModel, rowHeadValue, cellValues, cellMapping, columns, floatArea);
                        fileInfo.getNum2IndexCounts().put(number, fileInfo.getNum2IndexCounts().get(number) + 1);
                        fileInfo.setSheetIndex(fileInfo.getSheetIndex() + 1);
                    }
                }
                catch (Exception e) {
                    log.error("ReportExportCsvFileTaskService-initUnWeavingReport: " + e.getMessage());
                }
                this.dealProgress();
            }
        }
        return result;
    }

    public List<String> initWeavingReport(boolean isReportCsv, TempReportInfo tempReportInfo, FileInfo fileInfo, ReportExportInfo reportExportInfo, String number, Map<String, JSONArray> cellMapping, List<Element> columns, String reportDataType, String floatArea) {
        List<String> result = new ArrayList<String>();
        if (reportExportInfo.getWeavings() != null) {
            for (Map.Entry<String, DynamicObject> entry : reportExportInfo.getWeavings().entrySet()) {
                DynamicObject currentreport;
                ReportMultiExportService.KeyParamProvider keyProvider = new ReportMultiExportService.KeyParamProvider(entry.getKey());
                String tempid = keyProvider.getTempId();
                long orgid = Long.parseLong(keyProvider.getOrgId());
                DynamicObject tempDy = tempReportInfo.getAllTemps().get(Long.valueOf(tempid));
                FYPeriodPair currenctfp = this.getFyPeriodPair(this.fyPeriodPairs, tempReportInfo, fileInfo, number, keyProvider.getStrs(), tempDy);
                if (currenctfp == null) continue;
                Long l = (Long)this.srcTmp2RightId.get((Object)currenctfp.getKey(), (Object)Long.valueOf(tempid));
                if (l == null) {
                    if (!this.srcTmp2RightId.row((Object)currenctfp.getKey()).containsValue(Long.valueOf(tempid))) continue;
                    l = Long.valueOf(tempid);
                }
                TemplateModel temp = ModelDataProvider.getTemplateModel(l);
                DynamicObject report = currentreport = AutoFloatUtil.getAlternateFloatRecord(temp, entry.getValue().getLong("id"), "id,spreadjson,data,modifytime");
                if (!"1".equals(this.getSourcestyle())) {
                    report = null;
                }
                DynamicObject currentOrg = tempReportInfo.getId2OrgDys().get(orgid);
                this.initProcessMember(currentOrg, this.processMap);
                this.fileContext.setReport(true);
                this.isReport = true;
                this.fileContext.setSaveByDim(temp.isSaveByDim());
                BuildSheetContext buildSheetContext = new BuildSheetContext(fileInfo, number, temp.genDynamicObject(), currenctfp, currentOrg);
                SheetInfo sheetInfo = this.getSheetInfo(tempReportInfo, fileInfo, buildSheetContext);
                String rowHeadValue = this.buildRowHeadValue(currentOrg.getString("number"), reportDataType, currenctfp.getFy().getString("number"), currenctfp.getPeriod().getString("number"), isReportCsv);
                try {
                    Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues;
                    SpreadManager spreadModel = this.getSpreadManager(temp, currenctfp, currentOrg, report);
                    boolean isFilterTemp = false;
                    for (ReportExportInfo.FilterDomainAnalyier filterAnalyier : reportExportInfo.getFilterAnalyiers()) {
                        if (filterAnalyier.getTemplateid() != temp.getId() && !filterAnalyier.getTempNum().equals(temp.getNumber())) continue;
                        for (List<JSONObject> filters : filterAnalyier.fitlers) {
                            spreadModel = this.getSpreadManager(temp, currenctfp, currentOrg, null);
                            this.fileContext.setReport(false);
                            this.isReport = false;
                            StringBuilder sb = new StringBuilder();
                            for (JSONObject membObj : filters) {
                                JSONObject dimObj = membObj.getJSONObject("dim");
                                sb.append(dimObj.getString("name"));
                                sb.append(":");
                                Dimension dim = new Dimension(dimObj.getString("name"), dimObj.getString("number"), "");
                                DimMember dimMember = new DimMember(membObj.getString("name"), membObj.getString("number"), "", (IDimension)dim);
                                dimMember.setId(membObj.getLong("id").longValue());
                                dim.addMember((IDimMember)dimMember);
                                sb.append(membObj.getString("name"));
                                sb.append(";");
                                spreadModel.getFilter().changeFilterDim((IDimension)dim, spreadModel);
                            }
                            sheetInfo.setReal_sheetName(sheetInfo.getSheetName().replaceFirst("filterdim", sb.toString()));
                            cellValues = this.isKeepSomeSetting() ? this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, report, sheetInfo, currentreport) : this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, report, sheetInfo);
                            result = this.buildSaveData(spreadModel, rowHeadValue, cellValues, cellMapping, columns, floatArea);
                            isFilterTemp = true;
                            fileInfo.getNum2IndexCounts().put(number, fileInfo.getNum2IndexCounts().get(number) + 1);
                            fileInfo.setSheetIndex(fileInfo.getSheetIndex() + 1);
                        }
                    }
                    sheetInfo.setReal_sheetName(sheetInfo.getSheetName().replaceFirst("filterdim", ""));
                    if (!isFilterTemp) {
                        cellValues = this.isKeepSomeSetting() ? this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, report, sheetInfo, currentreport) : this.getOlapValue(spreadModel, temp, currenctfp, currentOrg, report, sheetInfo);
                        spreadModel.getAreaManager().getPostionInfoSet();
                        result = this.buildSaveData(spreadModel, rowHeadValue, cellValues, cellMapping, columns, floatArea);
                        fileInfo.getNum2IndexCounts().put(number, fileInfo.getNum2IndexCounts().get(number) + 1);
                        fileInfo.setSheetIndex(fileInfo.getSheetIndex() + 1);
                    }
                }
                catch (Exception e) {
                    log.error("ReportExportCsvFileTaskService-initWeavingReport: " + e.getMessage());
                }
                this.fileContext.setReport(false);
                this.hasTopSort = false;
                this.dealProgress();
            }
        }
        return result;
    }

    private Map<String, JSONArray> getCellMap(String mappingjson) {
        return (Map)ObjectSerialUtil.parseObject((String)mappingjson, Map.class);
    }

    private List<Tuple<Boolean, String, String>> getFloatAreaRangeList(SpreadManager sm) {
        ArrayList<Tuple<Boolean, String, String>> result = new ArrayList<Tuple<Boolean, String, String>>(10);
        Set positionInfos = sm.getAreaManager().getPostionInfoSet();
        for (PositionInfo p : positionInfos) {
            if (p.getExtendInfo() != null) {
                result.add((Tuple<Boolean, String, String>)Tuple.create((Object)true, (Object)p.getAreaRange(), (Object)p.getOriginalAreaRange()));
                continue;
            }
            for (BasePointInfo base : p.getBasePoints()) {
                result.add((Tuple<Boolean, String, String>)Tuple.create((Object)(base.getDirect() == 2 ? 1 : 0), (Object)base.getDynaRange(), (Object)base.getOriginalDynaRange()));
            }
        }
        return result;
    }

    private Pair<Object, RangeModel> findFloatRange(SpreadManager sm, String floatArea) {
        if (StringUtils.isEmpty((CharSequence)floatArea)) {
            return null;
        }
        Set positionInfos = sm.getAreaManager().getPostionInfoSet();
        for (PositionInfo positionInfo : positionInfos) {
            if (positionInfo.getExtendInfo() != null) {
                if (!floatArea.equals(positionInfo.getOriginalAreaRange())) continue;
                RangeModel range = SpreadAreaUtil.getRangModel((String)positionInfo.getAreaRange());
                return Pair.onePair((Object)positionInfo.getExtendInfo(), (Object)range);
            }
            for (BasePointInfo basePoint : positionInfo.getBasePoints()) {
                if (!floatArea.equals(basePoint.getOriginalDynaRange())) continue;
                RangeModel range = basePoint.getDataArea(positionInfo);
                return Pair.onePair((Object)basePoint, (Object)range);
            }
        }
        return null;
    }

    private List<String> buildSaveData(SpreadManager sm, String headInfo, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, Map<String, JSONArray> cellMapping, List<Element> columns, String floatArea) {
        ArrayList<String> result = new ArrayList<String>(10);
        boolean isFloat = StringUtils.isNotEmpty((CharSequence)floatArea);
        if (isFloat) {
            result.addAll(this.buildFloatInfo(headInfo, sm, cellValues, cellMapping, columns, floatArea));
        } else {
            result.addAll(this.buildUnFloatInfo(headInfo, sm, cellMapping, cellValues, columns));
        }
        return result;
    }

    private List<String> buildUnFloatInfo(String headInfo, SpreadManager sm, Map<String, JSONArray> cellMapping, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, List<Element> columns) {
        List<Tuple<Boolean, String, String>> floatAreaRanges = this.getFloatAreaRangeList(sm);
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < columns.size(); ++i) {
            JSONArray array;
            Object data;
            String key;
            String code = columns.get(i).attributeValue("code");
            boolean setValue = false;
            Iterator iterator = cellMapping.get("data").iterator();
            while (!(!iterator.hasNext() || (key = (String)((JSONObject)(data = iterator.next())).keySet().iterator().next()).startsWith("g_") && (setValue = this.addMemberToString(sb, floatAreaRanges, array = ((JSONObject)data).getJSONArray(key), code, cellValues)))) {
            }
            if (setValue) continue;
            sb.append(",");
        }
        if (sb.length() == columns.size() - 2) {
            return new ArrayList<String>(10);
        }
        StringBuilder temp = new StringBuilder();
        temp.append(headInfo);
        temp.append((CharSequence)sb);
        return Lists.newArrayList((Object[])new String[]{temp.toString()});
    }

    private List<String> buildFloatInfo(String headInfo, SpreadManager sm, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues, Map<String, JSONArray> cellMapping, List<Element> columns, String floatArea) {
        Tuple<String, List<String>, List<List<String>>> groupSetting;
        int j;
        ArrayList<String> result = new ArrayList<String>(10);
        Pair<Object, RangeModel> floatRange = this.findFloatRange(sm, floatArea);
        if (floatRange == null) {
            return result;
        }
        BasePointInfo baseInfo = null;
        ExtendInfo extendInfo = null;
        boolean rowFloat = true;
        if (floatRange.p1 instanceof BasePointInfo) {
            baseInfo = (BasePointInfo)floatRange.p1;
            rowFloat = baseInfo.getDirect() == 2;
        } else {
            extendInfo = (ExtendInfo)floatRange.p1;
        }
        JSONArray array = this.getFloatCellMappingArray(cellMapping, floatArea);
        if (array == null) {
            return result;
        }
        ArrayList<Integer> floatIndex = new ArrayList<Integer>(10);
        if (rowFloat) {
            for (j = ((RangeModel)floatRange.p2).getY_start(); j <= ((RangeModel)floatRange.p2).getY_end(); ++j) {
                floatIndex.add(j);
            }
        } else {
            for (j = ((RangeModel)floatRange.p2).getX_start(); j <= ((RangeModel)floatRange.p2).getX_end(); ++j) {
                floatIndex.add(j);
            }
        }
        if ((groupSetting = this.getGroupSetting(cellMapping, floatArea)) != null && rowFloat) {
            Map<Integer, Map<String, String>> rowMembers;
            LinkedHashSet<String> groupDimMembers;
            String groupBy = (String)groupSetting.p1;
            List groupField = (List)groupSetting.p2;
            List groupFieldMembers = (List)groupSetting.p3;
            int groupByIndex = -1;
            if (baseInfo != null) {
                groupDimMembers = this.getGroupDimMembers(groupBy, sm, baseInfo, floatArea, (RangeModel)floatRange.p2);
                rowMembers = this.getRowMembers(sm, (RangeModel)floatRange.p2);
            } else {
                groupDimMembers = this.getGroupDimMembers(groupBy, sm, extendInfo, floatArea, (RangeModel)floatRange.p2);
                rowMembers = this.getRowMembers(sm, (RangeModel)floatRange.p2, extendInfo, groupBy, groupField);
                groupByIndex = this.getExtendsColIndex((RangeModel)floatRange.p2, extendInfo, groupBy);
            }
            for (String groupMember : groupDimMembers) {
                StringBuilder sb = new StringBuilder();
                ArrayList<List<Integer>> matchRows = new ArrayList<List<Integer>>(10);
                boolean allUnMatch = true;
                for (List members : groupFieldMembers) {
                    ArrayList<Integer> rows = new ArrayList<Integer>(10);
                    for (Map.Entry<Integer, Map<String, String>> entry : rowMembers.entrySet()) {
                        if (!groupMember.equals(entry.getValue().get(groupBy))) continue;
                        int matchCol = 0;
                        for (int i = 0; i < members.size(); ++i) {
                            String rowMember;
                            String dim = (String)groupField.get(i);
                            String member = (String)members.get(i);
                            if (!member.equals(rowMember = entry.getValue().get(dim))) continue;
                            ++matchCol;
                        }
                        if (matchCol != members.size()) continue;
                        int row = entry.getKey();
                        rows.add(row);
                        allUnMatch = false;
                    }
                    matchRows.add(rows);
                }
                if (allUnMatch) continue;
                for (int i = 2; i < columns.size(); ++i) {
                    String code = columns.get(i).attributeValue("code");
                    this.addMemberToString(matchRows, ((RangeModel)floatRange.p2).getX_start(), groupByIndex, sb, array, code, cellValues);
                }
                StringBuilder temp = new StringBuilder();
                temp.append(headInfo);
                temp.append((CharSequence)sb);
                result.add(temp.toString());
            }
        } else {
            for (Integer index : floatIndex) {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < columns.size(); ++i) {
                    String code = columns.get(i).attributeValue("code");
                    boolean setValue = this.addMemberToString(index, rowFloat, sb, array, code, cellValues);
                    if (setValue) continue;
                    sb.append(",");
                }
                if (sb.length() == columns.size() - 2) continue;
                StringBuilder temp = new StringBuilder();
                temp.append(headInfo);
                temp.append((CharSequence)sb);
                result.add(temp.toString());
            }
        }
        return result;
    }

    private String getFloatMappingKey(Map<String, JSONArray> cellMapping, String floatArea) {
        List areas = cellMapping.get("floatArea").stream().map(Object::toString).collect(Collectors.toList());
        int index = 0;
        for (int j = 0; j < areas.size(); ++j) {
            if (!ExcelUtils.isOverlap((String)((String)areas.get(j)), (String)floatArea)) continue;
            index = j + 1;
            break;
        }
        if (index == 0) {
            return null;
        }
        return "f_" + index;
    }

    private JSONArray getFloatCellMappingArray(Map<String, JSONArray> cellMapping, String floatArea) {
        String floatMappingKey = this.getFloatMappingKey(cellMapping, floatArea);
        if (floatMappingKey == null || StringUtils.isEmpty((CharSequence)floatMappingKey)) {
            return null;
        }
        for (Object data : cellMapping.get("data")) {
            String key = (String)((JSONObject)data).keySet().iterator().next();
            if (!floatMappingKey.equals(key)) continue;
            return ((JSONObject)data).getJSONArray(key);
        }
        return null;
    }

    private Tuple<String, List<String>, List<List<String>>> getGroupSetting(Map<String, JSONArray> cellMapping, String floatArea) {
        JSONArray groupSetting = cellMapping.get("groupSetting");
        if (groupSetting != null) {
            for (Object o : groupSetting) {
                String area = ((JSONObject)o).getString("left");
                if (!floatArea.equals(area)) continue;
                String groupBy = ((JSONObject)o).getString("middle");
                String member = ((JSONObject)o).getJSONObject("right").getString("p1");
                LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(16);
                String[] dimInfo = member.split(";");
                int minLength = 0;
                ArrayList<String> dimens = new ArrayList<String>(10);
                for (String s : dimInfo) {
                    List<String> m;
                    String[] array = s.split("!");
                    boolean isDim = this.dimensions.contains(array[0]);
                    String[] members = array[1].split(",");
                    if (isDim) {
                        m = Arrays.asList(members);
                    } else {
                        m = new ArrayList<String>();
                        for (String id : members) {
                            if (this.enumValueMap.get(id) == null) continue;
                            m.add(this.enumValueMap.get(id).toString());
                        }
                    }
                    map.put(array[0], m);
                    minLength = minLength == 0 ? m.size() : Math.min(minLength, m.size());
                    dimens.add(array[0]);
                }
                ArrayList membersGroup = new ArrayList(10);
                for (int i = 0; i < minLength; ++i) {
                    ArrayList members = new ArrayList(10);
                    for (List value : map.values()) {
                        members.add(value.get(i));
                    }
                    membersGroup.add(members);
                }
                return Tuple.create((Object)groupBy, dimens, membersGroup);
            }
        }
        return null;
    }

    private LinkedHashSet<String> getGroupDimMembers(String groupBy, SpreadManager sm, BasePointInfo basePoint, String floatArea, RangeModel range) {
        String[] temp = floatArea.split(":");
        Point start = ExcelUtils.pos2Point((String)temp[0]);
        LinkedHashSet<String> result = new LinkedHashSet<String>(16);
        for (BasePointInnerLineInfo inner : basePoint.getBasePointInnerLineInfo()) {
            String dimension = inner.getDimension().getNumber();
            if (!groupBy.equals(dimension)) continue;
            int offset = inner.getOffset();
            if (offset == -1) {
                List membScope = inner.getDynaMembScopes();
                result.add(((DynaMembScopeInfo)membScope.get(0)).getMember().getNumber());
                continue;
            }
            sm.getBook().getSheet(0).iteratorRangeCells(range.getY_start(), range.getY_end(), start.x + offset, start.x + offset, cell -> {
                List dimMembers = (List)cell.getUserObject("KEY_DIM_FLAG");
                if (dimMembers != null && !dimMembers.isEmpty()) {
                    dimMembers.forEach(m -> result.add(m.getNumber()));
                }
            });
        }
        return result;
    }

    private LinkedHashSet<String> getGroupDimMembers(String groupBy, SpreadManager sm, ExtendInfo extendInfo, String floatArea, RangeModel range) {
        String[] temp = floatArea.split(":");
        Point start = ExcelUtils.pos2Point((String)temp[0]);
        LinkedHashSet<String> result = new LinkedHashSet<String>(16);
        List cols = extendInfo.getCols();
        for (int i = 0; i < cols.size(); ++i) {
            if (!groupBy.equals(cols.get(i))) continue;
            sm.getBook().getSheet(0).iteratorRangeCells(range.getY_start(), range.getY_end(), start.x + i, start.x + i, cell -> {
                if (this.dimensions.contains(groupBy)) {
                    List dimMembers = (List)cell.getUserObject("KEY_DIM_FLAG");
                    if (dimMembers != null && !dimMembers.isEmpty()) {
                        dimMembers.forEach(m -> result.add(m.getNumber()));
                    }
                } else {
                    Object value = cell.getValue();
                    if (value != null) {
                        result.add(value.toString());
                    }
                }
            });
        }
        return result;
    }

    private Map<Integer, Map<String, String>> getRowMembers(SpreadManager sm, RangeModel range) {
        HashMap<Integer, Map<String, String>> rowMembers = new HashMap<Integer, Map<String, String>>(16);
        sm.getBook().getSheet(0).iteratorRangeCells(range.getY_start(), range.getY_end(), range.getX_start(), range.getX_start(), cell -> {
            HashMap members = new HashMap(16);
            List dimMembers = (List)cell.getUserObject("KEY_DIM_FLAG");
            if (dimMembers != null && !dimMembers.isEmpty()) {
                dimMembers.forEach(m -> members.put(m.getDimension().getNumber(), m.getNumber()));
            }
            rowMembers.put(cell.getRow(), members);
        });
        return rowMembers;
    }

    private int getExtendsColIndex(RangeModel range, ExtendInfo extendInfo, String key) {
        List colNums = extendInfo.getCols();
        int startCol = range.getX_start();
        if (!colNums.contains(key)) {
            return -1;
        }
        return startCol + colNums.indexOf(key);
    }

    private Map<Integer, Map<String, String>> getRowMembers(SpreadManager sm, RangeModel range, ExtendInfo extendInfo, String groupBy, List<String> groupField) {
        HashMap<Integer, Map<String, String>> rowMembers = new HashMap<Integer, Map<String, String>>(16);
        int startRow = range.getY_start();
        int endRow = range.getY_end();
        int startCol = range.getX_start();
        List colNums = extendInfo.getCols();
        HashMap<Integer, String> fieldIndex = new HashMap<Integer, String>(16);
        int index = colNums.indexOf(groupBy) + startCol;
        fieldIndex.put(index, groupBy);
        for (String field : groupField) {
            index = colNums.indexOf(field) + startCol;
            fieldIndex.put(index, field);
        }
        for (int i = startRow; i <= endRow; ++i) {
            HashMap members = new HashMap(16);
            for (Cell cell : sm.getBook().getSheet(0).getRow(i)) {
                int col = cell.getCol();
                if (!fieldIndex.containsKey(col)) continue;
                if (this.dimensions.contains(fieldIndex.get(col))) {
                    List dimMembers = (List)cell.getUserObject("KEY_DIM_FLAG");
                    if (dimMembers == null || dimMembers.isEmpty()) continue;
                    dimMembers.forEach(m -> members.put(m.getDimension().getNumber(), m.getNumber()));
                    continue;
                }
                members.put(fieldIndex.get(col), cell.getValue() == null ? null : cell.getValue().toString());
            }
            rowMembers.put(i, members);
        }
        return rowMembers;
    }

    private boolean addMemberToString(int index, boolean isRowFloat, StringBuilder sb, JSONArray array, String code, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) {
        boolean setValue = false;
        block0: for (Object o : array) {
            String key = ((JSONArray)new ArrayList(((JSONObject)o).values()).get(0)).get(1).toString();
            if (!this.checkCellKeyMatch(key, code)) continue;
            String target = (String)((JSONObject)o).keySet().iterator().next();
            String[] targetIndex = target.split("#");
            int row = isRowFloat ? index : Integer.parseInt(targetIndex[0]);
            int col = isRowFloat ? Integer.parseInt(targetIndex[1]) : index;
            for (Map map : (List)cellValues.p2) {
                if (!map.get("r").equals(row) || !map.get("c").equals(col)) continue;
                String value = this.getCellValue(map.get("v"));
                sb.append(value).append(",");
                setValue = true;
                continue block0;
            }
        }
        return setValue;
    }

    private void addMemberToString(List<List<Integer>> matchRows, int start, int groupByIndex, StringBuilder sb, JSONArray array, String code, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) {
        for (Object o : array) {
            String key = ((JSONArray)new ArrayList(((JSONObject)o).values()).get(0)).get(1).toString();
            if (!this.checkCellKeyMatch(key, code)) continue;
            String target = (String)((JSONObject)o).keySet().iterator().next();
            String[] targetIndex = target.split("#");
            int col = Integer.parseInt(targetIndex[1]);
            HashSet<String> temp = new HashSet<String>();
            for (List<Integer> rows : matchRows) {
                block2: for (Integer index : rows) {
                    int row = index;
                    if (col >= start && col != groupByIndex) continue;
                    for (Map map : (List)cellValues.p2) {
                        if (!map.get("r").equals(row) || !map.get("c").equals(col)) continue;
                        String value = this.getCellValue(map.get("v"));
                        temp.add(value);
                        continue block2;
                    }
                }
            }
            if (!temp.isEmpty()) {
                sb.append((String)temp.iterator().next()).append(",");
                continue;
            }
            for (List<Integer> rows : matchRows) {
                if (rows.isEmpty()) {
                    sb.append(",");
                    continue;
                }
                boolean onlyData = rows.size() > 1;
                ArrayList<String> tempValue = new ArrayList<String>(10);
                block5: for (Integer index : rows) {
                    int row = index;
                    String cellKey = row + "@" + col;
                    if (onlyData && !this.dataCells.contains(cellKey)) break;
                    if (col < start || col == groupByIndex) continue;
                    for (Map map : (List)cellValues.p2) {
                        if (!map.get("r").equals(row) || !map.get("c").equals(col)) continue;
                        String value = this.getCellValue(map.get("v"));
                        tempValue.add(value);
                        continue block5;
                    }
                }
                if (tempValue.isEmpty()) {
                    sb.append(",");
                    continue;
                }
                if (onlyData) {
                    BigDecimal realValue = new BigDecimal(0);
                    for (String s : tempValue) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        realValue = realValue.add(new BigDecimal(s));
                    }
                    sb.append(realValue).append(",");
                    continue;
                }
                sb.append((String)tempValue.get(0)).append(",");
            }
        }
    }

    private boolean addMemberToString(StringBuilder sb, List<Tuple<Boolean, String, String>> floatAreaRanges, JSONArray array, String code, Pair<List<Map<String, Object>>, List<Map<String, Object>>> cellValues) {
        boolean setValue = false;
        block0: for (Object o : array) {
            String key = ((JSONArray)new ArrayList(((JSONObject)o).values()).get(0)).get(1).toString();
            if (!this.checkCellKeyMatch(key, code)) continue;
            String target = (String)((JSONObject)o).keySet().iterator().next();
            Point realPoint = this.getRealCellPoint(floatAreaRanges, target);
            for (Map map : (List)cellValues.p2) {
                if (!map.get("r").equals(realPoint.y) || !map.get("c").equals(realPoint.x)) continue;
                String value = this.getCellValue(map.get("v"));
                sb.append(value).append(",");
                setValue = true;
                continue block0;
            }
        }
        return setValue;
    }

    private Point getRealCellPoint(List<Tuple<Boolean, String, String>> floatAreaRanges, String point) {
        String[] targetIndex = point.split("#");
        int row = Integer.parseInt(targetIndex[0]);
        int col = Integer.parseInt(targetIndex[1]);
        if (!floatAreaRanges.isEmpty()) {
            String p = ExcelUtils.xy2Pos((int)col, (int)row);
            boolean rowFloat = (Boolean)floatAreaRanges.get((int)0).p1;
            String lastDynaRange = null;
            String lastOriginalDynaRange = null;
            for (Tuple<Boolean, String, String> area : floatAreaRanges) {
                String originalDynaRange = (String)area.p3;
                if ((!rowFloat || !ExcelUtils.isRowBeforeRange((String)originalDynaRange, (String)p)) && (rowFloat || !ExcelUtils.isColBeforeRange((String)originalDynaRange, (String)p)) || lastDynaRange != null && !ExcelUtils.isBeforeRange((String)originalDynaRange, lastOriginalDynaRange)) continue;
                lastDynaRange = (String)area.p2;
                lastOriginalDynaRange = (String)area.p3;
            }
            if (lastDynaRange != null && lastOriginalDynaRange != null) {
                RangeModel a = new RangeModel(lastDynaRange);
                RangeModel b = new RangeModel(lastOriginalDynaRange);
                if (rowFloat) {
                    int insertRowCount = a.getY_end() - b.getY_end();
                    row += insertRowCount;
                } else {
                    int insertColCount = a.getX_end() - b.getX_end();
                    col += insertColCount;
                }
            }
        }
        return new Point(col, row);
    }

    private boolean checkCellKeyMatch(String key, String code) {
        String[] keys = key.split(",");
        if (keys.length != 2) {
            return false;
        }
        return code.equals(keys[1].substring(0, keys[1].length() - 1));
    }

    private String getCellValue(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    private String buildRowHeadValue(String orgNumber, String reportDataType, String year, String period, boolean isReport) {
        Map map = (Map)this.jqOrgMappingsingleMap.get(orgNumber + "@" + reportDataType);
        String temp = "1@" + year + "@" + period;
        if (map == null) {
            return null;
        }
        String first = this.getFileNameYearMonth((String)map.get(ExportFileRuleEnum.ENTERPRISECODE.getCode()), (String)map.get(ExportFileRuleEnum.REPORTTYPECODE.getCode()), this.isSchemeId, temp);
        String second = isReport ? "1" : first;
        return first + "," + second + ",";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = cache.saveAsUrl(file.getName(), (InputStream)inputStream, 5000);
            this.fileUrls.add(url);
            this.fileNm2UrlMap.put(file.getName(), url);
        }
        catch (Exception e) {
            log.error("ReportExportCsvFileTaskService-uploadFile: " + e.getMessage());
        }
        finally {
            try {
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
            }
            catch (IOException e) {
                log.error("ReportExportCsvFileTaskService-deleteFile: " + file.getAbsolutePath() + ", " + e.getMessage());
            }
        }
    }

    @Override
    protected void dealDataUnit4JQ(List<Map<String, Object>> cellValues, Set<String> enumCells) {
        for (Map<String, Object> cell : cellValues) {
            Object value = cell.get("v");
            if (value instanceof Date) {
                cell.put("v", DateTimeUtils.format((Date)((Date)value), (String)"yyyy/MM/dd"));
            }
            String key = cell.get("r").toString() + "@" + cell.get("c").toString();
            if (!(value instanceof String) || !enumCells.contains(key)) continue;
            String v = String.valueOf(value);
            cell.put("v", v.split("\\|")[0]);
        }
    }
}

