/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.extreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.extreport.ExtReportViewHandle;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.ExtDataHandleService;

public class ExtReportModelHandle {
    private long modelId;
    private String modelNumber;
    private String cube;
    private SpreadManager sm;
    private TemplateModel templateModel;
    private PositionInfo positionInfo;
    private ExtReportViewHandle viewHandle;
    private PositionInfo.FloatMemDisplayPattern floatDisplayPattern = null;
    private boolean isDelayLoad = true;
    private int pageSize = 1000;
    public static final String DATAMODEL2DATASETCACHEID = "datamodel2datasetcacheid";
    public static final String ORIGINRANGE2CURSORS = "originRange2Cursors";
    public static final String floatarea = "floatarea";
    private List<Integer> deledata = new ArrayList<Integer>();
    private Map<String, Map<String, Map<String, String>>> result;
    private static final String MATCHEXTWITHROWCOL = "matchExtwithrowcol";

    public ExtReportModelHandle(long modelId, String modelNumber, SpreadManager sm, TemplateModel templateModel, PositionInfo positionInfo, ExtReportViewHandle viewHandle) {
        this.modelId = modelId;
        this.modelNumber = modelNumber;
        this.sm = sm;
        this.templateModel = templateModel;
        this.positionInfo = positionInfo;
        this.viewHandle = viewHandle;
    }

    public ExtReportModelHandle(long modelId, String cube, SpreadManager sm, TemplateModel template) {
        this.modelId = modelId;
        this.cube = cube;
        this.sm = sm;
        this.templateModel = template;
    }

    public ExtReportModelHandle(SpreadManager sm, ExtReportViewHandle viewHandle) {
        this.sm = sm;
        this.viewHandle = viewHandle;
    }

    public ExtReportModelHandle(long modelId, String modelNumber, SpreadManager sm, TemplateModel templateModel, ExtReportViewHandle viewHandle) {
        this.modelId = modelId;
        this.modelNumber = modelNumber;
        this.sm = sm;
        this.templateModel = templateModel;
        this.viewHandle = viewHandle;
        this.cube = MemberReader.findModelNumberByShowNum((String)modelNumber);
    }

    public void autoLoadExtReport(SpreadManager sm, IRelaMembSupplier<String, String> orgSupplier, PositionInfo curPos) {
        List dataSetInfos;
        this.isDelayLoad = this.viewHandle != null && this.viewHandle.getView() != null;
        ExtReportModelCacheManager cacheManager = null;
        if (this.isDelayLoad) {
            cacheManager = new ExtReportModelCacheManager(this.viewHandle.getPageCache(), (OrgRelaMembSupplier)orgSupplier);
            cacheManager.initCache();
        }
        if ((dataSetInfos = ExtDataHandleService.queryExtDataByDataSet((boolean)this.templateModel.getIsOnlyRead(), (SpreadManager)sm, (String)this.modelNumber, (OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (boolean)this.isDelayLoad, (int)this.pageSize)).isEmpty()) {
            return;
        }
        Map setmap = ExtDataHandleService.transDataSetInfo2PResult((List)dataSetInfos);
        if (this.isDelayLoad) {
            cacheManager.cacheDataModelDataSetInfo(dataSetInfos);
        }
        for (PositionInfo ps : FloatLogicImpl.sortPositionInfo(sm.getAreaManager().getPostionInfoSet(), false)) {
            if (ps.getExtendInfo() == null || curPos != null && !ps.getOriginalAreaRange().equals(curPos.getOriginalAreaRange())) continue;
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
            this.positionInfo = ps;
            EDResultSet edResultSet = (EDResultSet)setmap.get(ps);
            cellValues.addAll(this.clearExtMemberAndValue(this.positionInfo.getExtendInfo().getCols()));
            if (this.viewHandle != null && this.viewHandle.getView() != null) {
                SpreadClientInvoker.invokeUpdataValueMethod(this.viewHandle.getViewProxy(), this.viewHandle.getSpreadKey(), cellValues);
            }
            if (edResultSet == null) continue;
            List<EDRow> rows = ExtReportModelHandle.getRows(edResultSet);
            this.checkAndLoadExt(rows);
        }
    }

    public void nextPageExtDataFloat(boolean isOnlyRead, SpreadManager sm, int row, int col, IRelaMembSupplier<String, String> orgSupplier) {
        this.isDelayLoad = this.viewHandle != null && this.viewHandle.getView() != null || this.pageSize != ExtDataHandleService.getPageSizeSetting((long)this.modelId);
        PositionInfo selPos = sm.getInAreaPositionByRow(row, col);
        if (selPos == null || selPos.getExtendInfo() == null) {
            if (this.viewHandle == null || this.viewHandle.getView() == null) {
                return;
            }
            this.viewHandle.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u62d3\u5c55\u6570\u636e\u533a\u57df\u7684\u5355\u5143\u683c\uff0c\u518d\u70b9\u51fb\u663e\u793a\u66f4\u591a\u62d3\u5c55\u6570\u636e\u3002", (String)"ExtReportModelHandle_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.positionInfo = selPos;
        RangeModel rangeModel = new RangeModel(this.positionInfo.getAreaRange());
        if (this.viewHandle == null) {
            return;
        }
        ExtReportModelCacheManager cacheManager = new ExtReportModelCacheManager(this.viewHandle.getPageCache(), (OrgRelaMembSupplier)orgSupplier);
        cacheManager.initCache();
        if (cacheManager.originRange2CacheId.get(this.positionInfo.getOriginalAreaRange()) == null) {
            if (this.viewHandle == null || this.viewHandle.getView() == null) {
                return;
            }
            this.viewHandle.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62d3\u5c55\u6570\u636e\u533a\u57df\u7684\u6570\u636e\u5df2\u7ecf\u5168\u90e8\u663e\u793a\u3002", (String)"ExtReportModelHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ThreadCache.put((Object)"selectoriginRange", (Object)this.positionInfo.getOriginalAreaRange());
        List dataSetInfos = ExtDataHandleService.queryExtDataByDataSet((boolean)isOnlyRead, (SpreadManager)sm, (String)this.modelNumber, (OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (boolean)true, (int)this.pageSize);
        Map setmap = ExtDataHandleService.transDataSetInfo2PResult((List)dataSetInfos);
        cacheManager.cacheDataModelDataSetInfo(dataSetInfos);
        EDResultSet edResultSet = (EDResultSet)setmap.get(selPos);
        if (edResultSet == null) {
            cacheManager.closeRangeDataSet(this.positionInfo.getOriginalAreaRange());
            cacheManager.cacheDataSetCacheIdAndCursor();
            if (this.viewHandle == null || this.viewHandle.getView() == null) {
                return;
            }
            this.viewHandle.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62d3\u5c55\u6570\u636e\u533a\u57df\u7684\u6570\u636e\u5df2\u7ecf\u5168\u90e8\u663e\u793a\u3002", (String)"ExtReportModelHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<EDRow> rows = ExtReportModelHandle.getRows(edResultSet);
        if (rows.isEmpty()) {
            if (this.viewHandle == null || this.viewHandle.getView() == null) {
                return;
            }
            cacheManager.closeRangeDataSet(this.positionInfo.getOriginalAreaRange());
            cacheManager.cacheDataSetCacheIdAndCursor();
            this.viewHandle.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62d3\u5c55\u6570\u636e\u533a\u57df\u7684\u6570\u636e\u5df2\u7ecf\u5168\u90e8\u663e\u793a\u3002", (String)"ExtReportModelHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isDelayLoad && this.pageSize == ExtDataHandleService.getPageSizeSetting((long)this.modelId)) {
            if (rows.isEmpty() || rows.size() < this.pageSize) {
                cacheManager.closeRangeDataSet(this.positionInfo.getOriginalAreaRange());
                if (this.viewHandle == null || this.viewHandle.getView() == null) {
                    return;
                }
                if (rows.isEmpty()) {
                    this.viewHandle.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62d3\u5c55\u6570\u636e\u533a\u57df\u7684\u6570\u636e\u5df2\u7ecf\u5168\u90e8\u663e\u793a\u3002", (String)"ExtReportModelHandle_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            cacheManager.cacheDataSetCacheIdAndCursor();
        }
        int pageStartIndex = rangeModel.getY_start() + ExtDataHandleService.getHasDataRowMaxCount((SpreadManager)sm, (PositionInfo)this.positionInfo);
        if (rangeModel.getY_end() < pageStartIndex) {
            pageStartIndex = rangeModel.getY_end();
        }
        this.checkAndLoadNextPageExtData(rows, pageStartIndex);
        if (this.viewHandle != null && this.viewHandle.getView() != null) {
            this.refleshExt(sm);
        }
    }

    public boolean refleshExt(SpreadManager sm) {
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList cellValues = new ArrayList(10);
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            if (ps.getExtendInfo() == null) continue;
            RangeModel rangeModel = new RangeModel(ps.getAreaRange());
            sheet.iteratorRangeCells(rangeModel, cell -> {
                if (cell.isChangeVal()) {
                    HashMap<String, Object> cmap = new HashMap<String, Object>(4);
                    cmap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
                    cmap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
                    cmap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
                    cellValues.add(cmap);
                }
            });
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.viewHandle.getViewProxy(), this.viewHandle.getSpreadKey(), cellValues);
        if (this.viewHandle.getPlugin() != null) {
            this.viewHandle.getPlugin().updateClientSpreadValues();
        }
        return true;
    }

    private void checkAndLoadNextPageExtData(List<EDRow> rows, Integer pageStartIndex) {
        if (this.positionInfo.getExtendInfo().getCols().isEmpty() || rows.isEmpty()) {
            return;
        }
        this.insertRank(pageStartIndex, rows.size(), this.positionInfo.getAreaRange(), false);
        List floatDimNums = this.positionInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension()).collect(Collectors.toList());
        List<String> fDimNums = floatDimNums.stream().map(f -> f.getNumber()).collect(Collectors.toList());
        if (this.positionInfo.getExtendInfo().isShowDataSourceOrg()) {
            fDimNums.add(DimEntityNumEnum.ENTITY.getNumber());
        }
        List cols = this.positionInfo.getExtendInfo().getCols();
        Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems((List)cols, (long)this.modelId);
        HashMap<String, String> extCol2dimNum = new HashMap<String, String>(16);
        if (!multiF7ValueByExtMems.isEmpty()) {
            for (Map.Entry entry : multiF7ValueByExtMems.entrySet()) {
                if (((MultiF7Results)entry.getValue()).getDimDy() == null) continue;
                String key = (String)entry.getKey();
                String dimNumber = ((MultiF7Results)entry.getValue()).getDimDy().getString("number");
                fDimNums.add(key);
                extCol2dimNum.put(key, dimNumber);
            }
        }
        this.result = ExtReportModelHandle.collectMemMsg(rows, fDimNums, this.modelId, extCol2dimNum);
        RangeModel rangeModel = new RangeModel(this.positionInfo.getAreaRange());
        this.updataSheetExtModel(rangeModel, rows, this.result, pageStartIndex);
    }

    private static List<EDRow> getRows(EDResultSet setmap) {
        ArrayList<EDRow> rows = new ArrayList<EDRow>(16);
        while (setmap.next()) {
            rows.add(setmap.getRow());
        }
        return rows;
    }

    private void checkAndLoadExt(List<EDRow> rows) {
        String range = this.positionInfo.getAreaRange();
        String originalDynaRange = this.positionInfo.getOriginalAreaRange();
        int rangestartindex = ExcelUtils.pos2Y((String)range.split(":")[0]);
        if (this.positionInfo.getExtendInfo().getCols().isEmpty() || rows.isEmpty()) {
            ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
            cache.add(new AutoFloatLogicImpl.FloatArea(range, 0, false, originalDynaRange, this.positionInfo.getAreaRange(), this.deledata));
            this.deledata.clear();
            ThreadCache.put((Object)floatarea, cache);
            return;
        }
        int start2insert = rangestartindex;
        int insertSum = this.insertRank(start2insert, rows.size(), range, false);
        RangeModel rangeModel = new RangeModel(this.positionInfo.getAreaRange());
        ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
        cache.add(new AutoFloatLogicImpl.FloatArea(range, insertSum, false, originalDynaRange, this.positionInfo.getAreaRange(), this.deledata));
        ThreadCache.put((Object)floatarea, cache);
        this.deledata.clear();
        List floatDimNums = this.positionInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension()).collect(Collectors.toList());
        List<String> fDimNums = floatDimNums.stream().map(f -> f.getNumber()).collect(Collectors.toList());
        if (this.positionInfo.getExtendInfo().isShowDataSourceOrg()) {
            fDimNums.add(DimEntityNumEnum.ENTITY.getNumber());
        }
        List cols = this.positionInfo.getExtendInfo().getCols();
        Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems((List)cols, (long)this.modelId);
        HashMap<String, String> extCol2dimNum = new HashMap<String, String>(16);
        if (!multiF7ValueByExtMems.isEmpty()) {
            for (Map.Entry entry : multiF7ValueByExtMems.entrySet()) {
                if (((MultiF7Results)entry.getValue()).getDimDy() == null) continue;
                String dimNumber = ((MultiF7Results)entry.getValue()).getDimDy().getString("number");
                String key = (String)entry.getKey();
                fDimNums.add(key);
                extCol2dimNum.put(key, dimNumber);
            }
        }
        this.result = ExtReportModelHandle.collectMemMsg(rows, fDimNums, this.modelId, extCol2dimNum);
        this.updataSheetExtModel(rangeModel, rows, this.result, rangeModel.getY_start());
    }

    private void updataSheetExtModel(RangeModel rangeModel, List<EDRow> rows, Map<String, Map<String, Map<String, String>>> result, int startRowIndex) {
        int row = startRowIndex;
        List floatDimNums = this.positionInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension()).collect(Collectors.toList());
        HashMap<String, PositionInfo.FloatMemDisplayPattern> dimNum2DisplayEnums = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(16);
        for (FloatDimInfo floatDimInfo : this.positionInfo.getExtendInfo().getFloatdims()) {
            dimNum2DisplayEnums.put(floatDimInfo.getDimension().getNumber(), floatDimInfo.getFloatMemDisplayPattern());
        }
        dimNum2DisplayEnums.put(DimEntityNumEnum.ENTITY.getNumber(), this.positionInfo.getExtendInfo().getOrgDisplayPattern());
        List fDimNums = floatDimNums.stream().map(f -> f.getNumber()).collect(Collectors.toList());
        HashSet fDimNumSets = new HashSet(fDimNums);
        int headerCol = rangeModel.getY_start() >= 1 ? rangeModel.getY_start() - 1 : rangeModel.getY_start();
        ArrayList<String> headCols = new ArrayList<String>(16);
        ArrayList<Integer> headColIndexs = new ArrayList<Integer>(16);
        for (Cell cell : this.sm.getBook().getSheet(0).getRow(headerCol)) {
            if (cell.getCol() < rangeModel.getX_start() || cell.getCol() > rangeModel.getX_end() || cell.getEXTColNumber().isEmpty()) continue;
            headCols.add(cell.getEXTColNumber());
            headColIndexs.add(cell.getCol());
        }
        Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems(headCols, (long)this.modelId);
        for (EDRow edRow : rows) {
            boolean isDataFromRPT = true;
            if (edRow.getSpkId() != null && !edRow.getSpkId().startsWith("_")) {
                isDataFromRPT = false;
            }
            for (int i = 0; i < headCols.size(); ++i) {
                DynamicObject dimDy;
                Map<String, String> membermsg;
                Map<String, Map<String, String>> mems;
                DimMember member;
                String colNum = (String)headCols.get(i);
                int colIndex = (Integer)headColIndexs.get(i);
                Object originalValue = edRow.getOriginalValue(colNum);
                Cell cell = this.sm.getBook().getSheet(0).getCell(row, colIndex);
                cell.clearMembersOfUserObject();
                cell.getUserObject().put((Object)"extrowpkid", (Object)edRow.getPkId());
                if (isDataFromRPT) {
                    cell.getUserObject().put((Object)"extrowSpkid", (Object)"1");
                }
                if (colNum.equals(DimEntityNumEnum.ENTITY.getNumber())) {
                    Map<String, String> membermsg2;
                    PositionInfo.FloatMemDisplayPattern display = this.floatDisplayPattern != null ? this.floatDisplayPattern : (PositionInfo.FloatMemDisplayPattern)dimNum2DisplayEnums.get(colNum);
                    Map<String, Map<String, String>> mems2 = result.get(colNum);
                    if (mems2 == null || (membermsg2 = mems2.get(originalValue)) == null) continue;
                    member = new DimMember(membermsg2.get("name"), membermsg2.get("number"), membermsg2.get("simplename"), (IDimension)new Dimension("", DimEntityNumEnum.ENTITY.getNumber(), null));
                    cell.addDim2UserObject((IDimMember)member);
                    cell.setValue((Object)cell.displayDimMsg(display.getIndex()));
                    continue;
                }
                cell.setValue(originalValue);
                if (fDimNumSets.contains(colNum)) {
                    mems = result.get(colNum);
                    membermsg = mems.get(originalValue);
                    if (membermsg == null) continue;
                    member = new DimMember(membermsg.get("name"), membermsg.get("number"), membermsg.get("simplename"), (IDimension)floatDimNums.get(fDimNums.indexOf(colNum)));
                    cell.addDim2UserObject((IDimMember)member);
                    PositionInfo.FloatMemDisplayPattern display = this.floatDisplayPattern != null ? this.floatDisplayPattern : (PositionInfo.FloatMemDisplayPattern)dimNum2DisplayEnums.get(colNum);
                    cell.setValue((Object)cell.displayDimMsg(display.getIndex()));
                }
                if (!multiF7ValueByExtMems.containsKey(colNum) || (mems = result.get(colNum)) == null || (membermsg = mems.get(originalValue)) == null || (dimDy = ((MultiF7Results)multiF7ValueByExtMems.get(colNum)).getDimDy()) == null) continue;
                String memberModel = dimDy.getString("memberModel");
                String dimNum = dimDy.getString("number");
                String dimName = dimDy.getString("name");
                Dimension dimension = new Dimension(dimName, dimNum, memberModel);
                member = new DimMember(membermsg.get("name"), membermsg.get("number"), membermsg.get("simplename"), (IDimension)dimension);
                cell.addDim2UserObject((IDimMember)member);
                cell.setValue((Object)cell.displayDimMsg(this.positionInfo.getExtendInfo().getExt2DisplayPattern(colNum).getIndex()));
            }
            ++row;
        }
    }

    public static Map<String, Map<String, Map<String, String>>> collectMemMsg(List<EDRow> rows, List<String> fDimNums, long modelId, Map<String, String> extCol2dimNum) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>(16);
        HashMap dimnums = new HashMap(fDimNums.size());
        for (String string : fDimNums) {
            dimnums.put(string, new HashSet(16));
        }
        for (EDRow eDRow : rows) {
            for (Map.Entry entry : dimnums.entrySet()) {
                String numbernum = eDRow.getString((String)entry.getKey());
                ((Set)entry.getValue()).add(numbernum);
            }
        }
        for (Map.Entry entry : dimnums.entrySet()) {
            String dimnum = (String)entry.getKey();
            if (extCol2dimNum.containsKey(dimnum)) {
                dimnum = extCol2dimNum.get(dimnum);
            }
            QFilter qf = new QFilter("number", "in", entry.getValue());
            QFilter qfmodel = new QFilter("model", "=", (Object)modelId);
            if (DimensionUtil.isUserDefinedDim(dimnum)) {
                qfmodel.and("dimension.number", "=", (Object)dimnum);
            }
            HashMap map = new HashMap(16);
            for (DynamicObject obj : BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimnum), (String)"name,number,simplename", (QFilter[])new QFilter[]{qf, qfmodel}).values()) {
                String name = obj.getString("name");
                String number = obj.getString("number");
                String simplename = obj.getString("simplename");
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("name", name);
                msg.put("number", number);
                msg.put("simplename", simplename);
                map.put(number, msg);
            }
            result.put((String)entry.getKey(), map);
        }
        return result;
    }

    private List<Map<String, Object>> clearExtMemberAndValue(List<String> extNumber) {
        TemplateScanMemberService service = new TemplateScanMemberService(this.sm, this.templateModel);
        Set<Point> points = service.getFloatFirst(this.sm);
        String areaRange = this.positionInfo.getAreaRange();
        List<Object> delData = new ArrayList(16);
        String originalAreaRange = this.positionInfo.getOriginalAreaRange();
        RangeModel rangeModel = new RangeModel(areaRange);
        RangeModel originalRangeModel = new RangeModel(originalAreaRange);
        if (originalRangeModel.getRowSize() < rangeModel.getRowSize()) {
            delData = IntStream.range(rangeModel.getY_start() + 1, rangeModel.getY_end() + 1).boxed().collect(Collectors.toList());
            if (rangeModel.getRowSize() - delData.size() < originalRangeModel.getRowSize()) {
                int repairRowSum = rangeModel.getRowSize() - originalRangeModel.getRowSize();
                delData = new ArrayList<Object>(delData.subList(delData.size() - repairRowSum, delData.size()));
            }
            ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
            cache.add(new AutoFloatLogicImpl.FloatArea(areaRange, 0, false, originalAreaRange, this.positionInfo.getAreaRange(), delData));
            ThreadCache.put((Object)floatarea, cache);
            AskExcuteInfo excuteinfo = new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, delData);
            if (this.viewHandle != null) {
                this.adjustSheetModelAndJs(excuteinfo);
            }
        }
        RangeModel areaRangModel = SpreadAreaUtil.getRangModel((String)this.positionInfo.getAreaRange());
        String realRange = ExcelUtils.xy2Pos((int)areaRangModel.getX_start(), (int)areaRangModel.getY_start()) + ":" + ExcelUtils.xy2Pos((int)areaRangModel.getX_end(), (int)areaRangModel.getY_end());
        List<Map<String, Object>> cellValues = this.collectCell(points, SpreadAreaUtil.getRangModel((String)realRange), extNumber);
        return cellValues;
    }

    private List<Map<String, Object>> collectCell(Set<Point> points, RangeModel rangeModel, List<String> floatnumber) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        for (int rowIndex = rangeModel.getY_start(); rowIndex <= rangeModel.getY_end(); ++rowIndex) {
            for (int colIndex = rangeModel.getX_start(); colIndex <= rangeModel.getX_end(); ++colIndex) {
                Cell cell = this.sm.getBook().getSheet(0).getCell(rowIndex, colIndex);
                Point point = new Point(cell.getCol(), cell.getRow());
                cell.setValue(null);
                cell.removeUserObject("extrowpkid");
                cell.removeUserObject("extrowSpkid");
                cell.setChangeVal(false);
                HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                e.put("v", null);
                cellValues.add(e);
                cell.setMdDataDomain(false);
                if (points.contains(point)) {
                    List userObject = cell.getMemberFromUserObject();
                    if (null == userObject) continue;
                    Iterator iterator = userObject.iterator();
                    while (iterator.hasNext()) {
                        IDimMember dimMember = (IDimMember)iterator.next();
                        if (!floatnumber.contains(dimMember.getDimension().getNumber())) continue;
                        iterator.remove();
                    }
                    continue;
                }
                cell.clearMembersOfUserObject();
            }
        }
        return cellValues;
    }

    public void adjustSheetModelAndJs(AskExcuteInfo excuteinfo) {
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo);
    }

    private void adjustPositonInfo(AskExcuteInfo excuteinfo) {
        List matchbaseinfos = (List)ThreadCache.get((Object)MATCHEXTWITHROWCOL, () -> this.matchBasePositonWithOperationdata(false, excuteinfo));
        matchbaseinfos.forEach(matchbaseinfo -> {
            PositionInfo currentPositinfo = matchbaseinfo.getPositioninfo();
            if (currentPositinfo != null && this.viewHandle != null && this.viewHandle.getView() != null) {
                MarkSpecialCell.markSpecialCells(currentPositinfo, false, this.viewHandle.getView(), this.viewHandle.getSpreadKey());
            }
        });
        for (PositionInfo posInfo : this.sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null || this.viewHandle.getView() == null) continue;
            MarkSpecialCell.markSpecialCells(posInfo, false, this.viewHandle.getView(), this.viewHandle.getSpreadKey());
        }
        this.returndatatoView(excuteinfo);
        boolean deleteOrAdd = excuteinfo.getMethod() == RowColExcuteEnum.DELETECOL || excuteinfo.getMethod() == RowColExcuteEnum.DELETEROW;
        excuteinfo.getOperationdata().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.intValue(), excuteinfo.getOperation(), deleteOrAdd ? -1 : 1);
            adjust.setCheck(excuteinfo.isCheck());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
        excuteinfo.getBatchOperationData().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.getOprtPosition(), excuteinfo.getOperation(), dealdata.getSize() * (deleteOrAdd ? -1 : 1));
            adjust.setCheck(excuteinfo.isCheck());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
        matchbaseinfos.forEach(matchbaseinfo -> {
            PositionInfo currentPositinfo = matchbaseinfo.getPositioninfo();
            if (currentPositinfo != null && this.viewHandle != null && this.viewHandle.getView() != null) {
                MarkSpecialCell.markSpecialCells(currentPositinfo, true, this.viewHandle.getView(), this.viewHandle.getSpreadKey());
            }
        });
        for (PositionInfo posInfo : this.sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null || this.viewHandle == null || this.viewHandle.getView() == null) continue;
            MarkSpecialCell.markSpecialCells(posInfo, true, this.viewHandle.getView(), this.viewHandle.getSpreadKey());
        }
    }

    private void returndatatoView(AskExcuteInfo excuteinfo) {
        if (this.viewHandle != null && this.viewHandle.getView() != null) {
            SpreadBasePlugin.updateRowAndCol2View(this.viewHandle.getViewProxy(), this.viewHandle.getSpreadKey(), excuteinfo);
        }
    }

    private List<AbstractMultiReportPlugin.MatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, AskExcuteInfo excuteinfo) {
        List operationdata = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(excuteinfo.getOperationdata()));
        return this.matchBasePositonWithOperationdata(operationdata);
    }

    private List<AbstractMultiReportPlugin.MatchBaseInfo> matchBasePositonWithOperationdata(List<Integer> operationdata) {
        ArrayList<AbstractMultiReportPlugin.MatchBaseInfo> matchbaseinfos = new ArrayList<AbstractMultiReportPlugin.MatchBaseInfo>();
        this.sm.getAreaManager().getPostionInfoSet().forEach(position -> {
            AbstractMultiReportPlugin.MatchBaseInfo matchbaseinfo = new AbstractMultiReportPlugin.MatchBaseInfo((PositionInfo)position, null, (List<Integer>)new ArrayList<Integer>());
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)position.getAreaRange());
            Iterator dataiterator = operationdata.iterator();
            while (dataiterator.hasNext()) {
                Integer data = (Integer)dataiterator.next();
                if (data >= rangemodel.getY_start() && data <= rangemodel.getY_end()) {
                    matchbaseinfo.getRowOrcols().add(data);
                    dataiterator.remove();
                }
                if (rangemodel.getY_start() != rangemodel.getY_end()) continue;
                matchbaseinfo.setOnlyOneRowCol(true);
            }
            if (!matchbaseinfo.getRowOrcols().isEmpty()) {
                matchbaseinfos.add(matchbaseinfo);
            }
        });
        matchbaseinfos.add(new AbstractMultiReportPlugin.MatchBaseInfo(null, null, operationdata));
        ThreadCache.put((Object)MATCHEXTWITHROWCOL, matchbaseinfos);
        return matchbaseinfos;
    }

    public Integer insertRank(int start2insert, int num, String range, boolean isCol) {
        int i;
        RangeModel rangeModel;
        ArrayList<Integer> insertdata = new ArrayList<Integer>();
        boolean ischeck = true;
        if (StringUtils.isNotEmpty((String)range)) {
            rangeModel = new RangeModel(range);
            int beginindex = isCol ? rangeModel.getX_start() : rangeModel.getY_start();
            int endindex = isCol ? rangeModel.getX_end() : rangeModel.getY_end();
            int hasDataRowCount = ExtDataHandleService.getHasDataRowMaxCount((SpreadManager)this.sm, (PositionInfo)this.positionInfo);
            int lasBlankRowCount = rangeModel.getRowSize() - hasDataRowCount;
            if (ThreadCache.get((Object)"firstopen") != null) {
                if (hasDataRowCount > num) {
                    return 0;
                }
                if (num >= lasBlankRowCount) {
                    ++num;
                }
                num -= lasBlankRowCount;
            } else {
                if (num >= lasBlankRowCount) {
                    ++num;
                }
                int n = num = endindex < start2insert ? num : num - lasBlankRowCount;
            }
            if (start2insert == beginindex || start2insert == endindex) {
                ArrayList<Integer> tem = new ArrayList<Integer>();
                tem.add(start2insert);
                if (start2insert == beginindex) {
                    ++start2insert;
                }
                AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, tem);
                ThreadCache.put((Object)MATCHEXTWITHROWCOL, this.matchBasePositonWithOperationdata(isCol, excuteinfo));
                ischeck = false;
            }
        }
        if (num > 0) {
            rangeModel = new RangeModel(range);
            int endindex = isCol ? rangeModel.getX_end() : rangeModel.getY_end();
            int startInsertIndex = endindex < start2insert ? endindex : start2insert;
            for (i = 0; i < num; ++i) {
                insertdata.add(startInsertIndex);
            }
        }
        AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCheck(ischeck);
        excuteinfo.setCon(true);
        if (StringUtils.isNotEmpty((String)range)) {
            this.adjustInsertIndex(excuteinfo, range);
        }
        if (excuteinfo.getOperationdata().size() > 1) {
            AskExcuteInfo.BatchOperationList batch = new AskExcuteInfo.BatchOperationList();
            batch.addBatchOperationInfo(excuteinfo.getOperationdata().get(0), excuteinfo.getOperationdata().size());
            excuteinfo.getOperationdata().clear();
            excuteinfo.setBatchOperateData(batch);
        }
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo);
        if (!excuteinfo.getOperationdata().isEmpty()) {
            RangeModel rangeModel2 = new RangeModel(this.positionInfo.getAreaRange());
            if (this.viewHandle != null && this.viewHandle.getViewProxy() != null) {
                ArrayList cellValues = new ArrayList(rangeModel2.getX_start() + rangeModel2.getColSize());
                for (i = rangeModel2.getX_start(); i < rangeModel2.getX_start() + rangeModel2.getColSize(); ++i) {
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", rangeModel2.getY_end());
                    e.put("c", i);
                    e.put("v", null);
                    cellValues.add(e);
                }
                this.viewHandle.invokeUpdataValueMethod(cellValues);
            }
        }
        return num;
    }

    private void adjustInsertIndex(AskExcuteInfo excuteinfo, String range) {
        int start;
        if (RowColExcuteEnum.DELETECOL == excuteinfo.getMethod() || RowColExcuteEnum.DELETEROW == excuteinfo.getMethod()) {
            return;
        }
        String startPoint = range.split(":")[0];
        int n = start = RowColExcuteEnum.INSERTCOL == excuteinfo.getMethod() ? ExcelUtils.pos2X((String)startPoint) : ExcelUtils.pos2Y((String)startPoint);
        if (excuteinfo.getOperationdata().size() == 1 && excuteinfo.getOperationdata().get(0) == start) {
            excuteinfo.getOperationdata().clear();
            excuteinfo.getOperationdata().add(start);
        }
    }

    public static List<LinkedHashMap<String, Object>> pasteExtFloatMember(long modelId, SpreadManager spread, NotifyEvent mulevt) {
        SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
        LinkedHashMap first = (LinkedHashMap)data.getValues().get(0);
        Integer pasterow = (Integer)first.get("r");
        Integer pastecol = (Integer)first.get("c");
        boolean hasvalue = false;
        for (LinkedHashMap map : data.getValues()) {
            if (map.get("v") == null) continue;
            hasvalue = true;
            break;
        }
        if (!hasvalue) {
            return null;
        }
        PositionInfo posInfo = spread.getInAreaPositionByRow(pasterow.intValue(), pastecol.intValue());
        if (posInfo.getExtendInfo() == null) {
            return null;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String sceneNum = spread.getFilter().getCommonFilterNum(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = spread.getFilter().getCommonFilterNum(DimTypesEnum.YEAR.getNumber());
        String periodNum = spread.getFilter().getCommonFilterNum(DimTypesEnum.PERIOD.getNumber());
        long sceneId = MemberReader.findScenaMemberByNum((String)modelNum, (String)sceneNum).getId();
        long yearId = MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum).getId();
        long periodId = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum).getId();
        VersionParam verParam = new VersionParam(modelId, sceneId, yearId, periodId);
        ArrayList<LinkedHashMap> values = new ArrayList<LinkedHashMap>(16);
        ArrayList<LinkedHashMap<String, Object>> clearvalues = new ArrayList<LinkedHashMap<String, Object>>(16);
        for (LinkedHashMap map : data.getValues()) {
            Integer r = (Integer)map.get("r");
            Integer c = (Integer)map.get("c");
            String col_headDim = spread.getExtHeadCol2(r.intValue(), c.intValue());
            MultiF7Results multiF7ValueByExtMem = TemplateFloatUtil.getExtNumWithDim(modelId, col_headDim);
            DynamicObject dimDy = multiF7ValueByExtMem.getDimDy();
            ArrayList<DynaMembScopeInfo> scope = new ArrayList<DynaMembScopeInfo>(16);
            if (dimDy != null) {
                scope.addAll(TemplateFloatUtil.getDynaMembScopeInfos(multiF7ValueByExtMem));
            } else {
                List scopeInfos = posInfo.getExtendInfo().getFloatMemberScope(col_headDim);
                if (scopeInfos != null) {
                    scope.addAll(scopeInfos);
                }
            }
            if (scope == null || scope.isEmpty()) {
                values.add(map);
                continue;
            }
            Set numbers = (Set)BcmThreadCache.get((Object)"extscope", (Object)posInfo.getOriginalAreaRange(), (Object)col_headDim, () -> {
                HashSet ns = new HashSet();
                for (DynaMembScopeInfo scinfo : scope) {
                    MembRangeItem membRangeItem = new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(((DimMember)scinfo.getMember()).getId()), scinfo.getMember().getNumber(), scinfo.getRangeId(), scinfo.isCustom(), (Object)modelId);
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(scinfo.getMember().getDimension().getNumber())) {
                        membRangeItem.matchItem4Ic(verParam, m -> ns.add(m.number));
                        continue;
                    }
                    membRangeItem.matchItems(m -> ns.add(m.number));
                }
                return ns;
            });
            Set name_nums = new HashSet(16);
            PositionInfo.FloatMemDisplayPattern floatMemberDisplay = posInfo.getExtendInfo().getExt2DisplayPattern(col_headDim);
            if (dimDy != null) {
                ExtendInfo extendInfo = posInfo.getExtendInfo();
                floatMemberDisplay = extendInfo.getExt2DisplayPattern(col_headDim);
            }
            if (floatMemberDisplay == PositionInfo.FloatMemDisplayPattern.NAME) {
                name_nums = (Set)ThreadCache.get((Object)(posInfo.getAreaRange() + col_headDim + modelId), () -> {
                    Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)(dimDy == null ? col_headDim : dimDy.getString("number"))), (Object)modelId);
                    return allNodeFromCache.values().stream().filter(f -> numbers.contains(f.getNumber())).map(d -> d.getName()).collect(Collectors.toSet());
                });
            } else if (floatMemberDisplay == PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER) {
                name_nums = (Set)ThreadCache.get((Object)(posInfo.getAreaRange() + col_headDim + modelId), () -> {
                    Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)(dimDy == null ? col_headDim : dimDy.getString("number"))), (Object)modelId);
                    return allNodeFromCache.values().stream().filter(f -> numbers.contains(f.getNumber())).map(d -> d.getNumber() + "|" + d.getName()).collect(Collectors.toSet());
                });
            }
            if (numbers.contains(map.get("v")) || name_nums.contains(map.get("v"))) {
                values.add(map);
                continue;
            }
            map.put("v", null);
            clearvalues.add(map);
        }
        data.getValues().clear();
        data.getValues().addAll(values);
        return clearvalues;
    }

    public PositionInfo.FloatMemDisplayPattern getFloatDisplayPattern() {
        return this.floatDisplayPattern;
    }

    public void setFloatDisplayPattern(PositionInfo.FloatMemDisplayPattern floatDisplayPattern) {
        this.floatDisplayPattern = floatDisplayPattern;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public class ExtReportModelCacheManager {
        Map<String, String> originRange2CacheId = new HashMap<String, String>(16);
        Map<String, Integer> originRange2Cursors = new HashMap<String, Integer>(16);
        Map<String, Map<String, String>> orgtemp2ModelNum2CacheId = new HashMap<String, Map<String, String>>(16);
        Map<String, Map<String, Integer>> orgtemp2originRange2Cursors = new HashMap<String, Map<String, Integer>>(16);
        IPageCache pageCache;
        OrgRelaMembSupplier orgSupplier;

        public ExtReportModelCacheManager(IPageCache pageCache, OrgRelaMembSupplier orgSupplier) {
            this.pageCache = pageCache;
            this.orgSupplier = orgSupplier;
        }

        private void initCache() {
            String seriaStr1 = this.pageCache.get(ExtReportModelHandle.DATAMODEL2DATASETCACHEID);
            String seriaStr2 = this.pageCache.get(ExtReportModelHandle.ORIGINRANGE2CURSORS);
            if (StringUtils.isNotEmpty((String)seriaStr1)) {
                this.orgtemp2ModelNum2CacheId = (Map)SerializationUtils.fromJsonString((String)seriaStr1, Map.class);
                this.originRange2CacheId = this.orgtemp2ModelNum2CacheId.get(ExtReportModelHandle.this.templateModel.getId() + "" + this.orgSupplier.get_mainOrgId());
                if (this.originRange2CacheId != null) {
                    ThreadCache.put((Object)ExtReportModelHandle.DATAMODEL2DATASETCACHEID, this.originRange2CacheId);
                }
            }
            if (StringUtils.isNotEmpty((String)seriaStr2)) {
                this.orgtemp2originRange2Cursors = (Map)SerializationUtils.fromJsonString((String)seriaStr2, Map.class);
                this.originRange2Cursors = this.orgtemp2originRange2Cursors.get(ExtReportModelHandle.this.templateModel.getId() + "" + this.orgSupplier.get_mainOrgId());
                if (this.originRange2Cursors != null) {
                    ThreadCache.put((Object)ExtReportModelHandle.ORIGINRANGE2CURSORS, this.originRange2Cursors);
                }
            }
        }

        public void cacheDataModelDataSetInfo(List<ExtDataHandleService.DataModelDataSetInfo> dataSetInfos) {
            if (this.originRange2CacheId != null) {
                this.originRange2CacheId.putAll(ExtDataHandleService.transDataSetInfo2DataModelNumCacheId(dataSetInfos));
            } else {
                this.originRange2CacheId = ExtDataHandleService.transDataSetInfo2DataModelNumCacheId(dataSetInfos);
            }
            if (this.originRange2Cursors != null) {
                this.originRange2Cursors.putAll(ExtDataHandleService.transDataSetInfo2OriginRange2Cursors(dataSetInfos));
            } else {
                this.originRange2Cursors = ExtDataHandleService.transDataSetInfo2OriginRange2Cursors(dataSetInfos);
            }
            this.cacheDataSetCacheIdAndCursor();
        }

        public void closeRangeDataSet(String originRange) {
            DataSetUtil.close((String)this.originRange2CacheId.get(originRange));
            this.originRange2CacheId.remove(originRange);
            this.originRange2Cursors.remove(originRange);
        }

        public void cacheDataSetCacheIdAndCursor() {
            this.orgtemp2ModelNum2CacheId.put(ExtReportModelHandle.this.templateModel.getId() + "" + this.orgSupplier.get_mainOrgId(), this.originRange2CacheId);
            this.orgtemp2originRange2Cursors.put(ExtReportModelHandle.this.templateModel.getId() + "" + this.orgSupplier.get_mainOrgId(), this.originRange2Cursors);
            this.pageCache.put(ExtReportModelHandle.DATAMODEL2DATASETCACHEID, SerializationUtils.toJsonString(this.orgtemp2ModelNum2CacheId));
            this.pageCache.put(ExtReportModelHandle.ORIGINRANGE2CURSORS, SerializationUtils.toJsonString(this.orgtemp2originRange2Cursors));
        }
    }
}

