/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.extreport;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;

public class ExtReportViewHandle {
    IClientViewProxy viewProxy;
    String spreadKey;
    IFormView view;
    IPageCache pageCache;
    AbstractMultiReportPlugin plugin;

    public ExtReportViewHandle() {
    }

    public ExtReportViewHandle(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public ExtReportViewHandle(IClientViewProxy viewProxy, String spreadKey, IFormView view) {
        this.viewProxy = viewProxy;
        this.spreadKey = spreadKey;
        this.view = view;
    }

    public void setExtPosF7Style(Long modelId, SpreadManager sm) {
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null) continue;
            int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
            int endRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[1]);
            int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            ArrayList<String> headCols = new ArrayList<String>(16);
            ArrayList<Integer> headColIndexs = new ArrayList<Integer>(16);
            for (Cell cell : sm.getBook().getSheet(0).getRow(headerCol)) {
                if (cell.getEXTColNumber().isEmpty()) continue;
                headCols.add(cell.getEXTColNumber());
                headColIndexs.add(cell.getCol());
            }
            List mddColDims = posInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension().getNumber()).collect(Collectors.toList());
            Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems(headCols, (long)modelId);
            Map extMemberForEnumType = ExtDimensionHelper.getExtMemberForEnumType((Long)modelId, (String)posInfo.getExtendInfo().getExtGroup(), headCols);
            for (int i = 0; i < headCols.size(); ++i) {
                int rc = endRowIndex - startRowIndex + 1;
                String headCol = (String)headCols.get(i);
                if (mddColDims.contains(headCol)) {
                    this.invokeJsSetF7TypeCellMethod(startRowIndex, (Integer)headColIndexs.get(i), rc, 1, 0, 0, false);
                }
                if (extMemberForEnumType.containsKey(headCol)) {
                    String mapped = ((DynamicObject)extMemberForEnumType.get(headCol)).getString("fieldmapped");
                    HashMap userObject = Maps.newHashMap();
                    userObject.put("number", headCol);
                    userObject.put("mapped", mapped);
                    userObject.put("extGroup", posInfo.getExtendInfo().getExtGroup());
                    String userObjectStr = ObjectSerialUtil.toByteSerialized((Object)userObject);
                    sm.getBook().getSheet(0).getCell(headerCol, ((Integer)headColIndexs.get(i)).intValue()).setUserObject("extdim_cell_enumtype", (Object)userObjectStr);
                    boolean isDate = mapped.contains("dateext") ? Boolean.TRUE : Boolean.FALSE;
                    this.invokeJsSetF7TypeCellMethod(startRowIndex, (Integer)headColIndexs.get(i), rc, 1, 0, 1, isDate);
                }
                if (!multiF7ValueByExtMems.containsKey(headCol)) continue;
                this.invokeJsSetF7TypeCellMethod(startRowIndex, (Integer)headColIndexs.get(i), rc, 1, 0, 0, false);
            }
        }
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null) continue;
            MarkSpecialCell.markSpecialCells(posInfo, false, this.getView(), this.spreadKey);
        }
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null) continue;
            MarkSpecialCell.markSpecialCells(posInfo, true, this.getView(), this.spreadKey);
        }
    }

    public void lockExtSourceCols(SpreadManager sm) {
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            Object cell2;
            if (posInfo.getExtendInfo() == null) continue;
            int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
            int endRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[1]);
            int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            Integer sourceOrgIndex = -1;
            for (Object cell2 : sm.getBook().getSheet(0).getRow(headerCol)) {
                if (cell2.getEXTColNumber().isEmpty() || !cell2.getEXTColNumber().equals(DimTypesEnum.ENTITY.getNumber())) continue;
                sourceOrgIndex = cell2.getCol();
                break;
            }
            if (sourceOrgIndex == -1) continue;
            ArrayList<Object> cells = new ArrayList<Object>();
            cell2 = new HashMap();
            cell2.put(SpreadProperties.LockCellMethod.R.k(), startRowIndex);
            cell2.put(SpreadProperties.LockCellMethod.C.k(), sourceOrgIndex);
            cell2.put(SpreadProperties.LockCellMethod.RC.k(), endRowIndex - startRowIndex + 1);
            cell2.put(SpreadProperties.LockCellMethod.CC.k(), 1);
            cells.add(cell2);
            SpreadClientInvoker.invokeLockCellMethod(this.viewProxy, this.spreadKey, cells);
        }
    }

    public Pair<String, List<Integer>> lockStageLockCols(SpreadManager sm, boolean isBuildCommand) {
        boolean isHasLockDim;
        if (this.getPlugin() == null) {
            return Pair.onePair((Object)"", new ArrayList(16));
        }
        String dimNum = LockScopeServiceHelper.getLockDimNumber_HasEmpty((long)this.getPlugin().getModelId());
        boolean bl = isHasLockDim = !dimNum.isEmpty() && !IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(dimNum);
        if (!isHasLockDim) {
            return Pair.onePair((Object)"", new ArrayList(16));
        }
        if (!sm.hasExtArea()) {
            return Pair.onePair((Object)"", new ArrayList(16));
        }
        String sceneNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.YEAR.getNumber());
        String periodNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.PERIOD.getNumber());
        String orgNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.ENTITY.getNumber());
        String bpNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.PROCESS.getNumber());
        IDNumberTreeNode orgTreeNode = MemberReader.findMemberByNumber((String)this.getPlugin().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNum);
        String cyNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.CURRENCY.getNumber());
        cyNum = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)this.getPlugin().getModelId(), (long)orgTreeNode.getId().longValue(), (String)bpNum, (String)cyNum, (long)0L, (long)0L).p2;
        HashSet years = Sets.newHashSet((Object[])new String[]{yearNum});
        HashSet periods = Sets.newHashSet((Object[])new String[]{periodNum});
        HashSet cys = Sets.newHashSet((Object[])new String[]{cyNum});
        LockScope lockScope = LockScopeServiceHelper.queryLockScope((long)this.getPlugin().getModelId(), (String)sceneNum, (Set)years, (Set)periods, (Set)cys);
        ArrayList<Integer> lockRows = new ArrayList<Integer>(16);
        String lockname = "";
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (posInfo.getExtendInfo() == null || !posInfo.getExtendInfo().getFloatDimNums().contains(dimNum)) continue;
            RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
            int startRowIndex = rangeModel.getY_start();
            int endRowIndex = rangeModel.getY_end();
            int startColIndex = rangeModel.getX_start();
            int headerRow = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            ArrayList cells = new ArrayList();
            Integer lockDimIndex = -1;
            for (Cell cell : sm.getBook().getSheet(0).getRow(headerRow)) {
                if (cell.getEXTColNumber().isEmpty() || !cell.getEXTColNumber().equals(dimNum)) continue;
                lockDimIndex = cell.getCol();
                break;
            }
            if (lockDimIndex != -1) {
                for (int i = startRowIndex; i <= endRowIndex; ++i) {
                    boolean islock;
                    Cell cell;
                    cell = sm.getBook().getSheet(0).getCell(i, lockDimIndex.intValue());
                    if (cell.getNotNullMemberUserObject().isEmpty()) continue;
                    String lockDimMemb = ((IDimMember)cell.getNotNullMemberUserObject().get(0)).getNumber();
                    Pair lock = lockScope.isLock(yearNum, periodNum, cyNum, orgTreeNode.getNumber(), lockDimMemb);
                    boolean bl2 = islock = (Boolean)lock.p1 != false && lock.p2 != null && !((List)lock.p2).isEmpty();
                    if (!islock) continue;
                    if (isBuildCommand) {
                        HashMap<String, Integer> cellMap = new HashMap<String, Integer>();
                        cellMap.put(SpreadProperties.LockCellMethod.R.k(), cell.getRow());
                        cellMap.put(SpreadProperties.LockCellMethod.C.k(), startColIndex);
                        cellMap.put(SpreadProperties.LockCellMethod.RC.k(), 1);
                        cellMap.put(SpreadProperties.LockCellMethod.CC.k(), rangeModel.getColSize());
                        cells.add(cellMap);
                    }
                    lockname = (String)((Pair)((List)lock.p2).get((int)0)).p1;
                    lockRows.add(cell.getRow());
                }
            }
            if (!isBuildCommand) continue;
            SpreadClientInvoker.invokeLockCellMethod(this.viewProxy, this.spreadKey, cells);
        }
        return Pair.onePair((Object)lockname, lockRows);
    }

    public void invokeUpdataValueMethod(Object parameters) {
        SpreadClientInvoker.invokeUpdataValueMethod(this.viewProxy, this.spreadKey, parameters);
    }

    public void invokeJsSetF7TypeCellMethod(int r, int c, int rc, int cc, int selectType, int displayStyle, boolean isDate) {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>();
        ArrayList items = new ArrayList();
        HashMap<String, Integer> feature = new HashMap<String, Integer>();
        feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
        feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
        feature.put(SpreadProperties.SetF7TypeCellMethod.RC.k(), rc);
        feature.put(SpreadProperties.SetF7TypeCellMethod.CC.k(), cc);
        items.add(feature);
        features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
        features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(displayStyle));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.getViewProxy(), this.spreadKey, features);
        if (!isDate) {
            this.setStringStyle(r, c, rc, cc);
        }
    }

    public void setStringStyle(int r, int c, int rc, int cc) {
        SpreadEasyInvoker in = new SpreadEasyInvoker(this.getViewProxy(), this.spreadKey);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), "@");
        in.setStyle(r, c, rc, cc, styleMap);
    }

    public IClientViewProxy getViewProxy() {
        return this.viewProxy;
    }

    public void setViewProxy(IClientViewProxy viewProxy) {
        this.viewProxy = viewProxy;
    }

    public String getSpreadKey() {
        return this.spreadKey;
    }

    public void setSpreadKey(String spreadKey) {
        this.spreadKey = spreadKey;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public AbstractMultiReportPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
    }

    public IPageCache getPageCache() {
        if (this.pageCache == null) {
            return this.getView().getPageCache();
        }
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }
}

