/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.DimGroupKey;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MemberGroupKey;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.floatreport.BlockFloatNode;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.HideLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.OffsetLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.ResultPage;
import kd.fi.bcm.formplugin.report.floatreport.ResultPageManager;
import kd.fi.bcm.formplugin.report.formula.ReportFormulaUtil;
import kd.fi.bcm.formplugin.report.style.adjust.FloatDataProvider;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AutoFloatLogicImpl {
    public static boolean isRev = true;
    private static final String MatchBaseInfoWithRowCol = "matchbaseinfowithrowcol";
    private AbstractMultiReportPlugin plugin;
    private AbstractBaseFormPlugin abplugin;
    private TemplateModel templateModel;
    private IFormView view;
    private String spread_key;
    public static final String autoflaot_key = "autoflaot_key";
    private SpreadManager sm;
    private List<Map<String, Object>> cellValues;
    private Map<String, Map<String, Map<String, String>>> result;
    private List<Row> rowslimitfix;
    private PositionInfo positionInfo;
    private BasePointInfo basePointInfo;
    private IRelaMembSupplier<String, String> relaMembSupplier;
    private IRelaMembSupplier<String, String> periodSupplier;
    private long modelId;
    private long schemeId = 0L;
    private boolean isAlternateFloat = false;
    private HashMap<String, DataTypeAcctCacheInfo> dataTypeMap;
    private boolean isNextPage = false;
    private RangeModel nextRangeModel;
    private ResultPageManager resultPageManager;
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AutoFloatLogicImpl.class);
    private static final String CONFIG_NUM = "config_num";
    private List<Integer> deledata = new ArrayList<Integer>();
    private static final String MATCHBASEINFOWITHROWCOL = "matchbaseinfowithrowcol";

    public IFormView getView() {
        return this.view;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public AutoFloatLogicImpl(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
        this.sm = plugin.getSpreadModel();
    }

    public AutoFloatLogicImpl(AbstractMultiReportPlugin plugin, IFormView view, boolean isNextPage) {
        this.plugin = plugin;
        this.view = view;
        this.sm = plugin.getSpreadModel();
        this.isNextPage = isNextPage;
    }

    public AutoFloatLogicImpl(AbstractBaseFormPlugin plugin, SpreadManager sm, IFormView view, String spread_key, TemplateModel templateModel) {
        this.abplugin = plugin;
        this.sm = sm;
        this.view = view;
        this.spread_key = spread_key;
        this.templateModel = templateModel;
    }

    public void setRelaMembSupplier(IRelaMembSupplier<String, String> relaMembSupplier) {
        this.relaMembSupplier = relaMembSupplier;
    }

    public void setPeriodSupplier(IRelaMembSupplier<String, String> periodSupplier) {
        this.periodSupplier = periodSupplier;
        ReportSpecialVariableUtil.cachePeriodSupplier((SpreadManager)this.sm, periodSupplier);
    }

    private AbstractFormPlugin getPlugin() {
        if (this.plugin != null) {
            return this.plugin;
        }
        return this.abplugin;
    }

    private void clearNotExitMemberForFloat() {
        String modelNumber;
        final String templateNumber = modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        final HashMap<String, Map<String, Map<String, List<IDimMember>>>> notExitMember = new HashMap<String, Map<String, Map<String, List<IDimMember>>>>(16);
        this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.getBasePoints().forEach(basePointInfo -> {
            final String floatRange = basePointInfo.getDynaRange();
            basePointInfo.getBasePointInnerLineInfo().forEach(basePointInnerLineInfo -> {
                IDimMember memberAddOf;
                List membScopes = basePointInnerLineInfo.getDynaMembScopes();
                List newDynaMembScopes = membScopes.stream().filter(new Predicate<DynaMembScopeInfo>(){

                    @Override
                    public boolean test(DynaMembScopeInfo dynaMembScopeInfo) {
                        IDimMember member;
                        if (!dynaMembScopeInfo.isCustom() && (member = dynaMembScopeInfo.getMember()) != null) {
                            if (Arrays.stream(SystemVarsEnum.values()).anyMatch(e -> e.getNumber().equals(member.getNumber()))) {
                                return true;
                            }
                            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)member.getDimension().getNumber(), (String)member.getNumber());
                            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                                if (basePointInnerLineInfo.isFloated()) {
                                    TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, member, "floatmemtext", notExitMember, templateNumber);
                                } else {
                                    TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, member, "unfloatmem", notExitMember, templateNumber);
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                }).collect(Collectors.toList());
                if (newDynaMembScopes.size() != membScopes.size()) {
                    basePointInnerLineInfo.setDynaMembScopes(newDynaMembScopes);
                }
                if ((memberAddOf = basePointInnerLineInfo.getMemberAddOf()) != null && IDNumberTreeNode.NotFoundTreeNode == MemberReader.findMemberByNumber((String)modelNumber, (String)memberAddOf.getDimension().getNumber(), (String)memberAddOf.getNumber()) && !Arrays.stream(SystemVarsEnum.values()).anyMatch(e -> e.getNumber().equals(memberAddOf.getNumber()))) {
                    TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, memberAddOf, "newmembas", notExitMember, templateNumber);
                }
            });
        }));
        if (!notExitMember.isEmpty()) {
            this.getPlugin().getView().showTipNotification(TemplateFloatUtil.getTipsForNotExitMember(notExitMember, false), Integer.valueOf(7000));
        }
    }

    public void autoFloat(boolean isCsl, boolean isBase64, String orgNumber) {
        this.isAlternateFloat = AutoFloatUtil.isAlternateFloat(this.plugin == null ? this.templateModel : this.plugin.getTemplateModel());
        this.dataTypeMap = FloatLogicImpl.getAllDataType(this.getPlugin().getPageCache(), this.sm, this.getModelId());
        AbstractBaseFormPlugin currentPlugin = this.plugin == null ? this.abplugin : this.plugin;
        ResultPageManager.clearCache(currentPlugin.getPageCache());
        this.clearNotExitMemberForFloat();
        Map<String, MDResultSet> setmap = FloatDataProvider.queryMDResultSetMapByPageAndView(this.sm, this.getModelId(), this.isDirectHoriz(), this.relaMembSupplier, this.periodSupplier);
        this.cellValues = new ArrayList<Map<String, Object>>(10);
        Iterator<PositionInfo> iterator = FloatLogicImpl.sortPositionInfo(this.sm.getAreaManager().getPostionInfoSet(), this.isDirectHoriz()).iterator();
        while (iterator.hasNext()) {
            PositionInfo ps;
            this.positionInfo = ps = iterator.next();
            if (this.positionInfo.getBasePoints() == null || this.positionInfo.getBasePoints().isEmpty()) continue;
            Iterator<BasePointInfo> iterator2 = FloatLogicImpl.sortBasePoint(this.positionInfo.getBasePoints()).iterator();
            while (iterator2.hasNext()) {
                List<String> dmNumberLis;
                BasePointInfo bpi;
                this.basePointInfo = bpi = iterator2.next();
                ArrayList<String> floatnumber = new ArrayList<String>();
                if (this.basePointInfo.getTopSettingOrder() != null && !this.basePointInfo.getTopSettingOrder().isEmpty()) {
                    for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
                        if (!info.isFloated()) continue;
                        floatnumber.add(info.getDimension().getNumber());
                    }
                    this.clearFloatMemberAndValue(floatnumber);
                }
                if ((dmNumberLis = this.getDmNumberLis()) == null) continue;
                List<Row> rows = this.getRows(isCsl, setmap);
                if (rows.isEmpty() && this.isNoRecord(setmap, bpi) && !this.isBlankAreaNoCrossDimCell(bpi.getDataArea(ps))) {
                    this.clearNoValueRowOrCol();
                }
                AutoFloatUtil.fixBaseInfo(this.getModelId(), this.basePointInfo);
                ThreadCache.put((Object)autoflaot_key, (Object)"1");
                this.checkAndFloat(dmNumberLis, rows, currentPlugin.getPageCache());
            }
            this.clearUnExitMember(this.positionInfo);
        }
        if (isBase64) {
            SpreadClientInvoker.invokeUpdataValueMethod(currentPlugin.getClientViewProxy(), this.plugin == null ? this.spread_key : this.plugin.getSpreadKey(), this.cellValues);
        }
        if (this.resultPageManager != null) {
            this.resultPageManager.cacheManager(currentPlugin.getPageCache());
        }
    }

    public boolean isDirectHoriz() {
        return (Boolean)ThreadCache.get((Object)"floattype", () -> {
            for (PositionInfo positionInfo : this.sm.getAreaManager().getPostionInfoSet()) {
                if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
                return ((BasePointInfo)positionInfo.getBasePoints().get(0)).isDirectHoriz();
            }
            return false;
        });
    }

    public void nextPageFloat(boolean isBase64, int selRow, int selCol) {
        PositionInfo selPos = this.sm.getInAreaPositionByRow(selRow, selCol);
        if (selPos == null) {
            return;
        }
        Cell cell = new Cell();
        cell.setRowAndCol(selRow, selCol);
        BasePointInfo selBasePos = selPos.getBasePoint(cell);
        if (selBasePos == null) {
            selBasePos = this.sm.getInAreaBasePointInfoByXY(selRow, selCol);
        }
        if (selBasePos == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6d6e\u52a8\u6570\u636e\u533a\u57df\u7684\u5355\u5143\u683c\uff0c\u518d\u70b9\u51fb\u663e\u793a\u66f4\u591a\u6570\u636e\u6216\u663e\u793a\u5168\u90e8\u6570\u636e\u3002", (String)"AutoFloatLogicImpl_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.isAlternateFloat = AutoFloatUtil.isAlternateFloat(this.plugin == null ? this.templateModel : this.plugin.getTemplateModel());
        this.dataTypeMap = FloatLogicImpl.getAllDataType(this.getPlugin().getPageCache(), this.sm, this.getModelId());
        AbstractMultiReportPlugin currentPlugin = this.plugin;
        this.clearNotExitMemberForFloat();
        this.cellValues = new ArrayList<Map<String, Object>>(10);
        if (currentPlugin == null) {
            return;
        }
        Iterator<PositionInfo> iterator = FloatLogicImpl.sortPositionInfo(this.sm.getAreaManager().getPostionInfoSet(), FloatLogicImpl.isDirectHoriz(currentPlugin.getPageCache())).iterator();
        while (iterator.hasNext()) {
            PositionInfo ps;
            this.positionInfo = ps = iterator.next();
            if (this.positionInfo.getBasePoints() == null || this.positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo bpi : FloatLogicImpl.sortBasePoint(this.positionInfo.getBasePoints())) {
                if (!selBasePos.getOriginalDynaRange().equals(bpi.getOriginalDynaRange())) continue;
                this.basePointInfo = bpi;
                List<String> dmNumberLis = this.getDmNumberLis();
                if (dmNumberLis == null) continue;
                AutoFloatUtil.fixBaseInfo(this.getModelId(), this.basePointInfo);
                ThreadCache.put((Object)autoflaot_key, (Object)"1");
                this.checkAndFloat(dmNumberLis, new ArrayList<Row>(4), currentPlugin.getPageCache());
            }
            this.clearUnExitMember(this.positionInfo);
        }
        if (isBase64) {
            SpreadClientInvoker.invokeUpdataValueMethod(currentPlugin.getClientViewProxy(), this.plugin == null ? this.spread_key : this.plugin.getSpreadKey(), this.cellValues);
        }
        this.resultPageManager.cacheManager(this.getPageCache());
    }

    public static void clearNoDataRC(SpreadManager sm, AbstractMultiReportPlugin plugin) {
        boolean isDir = sm.isHorizon() == 1;
        for (PositionInfo ps : FloatLogicImpl.sortPositionInfo(sm.getAreaManager().getPostionInfoSet(), isDir)) {
            for (BasePointInfo basePointInfo : FloatLogicImpl.sortBasePoint(ps.getBasePoints())) {
                List<Integer> deledata = FloatLogicImpl.getHasMemNotValueRC_OutOriRange(sm, ps, basePointInfo);
                RangeModel range = new RangeModel(basePointInfo.getDynaRange());
                RangeModel oriRange = new RangeModel(basePointInfo.getOriginalDynaRange());
                int areaFloatSize = isDir ? range.getColSize() : range.getRowSize();
                int ori_AreaFloatSize = isDir ? oriRange.getColSize() : oriRange.getRowSize();
                if (deledata.isEmpty() || areaFloatSize == ori_AreaFloatSize && deledata.size() == areaFloatSize) continue;
                if (areaFloatSize == deledata.size() && areaFloatSize > 0) {
                    deledata.remove(0);
                }
                Sheet sheet = sm.getBook().getSheet(0);
                ArrayList lockxys = new ArrayList(16);
                if (isDir) {
                    int maxRow = sheet.getMaxRowCount();
                    for (Integer deledatum : deledata) {
                        sheet.iteratorRangeCells(new RangeModel(deledatum.intValue(), deledatum.intValue(), 0, maxRow - 1), true, c -> {
                            if (c.getUserObject("locked") != null && ((Boolean)c.getUserObject("locked")).booleanValue()) {
                                lockxys.add(c.getRow());
                            }
                        });
                    }
                } else {
                    int maxCol = sheet.getMaxColumnCount();
                    for (Integer deledatum : deledata) {
                        sheet.iteratorRangeCells(new RangeModel(0, maxCol - 1, deledatum.intValue(), deledatum.intValue()), true, c -> {
                            if (c.getUserObject("locked") != null && ((Boolean)c.getUserObject("locked")).booleanValue()) {
                                lockxys.add(c.getCol());
                            }
                        });
                    }
                }
                AskExcuteInfo excuteinfo = isDir ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
                SpreadDataModel.adjustSheet(excuteinfo, sm);
                plugin.adjustPositonInfo(excuteinfo);
                ArrayList<Integer> insertData = new ArrayList<Integer>(16);
                if (areaFloatSize - deledata.size() < ori_AreaFloatSize) {
                    RangeModel cur_range = new RangeModel(basePointInfo.getDynaRange());
                    int cur_areaFloatSize = isDir ? cur_range.getColSize() : cur_range.getRowSize();
                    int repairRowSum = ori_AreaFloatSize - cur_areaFloatSize;
                    int endIndex = isDir ? cur_range.getX_end() : cur_range.getY_end();
                    for (int i = 0; i < repairRowSum; ++i) {
                        insertData.add(endIndex);
                    }
                }
                if (insertData.isEmpty()) continue;
                AskExcuteInfo insertExcuteinfo = isDir ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertData) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertData);
                insertExcuteinfo.setRev(true);
                SpreadDataModel.adjustSheet(insertExcuteinfo, sm);
                plugin.adjustPositonInfo(insertExcuteinfo);
                for (Integer deledatum : deledata) {
                    RangeModel crange = new RangeModel(basePointInfo.getOriginalDynaRange());
                    if (isDir ? deledatum < crange.getX_start() || deledatum > crange.getX_end() : deledatum < crange.getY_start() || deledatum > crange.getY_end()) continue;
                    for (Integer lockxy : lockxys) {
                        if (isDir) {
                            sheet.getCell(lockxy.intValue(), deledatum.intValue()).setUserObject("locked", (Object)true);
                            continue;
                        }
                        sheet.getCell(deledatum.intValue(), lockxy.intValue()).setUserObject("locked", (Object)true);
                    }
                }
            }
        }
    }

    private void clearUnExitMember(PositionInfo positionInfo) {
        if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) {
            return;
        }
        boolean isH = ((BasePointInfo)positionInfo.getBasePoints().get(0)).isDirectHoriz();
        Tuple tu = this.sm.getAreaManager().getRowAndColDomainByPosition(positionInfo);
        HashMultimap map = HashMultimap.create();
        RangeModel pom = new RangeModel(positionInfo.getAreaRange());
        for (int x = pom.getX_start(); x <= pom.getX_end(); ++x) {
            for (int y = pom.getY_start(); y <= pom.getY_end(); ++y) {
                Cell cell = this.sm.getBook().getSheet(0).getCell(y, x);
                if (cell.getMemberFromUserObject() == null) continue;
                cell.getMemberFromUserObject().forEach(arg_0 -> AutoFloatLogicImpl.lambda$clearUnExitMember$7((Multimap)map, arg_0));
            }
        }
        if (isH) {
            ((ColumnDimDomain)tu.v).getDimensions().forEach(arg_0 -> AutoFloatLogicImpl.lambda$clearUnExitMember$9((Multimap)map, arg_0));
        } else {
            ((RowDimDomain)tu.k).getDimensions().forEach(arg_0 -> AutoFloatLogicImpl.lambda$clearUnExitMember$11((Multimap)map, arg_0));
        }
    }

    private boolean isNoRecord(Map<String, MDResultSet> valueMap, BasePointInfo bp) {
        MDResultSet rs = valueMap.get(bp.getOriginalDynaRange());
        boolean isNoRecord = rs == null || rs.getCount() <= 0;
        rs = valueMap.get(bp.getOriginalDynaRange() + "unleaf");
        return isNoRecord && (rs == null || rs.getCount() <= 0);
    }

    private boolean isBlankAreaNoCrossDimCell(RangeModel range) {
        Recorder bool = new Recorder((Object)false);
        this.getEffectiveSheet().iteratorRangeByPredicateBreak(range.getY_start(), range.getY_end(), range.getX_start(), range.getX_end(), cell -> {
            bool.setRecord((Object)cell.isMdDataDomain());
            return cell.isMdDataDomain();
        });
        return (Boolean)bool.getRecord() == false;
    }

    private void clearNoValueRowOrCol() {
        AskExcuteInfo insexcuteinfo;
        int i;
        int originacolorrow;
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        RangeModel originaldynaRange = new RangeModel(this.basePointInfo.getOriginalDynaRange());
        ArrayList<Integer> deledata = new ArrayList<Integer>(10);
        ArrayList<Integer> insertdata = new ArrayList<Integer>(10);
        int n = originacolorrow = this.basePointInfo.isDirectHoriz() ? originaldynaRange.getX_end() - originaldynaRange.getX_start() + 1 : originaldynaRange.getY_end() - originaldynaRange.getY_start() + 1;
        if (this.basePointInfo.isDirectHoriz()) {
            for (i = rangeModel.getX_start(); i < rangeModel.getX_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getY_end() + originacolorrow);
        } else {
            for (i = rangeModel.getY_start(); i < rangeModel.getY_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getY_end() + originacolorrow);
        }
        int start2insert = this.basePointInfo.isDirectHoriz() ? rangeModel.getX_end() : rangeModel.getY_end();
        for (int i2 = 0; i2 < originacolorrow; ++i2) {
            insertdata.add(start2insert);
        }
        AskExcuteInfo askExcuteInfo = insexcuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        if (!this.basePointInfo.isDirectHoriz()) {
            insexcuteinfo.setCon(true);
        }
        if (this.plugin != null) {
            insexcuteinfo.setRev(isRev);
            this.plugin.adjustSheetModelAndJs(insexcuteinfo);
        } else {
            this.adjustSheetModelAndJs(insexcuteinfo, this.abplugin.getPageCache());
            AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
            this.adjustSheetModelAndJs(excuteinfo, this.abplugin.getPageCache());
        }
    }

    private void clearNoValueRowOrCol2(int dataSize) {
        if (dataSize > 0) {
            RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
            RangeModel originaldynaRange = new RangeModel(this.basePointInfo.getOriginalDynaRange());
            ArrayList<Integer> deledata = new ArrayList<Integer>(10);
            List topSettingOrders = this.basePointInfo.getTopSettingOrder();
            List topSettingOrder = topSettingOrders.stream().filter(t -> t.containsKey("top") && Integer.parseInt(t.get("top").toString()) > 0).collect(Collectors.toList());
            if (!topSettingOrder.isEmpty()) {
                int i;
                int top = Integer.parseInt(((Map)topSettingOrder.get(0)).get("top").toString());
                int originacolorrow = this.basePointInfo.isDirectHoriz() ? originaldynaRange.getX_end() - originaldynaRange.getX_start() + 1 : originaldynaRange.getY_end() - originaldynaRange.getY_start() + 1;
                int startDeleteIndex = 0;
                if (dataSize > top) {
                    top = dataSize;
                }
                startDeleteIndex = top >= originacolorrow ? top + 2 : originacolorrow;
                if (this.basePointInfo.isDirectHoriz()) {
                    for (i = rangeModel.getX_start() + startDeleteIndex - 1; i < rangeModel.getX_end(); ++i) {
                        deledata.add(i);
                    }
                } else {
                    for (i = rangeModel.getY_start() + startDeleteIndex - 1; i < rangeModel.getY_end(); ++i) {
                        deledata.add(i);
                    }
                }
                if (this.plugin != null) {
                    AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
                    this.plugin.adjustSheetModelAndJs(excuteinfo);
                } else {
                    AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
                    this.adjustSheetModelAndJs(excuteinfo, this.abplugin.getPageCache());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkAndFloat(List<String> dmNumberLis, List<Row> rows, IPageCache pageCache) {
        Map fixmem = this.basePointInfo.getFixMemberPosition();
        Set fixmemset = fixmem.entrySet();
        String range = this.basePointInfo.getDynaRange();
        String originalDynaRange = this.basePointInfo.getOriginalDynaRange();
        int rangestartindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
        int rangeendindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
        int startvalueindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)this.positionInfo.getStartPosition().split(":")[0]) : ExcelUtils.pos2X((String)this.positionInfo.getStartPosition().split(":")[0]);
        int floatAreaNumber = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)range.split(":")[1]) - ExcelUtils.pos2Y((String)range.split(":")[0]) + 1 : ExcelUtils.pos2X((String)range.split(":")[1]) - ExcelUtils.pos2X((String)range.split(":")[0]) + 1;
        ArrayList<String> floatnumber = new ArrayList<String>();
        if (fixmemset.isEmpty()) {
            return;
        }
        for (Object info : this.basePointInfo.getBasePointInnerLineInfo()) {
            if (!info.isFloated()) continue;
            floatnumber.add(info.getDimension().getNumber());
        }
        if (!this.isNextPage) {
            this.filterFloatDim(rows);
            if (!this.basePointInfo.getShowFloatMember(this.positionInfo).booleanValue()) {
                rows = this.filterByFixMembers(rows);
            }
            if (rows.isEmpty()) {
                this.clearFloatMemberAndValue(floatnumber);
                return;
            }
            if (AutoFloatLogicImpl.getPageSizeSetting(this.getModelId()) != -1) {
                this.clearFloatMemberAndValue(floatnumber);
            }
            if (this.basePointInfo.getTopSettingOrder() != null && !this.basePointInfo.getTopSettingOrder().isEmpty()) {
                rows = this.sortRowsBySetting(rows, floatAreaNumber);
            }
            this.rowslimitfix = rows;
            if (AutoFloatLogicImpl.getPageSizeSetting(this.getModelId()) != -1) {
                this.getPageRowMap(rows, pageCache, floatnumber, false);
            }
            if (this.checkHasFloat((Integer)fixmem.keySet().iterator().next(), floatnumber, rangestartindex, rangeendindex, startvalueindex)) {
                if (this.plugin == null) {
                    List<FloatArea> cache = this.abplugin.getPageCache().get("floatarea") != null ? (List)ObjectSerialUtil.deSerializedBytes((String)this.abplugin.getPageCache().get("floatarea")) : new ArrayList<FloatArea>(16);
                    cache.add(new FloatArea(this.deledata, true));
                    this.abplugin.getPageCache().put("floatarea", ObjectSerialUtil.toByteSerialized(cache));
                    this.deledata.clear();
                } else {
                    this.result = FloatLogicImpl.collectMemMsg(this.sm, this.getModelId());
                    this.updateFloatNumberFormSheet(this.sm);
                }
                return;
            }
            if (this.basePointInfo.getTopSettingOrder() == null || this.basePointInfo.getTopSettingOrder().isEmpty()) {
                FloatDataProvider.sortRowByDim(this.rowslimitfix, floatnumber.toArray(new String[0]));
            }
            rows = AutoFloatUtil.alternateFloatData(rows, floatnumber, this.isAlternateFloat);
            this.rowslimitfix = rows;
        }
        Map<MemberGroupKey, List<Row>> rowMap = this.getPageRowMap(rows, pageCache, floatnumber, true);
        if (AutoFloatLogicImpl.getPageSizeSetting(this.getModelId()) != 0 && rowMap.isEmpty() && this.getPlugin() != null) {
            this.getPlugin().getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6d6e\u52a8\u6570\u636e\u533a\u57df\u7684\u6570\u636e\u5df2\u7ecf\u5168\u90e8\u663e\u793a\u3002", (String)"AbstractMultiReportPlugin_264", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.rowslimitfix == null) {
            this.rowslimitfix = new ArrayList<Row>(16);
            for (List list : rowMap.values()) {
                this.rowslimitfix.addAll(list);
            }
        }
        DimGroupKey dimkey = new DimGroupKey(floatnumber);
        int n = this.findStart2insertIndex(this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz());
        this.basePointInfo.setFloatMemDisplayPattern(this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo));
        this.result = FloatLogicImpl.collectMemMsg(this.rowslimitfix, this.basePointInfo, this.getModelId());
        if (this.plugin != null) {
            this.plugin.insertRank(n, rowMap.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz(), isRev);
        } else {
            List cache = this.abplugin.getPageCache().get("floatarea") != null ? (List)ObjectSerialUtil.deSerializedBytes((String)this.abplugin.getPageCache().get("floatarea")) : new ArrayList(16);
            this.insertRank(n, rowMap.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz(), pageCache);
            String originalRange = this.basePointInfo.getOriginalDynaRange();
            int beginindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)originalRange.split(":")[0]) : ExcelUtils.pos2Y((String)originalRange.split(":")[0]);
            int endindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)originalRange.split(":")[1]) : ExcelUtils.pos2Y((String)originalRange.split(":")[1]);
            int num = rowMap.size() - (endindex - n) - 1;
            cache.add(new FloatArea(beginindex, endindex, num >= 0 ? num : 0, this.basePointInfo.isDirectHoriz(), originalDynaRange, this.basePointInfo.getDynaRange(), this.deledata));
            this.deledata.clear();
            this.abplugin.getPageCache().put("floatarea", ObjectSerialUtil.toByteSerialized(cache));
        }
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        RangeModel dataRangeModel = this.basePointInfo.getDataArea(this.positionInfo);
        this.nextRangeModel = this.basePointInfo.isDirectHoriz() ? new RangeModel(n, rangeModel.getX_end(), dataRangeModel.getY_start(), dataRangeModel.getY_end()) : new RangeModel(dataRangeModel.getX_start(), dataRangeModel.getX_end(), n, rangeModel.getY_end());
        BlockFloatNode blockFloatNode = new BlockFloatNode(-1, null);
        for (MemberGroupKey dimlist : rowMap.keySet()) {
            void var15_17;
            int endIndex;
            int n2 = endIndex = this.basePointInfo.isDirectHoriz() ? rangeModel.getX_end() : rangeModel.getY_end();
            if (endIndex < var15_17) continue;
            this.updateSheetModel(dimlist, (int)var15_17, rangeModel, dimkey, blockFloatNode);
            ++var15_17;
        }
        this.updateFloatNumberFormSheet(this.sm);
        if (!(this.basePointInfo.getTopSettingOrder() == null || this.basePointInfo.getTopSettingOrder().isEmpty() || "0".equals(ThreadCache.get((Object)"isTop")) || this.plugin == null || this.plugin.getCurrentReportStatus().equals(ReportStatusEnum.UNWEAVE.status()))) {
            this.clearNoValueRowOrCol2(rowMap.size());
        }
    }

    private Map<MemberGroupKey, List<Row>> getPageRowMap(List<Row> rows, IPageCache pageCache, List<String> floatnumber, boolean isGetPageData) {
        if (this.resultPageManager == null) {
            int pageSize = AutoFloatLogicImpl.getPageSizeSetting(this.getModelId());
            this.resultPageManager = ResultPageManager.getOrInitResultPageManager(pageSize, pageCache);
        }
        if (this.resultPageManager.get(this.basePointInfo.getOriginalDynaRange()) == null) {
            Map<MemberGroupKey, List<Row>> allRowMap = this.toRowMap(rows, floatnumber);
            ResultPage resultPage = new ResultPage(allRowMap);
            this.resultPageManager.putIfAbsent(this.basePointInfo.getOriginalDynaRange(), resultPage);
        }
        Map<MemberGroupKey, List<Row>> rowMap = new HashMap<MemberGroupKey, List<Row>>(4);
        if (isGetPageData) {
            rowMap = this.resultPageManager.getNextPageRows(this.basePointInfo.getOriginalDynaRange());
        }
        return rowMap;
    }

    public static Integer getPageSizeSetting(long modelId) {
        Map jsonMap = (Map)ThreadCache.get((Object)(ConfigEnum.CM052.getNumber() + modelId), () -> {
            Map map = ConfigServiceHelper.getCM052((Long)modelId);
            if (map == null) {
                HashMap<String, Integer> defalutmap = new HashMap<String, Integer>();
                defalutmap.put(CONFIG_NUM, -1);
                return defalutmap;
            }
            return map;
        });
        try {
            return jsonMap.getOrDefault(CONFIG_NUM, -1);
        }
        catch (Exception e) {
            return Integer.valueOf(((Object)jsonMap.getOrDefault(CONFIG_NUM, -1)).toString());
        }
    }

    public static void setThreadPageSizeSetting(long modelId, int pageSize) {
        Map jsonMap = (Map)ThreadCache.get((Object)(ConfigEnum.CM052.getNumber() + modelId), () -> {
            Map map = ConfigServiceHelper.getCM052((Long)modelId);
            if (map == null) {
                HashMap<String, Integer> defalutmap = new HashMap<String, Integer>();
                defalutmap.put(CONFIG_NUM, -1);
                return defalutmap;
            }
            return map;
        });
        jsonMap.put(CONFIG_NUM, pageSize);
    }

    private IPageCache getPageCache() {
        return this.plugin.getPageCache();
    }

    private List<Row> sortRowsBySetting(List<Row> rows, int floatAreaNumber) {
        List maps = this.basePointInfo.getTopSettingOrder();
        HashMap<Integer, String> floatnumbers = new HashMap<Integer, String>(16);
        boolean isOrgFloat = false;
        boolean isIcFloat = false;
        int index = -1;
        for (Object info : this.basePointInfo.getBasePointInnerLineInfo()) {
            String dimNum = info.getDimension().getNumber();
            floatnumbers.put(info.getOffset(), dimNum);
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum) && info.isFloated()) {
                index = info.getOffset();
                isIcFloat = true;
            }
            if (!DimTypesEnum.ENTITY.getNumber().equals(dimNum) || !info.isFloated()) continue;
            isOrgFloat = true;
        }
        ArrayList<FloatDataProvider.SortSetting> sortSettings = new ArrayList<FloatDataProvider.SortSetting>(16);
        for (Map topSetting : maps) {
            Integer top = Integer.parseInt(String.valueOf(topSetting.get("top")));
            Integer orderby = Integer.parseInt(String.valueOf(topSetting.get("orderby")));
            String sortorder = String.valueOf(topSetting.get("sortorder"));
            if (orderby >= floatAreaNumber) {
                if (this.isAlternateFloat && isIcFloat && isOrgFloat && index == orderby) continue;
                sortSettings.add(new FloatDataProvider.SortSetting(top, orderby, Integer.parseInt(sortorder), ""));
                continue;
            }
            if (floatnumbers.get(orderby) == null || this.isAlternateFloat && isIcFloat && isOrgFloat && DimTypesEnum.INTERCOMPANY.getNumber().equals(floatnumbers.get(orderby))) continue;
            sortSettings.add(new FloatDataProvider.SortSetting(top, orderby, Integer.parseInt(sortorder), (String)floatnumbers.get(orderby)));
        }
        if (CollectionUtils.isEmpty(sortSettings)) {
            return rows;
        }
        int pattern = this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo).getIndex();
        Supplier<Integer> sortbyer = () -> pattern;
        this.modelId = this.plugin == null ? this.abplugin.getModelId() : this.plugin.getModelId();
        FloatDataProvider.Sorter sorter = new FloatDataProvider.Sorter(sortSettings, rows, this.basePointInfo, this.modelId, sortbyer, this.positionInfo);
        sorter.setSchemeId(this.schemeId);
        sorter.sortByStream();
        return sorter.getRows();
    }

    private void clearFloatMemberAndValue(List<String> floatnumber) {
        TemplateScanMemberService service = this.plugin == null ? new TemplateScanMemberService(this.sm, this.templateModel) : new TemplateScanMemberService(this.plugin.getSpreadModel(), this.plugin.getTemplateModel());
        Set<Point> points = this.plugin == null ? service.getFloatFirst(this.sm) : service.getFloatFirst(this.plugin.getSpreadModel());
        String dynaRange = this.basePointInfo.getDynaRange();
        String areaRange = this.positionInfo.getAreaRange();
        RangeModel dynaRangeModel = SpreadAreaUtil.getRangModel((String)dynaRange);
        RangeModel areaRangModel = SpreadAreaUtil.getRangModel((String)areaRange);
        String realRange = "";
        realRange = this.basePointInfo.isDirectHoriz() ? ExcelUtils.xy2Pos((int)dynaRangeModel.getX_start(), (int)areaRangModel.getY_start()) + ":" + ExcelUtils.xy2Pos((int)dynaRangeModel.getX_end(), (int)areaRangModel.getY_end()) : ExcelUtils.xy2Pos((int)areaRangModel.getX_start(), (int)dynaRangeModel.getY_start()) + ":" + ExcelUtils.xy2Pos((int)areaRangModel.getX_end(), (int)dynaRangeModel.getY_end());
        List<Map<String, Object>> cellValues = this.collectCell(points, SpreadAreaUtil.getRangModel((String)realRange), floatnumber);
        cellValues.addAll(this.collectCell(points, dynaRangeModel, floatnumber));
        if (!cellValues.isEmpty() && this.plugin != null) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), cellValues);
        }
    }

    private List<Map<String, Object>> collectCell(Set<Point> points, RangeModel rangeModel, List<String> floatnumber) {
        List excelNotSupportFormulas = FormulaRegister.getExcelNotSupportFormulas();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        for (int rowIndex = rangeModel.getY_start(); rowIndex <= rangeModel.getY_end(); ++rowIndex) {
            for (int colIndex = rangeModel.getX_start(); colIndex <= rangeModel.getX_end(); ++colIndex) {
                AtomicBoolean onlyExcel = new AtomicBoolean(true);
                Cell cell = this.getEffectiveSheet().getCell(rowIndex, colIndex);
                if (cell.hasFormula()) {
                    String formula = cell.getFormula();
                    AutoFloatLogicImpl.isOnlyExcel(excelNotSupportFormulas, onlyExcel, formula);
                }
                Point point = new Point(cell.getCol(), cell.getRow());
                if (!cell.hasFormula() || !onlyExcel.get()) {
                    cell.setValue(null);
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", cell.getRow());
                    e.put("c", cell.getCol());
                    e.put("v", null);
                    cellValues.add(e);
                }
                cell.setChangeVal(false);
                cell.setMdDataDomain(false);
                if (points.contains(point)) {
                    List userObject = cell.getMemberFromUserObject();
                    if (null == userObject) continue;
                    Iterator iterator = userObject.iterator();
                    while (iterator.hasNext()) {
                        IDimMember dimMember = (IDimMember)iterator.next();
                        if (!floatnumber.contains(dimMember.getDimension().getNumber())) continue;
                        iterator.remove();
                    }
                    continue;
                }
                cell.clearMembersOfUserObject();
                if (cell.getUserObject().containsKey((Object)"floatmember")) {
                    cell.removeUserObject("floatmember");
                }
                if (!cell.getUserObject().containsKey((Object)"seqobject")) continue;
                cell.removeUserObject("seqobject");
            }
        }
        return cellValues;
    }

    private static void isOnlyExcel(List<String> excelNotSupportFormulas, AtomicBoolean onlyExcel, String formula) {
        Expression ex = null;
        try {
            ex = ExcelFormulaPaserHelper.parse((String)formula);
            ReportFormulaUtil.isOnlyExcel(excelNotSupportFormulas, onlyExcel, ex);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    private List<Row> filterByFixMembers(List<Row> rows) {
        ArrayList<Row> realrows = new ArrayList<Row>(10);
        List samplemems = (List)this.basePointInfo.getFixMemberPosition().values().iterator().next();
        if (samplemems.isEmpty()) {
            return rows;
        }
        ArrayList<String> fixdim = new ArrayList<String>(samplemems.size());
        for (IDimMember m : samplemems) {
            fixdim.add(m.getDimension().getNumber());
        }
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, fixdim);
        for (List members : this.basePointInfo.getFixMemberPosition().values()) {
            ArrayList<String> objMembers = new ArrayList<String>(10);
            for (IDimMember m : members) {
                String memNum = m.getNumber();
                if (DimTypesEnum.CURRENCY.getNumber().equals(m.getDimension().getNumber()) && CurrencyTool.isTransCurrency((String)memNum)) {
                    return rows;
                }
                if (PresetConstant.PERIOD_DIM.equals(m.getDimension().getNumber()) && "LastPeriod".equals(memNum)) {
                    return rows;
                }
                if (!fixdim.contains(PresetConstant.PERIOD_DIM) && PresetConstant.FY_DIM.equals(m.getDimension().getNumber()) && "LastYear".equals(memNum)) {
                    return rows;
                }
                objMembers.add(memNum);
            }
            MemberGroupKey key = MemberGroupKey.create(objMembers);
            List<Row> list = rowMap.get(key);
            if (list == null) continue;
            realrows.addAll(list);
        }
        return realrows;
    }

    private void filterFloatDim(List<Row> rows) {
        long orgId = 0L;
        if (this.relaMembSupplier instanceof OrgRelaMembSupplier) {
            orgId = ((OrgRelaMembSupplier)this.relaMembSupplier).get_mainOrgId();
        }
        HideLogicImpl.filterRows(rows, this.basePointInfo, this.sm, this.getModelId(), orgId);
    }

    private List<String> getDmNumberLis() {
        Iterator it = this.basePointInfo.getFixMemberPosition().values().iterator();
        ArrayList<String> dmNumberLis = new ArrayList<String>(10);
        if (it.hasNext()) {
            List dmList = (List)it.next();
            for (IDimMember dm : dmList) {
                dmNumberLis.add(dm.getDimension().getNumber());
            }
        } else {
            return null;
        }
        return dmNumberLis;
    }

    private List<Row> getRows(boolean isCsl, Map<String, MDResultSet> setmap) {
        List<Row> rows;
        if (isCsl) {
            rows = FloatDataProvider.getResultRowByArea(this.plugin == null ? this.templateModel : this.plugin.getTemplateModel(), this.sm, setmap, this.positionInfo, this.basePointInfo, this.dataTypeMap);
            long orgId = 0L;
            if (this.relaMembSupplier instanceof OrgRelaMembSupplier) {
                orgId = ((OrgRelaMembSupplier)this.relaMembSupplier).get_mainOrgId();
            }
            OffsetLogicImpl.cleanMdData(this.sm, this.plugin == null ? this.templateModel : this.plugin.getTemplateModel(), this.positionInfo, this.basePointInfo, rows, ThreadCache.get((Object)"Offset") != null, orgId);
        } else {
            rows = this.basePointInfo.getDirect() == 1 || this.basePointInfo.getDirect() == 2 ? FloatDataProvider.getResultRowByArea(this.plugin == null ? this.templateModel : this.plugin.getTemplateModel(), this.sm, setmap, this.positionInfo, this.basePointInfo, this.dataTypeMap) : FloatDataProvider.getResultRowByArea(setmap, this.basePointInfo.getOriginalDynaRange());
        }
        return rows;
    }

    private boolean checkHasFloat(int entryKey, List<String> floatnumber, int rangestartindex, int rangeendindex, int startvalueindex) {
        Map<MemberGroupKey, List<Row>> mapData = null;
        ArrayList<Integer> deledata = new ArrayList<Integer>(10);
        int moneyColIndex = -1;
        boolean gobyfilter = false;
        ArrayList<Pair> k = new ArrayList<Pair>(10);
        for (int i = rangestartindex; i <= rangeendindex; ++i) {
            Cell cell;
            Cell cell2 = cell = this.basePointInfo.isDirectHoriz() ? this.getEffectiveSheet().getCell(startvalueindex + entryKey, i) : this.getEffectiveSheet().getCell(i, startvalueindex + entryKey);
            if (!cell.isMdDataDomain()) continue;
            gobyfilter = true;
            List mems = cell.getMemberFromUserObject();
            if (mems != null && !mems.isEmpty()) {
                Object mem2;
                for (Object mem2 : mems) {
                    if (!floatnumber.contains(mem2.getDimension().getNumber())) continue;
                    k.add(Pair.onePair((Object)mem2.getDimension().getNumber(), (Object)mem2.getNumber()));
                }
                if (cell.getUserObject("entity") != null) {
                    k.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)((String)cell.getUserObject("entity"))));
                }
                if (mapData == null) {
                    moneyColIndex = this.rowslimitfix.get(0).getColIndex(FacTabFieldDefEnum.FIELD_MONEY.getField());
                    ArrayList<String> dims = new ArrayList<String>(k.size());
                    for (Pair p : k) {
                        dims.add(p.p1.toString());
                    }
                    mapData = this.toRowMap(this.rowslimitfix, dims);
                }
                ReportSpecialVariableUtil.tranSpecialVar(k, (SpreadManager)this.sm);
                ArrayList<Object> members = new ArrayList<Object>(k.size());
                mem2 = k.iterator();
                while (mem2.hasNext()) {
                    Pair p;
                    p = (Pair)mem2.next();
                    members.add(p.p2);
                }
                MemberGroupKey key = MemberGroupKey.create(members);
                if (mapData.containsKey(key)) {
                    FloatDataProvider.dealRowByPack(mapData, key, cell, moneyColIndex);
                } else {
                    deledata.add(i);
                }
            }
            k.clear();
        }
        if (!deledata.isEmpty()) {
            List<Integer> clearData = this.dealFloatBlankRowCol(rangestartindex, rangeendindex, deledata);
            this.deledata.addAll(clearData);
        }
        if (gobyfilter) {
            if (mapData == null || mapData.isEmpty()) {
                return true;
            }
            this.rowslimitfix.clear();
            for (List rs : mapData.values()) {
                this.rowslimitfix.addAll(rs);
            }
        }
        return false;
    }

    private List<Integer> dealFloatBlankRowCol(int rangestartindex, int rangeendindex, List<Integer> deledata) {
        AskExcuteInfo excuteinfo;
        int cur_Index;
        Sheet sheet = this.sm.getBook().getSheet(0);
        if (this.basePointInfo.isDirectHoriz()) {
            for (Integer del_num : deledata) {
                sheet.resetColumn(del_num.intValue());
            }
        } else {
            for (Integer del_num : deledata) {
                sheet.resetRow(del_num.intValue());
            }
        }
        int lastHasVauleIndex = 0;
        if (this.basePointInfo.isDirectHoriz()) {
            for (cur_Index = rangeendindex; cur_Index >= rangestartindex; --cur_Index) {
                for (Cell cell : sheet.getCol(cur_Index)) {
                    if (cell.getValue() == null) continue;
                    lastHasVauleIndex = cur_Index;
                    break;
                }
                if (lastHasVauleIndex == 0) {
                    continue;
                }
                break;
            }
        } else {
            for (cur_Index = rangeendindex; cur_Index >= rangestartindex; --cur_Index) {
                for (Cell cell : sheet.getRow(cur_Index)) {
                    if (cell.getValue() == null) continue;
                    lastHasVauleIndex = cur_Index;
                    break;
                }
                if (lastHasVauleIndex == 0) {
                    continue;
                }
                break;
            }
        }
        int final_LastHasVauleRow = lastHasVauleIndex;
        List<Integer> clearData = deledata.stream().filter(d -> d < final_LastHasVauleRow).collect(Collectors.toList());
        AskExcuteInfo askExcuteInfo = excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, clearData) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, clearData);
        if (this.plugin != null) {
            this.plugin.adjustSheetModelAndJs(excuteinfo);
        }
        return clearData;
    }

    private void updateSheetModel(MemberGroupKey dimlist, int startIndex, RangeModel rangeModel, DimGroupKey dimkey, BlockFloatNode blockFloatNode) {
        int row = 0;
        int col = 0;
        ArrayList<DimMember> members = new ArrayList<DimMember>(10);
        for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
            int rcIndex;
            if (!info.isFloated()) continue;
            members.clear();
            int offset = info.getOffset();
            if (info.isSeq() || info.isIshide()) {
                offset = 0;
            }
            if (this.basePointInfo.isDirectHoriz()) {
                row = rangeModel.getY_start() + offset;
                col = startIndex;
            } else {
                col = rangeModel.getX_start() + offset;
                row = startIndex;
            }
            IDimension dimension = info.getDimension();
            String numbernum = dimlist.getValue(dimkey.getIndex(info.getDimension().getNumber())).toString();
            String findNum = DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) ? (String)this.relaMembSupplier.access((Object)numbernum) : numbernum;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dimension.getNumber(), (String)findNum);
            String simpleName = "";
            Map<String, Map<String, String>> mems = this.result.get(dimension.getNumber());
            if (mems != null && mems.size() > 0) {
                Map<String, String> membermsg = mems.get(numbernum);
                simpleName = membermsg == null ? "" : membermsg.get("simplename");
            }
            DimMember member = new DimMember(node.getName(), node.getNumber(), simpleName, dimension);
            if (DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) && node.getParent() != null) {
                member.setPar_SonNum(node.getParent_SonNumber());
            }
            members.add(member);
            Cell cur_cell = this.getEffectiveSheet().getCell(row, col);
            if (info.isSeq()) {
                cur_cell.setUserObject("seqobject", (Object)member);
            } else if (info.isIshide()) {
                HideLogicImpl.fixHideMember(this.sm, cur_cell, this.basePointInfo, numbernum);
            } else {
                if (info.getDynaMembScopes().isEmpty() && ThreadCache.get((Object)autoflaot_key) != null && DimTypesEnum.MYCOMPANY.getNumber().equals(info.getDimension().getNumber())) {
                    cur_cell.removeUserObject("numberfrom");
                }
                if (cur_cell.isMembUserObjContainMember(members)) {
                    cur_cell.replaceDims2UserObject(members);
                } else {
                    cur_cell.addDims2UserObject(members);
                }
            }
            PositionInfo.FloatMemDisplayPattern pattern = this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo);
            int ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
            String msg = cur_cell.displayDimMsg(ordinal);
            boolean isHasNode = false;
            int n = rcIndex = this.basePointInfo.isDirectHoriz() ? cur_cell.getRow() : cur_cell.getCol();
            if (blockFloatNode.rcIndex == -1 || blockFloatNode.rcIndex == rcIndex && (blockFloatNode.value == null || !blockFloatNode.value.equals(msg))) {
                blockFloatNode.reSetNode(rcIndex, msg);
            } else {
                isHasNode = !blockFloatNode.addChildNode(rcIndex, msg);
            }
            boolean bl = isHasNode = isHasNode && this.basePointInfo.isTopSettingOrder_memShowOne(info.getOffset());
            if (!isHasNode) {
                cur_cell.setValue((Object)msg);
                if (this.plugin != null) {
                    this.cellValues.add(this.plugin.packedUpdateCellMap(row, col, msg));
                } else {
                    this.cellValues.add(this.packedUpdateCellMap(row, col, msg));
                }
            }
            TemplateFloatUtil.setMsgBack2Cell(this.getModelId(), this.sm, row, col, null, true, false, this.positionInfo, this.basePointInfo);
        }
    }

    private void updateFloatNumberFormSheet(SpreadManager spreadManager) {
        Sheet sheet = spreadManager.getBook().getSheet(0);
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        for (PositionInfo info : spreadManager.getAreaManager().getPostionInfoSet()) {
            if (this.positionInfo != null && !info.getAreaRange().equals(this.positionInfo.getAreaRange())) continue;
            for (BasePointInfo baseinfo : info.getBasePoints()) {
                if (!baseinfo.getOriginalDynaRange().equals(this.basePointInfo.getOriginalDynaRange())) continue;
                RangeModel baseRangeModel = new RangeModel(baseinfo.getDynaRange());
                int startIndex = baseinfo.isDirectHoriz() ? baseRangeModel.getX_start() : baseRangeModel.getY_start();
                int endIndex = baseinfo.isDirectHoriz() ? baseRangeModel.getX_end() : baseRangeModel.getY_end();
                int rangeStartIndex = baseinfo.isDirectHoriz() ? baseRangeModel.getY_start() : baseRangeModel.getX_start();
                PositionInfo.FloatMemDisplayPattern pattern = baseinfo.getFloatMemDisplayPattern(this.positionInfo);
                int ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
                RangeModel floatDataRange = info.getFloatdataArea(baseinfo);
                List<Integer> matchRows = FloatLogicImpl.matchHasDataRC(this.sm, floatDataRange, !baseinfo.isDirectHoriz());
                BlockFloatNode blockFloatNode = new BlockFloatNode(-1, null);
                for (int i = startIndex; i <= endIndex; ++i) {
                    for (BasePointInnerLineInfo innerInfo : baseinfo.getBasePointInnerLineInfo()) {
                        Cell cell;
                        int offset = innerInfo.getOffset();
                        if (offset < 0) continue;
                        int index = rangeStartIndex + offset;
                        Cell cell2 = cell = baseinfo.isDirectHoriz() ? sheet.getCell(index, i) : sheet.getCell(i, index);
                        if (cell.getUserObject("numberfrom") != null || cell.getUserObject("numberfrom") == null && innerInfo.getNumberfrom() != null && !innerInfo.getNumberfrom().isEmpty()) {
                            if (cell.getMemberFromUserObject() == null || !matchRows.contains(i)) continue;
                            for (IDimMember member : cell.getMemberFromUserObject()) {
                                int rcIndex;
                                IDimension dimension = member.getDimension();
                                String number = member.getNumber();
                                String findNum = DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) ? (String)this.relaMembSupplier.access((Object)number) : number;
                                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dimension.getNumber(), (String)findNum);
                                String simpleName = "";
                                Map<String, Map<String, String>> mems = this.result.get(dimension.getNumber());
                                if (mems != null && mems.size() > 0) {
                                    Map<String, String> membermsg = mems.get(number);
                                    simpleName = membermsg == null ? "" : membermsg.get("simplename");
                                }
                                member.setName(node.getName());
                                member.setNumber(node.getNumber());
                                member.setSimpleName(simpleName);
                                if (DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) && node.getParent() != null) {
                                    member.setPar_SonNum(node.getParent_SonNumber());
                                }
                                String msg = cell.displayDimMsg(ordinal);
                                boolean isHasNode = false;
                                int n = rcIndex = baseinfo.isDirectHoriz() ? cell.getRow() : cell.getCol();
                                if (blockFloatNode.rcIndex == -1 || blockFloatNode.rcIndex == rcIndex && (blockFloatNode.value == null || !blockFloatNode.value.equals(msg))) {
                                    blockFloatNode.reSetNode(rcIndex, msg);
                                } else {
                                    isHasNode = !blockFloatNode.addChildNode(rcIndex, msg);
                                }
                                if (isHasNode = isHasNode && baseinfo.isTopSettingOrder_memShowOne(innerInfo.getOffset())) continue;
                                cell.setValue((Object)msg);
                                this.cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), msg));
                            }
                            continue;
                        }
                        if (innerInfo.isFloated() || innerInfo.getOffset() == -1 || !matchRows.contains(i)) continue;
                        IDimMember member = ((DynaMembScopeInfo)innerInfo.getDynaMembScopes().get(0)).getMember();
                        Dimension dim = new Dimension(member.getDimension().getName(), member.getDimension().getNumber(), member.getDimension().getUqCode());
                        DimMember dimMember = new DimMember(member.getName(), member.getNumber(), member.getSimpleName(), (IDimension)dim);
                        dimMember.setPar_SonNum(member.getPar_SonNum());
                        if (cell.isMembUserObjContainMember(member)) {
                            cell.replaceDims2UserObject(member);
                        } else {
                            cell.addDim2UserObject(member);
                        }
                        List members = cell.getMemberFromUserObject();
                        for (IDimMember mem : members) {
                            Map<String, String> membermsg;
                            Map<String, Map<String, String>> mems;
                            if (StringUtils.isEmpty((CharSequence)mem.getName())) {
                                mem.setName(MemberReader.findMemberByNumber((String)modelNum, (String)mem.getDimension().getNumber(), (String)mem.getNumber()).getName());
                            }
                            if ((mems = this.result.get(mem.getDimension().getNumber())) == null || mems.size() <= 0 || (membermsg = mems.get(mem.getNumber())) == null) continue;
                            mem.setSimpleName(membermsg.get("simplename"));
                        }
                        String msg = cell.displayDimMsg(ordinal);
                        cell.setValue((Object)msg);
                    }
                }
            }
        }
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    private long getModelId() {
        if (this.plugin == null) {
            if (this.abplugin == null) {
                return this.modelId;
            }
            return this.abplugin.getModelId();
        }
        return this.plugin.getModelId();
    }

    private Map<MemberGroupKey, List<Row>> toRowMap(List<Row> rows, List<String> dims) {
        if (rows.isEmpty()) {
            return new LinkedHashMap<MemberGroupKey, List<Row>>();
        }
        int[] colIndeies = new int[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            colIndeies[i] = rows.get(0).getColIndex(dims.get(i));
        }
        LinkedHashMap<MemberGroupKey, List<Row>> rowMap = new LinkedHashMap<MemberGroupKey, List<Row>>(16);
        for (Row row : rows) {
            MemberGroupKey key = MemberGroupKey.create((int[])colIndeies, (Row)row);
            ArrayList<Row> rs = (ArrayList<Row>)rowMap.get(key);
            if (rs == null) {
                rs = new ArrayList<Row>(10);
                rowMap.put(key, rs);
            }
            rs.add(row);
        }
        return rowMap;
    }

    public int findStart2insertIndex(String range, boolean isCol) {
        int endInsert;
        String start = range.split(":")[0];
        String end = range.split(":")[1];
        int start2insert = isCol ? ExcelUtils.pos2X((String)start) : ExcelUtils.pos2Y((String)start);
        int n = endInsert = isCol ? ExcelUtils.pos2X((String)end) : ExcelUtils.pos2Y((String)end);
        if (isCol) {
            for (int i = ExcelUtils.pos2X((String)end); i >= ExcelUtils.pos2X((String)start); --i) {
                for (int j = ExcelUtils.pos2Y((String)end); j >= ExcelUtils.pos2Y((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(j, i);
                    if ((cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty()) && cell.isNullValue()) continue;
                    return i + 1;
                }
            }
        } else {
            for (int i = ExcelUtils.pos2Y((String)end); i >= ExcelUtils.pos2Y((String)start); --i) {
                for (int j = ExcelUtils.pos2X((String)end); j >= ExcelUtils.pos2X((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(i, j);
                    if ((cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty()) && cell.isNullValue()) continue;
                    return i + 1;
                }
            }
        }
        return start2insert;
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    public void adjustSheetModelAndJs(AskExcuteInfo excuteinfo, IPageCache pageCache) {
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo, pageCache);
    }

    private void adjustPositonInfo(AskExcuteInfo excuteinfo, IPageCache pageCache) {
        List matchbaseinfos;
        String serial = pageCache.get("matchbaseinfowithrowcol");
        if (serial != null) {
            matchbaseinfos = (List)ObjectSerialUtil.deSerializedBytes((String)serial);
        } else {
            boolean isdirectHoriz = excuteinfo.getOperation() == 1;
            matchbaseinfos = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(this.matchBasePositonWithOperationdata(isdirectHoriz, excuteinfo, this.sm, pageCache)));
        }
        pageCache.remove("matchbaseinfowithrowcol");
        matchbaseinfos.forEach(matchbaseinfo -> {
            BasePointInfo currentbasepositinfo = matchbaseinfo.getBasepoint();
            if (currentbasepositinfo != null) {
                MarkSpecialCell.markSpecialCells(currentbasepositinfo, false, this.view, this.spread_key);
            }
        });
        this.returndatatoView(excuteinfo, this.view);
        boolean deleteOrAdd = excuteinfo.getMethod() == RowColExcuteEnum.DELETECOL || excuteinfo.getMethod() == RowColExcuteEnum.DELETEROW;
        excuteinfo.getOperationdata().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.intValue(), excuteinfo.getOperation(), deleteOrAdd ? -1 : 1);
            adjust.setCheck(excuteinfo.isCheck());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
        excuteinfo.getBatchOperationData().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.getOprtPosition(), excuteinfo.getOperation(), dealdata.getSize() * (deleteOrAdd ? -1 : 1));
            adjust.setCheck(excuteinfo.isCheck());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
    }

    private void returndatatoView(AskExcuteInfo excuteinfo, IFormView view) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        map.put("status", true);
        if (excuteinfo.isCon() && !excuteinfo.getOperationdata().isEmpty()) {
            ArrayList rangeList = new ArrayList(10);
            HashMap<String, Integer> data = new HashMap<String, Integer>(16);
            data.put("index", excuteinfo.getOperationdata().get(0));
            data.put("count", excuteinfo.getOperationdata().size());
            rangeList.add(data);
            map.put("data", rangeList);
        } else {
            map.put("data", excuteinfo.getOperationdata());
        }
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(this.spread_key, excuteinfo.getMethod().getMethod(), new Object[]{map});
    }

    private List<FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, AskExcuteInfo excuteinfo, SpreadManager sm, IPageCache pageCache) {
        List operationdata = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(excuteinfo.getOperationdata()));
        return this.matchBasePositonWithOperationdata(direct, operationdata, sm, pageCache);
    }

    private List<FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, List<Integer> operationdata, SpreadManager sm, IPageCache pageCache) {
        ArrayList<FMatchBaseInfo> matchbaseinfos = new ArrayList<FMatchBaseInfo>(10);
        sm.getAreaManager().getPostionInfoSet().forEach(position -> position.getBasePoints().forEach(basepoint -> {
            FMatchBaseInfo matchbaseinfo = new FMatchBaseInfo((PositionInfo)position, (BasePointInfo)basepoint, (List<Integer>)new ArrayList<Integer>(10));
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)basepoint.getDynaRange());
            Iterator dataiterator = operationdata.iterator();
            while (dataiterator.hasNext()) {
                Integer data = (Integer)dataiterator.next();
                if (direct) {
                    if (data >= rangemodel.getX_start() && data <= rangemodel.getX_end()) {
                        matchbaseinfo.getRowOrcols().add(data);
                        dataiterator.remove();
                    }
                    if (rangemodel.getX_start() != rangemodel.getX_end()) continue;
                    matchbaseinfo.setOnlyOneRowCol(true);
                    continue;
                }
                if (data >= rangemodel.getY_start() && data <= rangemodel.getY_end()) {
                    matchbaseinfo.getRowOrcols().add(data);
                    dataiterator.remove();
                }
                if (rangemodel.getY_start() != rangemodel.getY_end()) continue;
                matchbaseinfo.setOnlyOneRowCol(true);
            }
            if (!matchbaseinfo.getRowOrcols().isEmpty()) {
                matchbaseinfos.add(matchbaseinfo);
            }
        }));
        matchbaseinfos.add(new FMatchBaseInfo(null, null, operationdata));
        pageCache.put("matchbaseinfowithrowcol", ObjectSerialUtil.toByteSerialized(matchbaseinfos));
        return matchbaseinfos;
    }

    public void insertRank(int start2insert, int num, String range, boolean isCol, IPageCache pageCache) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(10);
        boolean ischeck = true;
        if (kd.bos.util.StringUtils.isNotEmpty((String)range)) {
            int beginindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
            int endindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
            num -= endindex - start2insert;
            if (start2insert == beginindex || start2insert == endindex) {
                ArrayList<Integer> tem = new ArrayList<Integer>(10);
                tem.add(start2insert);
                if (start2insert == beginindex) {
                    ++start2insert;
                }
                AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, tem);
                ThreadCache.put((Object)"matchbaseinfowithrowcol", this.matchBasePositonWithOperationdata(isCol, excuteinfo));
                ischeck = false;
            }
        }
        if (num >= 0) {
            for (int i = 0; i < num; ++i) {
                insertdata.add(start2insert);
            }
        }
        AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCheck(ischeck);
        excuteinfo.setCon(true);
        if (kd.bos.util.StringUtils.isNotEmpty((String)range)) {
            this.adjustInsertIndex(excuteinfo, range);
        }
        if (excuteinfo.getOperationdata().size() > 1) {
            AskExcuteInfo.BatchOperationList batch = new AskExcuteInfo.BatchOperationList();
            batch.addBatchOperationInfo(excuteinfo.getOperationdata().get(0), excuteinfo.getOperationdata().size());
            excuteinfo.getOperationdata().clear();
            excuteinfo.setBatchOperateData(batch);
        }
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo, pageCache);
    }

    private List<FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, AskExcuteInfo excuteinfo) {
        List operationdata = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(excuteinfo.getOperationdata()));
        return this.matchBasePositonWithOperationdata(direct, operationdata);
    }

    private List<FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, List<Integer> operationdata) {
        ArrayList<FMatchBaseInfo> matchbaseinfos = new ArrayList<FMatchBaseInfo>(10);
        this.sm.getAreaManager().getPostionInfoSet().forEach(position -> position.getBasePoints().forEach(basepoint -> {
            FMatchBaseInfo matchbaseinfo = new FMatchBaseInfo((PositionInfo)position, (BasePointInfo)basepoint, (List<Integer>)new ArrayList<Integer>(10));
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)basepoint.getDynaRange());
            Iterator dataiterator = operationdata.iterator();
            while (dataiterator.hasNext()) {
                Integer data = (Integer)dataiterator.next();
                if (direct) {
                    if (data >= rangemodel.getX_start() && data <= rangemodel.getX_end()) {
                        matchbaseinfo.getRowOrcols().add(data);
                        dataiterator.remove();
                    }
                    if (rangemodel.getX_start() != rangemodel.getX_end()) continue;
                    matchbaseinfo.setOnlyOneRowCol(true);
                    continue;
                }
                if (data >= rangemodel.getY_start() && data <= rangemodel.getY_end()) {
                    matchbaseinfo.getRowOrcols().add(data);
                    dataiterator.remove();
                }
                if (rangemodel.getY_start() != rangemodel.getY_end()) continue;
                matchbaseinfo.setOnlyOneRowCol(true);
            }
            if (!matchbaseinfo.getRowOrcols().isEmpty()) {
                matchbaseinfos.add(matchbaseinfo);
            }
        }));
        matchbaseinfos.add(new FMatchBaseInfo(null, null, operationdata));
        ThreadCache.put((Object)"matchbaseinfowithrowcol", matchbaseinfos);
        return matchbaseinfos;
    }

    private void adjustInsertIndex(AskExcuteInfo excuteinfo, String range) {
        int start;
        if (RowColExcuteEnum.DELETECOL == excuteinfo.getMethod() || RowColExcuteEnum.DELETEROW == excuteinfo.getMethod()) {
            return;
        }
        String startPoint = range.split(":")[0];
        int n = start = RowColExcuteEnum.INSERTCOL == excuteinfo.getMethod() ? ExcelUtils.pos2X((String)startPoint) : ExcelUtils.pos2Y((String)startPoint);
        if (excuteinfo.getOperationdata().size() == 1 && excuteinfo.getOperationdata().get(0) == start) {
            excuteinfo.getOperationdata().clear();
            excuteinfo.getOperationdata().add(start);
        }
    }

    public RangeModel getNextRangeModel() {
        return this.nextRangeModel;
    }

    public void setNextRangeModel(RangeModel nextRangeModel) {
        this.nextRangeModel = nextRangeModel;
    }

    public long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(long schemeId) {
        this.schemeId = schemeId;
    }

    private static /* synthetic */ void lambda$clearUnExitMember$11(Multimap map, IDimension d) {
        d.getMembers().removeIf(next -> !map.get((Object)d.getNumber()).contains(next.getNumber()));
    }

    private static /* synthetic */ void lambda$clearUnExitMember$9(Multimap map, IDimension d) {
        d.getMembers().removeIf(next -> !map.get((Object)d.getNumber()).contains(next.getNumber()));
    }

    private static /* synthetic */ void lambda$clearUnExitMember$7(Multimap map, IDimMember m) {
        map.put((Object)m.getDimension().getNumber(), (Object)m.getNumber());
    }

    static class FMatchBaseInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private BasePointInfo basepoint;
        private PositionInfo positioninfo;
        private List<Integer> rowOrcols = new ArrayList<Integer>(10);
        private boolean isOnlyOneRowCol = false;

        public FMatchBaseInfo(PositionInfo positioninfo, BasePointInfo basepoint, List<Integer> rowOrcols) {
            this.positioninfo = positioninfo;
            this.setBasepoint(basepoint);
            this.rowOrcols = rowOrcols;
        }

        public PositionInfo getPositioninfo() {
            return this.positioninfo;
        }

        public void setPositioninfo(PositionInfo positioninfo) {
            this.positioninfo = positioninfo;
        }

        public BasePointInfo getBasepoint() {
            return this.basepoint;
        }

        public final void setBasepoint(BasePointInfo basepoint) {
            this.basepoint = basepoint;
        }

        public List<Integer> getRowOrcols() {
            return this.rowOrcols;
        }

        public void setRowOrcols(List<Integer> rowOrcols) {
            this.rowOrcols = rowOrcols;
        }

        public boolean isOnlyOneRowCol() {
            return this.isOnlyOneRowCol;
        }

        public void setOnlyOneRowCol(boolean isOnlyOneRowCol) {
            this.isOnlyOneRowCol = isOnlyOneRowCol;
        }
    }

    static class MatchBaseInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private BasePointInfo basepoint;
        private PositionInfo positioninfo;
        private List<Integer> rowOrcols = new ArrayList<Integer>(10);
        private boolean isOnlyOneRowCol = false;

        public MatchBaseInfo(PositionInfo positioninfo, BasePointInfo basepoint, List<Integer> rowOrcols) {
            this.positioninfo = positioninfo;
            this.setBasepoint(basepoint);
            this.rowOrcols = rowOrcols;
        }

        public PositionInfo getPositioninfo() {
            return this.positioninfo;
        }

        public void setPositioninfo(PositionInfo positioninfo) {
            this.positioninfo = positioninfo;
        }

        public BasePointInfo getBasepoint() {
            return this.basepoint;
        }

        public final void setBasepoint(BasePointInfo basepoint) {
            this.basepoint = basepoint;
        }

        public List<Integer> getRowOrcols() {
            return this.rowOrcols;
        }

        public void setRowOrcols(List<Integer> rowOrcols) {
            this.rowOrcols = rowOrcols;
        }

        public boolean isOnlyOneRowCol() {
            return this.isOnlyOneRowCol;
        }

        public void setOnlyOneRowCol(boolean isOnlyOneRowCol) {
            this.isOnlyOneRowCol = isOnlyOneRowCol;
        }
    }

    public static class FloatArea
    implements Serializable {
        private boolean isHasFloat = true;
        private String dynaRange;
        private String originalDynaRange;
        private String originalDynaRange_report;
        private List<Integer> deledata = new ArrayList<Integer>();
        private int rowMapSize = 0;
        private int originalStartIndex = 0;
        private int originalendIndex = 0;
        private int dynaStartindex = 0;
        private int dynaEndindex = 0;
        private int originalStartIndex_report = 0;
        private int originalendIndex_report = 0;
        private int floatSize = 0;
        private int needBlankFloat = 0;
        private boolean isCol = false;
        private boolean isDel_pre = true;

        public FloatArea(int originalStartIndex, int originalendIndex, int rowMapSize, boolean isCol, String originalDynaRange, String dynaRange, List<Integer> deledata) {
            this.originalDynaRange = originalDynaRange;
            this.dynaRange = dynaRange;
            this.originalStartIndex = originalStartIndex;
            this.originalendIndex = originalendIndex;
            this.rowMapSize = rowMapSize;
            int tempfloatsize = originalendIndex - originalStartIndex + 1;
            this.dynaStartindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[0]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[0]);
            this.dynaEndindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[1]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[1]);
            this.floatSize = this.dynaEndindex - this.dynaStartindex + 1;
            this.needBlankFloat = tempfloatsize - rowMapSize >= 2 ? 0 : (tempfloatsize == rowMapSize ? 2 : (tempfloatsize - rowMapSize == 1 ? 1 : 2));
            this.isCol = isCol;
            this.deledata.addAll(deledata);
        }

        public FloatArea(String originalDynaRange_report, int rowMapSize, boolean isCol, String originalDynaRange, String dynaRange, List<Integer> deledata) {
            this.originalDynaRange_report = originalDynaRange_report;
            this.originalDynaRange = originalDynaRange;
            this.dynaRange = dynaRange;
            this.originalStartIndex = isCol ? ExcelUtils.pos2X((String)originalDynaRange.split(":")[0]) : ExcelUtils.pos2Y((String)originalDynaRange.split(":")[0]);
            this.originalendIndex = isCol ? ExcelUtils.pos2X((String)originalDynaRange.split(":")[1]) : ExcelUtils.pos2Y((String)originalDynaRange.split(":")[1]);
            this.rowMapSize = rowMapSize;
            int tempfloatsize = this.originalendIndex - this.originalStartIndex + 1;
            this.dynaStartindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[0]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[0]);
            this.dynaEndindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[1]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[1]);
            this.originalStartIndex_report = isCol ? ExcelUtils.pos2X((String)originalDynaRange_report.split(":")[0]) : ExcelUtils.pos2Y((String)originalDynaRange_report.split(":")[0]);
            this.originalendIndex_report = isCol ? ExcelUtils.pos2X((String)originalDynaRange_report.split(":")[1]) : ExcelUtils.pos2Y((String)originalDynaRange_report.split(":")[1]);
            this.floatSize = this.dynaEndindex - this.dynaStartindex + 1;
            this.needBlankFloat = tempfloatsize - rowMapSize >= 2 ? 0 : (tempfloatsize == rowMapSize ? 2 : (tempfloatsize - rowMapSize == 1 ? 1 : 2));
            this.isCol = isCol;
            this.deledata.addAll(deledata);
        }

        public FloatArea(List<Integer> deledata, boolean isHasFloat) {
            this.deledata = deledata;
            this.rowMapSize += deledata.size();
            this.isHasFloat = isHasFloat;
        }

        public boolean isHasFloat() {
            return this.isHasFloat;
        }

        public String getDynaRange() {
            return this.dynaRange;
        }

        public String getOriginalDynaRange() {
            return this.originalDynaRange;
        }

        public int getOriginalStartIndex() {
            return this.originalStartIndex;
        }

        public int getOriginalendIndex() {
            return this.originalendIndex;
        }

        public int getDynaStartindex() {
            return this.dynaStartindex;
        }

        public int getDynaEndindex() {
            return this.dynaEndindex;
        }

        public int getFloatSize() {
            return this.floatSize;
        }

        public int getRowMapSize() {
            return this.rowMapSize;
        }

        public int getNeedBlankFloat() {
            return this.needBlankFloat;
        }

        public boolean isCol() {
            return this.isCol;
        }

        public List<Integer> getDeledata() {
            return this.deledata;
        }

        public String getOriginalDynaRange_report() {
            return this.originalDynaRange_report;
        }

        public int getOriginalStartIndex_report() {
            return this.originalStartIndex_report;
        }

        public int getOriginalendIndex_report() {
            return this.originalendIndex_report;
        }

        public boolean isDel_pre() {
            return this.isDel_pre;
        }

        public void setDel_pre(boolean del_pre) {
            this.isDel_pre = del_pre;
        }

        public String getAreaSimpleInfo() {
            return "dynaRange:" + this.dynaRange + "; originalDynaRange:" + this.originalDynaRange + "; originalDynaRange_report:" + this.originalDynaRange_report + "; rowMapSize" + this.rowMapSize + "; deledata:" + this.deledata.toString() + "; ";
        }
    }
}

