/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.formplugin.template.util.TemplateSeqUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AutoFloatUtil {
    public static void fixBaseInfo(long modelId, BasePointInfo basePointInfo) {
        basePointInfo.getBasePointInnerLineInfo().forEach(f -> {
            if (!f.isFloated() && DimTypesEnum.ENTITY.getNumber().equals(f.getDimension().getNumber())) {
                f.getDynaMembScopes().forEach(s -> {
                    if (s.getMember().getPar_SonNum() == null) {
                        IDNumberTreeNode node = MemberReader.findMemberById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimEntityNumEnum.ENTITY.getEntityNum(), (Long)s.getMember().getId());
                        if (node == IDNumberTreeNode.NotFoundTreeNode) {
                            node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (String)s.getMember().getNumber());
                        }
                        ((DimMember)s.getMember()).setPar_SonNum(node.getParent_SonNumber());
                    }
                });
            }
        });
    }

    public static void reGenerateSeqCol(SpreadManager sm, SpreadEasyInvoker invoker) {
        if (invoker != null) {
            invoker.setBatch(true);
        }
        Sheet sheet = sm.getBook().getSheet(0);
        if (Objects.isNull(sm.getAreaManager()) || CollectionUtils.isEmpty((Collection)sm.getAreaManager().getPostionInfoSet())) {
            return;
        }
        for (PositionInfo positionInfo : AutoFloatUtil.getSortSeqPositionInfo(sm)) {
            SequenceInfo sequenceInfo = positionInfo.getSequenceInfo();
            String seqArea = sequenceInfo.getSeqArea();
            SequenceInfo fromarea = sequenceInfo.getFromarea();
            int initvalue = sequenceInfo.getInitvalue();
            if (fromarea != null) {
                initvalue = fromarea.isExitEffectValue() ? fromarea.getEndValue() : fromarea.getInitvalue();
            }
            RangeModel effectRangModel = new RangeModel(seqArea);
            AtomicInteger endValue = new AtomicInteger(initvalue);
            if (sequenceInfo.isFixValue()) {
                effectRangModel = new RangeModel(seqArea);
                Cell cell2 = sheet.getCell(effectRangModel.getY_start(), effectRangModel.getX_start());
                cell2.setValue((Object)sequenceInfo.getFixValue());
                if (invoker != null) {
                    invoker.setSingleSpan(effectRangModel.getY_start(), effectRangModel.getX_start(), effectRangModel.getY_end() - effectRangModel.getY_start() + 1, effectRangModel.getX_end() - effectRangModel.getX_start() + 1);
                    invoker.updataValue(cell2.getRow(), cell2.getCol(), cell2.getValue());
                }
                effectRangModel = null;
            } else if (Objects.nonNull(positionInfo.getExtendInfo())) {
                effectRangModel = AutoFloatUtil.getLastEffectRangeModel(positionInfo.getExtendInfo().isDirectHoriz(), sequenceInfo.isDirectHoriz(), new RangeModel(sequenceInfo.getSeqArea()), new RangeModel(positionInfo.getAreaRange()), sheet, true);
            } else if (CollectionUtils.isNotEmpty((Collection)positionInfo.getBasePoints())) {
                effectRangModel = null;
                for (BasePointInfo basePointInfo : FloatLogicImpl.sortBasePoint(positionInfo.getBasePoints())) {
                    effectRangModel = AutoFloatUtil.getLastEffectRangeModel(basePointInfo.isDirectHoriz(), sequenceInfo.isDirectHoriz(), new RangeModel(sequenceInfo.getSeqArea()), new RangeModel(basePointInfo.getDynaRange()), sheet, false);
                    if (!Objects.nonNull(effectRangModel)) continue;
                    sheet.iteratorRangeCells(effectRangModel, true, cell -> {
                        cell.setValue((Object)TemplateSeqUtil.generateCellValueForSequence(sequenceInfo, endValue.get()));
                        if (invoker != null) {
                            invoker.updataValue(cell.getRow(), cell.getCol(), cell.getValue());
                        }
                        endValue.getAndIncrement();
                    });
                    effectRangModel = null;
                }
            }
            if (Objects.nonNull(effectRangModel)) {
                sheet.iteratorRangeCells(effectRangModel, true, cell -> {
                    cell.setValue((Object)TemplateSeqUtil.generateCellValueForSequence(sequenceInfo, endValue.get()));
                    endValue.getAndIncrement();
                    if (invoker != null) {
                        invoker.updataValue(cell.getRow(), cell.getCol(), cell.getValue());
                    }
                });
            }
            sequenceInfo.setEndValue(endValue.get());
        }
        if (invoker != null) {
            invoker.startToInvoke();
        }
    }

    public static void reGenerateSeqCol(SpreadManager sm) {
        AutoFloatUtil.reGenerateSeqCol(sm, null);
    }

    private static RangeModel getLastEffectRangeModel(boolean floatType, boolean isDirect, RangeModel seqModel, RangeModel dataRangeModel, Sheet sheet, final boolean isExt) {
        int startRow = isDirect ? seqModel.getY_start() : dataRangeModel.getY_start();
        int endRow = isDirect ? seqModel.getY_start() : dataRangeModel.getY_end();
        int startCol = isDirect ? dataRangeModel.getX_start() : seqModel.getX_start();
        int endCol = isDirect ? dataRangeModel.getX_end() : seqModel.getX_start();
        RangeModel effectRangModel = new RangeModel(startCol, endCol, startRow, endRow);
        Predicate<Cell> predicate = new Predicate<Cell>(){

            @Override
            public boolean test(Cell cell) {
                if (isExt) {
                    return Objects.nonNull(cell.getValue()) && StringUtils.isNotEmpty((CharSequence)cell.getValue().toString());
                }
                return cell.isMdDataDomain();
            }
        };
        if (isDirect && floatType || !isDirect && !floatType) {
            int lastIndex = -1;
            for (int end = isDirect ? endCol : endRow; end >= (isDirect ? startCol : startRow); --end) {
                List cells;
                List list = cells = isDirect ? sheet.getCol(end) : sheet.getRow(end);
                if (!cells.stream().anyMatch(cell -> predicate.test((Cell)cell))) continue;
                lastIndex = end;
                break;
            }
            if (lastIndex == -1) {
                effectRangModel = null;
            } else if (isDirect) {
                effectRangModel.setX_end(lastIndex);
            } else {
                effectRangModel.setY_end(lastIndex);
            }
        }
        return effectRangModel;
    }

    private static List<PositionInfo> getSortSeqPositionInfo(SpreadManager sm) {
        ArrayList<PositionInfo> positionInfos = new ArrayList<PositionInfo>(16);
        ArrayList<String> dataAreaList = new ArrayList<String>(16);
        Set<PositionInfo> infoSet = sm.getAreaManager().getPostionInfoSet().stream().filter(f -> f.getSequenceInfo() != null).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(infoSet)) {
            Iterator iterator = infoSet.iterator();
            while (iterator.hasNext()) {
                PositionInfo e = (PositionInfo)iterator.next();
                if (!Objects.isNull(e.getSequenceInfo().getFromarea())) continue;
                positionInfos.add(e);
                dataAreaList.add(e.getAreaRange());
                iterator.remove();
            }
            if (!infoSet.isEmpty() && !positionInfos.isEmpty()) {
                AtomicInteger cycNums = new AtomicInteger(0);
                AutoFloatUtil.dealPositionInfos(positionInfos, dataAreaList, infoSet, cycNums, (positionInfos.size() + infoSet.size()) * infoSet.size());
            }
        }
        return positionInfos;
    }

    private static void dealPositionInfos(List<PositionInfo> positionInfos, List<String> dataAreaList, Set<PositionInfo> infoSet, AtomicInteger cycNums, int maxCycNums) {
        if (cycNums.get() > maxCycNums) {
            return;
        }
        cycNums.getAndIncrement();
        if (CollectionUtils.isNotEmpty(infoSet) && CollectionUtils.isNotEmpty(dataAreaList)) {
            Iterator<PositionInfo> iterator = infoSet.iterator();
            while (iterator.hasNext()) {
                PositionInfo e = iterator.next();
                if (!dataAreaList.contains(e.getSequenceInfo().getFromarea().getDataArea())) continue;
                positionInfos.add(e);
                dataAreaList.add(e.getAreaRange());
                iterator.remove();
            }
        }
        if (CollectionUtils.isNotEmpty(infoSet) && CollectionUtils.isNotEmpty(dataAreaList)) {
            AutoFloatUtil.dealPositionInfos(positionInfos, dataAreaList, infoSet, cycNums, maxCycNums);
        }
    }

    public static void clearOldSeqInfo(SpreadManager sm) {
        if (Objects.isNull(sm.getAreaManager()) || CollectionUtils.isEmpty((Collection)sm.getAreaManager().getPostionInfoSet())) {
            return;
        }
        Sheet sheet = sm.getBook().getSheet(0);
        sm.getAreaManager().getPostionInfoSet().forEach(p -> {
            if (Objects.nonNull(p.getSequenceInfo())) {
                sheet.iteratorRangeCells(new RangeModel(p.getSequenceInfo().getSeqArea()), cell -> cell.setValue(null));
            }
        });
    }

    public static List<Row> alternateFloatData(List<Row> rows, final List<String> dims, boolean isAlternateFloat) {
        if (!isAlternateFloat || !dims.containsAll(Lists.newArrayList((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber()})) || rows.isEmpty()) {
            return rows;
        }
        final ArrayList<Row> newRows = new ArrayList<Row>(rows.size());
        Iterator<Row> iterator = rows.iterator();
        final HashMap<String, String> map = new HashMap<String, String>(16);
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            final HashMap tempMap = new HashMap(16);
            Predicate<Row> predicate = new Predicate<Row>(){

                @Override
                public boolean test(Row r) {
                    if (map.isEmpty() || newRows.contains(r)) {
                        return false;
                    }
                    tempMap.clear();
                    dims.forEach(k -> tempMap.put(k, r.getString(k)));
                    return map.equals(tempMap);
                }
            };
            if (!isFirst) {
                Optional<Row> optional = rows.stream().filter(predicate).findFirst();
                if (optional.isPresent()) {
                    Row row1 = optional.get();
                    newRows.add(row1);
                    AutoFloatUtil.getLastRowMap(map, dims, row1);
                }
            } else {
                isFirst = false;
            }
            if (!newRows.contains(row)) {
                newRows.add(row);
                AutoFloatUtil.getLastRowMap(map, dims, row);
            }
            iterator.remove();
        }
        rows = newRows;
        return rows;
    }

    private static void getLastRowMap(Map<String, String> map, List<String> dims, Row row) {
        dims.forEach(k -> {
            if (DimTypesEnum.ENTITY.getNumber().equals(k)) {
                map.put(DimTypesEnum.ENTITY.getNumber(), row.getString(DimTypesEnum.INTERCOMPANY.getNumber()));
            } else if (DimTypesEnum.INTERCOMPANY.getNumber().equals(k)) {
                map.put(DimTypesEnum.INTERCOMPANY.getNumber(), row.getString(DimTypesEnum.ENTITY.getNumber()));
            } else {
                map.put((String)k, row.getString(k));
            }
        });
    }

    public static DynamicObject getAlternateFloatRecord(TemplateModel template, Object pk, String selectProperties) {
        DynamicObject currentreport = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bcm_reportentity", (String)selectProperties);
        if (Objects.isNull(currentreport)) {
            return currentreport;
        }
        Pair<String, String> pair = AutoFloatUtil.dealAlternateFloatRecord(template, currentreport.getString("data"), currentreport.getString("spreadjson"));
        currentreport.set("data", pair.p1);
        currentreport.set("spreadjson", pair.p2);
        return currentreport;
    }

    public static Pair<String, String> dealAlternateFloatRecord(TemplateModel template, String spreadSerial, String spreadJson) {
        if (StringUtils.isEmpty((CharSequence)spreadSerial)) {
            spreadSerial = template.getRptData();
        }
        return Pair.onePair((Object)spreadSerial, (Object)spreadJson);
    }

    public static boolean isSyncLockStatus(Sheet sheet) {
        Object object = sheet.getUserObject("isSyncLockStatus");
        return object instanceof Boolean && (Boolean)object != false;
    }

    public static void setSyncLockStatus(Sheet sheet, boolean flag) {
        sheet.putUserObject("isSyncLockStatus", (Object)flag);
    }

    public static boolean isAlternateFloat(SpreadManager sm, boolean isFromReport) {
        if (isFromReport && !AutoFloatUtil.isOrgAndIcFloat(sm)) {
            return false;
        }
        Object object = sm.getBook().getSheet(0).getUserObject("alternatefloat");
        return object instanceof Boolean && (Boolean)object != false;
    }

    public static void setAlternateFloat(Sheet sheet, boolean flag) {
        sheet.putUserObject("alternatefloat", (Object)flag);
    }

    public static boolean isAlternateFloat(TemplateModel tm) {
        if (!tm.isSaveByDim() || !TemplateExtendModelRefUtil.isOnlyReadOrQueryTm(tm)) {
            return false;
        }
        return (Boolean)GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateAlternateFloatCache).getOrLoad(AutoFloatUtil.getAlternateFloatCacheKey(tm.getModelId(), tm.getId()), () -> AutoFloatUtil.isAlternateFloat(JsonSerializerUtil.toSpreadManager((String)tm.getRptData()), true));
    }

    private static String getAlternateFloatCacheKey(Object modelId, Object id) {
        return String.join((CharSequence)"_", "templatealternatefloat", "" + modelId, "" + id);
    }

    public static void clearTemplateAlternateFloatCache(TemplateModel tm, SpreadManager sm) {
        String cacheKey = AutoFloatUtil.getAlternateFloatCacheKey(tm.getModelId(), tm.getId());
        Object o = GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateAlternateFloatCache).getIfPresent(cacheKey);
        if (o instanceof Boolean && AutoFloatUtil.isAlternateFloat(sm, true) != (Boolean)o) {
            GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateAlternateFloatCache).invalidateByKey(cacheKey);
        }
    }

    public static void clearTemplateAlternateFloatCache(Object modelId, Object ... ids) {
        ArrayList<String> keys = new ArrayList<String>(16);
        for (Object id : ids) {
            keys.add(AutoFloatUtil.getAlternateFloatCacheKey(modelId, id));
        }
        GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateAlternateFloatCache).invalidateByKeys(keys.toArray(new String[0]));
    }

    private static boolean isOrgAndIcFloat(SpreadManager sm) {
        Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
        if (CollectionUtils.isNotEmpty((Collection)postionInfoSet)) {
            Predicate<PositionInfo> predicate = new Predicate<PositionInfo>(){

                @Override
                public boolean test(PositionInfo p) {
                    List basePoints = p.getBasePoints();
                    if (CollectionUtils.isNotEmpty((Collection)basePoints)) {
                        return basePoints.stream().anyMatch(e -> {
                            boolean isOrgFloat = e.getBasePointInnerLineInfo().stream().anyMatch(b -> b.isFloated() && DimTypesEnum.ENTITY.getNumber().equals(b.getDimension().getNumber()));
                            boolean isIcFloat = e.getBasePointInnerLineInfo().stream().anyMatch(b -> b.isFloated() && DimTypesEnum.INTERCOMPANY.getNumber().equals(b.getDimension().getNumber()));
                            return isOrgFloat && isIcFloat;
                        });
                    }
                    return false;
                }
            };
            return postionInfoSet.stream().anyMatch(predicate);
        }
        return false;
    }

    public static RangeModel getFloatRangeModel(PositionInfo pos, final int index, final boolean isRow) {
        RangeModel rangeModel = new RangeModel(pos.getAreaRange());
        if (pos.getExtendInfo() == null && pos.isFloatPosition()) {
            Predicate<BasePointInfo> predicate = new Predicate<BasePointInfo>(){

                @Override
                public boolean test(BasePointInfo b) {
                    return isRow ? new RangeModel(b.getDynaRange()).isRowInArea(index) : new RangeModel(b.getDynaRange()).isColInArea(index);
                }
            };
            Optional<BasePointInfo> optional = pos.getBasePoints().stream().filter(predicate).findFirst();
            if (!optional.isPresent()) {
                return rangeModel;
            }
            BasePointInfo basePointInfo = optional.get();
            if (basePointInfo != null) {
                RangeModel range = new RangeModel(basePointInfo.getDynaRange());
                if (isRow) {
                    rangeModel.setY_start(range.getY_start());
                    rangeModel.setY_end(range.getY_end());
                } else {
                    rangeModel.setX_end(range.getX_end());
                    rangeModel.setX_start(range.getX_start());
                }
            }
        }
        return rangeModel;
    }
}

