/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.DimGroupKey;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MemberGroupKey;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.extreport.ExtReportModelHandle;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.HideLogicImpl;
import kd.fi.bcm.formplugin.report.floatreport.OffsetLogicImpl;
import kd.fi.bcm.formplugin.report.style.adjust.FloatDataProvider;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;
import org.apache.commons.collections.CollectionUtils;

public class AutoFloatWithoutViewHandle
implements Serializable {
    public static final String DIMENDIONAME = "dinemsioname";
    public static final String CLEARDATA = "cleardata";
    public static final String FLOATTYPE = "floattype";
    public static final String UPADTEEVT = "updateevt";
    public static final String PROCESSING = "processing";
    public static final String PASTEINDEX = "pasteindex";
    public static final String floatarea = "floatarea";
    private TemplateModel templateModel;
    private SpreadManager sm;
    private Map<String, Map<String, Map<String, String>>> result;
    private String reportOrgNumber;
    private List<Row> rowslimitfix;
    private PositionInfo positionInfo;
    private BasePointInfo basePointInfo;
    private long orgSchemeId = 0L;
    private IRelaMembSupplier<String, String> relaMembSupplier;
    private IRelaMembSupplier<String, String> periodSupplier;
    private String sceneNumber;
    private long modelId;
    private boolean isAlternateFloat = false;
    private HashMap<String, DataTypeAcctCacheInfo> dataTypeMap;
    private PositionInfo.FloatMemDisplayPattern floatDisplayPattern = null;
    private ExtReportModelHandle extModelHandle;
    private List<Integer> deledata = new ArrayList<Integer>();
    private static final String MATCHBASEINFOWITHROWCOL = "matchbaseinfowithrowcol";

    public PositionInfo.FloatMemDisplayPattern getFloatDisplayPattern() {
        return this.floatDisplayPattern;
    }

    public void setFloatDisplayPattern(PositionInfo.FloatMemDisplayPattern floatDisplayPattern) {
        this.floatDisplayPattern = floatDisplayPattern;
    }

    public void clearEffectiveThreadCache() {
        ThreadCache.remove((Object)floatarea);
        ThreadCache.remove((Object)MATCHBASEINFOWITHROWCOL);
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public AutoFloatWithoutViewHandle() {
    }

    public AutoFloatWithoutViewHandle(SpreadManager sm, TemplateModel templateModel) {
        this.sm = sm;
        this.templateModel = templateModel;
    }

    public void setRelaMembSupplier(IRelaMembSupplier<String, String> relaMembSupplier) {
        this.relaMembSupplier = relaMembSupplier;
    }

    public void setPeriodSupplier(IRelaMembSupplier<String, String> periodSupplier) {
        this.periodSupplier = periodSupplier;
        ReportSpecialVariableUtil.cachePeriodSupplier((SpreadManager)this.sm, periodSupplier);
    }

    public void autoFloat(boolean isCsl, String orgNumber) {
        this.isAlternateFloat = AutoFloatUtil.isAlternateFloat(this.templateModel);
        this.dataTypeMap = AutoFloatWithoutViewHandle.getDataTypeThreadCache(this.modelId);
        this.reportOrgNumber = orgNumber;
        Map<String, MDResultSet> setmap = FloatDataProvider.queryMDResultSetMapByPageAndView(this.sm, this.modelId, AutoFloatWithoutViewHandle.isDirectHoriz(), this.relaMembSupplier, this.periodSupplier);
        Iterator<PositionInfo> iterator = FloatLogicImpl.sortPositionInfo(this.sm.getAreaManager().getPostionInfoSet(), AutoFloatWithoutViewHandle.isDirectHoriz()).iterator();
        while (iterator.hasNext()) {
            PositionInfo ps;
            this.positionInfo = ps = iterator.next();
            if (this.positionInfo.getExtendInfo() != null && this.extModelHandle != null) {
                this.extModelHandle.autoLoadExtReport(this.sm, this.relaMembSupplier, this.positionInfo);
            }
            if (this.positionInfo.getBasePoints() == null || this.positionInfo.getBasePoints().isEmpty()) continue;
            Iterator<BasePointInfo> iterator2 = FloatLogicImpl.sortBasePoint(this.positionInfo.getBasePoints()).iterator();
            while (iterator2.hasNext()) {
                List<String> dmNumberLis;
                BasePointInfo bpi;
                this.basePointInfo = bpi = iterator2.next();
                if (this.basePointInfo.getTopSettingOrder() != null && !this.basePointInfo.getTopSettingOrder().isEmpty()) {
                    ArrayList<String> floatnumber = new ArrayList<String>();
                    for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
                        if (!info.isFloated()) continue;
                        floatnumber.add(info.getDimension().getNumber());
                    }
                    this.clearFloatMemberAndValue(floatnumber);
                }
                if ((dmNumberLis = this.getDmNumberLis()) == null) continue;
                List<Row> rows = this.getRows(isCsl, setmap);
                if (rows.isEmpty() && this.isNoRecord(setmap, bpi) && !this.isBlankAreaNoCrossDimCell(bpi.getDataArea(ps)) && ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"clearNoValueRowOrCol")) {
                    this.clearNoValueRowOrCol();
                }
                AutoFloatUtil.fixBaseInfo(this.modelId, this.basePointInfo);
                this.checkAndFloat(rows);
            }
            this.clearUnExitMember(this.positionInfo);
        }
    }

    public void clearNoDataRC(SpreadManager sm) {
        boolean isDir = sm.isHorizon() == 1;
        for (PositionInfo ps : FloatLogicImpl.sortPositionInfo(sm.getAreaManager().getPostionInfoSet(), isDir)) {
            for (BasePointInfo basePointInfo : FloatLogicImpl.sortBasePoint(ps.getBasePoints())) {
                List<Integer> deledata = FloatLogicImpl.getHasMemNotValueRC_OutOriRange(sm, ps, basePointInfo);
                RangeModel range = new RangeModel(basePointInfo.getDynaRange());
                String rangeStr = basePointInfo.getDynaRange();
                RangeModel oriRange = new RangeModel(basePointInfo.getOriginalDynaRange());
                String originalDynaRange = basePointInfo.getOriginalDynaRange();
                RangeModel oriRangeModel = new RangeModel(originalDynaRange);
                int areaFloatSize = isDir ? range.getColSize() : range.getRowSize();
                int ori_AreaFloatSize = isDir ? oriRange.getColSize() : oriRange.getRowSize();
                if (deledata.isEmpty() || areaFloatSize == ori_AreaFloatSize && deledata.size() == areaFloatSize) continue;
                if (areaFloatSize == deledata.size() && areaFloatSize > 0) {
                    deledata.remove(0);
                }
                AskExcuteInfo excuteinfo = isDir ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
                SpreadDataModel.adjustSheet(excuteinfo, sm);
                this.adjustPositonInfo(excuteinfo);
                ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
                cache.add(new AutoFloatLogicImpl.FloatArea(rangeStr, 0, basePointInfo.isDirectHoriz(), originalDynaRange, basePointInfo.getDynaRange(), deledata));
                ArrayList<Integer> insertData = new ArrayList<Integer>(16);
                if (areaFloatSize - deledata.size() < ori_AreaFloatSize) {
                    RangeModel cur_range = new RangeModel(basePointInfo.getDynaRange());
                    int cur_areaFloatSize = isDir ? cur_range.getColSize() : cur_range.getRowSize();
                    int repairRowSum = ori_AreaFloatSize - cur_areaFloatSize;
                    int endIndex = isDir ? cur_range.getX_end() : cur_range.getY_end();
                    for (int i = 0; i < repairRowSum; ++i) {
                        insertData.add(endIndex);
                    }
                }
                if (insertData.isEmpty()) continue;
                originalDynaRange = basePointInfo.getOriginalDynaRange();
                AskExcuteInfo insertExcuteinfo = isDir ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertData) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertData);
                insertExcuteinfo.setRev(true);
                SpreadDataModel.adjustSheet(insertExcuteinfo, sm);
                this.adjustPositonInfo(insertExcuteinfo);
                rangeStr = basePointInfo.getDynaRange();
                cache.add(new AutoFloatLogicImpl.FloatArea(rangeStr, insertData.size(), basePointInfo.isDirectHoriz(), originalDynaRange, basePointInfo.getDynaRange(), deledata));
                ThreadCache.put((Object)floatarea, cache);
            }
        }
    }

    private void clearUnExitMember(PositionInfo positionInfo) {
        if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) {
            return;
        }
        boolean isH = ((BasePointInfo)positionInfo.getBasePoints().get(0)).isDirectHoriz();
        Tuple tu = this.sm.getAreaManager().getRowAndColDomainByPosition(positionInfo);
        HashMultimap map = HashMultimap.create();
        RangeModel pom = new RangeModel(positionInfo.getAreaRange());
        for (int x = pom.getX_start(); x <= pom.getX_end(); ++x) {
            for (int y = pom.getY_start(); y <= pom.getY_end(); ++y) {
                Cell cell = this.sm.getBook().getSheet(0).getCell(y, x);
                if (cell.getMemberFromUserObject() == null) continue;
                cell.getMemberFromUserObject().forEach(arg_0 -> AutoFloatWithoutViewHandle.lambda$clearUnExitMember$0((Multimap)map, arg_0));
            }
        }
        if (isH) {
            if (tu.v != null) {
                ((ColumnDimDomain)tu.v).getDimensions().forEach(arg_0 -> AutoFloatWithoutViewHandle.lambda$clearUnExitMember$2((Multimap)map, arg_0));
            }
        } else if (tu.k != null) {
            ((RowDimDomain)tu.k).getDimensions().forEach(arg_0 -> AutoFloatWithoutViewHandle.lambda$clearUnExitMember$4((Multimap)map, arg_0));
        }
    }

    private void clearFloatMemberAndValue(List<String> floatnumber) {
        TemplateScanMemberService service = new TemplateScanMemberService(this.sm, this.templateModel);
        Set<Point> points = service.getFloatFirst(this.sm);
        String dynaRange = this.basePointInfo.getDynaRange();
        String areaRange = this.positionInfo.getAreaRange();
        RangeModel dynaRangeModel = SpreadAreaUtil.getRangModel((String)dynaRange);
        RangeModel areaRangModel = SpreadAreaUtil.getRangModel((String)areaRange);
        String realRange = "";
        realRange = this.basePointInfo.isDirectHoriz() ? ExcelUtils.xy2Pos((int)dynaRangeModel.getX_start(), (int)areaRangModel.getY_start()) + ":" + ExcelUtils.xy2Pos((int)dynaRangeModel.getX_end(), (int)areaRangModel.getY_end()) : ExcelUtils.xy2Pos((int)areaRangModel.getX_start(), (int)dynaRangeModel.getY_start()) + ":" + ExcelUtils.xy2Pos((int)areaRangModel.getX_end(), (int)dynaRangeModel.getY_end());
        this.collectCell(points, SpreadAreaUtil.getRangModel((String)realRange), floatnumber);
        this.collectCell(points, dynaRangeModel, floatnumber);
    }

    private void collectCell(Set<Point> points, RangeModel rangeModel, List<String> floatnumber) {
        for (int rowIndex = rangeModel.getY_start(); rowIndex <= rangeModel.getY_end(); ++rowIndex) {
            for (int colIndex = rangeModel.getX_start(); colIndex <= rangeModel.getX_end(); ++colIndex) {
                Cell cell = this.getEffectiveSheet().getCell(rowIndex, colIndex);
                Point point = new Point(cell.getCol(), cell.getRow());
                cell.setValue(null);
                cell.setChangeVal(false);
                cell.setMdDataDomain(false);
                if (points.contains(point)) {
                    List userObject = cell.getMemberFromUserObject();
                    if (null == userObject) continue;
                    Iterator iterator = userObject.iterator();
                    while (iterator.hasNext()) {
                        IDimMember dimMember = (IDimMember)iterator.next();
                        if (!floatnumber.contains(dimMember.getDimension().getNumber())) continue;
                        iterator.remove();
                    }
                    continue;
                }
                cell.clearMembersOfUserObject();
                if (cell.getUserObject().containsKey((Object)"floatmember")) {
                    cell.removeUserObject("floatmember");
                }
                if (!cell.getUserObject().containsKey((Object)"seqobject")) continue;
                cell.removeUserObject("seqobject");
            }
        }
    }

    private boolean isNoRecord(Map<String, MDResultSet> valueMap, BasePointInfo bp) {
        MDResultSet rs = valueMap.get(bp.getOriginalDynaRange());
        boolean isNoRecord = rs == null || rs.getCount() <= 0;
        rs = valueMap.get(bp.getOriginalDynaRange() + "unleaf");
        return isNoRecord && (rs == null || rs.getCount() <= 0);
    }

    private boolean isBlankAreaNoCrossDimCell(RangeModel range) {
        Recorder bool = new Recorder((Object)false);
        this.getEffectiveSheet().iteratorRangeByPredicateBreak(range.getY_start(), range.getY_end(), range.getX_start(), range.getX_end(), cell -> {
            bool.setRecord((Object)cell.isMdDataDomain());
            return cell.isMdDataDomain();
        });
        return (Boolean)bool.getRecord() == false;
    }

    private void clearNoValueRowOrCol() {
        AskExcuteInfo insexcuteinfo;
        int i;
        int originacolorrow;
        String range = this.basePointInfo.getDynaRange();
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        RangeModel originaldynaRange = new RangeModel(this.basePointInfo.getOriginalDynaRange());
        ArrayList<Integer> deledata = new ArrayList<Integer>(10);
        ArrayList<Integer> insertdata = new ArrayList<Integer>(10);
        int n = originacolorrow = this.basePointInfo.isDirectHoriz() ? originaldynaRange.getX_end() - originaldynaRange.getX_start() + 1 : originaldynaRange.getY_end() - originaldynaRange.getY_start() + 1;
        if (this.basePointInfo.isDirectHoriz()) {
            for (i = rangeModel.getX_start(); i < rangeModel.getX_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getX_end() + originacolorrow);
        } else {
            for (i = rangeModel.getY_start(); i < rangeModel.getY_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getY_end() + originacolorrow);
        }
        int start2insert = this.basePointInfo.isDirectHoriz() ? rangeModel.getX_end() : rangeModel.getY_end();
        for (int i2 = 0; i2 < originacolorrow; ++i2) {
            insertdata.add(start2insert);
        }
        AskExcuteInfo askExcuteInfo = insexcuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        if (!this.basePointInfo.isDirectHoriz()) {
            insexcuteinfo.setCon(true);
        }
        insexcuteinfo.setRev(AutoFloatLogicImpl.isRev);
        this.adjustSheetModelAndJs(insexcuteinfo);
        AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
        this.adjustSheetModelAndJs(excuteinfo);
        ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
        deledata.sort(Comparator.naturalOrder());
        AutoFloatLogicImpl.FloatArea floatArea = new AutoFloatLogicImpl.FloatArea(range, insertdata.size(), this.basePointInfo.isDirectHoriz(), this.basePointInfo.getOriginalDynaRange(), this.basePointInfo.getDynaRange(), deledata);
        floatArea.setDel_pre(false);
        cache.add(floatArea);
        ThreadCache.put((Object)floatarea, cache);
    }

    private void checkAndFloat(List<Row> rows) {
        Map fixmem = this.basePointInfo.getFixMemberPosition();
        Set fixmemset = fixmem.entrySet();
        String range = this.basePointInfo.getDynaRange();
        String originalDynaRange = this.basePointInfo.getOriginalDynaRange();
        int rangestartindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
        int rangeendindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
        int startvalueindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)this.positionInfo.getStartPosition().split(":")[0]) : ExcelUtils.pos2X((String)this.positionInfo.getStartPosition().split(":")[0]);
        int floatAreaNumber = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)range.split(":")[1]) - ExcelUtils.pos2Y((String)range.split(":")[0]) + 1 : ExcelUtils.pos2X((String)range.split(":")[1]) - ExcelUtils.pos2X((String)range.split(":")[0]) + 1;
        ArrayList<String> floatnumber = new ArrayList<String>();
        if (fixmemset.isEmpty()) {
            return;
        }
        this.filterFloatDim(rows, floatnumber);
        if (!this.basePointInfo.getShowFloatMember(this.positionInfo).booleanValue()) {
            rows = this.filterByFixMembers(rows);
        }
        if (rows.isEmpty()) {
            this.clearFloatMemberAndValue(floatnumber);
            return;
        }
        if (this.basePointInfo.getTopSettingOrder() != null && !this.basePointInfo.getTopSettingOrder().isEmpty()) {
            rows = this.sortRowsBySetting(rows, floatAreaNumber);
        }
        this.rowslimitfix = rows;
        if (this.checkHasFloat((Integer)fixmem.keySet().iterator().next(), floatnumber, rangestartindex, rangeendindex, startvalueindex)) {
            ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
            cache.add(new AutoFloatLogicImpl.FloatArea(range, 0, this.basePointInfo.isDirectHoriz(), originalDynaRange, this.basePointInfo.getDynaRange(), this.deledata));
            ThreadCache.put((Object)floatarea, cache);
            this.deledata.clear();
            return;
        }
        if (this.basePointInfo.getTopSettingOrder() == null || this.basePointInfo.getTopSettingOrder().isEmpty()) {
            FloatDataProvider.sortRowByDim(this.rowslimitfix, floatnumber.toArray(new String[0]));
        }
        rows = AutoFloatUtil.alternateFloatData(rows, floatnumber, this.isAlternateFloat);
        this.rowslimitfix = rows;
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, floatnumber);
        DimGroupKey dimkey = new DimGroupKey(floatnumber);
        int start2insert = this.findStart2insertIndex(this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz());
        if (this.floatDisplayPattern != null) {
            this.basePointInfo.setFloatMemDisplayPattern(this.floatDisplayPattern);
        } else {
            this.basePointInfo.setFloatMemDisplayPattern(this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo));
        }
        this.result = FloatLogicImpl.collectMemMsg(this.rowslimitfix, this.basePointInfo, this.modelId);
        ArrayList<AutoFloatLogicImpl.FloatArea> cache = ThreadCache.get((Object)floatarea) != null ? (ArrayList<AutoFloatLogicImpl.FloatArea>)ThreadCache.get((Object)floatarea) : new ArrayList<AutoFloatLogicImpl.FloatArea>(16);
        int insertSum = this.insertRank(start2insert, rowMap.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz(), AutoFloatLogicImpl.isRev);
        cache.add(new AutoFloatLogicImpl.FloatArea(range, insertSum, this.basePointInfo.isDirectHoriz(), originalDynaRange, this.basePointInfo.getDynaRange(), this.deledata));
        this.deledata.clear();
        ThreadCache.put((Object)floatarea, cache);
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        for (MemberGroupKey dimlist : rowMap.keySet()) {
            this.updateSheetModel(dimlist, start2insert, rangeModel, dimkey);
            ++start2insert;
        }
    }

    private List<Row> sortRowsBySetting(List<Row> rows, int floatAreaNumber) {
        List maps = this.basePointInfo.getTopSettingOrder();
        HashMap<Integer, String> floatnumbers = new HashMap<Integer, String>(16);
        boolean isOrgFloat = false;
        boolean isIcFloat = false;
        int index = -1;
        for (Object info : this.basePointInfo.getBasePointInnerLineInfo()) {
            String dimNum = info.getDimension().getNumber();
            floatnumbers.put(info.getOffset(), dimNum);
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum) && info.isFloated()) {
                index = info.getOffset();
                isIcFloat = true;
            }
            if (!DimTypesEnum.ENTITY.getNumber().equals(dimNum) || !info.isFloated()) continue;
            isOrgFloat = true;
        }
        ArrayList<FloatDataProvider.SortSetting> sortSettings = new ArrayList<FloatDataProvider.SortSetting>(16);
        for (Map topSetting : maps) {
            Integer top = Integer.parseInt(String.valueOf(topSetting.get("top")));
            Integer orderby = Integer.parseInt(String.valueOf(topSetting.get("orderby")));
            String sortorder = String.valueOf(topSetting.get("sortorder"));
            if (orderby >= floatAreaNumber) {
                if (this.isAlternateFloat && isIcFloat && isOrgFloat && index == orderby) continue;
                sortSettings.add(new FloatDataProvider.SortSetting(top, orderby, Integer.parseInt(sortorder), ""));
                continue;
            }
            if (floatnumbers.get(orderby) == null || this.isAlternateFloat && isIcFloat && isOrgFloat && DimTypesEnum.INTERCOMPANY.getNumber().equals(floatnumbers.get(orderby))) continue;
            sortSettings.add(new FloatDataProvider.SortSetting(top, orderby, Integer.parseInt(sortorder), (String)floatnumbers.get(orderby)));
        }
        if (CollectionUtils.isEmpty(sortSettings)) {
            return rows;
        }
        int pattern = this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo).getIndex();
        Supplier<Integer> sortbyer = () -> pattern;
        FloatDataProvider.Sorter sorter = new FloatDataProvider.Sorter(sortSettings, rows, this.basePointInfo, this.modelId, sortbyer, this.positionInfo);
        sorter.setSchemeId(this.orgSchemeId);
        sorter.sortByStream();
        return sorter.getRows();
    }

    public String getSceneNumber() {
        return this.sceneNumber;
    }

    public void setSceneNumber(String sceneNumber) {
        this.sceneNumber = sceneNumber;
    }

    private List<Row> filterByFixMembers(List<Row> rows) {
        ArrayList<Row> realrows = new ArrayList<Row>(10);
        List samplemems = (List)this.basePointInfo.getFixMemberPosition().values().iterator().next();
        if (samplemems.isEmpty()) {
            return rows;
        }
        ArrayList<String> fixdim = new ArrayList<String>(samplemems.size());
        for (IDimMember m : samplemems) {
            fixdim.add(m.getDimension().getNumber());
        }
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, fixdim);
        for (List members : this.basePointInfo.getFixMemberPosition().values()) {
            ArrayList<String> objMembers = new ArrayList<String>(10);
            for (IDimMember m : members) {
                String memNum = m.getNumber();
                if (DimTypesEnum.CURRENCY.getNumber().equals(m.getDimension().getNumber()) && CurrencyTool.isTransCurrency((String)memNum)) {
                    return rows;
                }
                if (PresetConstant.PERIOD_DIM.equals(m.getDimension().getNumber()) && "LastPeriod".equals(memNum)) {
                    return rows;
                }
                if (!fixdim.contains(PresetConstant.PERIOD_DIM) && PresetConstant.FY_DIM.equals(m.getDimension().getNumber()) && "LastYear".equals(memNum)) {
                    return rows;
                }
                objMembers.add(memNum);
            }
            MemberGroupKey key = MemberGroupKey.create(objMembers);
            List<Row> list = rowMap.get(key);
            if (list == null) continue;
            realrows.addAll(list);
        }
        return realrows;
    }

    private void filterFloatDim(List<Row> rows, List<String> floatnumber) {
        for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
            if (!info.isFloated()) continue;
            floatnumber.add(info.getDimension().getNumber());
        }
        long orgId = 0L;
        if (this.relaMembSupplier instanceof OrgRelaMembSupplier) {
            orgId = ((OrgRelaMembSupplier)this.relaMembSupplier).get_mainOrgId();
        }
        HideLogicImpl.filterRows(rows, this.basePointInfo, this.sm, this.modelId, orgId);
    }

    private List<String> getDmNumberLis() {
        Iterator it = this.basePointInfo.getFixMemberPosition().values().iterator();
        ArrayList<String> dmNumberLis = new ArrayList<String>(10);
        if (it.hasNext()) {
            List dmList = (List)it.next();
            for (IDimMember dm : dmList) {
                dmNumberLis.add(dm.getDimension().getNumber());
            }
        } else {
            return null;
        }
        return dmNumberLis;
    }

    private List<Row> getRows(boolean isCsl, Map<String, MDResultSet> setmap) {
        List<Row> rows;
        if (isCsl) {
            rows = FloatDataProvider.getResultRowByArea(this.templateModel, this.sm, setmap, this.positionInfo, this.basePointInfo, this.dataTypeMap);
            long orgId = 0L;
            if (this.relaMembSupplier instanceof OrgRelaMembSupplier) {
                orgId = ((OrgRelaMembSupplier)this.relaMembSupplier).get_mainOrgId();
            }
            OffsetLogicImpl.cleanMdData(this.sm, this.templateModel, this.positionInfo, this.basePointInfo, rows, ThreadCache.get((Object)"Offset") != null, orgId);
        } else {
            rows = this.basePointInfo.getDirect() == 1 || this.basePointInfo.getDirect() == 2 ? FloatDataProvider.getResultRowByArea(this.templateModel, this.sm, setmap, this.positionInfo, this.basePointInfo, this.dataTypeMap) : FloatDataProvider.getResultRowByArea(setmap, this.basePointInfo.getOriginalDynaRange());
        }
        return rows;
    }

    private boolean checkHasFloat(int entryKey, List<String> floatnumber, int rangestartindex, int rangeendindex, int startvalueindex) {
        Map<MemberGroupKey, List<Row>> mapData = null;
        ArrayList<Integer> deledata = new ArrayList<Integer>(10);
        int moneyColIndex = -1;
        boolean gobyfilter = false;
        ArrayList<Pair> k = new ArrayList<Pair>(10);
        for (int i = rangestartindex; i <= rangeendindex; ++i) {
            Cell cell;
            Cell cell2 = cell = this.basePointInfo.isDirectHoriz() ? this.getEffectiveSheet().getCell(startvalueindex + entryKey, i) : this.getEffectiveSheet().getCell(i, startvalueindex + entryKey);
            if (!cell.isMdDataDomain()) continue;
            gobyfilter = true;
            List mems = cell.getMemberFromUserObject();
            if (mems != null && !mems.isEmpty()) {
                Object mem2;
                boolean floatEntity = false;
                for (Object mem2 : mems) {
                    if (!floatnumber.contains(mem2.getDimension().getNumber())) continue;
                    k.add(Pair.onePair((Object)mem2.getDimension().getNumber(), (Object)mem2.getNumber()));
                    if (!DimTypesEnum.ENTITY.getNumber().equals(mem2.getDimension().getNumber())) continue;
                    floatEntity = true;
                }
                if (cell.getUserObject("entity") != null) {
                    k.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)((String)cell.getUserObject("entity"))));
                } else if (!floatEntity) {
                    k.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)this.reportOrgNumber));
                }
                if (mapData == null) {
                    moneyColIndex = this.rowslimitfix.get(0).getColIndex(FacTabFieldDefEnum.FIELD_MONEY.getField());
                    ArrayList<String> dims = new ArrayList<String>(k.size());
                    for (Pair p : k) {
                        dims.add(p.p1.toString());
                    }
                    mapData = this.toRowMap(this.rowslimitfix, dims);
                }
                ArrayList<Object> members = new ArrayList<Object>(k.size());
                mem2 = k.iterator();
                while (mem2.hasNext()) {
                    Pair p;
                    p = (Pair)mem2.next();
                    members.add(p.p2);
                }
                MemberGroupKey key = MemberGroupKey.create(members);
                if (mapData.containsKey(key)) {
                    FloatDataProvider.dealRowByPack(mapData, key, cell, moneyColIndex);
                } else {
                    deledata.add(i);
                }
            }
            k.clear();
        }
        if (!deledata.isEmpty()) {
            List<Integer> clearData = this.dealFloatBlankRowCol(rangestartindex, rangeendindex, deledata);
            this.deledata.addAll(clearData);
        }
        if (gobyfilter) {
            if (mapData == null || mapData.isEmpty()) {
                return true;
            }
            this.rowslimitfix.clear();
            for (List rs : mapData.values()) {
                this.rowslimitfix.addAll(rs);
            }
        }
        return false;
    }

    private List<Integer> dealFloatBlankRowCol(int rangestartindex, int rangeendindex, List<Integer> deledata) {
        int cur_Index;
        Sheet sheet = this.sm.getBook().getSheet(0);
        if (this.basePointInfo.isDirectHoriz()) {
            for (Integer del_num : deledata) {
                sheet.resetColumn(del_num.intValue());
            }
        } else {
            for (Integer del_num : deledata) {
                sheet.resetRow(del_num.intValue());
            }
        }
        int lastHasVauleIndex = 0;
        if (this.basePointInfo.isDirectHoriz()) {
            for (cur_Index = rangeendindex; cur_Index >= rangestartindex; --cur_Index) {
                for (Cell cell : sheet.getCol(cur_Index)) {
                    if (cell.getValue() == null) continue;
                    lastHasVauleIndex = cur_Index;
                    break;
                }
                if (lastHasVauleIndex == 0) {
                    continue;
                }
                break;
            }
        } else {
            for (cur_Index = rangeendindex; cur_Index >= rangestartindex; --cur_Index) {
                for (Cell cell : sheet.getRow(cur_Index)) {
                    if (cell.getValue() == null) continue;
                    lastHasVauleIndex = cur_Index;
                    break;
                }
                if (lastHasVauleIndex == 0) {
                    continue;
                }
                break;
            }
        }
        int final_LastHasVauleRow = lastHasVauleIndex;
        List<Integer> clearData = deledata.stream().filter(d -> d < final_LastHasVauleRow).collect(Collectors.toList());
        AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, clearData) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, clearData);
        this.adjustSheetModelAndJs(excuteinfo);
        return clearData;
    }

    private void updateSheetModel(MemberGroupKey dimlist, int startIndex, RangeModel rangeModel, DimGroupKey dimkey) {
        int row = 0;
        int col = 0;
        ArrayList<IDimMember> members = new ArrayList<IDimMember>(10);
        for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
            String msg;
            int ordinal;
            PositionInfo.FloatMemDisplayPattern pattern;
            IDimMember member;
            int offset;
            if (info.isFloated()) {
                members.clear();
                offset = info.getOffset();
                if (info.isSeq() || info.isIshide()) {
                    offset = 0;
                }
                if (this.basePointInfo.isDirectHoriz()) {
                    row = rangeModel.getY_start() + offset;
                    col = startIndex;
                } else {
                    col = rangeModel.getX_start() + offset;
                    row = startIndex;
                }
                IDimension dimension = info.getDimension();
                String numbernum = dimlist.getValue(dimkey.getIndex(info.getDimension().getNumber())).toString();
                String findNum = DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) ? (String)this.relaMembSupplier.access((Object)numbernum) : numbernum;
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)dimension.getNumber(), (String)findNum);
                String simpleName = "";
                Map<String, Map<String, String>> mems = this.result.get(dimension.getNumber());
                if (mems != null && mems.size() > 0) {
                    Map<String, String> membermsg = mems.get(numbernum);
                    simpleName = membermsg == null ? "" : membermsg.get("simplename");
                }
                member = new DimMember(node.getName(), node.getNumber(), simpleName, dimension);
                if (DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber()) && node.getParent() != null) {
                    member.setPar_SonNum(node.getParent_SonNumber());
                }
                members.add(member);
                Cell cur_cell = this.getEffectiveSheet().getCell(row, col);
                if (info.isSeq()) {
                    cur_cell.setUserObject("seqobject", (Object)member);
                } else if (info.isIshide()) {
                    HideLogicImpl.fixHideMember(this.sm, cur_cell, this.basePointInfo, numbernum);
                } else if (cur_cell.isMembUserObjContainMember(members)) {
                    cur_cell.replaceDims2UserObject(members);
                } else {
                    cur_cell.addDims2UserObject(members);
                }
                pattern = this.floatDisplayPattern != null ? this.floatDisplayPattern : this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo);
                ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
                msg = cur_cell.displayDimMsg(ordinal);
                cur_cell.setValue((Object)msg);
                TemplateFloatUtil.setMsgBack2Cell(this.modelId, this.sm, row, col, null, true, false, this.positionInfo, this.basePointInfo);
                continue;
            }
            if (!info.isFloated() && info.getDynaMembScopes().isEmpty()) continue;
            members.clear();
            offset = info.getOffset();
            if (offset == -1) continue;
            if (info.isSeq() || info.isIshide()) {
                offset = 0;
            }
            if (this.basePointInfo.isDirectHoriz()) {
                row = rangeModel.getY_start() + offset;
                col = startIndex;
            } else {
                col = rangeModel.getX_start() + offset;
                row = startIndex;
            }
            Cell currentCell = this.getEffectiveSheet().getCell(row, col);
            member = ((DynaMembScopeInfo)info.getDynaMembScopes().get(0)).getMember();
            String numbernum = member.getNumber();
            String findNum = DimTypesEnum.ENTITY.getNumber().equals(member.getDimension().getNumber()) ? (String)this.relaMembSupplier.access((Object)numbernum) : numbernum;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)member.getDimension().getNumber(), (String)findNum);
            String simpleName = "";
            Map<String, Map<String, String>> mems = this.result.get(member.getDimension().getNumber());
            if (mems != null && mems.size() > 0) {
                Map<String, String> membermsg = mems.get(numbernum);
                if (membermsg == null) continue;
                simpleName = membermsg.get("simplename");
            }
            ((DynaMembScopeInfo)info.getDynaMembScopes().get(0)).getMember().setSimpleName(simpleName);
            member = new DimMember(node.getName(), node.getNumber(), simpleName, member.getDimension());
            if (DimTypesEnum.ENTITY.getNumber().equals(member.getDimension().getNumber()) && node.getParent() != null) {
                member.setPar_SonNum(node.getParent_SonNumber());
            }
            members.add(member);
            if (info.isSeq()) {
                this.getEffectiveSheet().getCell(row, col).setUserObject("seqobject", (Object)member);
            } else if (info.isIshide()) {
                HideLogicImpl.fixHideMember(this.sm, this.getEffectiveSheet().getCell(row, col), this.basePointInfo, numbernum);
            } else {
                this.getEffectiveSheet().getCell(row, col).replaceDims2UserObject(members);
            }
            pattern = this.floatDisplayPattern != null ? this.floatDisplayPattern : this.basePointInfo.getFloatMemDisplayPattern(this.positionInfo);
            ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
            msg = currentCell.displayDimMsg(ordinal);
            currentCell.setValue((Object)msg);
            TemplateFloatUtil.setMsgBack2Cell(this.modelId, this.sm, row, col, null, true, false, this.positionInfo, this.basePointInfo);
        }
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    private Map<MemberGroupKey, List<Row>> toRowMap(List<Row> rows, List<String> dims) {
        if (rows.isEmpty()) {
            return new LinkedHashMap<MemberGroupKey, List<Row>>();
        }
        int[] colIndeies = new int[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            colIndeies[i] = rows.get(0).getColIndex(dims.get(i));
        }
        LinkedHashMap<MemberGroupKey, List<Row>> rowMap = new LinkedHashMap<MemberGroupKey, List<Row>>(16);
        for (Row row : rows) {
            MemberGroupKey key = MemberGroupKey.create((int[])colIndeies, (Row)row);
            List rs = rowMap.computeIfAbsent(key, k -> new ArrayList(10));
            rs.add(row);
        }
        return rowMap;
    }

    public int findStart2insertIndex(String range, boolean isCol) {
        int endInsert;
        String start = range.split(":")[0];
        String end = range.split(":")[1];
        int start2insert = isCol ? ExcelUtils.pos2X((String)start) : ExcelUtils.pos2Y((String)start);
        int n = endInsert = isCol ? ExcelUtils.pos2X((String)end) : ExcelUtils.pos2Y((String)end);
        if (isCol) {
            for (int i = ExcelUtils.pos2X((String)end); i >= ExcelUtils.pos2X((String)start); --i) {
                for (int j = ExcelUtils.pos2Y((String)end); j >= ExcelUtils.pos2Y((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(j, i);
                    if ((cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty()) && cell.isNullValue()) continue;
                    return i + 1;
                }
            }
        } else {
            for (int i = ExcelUtils.pos2Y((String)end); i >= ExcelUtils.pos2Y((String)start); --i) {
                for (int j = ExcelUtils.pos2X((String)end); j >= ExcelUtils.pos2X((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(i, j);
                    if ((cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty()) && cell.isNullValue()) continue;
                    return i + 1;
                }
            }
        }
        return start2insert;
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    public void adjustSheetModelAndJs(AskExcuteInfo excuteinfo) {
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo);
    }

    private void adjustPositonInfo(AskExcuteInfo excuteinfo) {
        boolean deleteOrAdd = excuteinfo.getMethod() == RowColExcuteEnum.DELETECOL || excuteinfo.getMethod() == RowColExcuteEnum.DELETEROW;
        excuteinfo.getOperationdata().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.intValue(), excuteinfo.getOperation(), deleteOrAdd ? -1 : 1);
            adjust.setCheck(excuteinfo.isCheck());
            adjust.setRev(excuteinfo.isRev());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
        excuteinfo.getBatchOperationData().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.getOprtPosition(), excuteinfo.getOperation(), dealdata.getSize() * (deleteOrAdd ? -1 : 1));
            adjust.setCheck(excuteinfo.isCheck());
            adjust.setRev(excuteinfo.isRev());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
        });
    }

    public void insertRank(int start2insert, int num, String range, boolean isCol) {
        this.insertRank(start2insert, num, range, isCol, false);
    }

    public int insertRank(int start2insert, int num, String range, boolean isCol, boolean isrev) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(10);
        boolean ischeck = true;
        if (StringUtils.isNotEmpty((String)range)) {
            int endindex;
            int beginindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
            int n = endindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
            int n2 = endindex < start2insert ? num : (num = num - (endindex - start2insert + (isrev ? 1 : 0)));
            if (start2insert == beginindex || start2insert == endindex) {
                ArrayList<Integer> tem = new ArrayList<Integer>(10);
                tem.add(start2insert);
                if (!isrev && start2insert == beginindex) {
                    ++start2insert;
                }
                AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, tem);
                ThreadCache.put((Object)MATCHBASEINFOWITHROWCOL, this.matchBasePositonWithOperationdata(isCol, excuteinfo));
                ischeck = isrev;
            }
        }
        if (num > 0) {
            int endindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
            int startInsertIndex = endindex < start2insert ? endindex : start2insert;
            for (int i = 0; i < num; ++i) {
                insertdata.add(startInsertIndex);
            }
        } else {
            num = 0;
        }
        AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCheck(ischeck);
        excuteinfo.setCon(true);
        excuteinfo.setRev(isrev);
        if (!isrev && StringUtils.isNotEmpty((String)range)) {
            this.adjustInsertIndex(excuteinfo, range);
        }
        if (excuteinfo.getOperationdata().size() > 1) {
            AskExcuteInfo.BatchOperationList batch = new AskExcuteInfo.BatchOperationList();
            batch.addBatchOperationInfo(excuteinfo.getOperationdata().get(0), excuteinfo.getOperationdata().size());
            excuteinfo.getOperationdata().clear();
            excuteinfo.setBatchOperateData(batch);
        }
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo);
        return num;
    }

    private List<AutoFloatLogicImpl.FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, AskExcuteInfo excuteinfo) {
        List operationdata = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(excuteinfo.getOperationdata()));
        return this.matchBasePositonWithOperationdata(direct, operationdata);
    }

    private List<AutoFloatLogicImpl.FMatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, List<Integer> operationdata) {
        ArrayList<AutoFloatLogicImpl.FMatchBaseInfo> matchbaseinfos = new ArrayList<AutoFloatLogicImpl.FMatchBaseInfo>(10);
        this.sm.getAreaManager().getPostionInfoSet().forEach(position -> position.getBasePoints().forEach(basepoint -> {
            AutoFloatLogicImpl.FMatchBaseInfo matchbaseinfo = new AutoFloatLogicImpl.FMatchBaseInfo((PositionInfo)position, (BasePointInfo)basepoint, (List<Integer>)new ArrayList<Integer>(10));
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)basepoint.getDynaRange());
            Iterator dataiterator = operationdata.iterator();
            while (dataiterator.hasNext()) {
                Integer data = (Integer)dataiterator.next();
                if (direct) {
                    if (data >= rangemodel.getX_start() && data <= rangemodel.getX_end()) {
                        matchbaseinfo.getRowOrcols().add(data);
                        dataiterator.remove();
                    }
                    if (rangemodel.getX_start() != rangemodel.getX_end()) continue;
                    matchbaseinfo.setOnlyOneRowCol(true);
                    continue;
                }
                if (data >= rangemodel.getY_start() && data <= rangemodel.getY_end()) {
                    matchbaseinfo.getRowOrcols().add(data);
                    dataiterator.remove();
                }
                if (rangemodel.getY_start() != rangemodel.getY_end()) continue;
                matchbaseinfo.setOnlyOneRowCol(true);
            }
            if (!matchbaseinfo.getRowOrcols().isEmpty()) {
                matchbaseinfos.add(matchbaseinfo);
            }
        }));
        matchbaseinfos.add(new AutoFloatLogicImpl.FMatchBaseInfo(null, null, operationdata));
        ThreadCache.put((Object)MATCHBASEINFOWITHROWCOL, matchbaseinfos);
        return matchbaseinfos;
    }

    private void adjustInsertIndex(AskExcuteInfo excuteinfo, String range) {
        int start;
        if (excuteinfo.isRev()) {
            return;
        }
        if (RowColExcuteEnum.DELETECOL == excuteinfo.getMethod() || RowColExcuteEnum.DELETEROW == excuteinfo.getMethod()) {
            return;
        }
        String startPoint = range.split(":")[0];
        int n = start = RowColExcuteEnum.INSERTCOL == excuteinfo.getMethod() ? ExcelUtils.pos2X((String)startPoint) : ExcelUtils.pos2Y((String)startPoint);
        if (excuteinfo.getOperationdata().size() == 1 && excuteinfo.getOperationdata().get(0) == start) {
            excuteinfo.getOperationdata().clear();
            excuteinfo.getOperationdata().add(start + 1);
        }
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getDataTypeThreadCache(long modelId) {
        HashMap cachemap = CellDataTypeUtil.getDataTypeThreadCache();
        List<String> dims = AutoFloatWithoutViewHandle.getDataTypeDimNums(modelId);
        dims.removeAll(cachemap.keySet());
        dims.forEach(dim -> {
            if (!cachemap.containsKey(dim)) {
                DataTypeAcctCacheInfo acctCacheInfo = new DataTypeAcctCacheInfo((Object)modelId, DimEntityNumEnum.getEntieyNumByNumber((String)dim), dim);
                cachemap.put(dim, acctCacheInfo);
            }
        });
        if (!dims.isEmpty()) {
            CellDataTypeUtil.cacheDataTypeInfo2Thread((HashMap)cachemap);
        }
        return cachemap;
    }

    public static List<String> getDataTypeDimNums(Object modelId) {
        return (List)ThreadCache.get((Object)"dataTypeDimNums", () -> {
            List dims = DataTypeEnum.getDataTypePerSetDims((Object)modelId);
            Collection coll = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("model.id", "=", modelId), new QFilter("issysdimension", "=", (Object)"0")}, null).values();
            coll.forEach(dy -> dims.add(dy.getString("number")));
            return dims;
        });
    }

    public static boolean isDirectHoriz() {
        String type = (String)ThreadCache.get((Object)FLOATTYPE);
        return "col".equals(type);
    }

    public static void cacheFloatType(boolean isH) {
        if (isH) {
            ThreadCache.put((Object)FLOATTYPE, (Object)"col");
        } else {
            ThreadCache.put((Object)FLOATTYPE, (Object)"row");
        }
    }

    public long getOrgSchemeId() {
        return this.orgSchemeId;
    }

    public void setOrgSchemeId(long orgSchemeId) {
        this.orgSchemeId = orgSchemeId;
    }

    public ExtReportModelHandle getExtModelHandle() {
        return this.extModelHandle;
    }

    public void setExtModelHandle(ExtReportModelHandle extModelHandle) {
        this.extModelHandle = extModelHandle;
    }

    private static /* synthetic */ void lambda$clearUnExitMember$4(Multimap map, IDimension d) {
        d.getMembers().removeIf(next -> !map.get((Object)d.getNumber()).contains(next.getNumber()));
    }

    private static /* synthetic */ void lambda$clearUnExitMember$2(Multimap map, IDimension d) {
        d.getMembers().removeIf(next -> !map.get((Object)d.getNumber()).contains(next.getNumber()));
    }

    private static /* synthetic */ void lambda$clearUnExitMember$0(Multimap map, IDimMember m) {
        map.put((Object)m.getDimension().getNumber(), (Object)m.getNumber());
    }

    public static class FloatArea
    implements Serializable {
        private boolean isHasFloat = false;
        private String dynaRange;
        private String originalDynaRange;
        private int originalStartIndex = 0;
        private int originalendIndex = 0;
        private int dynaStartindex = 0;
        private int dynaEndindex = 0;
        private int floatSize = 0;
        private int rowMapSize = 0;
        private int needBlankFloat = 0;
        private boolean isCol = false;
        private List<Integer> deledata = new ArrayList<Integer>();

        public FloatArea(int originalStartIndex, int originalendIndex, int rowMapSize, boolean isCol, String originalDynaRange, String dynaRange, List<Integer> deledata) {
            this.originalDynaRange = originalDynaRange;
            this.dynaRange = dynaRange;
            this.originalStartIndex = originalStartIndex;
            this.originalendIndex = originalendIndex;
            this.rowMapSize = rowMapSize;
            int tempfloatsize = originalendIndex - originalStartIndex + 1;
            this.dynaStartindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[0]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[0]);
            this.dynaEndindex = isCol ? ExcelUtils.pos2X((String)dynaRange.split(":")[1]) : ExcelUtils.pos2Y((String)dynaRange.split(":")[1]);
            this.floatSize = this.dynaEndindex - this.dynaStartindex + 1;
            this.needBlankFloat = tempfloatsize - rowMapSize >= 2 ? 0 : (tempfloatsize == rowMapSize ? 2 : (tempfloatsize - rowMapSize == 1 ? 1 : 2));
            this.isCol = isCol;
            this.deledata.addAll(deledata);
        }

        public FloatArea(List<Integer> deledata, boolean isHasFloat) {
            this.deledata = deledata;
            this.isHasFloat = isHasFloat;
        }

        public boolean isHasFloat() {
            return this.isHasFloat;
        }

        public String getDynaRange() {
            return this.dynaRange;
        }

        public String getOriginalDynaRange() {
            return this.originalDynaRange;
        }

        public int getOriginalStartIndex() {
            return this.originalStartIndex;
        }

        public int getOriginalendIndex() {
            return this.originalendIndex;
        }

        public int getDynaStartindex() {
            return this.dynaStartindex;
        }

        public int getDynaEndindex() {
            return this.dynaEndindex;
        }

        public int getFloatSize() {
            return this.floatSize;
        }

        public int getRowMapSize() {
            return this.rowMapSize;
        }

        public int getNeedBlankFloat() {
            return this.needBlankFloat;
        }

        public boolean isCol() {
            return this.isCol;
        }

        public List<Integer> getDeledata() {
            return this.deledata;
        }
    }
}

