/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MembAddPositionEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.floatreport.FloatSilentMemImpl;
import kd.fi.bcm.formplugin.report.formula.ReportFormulaUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.EnumStyleCellUtils;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.DynamicUtils;

public class FloatLogicImpl {
    public static final String DIMENDIONNUMBER = "dinemsionumber";
    public static final String DIMENDIONAME = "dinemsioname";
    public static final String DIMENDIONENTITY = "dinemsionrntity";
    public static final String CLEARDATA = "cleardata";
    public static final String CLEARCELL = "clearcell";
    public static final String FLOATTYPE = "floattype";
    public static final String UPADTEEVT = "updateevt";
    public static final String PROCESSING = "processing";
    public static final String PASTEINDEX = "pasteindex";
    protected static final String SPREAD_KEY = "report";

    public static void pasteFloat(AbstractBaseFormPlugin plugin, String selectArea, SpreadManager spread, NotifyEvent mulevt, IPageCache cache, Map<String, Map<String, Map<String, String>>> result, Map<String, Set<String>> inScopeMember) {
        SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
        List dataValues = data.getValues();
        FloatLogicImpl.pasteFloat(plugin, selectArea, spread, dataValues, cache, result, inScopeMember);
    }

    public static void pasteFloat(AbstractBaseFormPlugin plugin, String selectArea, SpreadManager spread, List<LinkedHashMap<String, Object>> dataValues, IPageCache cache, Map<String, Map<String, Map<String, String>>> result, Map<String, Set<String>> inScopeMember) {
        LinkedHashMap<String, Object> first = dataValues.get(0);
        String pasterowindex = FloatLogicImpl.isDirectHoriz(cache) ? first.get("r").toString() : null;
        String pastecolindex = FloatLogicImpl.isDirectHoriz(cache) ? null : first.get("c").toString();
        boolean hasvalue = false;
        for (LinkedHashMap<String, Object> map : dataValues) {
            if (map.get("v") == null) continue;
            hasvalue = true;
            break;
        }
        if (!hasvalue) {
            return;
        }
        BasePointInnerLineInfo[] innerInfo = TemplateFloatUtil.findInnerInfoFromFolatSetting(spread, Integer.parseInt(dataValues.get(0).get("r").toString()), Integer.parseInt(dataValues.get(0).get("c").toString()));
        if (innerInfo.length == 1 && innerInfo[0].getMemberAddOf() != null) {
            String string;
            ArrayList<LinkedHashMap<String, Object>> values = new ArrayList<LinkedHashMap<String, Object>>();
            for (LinkedHashMap<String, Object> map : dataValues) {
                Object value;
                if ((pasterowindex == null || !pasterowindex.equals(map.get("r").toString())) && (pastecolindex == null || !pastecolindex.equals(map.get("c").toString())) || map.get("v") == null || !StringUtils.isNotEmpty((String)(value = map.get("v").toString())) || FloatLogicImpl.isBlank((String)value)) continue;
                values.add(map);
            }
            if (values.isEmpty()) {
                return;
            }
            boolean hasnotexistmem = false;
            ArrayList<String> va = new ArrayList<String>();
            for (LinkedHashMap linkedHashMap : values) {
                String value = linkedHashMap.get("v") == null ? "" : linkedHashMap.get("v").toString();
                va.add(value.indexOf("|") != -1 ? value.substring(0, value.indexOf("|")) : value);
            }
            String entity = innerInfo[0].getDimension().getUqCode();
            List<String> newva = FloatLogicImpl.getExistMems(entity, string = innerInfo[0].getDimension().getNumber(), result, va.toArray(new String[0]));
            if (!newva.containsAll(va)) {
                hasnotexistmem = true;
            } else if (entity.equalsIgnoreCase("bcm_userdefinedmembertree")) {
                boolean bl = hasnotexistmem = !FloatLogicImpl.checkNum(plugin.getModelId(), newva, inScopeMember, result, innerInfo[0]).isEmpty();
            }
            if (hasnotexistmem) {
                String valuesSerial = ObjectSerialUtil.toByteSerialized(values);
                for (LinkedHashMap<String, Object> map : dataValues) {
                    if ((pasterowindex == null || !pasterowindex.equals(map.get("r").toString())) && (pastecolindex == null || !pastecolindex.equals(map.get("c").toString())) || map.get("v") == null) continue;
                    map.put("v", null);
                    spread.getBook().getSheet(0).getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue()).setChangeVal(true);
                }
                if (plugin.getPageCache().get(PROCESSING) == null) {
                    plugin.getPageCache().put(PROCESSING, "true");
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setCustomParam("KEY_SPREAD_MODEL", (Object)ObjectSerialUtil.toByteSerialized((Object)spread));
                    showParameter.setCustomParam("value", (Object)valuesSerial);
                    showParameter.setCustomParam("isDirectHoriz", (Object)FloatLogicImpl.isDirectHoriz(cache));
                    showParameter.setCustomParam("KEY_MODEL_ID", (Object)plugin.getModelId());
                    showParameter.setCustomParam("selectarea", (Object)selectArea);
                    showParameter.setCustomParam(DIMENDIONNUMBER, (Object)innerInfo[0].getDimension().getNumber());
                    DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)plugin.getModelId()), new QFilter("number", "=", (Object)innerInfo[0].getDimension().getNumber())});
                    showParameter.setCustomParam(DIMENDIONAME, (Object)obj.getString("name"));
                    showParameter.setCustomParam(DIMENDIONENTITY, (Object)innerInfo[0].getDimension().getUqCode());
                    showParameter.setCustomParam("result", (Object)SerializationUtils.toJsonString(result));
                    showParameter.setCustomParam("scope", (Object)ObjectSerialUtil.toByteSerialized(inScopeMember));
                    showParameter.setCustomParam("innerinfo", (Object)ObjectSerialUtil.toByteSerialized((Object)innerInfo[0]));
                    showParameter.setFormId("bcm_floatmem_paste");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "pasteFloat");
                    showParameter.setCloseCallBack(closeCallBack);
                    if (pastecolindex != null) {
                        cache.put(PASTEINDEX, pastecolindex);
                    } else {
                        cache.put(PASTEINDEX, pasterowindex);
                    }
                    plugin.getView().showForm(showParameter);
                }
            }
        }
    }

    public static void checkAndsaveMember(AbstractBaseFormPlugin plugin, String selectArea, SpreadManager spread, NotifyEvent mulevt, IPageCache cache, Map<String, Map<String, Map<String, String>>> result, Map<String, Set<String>> inScopeMember) {
        SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
        List dataValues = data.getValues();
        FloatLogicImpl.checkAndsaveMember(plugin, selectArea, spread, dataValues, cache, result, inScopeMember);
    }

    public static void checkAndsaveMember(AbstractBaseFormPlugin plugin, String selectArea, SpreadManager spread, List<LinkedHashMap<String, Object>> dataValues, IPageCache cache, Map<String, Map<String, Map<String, String>>> result, Map<String, Set<String>> inScopeMember) {
        String pastecolindex;
        LinkedHashMap<String, Object> first = dataValues.get(0);
        String pasterowindex = FloatLogicImpl.isDirectHoriz(cache) ? first.get("r").toString() : null;
        String string = pastecolindex = FloatLogicImpl.isDirectHoriz(cache) ? null : first.get("c").toString();
        if (pasterowindex != null && pasterowindex.equals(first.get("r").toString()) || pastecolindex != null && pastecolindex.equals(first.get("c").toString())) {
            boolean hasvalue = false;
            ArrayList<LinkedHashMap<String, Object>> values = new ArrayList<LinkedHashMap<String, Object>>(dataValues.size());
            List<Object> newNames = new ArrayList<String>(dataValues.size());
            for (LinkedHashMap<String, Object> map : dataValues) {
                Object v;
                if ((pasterowindex == null || !pasterowindex.equals(map.get("r").toString())) && (pastecolindex == null || !pastecolindex.equals(map.get("c").toString())) || (v = map.get("v")) == null) continue;
                String newName = v.toString();
                if (!StringUtils.isNotEmpty((String)(newName = newName.trim())) || FloatLogicImpl.isBlank(newName)) continue;
                if (!newNames.contains(newName)) {
                    newNames.add(newName);
                }
                values.add(map);
                hasvalue = true;
            }
            if (!hasvalue || values.isEmpty()) {
                return;
            }
            BasePointInnerLineInfo[] innerInfo = TemplateFloatUtil.findInnerInfoFromFolatSetting(spread, Integer.parseInt(dataValues.get(0).get("r").toString()), Integer.parseInt(dataValues.get(0).get("c").toString()));
            if (innerInfo.length == 1 && innerInfo[0].getMemberAddOf() != null) {
                String entity = innerInfo[0].getDimension().getUqCode();
                String dimNumber = innerInfo[0].getDimension().getNumber();
                List<String> newva = FloatLogicImpl.getExistMems(entity, dimNumber, result, newNames.toArray(new String[0]));
                if (entity.equalsIgnoreCase("bcm_icmembertree")) {
                    for (String s : newva) {
                        newNames.remove(s);
                    }
                    if (newNames.isEmpty()) {
                        return;
                    }
                }
                if (entity.equalsIgnoreCase("bcm_userdefinedmembertree")) {
                    Set<String> dimsc = inScopeMember.get(dimNumber);
                    final Map nameToNumber = (Map)ThreadCache.get((Object)("nameToNumber" + dimNumber), () -> {
                        HashMap<String, String> maps = new HashMap<String, String>(10);
                        String modelNum = MemberReader.findModelNumberById((Object)plugin.getModelId());
                        for (IDNumberTreeNode m : MemberReader.getAllNodeFromCache((String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNumber), (String)modelNum).values()) {
                            if (!dimsc.contains(m.getNumber()) || !m.getDimNumber().equals(dimNumber)) continue;
                            maps.put(m.getName(), m.getNumber());
                        }
                        return maps;
                    });
                    List checkNum = newNames.stream().filter(new Predicate<String>(){

                        @Override
                        public boolean test(String s) {
                            return !nameToNumber.containsKey(s);
                        }
                    }).collect(Collectors.toList());
                    if (checkNum.isEmpty()) {
                        return;
                    }
                    newNames = checkNum;
                }
                if (!newNames.isEmpty()) {
                    IDimMember memberAddOf = innerInfo[0].getMemberAddOf();
                    newNames.remove(memberAddOf.getName());
                    if (newNames.isEmpty()) {
                        return;
                    }
                    DynamicObject memberDyo = BusinessDataServiceHelper.loadSingle((Object)memberAddOf.getId(), (String)entity);
                    String[] numbers = CodeRuleUtil.getDimensionNumber(entity, memberDyo, newNames.size());
                    if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numbers)})) {
                        numbers = CodeRuleUtil.getDimensionNumber(entity, memberDyo, newNames.size());
                    }
                    LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>(numbers.length);
                    for (int i = 0; i < newNames.size(); ++i) {
                        tempMap.put(numbers[i], (String)newNames.get(i));
                    }
                    Long parent = memberAddOf.getId();
                    if (entity.equalsIgnoreCase("bcm_userdefinedmembertree")) {
                        parent = FloatLogicImpl.getRealParent(plugin.getModelId(), entity, dimNumber, memberAddOf.getNumber(), innerInfo[0].getAddPositionEnum());
                    }
                    String s = MemberReader.findMemberById((long)plugin.getModelId(), (String)entity, (Long)parent).getNumber();
                    List<DynamicObject> dynamicObjects = FloatLogicImpl.saveMember(plugin.getModelId(), innerInfo[0].getDimension().getNumber(), tempMap, parent, innerInfo[0].getAddPositionEnum().getVal());
                    if (!dynamicObjects.isEmpty()) {
                        for (DynamicObject object : dynamicObjects) {
                            String number = object.getString("number");
                            HashMap<String, String> e = new HashMap<String, String>(10);
                            inScopeMember.get(dimNumber).add(number);
                            e.put("number", number);
                            e.put("parent", s);
                            e.put("name", object.getString("name"));
                            e.put("isleaf", "true");
                            result.get(dimNumber).put(object.getString("name"), e);
                            result.get(dimNumber).put(number, e);
                        }
                    }
                }
            }
        }
    }

    public static boolean isBlank(String str) {
        boolean isBlank = false;
        if (str != null) {
            isBlank = true;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == ' ' || str.charAt(i) == '\u3000') continue;
                isBlank = false;
                break;
            }
        }
        return isBlank;
    }

    public static List<DynamicObject> saveMember(Long modelId, String dimNum, Map<String, String> member, Long parentid, Integer position) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        String cs1 = "icmembertree";
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        String membertable = entity.contains(cs1) ? "bcm_intercompanymember" : entity.substring(0, entity.length() - 4);
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)entity);
        if (parent.getBoolean("isleaf")) {
            parent.set("isleaf", (Object)0);
            parent.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
        }
        int seq = QueryDimensionServiceHelper.getMaxDSeq((long)parentid, (String)entity);
        Object[] nones = new DynamicObject[member.size()];
        Object[] noneTrees = new DynamicObject[member.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : member.entrySet()) {
            String number = entry.getKey();
            String name = entry.getValue();
            DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)none);
            none.set("number", (Object)number);
            none.set("name", (Object)name);
            none.set("model", parent.get("model"));
            none.set("dimension", parent.get("dimension"));
            nones[i] = none;
            DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)entity);
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)noneTree);
            noneTree.set("model", parent.get("model"));
            noneTree.set("dimension", parent.get("dimension"));
            noneTree.set("level", (Object)String.valueOf((Integer)parent.get("level") + 1));
            noneTree.set("member", (Object)none);
            noneTree.set("parent", (Object)parentid);
            noneTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
            if ("bcm_userdefinedmembertree".equals(entity)) {
                noneTree.set("datatype", (Object)"0");
            }
            noneTree.set("aggoprt", (Object)"1");
            noneTree.set("isleaf", (Object)true);
            noneTree.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
            noneTree.set("number", (Object)number);
            noneTree.set("name", (Object)name);
            noneTree.set("issysmember", (Object)5);
            noneTree.set("dseq", (Object)(++seq));
            if (position != null && 1 == position) {
                noneTree.set("addtext", (Object)"baritemaddsub");
            } else {
                noneTree.set("addtext", (Object)"");
            }
            noneTrees[i] = noneTree;
            ++i;
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                QFilter[] qFilters2;
                int size = ((HashMap)member).size();
                ArrayList<String> numbers = new ArrayList<String>(size);
                ArrayList<String> names = new ArrayList<String>(size);
                for (Map.Entry<String, String> entry : member.entrySet()) {
                    numbers.add(entry.getKey());
                    names.add(entry.getValue());
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension.number", "=", (Object)dimNum), new QFilter("number", "in", numbers)};
                if (QueryServiceHelper.exists((String)entity, (QFilter[])qFilters)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"FloatLogicImpl_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                QFilter nameQf = new QFilter("name", "in", names);
                if ("bcm_userdefinedmembertree".equals(entity)) {
                    nameQf = nameQf.and("parent", "=", (Object)parentid);
                }
                if (QueryServiceHelper.exists((String)entity, (QFilter[])(qFilters2 = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension.number", "=", (Object)dimNum), nameQf}))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u540d\u79f0\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"FloatLogicImpl_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)membertable).getDynamicObjectType(), (Object[])nones);
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entity).getDynamicObjectType(), (Object[])noneTrees);
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])new DynamicObject[]{parent});
                ArrayList<Tuple> list = new ArrayList<Tuple>(noneTrees.length);
                for (Object treeMember : noneTrees) {
                    list.add(Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Object)treeMember.get("parent"))));
                }
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)dimNum, list);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        SaveDimMemberHelper.saveLog(Arrays.asList(noneTrees), (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.NEW);
        return Arrays.asList(noneTrees);
    }

    private static List<String> checkNum(long modelId, List<String> existmember, Map<String, Set<String>> scope, Map<String, Map<String, Map<String, String>>> result, BasePointInnerLineInfo inner) {
        ArrayList<String> nonmember = new ArrayList<String>();
        if (inner == null) {
            return nonmember;
        }
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)inner.getDimension().getNumber())});
        IDimension dimension = ObjectConvertUtils.toIDimension(dimObj);
        for (int i = 0; i < existmember.size(); ++i) {
            String number = existmember.get(i);
            boolean isValidate = FloatLogicImpl.buildDimMemberGroupByMap(result, scope, dimension.getNumber(), number, null, modelId, inner, nonmember);
            if (isValidate) continue;
            existmember.set(i, null);
        }
        return nonmember;
    }

    public static Long getRealParent(Object modelId, String entity, String dimNumber, String memberAddOf, MembAddPositionEnum mae) {
        boolean isUserDefine = "bcm_userdefinedmembertree".equalsIgnoreCase(entity);
        if (!isUserDefine) {
            return null;
        }
        QFBuilder qfBuilder = new QFBuilder("dimension.number", "=", (Object)dimNumber);
        qfBuilder.add("number", "=", (Object)memberAddOf);
        qfBuilder.add("model", "=", modelId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])qfBuilder.toArray());
        if (MembAddPositionEnum.Brother == mae) {
            return dy.getLong("parent.id");
        }
        return dy.getLong("id");
    }

    public static List<String> getExistMems(String entity, String dimnumber, Map<String, Map<String, Map<String, String>>> result, String ... values) {
        ArrayList<String> value = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            value.add(values[i].indexOf(124) != -1 ? values[i].substring(0, values[i].indexOf(124)) : values[i]);
        }
        Map<String, Map<String, String>> exitmem = result.get(dimnumber);
        ArrayList<String> exitvalue = new ArrayList<String>();
        exitmem.keySet().stream().filter(e -> value.contains(e)).forEach(e -> exitvalue.add((String)e));
        return exitvalue;
    }

    public static List<PositionInfo> sortPositionInfo(Set<PositionInfo> positionInfoSet, final boolean isDirectHoriz) {
        ArrayList<PositionInfo> result = new ArrayList<PositionInfo>(positionInfoSet);
        if (positionInfoSet.size() <= 1) {
            return result;
        }
        result.sort(new Comparator<PositionInfo>(){

            @Override
            public int compare(PositionInfo o1, PositionInfo o2) {
                int i = 0;
                int j = 0;
                if (isDirectHoriz) {
                    i = ExcelUtils.pos2X((String)o1.getStartPosition());
                    j = ExcelUtils.pos2X((String)o2.getStartPosition());
                } else {
                    i = ExcelUtils.pos2Y((String)o1.getStartPosition());
                    j = ExcelUtils.pos2Y((String)o2.getStartPosition());
                }
                return i - j;
            }
        });
        return result;
    }

    public static List<BasePointInfo> sortBasePoint(List<BasePointInfo> basePointInfoList) {
        ArrayList<BasePointInfo> result = new ArrayList<BasePointInfo>(basePointInfoList);
        if (result.size() <= 1) {
            return result;
        }
        final boolean isDirectHoriz = ((BasePointInfo)result.get(0)).isDirectHoriz();
        result.sort(new Comparator<BasePointInfo>(){

            @Override
            public int compare(BasePointInfo o1, BasePointInfo o2) {
                int i = 0;
                int j = 0;
                String o1Position = o1.getDynaRange().substring(0, o1.getDynaRange().indexOf(58));
                String o2Position = o2.getDynaRange().substring(0, o2.getDynaRange().indexOf(58));
                if (isDirectHoriz) {
                    i = ExcelUtils.pos2X((String)o1Position);
                    j = ExcelUtils.pos2X((String)o2Position);
                } else {
                    i = ExcelUtils.pos2Y((String)o1Position);
                    j = ExcelUtils.pos2Y((String)o2Position);
                }
                return i - j;
            }
        });
        return result;
    }

    public static void showTip(AbstractBaseFormPlugin plugin, SpreadManager spread, Cell cell, List<Object> isShowTip) {
        List excelNotSupportFormulas = FormulaRegister.getExcelNotSupportFormulas();
        int r = cell.getRow();
        int c = cell.getCol();
        Object v = cell.getValue();
        BasePointInfo base = null;
        String startpoint = "";
        String position = ExcelUtils.xy2Pos((int)c, (int)r);
        block2: for (PositionInfo positionInfo : spread.getAreaManager().getPostionInfoSet()) {
            Cell cell1;
            int i;
            int endindex;
            int stindex;
            String[] area;
            BasePointInfo basePointInfo2;
            String spreadArea = positionInfo.getAreaRange();
            if (SpreadAreaUtil.isInArea((String)(position + ":" + position), (String)spreadArea)) {
                for (BasePointInfo basePointInfo2 : positionInfo.getBasePoints()) {
                    int compareindex;
                    spreadArea = basePointInfo2.getDynaRange();
                    area = spreadArea.split(":");
                    stindex = basePointInfo2.isDirectHoriz() ? ExcelUtils.pos2X((String)area[0]) : ExcelUtils.pos2Y((String)area[0]);
                    endindex = basePointInfo2.isDirectHoriz() ? ExcelUtils.pos2X((String)area[1]) : ExcelUtils.pos2Y((String)area[1]);
                    int n = compareindex = basePointInfo2.isDirectHoriz() ? c : r;
                    if (!SpreadAreaUtil.isInArea((String)(position + ":" + position), (String)positionInfo.getAreaRange()) || stindex > compareindex || endindex < compareindex) continue;
                    base = basePointInfo2;
                    startpoint = positionInfo.getStartPosition();
                    break block2;
                }
                continue;
            }
            PositionInfo positionInfo1 = TemplateFloatUtil.getPositionInfoByRowAndCol(spread, r, c);
            basePointInfo2 = TemplateFloatUtil.getBasePointInfoByRowAndCol(spread, r, c);
            if (positionInfo1 == null || !positionInfo1.isFloatPosition() || !ObjectUtils.isEmpty((Object)v) || basePointInfo2 == null) continue;
            spreadArea = positionInfo1.getAreaRange();
            area = spreadArea.split(":");
            stindex = basePointInfo2.isDirectHoriz() ? ExcelUtils.pos2Y((String)area[0]) : ExcelUtils.pos2X((String)area[0]);
            int n = endindex = basePointInfo2.isDirectHoriz() ? ExcelUtils.pos2Y((String)area[1]) : ExcelUtils.pos2X((String)area[1]);
            if (!basePointInfo2.isDirectHoriz()) {
                for (i = stindex; i <= endindex; ++i) {
                    cell1 = spread.getBook().getSheet(0).getCell(r, i);
                    if (ObjectUtils.isEmpty((Object)cell1.getValue())) continue;
                    isShowTip.add(true);
                    return;
                }
                continue;
            }
            for (i = stindex; i <= endindex; ++i) {
                cell1 = spread.getBook().getSheet(0).getCell(i, c);
                if (ObjectUtils.isEmpty((Object)cell1.getValue())) continue;
                isShowTip.add(true);
                return;
            }
        }
        if (base != null) {
            int local;
            int st = base.isDirectHoriz() ? ExcelUtils.pos2Y((String)startpoint) : ExcelUtils.pos2X((String)startpoint);
            int n = local = base.isDirectHoriz() ? r : c;
            if (base.getFixMemberPosition().get(local - st) != null && !cell.isMdDataDomain() && cell.getValue() != null) {
                AtomicBoolean onlyExcel = new AtomicBoolean(true);
                if (cell.hasFormula()) {
                    Expression ex = null;
                    try {
                        ex = ExcelFormulaPaserHelper.parse((String)cell.getFormula());
                        ReportFormulaUtil.isOnlyExcel(excelNotSupportFormulas, onlyExcel, ex);
                    }
                    catch (Exception exception) {
                        throw new KDBizException("formula parse error: " + exception);
                    }
                }
                if (!onlyExcel.get()) {
                    spread.getBook().getSheet(0).getCell(cell.getRow(), cell.getCol()).setValue(null);
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", cell.getRow());
                    e.put("c", cell.getCol());
                    e.put("v", null);
                    SpreadClientInvoker.invokeUpdataValueMethod(plugin.getClientViewProxy(), SPREAD_KEY, Lists.newArrayList((Object[])new Map[]{e}));
                }
                if (cell.hasFormula() && !cell.getFormula().contains("@") && !onlyExcel.get()) {
                    HashMap<String, Integer> formulapa = new HashMap<String, Integer>(16);
                    formulapa.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                    formulapa.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                    formulapa.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                    spread.getBook().getSheet(0).getCell(cell.getRow(), cell.getCol()).setFormula(null);
                    SpreadClientInvoker.invokeSetFormulaMethod(plugin.getClientViewProxy(), SPREAD_KEY, Lists.newArrayList((Object[])new Map[]{formulapa}));
                    isShowTip.add(true);
                }
                return;
            }
        }
    }

    public static void cacheClearDatas(IPageCache pageCache, List<Cell> cells) {
        String sc = pageCache.get(CLEARDATA);
        String sccell = pageCache.get(CLEARCELL);
        List<Integer> list = new ArrayList();
        List<Cell> celllist = new ArrayList(10);
        if (StringUtils.isNotEmpty((String)sc)) {
            list = (List)SerializationUtils.fromJsonString((String)sc, List.class);
        }
        if (StringUtils.isNotEmpty((String)sccell)) {
            celllist = (List)ObjectSerialUtil.deSerializedBytes((String)sccell);
        }
        for (Cell cell : cells) {
            if (FloatLogicImpl.isDirectHoriz(pageCache)) {
                list.add(cell.getCol());
            } else {
                list.add(cell.getRow());
            }
            cell.setUserObject("delrow", (Object)cell.getRow());
            cell.setUserObject("delcol", (Object)cell.getCol());
            celllist.add(cell);
        }
        pageCache.put(CLEARDATA, SerializationUtils.toJsonString(list));
        pageCache.put(CLEARCELL, ObjectSerialUtil.toByteSerialized(celllist));
        for (Cell cell : cells) {
            cell.removeUserObject("delrow");
            cell.removeUserObject("delcol");
        }
    }

    public static void cacheFloatType(IPageCache pageCache, boolean isH) {
        if (isH) {
            pageCache.put(FLOATTYPE, "col");
        } else {
            pageCache.put(FLOATTYPE, "row");
        }
    }

    public static boolean isDirectHoriz(IPageCache pageCache) {
        String type = pageCache.get(FLOATTYPE);
        return "col".equals(type);
    }

    public static List<String> sortMemByDim(SpreadManager sp, Map<String, String> map, PositionInfo ps) {
        ArrayList rowColDims = new ArrayList(sp.getAreaManager().getRowDimDoman(ps).getDimensions());
        rowColDims.addAll(sp.getAreaManager().getColDimDomain(ps).getDimensions());
        ArrayList<String> newMems = new ArrayList<String>(map.size());
        Boolean isAddedYearDim = Boolean.FALSE;
        for (IDimension dim : rowColDims) {
            newMems.add(map.get(dim.getNumber()));
            if (!DimEntityNumEnum.YEAR.getNumber().equalsIgnoreCase(dim.getNumber())) continue;
            isAddedYearDim = Boolean.TRUE;
        }
        String year = map.get(DimEntityNumEnum.YEAR.getNumber());
        if (newMems.size() != map.size() && !isAddedYearDim.booleanValue() && StringUtils.isNotEmpty((String)year)) {
            newMems.add(year);
        }
        return newMems;
    }

    public static Map<Long, DynamicObject> getDyObjMapByid(ListSelectedRowCollection coll, String dimnum, SpreadManager sm, long modelId) {
        ArrayList ids = new ArrayList();
        coll.forEach(e -> ids.add((Long)e.getPrimaryKeyValue()));
        if (DimTypesEnum.ENTITY.getNumber().equals(dimnum)) {
            boolean isAnalyOrgNames;
            boolean isOrgInPV = sm.getFilter().isInCommonFilter(DimTypesEnum.ENTITY.getNumber());
            boolean isSceneInPV = sm.getFilter().isInCommonFilter(DimTypesEnum.SCENARIO.getNumber());
            boolean isYearInPV = sm.getFilter().isInCommonFilter(DimTypesEnum.YEAR.getNumber());
            boolean isPeriodInPV = sm.getFilter().isInCommonFilter(DimTypesEnum.PERIOD.getNumber());
            boolean bl = isAnalyOrgNames = !isOrgInPV && isSceneInPV && isYearInPV && isPeriodInPV;
            if (isAnalyOrgNames) {
                String sceneNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.SCENARIO.getNumber());
                String yearNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.YEAR.getNumber());
                String periodNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.PERIOD.getNumber());
                long sceneId = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)sceneNum).getId();
                long periodId = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)periodNum).getId();
                FilterOrgStructParam param = new FilterOrgStructParam(modelId, sceneId, yearNum, periodId);
                return EntityVersioningUtil.getEffectiveOrgNameByPY((List)Lists.newArrayList((Object[])new FilterOrgStructParam[]{param}), ids);
            }
        }
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection dynaObjs = QueryServiceHelper.query((String)DimensionUtil.getDimMembEntityNumByDimNum(dimnum), (String)"id,name,number,simplename,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        dynaObjs.forEach(e -> result.put(e.getLong("id"), (DynamicObject)e));
        return result;
    }

    public static Map<String, Map<String, Map<String, String>>> getMemObjMapByCells(HashMultimap<String, String> values, TemplateModel model) {
        return FloatLogicImpl.getMemObjMapByCells(values, model, false);
    }

    public static Map<String, Map<String, Map<String, String>>> getMemObjMapByCells(HashMultimap<String, String> values, TemplateModel model, boolean needId) {
        LinkedHashMap dimMap;
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>();
        if (model.getAreaRangeEntries() == null || model.getAreaRangeEntries().isEmpty()) {
            return result;
        }
        String cacheKey = FloatLogicImpl.class.getName() + ".getMemObjMapByCells." + model.getId();
        if (ThreadCache.exists((Object)cacheKey)) {
            dimMap = (LinkedHashMap)ThreadCache.get((Object)cacheKey);
        } else {
            dimMap = new LinkedHashMap();
            for (int i = 0; i < model.getAreaRangeEntries().size(); ++i) {
                if (((AreaRangeEntry)model.getAreaRangeEntries().get(i)).getRowDimEntries().isEmpty() && ((AreaRangeEntry)model.getAreaRangeEntries().get(i)).getColDimEntries().isEmpty()) continue;
                ((AreaRangeEntry)model.getAreaRangeEntries().get(i)).getColDimEntries().forEach(e -> {
                    String dimNumber = e.getDimension().getNumber();
                    dimMap.put(dimNumber, BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,membertable,membermodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber), new QFilter("model", "=", (Object)model.getModelId())}));
                });
                ((AreaRangeEntry)model.getAreaRangeEntries().get(i)).getRowDimEntries().forEach(e -> {
                    String dimNumber = e.getDimension().getNumber();
                    dimMap.put(dimNumber, BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,membertable,membermodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber), new QFilter("model", "=", (Object)model.getModelId())}));
                });
                ThreadCache.put((Object)cacheKey, dimMap);
                break;
            }
        }
        for (Map.Entry<String, Collection<String>> entry : values.asMap().entrySet()) {
            DynamicObject dim = (DynamicObject)dimMap.get(entry.getKey());
            Map<Object, DynamicObject> members = FloatLogicImpl.queryMembers(dim, "name", entry);
            members.putAll(FloatLogicImpl.queryMembers(dim, "number", entry));
            Collection<DynamicObject> coll = members.values();
            String dimNumber = entry.getKey();
            result.computeIfAbsent(dimNumber, k -> new HashMap()).put(dimNumber, MapInitHelper.ofMap((Object)"number", (Object)dimNumber, (Object)"name", (Object)dim.getString("name"), (Object)"isleaf", (Object)"0"));
            for (DynamicObject m : coll) {
                String membNum = m.getString("number");
                String membName = m.getString("name");
                String simplename = m.getString("simplename");
                String isleaf = m.getString("isleaf");
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("number", membNum);
                msg.put("name", membName);
                msg.put("simplename", simplename);
                msg.put("isleaf", isleaf);
                msg.put("parent", m.getString("parent.number"));
                if (needId) {
                    long memId = m.getLong("id");
                    ((Map)result.get(dimNumber)).put(memId + "", msg);
                    continue;
                }
                result.computeIfAbsent(dimNumber, k -> new HashMap()).put(membName, msg);
                ((Map)result.get(dimNumber)).put(membNum, msg);
            }
        }
        return result;
    }

    private static Map<Object, DynamicObject> queryMembers(DynamicObject dim, String memberFieldFilter, Map.Entry<String, Collection<String>> entry) {
        QFBuilder qf = new QFBuilder();
        qf.add("dimension.id", "=", (Object)dim.getLong("id"));
        qf.add(new QFilter(memberFieldFilter, "in", entry.getValue()));
        return BusinessDataServiceHelper.loadFromCache((String)dim.getString("membermodel"), (String)"id,name,simplename,number,parent,isleaf", (QFilter[])qf.toArray());
    }

    public static Map<String, Map<String, Map<String, String>>> getMemObjMapByCells(HashMultimap<String, String> values, PositionInfo ps, TemplateModel model, boolean needId) {
        LinkedHashMap<String, DynamicObject> dimMap;
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>();
        if (ps == null || ps.getExtendInfo() == null) {
            return result;
        }
        String cacheKey = FloatLogicImpl.class.getName() + ".getMemObjMapByCells." + model.getId();
        if (ThreadCache.exists((Object)cacheKey)) {
            dimMap = (LinkedHashMap<String, DynamicObject>)ThreadCache.get((Object)cacheKey);
        } else {
            dimMap = new LinkedHashMap<String, DynamicObject>(16);
            for (FloatDimInfo floatdim : ps.getExtendInfo().getFloatdims()) {
                String dimNumber = floatdim.getDimension().getNumber();
                dimMap.put(dimNumber, BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,membertable,membermodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber), new QFilter("model", "=", (Object)model.getModelId())}));
                ThreadCache.put((Object)cacheKey, dimMap);
            }
            List cols = ps.getExtendInfo().getCols();
            Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems((List)cols, (long)model.getModelId());
            if (!multiF7ValueByExtMems.isEmpty()) {
                for (Map.Entry entry : multiF7ValueByExtMems.entrySet()) {
                    if (((MultiF7Results)entry.getValue()).getDimDy() == null) continue;
                    String dimNumber = ((MultiF7Results)entry.getValue()).getDimDy().getString("number");
                    dimMap.put(dimNumber, BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,membertable,membermodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimNumber), new QFilter("model", "=", (Object)model.getModelId())}));
                    ThreadCache.put((Object)cacheKey, dimMap);
                }
            }
        }
        QFBuilder qf = new QFBuilder();
        for (Map.Entry entry : values.asMap().entrySet()) {
            DynamicObject dim = (DynamicObject)dimMap.get(entry.getKey());
            if (dim == null) continue;
            qf.add("dimension.id", "=", (Object)dim.getLong("id"));
            qf.add(new QFilter("name", "in", entry.getValue()).or(new QFilter("number", "in", entry.getValue())));
            Collection coll = BusinessDataServiceHelper.loadFromCache((String)dim.getString("membermodel"), (String)"id,name,simplename,number,parent,isleaf", (QFilter[])qf.toArray()).values();
            qf.clear();
            String dimNumber = (String)entry.getKey();
            result.computeIfAbsent(dimNumber, k -> new HashMap()).put(dimNumber, MapInitHelper.ofMap((Object)"number", (Object)dimNumber, (Object)"name", (Object)dim.getString("name"), (Object)"isleaf", (Object)"0"));
            for (DynamicObject m : coll) {
                String membNum = m.getString("number");
                String membName = m.getString("name");
                String string = m.getString("isleaf");
                String simplename = m.getString("simplename");
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("number", membNum);
                msg.put("name", membName);
                msg.put("simplename", simplename);
                msg.put("isleaf", string);
                msg.put("parent", m.getString("parent.number"));
                if (needId) {
                    long memId = m.getLong("id");
                    ((Map)result.get(dimNumber)).put(memId + "", msg);
                    continue;
                }
                result.computeIfAbsent(dimNumber, k -> new HashMap()).put(membName, msg);
                ((Map)result.get(dimNumber)).put(membNum, msg);
            }
        }
        return result;
    }

    public static boolean buildDimMemberGroupByMap(Map<String, Map<String, Map<String, String>>> result, Map<String, Set<String>> scope, String dimnum, String input, Cell cell, long modelId, BasePointInnerLineInfo bn, List<String> nonmember) {
        Map<String, Map<String, String>> mems = result.get(dimnum);
        Map<String, String> member = null;
        Map<Object, Object> dimobj = new HashMap();
        if (mems != null && mems.size() > 0) {
            member = mems.get(input);
            dimobj = mems.get(dimnum);
        }
        if (member == null) {
            if (ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SILENTMEM.getNumber())) {
                return FloatSilentMemImpl.setTempMember(bn, cell, (Pair<String, String>)Pair.onePair(dimobj.get("name"), dimobj.get("number")), input);
            }
            if (cell != null) {
                cell.clearMembersOfUserObject();
            }
            return false;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Dimension dim = new Dimension((String)dimobj.get("name"), (String)dimobj.get("number"), null);
        DimMember memb = new DimMember(member.get("name"), member.get("number"), member.get("simplename"), (IDimension)dim);
        if ((memb = FloatLogicImpl.checkNumberInScopeAndAddNew(scope, (IDimMember)memb, modelId, bn, nonmember)) != null) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimnum, (String)memb.getNumber());
            if (node == null || node == IDNumberTreeNode.NotFoundTreeNode) {
                return false;
            }
            if (DimTypesEnum.ENTITY.getNumber().equals(dimnum) && node.getParent() != null) {
                memb.setPar_SonNum(node.getParent_SonNumber());
            }
            if (cell != null) {
                cell.addDim2UserObject((IDimMember)memb);
            }
            return true;
        }
        if (ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SILENTMEM.getNumber())) {
            return FloatSilentMemImpl.setTempMember(bn, cell, (Pair<String, String>)Pair.onePair((Object)dimobj.get("name"), (Object)dimobj.get("number")), input);
        }
        return !nonmember.isEmpty();
    }

    public static boolean buildDimMemberGroupByMap(Map<String, Map<String, Map<String, String>>> result, String dimnum, String input, Cell cell, long modelId, List<String> nonmember) {
        Map<String, Map<String, String>> mems = result.get(dimnum);
        Map<String, String> member = null;
        Map<Object, Object> dimobj = new HashMap();
        if (mems != null && mems.size() > 0) {
            member = mems.get(input);
            dimobj = mems.get(dimnum);
        }
        if (member == null) {
            if (cell != null) {
                cell.clearMembersOfUserObject();
            }
            return true;
        }
        Dimension dim = new Dimension((String)dimobj.get("name"), (String)dimobj.get("number"), null);
        DimMember memb = new DimMember(member.get("name"), member.get("number"), member.get("simplename"), (IDimension)dim);
        if (cell != null) {
            cell.addDim2UserObject((IDimMember)memb);
            return true;
        }
        return !nonmember.isEmpty();
    }

    public static IDimMember checkNumberInScopeAndAddNew(Map<String, Set<String>> scope, IDimMember memb, long modelId, BasePointInnerLineInfo bn, List<String> nonmember) {
        String dimNum = memb.getDimension().getNumber();
        String memNum = memb.getNumber();
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        Set<String> dimsc = scope.get(dimNum);
        if (dimsc != null) {
            DimMember addtomember = (DimMember)bn.getMemberAddOf();
            if (!dimsc.contains(memNum)) {
                Map nameToNumber = (Map)ThreadCache.get((Object)("nameToNumber" + dimNum), () -> {
                    HashMap<String, String> maps = new HashMap<String, String>();
                    String modelNum = MemberReader.findModelNumberById((Object)modelId);
                    for (IDNumberTreeNode m : MemberReader.getAllNodeFromCache((String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNum), (String)modelNum).values()) {
                        if (!dimsc.contains(m.getNumber()) || !m.getDimNumber().equals(dimNum)) continue;
                        maps.put(m.getName(), m.getNumber());
                    }
                    return maps;
                });
                if (nameToNumber.containsKey(memb.getName())) {
                    memb.setNumber((String)nameToNumber.get(memb.getName()));
                    return memb;
                }
                if (addtomember == null) {
                    return null;
                }
                if ("bcm_userdefinedmembertree".equals(entity)) {
                    nonmember.add(memb.getName());
                    return null;
                }
                return null;
            }
        } else {
            return memb;
        }
        return memb;
    }

    public static List<Map<String, Object>> getFloatMdCell(Sheet sheet) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        sheet.iteratorCells(cell -> {
            if (cell.isMdDataDomain() && cell.isChangeVal() && cell.getUserObject("floatmd") != null && ((Boolean)cell.getUserObject("floatmd")).booleanValue()) {
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                e.put("v", cell.getValue());
                cellValues.add(e);
                cell.removeUserObject("floatmd");
            }
        });
        return cellValues;
    }

    public static Map<String, Set<String>> getInScopeMember(SpreadManager sm, BasePointInfo baseP, long modelid) {
        boolean isSYPNotInPV;
        HashMap<String, Set<String>> inScopeMember = new HashMap<String, Set<String>>();
        long sceneId = sm.getFilter().getCommonFilterId(DimTypesEnum.SCENARIO.getNumber());
        long yearId = sm.getFilter().getCommonFilterId(DimTypesEnum.YEAR.getNumber());
        long periodId = sm.getFilter().getCommonFilterId(DimTypesEnum.PERIOD.getNumber());
        String sceneNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.YEAR.getNumber());
        String periodNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.PERIOD.getNumber());
        if (0L == sceneId) {
            sceneId = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelid), (String)sceneNum).getId();
        }
        if (0L == yearId) {
            yearId = MemberReader.findFyMemberByNum((String)MemberReader.findModelNumberById((Object)modelid), (String)yearNum).getId();
        }
        if (0L == periodId) {
            periodId = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelid), (String)periodNum).getId();
        }
        Recorder sceneRecord = new Recorder((Object)sceneId);
        Recorder yearRecord = new Recorder((Object)yearId);
        Recorder periodRecord = new Recorder((Object)periodId);
        boolean bl = isSYPNotInPV = sceneId == 0L || yearId == 0L || periodId == 0L;
        if (baseP != null) {
            baseP.getBasePointInnerLineInfo().forEach(info -> {
                String dimNum = info.getDimension().getNumber();
                List scope = info.getDynaMembScopes();
                HashSet numbers = new HashSet();
                if (!scope.isEmpty()) {
                    for (DynaMembScopeInfo scinfo : scope) {
                        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum) && !isSYPNotInPV) {
                            VersionParam verParam = new VersionParam(modelid, ((Long)sceneRecord.getRecord()).longValue(), ((Long)yearRecord.getRecord()).longValue(), ((Long)periodRecord.getRecord()).longValue());
                            MembRangeItem item = new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(((DimMember)scinfo.getMember()).getId()), scinfo.getMember().getNumber(), RangeEnum.getRangeByVal((int)scinfo.getRangeId()), scinfo.isCustom(), (Object)modelid);
                            item.matchItem4Ic(verParam, c -> numbers.add(c.getNumber()));
                            continue;
                        }
                        new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(((DimMember)scinfo.getMember()).getId()), scinfo.getMember().getNumber(), RangeEnum.getRangeByVal((int)scinfo.getRangeId()), scinfo.isCustom(), (Object)modelid).matchItems(c -> numbers.add(c.number));
                    }
                    inScopeMember.put(info.getDimension().getNumber(), numbers);
                } else {
                    QFBuilder qb = new QFBuilder();
                    qb.add(new QFilter("model", "=", (Object)modelid));
                    qb.add(new QFilter("number", "=", (Object)info.getDimension().getNumber()));
                    DynamicObject dim = QueryServiceHelper.queryOne((String)info.getDimension().getUqCode(), (String)"id", (QFilter[])qb.toArray());
                    new MembRangeItem(info.getDimension().getUqCode(), Long.valueOf(dim.getLong("id")), info.getDimension().getNumber(), RangeEnum.VALUE_50, false, (Object)modelid).matchItems(c -> numbers.add(c.number));
                    inScopeMember.put(info.getDimension().getNumber(), numbers);
                }
            });
        }
        return inScopeMember;
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getAllDataType(IPageCache pageCache, SpreadManager spread, long modelId) {
        HashMap cachemap = CellDataTypeUtil.getDataTypeCache((IPageCache)pageCache);
        List<String> dims = FloatLogicImpl.getDataTypeDimNums(pageCache, modelId);
        dims.removeAll(cachemap.keySet());
        dims.forEach(dim -> {
            if (!cachemap.containsKey(dim)) {
                DataTypeAcctCacheInfo acctCacheInfo = new DataTypeAcctCacheInfo((Object)modelId, DimEntityNumEnum.getEntieyNumByNumber((String)dim), dim);
                cachemap.put(dim, acctCacheInfo);
            }
        });
        if (!dims.isEmpty()) {
            CellDataTypeUtil.cacheDataTypeInfo((IPageCache)pageCache, (HashMap)cachemap);
        }
        return cachemap;
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getAllDataType(IPageCache pageCache, SpreadManager spread, TemplateModel tempModel) {
        return FloatLogicImpl.getAllDataType(pageCache, spread, tempModel.getModelId());
    }

    public static HashMultimap<String, String> getCellDynaDimValues(List<LinkedHashMap<String, Object>> cells, BasePointInfo refBasePointInfo, PositionInfo ps) {
        HashMultimap values = HashMultimap.create();
        if (refBasePointInfo == null || ps == null) {
            return values;
        }
        LinkedHashMultimap dynaScopeAxis = LinkedHashMultimap.create();
        Point startPoint = ExcelUtils.pos2Point((String)refBasePointInfo.getDynaRange().split(":")[0]);
        int baseAxis = refBasePointInfo.isDirectHoriz() ? startPoint.y : startPoint.x;
        refBasePointInfo.getBasePointInnerLineInfo().forEach(line -> dynaScopeAxis.put((Object)(line.getOffset() + baseAxis), line));
        boolean split = false;
        if (refBasePointInfo.getFloatMemDisplayPattern(ps) == PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER) {
            split = true;
        }
        for (LinkedHashMap<String, Object> map : cells) {
            if (map.get("v") == null) continue;
            int compare = refBasePointInfo.isDirectHoriz() ? (Integer)map.get("r") : (Integer)map.get("c");
            ArrayList basePointInnerLineInfos = Lists.newArrayList((Iterable)dynaScopeAxis.get((Object)compare));
            int basePointInnerLineInfosSize = basePointInnerLineInfos.size();
            String[] dimArray = map.get("v").toString().split(";");
            for (int i = 0; i < basePointInnerLineInfosSize; ++i) {
                BasePointInnerLineInfo basePointInnerLineInfo = (BasePointInnerLineInfo)basePointInnerLineInfos.get(i);
                if (basePointInnerLineInfo == null || basePointInnerLineInfosSize > 1 && !map.get("v").toString().contains("!")) continue;
                String value = split ? (basePointInnerLineInfosSize > 1 ? dimArray[i].split("!")[1].split("\\|")[0] : dimArray[i].split("\\|")[0]) : (basePointInnerLineInfosSize > 1 ? dimArray[i].split("!")[1] : dimArray[i]);
                values.put((Object)basePointInnerLineInfo.getDimension().getNumber(), (Object)value);
            }
        }
        return values;
    }

    public static HashMultimap<String, String> getCellDynaDimValues(List<LinkedHashMap<String, Object>> cells, PositionInfo ps, SpreadManager sm, long modelId) {
        HashMultimap values = HashMultimap.create();
        if (ps == null || ps.getExtendInfo() == null) {
            return values;
        }
        boolean split = false;
        HashMap<String, PositionInfo.FloatMemDisplayPattern> dim2patterns = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(16);
        for (FloatDimInfo floatDimInfo : ps.getExtendInfo().getFloatdims()) {
            dim2patterns.put(floatDimInfo.getDimension().getNumber(), floatDimInfo.getFloatMemDisplayPattern());
        }
        for (LinkedHashMap linkedHashMap : cells) {
            if (linkedHashMap.get("v") == null) continue;
            int index = (Integer)linkedHashMap.get("c");
            String dimKey = (String)sm.getExtFloatDimInfo(ps).get(index);
            String extCol = sm.getExtHeadCol2(((Integer)linkedHashMap.get("r")).intValue(), ((Integer)linkedHashMap.get("c")).intValue());
            DynamicObject dimDy = TemplateFloatUtil.getExtNumWithDim(modelId, extCol).getDimDy();
            if (dimDy != null) {
                dimKey = dimDy.getString("number");
            }
            if (dimKey == null) continue;
            if (!ps.getExtendInfo().getFloatdims().isEmpty() && dim2patterns.get(dimKey) == PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER) {
                split = true;
            }
            String value = linkedHashMap.get("v").toString();
            if (split) {
                value = value.split("\\|")[0];
            }
            values.put((Object)dimKey, (Object)value);
        }
        return values;
    }

    public static List<String> getDataTypeDimNums(IPageCache pageCache, Object modelId) {
        return (List)ThreadCache.get((Object)"dataTypeDimNums", () -> {
            String dataTypeDimNums = pageCache.get("dataTypeDimNums");
            if (StringUtils.isNotEmpty((String)dataTypeDimNums)) {
                List numList = (List)ObjectSerialUtil.parseObject((String)dataTypeDimNums, List.class);
                return numList;
            }
            List dims = DataTypeEnum.getDataTypePerSetDims((Object)modelId);
            Collection coll = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("model.id", "=", modelId), new QFilter("issysdimension", "=", (Object)"0")}, null).values();
            coll.forEach(dy -> dims.add(dy.getString("number")));
            pageCache.put("dataTypeDimNums", ObjectSerialUtil.toJson((Object)dims));
            return dims;
        });
    }

    public static boolean checkCellIsUnLeaf(Cell cell, Map<String, Map<String, Map<String, String>>> result, String id) {
        boolean isleaf = false;
        if (cell.getMemberFromUserObject() != null) {
            Map<Object, Object> msg = new HashMap();
            for (IDimMember mem : cell.getMemberFromUserObject()) {
                Map<String, Map<String, String>> dimmap;
                if (mem.isTemp() || (dimmap = result.get(mem.getDimension().getNumber())) == null) continue;
                msg = StringUtils.isNotEmpty((String)id) ? dimmap.get(id) : dimmap.get(mem.getNumber());
                if (msg == null) {
                    return false;
                }
                String isleafStr = (String)msg.get("isleaf");
                if (isleafStr == null || !"0".equals(isleafStr)) continue;
                isleaf = true;
                break;
            }
        }
        return isleaf;
    }

    public static Map<String, Map<String, Map<String, String>>> collectMemMsg(List<Row> rowslimitfix, BasePointInfo bs, long modelId) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>(16);
        HashMap dimnums = new HashMap();
        boolean isEntityInRC = false;
        for (BasePointInnerLineInfo bn : bs.getBasePointInnerLineInfo()) {
            if (bn.isFloated()) {
                isEntityInRC = isEntityInRC ? isEntityInRC : DimTypesEnum.ENTITY.getNumber().equals(bn.getDimension().getNumber());
                dimnums.put(bn.getDimension().getNumber(), new HashSet());
                continue;
            }
            if (bn.isFloated() || bn.getOffset() == -1) continue;
            isEntityInRC = isEntityInRC ? isEntityInRC : DimTypesEnum.ENTITY.getNumber().equals(bn.getDimension().getNumber());
            dimnums.put(bn.getDimension().getNumber(), new HashSet());
        }
        ArrayList<FilterOrgStructParam> params = new ArrayList<FilterOrgStructParam>(16);
        String modelnumber = MemberReader.findModelNumberById((Object)modelId);
        HashSet<String> paramskey = new HashSet<String>();
        for (Row row : rowslimitfix) {
            if (isEntityInRC) {
                String scnum = row.getString(DimTypesEnum.SCENARIO.getNumber());
                String string = row.getString(DimTypesEnum.PERIOD.getNumber());
                String fynum = row.getString(DimTypesEnum.YEAR.getNumber());
                if (paramskey.add((String)scnum + string + fynum)) {
                    long sceneId = BcmThreadCache.findMemberByNum((String)modelnumber, (String)DimTypesEnum.SCENARIO.getNumber(), (String)scnum).getId();
                    long periodId = BcmThreadCache.findMemberByNum((String)modelnumber, (String)DimTypesEnum.PERIOD.getNumber(), (String)string).getId();
                    params.add(new FilterOrgStructParam(modelId, sceneId, fynum, periodId));
                }
            }
            for (Map.Entry entry : dimnums.entrySet()) {
                String numbernum = row.getString((String)entry.getKey());
                ((Set)entry.getValue()).add(numbernum);
            }
        }
        for (Map.Entry entry : dimnums.entrySet()) {
            String simplename;
            String dimnum = (String)entry.getKey();
            HashMap hashMap = new HashMap(16);
            if (isEntityInRC && DimTypesEnum.ENTITY.getNumber().equals(dimnum)) {
                DynamicObjectCollection doc;
                List ids;
                QFilter qf = new QFilter("number", "in", entry.getValue());
                qf.and(new QFilter("simplename", "not in", (Object)Lists.newArrayList((Object[])new String[]{"", " "})));
                QFilter qfmodel = new QFilter("model", "=", (Object)modelId);
                if (DimensionUtil.isUserDefinedDim(dimnum)) {
                    qfmodel.and("dimension.number", "=", (Object)dimnum);
                }
                if (!(ids = (doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{qf, qfmodel})).stream().map(d -> d.getLong("id")).collect(Collectors.toList())).isEmpty()) {
                    for (Map.Entry objectEntry : EntityVersioningUtil.getEffectiveOrgNameByPY(params, ids).entrySet()) {
                        String name = ((DynamicObject)objectEntry.getValue()).getString("name");
                        String number = ((DynamicObject)objectEntry.getValue()).getString("number");
                        simplename = ((DynamicObject)objectEntry.getValue()).getString("simplename");
                        HashMap<String, String> msg = new HashMap<String, String>();
                        msg.put("name", name);
                        msg.put("number", number);
                        msg.put("simplename", simplename);
                        hashMap.put(number, msg);
                    }
                }
            } else {
                boolean isShowSimpleName;
                String selectFields = "number,simplename";
                boolean bl = isShowSimpleName = bs != null && PositionInfo.FloatMemDisplayPattern.SIMPLENAME == bs.getFloatMemDisplayPattern();
                if (isShowSimpleName) {
                    QFilter qf = new QFilter("number", "in", entry.getValue());
                    qf.and(new QFilter("simplename", "not in", (Object)Lists.newArrayList((Object[])new String[]{"", " "})));
                    QFilter qfmodel = new QFilter("model", "=", (Object)modelId);
                    if (DimensionUtil.isUserDefinedDim(dimnum)) {
                        qfmodel.and("dimension.number", "=", (Object)dimnum);
                    }
                    for (DynamicObject obj : QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimnum), (String)selectFields, (QFilter[])new QFilter[]{qfmodel, qf})) {
                        String number = obj.getString("number");
                        HashMap<String, String> msg = new HashMap<String, String>();
                        simplename = obj.getString("simplename");
                        msg.put("simplename", simplename);
                        hashMap.put(number, msg);
                    }
                }
            }
            result.put(dimnum, hashMap);
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, String>>> collectMemMsg(SpreadManager spreadManager, long modelId) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>(16);
        HashSet<String> mcNumbers = new HashSet<String>(16);
        Sheet sheet = spreadManager.getBook().getSheet(0);
        for (PositionInfo info : spreadManager.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePointInfo : info.getBasePoints()) {
                RangeModel baseRangeModel = new RangeModel(basePointInfo.getDynaRange());
                int startIndex = basePointInfo.isDirectHoriz() ? baseRangeModel.getX_start() : baseRangeModel.getY_start();
                int endIndex = basePointInfo.isDirectHoriz() ? baseRangeModel.getX_end() : baseRangeModel.getY_end();
                int rangeStartIndex = basePointInfo.isDirectHoriz() ? baseRangeModel.getY_start() : baseRangeModel.getX_start();
                for (int i = startIndex; i < endIndex; ++i) {
                    for (BasePointInnerLineInfo basePointInnerLineInfo : basePointInfo.getBasePointInnerLineInfo()) {
                        int offset = basePointInnerLineInfo.getOffset();
                        if (offset < 0) continue;
                        int index = rangeStartIndex + offset;
                        Cell cell = basePointInfo.isDirectHoriz() ? sheet.getCell(index, i) : sheet.getCell(i, index);
                        if (cell.getUserObject("numberfrom") == null || cell.getMemberFromUserObject() == null) continue;
                        for (IDimMember member : cell.getMemberFromUserObject()) {
                            mcNumbers.add(member.getNumber());
                        }
                    }
                }
            }
        }
        if (!mcNumbers.isEmpty()) {
            QFilter qfmodel = new QFilter("model", "=", (Object)modelId);
            QFilter qf = new QFilter("number", "in", mcNumbers);
            HashMap map = new HashMap(16);
            for (DynamicObject obj : QueryServiceHelper.query((String)"bcm_mycompanymembertree", (String)"number,name,simplename", (QFilter[])new QFilter[]{qfmodel, qf})) {
                String number = obj.getString("number");
                String simplename = obj.getString("simplename");
                String name = obj.getString("name");
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("simplename", simplename);
                msg.put("name", name);
                map.put(number, msg);
            }
            result.put(DimTypesEnum.MYCOMPANY.getNumber(), map);
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, String>>> collectMemMsg(String dimNum, Collection<Long> ids, long modelId) {
        QFilter qf = new QFilter("id", "in", ids);
        Map<String, Map<String, Map<String, String>>> result = FloatLogicImpl.collectMemMsg(dimNum, modelId, qf);
        return result;
    }

    public static Map<String, Map<String, Map<String, String>>> collectMemMsg(String dimNum, long modelId, QFilter qf) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>(16);
        qf.and(new QFilter("simplename", "not in", (Object)Lists.newArrayList((Object[])new String[]{"", " "})));
        QFilter qfmodel = new QFilter("model", "=", (Object)modelId);
        HashMap map = new HashMap(16);
        for (DynamicObject obj : QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)"number,simplename", (QFilter[])new QFilter[]{qfmodel, qf})) {
            String number = obj.getString("number");
            String simplename = obj.getString("simplename");
            HashMap<String, String> msg = new HashMap<String, String>();
            msg.put("simplename", simplename);
            map.put(number, msg);
        }
        result.put(dimNum, map);
        return result;
    }

    public static String getBpNumber(SpreadManager spread) {
        ArrayList pageAndViewDim = new ArrayList(spread.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(spread.getFilter().getViewPointDomain().getDimensions());
        String number = null;
        for (IDimension dim : pageAndViewDim) {
            if (!DimTypesEnum.PROCESS.getNumber().equals(dim.getNumber())) continue;
            for (IDimMember mem : dim.getMembers()) {
                number = mem.getNumber();
            }
        }
        return number;
    }

    public static List<Map<String, Object>> getNoMemberCellToClear(SpreadManager spread) {
        Cell cell;
        Sheet sheet = spread.getBook().getSheet(0);
        ArrayList<String> ranges = new ArrayList<String>(16);
        for (PositionInfo ps : spread.getAreaManager().getPostionInfoSet()) {
            if (ps.getExtendInfo() != null) continue;
            ranges.add(ps.getAreaRange());
        }
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        for (String range : ranges) {
            String startpoint = range.split(":")[0];
            String endpoint = range.split(":")[1];
            int startx = ExcelUtils.pos2X((String)startpoint);
            int starty = ExcelUtils.pos2Y((String)startpoint);
            int endx = ExcelUtils.pos2X((String)endpoint);
            int endy = ExcelUtils.pos2Y((String)endpoint);
            for (int x = startx; x <= endx; ++x) {
                for (int y = starty; y <= endy; ++y) {
                    boolean isclrear_NoCrossMem;
                    cell = sheet.getCell(y, x);
                    boolean bl = isclrear_NoCrossMem = cell.getUserObject("not_cross") != null && (Boolean)cell.getUserObject("not_cross") == false;
                    if (cell.getValue() == null || cell.isMdDataDomain() || !isclrear_NoCrossMem && cell.getUserObject("not_cross") != null) continue;
                    HashMap<String, Integer> e = new HashMap<String, Integer>(3);
                    e.put("r", cell.getRow());
                    e.put("c", cell.getCol());
                    e.put("v", null);
                    cellValues.add(e);
                }
            }
        }
        for (PositionInfo ps : spread.getAreaManager().getPostionInfoSet()) {
            String areaRang = ps.getAreaRange();
            String areastartpoint = areaRang.split(":")[0];
            String areaendpoint = areaRang.split(":")[1];
            int areastartx = ExcelUtils.pos2X((String)areastartpoint);
            int areastarty = ExcelUtils.pos2Y((String)areastartpoint);
            int areaendx = ExcelUtils.pos2X((String)areaendpoint);
            int areaendy = ExcelUtils.pos2Y((String)areaendpoint);
            for (BasePointInfo basePointInfo : ps.getBasePoints()) {
                boolean isExistFloatMember;
                String range = basePointInfo.getDynaRange();
                int direct = basePointInfo.getDirect();
                String startpoint = range.split(":")[0];
                String endpoint = range.split(":")[1];
                int startx = ExcelUtils.pos2X((String)startpoint);
                int starty = ExcelUtils.pos2Y((String)startpoint);
                int endx = ExcelUtils.pos2X((String)endpoint);
                int endy = ExcelUtils.pos2Y((String)endpoint);
                if (direct == 1) {
                    for (int x = startx; x <= endx; ++x) {
                        int y;
                        isExistFloatMember = false;
                        for (y = areastarty; y <= areaendy; ++y) {
                            cell = sheet.getCell(y, x);
                            if (!cell.isMdDataDomain()) continue;
                            isExistFloatMember = true;
                        }
                        if (isExistFloatMember) continue;
                        for (y = starty; y <= endy; ++y) {
                            FloatLogicImpl.clearCellValues(sheet, cellValues, y, x);
                        }
                    }
                    continue;
                }
                for (int y = starty; y <= endy; ++y) {
                    int x;
                    isExistFloatMember = false;
                    for (x = areastartx; x <= areaendx; ++x) {
                        cell = sheet.getCell(y, x);
                        if (!cell.isMdDataDomain()) continue;
                        isExistFloatMember = true;
                    }
                    if (isExistFloatMember) continue;
                    for (x = startx; x <= endx; ++x) {
                        FloatLogicImpl.clearCellValues(sheet, cellValues, y, x);
                    }
                }
            }
        }
        return cellValues;
    }

    private static void clearCellValues(Sheet sheet, List<Map<String, Object>> cellValues, int y, int x) {
        Cell cell = sheet.getCell(y, x);
        if (cell.getValue() != null) {
            HashMap<String, Integer> e = new HashMap<String, Integer>(3);
            e.put("r", cell.getRow());
            e.put("c", cell.getCol());
            e.put("v", null);
            cellValues.add(e);
            cell.setValue(null);
            cell.clearAllUserObject();
        }
    }

    public static List<Integer> addToUpdateEnumindex(int r, int c, IPageCache pageCache, List<Integer> updateenumindex) {
        if (updateenumindex == null) {
            updateenumindex = new ArrayList<Integer>();
        }
        if (FloatLogicImpl.isDirectHoriz(pageCache)) {
            updateenumindex.add(c);
        } else {
            updateenumindex.add(r);
        }
        return updateenumindex;
    }

    public static void UpdateEnumByindex(AbstractMultiReportPlugin plugin, List<Integer> updateenumindex, String range) {
        IPageCache pageCache = plugin.getPageCache();
        if (updateenumindex != null) {
            if (FloatLogicImpl.isDirectHoriz(pageCache)) {
                EnumStyleCellUtils.setEnumStyleCell(plugin, pageCache, null, updateenumindex, range);
            } else {
                EnumStyleCellUtils.setEnumStyleCell(plugin, pageCache, updateenumindex, null, range);
            }
        }
    }

    public static RangeModel getFloatEffRange(SpreadManager spmodel, List<Integer> index) {
        int first = index.get(0);
        boolean isH = DynamicUtils.isDirectHoriz((SpreadManager)spmodel);
        String rangeArea = "";
        for (PositionInfo p : spmodel.getAreaManager().getPostionInfoSet()) {
            String area = p.getAreaRange();
            boolean match = isH ? SpreadAreaUtil.isColInArea((int)first, (String)area) : SpreadAreaUtil.isRowInArea((int)first, (String)area);
            if (!match) continue;
            rangeArea = area;
            break;
        }
        RangeModel areaRange = new RangeModel(rangeArea);
        RangeModel floatrange = isH ? new RangeModel(index.get(0).intValue(), index.get(index.size() - 1).intValue(), areaRange.getY_start(), areaRange.getY_end()) : new RangeModel(areaRange.getX_start(), areaRange.getX_end(), index.get(0).intValue(), index.get(index.size() - 1).intValue());
        return floatrange;
    }

    public static List<RangeModel> getRangeByCommands(SpreadManager sp, List<Map<String, Object>> commands) {
        String sign = DynamicUtils.isDirectHoriz((SpreadManager)sp) ? "c" : "r";
        HashSet ir = new HashSet();
        commands.forEach(m -> ir.add((Integer)m.get(sign)));
        HashMap areas = new HashMap();
        boolean isH = DynamicUtils.isDirectHoriz((SpreadManager)sp);
        Iterator iterator = ir.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            String rangeArea = "";
            for (PositionInfo p : sp.getAreaManager().getPostionInfoSet()) {
                String area = p.getAreaRange();
                boolean match = isH ? SpreadAreaUtil.isColInArea((int)i, (String)area) : SpreadAreaUtil.isRowInArea((int)i, (String)area);
                if (!match) continue;
                rangeArea = area;
                break;
            }
            if (!StringUtils.isNotEmpty((String)rangeArea)) continue;
            if (!areas.containsKey(rangeArea)) {
                areas.put(rangeArea, new ArrayList());
            }
            ((List)areas.get(rangeArea)).add(i);
        }
        ArrayList<RangeModel> rangeModels = new ArrayList<RangeModel>(areas.size());
        for (List area : areas.values()) {
            area.sort(Comparator.comparingInt(o -> o));
            rangeModels.add(FloatLogicImpl.getFloatEffRange(sp, area));
        }
        return rangeModels;
    }

    public static RangeModel getRangeForF7Back(SpreadManager sp, SpreadSelector seletor, Object result) {
        ArrayList<Integer> ir = new ArrayList<Integer>(16);
        int startindex = DynamicUtils.isDirectHoriz((SpreadManager)sp) ? seletor.getStartCol() : seletor.getStartRow();
        int size = 1;
        if (result instanceof ListSelectedRowCollection) {
            size = ((ListSelectedRowCollection)result).size();
        }
        for (int i = 0; i < size; ++i) {
            ir.add(startindex);
            ++startindex;
        }
        RangeModel rangeModel = FloatLogicImpl.getFloatEffRange(sp, ir);
        return rangeModel;
    }

    public static void showTip2(AbstractMultiReportPlugin plugin) {
        plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6d6e\u52a8\u6210\u5458\uff0c\u5426\u5219\u8be5\u6570\u636e\u4e0d\u4f1a\u5b58\u50a8\u3002", (String)"FloatLogicImpl_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static void hideArea(SpreadManager sm, String key, IClientViewProxy proxy, boolean isHide) {
        List<Object> areas = new ArrayList(16);
        int[] row = new int[]{};
        int[] col = new int[]{};
        switch (key) {
            case "bar_txtfloat": {
                areas = FloatLogicImpl.getHideTXTFloat(sm);
                break;
            }
            case "bar_nullzerofloat": {
                areas = FloatLogicImpl.getHideNullOrZeroFloat(sm);
                break;
            }
            case "bar_floatarea": {
                areas = FloatLogicImpl.getHideFloatArea(sm);
                break;
            }
            case "bar_allfloat": {
                areas = FloatLogicImpl.getHideFloatArea(sm);
            }
        }
        if (sm.isHorizon() == 1) {
            col = areas.stream().mapToInt(Integer::intValue).toArray();
        } else if (sm.isHorizon() == 2) {
            row = areas.stream().mapToInt(Integer::intValue).toArray();
        }
        SpreadEasyInvoker.setRowsVisble(proxy, SPREAD_KEY, row, isHide);
        SpreadEasyInvoker.setColumnVisble(proxy, SPREAD_KEY, col, isHide);
    }

    public static List<Integer> getHideTXTFloat(SpreadManager sm) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        Predicate<Cell> matchTxt = c -> c.getValue() == null || c.getValue() instanceof String || c.getValue() instanceof Character;
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                Point start = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[0]);
                Point end = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[1]);
                if (!basePointInfo.isDirectHoriz()) {
                    matchRows.addAll(FloatLogicImpl.getMatchRowArea(sm, start.y, end.y, matchTxt));
                    continue;
                }
                matchRows.addAll(FloatLogicImpl.getMatchColArea(sm, start.x, end.x, matchTxt));
            }
        }
        return matchRows;
    }

    public static List<Integer> getHideNullOrZeroFloat(SpreadManager sm) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        Predicate<Cell> matchNullOrZero = c -> c.getValue() == null || c.getValue() instanceof Number && TypeConversionUtils.objToBigDecimal((Object)c.getValue()).compareTo(BigDecimal.ZERO) == 0;
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                Point start = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[0]);
                Point end = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[1]);
                if (!basePointInfo.isDirectHoriz()) {
                    matchRows.addAll(FloatLogicImpl.getMatchRowArea(sm, start.y, end.y, matchNullOrZero));
                    continue;
                }
                matchRows.addAll(FloatLogicImpl.getMatchColArea(sm, start.x, end.x, matchNullOrZero));
            }
        }
        return matchRows;
    }

    public static List<Integer> getHideFloatArea(SpreadManager sm) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                int i;
                Point start = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[0]);
                Point end = ExcelUtils.pos2Point((String)basePointInfo.getDynaRange().split(":")[1]);
                if (!basePointInfo.isDirectHoriz()) {
                    for (i = start.y; i <= end.y; ++i) {
                        matchRows.add(i);
                    }
                    continue;
                }
                for (i = start.x; i <= end.x; ++i) {
                    matchRows.add(i);
                }
            }
        }
        return matchRows;
    }

    private static List<Integer> getMatchRowArea(SpreadManager sm, int startIndex, int endIndex, Predicate<Cell> matcher) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        for (int i = startIndex; i <= endIndex; ++i) {
            Recorder allMatch = new Recorder((Object)true);
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            sm.getBook().getSheet(0).iteratorRowRangeCells(i, i, false, c -> {
                if (c.isMdDataDomain() && ((Boolean)allMatch.getRecord()).booleanValue() && !matcher.test((Cell)c)) {
                    allMatch.setRecord((Object)false);
                }
            });
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            matchRows.add(i);
        }
        return matchRows;
    }

    private static List<Integer> getMatchColArea(SpreadManager sm, int startIndex, int endIndex, Predicate<Cell> matcher) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        for (int i = startIndex; i <= endIndex; ++i) {
            Recorder allMatch = new Recorder((Object)true);
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            sm.getBook().getSheet(0).iteratorColRangeCells(i, i, false, c -> {
                if (c.isMdDataDomain() && ((Boolean)allMatch.getRecord()).booleanValue() && !matcher.test((Cell)c)) {
                    allMatch.setRecord((Object)false);
                }
            });
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            matchRows.add(i);
        }
        return matchRows;
    }

    public static List<Integer> getHasMemNotValueRC_OutOriRange(SpreadManager sm, PositionInfo positionInfo, BasePointInfo basePointInfo) {
        RangeModel floatDataRange;
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        boolean isRowFloat = !basePointInfo.isDirectHoriz();
        RangeModel floatRange = new RangeModel(basePointInfo.getDynaRange());
        RangeModel datarange = new RangeModel(positionInfo.getAreaRange());
        RangeModel floatAreaDataRange = new RangeModel(basePointInfo.getOriginalDynaRange());
        if (isRowFloat) {
            int endDataRangeCol;
            int floatSize = floatAreaDataRange.getRowSize();
            int startFloatRow = floatRange.getY_start() + floatSize;
            int endFloatRow = floatRange.getY_end();
            int startDataRangeCol = datarange.getX_start();
            floatDataRange = new RangeModel(startDataRangeCol, endDataRangeCol = datarange.getX_end(), startFloatRow, endFloatRow);
            if (floatDataRange.getRowSize() < 1) {
                return matchRows;
            }
        } else {
            int endDataRangeRow;
            int startDataRangeRow;
            int endFloatCol;
            int floatSize = floatAreaDataRange.getColSize();
            int startFloatCol = floatRange.getX_start() + floatSize;
            floatDataRange = new RangeModel(startFloatCol, endFloatCol = floatRange.getX_end(), startDataRangeRow = datarange.getY_start(), endDataRangeRow = datarange.getY_end());
            if (floatDataRange.getColSize() < 1) {
                return matchRows;
            }
        }
        if (basePointInfo.getShowFloatMember(positionInfo).booleanValue()) {
            matchRows.addAll(FloatLogicImpl.matchNotHasMemRC(sm, floatRange, isRowFloat));
        } else {
            matchRows.addAll(FloatLogicImpl.matchHasMemNotValueRC(sm, floatDataRange, isRowFloat));
        }
        return matchRows;
    }

    public static List<Integer> matchHasMemNotValueRC(SpreadManager sm, RangeModel floatDataRange, boolean isRow) {
        Predicate<Cell> matchNullOrZero = c -> c.getValue() == null || !c.isMdDataDomain() && c.getFormula() != null;
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        int startIndex = isRow ? floatDataRange.getY_start() : floatDataRange.getX_start();
        int endIndex = isRow ? floatDataRange.getY_end() : floatDataRange.getX_end();
        int startLoopIndex = isRow ? floatDataRange.getX_start() : floatDataRange.getY_start();
        int endLoopindex = isRow ? floatDataRange.getX_end() : floatDataRange.getY_end();
        for (int i = startIndex; i <= endIndex; ++i) {
            Recorder allMatch = new Recorder((Object)true);
            Consumer<Cell> consumer = c -> {
                if (((Boolean)allMatch.getRecord()).booleanValue() && !matchNullOrZero.test((Cell)c)) {
                    allMatch.setRecord((Object)false);
                }
            };
            if (isRow) {
                sm.getBook().getSheet(0).iteratorRangeCells(i, i, startLoopIndex, endLoopindex, false, consumer);
            } else {
                sm.getBook().getSheet(0).iteratorRangeCells(startLoopIndex, endLoopindex, i, i, false, consumer);
            }
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            matchRows.add(i);
        }
        return matchRows;
    }

    public static List<Integer> matchNotHasMemRC(SpreadManager sm, RangeModel floatRange, boolean isRow) {
        Predicate<Cell> matchNull = c -> c.getNotNullMemberUserObject().isEmpty();
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        int startIndex = isRow ? floatRange.getY_start() : floatRange.getX_start();
        int endIndex = isRow ? floatRange.getY_end() : floatRange.getX_end();
        int startLoopIndex = isRow ? floatRange.getX_start() : floatRange.getY_start();
        int endLoopindex = isRow ? floatRange.getX_end() : floatRange.getY_end();
        for (int i = startIndex; i <= endIndex; ++i) {
            Recorder allMatch = new Recorder((Object)true);
            Consumer<Cell> consumer = c -> {
                if (((Boolean)allMatch.getRecord()).booleanValue() && !matchNull.test((Cell)c)) {
                    allMatch.setRecord((Object)false);
                }
            };
            if (isRow) {
                sm.getBook().getSheet(0).iteratorRangeCells(i, i, startLoopIndex, endLoopindex, false, consumer);
            } else {
                sm.getBook().getSheet(0).iteratorRangeCells(startLoopIndex, endLoopindex, i, i, false, consumer);
            }
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            matchRows.add(i);
        }
        return matchRows;
    }

    public static List<Integer> matchHasDataRC(SpreadManager sm, RangeModel floatDataRange, boolean isRow) {
        Predicate<Cell> matchHasData = c -> c.isMdDataDomain();
        ArrayList<Integer> matchRows = new ArrayList<Integer>(16);
        int startIndex = isRow ? floatDataRange.getY_start() : floatDataRange.getX_start();
        int endIndex = isRow ? floatDataRange.getY_end() : floatDataRange.getX_end();
        int startLoopIndex = isRow ? floatDataRange.getX_start() : floatDataRange.getY_start();
        int endLoopindex = isRow ? floatDataRange.getX_end() : floatDataRange.getY_end();
        for (int i = startIndex; i <= endIndex; ++i) {
            Recorder allMatch = new Recorder((Object)false);
            Consumer<Cell> consumer = c -> {
                if (!((Boolean)allMatch.getRecord()).booleanValue() && matchHasData.test((Cell)c)) {
                    allMatch.setRecord((Object)true);
                }
            };
            if (isRow) {
                sm.getBook().getSheet(0).iteratorRangeCells(i, i, startLoopIndex, endLoopindex, false, consumer);
            } else {
                sm.getBook().getSheet(0).iteratorRangeCells(startLoopIndex, endLoopindex, i, i, false, consumer);
            }
            if (!((Boolean)allMatch.getRecord()).booleanValue()) continue;
            matchRows.add(i);
        }
        return matchRows;
    }
}

