/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.SpecialCellObjectUtil;

public class HideLogicImpl {
    private static List<String> allChildbp = Arrays.asList("Rpt", "IRpt", "RAdj", "ERpt", "EIRpt", "ERAdj");
    private static List<String> allChildat = Arrays.asList("EntityInput", "ATTotal");

    public static void checkAndFixHideMember(long modelid, SpreadManager sm, Cell cell, boolean addMem) {
        if (cell.isMdDataDomain()) {
            return;
        }
        BasePointInfo basePointInfo = TemplateFloatUtil.getBasePointInfoByMdCell(sm, cell.getRow(), cell.getCol());
        if (basePointInfo != null && !basePointInfo.getHideInfo().isEmpty()) {
            HideLogicImpl.fixHideMember(sm, cell, basePointInfo, addMem, modelid);
            TemplateFloatUtil.setMsgBack2Cell(modelid, sm, cell.getRow(), cell.getCol(), null, false, true, null, basePointInfo);
        }
    }

    public static void fixHideMember(SpreadManager sm, Cell cell, BasePointInfo basePointInfo, boolean addMem, Long modelId) {
        HideLogicImpl.fixHideMember(sm, cell, basePointInfo, addMem, modelId, null);
    }

    public static void fixHideMember(SpreadManager sm, Cell cell, BasePointInfo basePointInfo, String membernumber) {
        HideLogicImpl.fixHideMember(sm, cell, basePointInfo, false, null, membernumber);
    }

    private static void fixHideMember(SpreadManager sm, Cell cell, BasePointInfo basePointInfo, boolean addMem, Long modelId, String membernumber) {
        HashMap memmap = new HashMap(16);
        sm.getFilter().getPageDomain().getAllMembers().forEach(e -> memmap.put(e.getDimension().getNumber(), e.getNumber()));
        sm.getFilter().getViewPointDomain().getAllMembers().forEach(e -> memmap.put(e.getDimension().getNumber(), e.getNumber()));
        RangeModel spreadAreaRange = new RangeModel(basePointInfo.getDynaRange());
        int x = spreadAreaRange.getY_start();
        int y = spreadAreaRange.getX_start();
        for (BasePointInnerLineInfo innerInfo : basePointInfo.getBasePointInnerLineInfo()) {
            String cube;
            if (!innerInfo.isIshide()) continue;
            if (StringUtils.isEmpty((String)membernumber) && memmap.containsKey(innerInfo.getNumberfrom())) {
                membernumber = (String)memmap.get(innerInfo.getNumberfrom());
            }
            IDimension dim = innerInfo.getDimension();
            DimMember member = new DimMember(null, membernumber, null, dim);
            if (addMem) {
                member = HideLogicImpl.addMember(modelId, innerInfo, membernumber);
            } else if (modelId != null && MemberReader.isExistMember((String)(cube = QueryDimensionServiceHelper.getModelNumber((long)modelId)), (String)innerInfo.getDimension().getNumber(), (String)membernumber)) {
                IDNumberTreeNode mem = MemberReader.findMemberByNumber((String)cube, (String)innerInfo.getDimension().getNumber(), (String)membernumber);
                member = new DimMember(mem.getName(), mem.getNumber(), null, innerInfo.getDimension());
            }
            if (member == null) continue;
            Cell first = basePointInfo.getDirect() == 2 ? sm.getBook().getSheet(0).getCell(cell.getRow(), y) : sm.getBook().getSheet(0).getCell(x, cell.getCol());
            SpecialCellObjectUtil.addHideMembers((Cell)first, (IDimMember)member);
        }
    }

    private static DimMember addMember(Long modelid, BasePointInnerLineInfo innerInfo, String number) {
        if (modelid == null) {
            return null;
        }
        String cube = QueryDimensionServiceHelper.getModelNumber((long)modelid);
        if (MemberReader.isExistMember((String)cube, (String)innerInfo.getDimension().getNumber(), (String)number)) {
            IDNumberTreeNode mem = MemberReader.findMemberByNumber((String)cube, (String)innerInfo.getDimension().getNumber(), (String)number);
            return new DimMember(mem.getName(), mem.getNumber(), null, innerInfo.getDimension());
        }
        if (innerInfo.getMemberAddOf() != null && DimEntityNumEnum.getEntieyNumByNumber((String)innerInfo.getDimension().getNumber()).equals("bcm_userdefinedmembertree")) {
            DynamicObject from = BusinessDataServiceHelper.loadSingle((String)DimEntityNumEnum.getEntieyNumByNumber((String)innerInfo.getNumberfrom()), (String)"name", (QFilter[])new QFilter[]{new QFilter("model.number", "=", (Object)cube), new QFilter("number", "=", (Object)number)});
            HashMap<String, String> member = new HashMap<String, String>(16);
            String name = from.getString("name");
            member.put(number, name);
            MemberServiceHelper.createMember((long)modelid, (String)innerInfo.getDimension().getNumber(), member, (long)((DimMember)innerInfo.getMemberAddOf()).getId(), (DimMemTypeEnum)DimMemTypeEnum.FLOATMEM);
            return new DimMember(name, number, null, innerInfo.getDimension());
        }
        return null;
    }

    public static void filterRows(List<Row> rows, BasePointInfo basePointInfo, SpreadManager sm, long modelId, long orgId) {
        HashMap nums = new HashMap(16);
        sm.getFilter().getViewPointDomain().getAllMembers().forEach(v -> nums.put(v.getDimension().getNumber(), v.getNumber()));
        sm.getFilter().getPageDomain().getAllMembers().forEach(v -> nums.put(v.getDimension().getNumber(), v.getNumber()));
        String bp = (String)nums.get(DimTypesEnum.PROCESS.getNumber());
        String at = (String)nums.get(DimTypesEnum.AUDITTRIAL.getNumber());
        HashMap<String, String> hides = new HashMap<String, String>(16);
        for (BasePointInnerLineInfo bin : basePointInfo.getBasePointInnerLineInfo()) {
            if (!bin.isIshide()) continue;
            hides.put(bin.getDimension().getNumber(), bin.getNumberfrom());
        }
        if (hides.isEmpty() || rows.isEmpty()) {
            return;
        }
        List<String> orgAllChilds = HideLogicImpl.getOrgAllChilds(modelId, orgId);
        if (orgId != 0L && HideLogicImpl.checkBpAndAt(bp, at)) {
            HideLogicImpl.filterRows(rows, r -> {
                for (Map.Entry h : hides.entrySet()) {
                    String roworg;
                    if (!(((String)h.getValue()).equals(DimTypesEnum.ENTITY.getNumber()) ? !orgAllChilds.contains(roworg = r.getString((String)h.getKey())) : !r.getString((String)h.getKey()).equals(r.getString((String)h.getValue())))) continue;
                    return false;
                }
                return true;
            });
        } else {
            HideLogicImpl.filterRows(rows, r -> {
                for (Map.Entry h : hides.entrySet()) {
                    if (r.getString((String)h.getKey()).equals(r.getString((String)h.getValue()))) continue;
                    return false;
                }
                return true;
            });
        }
    }

    private static boolean checkBpAndAt(String bp, String at) {
        return allChildbp.contains(bp) && allChildat.contains(at);
    }

    private static List<String> getOrgAllChilds(long modelId, long orgId) {
        ArrayList<String> list = new ArrayList<String>(10);
        DynamicObject self = TreeStructureServiceHelper.getSelfById((String)DimEntityNumEnum.ENTITY.getEntityNum(), (Long)orgId, (String)"number");
        list.add(self.getString("number"));
        List items = TreeStructureServiceHelper.getChild((String)DimEntityNumEnum.ENTITY.getEntityNum(), (Long)orgId, (Object)modelId);
        items.forEach(m -> list.add(m.number));
        return list;
    }

    public static void filterRows(List<Row> rows, Predicate<Row> function) {
        rows.removeIf(r -> !function.test((Row)r));
    }
}

