/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.report.style.adjust.FloatDataProvider;
import kd.fi.bcm.formplugin.report.util.ReportPeriodUtil;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class OffsetLogicImpl {
    private static final String OLD_DATA = "oldData";

    public static void cleanMdData(SpreadManager sm, TemplateModel template, PositionInfo positionInfo, BasePointInfo basePointInfo, List<Row> rows, boolean autoOffset, long orgId) {
        if (!MemberReader.isExistMember((String)MemberReader.findModelNumberById((Object)template.getModelId()), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)"AutoCWP")) {
            return;
        }
        int beforenum = rows.size();
        if (positionInfo.getOffsetIndex() == null || positionInfo.getOffsetIndex().isEmpty()) {
            return;
        }
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)template.getModelId());
        Table<Map<String, String>, Map<String, String>, Row> table = OffsetLogicImpl.getRowTable(template, positionInfo, rows);
        Table<Map<String, String>, Map<String, String>, Row> autocwptable = null;
        if (autoOffset) {
            autocwptable = OffsetLogicImpl.getOffsetTable(sm, template, positionInfo, basePointInfo, rows, modelNumber);
        }
        Map data = new HashMap(16);
        Map<String, BigDecimal> numberData = new HashMap(16);
        if (ThreadCache.get((Object)OLD_DATA) != null) {
            data = (Map)ObjectSerialUtil.deSerializedBytes((String)ThreadCache.get((Object)OLD_DATA).toString());
            numberData = (Map)data.get("number");
        }
        Map fixMemberPosition = ((BasePointInfo)positionInfo.getBasePoints().get(0)).getFixMemberPosition();
        IRelaMembSupplier periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm((SpreadManager)sm);
        boolean fyIsPV = ReportSpecialVariableUtil.isPageAndViewFilterForFp((SpreadManager)sm, (String)PresetConstant.FY_DIM);
        ArrayList fixkeys = new ArrayList(10);
        positionInfo.getOffsetIndex().stream().forEach(c -> {
            if (fixMemberPosition.get(c) != null) {
                HashMap key = new HashMap(16);
                ((List)fixMemberPosition.get(c)).stream().forEach(d -> {
                    String dimNum = d.getDimension().getNumber();
                    String memNum = d.getNumber();
                    if (Arrays.asList(PresetConstant.PERIOD_DIM, PresetConstant.FY_DIM).contains(dimNum)) {
                        memNum = ReportSpecialVariableUtil.getRealMemNumber((String)dimNum, (String)memNum, (boolean)fyIsPV, (IRelaMembSupplier)periodSupplier);
                    }
                    key.put(dimNum, memNum);
                });
                fixkeys.add(key);
            }
        });
        SaveCommandInfo info = OffsetLogicImpl.getSaveCommandInfo(sm, template.getModelId(), orgId);
        List<String> colandrow = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList());
        colandrow.addAll(((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList()));
        info.addDimensions(colandrow.toArray(new String[0]));
        CellSet cellSets = new CellSet(colandrow.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        HashMap dataMap = new HashMap(16);
        for (Map fixkey : table.rowKeySet()) {
            Map map = table.row((Object)fixkey);
            boolean isNotAllZero = map.entrySet().stream().anyMatch(e -> {
                if (!fixkeys.contains(e.getKey())) {
                    return false;
                }
                try {
                    BigDecimal vv = TypeConversionUtils.objToBigDecimal((Object)((Row)e.getValue()).getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                    if (vv != null && vv.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            });
            if (isNotAllZero) {
                for (Map.Entry r : map.entrySet()) {
                    HashMap map1 = new HashMap(16);
                    map1.putAll(fixkey);
                    map1.putAll((Map)r.getKey());
                    String[] key = new String[colandrow.size()];
                    for (int i = 0; i < colandrow.size(); ++i) {
                        key[i] = (String)map1.get(colandrow.get(i));
                    }
                    cellSets.set(key, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                }
                continue;
            }
            if (!autoOffset) continue;
            for (Map.Entry r : map.entrySet()) {
                BigDecimal vv;
                Row oldautocwp = null;
                if (autocwptable != null) {
                    oldautocwp = (Row)autocwptable.get((Object)fixkey, r.getKey());
                }
                Row nowattotal = (Row)r.getValue();
                rows.remove(nowattotal);
                BigDecimal autocwp = BigDecimal.ZERO;
                BigDecimal total = BigDecimal.ZERO;
                if (oldautocwp != null) {
                    vv = OffsetLogicImpl.getValue(oldautocwp.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                    if (vv == null) continue;
                    autocwp = vv;
                }
                if (nowattotal != null) {
                    vv = OffsetLogicImpl.getValue(nowattotal.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                    if (vv == null) continue;
                    total = vv;
                }
                BigDecimal newValue = BigDecimal.ZERO.subtract(total).add(autocwp);
                dataMap.putAll(fixkey);
                dataMap.putAll((Map)r.getKey());
                String[] key = new String[colandrow.size()];
                for (int i = 0; i < colandrow.size(); ++i) {
                    key[i] = (String)dataMap.get(colandrow.get(i));
                }
                cellSets.set(key, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)newValue);
                numberData.put(OffsetLogicImpl.buildKey(key, colandrow.toArray(new String[0])), newValue);
                dataMap.clear();
            }
        }
        OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)modelNumber, (boolean)true, (boolean)false);
        data.put("number", numberData);
        ThreadCache.put((Object)OLD_DATA, (Object)ObjectSerialUtil.toByteSerialized(data));
        if (beforenum != rows.size()) {
            ThreadCache.put((Object)"cwp", (Object)true);
        }
    }

    private static String buildKey(String[] key, String[] dim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length; ++i) {
            sb.append(dim[i]).append(':').append(key[i]).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static BigDecimal getValue(Object obj) {
        try {
            BigDecimal value = TypeConversionUtils.objToBigDecimal((Object)obj);
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static SaveCommandInfo getSaveCommandInfo(SpreadManager sm, long modelid, long orgId) {
        HashMap nums = new HashMap();
        sm.getFilter().getViewPointDomain().getAllMembers().forEach(n -> nums.put(n.getDimension().getNumber(), n.getNumber()));
        sm.getFilter().getPageDomain().getAllMembers().forEach(n -> nums.put(n.getDimension().getNumber(), n.getNumber()));
        String cur = (String)nums.get(DimTypesEnum.CURRENCY.getNumber());
        if (nums.containsKey(DimTypesEnum.CURRENCY.getNumber()) && nums.containsKey(DimTypesEnum.PROCESS.getNumber()) && nums.containsKey(DimTypesEnum.ENTITY.getNumber())) {
            cur = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelid, (long)orgId, (String)((String)nums.get((Object)DimTypesEnum.PROCESS.getNumber())), (String)((String)nums.get((Object)DimTypesEnum.CURRENCY.getNumber())), (long)0L, (long)0L).p2;
        }
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String finalCur = cur;
        sm.getFilter().getViewPointDomain().getAllMembers().forEach(d -> {
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(d.getDimension().getNumber())) {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), "AutoCWP"});
            } else if (DimTypesEnum.CURRENCY.getNumber().equals(d.getDimension().getNumber()) && SysMembConstant.CurrencyVariable.contains(d.getNumber()) && finalCur != null) {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), finalCur});
            } else {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), d.getNumber()});
            }
        });
        sm.getFilter().getPageDomain().getAllMembers().forEach(d -> {
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(d.getDimension().getNumber())) {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), "AutoCWP"});
            } else if (DimTypesEnum.CURRENCY.getNumber().equals(d.getDimension().getNumber()) && SysMembConstant.CurrencyVariable.contains(d.getNumber()) && finalCur != null) {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), finalCur});
            } else {
                info.addfixedDimension(new String[]{d.getDimension().getNumber(), d.getNumber()});
            }
        });
        return info;
    }

    private static Table<Map<String, String>, Map<String, String>, Row> getOffsetTable(SpreadManager sm, TemplateModel template, PositionInfo positionInfo, BasePointInfo bs, List<Row> rows, String modelNumber) {
        Table<Map<String, String>, Map<String, String>, Row> table = HashBasedTable.create();
        ArrayList pageAndViewDim = new ArrayList(sm.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(sm.getFilter().getViewPointDomain().getDimensions());
        SQLBuilder sql = new SQLBuilder(modelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (IDimension dim : pageAndViewDim) {
            String[] values = new String[dim.getMembers().size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
            }
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dim.getNumber())) {
                sql.addFilter(dim.getNumber(), new String[]{"AutoCWP"});
                continue;
            }
            sql.addFilter(dim.getNumber(), values);
        }
        FloatDataProvider.addFixMemberFilter(sm, bs, sql, template.getModelId());
        ReportPeriodUtil.addSingleDimSpecialSqlFilter(sm, sql, modelNumber, (IRelaMembSupplier<String, String>)ReportSpecialVariableUtil.getPeriodSupplierFromSm((SpreadManager)sm));
        sql.addSelectField(FloatDataProvider.getDimensionNums(template.getModelId()));
        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
        table = OffsetLogicImpl.getRowTable(template, positionInfo, set);
        return table;
    }

    private static Table<Map<String, String>, Map<String, String>, Row> getRowTable(TemplateModel template, PositionInfo positionInfo, List<Row> rows) {
        HashBasedTable table = HashBasedTable.create();
        if (positionInfo.isFloatPosition() && positionInfo.getBasePoints() != null && !positionInfo.getBasePoints().isEmpty()) {
            Pair pair = SpreadMemUtil.getFixAndFloatDimByPositionInfo((PositionInfo)positionInfo);
            Set floatDims = (Set)pair.p2;
            Set fixDims = (Set)pair.p1;
            if (!floatDims.isEmpty()) {
                rows.stream().forEach(arg_0 -> OffsetLogicImpl.lambda$getRowTable$9(floatDims, fixDims, (Table)table, arg_0));
            }
        }
        return table;
    }

    private static Table<Map<String, String>, Map<String, String>, Row> getRowTable(TemplateModel template, PositionInfo positionInfo, MDResultSet set) {
        HashBasedTable table = HashBasedTable.create();
        if (positionInfo.isFloatPosition() && positionInfo.getBasePoints() != null && !positionInfo.getBasePoints().isEmpty()) {
            Pair pair = SpreadMemUtil.getFixAndFloatDimByPositionInfo((PositionInfo)positionInfo);
            Set floatDims = (Set)pair.p2;
            Set fixDims = (Set)pair.p1;
            if (!floatDims.isEmpty()) {
                while (set.next()) {
                    Row r = set.getRow();
                    HashMap<String, String> floatkey = new HashMap<String, String>(floatDims.size());
                    for (String dim : floatDims) {
                        floatkey.put(dim, r.getString(dim));
                    }
                    HashMap<String, String> fixkey = new HashMap<String, String>(fixDims.size());
                    for (String dim : fixDims) {
                        fixkey.put(dim, r.getString(dim));
                    }
                    table.put(floatkey, fixkey, (Object)r);
                }
            }
        }
        return table;
    }

    private static /* synthetic */ void lambda$getRowTable$9(Set floatDims, Set fixDims, Table table, Row r) {
        HashMap<String, String> floatkey = new HashMap<String, String>(floatDims.size());
        for (String dim : floatDims) {
            floatkey.put(dim, r.getString(dim));
        }
        HashMap<String, String> fixkey = new HashMap<String, String>(fixDims.size());
        for (String dim : fixDims) {
            fixkey.put(dim, r.getString(dim));
        }
        table.put(floatkey, fixkey, (Object)r);
    }
}

