/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.template.FloatMaintainPlugin;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.IDimension;

public class PasteFloatplugin
extends FloatMaintainPlugin {
    private static final String NUMBER = "number";
    private static final String MEMBER = "member";
    private static final String MODEL = "model";
    private static final String DIMENSION = "dimension";
    private String EXISTMEMBER = "existmember";
    private String SORT = "sort";
    private String NEWNAME = "newname";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit unfloatmem = (BasedataEdit)this.getControl(MEMBER);
        unfloatmem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String name = (String)this.getFormCustomParam("dinemsionumber");
        this.getModel().setValue(DIMENSION, (Object)name);
        String area = (String)this.getModel().getValue("floatarea");
        Map<String, List<FloatMaintainPlugin.FloatInfo>> map = this.analyseSpeadInfo();
        List<FloatMaintainPlugin.FloatInfo> infos = map.get(area);
        this.refreshDimenInfo(infos, name);
        this.getModel().setValue("dimtype", (Object)this.getPageCache().get(entityname));
    }

    @Override
    protected void refreshEntity() {
        this.getModel().deleteEntryData("entryentity");
        ArrayList<String> existmember = new ArrayList<String>();
        ArrayList<String> nonmember = new ArrayList<String>();
        String dimentity = (String)this.getFormCustomParam("dinemsionrntity");
        String dimnumber = (String)this.getFormCustomParam("dinemsionumber");
        List values = (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("value")));
        boolean isDirectHoriz = (Boolean)this.getView().getFormShowParameter().getCustomParam("isDirectHoriz");
        String indexkey = isDirectHoriz ? "c" : "r";
        HashMap<String, String> sortMap = new HashMap<String, String>();
        ArrayList<String> va = new ArrayList<String>();
        for (LinkedHashMap map : values) {
            if (map.get("v") == null) continue;
            String value = map.get("v").toString();
            va.add(value);
            sortMap.put(map.get(indexkey).toString(), value);
        }
        SpreadManager spreadManager = this.getSpreadModelFromSerial(this.getPageCache().get(spreadCache));
        MultiAreaPositionsManager pm = spreadManager.getAreaManager();
        BasePointInnerLineInfo bs = this.getInnerInfo();
        List<String> newva = FloatLogicImpl.getExistMems(dimentity, dimnumber, this.getResult(), va.toArray(new String[0]));
        for (LinkedHashMap map : values) {
            if (map.get("v") == null) continue;
            String value = map.get("v").toString();
            if (newva.contains(value)) {
                existmember.add(value);
                continue;
            }
            if (nonmember.contains(value)) continue;
            nonmember.add(value);
        }
        if ("bcm_userdefinedmembertree".equalsIgnoreCase(dimentity)) {
            Long realParent = FloatLogicImpl.getRealParent(this.getModelId(), dimentity, dimnumber, bs.getMemberAddOf().getNumber(), bs.getAddPositionEnum());
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"name", (QFilter[])new QFilter[]{new QFilter("name", "in", nonmember), new QFilter("parent.id", "=", (Object)realParent), new QFilter("dimension.number", "=", (Object)dimnumber)});
            dys.stream().forEach(dy -> nonmember.remove(dy.getString("name")));
        }
        nonmember.addAll(this.checkNum(existmember));
        this.refreshEntity(nonmember);
        this.getPageCache().put(this.EXISTMEMBER, SerializationUtils.toJsonString(existmember));
        this.getPageCache().put(this.SORT, SerializationUtils.toJsonString(sortMap));
    }

    private List<String> checkNum(List<String> existmember) {
        ArrayList<String> nonmember = new ArrayList<String>();
        Map<String, Set<String>> scope = this.getScope();
        Map<String, Map<String, Map<String, String>>> result = this.getResult();
        BasePointInnerLineInfo inner = this.getInnerInfo();
        if (inner == null) {
            return nonmember;
        }
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name,number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(NUMBER, "=", (Object)inner.getDimension().getNumber())});
        IDimension dimension = ObjectConvertUtils.toIDimension(dimObj);
        for (int i = 0; i < existmember.size(); ++i) {
            String number = existmember.get(i);
            boolean isValidate = FloatLogicImpl.buildDimMemberGroupByMap(result, scope, dimension.getNumber(), number, null, this.getModelId(), inner, nonmember);
            if (!isValidate) {
                existmember.set(i, null);
                continue;
            }
            if (!"bcm_userdefinedmembertree".equalsIgnoreCase(DimEntityNumEnum.getEntieyNumByNumber((String)dimension.getNumber()))) continue;
            existmember.set(i, number);
        }
        this.getView().getFormShowParameter().setCustomParam("scope", (Object)this.toByteSerialized(scope));
        this.getView().cacheFormShowParameter();
        return nonmember;
    }

    private Map<String, Set<String>> getScope() {
        Map<String, Set<String>> map = new HashMap<String, Set<String>>();
        String sc = (String)this.getFormCustomParam("scope");
        if (StringUtils.isNotEmpty((CharSequence)sc)) {
            map = (Map)this.deSerializedBytes(sc);
        }
        return map;
    }

    private Map<String, Map<String, Map<String, String>>> getResult() {
        Map<String, Map<String, Map<String, String>>> map = new HashMap<String, Map<String, Map<String, String>>>();
        String sc = (String)this.getFormCustomParam("result");
        if (StringUtils.isNotEmpty((CharSequence)sc)) {
            map = (Map)SerializationUtils.fromJsonString((String)sc, Map.class);
        }
        return map;
    }

    private BasePointInnerLineInfo getInnerInfo() {
        String sc = (String)this.getFormCustomParam("innerinfo");
        BasePointInnerLineInfo inner = null;
        if (StringUtils.isNotEmpty((CharSequence)sc)) {
            inner = (BasePointInnerLineInfo)this.deSerializedBytes(sc);
        }
        return inner;
    }

    protected void refreshEntity(List<String> nonmember) {
        long dimId = Long.parseLong(this.getPageCache().get(dimenmemberid));
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)dimId, (String)this.getPageCache().get(entityname));
        member.set("createtime", (Object)TimeServiceHelper.now());
        String[] numbers = CodeRuleUtil.getDimensionNumber(this.getPageCache().get(entityname), member, nonmember.size());
        int i = 0;
        for (String name : nonmember) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("name", (Object)name, row);
            String uid = RequestContext.getOrCreate().getUserId();
            Date now = TimeServiceHelper.now();
            this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"name"});
            String number = numbers[i];
            ++i;
            this.getModel().setValue(NUMBER, (Object)number, row);
            this.getModel().setValue("createrfield", (Object)uid, row);
            this.getModel().setValue("createdatefield", (Object)now, row);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btn_save".equals(key)) {
            this.dealMember();
        } else if ("btn_cancel".equals(key)) {
            // empty if block
        }
    }

    private void dealMember() {
        if (this.checkEntity()) {
            List existmember = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.EXISTMEMBER), List.class);
            DynamicObjectCollection rateColl = this.getModel().getEntryEntity("entryentity");
            LinkedHashMap<String, String> newMember = new LinkedHashMap<String, String>();
            HashMap<String, String> newnamesign = new HashMap<String, String>();
            for (DynamicObject obj : rateColl) {
                String deal;
                switch (deal = obj.getString("deal")) {
                    case "1": {
                        newMember.put(obj.getString(NUMBER), obj.getString("name"));
                        existmember.add(obj.getString(NUMBER));
                        break;
                    }
                    case "2": {
                        DynamicObject mem = (DynamicObject)obj.get(MEMBER);
                        String number = mem.getString(NUMBER);
                        existmember.add(number);
                        String oraname = obj.getString("name");
                        newnamesign.put(oraname, number);
                        break;
                    }
                }
            }
            if (newMember.size() > 0 && !this.checkEbAddNewPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u4e0a\u7ea7\u6210\u5458\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"PasteFloatplugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveMember(newMember);
            this.getPageCache().put(this.EXISTMEMBER, SerializationUtils.toJsonString((Object)existmember));
            this.getPageCache().put(this.NEWNAME, SerializationUtils.toJsonString(newnamesign));
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u6709\u6210\u5458\u3002", (String)"PasteFloatplugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkEbAddNewPerm() {
        return true;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormView view = (FormView)e.getSource();
        String entity = this.getPageCache().get(entityname);
        List existmember = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.EXISTMEMBER), List.class);
        Map sort = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.SORT), Map.class);
        Map namesign = new HashMap();
        if (this.getPageCache().get(this.NEWNAME) != null) {
            namesign = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.NEWNAME), Map.class);
        }
        String selectid = this.getPageCache().get(dimenmemberid);
        long parentid = this.getParent(selectid);
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        qf.add(new QFilter("dimension.number", "=", (Object)this.getPageCache().get(dimensionnumber)));
        qf.add(new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentid)));
        qf.add(new QFilter("name", "in", (Object)existmember.toArray()).or(new QFilter(NUMBER, "in", (Object)existmember.toArray())));
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entity, (String)"id,number,name", (QFilter[])qf.toArray());
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DynamicObject oo : ids) {
            map.put(oo.getString("name"), oo.getLong("id"));
            map.put(oo.getString(NUMBER), oo.getLong("id"));
        }
        ListSelectedRowCollection li = new ListSelectedRowCollection();
        for (Map.Entry entry : sort.entrySet()) {
            Long id;
            String name = (String)entry.getValue();
            String nameStr = (String)namesign.get(name);
            if (!StringUtil.isEmptyString((String)nameStr)) {
                name = nameStr;
            }
            if ((id = (Long)map.get(name)) == null) continue;
            ListSelectedRow lr = new ListSelectedRow((Object)id);
            lr.setRowKey(Integer.parseInt((String)entry.getKey()));
            li.add((Object)lr);
        }
        view.returnDataToParent((Object)li);
    }

    private void saveMember(Map<String, String> member) {
        String cs1;
        if (member.isEmpty()) {
            return;
        }
        String modelNum = QueryDimensionServiceHelper.getModelNumber((long)this.getModelId());
        String selectid = this.getPageCache().get(dimenmemberid);
        long parentid = this.getParent(selectid);
        String entity = this.getPageCache().get(entityname);
        String membertable = entity.contains(cs1 = "icmembertree") ? "bcm_intercompanymember" : entity.substring(0, entity.length() - 4);
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)entity);
        if (parent.getBoolean("isleaf")) {
            parent.set("isleaf", (Object)0);
        }
        int seq = QueryDimensionServiceHelper.getMaxDSeq((long)parentid, (String)entity);
        Object[] nones = new DynamicObject[member.size()];
        Object[] noneTrees = new DynamicObject[member.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : member.entrySet()) {
            String number = entry.getKey();
            String name = entry.getValue();
            DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)none);
            none.set(NUMBER, (Object)number);
            none.set("name", (Object)name);
            none.set(MODEL, parent.get(MODEL));
            none.set(DIMENSION, parent.get(DIMENSION));
            nones[i] = none;
            DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)entity);
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)noneTree);
            noneTree.set(MODEL, parent.get(MODEL));
            noneTree.set(DIMENSION, parent.get(DIMENSION));
            noneTree.set("level", (Object)String.valueOf((Integer)parent.get("level") + 1));
            noneTree.set(MEMBER, (Object)none);
            noneTree.set("parent", (Object)parentid);
            noneTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
            if ("bcm_userdefinedmembertree".equals(entity)) {
                noneTree.set("datatype", (Object)"0");
            }
            if (String.valueOf(parentid).equals(selectid)) {
                noneTree.set("addtext", (Object)"baritemaddsub");
            } else {
                noneTree.set("addtext", (Object)"");
            }
            noneTree.set("aggoprt", (Object)"1");
            noneTree.set("isleaf", (Object)true);
            noneTree.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
            noneTree.set(NUMBER, (Object)number);
            noneTree.set("name", (Object)name);
            noneTree.set("issysmember", (Object)5);
            noneTree.set("dseq", (Object)(++seq));
            noneTrees[i] = noneTree;
            ++i;
        }
        DynamicObject dimesion = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(NUMBER, "=", (Object)this.getPageCache().get(dimensionnumber))});
        try (TXHandle th = TX.requiresNew();){
            try {
                int size = ((HashMap)member).size();
                ArrayList numbers = new ArrayList(size);
                for (Map.Entry entry : member.entrySet()) {
                    numbers.add(entry.getKey());
                }
                QFilter[] qFilters = new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(DIMENSION, "=", dimesion.get("id")), new QFilter(NUMBER, "in", numbers)};
                if (QueryServiceHelper.exists((String)entity, (QFilter[])qFilters)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PasteFloatplugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)membertable).getDynamicObjectType(), (Object[])nones);
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entity).getDynamicObjectType(), (Object[])noneTrees);
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])new DynamicObject[]{parent});
                ArrayList<Tuple> arrayList = new ArrayList<Tuple>(noneTrees.length);
                for (Object treeMember : noneTrees) {
                    arrayList.add(Tuple.create((Object)treeMember.getString(NUMBER), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimesion.getString(NUMBER)), (Object)treeMember.get("parent"))));
                }
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimesion.getString(NUMBER), arrayList);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        if (member.size() > 0) {
            SaveDimMemberHelper.saveLog(Arrays.asList(noneTrees), (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.NEW);
        }
    }

    private boolean checkEntity() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject obj : rateColl) {
            String deal = obj.getString("deal");
            if (!"2".equals(deal) || obj.get(MEMBER) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String fuzzy = this.getPageCache().get("fuzzy");
        if (arg0.getFormShowParameter().getCloseCallBack() != null) {
            boolean isLookUpList = "setItemByNumber".equals(arg0.getSourceMethod());
            if (!"true".equals(fuzzy) && !isLookUpList) {
                arg0.setCancel(true);
                this.showSingleF7(bs.getKey());
            }
            this.getPageCache().put("fuzzy", "false");
        } else {
            this.getPageCache().put("fuzzy", "true");
            if (!"true".equals(fuzzy)) {
                EntryGrid eg = (EntryGrid)this.getControl("entryentity");
                QFilter filter = null;
                String dimNum = this.getModel().getValue(DIMENSION).toString();
                QFilter numberFilter = new QFilter(NUMBER, "=", (Object)dimNum);
                DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), numberFilter});
                if (filter == null) {
                    filter = new QFilter(DIMENSION, "=", dimObj.get("id"));
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(filter);
                showParameter.setListFilterParameter(new ListFilterParameter(qFilters, (String)null));
            }
        }
    }

    private void showSingleF7(String key) {
        String dimNum = this.getModel().getValue(DIMENSION).toString();
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)dimNum);
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), numberFilter});
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), key, null, true, SingleF7TypeEnum.COMMON);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"PasteFloatplugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        f7.setCallBackClassName(this.getClass().getName());
        f7.setStatus(OperationStatus.EDIT);
        f7.click();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (MEMBER.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            this.getModel().setValue(actionId, result.get("id"), eg.getSelectRows()[0]);
        }
    }
}

