/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import org.apache.commons.lang3.StringUtils;

public class ReportOPValidator {
    public static boolean validateFloatMemberInput(SpreadManager sm) {
        Sheet sheet = sm.getBook().getSheet(0);
        Predicate<Cell> testHasValue = cell -> cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty();
        Predicate<Map> testHasNullValue = m -> m.values().contains(null);
        for (PositionInfo positionInfo : sm.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePoint : positionInfo.getBasePoints()) {
                RangeModel baseRangeModel = new RangeModel(basePoint.getDynaRange());
                int startIndex = basePoint.isDirectHoriz() ? baseRangeModel.getX_start() : baseRangeModel.getY_start();
                int endIndex = basePoint.isDirectHoriz() ? baseRangeModel.getX_end() : baseRangeModel.getY_end();
                int rangeStartIndex = basePoint.isDirectHoriz() ? baseRangeModel.getY_start() : baseRangeModel.getX_start();
                for (int i = startIndex; i <= endIndex; ++i) {
                    boolean isAllFloatBlank = true;
                    boolean ishasFloatBlank = false;
                    HashMap<String, String> loopRCs = new HashMap<String, String>(16);
                    for (BasePointInnerLineInfo basePointInnerLineInfo : basePoint.getBasePointInnerLineInfo()) {
                        Cell cell2;
                        int offset;
                        if (!basePointInnerLineInfo.isFloated() || basePointInnerLineInfo.isSeq() || (offset = basePointInnerLineInfo.getOffset()) < 0) continue;
                        int index = rangeStartIndex + offset;
                        Cell cell3 = cell2 = basePoint.isDirectHoriz() ? sheet.getCell(index, i) : sheet.getCell(i, index);
                        if (DimTypesEnum.MYCOMPANY.getNumber().equals(basePointInnerLineInfo.getDimension().getNumber()) && StringUtils.isNotEmpty((CharSequence)basePointInnerLineInfo.getNumberfrom())) {
                            loopRCs.put(basePointInnerLineInfo.getDimension().getNumber(), "1");
                            continue;
                        }
                        if (!testHasValue.test(cell2)) {
                            isAllFloatBlank = false;
                            loopRCs.put(basePointInnerLineInfo.getDimension().getNumber(), null);
                            continue;
                        }
                        loopRCs.put(basePointInnerLineInfo.getDimension().getNumber(), "1");
                        ishasFloatBlank = true;
                    }
                    if (!ishasFloatBlank || isAllFloatBlank || !testHasNullValue.test(loopRCs)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

