/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.floatreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class SeqLogicImpl {
    private static final int seqfirstindex = 1000000;
    public static final String ORGCACHESIGN = "orgnum";
    protected SpreadManager spread;
    protected String dimnumber;
    protected List<String> seqnumbers = new ArrayList<String>(10);
    protected boolean isH;
    private long modelId;
    private String parentNum;
    private Map<String, String> seqnumberToNames = new LinkedHashMap<String, String>();
    private boolean isOrgWithSeq = false;

    public List<String> getSeqnumbers() {
        return this.seqnumbers;
    }

    public String getDimnumber() {
        return this.dimnumber;
    }

    public SeqLogicImpl(SpreadManager spread, long modelId, boolean isH) {
        this(spread, modelId, isH, null);
    }

    public SeqLogicImpl(SpreadManager spread, long modelId, boolean isH, String orgNum) {
        this.isH = isH;
        this.isOrgWithSeq = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_JOINORG_TOSEQ.getNumber());
        this.spread = spread;
        String membernumber = null;
        block0: for (PositionInfo ps : spread.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo bs : ps.getBasePoints()) {
                for (BasePointInnerLineInfo line : bs.getBasePointInnerLineInfo()) {
                    if (!line.isSeq()) continue;
                    this.dimnumber = line.getDimension().getNumber();
                    membernumber = ((DynaMembScopeInfo)line.getDynaMembScopes().get(0)).getMember().getNumber();
                    break block0;
                }
            }
        }
        if (orgNum != null) {
            this.modelId = modelId;
            if (StringUtils.isNotEmpty(membernumber)) {
                this.parentNum = membernumber;
            }
        }
        if (StringUtils.isNotEmpty(membernumber)) {
            QFBuilder qb = new QFBuilder();
            qb.add(new QFilter("model", "=", (Object)modelId));
            qb.and(new QFilter("dimension.number", "=", (Object)this.dimnumber));
            qb.and(new QFilter("parent.number", "=", membernumber));
            qb.and(new QFilter("issysmember", "!=", (Object)DimMemTypeEnum.ORGSEQMEMBER.getIndex()));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number,name,dseq", (QFilter[])qb.toArray(), (String)"dseq");
            if (doc != null && !doc.isEmpty()) {
                this.seqnumbers = new ArrayList<String>(doc.size());
                for (DynamicObject obj : doc) {
                    if (this.isOrgWithSeq && orgNum != null) {
                        String number = orgNum + "_" + obj.getString("number");
                        String name = orgNum + "_" + obj.getString("name");
                        this.seqnumbers.add(number);
                        this.seqnumberToNames.put(number, name);
                        continue;
                    }
                    this.seqnumbers.add(obj.getString("number"));
                }
            }
        }
    }

    public SeqLogicImpl(BasePointInfo bs) {
        for (BasePointInnerLineInfo line : bs.getBasePointInnerLineInfo()) {
            if (!line.isSeq()) continue;
            this.dimnumber = line.getDimension().getNumber();
            break;
        }
    }

    public boolean fillBackSeq() {
        HashMap<Integer, DimMember> dimmap = new HashMap<Integer, DimMember>(16);
        if (!this.seqnumbers.isEmpty()) {
            this.spread.getAreaManager().getPostionInfoSet().forEach(p -> p.getBasePoints().forEach(b -> b.reCollectUsedSeq(this.spread)));
            Sheet sheet = this.spread.getBook().getSheet(0);
            for (int row = 0; row < sheet.getMaxRowCount(); ++row) {
                for (int col = 0; col < sheet.getMaxColumnCount(); ++col) {
                    DimMember mem;
                    int memindex;
                    Cell cell = sheet.getCell(row, col);
                    if (cell.getUserObject("needseq") == null) continue;
                    BasePointInfo bs = TemplateFloatUtil.getBasePointInfoByMdCell(this.spread, cell.getRow(), cell.getCol(), this.isH);
                    String key = SeqLogicImpl.getFloatKey(bs, cell);
                    int n = memindex = this.isH ? cell.getCol() : cell.getRow();
                    if (dimmap.get(memindex) != null) {
                        mem = (DimMember)dimmap.get(memindex);
                    } else {
                        String curMemberNumber = this.getCurSeq(bs, key);
                        if (curMemberNumber == null) {
                            return false;
                        }
                        mem = new DimMember(null, curMemberNumber, null, (IDimension)new Dimension(null, this.dimnumber, null));
                        dimmap.put(memindex, mem);
                        this.fillbackTuple(cell, mem);
                        this.fillBackseqObj(bs, mem, cell);
                        bs.setUsedSeq(key, mem.getNumber());
                    }
                    List mems = cell.getMemberFromUserObject();
                    for (int i = 0; i < mems.size(); ++i) {
                        IDimMember m = (IDimMember)mems.get(i);
                        if (!this.dimnumber.equals(m.getDimension().getNumber())) continue;
                        int midex = mems.indexOf(m);
                        mems.remove(m);
                        mems.add(midex, mem);
                        break;
                    }
                    cell.removeUserObject("needseq");
                }
            }
            if (this.isOrgWithSeq) {
                this.createMember();
            }
            return true;
        }
        return false;
    }

    private void fillbackTuple(Cell cell, DimMember mem) {
        String point = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
        PositionInfo pInfo = TemplateFloatUtil.getPositionInfobyCell(this.spread, point);
        Tuple randc = this.spread.getAreaManager().getRowAndColDomainByPosition(pInfo);
        List dimlist = !this.isH ? ((RowDimDomain)randc.k).getDimensions() : ((ColumnDimDomain)randc.v).getDimensions();
        boolean iscon = false;
        for (IDimension dim : dimlist) {
            if (!dim.getNumber().equals(mem.getDimension().getNumber())) continue;
            dim.addMember((IDimMember)mem);
            iscon = true;
            break;
        }
        if (!iscon) {
            Dimension dim = new Dimension(mem.getDimension().getName(), mem.getDimension().getNumber(), mem.getDimension().getUqCode());
            dim.addMember((IDimMember)mem);
            dimlist.add(dim);
        }
    }

    private String getCurSeq(BasePointInfo bs, String key) {
        Map usedMap = bs.getUsedSeq();
        List usedset = (List)usedMap.get(key);
        if (usedset != null) {
            int usedSetSize = usedset.size();
            if (usedSetSize < this.seqnumbers.size() && !usedset.contains(this.seqnumbers.get(usedSetSize))) {
                boolean allMatch = true;
                for (int i = 0; i < usedset.size(); ++i) {
                    if (((String)usedset.get(i)).equals(this.seqnumbers.get(i))) continue;
                    allMatch = false;
                    break;
                }
                if (allMatch) {
                    return this.seqnumbers.get(usedSetSize);
                }
            }
            for (String s : this.seqnumbers) {
                if (usedset.contains(s)) continue;
                return s;
            }
            return null;
        }
        if (!this.seqnumbers.isEmpty()) {
            return this.seqnumbers.get(0);
        }
        return null;
    }

    private void fillBackseqObj(BasePointInfo bs, DimMember mem, Cell cell) {
        int x = 0;
        int y = 0;
        String range = bs.getDynaRange();
        if (this.isH) {
            y = ExcelUtils.pos2Y((String)range.split(":")[0]);
            x = cell.getCol();
        } else {
            y = cell.getRow();
            x = ExcelUtils.pos2X((String)range.split(":")[0]);
        }
        this.spread.getBook().getSheet(0).getCell(y, x).setUserObject("seqobject", (Object)mem);
    }

    public static DimMember getFirstSeqMem(long modelId) {
        String orgnum = (String)ThreadCache.get((Object)ORGCACHESIGN, () -> null);
        return SeqLogicImpl.getFirstSeqMem(modelId, orgnum);
    }

    public static DimMember getFirstSeqMem(long modelId, String orgNum) {
        DimMember member = (DimMember)ThreadCache.get((Object)("dimmember_" + modelId));
        if (member != null) {
            return member;
        }
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("model", "=", (Object)modelId));
        qb.add(new QFilter("isseq", "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"id,dimension.number,number", (QFilter[])qb.toArray());
        if (doc != null && !doc.isEmpty()) {
            if (doc.size() == 1) {
                qb = new QFBuilder();
                qb.add(new QFilter("model", "=", (Object)modelId));
                qb.and(new QFilter("parent", "=", ((DynamicObject)doc.get(0)).get("id")));
                qb.and(new QFilter("dseq", "=", (Object)1));
                DynamicObject first = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"id,dimension.number,dimension.name,number,name", (QFilter[])qb.toArray());
                if (first != null) {
                    String dimnum = first.getString("dimension.number");
                    String memnum = first.getString("number");
                    String dimname = first.getString("dimension.name");
                    String memname = first.getString("name");
                    if (ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_JOINORG_TOSEQ.getNumber()) && orgNum != null) {
                        memnum = orgNum + "_" + memnum;
                        memname = orgNum + "_" + memname;
                    }
                    Dimension dim = new Dimension(dimname, dimnum, null);
                    member = new DimMember(memname, memnum, null, (IDimension)dim);
                    member.setId(first.getLong("id"));
                    ThreadCache.put((Object)("dimmember_" + modelId), (Object)member);
                    return member;
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u5e8f\u53f7\u7684\u6210\u5458\u4e0d\u552f\u4e00\u3002", (String)"SeqLogicImpl_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5e8f\u53f7\u6210\u5458\u3002", (String)"SeqLogicImpl_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static DimMember getParentSeqMem(long modelId) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("model", "=", (Object)modelId));
        qb.add(new QFilter("isseq", "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"id,dimension.number,dimension.name,number,name", (QFilter[])qb.toArray());
        if (doc != null && !doc.isEmpty()) {
            if (doc.size() == 1) {
                DynamicObject first = (DynamicObject)doc.get(0);
                String dimnum = first.getString("dimension.number");
                String memnum = first.getString("number");
                String dimname = first.getString("dimension.name");
                String memname = first.getString("name");
                Dimension dim = new Dimension(dimname, dimnum, null);
                DimMember member = new DimMember(memname, memnum, null, (IDimension)dim);
                member.setId(first.getLong("id"));
                return member;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u5e8f\u53f7\u7684\u6210\u5458\u4e0d\u552f\u4e00\u3002", (String)"SeqLogicImpl_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5e8f\u53f7\u6210\u5458\u3002", (String)"SeqLogicImpl_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public static void cleanseq(SpreadManager sp, Cell cell, boolean isH) {
        TemplateFloatUtil.getBasePointInfoByMdCell(sp, cell.getRow(), cell.getCol(), isH);
    }

    public static String getFloatKey(BasePointInfo bs, Cell cell) {
        return BasePointInfo.getFloatKey((BasePointInfo)bs, (List)cell.getMemberFromUserObject());
    }

    private void createMember() {
        long parentid = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)this.dimnumber, (String)this.parentNum).getId();
        HashSet seqNums = new HashSet();
        for (PositionInfo positionInfo : this.spread.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo bs : positionInfo.getBasePoints()) {
                Map usedMap = bs.getUsedSeq();
                if (usedMap.size() <= 0) continue;
                usedMap.values().forEach(seqNums::addAll);
            }
        }
        if (!seqNums.isEmpty()) {
            QFBuilder qb = new QFBuilder();
            qb.add(new QFilter("model", "=", (Object)this.modelId));
            qb.and(new QFilter("parent", "=", (Object)parentid));
            qb.and(new QFilter("number", "in", seqNums));
            TXHandle tx = TX.required((String)("checkseqnum" + this.modelId + this.dimnumber));
            Object object = null;
            try {
                try {
                    DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number", (QFilter[])qb.toArray());
                    if (doc != null && !doc.isEmpty()) {
                        doc.forEach(o -> seqNums.remove(o.getString("number")));
                    }
                    HashMap<String, String> member = new HashMap<String, String>();
                    seqNums.forEach(n -> member.put((String)n, this.seqnumberToNames.get(n)));
                    this.saveMember(this.modelId, member, parentid);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    private void saveMember(Long modelId, Map<String, String> member, Long parentid) {
        int seq;
        DynamicObject dimDyo = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)this.dimnumber)});
        String membertable = "bcm_userdefinedmember";
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)"bcm_userdefinedmembertree");
        if (parent.getBoolean("isleaf")) {
            parent.set("isleaf", (Object)0);
        }
        if ((seq = QueryDimensionServiceHelper.getMaxDSeq((long)parentid, (String)"bcm_userdefinedmembertree")) < 1000000) {
            seq = 1000000;
        }
        Object[] nones = new DynamicObject[member.size()];
        Object[] noneTrees = new DynamicObject[member.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : member.entrySet()) {
            String number = entry.getKey();
            String name = entry.getValue();
            DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)none);
            none.set("number", (Object)number);
            none.set("name", (Object)name);
            none.set("model", parent.get("model"));
            none.set("dimension", parent.get("dimension"));
            nones[i] = none;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)dynamicObject);
            dynamicObject.set("model", parent.get("model"));
            dynamicObject.set("dimension", parent.get("dimension"));
            dynamicObject.set("level", (Object)String.valueOf((Integer)parent.get("level") + 1));
            dynamicObject.set("member", (Object)none);
            dynamicObject.set("parent", (Object)parentid);
            dynamicObject.set("storagetype", (Object)StorageTypeEnum.UNSHARE.getOIndex());
            dynamicObject.set("datatype", (Object)"0");
            dynamicObject.set("aggoprt", (Object)"1");
            dynamicObject.set("isleaf", (Object)true);
            dynamicObject.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("issysmember", (Object)DimMemTypeEnum.ORGSEQMEMBER.getIndex());
            dynamicObject.set("dseq", (Object)(++seq));
            noneTrees[i] = dynamicObject;
            ++i;
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                int size = member.size();
                ArrayList numbers = new ArrayList(size);
                for (Map.Entry entry : member.entrySet()) {
                    numbers.add(entry.getKey());
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension", "=", (Object)dimDyo.getLong("id")), new QFilter("number", "in", numbers)};
                if (QueryServiceHelper.exists((String)"bcm_userdefinedmembertree", (QFilter[])qFilters)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PasteFloatplugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)membertable).getDynamicObjectType(), (Object[])nones);
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree").getDynamicObjectType(), (Object[])noneTrees);
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])new DynamicObject[]{parent});
                ArrayList<kd.fi.bcm.common.Tuple> arrayList = new ArrayList<kd.fi.bcm.common.Tuple>(noneTrees.length);
                for (Object treeMember : noneTrees) {
                    arrayList.add(kd.fi.bcm.common.Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimDyo.getString("number")), (Object)treeMember.get("parent"))));
                }
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)dimDyo.getString("number"), arrayList);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

