/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections4.CollectionUtils;

public class ReportFormulaUtil {
    public static final String MEMBER_GROUP_CELL = "getMemberGroupCells";
    public static final Pattern FIX_COL = Pattern.compile("^\\$[a-zA-Z]");
    public static final Pattern FIX_ROW = Pattern.compile("\\$[0-9]");
    public static final List<String> specialFormulas = Collections.singletonList("getjlentry");
    public static final Integer GETTJENTRYPARAMINDEX = 2;

    public static String getCellFormula(Cell cell, long modelId, long orgId, long tmpId) {
        if (cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty()) {
            return null;
        }
        StringBuilder dimKey = new StringBuilder();
        StringBuilder membKey = new StringBuilder();
        if (cell.getMemberFromUserObject() != null) {
            cell.getMemberFromUserObject().forEach(m -> {
                if (StringUtils.isNotEmpty((String)((DimMember)m).getOriNumber())) {
                    membKey.append(((DimMember)m).getOriNumber()).append('|');
                } else {
                    membKey.append(m.getNumber()).append('|');
                }
                dimKey.append(m.getDimension().getNumber()).append('|');
            });
        }
        List orgparent = IntergrationUtil.getOrgParentNodeList((String)String.valueOf(modelId), (String)String.valueOf(orgId));
        orgparent.add("0");
        HashMap acctmap = new HashMap();
        QFilter qf1 = QFilter.of((String)"template= ? and dimkey=? and membkey=?", (Object[])new Object[]{tmpId, dimKey.toString(), membKey.toString()});
        QFilter qf2 = new QFilter("org", "in", (Object)orgparent);
        DynamicObjectCollection allRules = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)"id,dimkey,membkey,org.id,floatarea,floatindex,datafrom", (QFilter[])new QFilter[]{qf1, qf2});
        Map org2Rules = IntergrationUtil.classRulesByOrg((DynamicObjectCollection)allRules);
        for (String orgnode : orgparent) {
            List rules = (List)org2Rules.get(orgnode);
            if (rules == null) continue;
            for (DynamicObject dot : rules) {
                IntergrationUtil.addRulesObjToMap(acctmap, (DynamicObject)dot);
            }
        }
        if (acctmap.size() != 0) {
            String formula = ((DynamicObject)acctmap.values().iterator().next()).getString("datafrom");
            if (formula.startsWith("=")) {
                formula = formula.substring(1);
            }
            return formula;
        }
        return null;
    }

    public static void collectOriginFloatFormula(SpreadManager spreadModel) {
        for (PositionInfo positionInfo : spreadModel.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                String[] range = positionInfo.getAreaRange().split(":");
                String[] floatRange = basePointInfo.getDynaRange().split(":");
                Point start = ExcelUtils.pos2Point((String)range[0]);
                Point end = ExcelUtils.pos2Point((String)range[1]);
                Point floatStart = ExcelUtils.pos2Point((String)floatRange[0]);
                boolean directHoriz = basePointInfo.isDirectHoriz();
                Sheet sheet = spreadModel.getBook().getSheet(0);
                if (directHoriz) {
                    ReportFormulaUtil.collectOriginFormulaForCell(start.y, end.y, floatStart.x, sheet, directHoriz, basePointInfo);
                    continue;
                }
                ReportFormulaUtil.collectOriginFormulaForCell(start.x, end.x, floatStart.y, sheet, directHoriz, basePointInfo);
            }
        }
    }

    private static void collectOriginFormulaForCell(int direcStart, int direcEnd, int floatStart, Sheet sheet, boolean directHoriz, BasePointInfo basePointInfo) {
        Map originFormulaByCellPosition = basePointInfo.getOriginFormulaByCellPosition();
        for (int j = direcStart; j <= direcEnd; ++j) {
            Cell cell;
            Cell cell2 = cell = directHoriz ? sheet.getCell(j, floatStart) : sheet.getCell(floatStart, j);
            if (!cell.hasFormula() || originFormulaByCellPosition.containsKey(j)) continue;
            originFormulaByCellPosition.put(j, cell.getFormula());
        }
    }

    public static List<Map> copyExcel(SpreadManager spreadModel, IClientViewProxy view, String spreadKey) {
        ArrayList<Map> formulas = new ArrayList<Map>(16);
        for (PositionInfo positionInfo : spreadModel.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                String[] range = positionInfo.getAreaRange().split(":");
                String[] floatRange = basePointInfo.getDynaRange().split(":");
                Point start = ExcelUtils.pos2Point((String)range[0]);
                Point end = ExcelUtils.pos2Point((String)range[1]);
                Point floatStart = ExcelUtils.pos2Point((String)floatRange[0]);
                Point floatEnd = ExcelUtils.pos2Point((String)floatRange[1]);
                String[] originalRange = basePointInfo.getOriginalDynaRange().split(":");
                Point originFloatStart = ExcelUtils.pos2Point((String)originalRange[0]);
                boolean directHoriz = basePointInfo.isDirectHoriz();
                Sheet sheet = spreadModel.getBook().getSheet(0);
                if (directHoriz) {
                    formulas.addAll(ReportFormulaUtil.addExcel(start.y, end.y, floatStart.x, floatEnd.x, sheet, directHoriz, originFloatStart.x, basePointInfo));
                    continue;
                }
                formulas.addAll(ReportFormulaUtil.addExcel(start.x, end.x, floatStart.y, floatEnd.y, sheet, directHoriz, originFloatStart.y, basePointInfo));
            }
        }
        if (view != null && CollectionUtils.isNotEmpty(formulas)) {
            SpreadClientInvoker.invokeSetFormulaMethod(view, spreadKey, formulas);
        }
        return formulas;
    }

    private static List<Map> addExcel(int direcStart, int direcEnd, int floatStart, int floatEnd, Sheet sheet, boolean directHoriz, int originStart, BasePointInfo basePointInfo) {
        List excelNotSupportFormulas = FormulaRegister.getExcelNotSupportFormulas();
        ArrayList<Map> formulas = new ArrayList<Map>(16);
        Map originFormulaByCellPosition = basePointInfo.getOriginFormulaByCellPosition();
        for (int j = direcStart; j <= direcEnd; ++j) {
            int i;
            Cell cell = directHoriz ? sheet.getCell(j, floatStart) : sheet.getCell(floatStart, j);
            AtomicBoolean onlyExcel = new AtomicBoolean(true);
            if (!cell.hasFormula() && !originFormulaByCellPosition.containsKey(j)) continue;
            Expression ex = null;
            String formula = cell.getFormula();
            try {
                Object originFormula = originFormulaByCellPosition.get(j);
                if (originFormula != null) {
                    formula = originFormula.toString();
                    cell.setFormula(formula);
                }
                ex = ExcelFormulaPaserHelper.parse((String)formula);
                ReportFormulaUtil.isOnlyExcel(excelNotSupportFormulas, onlyExcel, ex);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"%1s\u5355\u5143\u683c\u201c%2s\u201d\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff1a\u201c%3s\u201d\u3002", (String)"ReportFormulaUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(msg, cell.getExcelAxis(), formula, e));
            }
            if (!onlyExcel.get()) continue;
            AtomicBoolean hasRef = new AtomicBoolean(false);
            ArrayList<ReferenceExpr> refParamList = new ArrayList<ReferenceExpr>();
            HashMap<AreaExpr, Pair<Boolean, Boolean>> areaParamListMap = new HashMap<AreaExpr, Pair<Boolean, Boolean>>(10);
            ArrayList<FunctionExpr> specialFormulas = new ArrayList<FunctionExpr>();
            ExcelFormulaPaserHelper.walk((Expression)ex, exp -> ReportFormulaUtil.collectRefParam(exp, refParamList, areaParamListMap, hasRef, directHoriz, specialFormulas));
            int insert = floatStart - originStart;
            HashMap<Integer, Pair<Integer, List<Object>>> specialParameters = new HashMap<Integer, Pair<Integer, List<Object>>>(5);
            for (i = 0; i < specialFormulas.size(); ++i) {
                Object thirdParam;
                List parameters;
                FunctionExpr specialFormula = (FunctionExpr)specialFormulas.get(i);
                if (!specialFormula.getFuncionName().toLowerCase(Locale.ENGLISH).startsWith("getjlentry") || (parameters = specialFormula.getParameters()) == null || parameters.size() <= GETTJENTRYPARAMINDEX || (thirdParam = parameters.get(GETTJENTRYPARAMINDEX)) == null || !thirdParam.toString().contains("|")) continue;
                Pair index2param = new Pair((Object)GETTJENTRYPARAMINDEX, (Object)parameters);
                specialParameters.put(i, (Pair<Integer, List<Object>>)index2param);
            }
            if (insert != 0) {
                ReportFormulaUtil.shiftingFormula(directHoriz, refParamList, areaParamListMap, insert);
                ReportFormulaUtil.shiftingSpecialFormula(directHoriz, specialFormulas, specialParameters, insert, cell.getExcelAxis());
                String express = ex.toString();
                if (ObjectUtils.notEqual((Object)express, (Object)cell.getFormula())) {
                    if (!express.toLowerCase(Locale.ENGLISH).startsWith("get_dim_attr") && !express.toLowerCase(Locale.ENGLISH).startsWith("getjlentry")) {
                        ReportFormulaUtil.collectCellFormula(ex, cell.getRow(), cell.getCol(), formulas);
                    }
                    cell.setFormula(ex.toString());
                }
            }
            for (i = floatStart + 1; i <= floatEnd; ++i) {
                int col;
                int row;
                if (hasRef.get()) {
                    ReportFormulaUtil.shiftingFormula(directHoriz, refParamList, areaParamListMap, 1);
                }
                ReportFormulaUtil.shiftingSpecialFormula(directHoriz, specialFormulas, specialParameters, 1, cell.getExcelAxis());
                if (directHoriz) {
                    row = j;
                    col = i;
                } else {
                    row = i;
                    col = j;
                }
                if (sheet.getCell(row, col).hasFormula() && ObjectUtils.equals((Object)ex.toString(), (Object)sheet.getCell(row, col).getFormula())) continue;
                sheet.getCell(row, col).setFormula(ex.toString());
                String formulaStr = ex.toString().toLowerCase(Locale.ENGLISH).trim();
                if (formulaStr.startsWith("get_dim_attr") || formulaStr.startsWith("getjlentry")) continue;
                ReportFormulaUtil.collectCellFormula(ex, row, col, formulas);
            }
        }
        return formulas;
    }

    private static void shiftingSpecialFormula(boolean directHoriz, ArrayList<FunctionExpr> specialFormulas, Map<Integer, Pair<Integer, List<Object>>> specialParameters, Integer index, String axis) {
        for (Map.Entry<Integer, Pair<Integer, List<Object>>> entry : specialParameters.entrySet()) {
            Pair<Integer, List<Object>> index2params = entry.getValue();
            List params = (List)index2params.p2;
            Object param = params.get((Integer)index2params.p1);
            CharSequence[] split = new String[]{};
            if (param instanceof StringExpr) {
                split = ((StringExpr)param).getValue().split(",");
            }
            for (int i1 = 0; i1 < split.length; ++i1) {
                String dim2mem = split[i1];
                String[] dim2Ref = dim2mem.split("\\|");
                if (dim2Ref.length != 2) continue;
                String ref = dim2Ref[1];
                try {
                    Expression parse = ExcelFormulaPaserHelper.parse((String)ref);
                    if (!(parse instanceof ReferenceExpr)) continue;
                    ReferenceExpr refExp = (ReferenceExpr)parse;
                    ReportFormulaUtil.shiftingFormula(directHoriz, Collections.singletonList(refExp), new HashMap<AreaExpr, Pair<Boolean, Boolean>>(), index);
                    split[i1] = String.join((CharSequence)"|", dim2Ref[0], refExp.toString());
                    continue;
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"%1s\u5355\u5143\u683c\u201c%2s\u201d\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff1a\u201c%3s\u201d\u3002", (String)"ReportFormulaUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(String.format(msg, axis, ref, e));
                }
            }
            String newThirdParam = String.join((CharSequence)",", split);
            params.set(2, new StringExpr(newThirdParam));
            specialFormulas.get(entry.getKey()).setParameters(params);
        }
    }

    private static void collectCellFormula(Expression ex, int row, int col, List<Map> formulas) {
        HashMap<String, Object> formula = new HashMap<String, Object>();
        formula.put("r", row);
        formula.put("c", col);
        formula.put("f", ex.toString());
        formulas.add(formula);
    }

    private static void shiftingFormula(boolean directHoriz, List<ReferenceExpr> refParamList, Map<AreaExpr, Pair<Boolean, Boolean>> areaParamListMap, int insert) {
        if (!refParamList.isEmpty()) {
            for (ReferenceExpr referenceExpr : refParamList) {
                if (directHoriz) {
                    int col = referenceExpr.getCol() + insert;
                    referenceExpr.setCol(col);
                    continue;
                }
                if (FIX_ROW.matcher(referenceExpr.getName()).find()) {
                    return;
                }
                int row = referenceExpr.getRow() + insert;
                referenceExpr.setRow(row);
            }
        }
        if (!areaParamListMap.isEmpty()) {
            for (Map.Entry entry : areaParamListMap.entrySet()) {
                AreaExpr areaExpr;
                if (directHoriz) {
                    areaExpr = (AreaExpr)entry.getKey();
                    if (!((Boolean)((Pair)entry.getValue()).p1).booleanValue()) {
                        int start_col = areaExpr.getStart_col() + insert;
                        areaExpr.setStart_col(start_col);
                    }
                    if (((Boolean)((Pair)entry.getValue()).p2).booleanValue()) continue;
                    int end_col = areaExpr.getEnd_col() + insert;
                    areaExpr.setEnd_col(end_col);
                    continue;
                }
                areaExpr = (AreaExpr)entry.getKey();
                if (!((Boolean)((Pair)entry.getValue()).p1).booleanValue()) {
                    int start_row = areaExpr.getStart_row() + insert;
                    areaExpr.setStart_row(start_row);
                }
                if (((Boolean)((Pair)entry.getValue()).p2).booleanValue()) continue;
                int end_row = areaExpr.getEnd_row() + insert;
                areaExpr.setEnd_row(end_row);
            }
        }
    }

    public static boolean checkRef(String ref, Pattern regex) {
        Matcher m = regex.matcher(ref);
        return m.matches();
    }

    public static void isOnlyExcel(List<String> excelNotSupportFormulas, AtomicBoolean onlyExcel, Expression ex) {
        ExcelFormulaPaserHelper.walk((Expression)ex, exp -> {
            if (onlyExcel.get() && exp instanceof FunctionExpr) {
                onlyExcel.set(((FunctionExpr)exp).getFuncionName().toLowerCase(Locale.ENGLISH).startsWith("get_dim_attr") || ((FunctionExpr)exp).getFuncionName().toLowerCase(Locale.ENGLISH).startsWith("getjlentry") || !excelNotSupportFormulas.contains(((FunctionExpr)exp).getFuncionName().toLowerCase(Locale.ENGLISH)) || exp instanceof ReferenceExpr);
            }
        });
    }

    private static void collectRefParam(Expression ex, List<ReferenceExpr> refParamList, Map<AreaExpr, Pair<Boolean, Boolean>> areaParamListMap, AtomicBoolean hasRef, boolean directHoriz, List<FunctionExpr> specialFormula) {
        if (ex instanceof ReferenceExpr) {
            boolean fixRef;
            boolean bl = fixRef = directHoriz ? FIX_COL.matcher(((ReferenceExpr)ex).getName()).find() : FIX_ROW.matcher(((ReferenceExpr)ex).getName()).find();
            if (fixRef) {
                return;
            }
            refParamList.add((ReferenceExpr)ex);
            hasRef.set(true);
        } else if (ex instanceof AreaExpr) {
            boolean fixEndRef;
            String[] split = ((AreaExpr)ex).getName().split(":");
            boolean fixStartRef = directHoriz ? FIX_COL.matcher(split[0]).find() : FIX_ROW.matcher(split[0]).find();
            boolean bl = fixEndRef = directHoriz ? FIX_COL.matcher(split[1]).find() : FIX_ROW.matcher(split[1]).find();
            if (fixStartRef && fixEndRef) {
                return;
            }
            areaParamListMap.put((AreaExpr)ex, (Pair<Boolean, Boolean>)Pair.onePair((Object)fixStartRef, (Object)fixEndRef));
            hasRef.set(true);
        } else if (ex instanceof FunctionExpr && specialFormulas.contains(((FunctionExpr)ex).getFuncionName().toLowerCase())) {
            specialFormula.add((FunctionExpr)ex);
        }
    }

    public static List<Cell> getMemberGroupCell(SpreadManager spreadModel) {
        return (List)ThreadCache.get((Object)MEMBER_GROUP_CELL, () -> {
            ArrayList<Cell> resultList = new ArrayList<Cell>(16);
            for (PositionInfo positionInfo : spreadModel.getAreaManager().getPostionInfoSet()) {
                if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty()) continue;
                HashMap<String, String> rowDim = new HashMap<String, String>(16);
                HashMap<String, String> colDim = new HashMap<String, String>(16);
                ReportFormulaUtil.genTuples((Domain)spreadModel.getAreaManager().getColDimDomain(positionInfo), colDim);
                ReportFormulaUtil.genTuples((Domain)spreadModel.getAreaManager().getRowDimDoman(positionInfo), rowDim);
                for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                    Cell cell;
                    int j;
                    String[] range = positionInfo.getAreaRange().split(":");
                    String[] floatRange = basePointInfo.getDynaRange().split(":");
                    Point start = ExcelUtils.pos2Point((String)range[0]);
                    Point end = ExcelUtils.pos2Point((String)range[1]);
                    Point floatStart = ExcelUtils.pos2Point((String)floatRange[0]);
                    Point floatEnd = ExcelUtils.pos2Point((String)floatRange[1]);
                    boolean directHoriz = basePointInfo.isDirectHoriz();
                    int startR = start.y;
                    int startC = start.x;
                    int endR = end.y;
                    int endC = end.x;
                    if (directHoriz) {
                        startC = floatStart.x;
                        endC = floatEnd.x;
                    } else {
                        startR = floatStart.y;
                        endR = floatEnd.y;
                    }
                    Sheet sheet = spreadModel.getBook().getSheet(0);
                    if (directHoriz) {
                        for (j = startR; j <= endR; ++j) {
                            cell = sheet.getCell(j, startC);
                            ReportFormulaUtil.checkCellMemberGroup(resultList, rowDim, cell);
                        }
                        continue;
                    }
                    for (j = startC; j <= endC; ++j) {
                        cell = sheet.getCell(startR, j);
                        ReportFormulaUtil.checkCellMemberGroup(resultList, colDim, cell);
                    }
                }
            }
            return resultList;
        });
    }

    private static void checkCellMemberGroup(List<Cell> resultList, Map<String, String> rowDim, Cell cell) {
        boolean isMemberGroup;
        if (cell.hasFormula() && !cell.isMdDataDomain() && (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("get_dim_attr") || cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("getjlentry")) && (isMemberGroup = ReportFormulaUtil.isMemberGroup(rowDim, cell))) {
            resultList.add(cell);
        }
    }

    public static boolean isFloatAreaCell(SpreadManager spreadModel, Cell cell) {
        boolean isFloatAreaCell = false;
        for (PositionInfo positionInfo : spreadModel.getAreaManager().getPostionInfoSet()) {
            Point cellPoint;
            String areaRang;
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().isEmpty() || !ExcelUtils.isWithInScope((String)(areaRang = positionInfo.getAreaRange()), (String)(cellPoint = new Point(cell.getCol(), cell.getRow())).toString())) continue;
            return true;
        }
        return isFloatAreaCell;
    }

    private static boolean isMemberGroup(Map<String, String> dims, Cell cell) {
        boolean isMemberGroup = true;
        HashMap<String, String> dimMp = new HashMap<String, String>(16);
        if (cell.getMemberFromUserObject() != null) {
            for (IDimMember iDimMember : cell.getMemberFromUserObject()) {
                dimMp.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
            }
            for (Map.Entry entry : dims.entrySet()) {
                if (dimMp.containsKey(entry.getKey()) && dimMp.get(entry.getKey()) != null) continue;
                isMemberGroup = false;
            }
        } else {
            isMemberGroup = false;
        }
        return isMemberGroup;
    }

    private static void genTuples(Domain domain, Map<String, String> mapViewPoint) {
        if (domain == null) {
            return;
        }
        for (IDimMember m : domain.getAllMembers()) {
            if (m == null) continue;
            mapViewPoint.put(m.getDimension().getNumber(), m.getNumber());
        }
    }
}

