/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.merge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.convert.ConvertOrgScopeEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ReportConvertTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportConvertTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        OperationContext context = OperationContext.get();
        if (context != null) {
            context.setFormId("bcm_report_list");
        }
        String executeContextStr = (String)params.get("executeContext");
        Boolean isOnlyExecRules = (Boolean)params.get("onlyExecRules");
        ExecuteContext ctx = (ExecuteContext)ObjectSerialUtil.deSerializedBytes((String)executeContextStr);
        log.info("RealTimeCVTParam:" + ctx.toString());
        String cvtScope = ctx.getCvtScope();
        long modelId = (Long)ctx.getModel().id;
        long orgId = (Long)ctx.getOrg().id;
        long sceneId = (Long)ctx.getScenario().id;
        String yearNumber = ctx.getFy().number;
        long periodId = (Long)ctx.getPeriod().id;
        ArrayList<Pair> cvtPaths = ctx.getNowPaths();
        Pair targetCurrencyPair = (Pair)cvtPaths.get(1);
        String targetCurrency = (String)targetCurrencyPair.p2;
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        OlapTraceServiceHelper.setTraceOpInfo((String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6298\u7b97", (String)"ReportConvertTask_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber()));
        StringBuilder error = new StringBuilder();
        boolean success = Boolean.TRUE;
        boolean singleOrgConvert = ConvertServiceHelper.isSingleOrgConvert((String)cvtScope);
        if (singleOrgConvert) {
            try {
                String desc;
                if (this.isStop()) {
                    this.stop();
                }
                if (Boolean.TRUE.equals(isOnlyExecRules)) {
                    desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c %s\u201d \u5f00\u59cb\u6267\u884c\u89c4\u5219\u3002", (String)"ReportConvertTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber());
                    this.feedbackProgress(0, desc, null);
                    BizRuleExecuteService service = new BizRuleExecuteService(ctx);
                    service.executeRule(Arrays.asList("IRpt", "RAdj"), (String)((Pair)ctx.getNowPaths().get((int)1)).p2);
                } else {
                    desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c %s \u201d\u6b63\u5728\u6267\u884c\u62d3\u5c55\u7ef4\u6570\u636e\u6a21\u578b\u6298\u7b97\u3002", (String)"ReportConvertTask_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber());
                    this.feedbackProgress(50, desc, null);
                    ResultBox result = ExtConvertServiceHelper.convertExtModels((ExecuteContext)ctx, (boolean)true);
                    if (result.isNotSuccess()) {
                        error.append(result.getMessageText()).append("\n");
                        success = Boolean.FALSE;
                    }
                    desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 \u201c%s \u201d\u5f00\u59cb\u6267\u884c\u6807\u51c6\u6298\u7b97\u3002", (String)"ReportConvertTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber());
                    this.feedbackProgress(0, desc, null);
                    String errorMsg = MsServiceHelper.invokeMcConvertService((String)ctx.toString());
                    if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                        error.append(errorMsg).append("\n");
                        success = Boolean.FALSE;
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                error.append(e.getMessage()).append("\n");
                success = Boolean.FALSE;
            }
        } else {
            ArrayList<IDNumberTreeNode> allCvtOrg = new ArrayList<IDNumberTreeNode>(16);
            if (ConvertOrgScopeEnum.DIRECT_SUB_ORG.getScope().equals(cvtScope)) {
                allCvtOrg.addAll(orgNode.getChildren());
            } else {
                allCvtOrg.addAll(orgNode.getAllChildren());
            }
            allCvtOrg.add(orgNode);
            List allOrgIds = allCvtOrg.stream().map(IDNumberTreeNode::getId).collect(Collectors.toList());
            DynamicObjectCollection orgList = OrgServiceHelper.getOrgListByPremOnWrite((Long)modelId, allOrgIds);
            if (!orgList.isEmpty()) {
                ResultBox resultBox;
                IDNumberTreeNode ecNode;
                SimpleItem cvtOrg;
                FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, sceneId, yearNumber, periodId);
                EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (List)orgList);
                Set effectOrgIds = orgList.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                this.feedbackProgress(30, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u5408\u5e76\u7ec4\u7ec7\u4e0d\u53c2\u4e0e\u5408\u5e76\u62d3\u5c55\u7ef4\u6570\u636e\u6a21\u578b\u6298\u7b97\u3002", (String)"ReportConvertTask_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                for (IDNumberTreeNode treeNode : allCvtOrg) {
                    if (!effectOrgIds.contains(treeNode.getId()) || treeNode.isLeaf() || targetCurrency.equals(treeNode.getCurrency())) continue;
                    cvtOrg = SimpleItem.newOne((Object)treeNode.getId(), (String)treeNode.getNumber());
                    ctx.setOrg(cvtOrg);
                    ecNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)treeNode.getCurrency());
                    if (ecNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    cvtPaths = new ArrayList<Pair>(2);
                    cvtPaths.add(Pair.onePair((Object)ecNode.getId(), (Object)ecNode.getNumber()));
                    cvtPaths.add(targetCurrencyPair);
                    ctx.setNowPaths(cvtPaths);
                    resultBox = ExtConvertServiceHelper.convertExtModels((ExecuteContext)ctx, (boolean)false);
                    if (!resultBox.isNotSuccess()) continue;
                    error.append(resultBox.getMessageText()).append("\n");
                    success = Boolean.FALSE;
                }
                this.feedbackProgress(60, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u660e\u7ec6\u7ec4\u7ec7\u53c2\u4e0e\u5408\u5e76\u62d3\u5c55\u7ef4\u6570\u636e\u6a21\u578b\u6298\u7b97", (String)"ReportConvertTask_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                for (IDNumberTreeNode treeNode : allCvtOrg) {
                    if (!effectOrgIds.contains(treeNode.getId()) || !treeNode.isLeaf() || targetCurrency.equals(treeNode.getCurrency())) continue;
                    cvtOrg = SimpleItem.newOne((Object)treeNode.getId(), (String)treeNode.getNumber());
                    ctx.setOrg(cvtOrg);
                    ecNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)treeNode.getCurrency());
                    if (ecNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    cvtPaths = new ArrayList(2);
                    cvtPaths.add(Pair.onePair((Object)ecNode.getId(), (Object)ecNode.getNumber()));
                    cvtPaths.add(targetCurrencyPair);
                    ctx.setNowPaths(cvtPaths);
                    resultBox = ExtConvertServiceHelper.convertExtModels((ExecuteContext)ctx, (boolean)false);
                    if (!resultBox.isNotSuccess()) continue;
                    error.append(resultBox.getMessageText()).append("\n");
                    success = Boolean.FALSE;
                }
                int count = allCvtOrg.size();
                for (int i = 0; i < count; ++i) {
                    if (this.isStop()) {
                        this.stop();
                    }
                    IDNumberTreeNode currentOrgNode = (IDNumberTreeNode)allCvtOrg.get(i);
                    try {
                        String desc;
                        int progress = (int)((double)(100 * i / count) * 0.4) + 60;
                        if (!effectOrgIds.contains(currentOrgNode.getId())) continue;
                        if (!targetCurrency.equals(currentOrgNode.getCurrency())) {
                            desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 \u201c%s \u201d\u5f00\u59cb\u6267\u884c\u6807\u51c6\u6298\u7b97\u3002", (String)"ReportConvertTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), currentOrgNode.getNumber());
                            this.feedbackProgress(progress, desc, null);
                            SimpleItem cvtOrg2 = SimpleItem.newOne((Object)currentOrgNode.getId(), (String)currentOrgNode.getNumber());
                            ctx.setOrg(cvtOrg2);
                            IDNumberTreeNode ecNode2 = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)currentOrgNode.getCurrency());
                            if (ecNode2 == IDNumberTreeNode.NotFoundTreeNode) continue;
                            cvtPaths = new ArrayList(2);
                            cvtPaths.add(Pair.onePair((Object)ecNode2.getId(), (Object)ecNode2.getNumber()));
                            cvtPaths.add(targetCurrencyPair);
                            ctx.setNowPaths(cvtPaths);
                            String errorMsg = MsServiceHelper.invokeMcConvertService((String)ctx.toString());
                            if (!StringUtils.isNotEmpty((CharSequence)errorMsg)) continue;
                            error.append(errorMsg).append("\n");
                            success = Boolean.FALSE;
                            continue;
                        }
                        desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u9ed8\u8ba4\u5e01\u548c\u76ee\u6807\u5e01\u4e00\u81f4\uff0c\u8df3\u8fc7\u6298\u7b97\u3002", (String)"ReportConvertTask_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), currentOrgNode.getNumber());
                        this.feedbackProgress(progress, desc, null);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %s \u6267\u884c\u6807\u51c6\u6298\u7b97\u5931\u8d25", (String)"ReportConvertTask_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), currentOrgNode.getNumber()));
                        log.error((Throwable)e);
                        error.append(e.getMessage()).append("\n");
                        success = Boolean.FALSE;
                    }
                }
            } else {
                success = Boolean.FALSE;
                error.append(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u8303\u56f4\u65e0\u8bfb\u5199\u6743\u9650\u7684\u7ec4\u7ec7\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"ReportConvertTask_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msg", error.toString());
        String orgNumber = "";
        String orgName = "";
        if (orgNode.getId() != -1L) {
            orgNumber = orgNode.getNumber();
            orgName = orgNode.getName();
        }
        result.put("orgNumber", orgNumber);
        result.put("orgName", orgName);
        this.feedbackCustomdata(result);
    }
}

