/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.merge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.report.ReportMergeExecuteService;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.report.merge.util.MergeSumMemberUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.collections.CollectionUtils;

public class ReportMergeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportMergeTask.class);
    private static final List<String> notDimNumber = Lists.newArrayList((Object[])new String[]{"Entity", "Scenario", "Year", "Period", "Process", "Currency", "AuditTrail", "MyCompany"});

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u3002", (String)"ReportMergeTask_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        String executeContextStr = (String)params.get("executeContext");
        ExecuteContext ctx = (ExecuteContext)ObjectSerialUtil.deSerializedBytes((String)executeContextStr);
        OrgBuilder build = OrgBuilder.build((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getScenario().getId()), (Long)((Long)ctx.getFy().getId()), (Long)((Long)ctx.getPeriod().getId()));
        OrgNode node = build.genOrgNode((Long)ctx.getOrg().getId());
        build.extendDirectChildren(node);
        Map<Object, Object> dimNumberMap = DimensionUtil.getDimMap("bcm_dimension", "number", "shortnumber", LongUtil.toLong((Object)ctx.getModel().id));
        ArrayList needScopeDimNumber = new ArrayList(10);
        ArrayList<String> runSuccessTmpNumber = new ArrayList<String>(10);
        dimNumberMap.forEach((k, v) -> {
            if (!notDimNumber.contains(k.toString())) {
                needScopeDimNumber.add(k.toString());
            }
        });
        String[] needScopeDimNumberArray = needScopeDimNumber.toArray(new String[0]);
        List tempids = ctx.getTempids();
        DynamicObject[] reports = ctx.getReports();
        boolean isID = CollectionUtils.isNotEmpty((Collection)tempids);
        ArrayList<String> completeTemplateNumber = new ArrayList<String>(10);
        int time = isID ? tempids.size() : reports.length;
        try {
            for (int i = 0; i < time; ++i) {
                Long id;
                String reportStatus = ReportStatusEnum.UNWEAVE.status();
                if (isID) {
                    id = (Long)tempids.get(i);
                } else {
                    DynamicObject report = reports[i];
                    reportStatus = report.getString("reportstatus");
                    id = report.getLong("template.id");
                }
                this.doSingleTemplate(id, reportStatus, i, time, needScopeDimNumberArray, completeTemplateNumber, ctx, node, runSuccessTmpNumber);
            }
        }
        catch (Exception e) {
            log.error("MergeSumByTpl error:" + e.getMessage());
            log.error((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        if (!completeTemplateNumber.isEmpty()) {
            success = false;
            result.put("number", completeTemplateNumber);
        }
        result.put("success", success);
        result.put("successTmp", runSuccessTmpNumber);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)((Long)ctx.getModel().id), (Long)((Long)ctx.getOrg().id));
        String orgNumber = "";
        String orgName = "";
        if (orgNode.getId() != -1L) {
            orgNumber = orgNode.getNumber();
            orgName = orgNode.getName();
        }
        result.put("orgNumber", orgNumber);
        result.put("orgName", orgName);
        result.put("isContainNotMergeMember", ctx.isContainNotMergeMember());
        this.feedbackCustomdata(result);
    }

    private void doSingleTemplate(Long templateId, String reportStatus, int i, int time, String[] needScopeDimNumberArray, List<String> completeTemplateNumber, ExecuteContext ctx, OrgNode node, List<String> runSuccessTmpNumber) {
        if (this.isStop()) {
            this.stop();
        }
        TemplateModel templateModel = ModelDataProvider.getTemplateModel(templateId);
        String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c%1$s/%2$s\u6b21\u5faa\u73af\uff0c\u5408\u5e76\u6c47\u603b\u6a21\u677f\u201c%3$s\u201d\u3002", (String)"ReportMergeTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, time, templateModel.getNumber());
        int progress = 100 * i / time;
        this.feedbackProgress(progress, desc, null);
        if (ReportStatusEnum.COMPLETE.status().equals(reportStatus) || ReportStatusEnum.COMMIT.status().equals(reportStatus)) {
            completeTemplateNumber.add(templateModel.getNumber());
            return;
        }
        if (templateModel.isSaveByDim()) {
            List scopeList = SpreadMemUtil.analysisMemberFromSheet((SpreadManager)SpreadMemUtil.querySpreadManager((Long)templateId), (TemplateModel)templateModel, (String[])needScopeDimNumberArray);
            int index = 0;
            for (Map memScope : scopeList) {
                if (needScopeDimNumberArray.length == memScope.size()) {
                    Map<String, Set<String>> scope = MergeSumMemberUtil.replaceDynamicMemberToLeafMember((Long)ctx.getModel().getId(), memScope);
                    log.info(String.format("MergeSumForTpl[%s]MemberScopeIndex[%s]:%s", templateModel.getNumber(), index, scope));
                    ctx.setTmpscope(memScope);
                    ctx.setTemplateNumber(templateModel.getNumber());
                    new ReportMergeExecuteService(node).executeService(ctx);
                }
                ++index;
            }
            runSuccessTmpNumber.add(templateModel.getNumber());
        }
    }
}

