/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.merge;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ReportMergeTaskHelper {
    private static final String TASK_CLASS_MERGE_NAME = "kd.fi.bcm.formplugin.report.merge.ReportMergeTask";
    private static final String TASK_CLASS_CONVERT_NAME = "kd.fi.bcm.formplugin.report.merge.ReportConvertTask";

    public static void createTask(AbstractFormPlugin plugin, ExecuteContext executeContext, String type) {
        JobInfo jobInfo = new JobInfo();
        IFormView view = plugin.getView();
        jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setId(UUID.randomUUID().toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "mergeTaskCloseBack");
        String orgNumber = executeContext.getOrg().getNumber();
        StringBuilder sb = new StringBuilder(orgNumber);
        if ("1".equalsIgnoreCase(type)) {
            jobInfo.setName(ResManager.loadKDString((String)"\u6309\u62a5\u8868\u5408\u5e76\u6c47\u603b", (String)"ReportMergeTaskHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            jobInfo.setTaskClassname(TASK_CLASS_MERGE_NAME);
        } else {
            sb.append(ResManager.loadKDString((String)"\u6298\u7b97", (String)"ReportMergeTaskHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            jobInfo.setName(sb.toString());
            jobInfo.setTaskClassname(TASK_CLASS_CONVERT_NAME);
            closeCallBack = new CloseCallBack((IFormPlugin)plugin, "convertTaskCloseBack");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("executeContext", ObjectSerialUtil.toByteSerialized((Object)executeContext));
        if ("3".equalsIgnoreCase(type)) {
            params.put("onlyExecRules", Boolean.TRUE);
        }
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(view.getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public static ExecuteContext getReportListCslExecuteContext(DynamicObject model, DynamicObject scenario, DynamicObject year, DynamicObject period, long orgId, String orgNum) {
        ExecuteContext ctx = new ExecuteContext(SimpleItem.newOne((Object)model.getLong("id"), (String)model.getString("number")), SimpleItem.newOne((Object)orgId, (String)orgNum), SimpleItem.newOne((Object)year.getLong("id"), (String)year.getString("number")), SimpleItem.newOne((Object)period.getLong("id"), (String)period.getString("number")), SimpleItem.newOne((Object)scenario.getLong("id"), (String)scenario.getString("number")), false);
        ctx.setUserId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        ctx.setFromRpt(true);
        ctx.setCsl(false);
        ctx.setSkipCheck(true);
        ctx.setSkipPcRule(true);
        ctx.setSkipEcRule(true);
        ctx.setSkipInvElim(true);
        return ctx;
    }

    public static ExecuteContext getReportListCslExecuteContext(DynamicObject model, DynamicObject scenario, DynamicObject year, DynamicObject period, DynamicObject org) {
        return ReportMergeTaskHelper.getReportListCslExecuteContext(model, scenario, year, period, org.getLong("id"), org.getString("number"));
    }

    public static ExecuteContext getReportCovertContext(Pair<Long, String> model, Pair<Long, String> scenario, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> orgPair) {
        ExecuteContext ctx = new ExecuteContext(SimpleItem.newOne((Object)model.p1, (String)((String)model.p2)), SimpleItem.newOne((Object)orgPair.p1, (String)((String)orgPair.p2)), SimpleItem.newOne((Object)year.p1, (String)((String)year.p2)), SimpleItem.newOne((Object)period.p1, (String)((String)period.p2)), SimpleItem.newOne((Object)scenario.p1, (String)((String)scenario.p2)), false);
        ctx.setSkipCheck(true);
        ctx.setSkipPcRule(false);
        ctx.setSkipEcRule(false);
        ctx.setSkipInvElim(true);
        return ctx;
    }
}

