/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.merge.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.cache.PageCache;
import kd.bos.service.ServiceFactory;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.report.ReportMergeExecuteService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.report.merge.util.MergeSumMemberUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class MergeSumThread
implements Runnable {
    private WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());
    private static final String CACHE_KEY_PROGRESS = "datacollect_progress";
    private Map<String, Pair<Long, String>> commonParam;
    private Pair<Long, String> model;
    private Long templateId;
    private String pageId;
    private boolean isContainNotMergeMember = false;
    private static final List<String> notNeedScopeDimNumber = Arrays.asList("Entity", "Scenario", "Year", "Period", "Process", "Currency", "AuditTrail", "MyCompany");

    public MergeSumThread(Pair<Long, String> model, Long templateId, Map<String, Pair<Long, String>> commonParam, String pageId) {
        this.model = model;
        this.templateId = templateId;
        this.commonParam = commonParam;
        this.pageId = pageId;
    }

    public void setContainNotMergeMember(boolean containNotMergeMember) {
        this.isContainNotMergeMember = containNotMergeMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PageCache pageCache = new PageCache(this.pageId);
        pageCache.put(CACHE_KEY_PROGRESS, "1");
        Pair<Long, String> orgPair = this.commonParam.get(DimTypesEnum.ENTITY.getNumber());
        Pair<Long, String> yearPair = this.commonParam.get(DimTypesEnum.YEAR.getNumber());
        Pair<Long, String> periodPair = this.commonParam.get(DimTypesEnum.PERIOD.getNumber());
        Pair<Long, String> scenePair = this.commonParam.get(DimTypesEnum.SCENARIO.getNumber());
        TemplateModel templateModel = null;
        try {
            ExecuteContext executeContext = new ExecuteContext(SimpleItem.newOne((Object)this.model.p1, (String)((String)this.model.p2)), SimpleItem.newOne((Object)orgPair.p1, (String)((String)orgPair.p2)), SimpleItem.newOne((Object)yearPair.p1, (String)((String)yearPair.p2)), SimpleItem.newOne((Object)periodPair.p1, (String)((String)periodPair.p2)), SimpleItem.newOne((Object)scenePair.p1, (String)((String)scenePair.p2)), false);
            executeContext.setUserId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
            executeContext.setFromRpt(true);
            executeContext.setCsl(false);
            executeContext.setSkipCheck(true);
            executeContext.setSkipPcRule(true);
            executeContext.setSkipEcRule(true);
            executeContext.setSkipInvElim(true);
            executeContext.setContainNotMergeMember(this.isContainNotMergeMember);
            OrgBuilder build = OrgBuilder.build((Long)((Long)this.model.p1), (Long)((Long)scenePair.p1), (Long)((Long)yearPair.p1), (Long)((Long)periodPair.p1));
            OrgNode node = build.genOrgNode((Long)orgPair.p1);
            build.extendDirectChildren(node);
            Map<Object, Object> dimNumberMap = DimensionUtil.getDimMap("bcm_dimension", "number", "shortnumber", (Long)this.model.p1);
            ArrayList needScopeDimNumber = new ArrayList(10);
            dimNumberMap.forEach((k, v) -> {
                if (!notNeedScopeDimNumber.contains(k.toString())) {
                    needScopeDimNumber.add(k.toString());
                }
            });
            String[] needScopeDimNumberArray = needScopeDimNumber.toArray(new String[0]);
            templateModel = ModelDataProvider.getTemplateModel(this.templateId);
            if (templateModel.isSaveByDim()) {
                List scopeList = SpreadMemUtil.analysisMemberFromSheet((SpreadManager)SpreadMemUtil.querySpreadManager((Long)this.templateId), (TemplateModel)templateModel, (String[])needScopeDimNumberArray);
                int count = scopeList.size();
                int index = 0;
                for (Map memScope : scopeList) {
                    if (needScopeDimNumberArray.length == memScope.size()) {
                        Map<String, Set<String>> scope = MergeSumMemberUtil.replaceDynamicMemberToLeafMember((Long)this.model.p1, memScope);
                        this.logger.info(String.format("MergeSumForTpl[%s]MemberScopeIndex[%s]:%s", templateModel.getNumber(), index, scope));
                        executeContext.setTmpscope(scope);
                        executeContext.setTemplateNumber(templateModel.getNumber());
                        new ReportMergeExecuteService(node).executeService(executeContext);
                    }
                    double percent = (double)(++index * 100) / (double)count;
                    pageCache.put(CACHE_KEY_PROGRESS, String.valueOf((int)percent));
                }
                if (this.isContainNotMergeMember) {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6309\u8868\u5408\u5e76\u6c47\u603b", "MergeSumThread_0", "fi-bcm-formplugin", "reportmerge"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s \u6a21\u677f\uff1a%4$s \u6309\u8868\u5408\u5e76\u6c47\u603b\u6210\u529f, \u5305\u542b\u4e0d\u53c2\u4e0e\u5408\u5e76\u7684\u6570\u636e\u3002", "MergeSumThread_2", "fi-bcm-formplugin", new String[]{(String)yearPair.p2, (String)periodPair.p2, (String)orgPair.p2, templateModel.getNumber()}), (Long)this.model.p1);
                } else {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6309\u8868\u5408\u5e76\u6c47\u603b", "MergeSumThread_0", "fi-bcm-formplugin", "reportmerge"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s \u6a21\u677f\uff1a%4$s \u6309\u8868\u5408\u5e76\u6c47\u603b\u6210\u529f\u3002", "MergeSumThread_1", "fi-bcm-formplugin", new String[]{(String)yearPair.p2, (String)periodPair.p2, (String)orgPair.p2, templateModel.getNumber()}), (Long)this.model.p1);
                }
            }
        }
        catch (Exception e) {
            pageCache.put("exterror", ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
            if (templateModel != null) {
                if (this.isContainNotMergeMember) {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6309\u8868\u5408\u5e76\u6c47\u603b", "MergeSumThread_0", "fi-bcm-formplugin", "reportmerge"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s \u6a21\u677f\uff1a%4$s \u6309\u8868\u5408\u5e76\u6c47\u603b\u5931\u8d25, \u5305\u542b\u4e0d\u53c2\u4e0e\u5408\u5e76\u7684\u6570\u636e\u3002", "MergeSumThread_4", "fi-bcm-formplugin", new String[]{(String)yearPair.p2, (String)periodPair.p2, (String)orgPair.p2, templateModel.getNumber()}), (Long)this.model.p1);
                } else {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6309\u8868\u5408\u5e76\u6c47\u603b", "MergeSumThread_0", "fi-bcm-formplugin", "reportmerge"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s \u6a21\u677f\uff1a%4$s \u6309\u8868\u5408\u5e76\u6c47\u603b\u5931\u8d25\u3002", "MergeSumThread_3", "fi-bcm-formplugin", new String[]{(String)yearPair.p2, (String)periodPair.p2, (String)orgPair.p2, templateModel.getNumber()}), (Long)this.model.p1);
                }
            }
        }
        finally {
            pageCache.put(CACHE_KEY_PROGRESS, String.valueOf(100));
        }
    }

    private void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge, Long modelId) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)"bcm_cslreportprocess");
        logService.addLog(logInfo);
    }
}

