/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.merge.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class MergeSumMemberUtil {
    public static Map<String, Set<String>> replaceDynamicMemberToLeafMember(Long modelId, Map<String, Set<String>> dimMemberScopeMap) {
        boolean boolParam043 = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM043");
        if (boolParam043) {
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            for (Map.Entry<String, Set<String>> entry : dimMemberScopeMap.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> memberSet = entry.getValue();
                HashSet<Object> replaceRes = new HashSet<Object>();
                HashSet<String> hasReplaceMemberLongNumberSet = new HashSet<String>();
                for (String memberNumber : memberSet) {
                    IDNumberTreeNode baseTreeNode = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memberNumber).getBaseTreeNode();
                    if (!baseTreeNode.isLeaf() && baseTreeNode.getStorageType() == StorageTypeEnum.DYNAMIC) {
                        if (MergeSumMemberUtil.checkIfHasReplace(hasReplaceMemberLongNumberSet, baseTreeNode.getLongNumber())) continue;
                        List allLeafChildren = baseTreeNode.getAllChildren(2);
                        if (allLeafChildren != null && !allLeafChildren.isEmpty()) {
                            Set leafNumberSet = allLeafChildren.stream().filter(r -> r.getStorageType() != StorageTypeEnum.LABEL).map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                            replaceRes.addAll(leafNumberSet);
                        }
                        hasReplaceMemberLongNumberSet.add(baseTreeNode.getLongNumber());
                        continue;
                    }
                    if (baseTreeNode.getStorageType() == StorageTypeEnum.LABEL) continue;
                    replaceRes.add(baseTreeNode.getNumber());
                }
                memberSet.clear();
                memberSet.addAll(replaceRes);
            }
        }
        return dimMemberScopeMap;
    }

    private static boolean checkIfHasReplace(Set<String> hasReplaceMemberLongNumberSet, String longNumber) {
        if (hasReplaceMemberLongNumberSet.contains(longNumber)) {
            return true;
        }
        for (String delOrgLongNumber : hasReplaceMemberLongNumberSet) {
            if (!longNumber.contains(delOrgLongNumber)) continue;
            return true;
        }
        return false;
    }
}

