/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.multi;

import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.report.multi.ReportModelTypeEnum;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabModel;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class ModelDataProvider {
    public static final String SPREADJSON = "spreadjson";
    public static final String DATA = "data";

    public ReportTabModel query4Cache(ReportTabInfo tab, IPageCache cache) {
        ReportTabModel item = new ReportTabModel(tab.getTabKey(), cache);
        TemplateModel template = ModelDataProvider.getTemplateModel(tab.getTemplateId());
        String spreadSerial = null;
        String spreadJson = null;
        SpreadManager sm = null;
        boolean isFromTemplateModel = false;
        String orgid = tab.getOrg();
        if (ReportModelTypeEnum.REPORT == tab.getModelType()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_reportentity", (String)"spreadjson,data", (QFilter[])new QFilter("id", "=", (Object)ConvertUtil.convertObjToLong((Object)tab.getReportId())).toArray(), null);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    Pair<String, String> tuple = AutoFloatUtil.dealAlternateFloatRecord(template, row.getString(DATA), row.getString(SPREADJSON));
                    spreadSerial = (String)tuple.p1;
                    spreadJson = (String)tuple.p2;
                    if (StringUtils.isNotEmpty((String)spreadSerial)) {
                        sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                    }
                    DynamicObject orgTmp = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)template, (long)Long.parseLong(orgid));
                    String dealJson = null;
                    if (orgTmp != null && !StringUtils.isEmpty((String)spreadJson)) {
                        if (sm == null) {
                            sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                        }
                        dealJson = TempFormulaUtil.dealSpreadJson(sm, spreadJson);
                    }
                    spreadJson = !StringUtils.isEmpty((String)spreadJson) ? (orgTmp == null ? spreadJson : dealJson) : template.getRptSpreadJson();
                }
            }
        }
        if (StringUtils.isEmpty(spreadJson)) {
            Map<String, Object> stringMap = ModelDataProvider.dealString(template, orgid);
            spreadJson = (String)stringMap.get(SPREADJSON);
            spreadSerial = (String)stringMap.get(DATA);
            sm = (SpreadManager)stringMap.get("sm");
            isFromTemplateModel = Boolean.parseBoolean((String)stringMap.get("isFromTemplateModel"));
        }
        item.initReportTabModel(spreadJson, spreadSerial, sm, !isFromTemplateModel);
        item.setTemplateModel(template);
        return item;
    }

    public static Map<String, Object> dealString(TemplateModel template, String orgid) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        SpreadManager sm = null;
        String spreadJson = template.getRptSpreadJson();
        String spreadSerial = StringUtils.isNotEmpty((String)template.getRptData()) ? template.getRptData() : template.getData();
        boolean isFromTemplateModel = true;
        DynamicObject orgTmp = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)template, (long)Long.parseLong(orgid));
        if (orgTmp != null) {
            if (StringUtils.isEmpty((String)orgTmp.getString(DATA))) {
                sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                List cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)sm, (long)template.getModelId(), (long)template.getId(), (long)Long.parseLong(orgid), (boolean)true);
                spreadJson = TempFormulaUtil.dealSpreadJson(cells, sm.getBook().getSheet(0).getSheetName(), spreadJson);
            } else {
                spreadJson = orgTmp.getString(SPREADJSON);
                spreadSerial = orgTmp.getString(DATA);
                sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
            }
            spreadJson = TempFormulaUtil.removeAccFormula(sm, spreadJson);
            spreadSerial = JsonSerializerUtil.toJson((SpreadManager)sm);
            isFromTemplateModel = false;
        } else if (template.isSaveByDim()) {
            Table table;
            sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
            if (ConfigServiceHelper.getBoolParam((Long)template.getModelId(), (String)"isSupportNewMytemplate")) {
                List cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)sm, (long)template.getModelId(), (long)template.getId(), (long)Long.parseLong(orgid), (boolean)true);
                spreadJson = TempFormulaUtil.dealSpreadJson(cells, sm.getBook().getSheet(0).getSheetName(), spreadJson);
            }
            if ((table = TempFormulaUtil.collectFormulas(template, sm, Long.parseLong(orgid))) != null) {
                Map<String, String> managerAndSpreadJson = TempFormulaUtil.dealSpreadManagerAndSpreadJson(table, sm, spreadJson);
                spreadJson = managerAndSpreadJson.get(SPREADJSON);
                isFromTemplateModel = false;
            }
            spreadSerial = JsonSerializerUtil.toJson((SpreadManager)sm);
        } else if (ConfigServiceHelper.getBoolParam((Long)template.getModelId(), (String)"isSupportNewMytemplate")) {
            sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
            List cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)sm, (long)template.getModelId(), (long)template.getId(), (long)Long.parseLong(orgid), (boolean)true);
            spreadJson = TempFormulaUtil.dealSpreadJson(cells, sm.getBook().getSheet(0).getSheetName(), spreadJson);
            spreadSerial = JsonSerializerUtil.toJson((SpreadManager)sm);
        }
        map.put(SPREADJSON, spreadJson);
        map.put(DATA, spreadSerial);
        map.put("sm", sm);
        map.put("isFromTemplateModel", Boolean.toString(isFromTemplateModel));
        return map;
    }

    public static List<TemplateModel> batchGetTemplateModel(List<Long> templateIds, Long modelId) {
        return TemplateUtil.batchGetTemplateModel(templateIds, (Long)modelId, (boolean)true);
    }

    public static TemplateModel getTemplateModel(Object templateId) {
        return TemplateUtil.getTemplateModel((Object)templateId);
    }
}

