/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.multi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.util.BcmDLockUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.csl.CslReportProcessPlugin;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabManager;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import org.apache.commons.collections.CollectionUtils;

public class SwitchUnRefreshReportPlugin
extends AbstractBaseFormPlugin
implements MainPage,
TabSelectListener,
IIncreaseReportTab {
    protected static final String REPORT_TAB = "tabap";
    protected static final String CMDNAMEKEY = "closeTab";
    protected static final String CMDNAMEKEYS = "closeTabs";
    private static final String KEY_TAB_MANAGER = "KEY_TAB_MANAGER";
    protected static final String PAGEID = "pageId";
    private static final String CLOSETABKEYS = "closeTabKeys";
    private ReportTabManager manager;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab reporttab = (Tab)this.getControl(REPORT_TAB);
        if (reporttab != null) {
            reporttab.addTabSelectListener((TabSelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initReportTabInfoByPostman();
        this.contructReportTab();
    }

    public void tabSelected(TabSelectEvent evt) {
        BcmDLockUtil.lockOpenReport((String)this.getView().getPageId());
        String tabKey = evt.getTabKey();
        if (this.getPageCache().get(tabKey) == null) {
            this.getReportTabInfoManager().setSelectReportTabInfo(tabKey);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            if (this.getReportTabInfoManager() == null || this.getReportTabInfoManager().getCurrSelectReportTabInfo() == null || this.getReportTabInfoManager().getCurrSelectReportTabInfo().getListRecordInfo() == null) {
                return;
            }
            Map<String, Object> recordInfo = this.getReportTabInfoManager().getCurrSelectReportTabInfo().getListRecordInfo();
            formShowParameter.getCustomParams().put("reportpostman", recordInfo.get("postman"));
            formShowParameter.setFormId(this.getReportFrom());
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(tabKey);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, tabKey));
            if (recordInfo.containsKey("numtomems")) {
                formShowParameter.setCustomParam("numtomems", recordInfo.remove("numtomems"));
            }
            this.addCustomParam(formShowParameter);
            this.getView().showForm(formShowParameter);
            this.getPageCache().put(tabKey, "1");
            this.getReportTabInfoManager().getCurrSelectReportTabInfo().getListRecordInfo().put(PAGEID, formShowParameter.getPageId());
            this.cacheReportTabInfoManager(this.getReportTabInfoManager());
        } else {
            this.selectOldTab(tabKey);
        }
        BcmDLockUtil.unLockOpenReport((String)this.getView().getPageId());
    }

    protected void addCustomParam(FormShowParameter formShowParameter) {
    }

    protected String getReportFrom() {
        return "bcm_cslreportprocess";
    }

    protected Long getMemId(String key) {
        return 0L;
    }

    protected void selectOldTab(String tabKey) {
        this.getReportTabInfoManager().setSelectReportTabInfo(tabKey);
        if (this.getReportTabInfoManager().getCurrSelectReportTabInfo() == null) {
            return;
        }
        Map<String, Object> recordInfo = this.getReportTabInfoManager().getCurrSelectReportTabInfo().getListRecordInfo();
        String repPageId = recordInfo.get(PAGEID).toString();
        if (recordInfo.containsKey("numtomems")) {
            ThreadCache.put((Object)"numtomems", (Object)recordInfo.remove("numtomems"));
            IFormView repView = this.getView().getView(repPageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)repView.getService(FormViewPluginProxy.class);
            pluginProxy.getPlugIns().forEach(e -> {
                if (CslReportProcessPlugin.class.isAssignableFrom(e.getClass())) {
                    ((CslReportProcessPlugin)e).selectCurAgain();
                    ((CslReportProcessPlugin)e).selectCurAnnotateTabAgain();
                    ((CslReportProcessPlugin)e).destory();
                }
            });
            this.getView().sendFormAction(repView);
        }
        Map pagePool = this.getPagePool(this.getPageCache());
        pagePool.entrySet().removeIf(s -> "bcm_workbenchreport".equals(s.getValue()));
        pagePool.put(repPageId, "bcm_workbenchreport");
        this.getPageCache().put("pagePool", SerializationUtils.toJsonString((Object)pagePool));
        this.cacheReportTabInfoManager(this.getReportTabInfoManager());
    }

    protected List<ReportTabInfo> getAddReportInfoByPostman(AbstractReportPostman postman) {
        List<Map<String, Object>> msf = this.getTabMsgFromPm(postman);
        ArrayList<ReportTabInfo> insertInfo = new ArrayList<ReportTabInfo>(msf.size());
        for (Map<String, Object> tabMsg : msf) {
            ReportTabInfo tri = new ReportTabInfo(tabMsg.get("tabKey").toString(), tabMsg.get("tabName").toString(), tabMsg.get("reportId"), tabMsg.get("templateId"));
            tri.getListRecordInfo().put("postman", tabMsg.get("postman"));
            if (ThreadCache.exists((Object)"numtomems")) {
                tri.getListRecordInfo().put("numtomems", ThreadCache.get((Object)"numtomems"));
            }
            insertInfo.add(tri);
        }
        return insertInfo;
    }

    @Override
    public void increaseReportTab(AbstractReportPostman postman) {
        String newTabSelKey = null;
        List<ReportTabInfo> insertInfo = this.getAddReportInfoByPostman(postman);
        for (ReportTabInfo tabInfo : insertInfo) {
            boolean hasAdd = this.getReportTabInfoManager().addReportTabInfo4List(tabInfo);
            if (!hasAdd || newTabSelKey != null) continue;
            newTabSelKey = tabInfo.getTabKey();
        }
        this.openNewReportTab(newTabSelKey, insertInfo);
        this.cacheReportTabInfoManager(this.getReportTabInfoManager());
        BcmDLockUtil.unLockOpenReport((String)this.getView().getPageId());
    }

    protected void openNewReportTab(String newTabSelKey, List<ReportTabInfo> insertInfo) {
        Tab reporttab = (Tab)this.getControl(REPORT_TAB);
        if (newTabSelKey != null) {
            this.contructReportTab();
            reporttab.activeTab(newTabSelKey);
        } else if (CollectionUtils.isNotEmpty(insertInfo)) {
            String oldTabKey = this.findOldKey(insertInfo.get(0).getTabKey());
            if (ThreadCache.exists((Object)"numtomems")) {
                this.getReportTabInfoManager().searchTab(oldTabKey).getListRecordInfo().put("numtomems", ThreadCache.get((Object)"numtomems"));
            }
            reporttab.activeTab(oldTabKey);
            if (oldTabKey.equals(this.getReportTabInfoManager().getCurrSelectReportTabInfo().getTabKey())) {
                this.selectOldTab(oldTabKey);
            }
        }
    }

    protected String findOldKey(String key) {
        String[] newKeyArr = key.split("\\|");
        if (newKeyArr.length >= 2) {
            for (ReportTabInfo e : this.getReportTabInfoManager().getTabs()) {
                String[] oldKeyArr = e.getTabKey().split("\\|");
                if (oldKeyArr.length < 2 || !oldKeyArr[0].equals(newKeyArr[0]) || !oldKeyArr[1].equals(newKeyArr[1])) continue;
                return e.getTabKey();
            }
        }
        return key;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        this.doCloseTab(key, true);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        List<String> closeKeys = this.getAllTabKeys();
        if (!this.batchCheckAndCloseTab(closeKeys)) {
            evt.setCancel(true);
        }
        BcmDLockUtil.unLockOpenReport((String)this.getView().getPageId());
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        String key = e.getEventArgs();
        if (CMDNAMEKEY.equals(name) || CMDNAMEKEYS.equals(name)) {
            ArrayList<String> closeKeys = new ArrayList<String>();
            if (CMDNAMEKEY.equals(name)) {
                closeKeys = new ArrayList();
                closeKeys.add(key);
            }
            if (CMDNAMEKEYS.equals(name)) {
                closeKeys = SwitchUnRefreshReportPlugin.getCloseKeysFromArgs(key);
            }
            this.getPageCache().put(CLOSETABKEYS, this.toByteSerialized(closeKeys));
            this.batchCheckAndCloseTab(closeKeys);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        String tabKey = e.getCustomVaule();
        if ("jumpPage".equals(callBackId)) {
            if (StringUtils.isNotEmpty((String)tabKey)) {
                this.selectRealReportTab(tabKey);
                this.fallBackChange();
            } else if (MessageBoxResult.Yes == e.getResult()) {
                String closeTabkeysStr = this.getPageCache().get(CLOSETABKEYS);
                List closeKeys = this.getAllTabKeys();
                if (closeTabkeysStr != null) {
                    closeKeys = (List)this.deSerializedBytes(closeTabkeysStr);
                    this.getPageCache().remove(CLOSETABKEYS);
                }
                for (String closeKey : closeKeys) {
                    this.doCloseTab(closeKey, false);
                }
                this.closeAllCustomTab(closeKeys);
                this.quitMainPage();
            } else if (MessageBoxResult.No == e.getResult()) {
                this.fallBackChange();
            }
        }
    }

    protected void quitMainPage() {
    }

    protected void showF7Form() {
    }

    protected void fallBackChange() {
    }

    protected void selectRealReportTab(String tabKey) {
        this.getReportTabInfoManager().setSelectReportTabInfo(tabKey);
        this.cacheReportTabInfoManager(this.getReportTabInfoManager());
        Tab reporttab = (Tab)this.getControl(REPORT_TAB);
        reporttab.selectTab(tabKey);
        reporttab.activeTab(tabKey);
    }

    protected AbstractReportPostman getReportPostman() {
        String postmanSerial = (String)this.getFormCustomParam("reportpostman");
        if (StringUtils.isEmpty((String)postmanSerial)) {
            throw new KDBizException("not found ReportPostman Info!");
        }
        return (AbstractReportPostman)this.deSerializedBytes(postmanSerial);
    }

    protected List<Map<String, Object>> getTabMsgFromPm(AbstractReportPostman postman) {
        ArrayList<Map<String, Object>> tabmsgs = new ArrayList<Map<String, Object>>(postman.getPairs().size());
        Map<Object, DynamicObject> names = this.collectSortNameByIds(postman);
        for (Pair<Object, Object> e : postman.getPairs()) {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("tabKey", postman.getTabKey(e));
            msg.put("tabName", names.get(postman.querySortPrimaryPK(e)).getString("name"));
            AbstractReportPostman newpm = this.getReportPostman();
            newpm.getPairs().clear();
            newpm.addPair(e.p1, e.p2);
            msg.put("postman", this.toByteSerialized(newpm));
            if (this.getReportFrom().equals("bcm_workbenchreport")) {
                msg.put("templateId", LongUtil.toLong((Object)e.p1));
                msg.put("reportId", e.p2);
            }
            tabmsgs.add(msg);
        }
        return tabmsgs;
    }

    protected void initReportTabInfoByPostman() {
        ReportTabManager rtm = this.getReportTabInfoManager();
        for (Map<String, Object> tabMsg : this.getTabMsgFromPm(this.getReportPostman())) {
            ReportTabInfo tri = new ReportTabInfo(tabMsg.get("tabKey").toString(), tabMsg.get("tabName").toString(), tabMsg.get("reportId"), tabMsg.get("templateId"));
            tri.getListRecordInfo().put("postman", tabMsg.get("postman"));
            rtm.addReportTabInfo(tri);
        }
        this.cacheReportTabInfoManager(rtm);
    }

    protected void contructReportTab() {
        TabAp tabap = new TabAp();
        tabap.setKey(REPORT_TAB);
        tabap.setName(new LocaleString(REPORT_TAB));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>(this.getReportTabInfoManager().getTabs().size());
        for (ReportTabInfo tabInfo : this.getReportTabInfoManager().getTabs()) {
            TabPageAp page = new TabPageAp();
            page.setKey(tabInfo.getTabKey());
            page.setName(new LocaleString(tabInfo.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"AbstractMultiReportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata(REPORT_TAB, features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(2);
        closeMap.put("closable", true);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
        if (CollectionUtils.isNotEmpty(keys)) {
            this.activeFirstTab(REPORT_TAB, (String)keys.get(0));
        }
    }

    protected void activeFirstTab(String controlKey, String tabKey) {
        Tab reporttab = (Tab)this.getControl(controlKey);
        reporttab.activeTab(tabKey);
    }

    protected void doCloseTab(String key, boolean isCloseCus) {
        if (StringUtils.isNotEmpty((String)key)) {
            ReportTabManager reportTabManager = this.getReportTabInfoManager();
            reportTabManager.releaseByKey(key);
            if (reportTabManager.getTabCount() == 0) {
                BcmDLockUtil.unLockOpenReport((String)this.getView().getPageId());
                this.closeReportTab(key, true, isCloseCus);
                return;
            }
            this.activeLastTab(reportTabManager, key, isCloseCus);
            this.cacheReportTabInfoManager(reportTabManager);
            this.closeReportTab(key, false, isCloseCus);
        }
    }

    protected void activeLastTab(ReportTabManager reportTabManager, String key, boolean isCloseCus) {
        Tab tab = (Tab)this.getControl(REPORT_TAB);
        String cur = tab.getCurrentTab();
        String lastTabKey = reportTabManager.getLastTabKey(key);
        if (lastTabKey != null && key.equals(cur)) {
            tab.activeTab(lastTabKey);
        }
    }

    protected void closeReportTab(String key, boolean isAll, boolean isCloseCus) {
        if (isAll) {
            this.getView().close();
            return;
        }
        this.getView().executeClientCommand(CMDNAMEKEY, new Object[]{key});
    }

    public ReportTabManager getReportTabInfoManager() {
        if (this.manager != null) {
            return this.manager;
        }
        String serial = this.getPageCache().get(KEY_TAB_MANAGER);
        if (StringUtils.isNotEmpty((String)serial)) {
            this.manager = (ReportTabManager)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        if (this.manager == null) {
            this.manager = new ReportTabManager();
        }
        return this.manager;
    }

    protected void setReportTabManager(ReportTabManager manager) {
        this.manager = manager;
        this.cacheReportTabInfoManager(manager);
    }

    public void cacheReportTabInfoManager(ReportTabManager manager) {
        this.getPageCache().put(KEY_TAB_MANAGER, ObjectSerialUtil.toByteSerialized((Object)manager));
    }

    private Map<Object, DynamicObject> collectSortNameByIds(AbstractReportPostman postman) {
        HashMap<Object, DynamicObject> nameMap = new HashMap<Object, DynamicObject>(16);
        HashSet ids = new HashSet();
        postman.getPairs().forEach(e -> ids.add(postman.querySortPrimaryPK((Pair<Object, Object>)e)));
        if (!ids.isEmpty()) {
            DynamicObject[] templates;
            String tmplSelector = "id,name,number";
            String entitySelector = "id,name,number,isleaf,parent.id,parent.number";
            for (DynamicObject d : templates = BusinessDataServiceHelper.load((String)postman.getFormEntityNumber(), (String)("bcm_entitymembertree".equals(postman.getFormEntityNumber()) ? entitySelector : tmplSelector), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                nameMap.put(d.get("id"), d);
            }
        }
        return nameMap;
    }

    protected boolean checkTabIsChange(ReportTabInfo page) {
        IFormView view;
        Object pageid = page.getListRecordInfo().get(PAGEID);
        if (pageid != null && (view = this.getView().getView(pageid.toString())) != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
            return pluginProxy.getPlugIns().stream().anyMatch(e -> {
                if (CslReportProcessPlugin.class.isAssignableFrom(e.getClass())) {
                    return ((CslReportProcessPlugin)e).isModified();
                }
                return false;
            });
        }
        return false;
    }

    private static List<String> getCloseKeysFromArgs(String key) {
        JSONArray keyArray = JSONArray.parseArray((String)key);
        ArrayList<String> closeKeys = new ArrayList<String>();
        for (Object o : keyArray) {
            JSONObject jsonObject = (JSONObject)o;
            String closeKey = jsonObject.getString("id");
            closeKeys.add(closeKey);
        }
        return closeKeys;
    }

    protected boolean batchCheckAndCloseTab(List<String> closeKeys) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        ArrayList<MessageBoxLink> msgLinkList = new ArrayList<MessageBoxLink>();
        for (String closeKey : closeKeys) {
            ReportTabInfo changeTab = this.getReportTabInfoManager().searchTab(closeKey);
            if (changeTab == null || !this.checkTabIsChange(changeTab)) continue;
            MessageBoxLink msgLink = new MessageBoxLink();
            msgLink.setText(changeTab.getTabName());
            msgLink.setValue(changeTab.getTabKey());
            msgLinkList.add(msgLink);
            sb.append("#{").append(i++).append("} ");
        }
        if (msgLinkList.isEmpty()) {
            for (String closeKey : closeKeys) {
                this.doCloseTab(closeKey, false);
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u7b49\u62a5\u8868\u5df2\u4fee\u6539\u672a\u4fdd\u5b58\uff0c\u8d85\u94fe\u63a5\u53ef\u8df3\u8f6c\u81f3\u5bf9\u5e94\u62a5\u8868\u3002\u662f\u5426\u76f4\u63a5\u5173\u95ed\uff1f", (String)"SwitchUnRefreshReportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(sb.toString(), msgLinkList, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("jumpPage", (IFormPlugin)this));
            return false;
        }
        this.closeAllCustomTab(closeKeys);
        return true;
    }

    protected void closeAllCustomTab(List<String> closeKeys) {
    }

    protected List<String> getAllTabKeys() {
        ArrayList<String> closeKeys = new ArrayList<String>(this.getReportTabInfoManager().getTabs().size());
        for (ReportTabInfo page : this.getReportTabInfoManager().getTabs()) {
            closeKeys.add(page.getTabKey());
        }
        return closeKeys;
    }
}

