/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.querydata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.reportenum.ReportAreaEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.floatreport.CTMOTService;
import kd.fi.bcm.formplugin.report.querydata.ReportQueryRowResult;
import kd.fi.bcm.formplugin.report.querydata.ReportRowDataQueryParam;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.lang3.StringUtils;

public class ReportDataQueryService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportDataQueryService.class);
    private static final String splitStr = "|";

    public List<ReportQueryRowResult> getReportRowData(ReportRowDataQueryParam param) {
        ArrayList<ReportQueryRowResult> results = new ArrayList<ReportQueryRowResult>(16);
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelNum());
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelNum());
        IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)modelNum, (String)param.getSceneNum());
        IDNumberTreeNode year = MemberReader.findFyMemberByNum((String)modelNum, (String)param.getYear());
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNum, (String)param.getPeriod());
        IDNumberTreeNode currency = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)param.getCurrency());
        if (param.getDim2Mems() == null) {
            param.setDim2Mems(new HashMap<String, String>(16));
        }
        param.getDim2Mems().put(DimTypesEnum.SCENARIO.getNumber(), scene.getNumber());
        param.getDim2Mems().put(DimTypesEnum.YEAR.getNumber(), year.getNumber());
        param.getDim2Mems().put(DimTypesEnum.PERIOD.getNumber(), period.getNumber());
        if (!param.getDim2Mems().containsKey(DimTypesEnum.CURRENCY.getNumber())) {
            param.getDim2Mems().put(DimTypesEnum.CURRENCY.getNumber(), currency.getNumber());
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter tempFilter = new QFilter("number", "in", param.getTmps());
        tempFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection tempDoc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{modelFilter, tempFilter});
        Set tmpIds = tempDoc.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        Map source2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)year.getId(), (Long)period.getId(), tmpIds, (boolean)true);
        QFilter orgFilter = new QFilter("number", "in", param.getOrgs());
        orgFilter.and("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index);
        DynamicObjectCollection orgDoc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, orgFilter});
        List orgIds = orgDoc.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        List orgNodes = MemberReader.getSomeNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)modelNum, orgIds);
        for (IDNumberTreeNode orgNode : orgNodes) {
            for (Long tmpId : source2Right.values()) {
                results.add(ReportDataQueryService.getTemplateData(param, modelId, orgNode, tmpId));
            }
        }
        return results;
    }

    private static ReportQueryRowResult getTemplateData(ReportRowDataQueryParam param, long modelId, IDNumberTreeNode orgNode, Long tmpId) {
        Map<String, String> dim2Mems = param.getDim2Mems();
        dim2Mems.put(DimTypesEnum.ENTITY.getNumber(), orgNode.getNumber());
        Pair<SpreadManager, TemplateModel> sm2TmpModel = CTMOTService.getAndInitSpread(tmpId, dim2Mems);
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelNum());
        CTMOTService.autoFloat(modelNum, modelId, false, orgNode.getId(), orgNode.getNumber(), (SpreadManager)sm2TmpModel.p1, (TemplateModel)sm2TmpModel.p2, param);
        ArrayList<ReportQueryRowResult.PositionRowDataInfo> areaInfos = new ArrayList<ReportQueryRowResult.PositionRowDataInfo>(16);
        ReportQueryRowResult queryResult = new ReportQueryRowResult();
        for (PositionInfo posInfo : ((SpreadManager)sm2TmpModel.p1).getAreaManager().getPostionInfoSet()) {
            ReportQueryRowResult.PositionRowDataInfo extAreaInfo = ReportDataQueryService.buildExtAreaInfo(sm2TmpModel, posInfo);
            if (extAreaInfo != null) {
                areaInfos.add(extAreaInfo);
                continue;
            }
            Map<RangeModel, ReportQueryRowResult.PositionRowDataInfo> range2DataInfo = ReportDataQueryService.buildFloatDataAreaInfo(sm2TmpModel, modelNum, posInfo);
            areaInfos.addAll(range2DataInfo.values());
            ReportQueryRowResult.PositionRowDataInfo cur_DataInfo = ReportDataQueryService.buildFixDataAreaInfo(sm2TmpModel, modelNum, posInfo);
            if (cur_DataInfo == null) continue;
            areaInfos.add(cur_DataInfo);
        }
        queryResult.getPageDims().put(DimTypesEnum.ENTITY.getNumber(), orgNode.getNumber());
        queryResult.getPageDims().put(DimTypesEnum.SCENARIO.getNumber(), param.getSceneNum());
        queryResult.getPageDims().put(DimTypesEnum.YEAR.getNumber(), param.getYear());
        queryResult.getPageDims().put(DimTypesEnum.PERIOD.getNumber(), param.getPeriod());
        queryResult.setPageDims(((SpreadManager)sm2TmpModel.p1).getFilter().getPageFilterDim2MembNums());
        queryResult.setViewDims(((SpreadManager)sm2TmpModel.p1).getFilter().getViewFilterDim2MembNums());
        queryResult.setTempNum(((TemplateModel)sm2TmpModel.p2).getNumber());
        queryResult.setTempName(((TemplateModel)sm2TmpModel.p2).getName());
        queryResult.setAreaInfos(areaInfos);
        return queryResult;
    }

    private static ReportQueryRowResult.PositionRowDataInfo buildFixDataAreaInfo(Pair<SpreadManager, TemplateModel> sm2TmpModel, String modelNum, PositionInfo posInfo) {
        Sheet sheet = ((SpreadManager)sm2TmpModel.p1).getBook().getSheet(0);
        RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
        RowDimDomain rowDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getRowDimDoman(posInfo);
        ArrayList rowDims = rowDimDoman == null ? new ArrayList(16) : rowDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList());
        ColumnDimDomain colDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getColDimDomain(posInfo);
        ArrayList colDims = colDimDoman == null ? new ArrayList(16) : colDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList());
        ReportQueryRowResult.PositionRowDataInfo cur_DataInfo = new ReportQueryRowResult.PositionRowDataInfo();
        cur_DataInfo.setArea(rangeModel.getAreaRangeStr());
        cur_DataInfo.setAreaType(ReportAreaEnum.FIX.getNumber());
        ArrayList floatAreaRowDims = Lists.newArrayList(rowDims);
        floatAreaRowDims.removeAll(cur_DataInfo.getHideDims().keySet());
        cur_DataInfo.setRowDims(floatAreaRowDims);
        ArrayList floatAreaColDims = Lists.newArrayList(colDims);
        floatAreaColDims.removeAll(cur_DataInfo.getHideDims().keySet());
        cur_DataInfo.setColDims(floatAreaColDims);
        ArrayList<List<Object>> dataColFields = new ArrayList<List<Object>>(16);
        cur_DataInfo.setDataColFields(dataColFields);
        for (String rowDim : cur_DataInfo.getRowDims()) {
            dataColFields.add(Lists.newArrayList((Object[])new Object[]{rowDim}));
        }
        for (int i = rangeModel.getX_start(); i <= rangeModel.getX_end(); ++i) {
            Recorder isGetColDim = new Recorder((Object)false);
            sheet.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), i, i, c -> {
                if (((Boolean)isGetColDim.getRecord()).booleanValue()) {
                    return;
                }
                if (c.isMdDataDomain()) {
                    Map<String, String> dim2Membs = c.getNotNullMemberUserObject().stream().collect(Collectors.toMap(k -> k.getDimension().getNumber(), v -> v.getNumber(), (v1, v2) -> v1));
                    ArrayList<String> cols = new ArrayList<String>(cur_DataInfo.getColDims().size());
                    for (String colDim : cur_DataInfo.getColDims()) {
                        cols.add(dim2Membs.get(colDim));
                    }
                    isGetColDim.setRecord((Object)true);
                    dataColFields.add(cols);
                }
            });
        }
        List floatDataRanges = posInfo.getFloatDataArea();
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(16);
        Recorder isSetRowMembs = new Recorder((Object)true);
        boolean isVFloat = 2 == ((SpreadManager)sm2TmpModel.p1).isHorizon();
        Recorder hasFix = new Recorder((Object)false);
        for (int rowIndex = rangeModel.getY_start(); rowIndex <= rangeModel.getY_end(); ++rowIndex) {
            ArrayList rowData = new ArrayList(16);
            sheet.iteratorRangeCells(rowIndex, rowIndex, rangeModel.getX_start(), rangeModel.getX_end(), c -> {
                if (c.isMdDataDomain()) {
                    for (RangeModel model : floatDataRanges) {
                        if (!(isVFloat ? c.getRow() <= model.getY_end() && c.getRow() >= model.getY_start() : c.getCol() <= model.getX_end() && c.getCol() >= model.getX_start())) continue;
                        return;
                    }
                    hasFix.setRecord((Object)true);
                    if (((Boolean)isSetRowMembs.getRecord()).booleanValue()) {
                        isSetRowMembs.setRecord((Object)false);
                        Map<String, IDimMember> dim2Membs = c.getNotNullMemberUserObject().stream().collect(Collectors.toMap(k -> k.getDimension().getNumber(), v -> v, (v1, v2) -> v1));
                        for (String colDim : cur_DataInfo.getRowDims()) {
                            IDimMember member = dim2Membs.get(colDim);
                            if (StringUtils.isEmpty((CharSequence)member.getName())) {
                                String name = MemberReader.findMemberByNumber((String)modelNum, (String)member.getDimension().getNumber(), (String)member.getNumber()).getName();
                                rowData.add(member.getNumber() + splitStr + name);
                                continue;
                            }
                            rowData.add(member.getNumber() + splitStr + member.getName());
                        }
                    }
                    rowData.add(c.getValue());
                }
            });
            datas.add(rowData);
            isSetRowMembs.setRecord((Object)true);
        }
        cur_DataInfo.setAllDatas(datas);
        if (((Boolean)hasFix.getRecord()).booleanValue()) {
            return cur_DataInfo;
        }
        return null;
    }

    private static Map<RangeModel, ReportQueryRowResult.PositionRowDataInfo> buildFloatDataAreaInfo(Pair<SpreadManager, TemplateModel> sm2TmpModel, String modelNum, PositionInfo posInfo) {
        ReportQueryRowResult.PositionRowDataInfo cur_DataInfo;
        RowDimDomain rowDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getRowDimDoman(posInfo);
        ArrayList rowDims = rowDimDoman == null ? new ArrayList(16) : rowDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList());
        ColumnDimDomain colDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getColDimDomain(posInfo);
        ArrayList colDims = colDimDoman == null ? new ArrayList(16) : colDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList());
        LinkedHashMap<RangeModel, ReportQueryRowResult.PositionRowDataInfo> range2DataInfo = new LinkedHashMap<RangeModel, ReportQueryRowResult.PositionRowDataInfo>(16);
        Map floatArea2DataRanges = posInfo.getFloatArea2DataArea();
        for (BasePointInfo basePoint : posInfo.getBasePoints()) {
            cur_DataInfo = range2DataInfo.getOrDefault(floatArea2DataRanges.get(basePoint.getOriginalDynaRange()), new ReportQueryRowResult.PositionRowDataInfo());
            HashMap<String, String> hideDims = new HashMap<String, String>(16);
            for (Object lineInfo : basePoint.getBasePointInnerLineInfo()) {
                if (lineInfo.isFloated()) continue;
                for (DynaMembScopeInfo membScope : lineInfo.getDynaMembScopes()) {
                    IDimMember member = membScope.getMember();
                    if (StringUtils.isEmpty((CharSequence)member.getName())) {
                        String name = MemberReader.findMemberByNumber((String)modelNum, (String)member.getDimension().getNumber(), (String)member.getNumber()).getName();
                        hideDims.put(member.getDimension().getNumber(), member.getNumber() + splitStr + name);
                        continue;
                    }
                    hideDims.put(member.getDimension().getNumber(), member.getNumber() + splitStr + member.getName());
                }
            }
            cur_DataInfo.setHideDims(hideDims);
            range2DataInfo.put((RangeModel)floatArea2DataRanges.get(basePoint.getOriginalDynaRange()), cur_DataInfo);
        }
        for (RangeModel rangeModel : floatArea2DataRanges.values()) {
            cur_DataInfo = range2DataInfo.getOrDefault(rangeModel, new ReportQueryRowResult.PositionRowDataInfo());
            cur_DataInfo.setArea(rangeModel.getAreaRangeStr());
            cur_DataInfo.setAreaType(ReportAreaEnum.FLOAT.getNumber());
            ArrayList floatAreaRowDims = Lists.newArrayList(rowDims);
            floatAreaRowDims.removeAll(cur_DataInfo.getHideDims().keySet());
            cur_DataInfo.setRowDims(floatAreaRowDims);
            ArrayList floatAreaColDims = Lists.newArrayList(colDims);
            floatAreaColDims.removeAll(cur_DataInfo.getHideDims().keySet());
            cur_DataInfo.setColDims(floatAreaColDims);
            range2DataInfo.put(rangeModel, cur_DataInfo);
        }
        Sheet sheet = ((SpreadManager)sm2TmpModel.p1).getBook().getSheet(0);
        for (RangeModel rangeModel : floatArea2DataRanges.values()) {
            ReportQueryRowResult.PositionRowDataInfo cur_DataInfo2 = (ReportQueryRowResult.PositionRowDataInfo)range2DataInfo.get(rangeModel);
            ArrayList<List<Object>> dataColFields = new ArrayList<List<Object>>(16);
            cur_DataInfo2.setDataColFields(dataColFields);
            for (String rowDim : cur_DataInfo2.getRowDims()) {
                dataColFields.add(Lists.newArrayList((Object[])new Object[]{rowDim}));
            }
            for (int i = rangeModel.getX_start(); i <= rangeModel.getX_end(); ++i) {
                Recorder isGetColDim = new Recorder((Object)false);
                sheet.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), i, i, c -> {
                    if (((Boolean)isGetColDim.getRecord()).booleanValue()) {
                        return;
                    }
                    if (c.isMdDataDomain()) {
                        Map<String, String> dim2Membs = c.getNotNullMemberUserObject().stream().collect(Collectors.toMap(k -> k.getDimension().getNumber(), v -> v.getNumber(), (v1, v2) -> v1));
                        ArrayList<String> cols = new ArrayList<String>(cur_DataInfo2.getColDims().size());
                        for (String colDim : cur_DataInfo2.getColDims()) {
                            cols.add(dim2Membs.get(colDim));
                        }
                        isGetColDim.setRecord((Object)true);
                        dataColFields.add(cols);
                    }
                });
            }
            ArrayList<List<Object>> datas = new ArrayList<List<Object>>(16);
            Recorder isSetRowMembs = new Recorder((Object)true);
            for (int rowIndex = rangeModel.getY_start(); rowIndex <= rangeModel.getY_end(); ++rowIndex) {
                ArrayList rowData = new ArrayList(16);
                sheet.iteratorRangeCells(rowIndex, rowIndex, rangeModel.getX_start(), rangeModel.getX_end(), c -> {
                    if (c.isMdDataDomain()) {
                        if (((Boolean)isSetRowMembs.getRecord()).booleanValue()) {
                            isSetRowMembs.setRecord((Object)false);
                            Map<String, IDimMember> dim2Membs = c.getNotNullMemberUserObject().stream().collect(Collectors.toMap(k -> k.getDimension().getNumber(), v -> v, (v1, v2) -> v1));
                            for (String colDim : cur_DataInfo2.getRowDims()) {
                                IDimMember member = dim2Membs.get(colDim);
                                if (StringUtils.isEmpty((CharSequence)member.getName())) {
                                    String name = MemberReader.findMemberByNumber((String)modelNum, (String)member.getDimension().getNumber(), (String)member.getNumber()).getName();
                                    rowData.add(member.getNumber() + splitStr + name);
                                    continue;
                                }
                                rowData.add(member.getNumber() + splitStr + member.getName());
                            }
                        }
                        rowData.add(c.getValue());
                    }
                });
                datas.add(rowData);
                isSetRowMembs.setRecord((Object)true);
            }
            cur_DataInfo2.setAllDatas(datas);
        }
        return range2DataInfo;
    }

    private static ReportQueryRowResult.PositionRowDataInfo buildExtAreaInfo(Pair<SpreadManager, TemplateModel> sm2TmpModel, PositionInfo posInfo) {
        if (posInfo.getExtendInfo() != null) {
            Sheet sheet = ((SpreadManager)sm2TmpModel.p1).getBook().getSheet(0);
            ReportQueryRowResult.PositionRowDataInfo dataInfo = new ReportQueryRowResult.PositionRowDataInfo();
            ArrayList<List<Object>> datas = new ArrayList<List<Object>>(16);
            dataInfo.setArea(posInfo.getAreaRange());
            dataInfo.setDataColFields(ReportDataQueryService.getDataColFields(posInfo));
            dataInfo.setAreaType(ReportAreaEnum.EXTEND.getNumber());
            dataInfo.setExtModel(posInfo.getExtendInfo().getExtModelNumber());
            Map index2DimNums = ((SpreadManager)sm2TmpModel.p1).getExtFloatDimInfo(posInfo);
            RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
            for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
                ArrayList<Object> data = new ArrayList<Object>(16);
                List row = sheet.getRow(i, true);
                for (Cell cell : row) {
                    if (cell.getCol() > rangeModel.getX_end() || cell.getCol() < rangeModel.getX_start()) continue;
                    if (index2DimNums.containsKey(cell.getCol())) {
                        for (IDimMember dimMember : cell.getNotNullMemberUserObject()) {
                            data.add(dimMember.getNumber() + splitStr + dimMember.getName());
                        }
                        continue;
                    }
                    data.add(cell.getValue());
                }
                datas.add(data);
            }
            dataInfo.setAllDatas(datas);
            return dataInfo;
        }
        return null;
    }

    private static List<List<Object>> getDataColFields(PositionInfo posInfo) {
        List cols = posInfo.getExtendInfo().getCols(true);
        ArrayList<List<Object>> dataColFields = new ArrayList<List<Object>>(16);
        for (String col : cols) {
            dataColFields.add(Lists.newArrayList((Object[])new Object[]{col}));
        }
        return dataColFields;
    }

    public void testAPIOperation() {
        ReportDataQueryService controller = new ReportDataQueryService();
        ReportRowDataQueryParam param = new ReportRowDataQueryParam();
        param.setModelNum("LOK_2023");
        param.setSceneNum("MRpt");
        param.setYear("FY2022");
        param.setPeriod("M_M05");
        param.setCurrency("DC");
        param.setOrgs(Lists.newArrayList((Object[])new String[]{"BCM2022"}));
        param.setTmps(Lists.newArrayList((Object[])new String[]{"COL_FLOAT"}));
        HashMap<String, String> dim2Mems = new HashMap<String, String>(16);
        dim2Mems.put(DimTypesEnum.PROCESS.getNumber(), "ERpt");
        dim2Mems.put(DimTypesEnum.AUDITTRIAL.getNumber(), "EntityInput");
        dim2Mems.put(DimTypesEnum.MULTIGAAP.getNumber(), "PRCGAAP");
        dim2Mems.put("ZDY1", "Z1None");
        param.setDim2Mems(dim2Mems);
        List<ReportQueryRowResult> results = controller.getReportRowData(param);
    }
}

